//
// Copyright 2009-2010 Fess Project
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//    http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

#import "AppDelegate.h"
#import "TabBarController.h"
#import "SearchViewController.h"
#import "ConfigController.h"
#import "CommonTextViewController.h"
#import "ConfigServerController.h"

@implementation AppDelegate

///////////////////////////////////////////////////////////////////////////////////////////////////
// UIApplicationDelegate

- (void)applicationDidFinishLaunching:(UIApplication*)application {
	TTNavigator* navigator = [TTNavigator navigator];
	navigator.persistenceMode = TTNavigatorPersistenceModeAll;
	navigator.window = [[[UIWindow alloc] initWithFrame:TTScreenBounds()] autorelease];
	
	TTURLMap* map = navigator.URLMap;

	// Default Controller
	[map from:@"*" toViewController:[ConfigController class]];

	// Tab
	[map from:@"tt://tabBar" toSharedViewController:[TabBarController class]];

	// Search
	[map from:@"tt://search" toSharedViewController:[SearchViewController class]];

	// Config
	[map from:@"tt://config" toSharedViewController:[ConfigController class]];

	// Config Server
	[map from:@"tt://config/setting/server" toSharedViewController:[ConfigServerController class]];

	// Common Text Viewer
	[map from:@"tt://common/text/(initWithTitle:)/(fileName:)" toViewController:[CommonTextViewController class]];	


	// Before opening the tab bar, we see if the controller history was persisted the last time
	if (![navigator restoreViewControllers]) {
		// This is the first launch, so we just start with the tab bar
		[navigator openURLAction:[TTURLAction actionWithURLPath:@"tt://tabBar"]];
	}
}

///////////////////////////////////////////////////////////////////////////////////////////////////
- (BOOL)navigator:(TTNavigator*)navigator shouldOpenURL:(NSURL*)URL {
	return YES;
}


///////////////////////////////////////////////////////////////////////////////////////////////////
- (BOOL)application:(UIApplication*)application handleOpenURL:(NSURL*)URL {
	[[TTNavigator navigator] openURLAction:[TTURLAction actionWithURLPath:URL.absoluteString]];
	return YES;
}


@end