<%@page pageEncoding="UTF-8" contentType="text/html; charset=UTF-8"%>
<!-- query matched some document -->
<div id="subheader" class="row">
	<div class="span16">
		<p>
			<bean:message key="labels.search_result_status"
				arg0="${f:h(displayQuery)}" arg1="${f:h(allRecordCount)}"
				arg2="${f:h(currentStartRecordNumber)}"
				arg3="${f:h(currentEndRecordNumber)}" />
			<c:if test="${execTime!=null}">
				<bean:message key="labels.search_result_time"
					arg0="${f:h(execTime)}" />
			</c:if>
		</p>
	</div>
</div>
<c:if test="${partialResults}">
<div class="alert-message warning">
	<p><bean:message key="errors.process_time_is_exceeded"/></p>
</div>
</c:if>
<div id="result" class="row">
	<input type="hidden" id="rt" value="${f:u(rt)}" />
	<div class="span12">
		<ol>
			<c:forEach var="doc" varStatus="s" items="${documentItems}">
				<li>
					<h3 class="title">
						<a href="${doc.urlLink}"> ${f:h(doc.contentTitle)} </a>
					</h3>
					<div class="body">
						${doc.contentDescription}<br /> 
						<cite>${f:h(doc.site)}</cite><br/>
						<logic:empty name="doc.tstamp">
							<bean:message key="labels.search_result_tstamp"/>
							<fmt:formatDate value="${fe:date(doc.tstamp)}" type="BOTH"/>
						</logic:empty>
						-
						<logic:empty name="doc.lastModified">
							<bean:message key="labels.search_result_lastModified"/>
							<fmt:formatDate value="${fe:date(doc.lastModified)}" type="BOTH"/>
						</logic:empty>
						-
						<logic:empty name="doc.contentLength">
							<bean:message key="labels.search_result_size" arg0="${f:h(doc.contentLength)}"/>
						</logic:empty>
					</div>
				</li>
			</c:forEach>
		</ol>
	</div>
	<div class="span4">
		<!-- Side Content -->
	</div>
</div>
<div class="row center">
	<div id="subfooter" class="pagination">
		<ul>
			<c:if test="${existPrevPage}">
				<li class="prev"><s:link
						href="prev?query=${f:u(query)}&pn=${f:u(currentPageNumber)}&num=${f:u(pageSize)}${pagingQuery}">
						<bean:message key="labels.prev_page" />
					</s:link></li>
			</c:if>
			<c:if test="${!existPrevPage}">
				<li class="prev disabled"><a href="#"><bean:message
							key="labels.prev_page" /></a></li>
			</c:if>
			<c:forEach var="pageNumber" varStatus="s" items="${pageNumberList}">
				<li
					<c:if test="${pageNumber == currentPageNumber}">class="active"</c:if>>
					<s:link
						href="move?query=${f:u(query)}&pn=${f:u(pageNumber)}&num=${f:u(pageSize)}${pagingQuery}">${f:h(pageNumber)}</s:link>
				</li>
			</c:forEach>
			<c:if test="${existNextPage}">
				<li class="next"><s:link
						href="next?query=${f:u(query)}&pn=${f:u(currentPageNumber)}&num=${f:u(pageSize)}${pagingQuery}">
						<bean:message key="labels.next_page" />
					</s:link></li>
			</c:if>
			<c:if test="${!existNextPage}">
				<li class="next disabled"><a href="#"><bean:message
							key="labels.next_page" /></a></li>
			</c:if>
		</ul>
	</div>
</div>
