/*
 * Copyright 2009-2010 the Fess Project and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */

package jp.sf.fess.db.bsbhv;

import java.util.List;

import jp.sf.fess.db.bsentity.dbmeta.FileConfigToBrowserTypeMappingDbm;
import jp.sf.fess.db.cbean.FileConfigToBrowserTypeMappingCB;
import jp.sf.fess.db.exentity.BrowserType;
import jp.sf.fess.db.exentity.FileConfigToBrowserTypeMapping;
import jp.sf.fess.db.exentity.FileCrawlingConfig;

import org.seasar.dbflute.Entity;
import org.seasar.dbflute.bhv.AbstractBehaviorWritable;
import org.seasar.dbflute.bhv.UpdateOption;
import org.seasar.dbflute.cbean.ConditionBean;
import org.seasar.dbflute.cbean.EntityRowHandler;
import org.seasar.dbflute.cbean.ListResultBean;
import org.seasar.dbflute.cbean.PagingResultBean;
import org.seasar.dbflute.dbmeta.DBMeta;

/**
 * The behavior of FILE_CONFIG_TO_BROWSER_TYPE_MAPPING as TABLE. <br />
 * <pre>
 * [primary-key]
 *     ID
 * 
 * [column]
 *     ID, FILE_CONFIG_ID, BROWSER_TYPE_ID
 * 
 * [sequence]
 *     
 * 
 * [identity]
 *     ID
 * 
 * [version-no]
 *     
 * 
 * [foreign-table]
 *     BROWSER_TYPE, FILE_CRAWLING_CONFIG
 * 
 * [referrer-table]
 *     
 * 
 * [foreign-property]
 *     browserType, fileCrawlingConfig
 * 
 * [referrer-property]
 *     
 * </pre>
 * @author DBFlute(AutoGenerator)
 */
public abstract class BsFileConfigToBrowserTypeMappingBhv extends
        AbstractBehaviorWritable {

    // ===================================================================================
    //                                                                          Definition
    //                                                                          ==========
    /*df:BehaviorQueryPathBegin*/
    /*df:BehaviorQueryPathEnd*/

    // ===================================================================================
    //                                                                          Table name
    //                                                                          ==========
    /** @return The name on database of table. (NotNull) */
    public String getTableDbName() {
        return "FILE_CONFIG_TO_BROWSER_TYPE_MAPPING";
    }

    // ===================================================================================
    //                                                                              DBMeta
    //                                                                              ======
    /** @return The instance of DBMeta. (NotNull) */
    public DBMeta getDBMeta() {
        return FileConfigToBrowserTypeMappingDbm.getInstance();
    }

    /** @return The instance of DBMeta as my table type. (NotNull) */
    public FileConfigToBrowserTypeMappingDbm getMyDBMeta() {
        return FileConfigToBrowserTypeMappingDbm.getInstance();
    }

    // ===================================================================================
    //                                                                        New Instance
    //                                                                        ============
    /** {@inheritDoc} */
    public Entity newEntity() {
        return newMyEntity();
    }

    /** {@inheritDoc} */
    public ConditionBean newConditionBean() {
        return newMyConditionBean();
    }

    /** @return The instance of new entity as my table type. (NotNull) */
    public FileConfigToBrowserTypeMapping newMyEntity() {
        return new FileConfigToBrowserTypeMapping();
    }

    /** @return The instance of new condition-bean as my table type. (NotNull) */
    public FileConfigToBrowserTypeMappingCB newMyConditionBean() {
        return new FileConfigToBrowserTypeMappingCB();
    }

    // ===================================================================================
    //                                                                        Count Select
    //                                                                        ============
    /**
     * Select the count by the condition-bean. {IgnorePagingCondition}
     * <pre>
     * FileConfigToBrowserTypeMappingCB cb = new FileConfigToBrowserTypeMappingCB();
     * cb.query().setFoo...(value);
     * int count = fileConfigToBrowserTypeMappingBhv.<span style="color: #FD4747">selectCount</span>(cb);
     * </pre>
     * @param cb The condition-bean of FileConfigToBrowserTypeMapping. (NotNull)
     * @return The selected count.
     */
    public int selectCount(FileConfigToBrowserTypeMappingCB cb) {
        return doSelectCount(cb);
    }

    protected int doSelectCount(FileConfigToBrowserTypeMappingCB cb) {
        assertCBNotNull(cb);
        return delegateSelectCount(cb);
    }

    @Override
    protected int doReadCount(ConditionBean cb) {
        return selectCount(downcast(cb));
    }

    // ===================================================================================
    //                                                                       Cursor Select
    //                                                                       =============
    /**
     * Select the cursor by the condition-bean.
     * <pre>
     * FileConfigToBrowserTypeMappingCB cb = new FileConfigToBrowserTypeMappingCB();
     * cb.query().setFoo...(value);
     * fileConfigToBrowserTypeMappingBhv.<span style="color: #FD4747">selectCursor</span>(cb, new EntityRowHandler&lt;FileConfigToBrowserTypeMapping&gt;() {
     *     public void handle(FileConfigToBrowserTypeMapping entity) {
     *         ... = entity.getFoo...();
     *     }
     * });
     * </pre>
     * @param cb The condition-bean of FileConfigToBrowserTypeMapping. (NotNull)
     * @param entityRowHandler The handler of entity row of FileConfigToBrowserTypeMapping. (NotNull)
     */
    public void selectCursor(FileConfigToBrowserTypeMappingCB cb,
            EntityRowHandler<FileConfigToBrowserTypeMapping> entityRowHandler) {
        doSelectCursor(cb, entityRowHandler,
                FileConfigToBrowserTypeMapping.class);
    }

    protected <ENTITY extends FileConfigToBrowserTypeMapping> void doSelectCursor(
            FileConfigToBrowserTypeMappingCB cb,
            EntityRowHandler<ENTITY> entityRowHandler, Class<ENTITY> entityType) {
        assertCBNotNull(cb);
        assertObjectNotNull("entityRowHandler<FileConfigToBrowserTypeMapping>",
                entityRowHandler);
        assertObjectNotNull("entityType", entityType);
        assertSpecifyDerivedReferrerEntityProperty(cb, entityType);
        delegateSelectCursor(cb, entityRowHandler, entityType);
    }

    // ===================================================================================
    //                                                                       Entity Select
    //                                                                       =============
    /**
     * Select the entity by the condition-bean.
     * <pre>
     * FileConfigToBrowserTypeMappingCB cb = new FileConfigToBrowserTypeMappingCB();
     * cb.query().setFoo...(value);
     * FileConfigToBrowserTypeMapping fileConfigToBrowserTypeMapping = fileConfigToBrowserTypeMappingBhv.<span style="color: #FD4747">selectEntity</span>(cb);
     * if (fileConfigToBrowserTypeMapping != null) {
     *     ... = fileConfigToBrowserTypeMapping.get...();
     * } else {
     *     ...
     * }
     * </pre>
     * @param cb The condition-bean of FileConfigToBrowserTypeMapping. (NotNull)
     * @return The selected entity. (Nullable: If the condition has no data, it returns null)
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.SelectEntityConditionNotFoundException When the condition for selecting an entity is not found.
     */
    public FileConfigToBrowserTypeMapping selectEntity(
            FileConfigToBrowserTypeMappingCB cb) {
        return doSelectEntity(cb, FileConfigToBrowserTypeMapping.class);
    }

    protected <ENTITY extends FileConfigToBrowserTypeMapping> ENTITY doSelectEntity(
            final FileConfigToBrowserTypeMappingCB cb,
            final Class<ENTITY> entityType) {
        return helpSelectEntityInternally(
                cb,
                new InternalSelectEntityCallback<ENTITY, FileConfigToBrowserTypeMappingCB>() {
                    public List<ENTITY> callbackSelectList(
                            FileConfigToBrowserTypeMappingCB cb) {
                        return doSelectList(cb, entityType);
                    }
                });
    }

    @Override
    protected Entity doReadEntity(ConditionBean cb) {
        return selectEntity(downcast(cb));
    }

    /**
     * Select the entity by the condition-bean with deleted check.
     * <pre>
     * FileConfigToBrowserTypeMappingCB cb = new FileConfigToBrowserTypeMappingCB();
     * cb.query().setFoo...(value);
     * FileConfigToBrowserTypeMapping fileConfigToBrowserTypeMapping = fileConfigToBrowserTypeMappingBhv.<span style="color: #FD4747">selectEntityWithDeletedCheck</span>(cb);
     * ... = fileConfigToBrowserTypeMapping.get...(); <span style="color: #3F7E5E">// the entity always be not null</span>
     * </pre>
     * @param cb The condition-bean of FileConfigToBrowserTypeMapping. (NotNull)
     * @return The selected entity. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.SelectEntityConditionNotFoundException When the condition for selecting an entity is not found.
     */
    public FileConfigToBrowserTypeMapping selectEntityWithDeletedCheck(
            FileConfigToBrowserTypeMappingCB cb) {
        return doSelectEntityWithDeletedCheck(cb,
                FileConfigToBrowserTypeMapping.class);
    }

    protected <ENTITY extends FileConfigToBrowserTypeMapping> ENTITY doSelectEntityWithDeletedCheck(
            final FileConfigToBrowserTypeMappingCB cb,
            final Class<ENTITY> entityType) {
        return helpSelectEntityWithDeletedCheckInternally(
                cb,
                new InternalSelectEntityWithDeletedCheckCallback<ENTITY, FileConfigToBrowserTypeMappingCB>() {
                    public List<ENTITY> callbackSelectList(
                            FileConfigToBrowserTypeMappingCB cb) {
                        return doSelectList(cb, entityType);
                    }
                });
    }

    @Override
    protected Entity doReadEntityWithDeletedCheck(ConditionBean cb) {
        return selectEntityWithDeletedCheck(downcast(cb));
    }

    /**
     * Select the entity by the primary-key value.
     * @param id The one of primary key. (NotNull)
     * @return The selected entity. (Nullable: If the primary-key value has no data, it returns null)
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.SelectEntityConditionNotFoundException When the condition for selecting an entity is not found.
     */
    public FileConfigToBrowserTypeMapping selectByPKValue(Long id) {
        return doSelectByPKValue(id, FileConfigToBrowserTypeMapping.class);
    }

    protected <ENTITY extends FileConfigToBrowserTypeMapping> ENTITY doSelectByPKValue(
            Long id, Class<ENTITY> entityType) {
        return doSelectEntity(buildPKCB(id), entityType);
    }

    /**
     * Select the entity by the primary-key value with deleted check.
     * @param id The one of primary key. (NotNull)
     * @return The selected entity. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.SelectEntityConditionNotFoundException When the condition for selecting an entity is not found.
     */
    public FileConfigToBrowserTypeMapping selectByPKValueWithDeletedCheck(
            Long id) {
        return doSelectByPKValueWithDeletedCheck(id,
                FileConfigToBrowserTypeMapping.class);
    }

    protected <ENTITY extends FileConfigToBrowserTypeMapping> ENTITY doSelectByPKValueWithDeletedCheck(
            Long id, Class<ENTITY> entityType) {
        return doSelectEntityWithDeletedCheck(buildPKCB(id), entityType);
    }

    private FileConfigToBrowserTypeMappingCB buildPKCB(Long id) {
        assertObjectNotNull("id", id);
        FileConfigToBrowserTypeMappingCB cb = newMyConditionBean();
        cb.query().setId_Equal(id);
        return cb;
    }

    // ===================================================================================
    //                                                                         List Select
    //                                                                         ===========
    /**
     * Select the list as result bean.
     * <pre>
     * FileConfigToBrowserTypeMappingCB cb = new FileConfigToBrowserTypeMappingCB();
     * cb.query().setFoo...(value);
     * cb.query().addOrderBy_Bar...();
     * ListResultBean&lt;FileConfigToBrowserTypeMapping&gt; fileConfigToBrowserTypeMappingList = fileConfigToBrowserTypeMappingBhv.<span style="color: #FD4747">selectList</span>(cb);
     * for (FileConfigToBrowserTypeMapping fileConfigToBrowserTypeMapping : fileConfigToBrowserTypeMappingList) {
     *     ... = fileConfigToBrowserTypeMapping.get...();
     * }
     * </pre>
     * @param cb The condition-bean of FileConfigToBrowserTypeMapping. (NotNull)
     * @return The result bean of selected list. (NotNull)
     * @exception org.seasar.dbflute.exception.DangerousResultSizeException When the result size is over the specified safety size.
     */
    public ListResultBean<FileConfigToBrowserTypeMapping> selectList(
            FileConfigToBrowserTypeMappingCB cb) {
        return doSelectList(cb, FileConfigToBrowserTypeMapping.class);
    }

    protected <ENTITY extends FileConfigToBrowserTypeMapping> ListResultBean<ENTITY> doSelectList(
            FileConfigToBrowserTypeMappingCB cb, Class<ENTITY> entityType) {
        assertCBNotNull(cb);
        assertObjectNotNull("entityType", entityType);
        assertSpecifyDerivedReferrerEntityProperty(cb, entityType);
        return helpSelectListInternally(
                cb,
                entityType,
                new InternalSelectListCallback<ENTITY, FileConfigToBrowserTypeMappingCB>() {
                    public List<ENTITY> callbackSelectList(
                            FileConfigToBrowserTypeMappingCB cb,
                            Class<ENTITY> entityType) {
                        return delegateSelectList(cb, entityType);
                    }
                });
    }

    @Override
    protected ListResultBean<? extends Entity> doReadList(ConditionBean cb) {
        return selectList(downcast(cb));
    }

    // ===================================================================================
    //                                                                         Page Select
    //                                                                         ===========
    /**
     * Select the page as result bean. <br />
     * (both count-select and paging-select are executed)
     * <pre>
     * FileConfigToBrowserTypeMappingCB cb = new FileConfigToBrowserTypeMappingCB();
     * cb.query().setFoo...(value);
     * cb.query().addOrderBy_Bar...();
     * cb.<span style="color: #FD4747">paging</span>(20, 3); <span style="color: #3F7E5E">// 20 records per a page and current page number is 3</span>
     * PagingResultBean&lt;FileConfigToBrowserTypeMapping&gt; page = fileConfigToBrowserTypeMappingBhv.<span style="color: #FD4747">selectPage</span>(cb);
     * int allRecordCount = page.getAllRecordCount();
     * int allPageCount = page.getAllPageCount();
     * boolean isExistPrePage = page.isExistPrePage();
     * boolean isExistNextPage = page.isExistNextPage();
     * ...
     * for (FileConfigToBrowserTypeMapping fileConfigToBrowserTypeMapping : page) {
     *     ... = fileConfigToBrowserTypeMapping.get...();
     * }
     * </pre>
     * @param cb The condition-bean of FileConfigToBrowserTypeMapping. (NotNull)
     * @return The result bean of selected page. (NotNull)
     * @exception org.seasar.dbflute.exception.DangerousResultSizeException When the result size is over the specified safety size.
     */
    public PagingResultBean<FileConfigToBrowserTypeMapping> selectPage(
            FileConfigToBrowserTypeMappingCB cb) {
        return doSelectPage(cb, FileConfigToBrowserTypeMapping.class);
    }

    protected <ENTITY extends FileConfigToBrowserTypeMapping> PagingResultBean<ENTITY> doSelectPage(
            FileConfigToBrowserTypeMappingCB cb, Class<ENTITY> entityType) {
        assertCBNotNull(cb);
        assertObjectNotNull("entityType", entityType);
        return helpSelectPageInternally(
                cb,
                entityType,
                new InternalSelectPageCallback<ENTITY, FileConfigToBrowserTypeMappingCB>() {
                    public int callbackSelectCount(
                            FileConfigToBrowserTypeMappingCB cb) {
                        return doSelectCount(cb);
                    }

                    public List<ENTITY> callbackSelectList(
                            FileConfigToBrowserTypeMappingCB cb,
                            Class<ENTITY> entityType) {
                        return doSelectList(cb, entityType);
                    }
                });
    }

    @Override
    protected PagingResultBean<? extends Entity> doReadPage(ConditionBean cb) {
        return selectPage(downcast(cb));
    }

    // ===================================================================================
    //                                                                       Scalar Select
    //                                                                       =============
    /**
     * Select the scalar value derived by a function. <br />
     * You should call a function method after this method called like as follows:
     * <pre>
     * fileConfigToBrowserTypeMappingBhv.<span style="color: #FD4747">scalarSelect</span>(Date.class).max(new ScalarQuery() {
     *     public void query(FileConfigToBrowserTypeMappingCB cb) {
     *         cb.specify().<span style="color: #FD4747">columnFooDatetime()</span>; <span style="color: #3F7E5E">// required for a function</span>
     *         cb.query().setBarName_PrefixSearch("S");
     *     }
     * });
     * </pre>
     * @param <RESULT> The type of result.
     * @param resultType The type of result. (NotNull)
     * @return The scalar value derived by a function. (Nullable)
     */
    public <RESULT> SLFunction<FileConfigToBrowserTypeMappingCB, RESULT> scalarSelect(
            Class<RESULT> resultType) {
        return doScalarSelect(resultType, newMyConditionBean());
    }

    protected <RESULT, CB extends FileConfigToBrowserTypeMappingCB> SLFunction<CB, RESULT> doScalarSelect(
            Class<RESULT> resultType, CB cb) {
        assertObjectNotNull("resultType", resultType);
        assertCBNotNull(cb);
        cb.xsetupForScalarSelect();
        cb.getSqlClause().disableSelectIndex(); // for when you use union
        return new SLFunction<CB, RESULT>(cb, resultType);
    }

    // ===================================================================================
    //                                                                            Sequence
    //                                                                            ========
    @Override
    protected Number doReadNextVal() {
        String msg = "This table is NOT related to sequence: "
                + getTableDbName();
        throw new UnsupportedOperationException(msg);
    }

    // ===================================================================================
    //                                                                    Pull out Foreign
    //                                                                    ================
    /**
     * Pull out the list of foreign table 'BrowserType'.
     * @param fileConfigToBrowserTypeMappingList The list of fileConfigToBrowserTypeMapping. (NotNull)
     * @return The list of foreign table. (NotNull)
     */
    public List<BrowserType> pulloutBrowserType(
            List<FileConfigToBrowserTypeMapping> fileConfigToBrowserTypeMappingList) {
        return helpPulloutInternally(
                fileConfigToBrowserTypeMappingList,
                new InternalPulloutCallback<FileConfigToBrowserTypeMapping, BrowserType>() {
                    public BrowserType getFr(FileConfigToBrowserTypeMapping e) {
                        return e.getBrowserType();
                    }

                    public boolean hasRf() {
                        return true;
                    }

                    public void setRfLs(BrowserType e,
                            List<FileConfigToBrowserTypeMapping> ls) {
                        e.setFileConfigToBrowserTypeMappingList(ls);
                    }
                });
    }

    /**
     * Pull out the list of foreign table 'FileCrawlingConfig'.
     * @param fileConfigToBrowserTypeMappingList The list of fileConfigToBrowserTypeMapping. (NotNull)
     * @return The list of foreign table. (NotNull)
     */
    public List<FileCrawlingConfig> pulloutFileCrawlingConfig(
            List<FileConfigToBrowserTypeMapping> fileConfigToBrowserTypeMappingList) {
        return helpPulloutInternally(
                fileConfigToBrowserTypeMappingList,
                new InternalPulloutCallback<FileConfigToBrowserTypeMapping, FileCrawlingConfig>() {
                    public FileCrawlingConfig getFr(
                            FileConfigToBrowserTypeMapping e) {
                        return e.getFileCrawlingConfig();
                    }

                    public boolean hasRf() {
                        return true;
                    }

                    public void setRfLs(FileCrawlingConfig e,
                            List<FileConfigToBrowserTypeMapping> ls) {
                        e.setFileConfigToBrowserTypeMappingList(ls);
                    }
                });
    }

    // ===================================================================================
    //                                                                       Entity Update
    //                                                                       =============
    /**
     * Insert the entity.
     * <pre>
     * FileConfigToBrowserTypeMapping fileConfigToBrowserTypeMapping = new FileConfigToBrowserTypeMapping();
     * <span style="color: #3F7E5E">// if auto-increment, you don't need to set the PK value</span>
     * fileConfigToBrowserTypeMapping.setFoo...(value);
     * fileConfigToBrowserTypeMapping.setBar...(value);
     * fileConfigToBrowserTypeMappingBhv.<span style="color: #FD4747">insert</span>(fileConfigToBrowserTypeMapping);
     * ... = fileConfigToBrowserTypeMapping.getPK...(); <span style="color: #3F7E5E">// if auto-increment, you can get the value after</span>
     * </pre>
     * @param fileConfigToBrowserTypeMapping The entity of insert target. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void insert(
            FileConfigToBrowserTypeMapping fileConfigToBrowserTypeMapping) {
        assertEntityNotNull(fileConfigToBrowserTypeMapping);
        delegateInsert(fileConfigToBrowserTypeMapping);
    }

    @Override
    protected void doCreate(Entity entity) {
        insert(downcast(entity));
    }

    /**
     * Update the entity modified-only. {UpdateCountZeroException, ExclusiveControl}
     * <pre>
     * FileConfigToBrowserTypeMapping fileConfigToBrowserTypeMapping = new FileConfigToBrowserTypeMapping();
     * fileConfigToBrowserTypeMapping.setPK...(value); <span style="color: #3F7E5E">// required</span>
     * fileConfigToBrowserTypeMapping.setFoo...(value); <span style="color: #3F7E5E">// you should set only modified columns</span>
     * <span style="color: #3F7E5E">// if exclusive control, the value of exclusive control column is required</span>
     * fileConfigToBrowserTypeMapping.<span style="color: #FD4747">setVersionNo</span>(value);
     * try {
     *     fileConfigToBrowserTypeMappingBhv.<span style="color: #FD4747">update</span>(fileConfigToBrowserTypeMapping);
     * } catch (EntityAlreadyUpdatedException e) { <span style="color: #3F7E5E">// if concurrent update</span>
     *     ...
     * } 
     * </pre>
     * @param fileConfigToBrowserTypeMapping The entity of update target. (NotNull) {PrimaryKeyRequired, ConcurrencyColumnRequired}
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void update(
            final FileConfigToBrowserTypeMapping fileConfigToBrowserTypeMapping) {
        helpUpdateInternally(fileConfigToBrowserTypeMapping,
                new InternalUpdateCallback<FileConfigToBrowserTypeMapping>() {
                    public int callbackDelegateUpdate(
                            FileConfigToBrowserTypeMapping entity) {
                        return delegateUpdate(entity);
                    }
                });
    }

    @Override
    protected void doModify(Entity entity) {
        update(downcast(entity));
    }

    @Override
    protected void doModifyNonstrict(Entity entity) {
        update(downcast(entity));
    }

    /**
     * Insert or update the entity modified-only. {ExclusiveControl(when update)}
     * @param fileConfigToBrowserTypeMapping The entity of insert or update target. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void insertOrUpdate(
            final FileConfigToBrowserTypeMapping fileConfigToBrowserTypeMapping) {
        helpInsertOrUpdateInternally(
                fileConfigToBrowserTypeMapping,
                new InternalInsertOrUpdateCallback<FileConfigToBrowserTypeMapping, FileConfigToBrowserTypeMappingCB>() {
                    public void callbackInsert(
                            FileConfigToBrowserTypeMapping entity) {
                        insert(entity);
                    }

                    public void callbackUpdate(
                            FileConfigToBrowserTypeMapping entity) {
                        update(entity);
                    }

                    public FileConfigToBrowserTypeMappingCB callbackNewMyConditionBean() {
                        return newMyConditionBean();
                    }

                    public int callbackSelectCount(
                            FileConfigToBrowserTypeMappingCB cb) {
                        return selectCount(cb);
                    }
                });
    }

    @Override
    protected void doCreateOrUpdate(Entity entity) {
        insertOrUpdate(downcast(entity));
    }

    @Override
    protected void doCreateOrUpdateNonstrict(Entity entity) {
        insertOrUpdate(downcast(entity));
    }

    /**
     * Delete the entity. {UpdateCountZeroException, ExclusiveControl}
     * <pre>
     * FileConfigToBrowserTypeMapping fileConfigToBrowserTypeMapping = new FileConfigToBrowserTypeMapping();
     * fileConfigToBrowserTypeMapping.setPK...(value); <span style="color: #3F7E5E">// required</span>
     * <span style="color: #3F7E5E">// if exclusive control, the value of exclusive control column is required</span>
     * fileConfigToBrowserTypeMapping.<span style="color: #FD4747">setVersionNo</span>(value);
     * try {
     *     fileConfigToBrowserTypeMappingBhv.<span style="color: #FD4747">delete</span>(fileConfigToBrowserTypeMapping);
     * } catch (EntityAlreadyUpdatedException e) { <span style="color: #3F7E5E">// if concurrent update</span>
     *     ...
     * } 
     * </pre>
     * @param fileConfigToBrowserTypeMapping The entity of delete target. (NotNull) {PrimaryKeyRequired, ConcurrencyColumnRequired}
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     */
    public void delete(
            FileConfigToBrowserTypeMapping fileConfigToBrowserTypeMapping) {
        helpDeleteInternally(fileConfigToBrowserTypeMapping,
                new InternalDeleteCallback<FileConfigToBrowserTypeMapping>() {
                    public int callbackDelegateDelete(
                            FileConfigToBrowserTypeMapping entity) {
                        return delegateDelete(entity);
                    }
                });
    }

    @Override
    protected void doRemove(Entity entity) {
        delete(downcast(entity));
    }

    // ===================================================================================
    //                                                                        Batch Update
    //                                                                        ============
    /**
     * Batch-insert the list. This method uses 'Batch Update' of java.sql.PreparedStatement.
     * @param fileConfigToBrowserTypeMappingList The list of the entity. (NotNull)
     * @return The array of inserted count.
     */
    public int[] batchInsert(
            List<FileConfigToBrowserTypeMapping> fileConfigToBrowserTypeMappingList) {
        assertObjectNotNull("fileConfigToBrowserTypeMappingList",
                fileConfigToBrowserTypeMappingList);
        return delegateInsertList(fileConfigToBrowserTypeMappingList);
    }

    /**
     * Batch-update the list. <br />
     * All columns are update target. {NOT modified only} <br />
     * This method uses 'Batch Update' of java.sql.PreparedStatement.
     * @param fileConfigToBrowserTypeMappingList The list of the entity. (NotNull)
     * @return The array of updated count.
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     */
    public int[] batchUpdate(
            List<FileConfigToBrowserTypeMapping> fileConfigToBrowserTypeMappingList) {
        assertObjectNotNull("fileConfigToBrowserTypeMappingList",
                fileConfigToBrowserTypeMappingList);
        return delegateUpdateList(fileConfigToBrowserTypeMappingList);
    }

    /**
     * Batch-delete the list. <br />
     * This method uses 'Batch Update' of java.sql.PreparedStatement.
     * @param fileConfigToBrowserTypeMappingList The list of the entity. (NotNull)
     * @return The array of deleted count.
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     */
    public int[] batchDelete(
            List<FileConfigToBrowserTypeMapping> fileConfigToBrowserTypeMappingList) {
        assertObjectNotNull("fileConfigToBrowserTypeMappingList",
                fileConfigToBrowserTypeMappingList);
        return delegateDeleteList(fileConfigToBrowserTypeMappingList);
    }

    // ===================================================================================
    //                                                                        Query Update
    //                                                                        ============
    /**
     * Query-update the several entities non-strictly modified-only. {NonExclusiveControl}
     * <pre>
     * FileConfigToBrowserTypeMapping fileConfigToBrowserTypeMapping = new FileConfigToBrowserTypeMapping();
     * <span style="color: #3F7E5E">// you don't need to set PK value</span>
     * <span style="color: #3F7E5E">//fileConfigToBrowserTypeMapping.setPK...(value);</span>
     * fileConfigToBrowserTypeMapping.setFoo...(value); <span style="color: #3F7E5E">// you should set only modified columns</span>
     * <span style="color: #3F7E5E">// you don't need to set the value of exclusive control column</span>
     * <span style="color: #3F7E5E">// (auto-increment for version number is valid though non-exclusive control)</span>
     * <span style="color: #3F7E5E">//fileConfigToBrowserTypeMapping.setVersionNo(value);</span>
     * FileConfigToBrowserTypeMappingCB cb = new FileConfigToBrowserTypeMappingCB();
     * cb.query().setFoo...(value);
     * fileConfigToBrowserTypeMappingBhv.<span style="color: #FD4747">queryUpdate</span>(fileConfigToBrowserTypeMapping, cb);
     * </pre>
     * @param fileConfigToBrowserTypeMapping The entity that contains update values. (NotNull) {PrimaryKeyNotRequired}
     * @param cb The condition-bean of FileConfigToBrowserTypeMapping. (NotNull)
     * @return The updated count.
     */
    public int queryUpdate(
            FileConfigToBrowserTypeMapping fileConfigToBrowserTypeMapping,
            FileConfigToBrowserTypeMappingCB cb) {
        return delegateQueryUpdate(fileConfigToBrowserTypeMapping, cb);
    }

    /**
     * Query-delete the several entities. {NonExclusiveControl}
     * <pre>
     * FileConfigToBrowserTypeMappingCB cb = new FileConfigToBrowserTypeMappingCB();
     * cb.query().setFoo...(value);
     * fileConfigToBrowserTypeMappingBhv.<span style="color: #FD4747">queryDelete</span>(fileConfigToBrowserTypeMapping, cb);
     * </pre>
     * @param cb The condition-bean of FileConfigToBrowserTypeMapping. (NotNull)
     * @return The deleted count.
     */
    public int queryDelete(FileConfigToBrowserTypeMappingCB cb) {
        return delegateQueryDelete(cb);
    }

    /**
     * Varying-update the entity modified-only. {UpdateCountZeroException, ExclusiveControl}
     * <pre>
     * FileConfigToBrowserTypeMapping fileConfigToBrowserTypeMapping = new FileConfigToBrowserTypeMapping();
     * fileConfigToBrowserTypeMapping.setPK...(value); <span style="color: #3F7E5E">// required</span>
     * fileConfigToBrowserTypeMapping.setOther...(value); <span style="color: #3F7E5E">// you should set only modified columns</span>
     * <span style="color: #3F7E5E">// if exclusive control, the value of exclusive control column is required</span>
     * fileConfigToBrowserTypeMapping.<span style="color: #FD4747">setVersionNo</span>(value);
     * try {
     *     UpdateOption&lt;FileConfigToBrowserTypeMappingCB&gt; option = new UpdateOption&lt;FileConfigToBrowserTypeMappingCB&gt;();
     *     option.self(new SpecifyQuery&lt;FileConfigToBrowserTypeMappingCB&gt;() {
     *         public void specify(FileConfigToBrowserTypeMappingCB cb) {
     *             cb.specify().<span style="color: #FD4747">columnXxxCount()</span>;
     *         }
     *     }).plus(1); <span style="color: #3F7E5E">// XXX_COUNT = XXX_COUNT + 1</span>
     *     fileConfigToBrowserTypeMappingBhv.<span style="color: #FD4747">varyingUpdate</span>(fileConfigToBrowserTypeMapping, option);
     * } catch (EntityAlreadyUpdatedException e) { <span style="color: #3F7E5E">// if concurrent update</span>
     *     ...
     * }
     * </pre>
     * @param fileConfigToBrowserTypeMapping The entity of update target. (NotNull) {PrimaryKeyRequired, ConcurrencyColumnRequired}
     * @param option The option of update for varying values. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void varyingUpdate(
            FileConfigToBrowserTypeMapping fileConfigToBrowserTypeMapping,
            final UpdateOption<FileConfigToBrowserTypeMappingCB> option) {
        processVaryingUpdate(option);
        helpUpdateInternally(fileConfigToBrowserTypeMapping,
                new InternalUpdateCallback<FileConfigToBrowserTypeMapping>() {
                    public int callbackDelegateUpdate(
                            FileConfigToBrowserTypeMapping entity) {
                        return delegateVaryingUpdate(entity, option);
                    }
                });
    }

    /**
     * Varying-query-update the several entities non-strictly modified-only. {NonExclusiveControl}
     * <pre>
     * FileConfigToBrowserTypeMapping fileConfigToBrowserTypeMapping = new FileConfigToBrowserTypeMapping();
     * <span style="color: #3F7E5E">// you don't need to set PK value</span>
     * <span style="color: #3F7E5E">//fileConfigToBrowserTypeMapping.setPK...(value);</span>
     * fileConfigToBrowserTypeMapping.setOther...(value); <span style="color: #3F7E5E">// you should set only modified columns</span>
     * <span style="color: #3F7E5E">// you don't need to set the value of exclusive control column</span>
     * <span style="color: #3F7E5E">// (auto-increment for version number is valid though non-exclusive control)</span>
     * <span style="color: #3F7E5E">//fileConfigToBrowserTypeMapping.setVersionNo(value);</span>
     * FileConfigToBrowserTypeMappingCB cb = new FileConfigToBrowserTypeMappingCB();
     * cb.query().setFoo...(value);
     * UpdateOption&lt;FileConfigToBrowserTypeMappingCB&gt; option = new UpdateOption&lt;FileConfigToBrowserTypeMappingCB&gt;();
     * option.self(new SpecifyQuery&lt;FileConfigToBrowserTypeMappingCB&gt;() {
     *     public void specify(FileConfigToBrowserTypeMappingCB cb) {
     *         cb.specify().<span style="color: #FD4747">columnFooCount()</span>;
     *     }
     * }).plus(1); <span style="color: #3F7E5E">// FOO_COUNT = FOO_COUNT + 1</span>
     * fileConfigToBrowserTypeMappingBhv.<span style="color: #FD4747">varyingQueryUpdate</span>(fileConfigToBrowserTypeMapping, cb, option);
     * </pre>
     * @param fileConfigToBrowserTypeMapping The entity that contains update values. (NotNull) {PrimaryKeyNotRequired}
     * @param cb The condition-bean of FileConfigToBrowserTypeMapping. (NotNull)
     * @param option The option of update for varying values. (NotNull)
     * @return The updated count.
     */
    public int varyingQueryUpdate(
            FileConfigToBrowserTypeMapping fileConfigToBrowserTypeMapping,
            FileConfigToBrowserTypeMappingCB cb,
            final UpdateOption<FileConfigToBrowserTypeMappingCB> option) {
        processVaryingUpdate(option);
        return delegateVaryingQueryUpdate(fileConfigToBrowserTypeMapping, cb,
                option);
    }

    protected void processVaryingUpdate(
            UpdateOption<FileConfigToBrowserTypeMappingCB> option) {
        assertUpdateOptionNotNull(option);
        FileConfigToBrowserTypeMappingCB cb = newMyConditionBean();
        cb.xsetupForVaryingUpdate();
        option.resolveSpecification(cb);
    }

    // ===================================================================================
    //                                                                     Delegate Method
    //                                                                     ===============
    // [Behavior Command]
    // -----------------------------------------------------
    //                                                Select
    //                                                ------
    protected int delegateSelectCount(FileConfigToBrowserTypeMappingCB cb) {
        return invoke(createSelectCountCBCommand(cb));
    }

    protected <ENTITY extends FileConfigToBrowserTypeMapping> void delegateSelectCursor(
            FileConfigToBrowserTypeMappingCB cb,
            EntityRowHandler<ENTITY> entityRowHandler, Class<ENTITY> entityType) {
        invoke(createSelectCursorCBCommand(cb, entityRowHandler, entityType));
    }

    protected <ENTITY extends FileConfigToBrowserTypeMapping> List<ENTITY> delegateSelectList(
            FileConfigToBrowserTypeMappingCB cb, Class<ENTITY> entityType) {
        return invoke(createSelectListCBCommand(cb, entityType));
    }

    // -----------------------------------------------------
    //                                                Update
    //                                                ------
    protected int delegateInsert(FileConfigToBrowserTypeMapping e) {
        if (!processBeforeInsert(e)) {
            return 1;
        }
        return invoke(createInsertEntityCommand(e));
    }

    protected int delegateUpdate(FileConfigToBrowserTypeMapping e) {
        if (!processBeforeUpdate(e)) {
            return 1;
        }
        return invoke(createUpdateNonstrictEntityCommand(e));
    }

    protected int delegateDelete(FileConfigToBrowserTypeMapping e) {
        if (!processBeforeDelete(e)) {
            return 1;
        }
        return invoke(createDeleteNonstrictEntityCommand(e));
    }

    protected int[] delegateInsertList(List<FileConfigToBrowserTypeMapping> ls) {
        if (ls.isEmpty()) {
            return new int[] {};
        }
        return invoke(createBatchInsertEntityCommand(helpFilterBeforeInsertInternally(ls)));
    }

    @SuppressWarnings("unchecked")
    protected int[] doCreateList(List<Entity> ls) {
        return delegateInsertList((List) ls);
    }

    protected int[] delegateUpdateList(List<FileConfigToBrowserTypeMapping> ls) {
        if (ls.isEmpty()) {
            return new int[] {};
        }
        return invoke(createBatchUpdateNonstrictEntityCommand(helpFilterBeforeUpdateInternally(ls)));
    }

    @SuppressWarnings("unchecked")
    protected int[] doModifyList(List<Entity> ls) {
        return delegateUpdateList((List) ls);
    }

    protected int[] delegateDeleteList(List<FileConfigToBrowserTypeMapping> ls) {
        if (ls.isEmpty()) {
            return new int[] {};
        }
        return invoke(createBatchDeleteNonstrictEntityCommand(helpFilterBeforeDeleteInternally(ls)));
    }

    @SuppressWarnings("unchecked")
    protected int[] doRemoveList(List<Entity> ls) {
        return delegateDeleteList((List) ls);
    }

    protected int delegateQueryUpdate(FileConfigToBrowserTypeMapping e,
            FileConfigToBrowserTypeMappingCB cb) {
        if (!processBeforeQueryUpdate(e, cb)) {
            return 0;
        }
        return invoke(createQueryUpdateEntityCBCommand(e, cb));
    }

    protected int delegateQueryDelete(FileConfigToBrowserTypeMappingCB cb) {
        if (!processBeforeQueryDelete(cb)) {
            return 0;
        }
        return invoke(createQueryDeleteCBCommand(cb));
    }

    protected int delegateVaryingUpdate(FileConfigToBrowserTypeMapping e,
            UpdateOption<FileConfigToBrowserTypeMappingCB> op) {
        if (!processBeforeUpdate(e)) {
            return 1;
        }
        return invoke(createVaryingUpdateNonstrictEntityCommand(e, op));
    }

    protected int delegateVaryingQueryUpdate(FileConfigToBrowserTypeMapping e,
            FileConfigToBrowserTypeMappingCB cb,
            UpdateOption<FileConfigToBrowserTypeMappingCB> op) {
        if (!processBeforeQueryUpdate(e, cb)) {
            return 0;
        }
        return invoke(createVaryingQueryUpdateEntityCBCommand(e, cb, op));
    }

    // ===================================================================================
    //                                                                Optimistic Lock Info
    //                                                                ====================
    /**
     * {@inheritDoc}
     */
    @Override
    protected boolean hasVersionNoValue(Entity entity) {
        return false;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    protected boolean hasUpdateDateValue(Entity entity) {
        return false;
    }

    // ===================================================================================
    //                                                                     Downcast Helper
    //                                                                     ===============
    protected FileConfigToBrowserTypeMapping downcast(Entity entity) {
        return helpEntityDowncastInternally(entity,
                FileConfigToBrowserTypeMapping.class);
    }

    protected FileConfigToBrowserTypeMappingCB downcast(ConditionBean cb) {
        return helpConditionBeanDowncastInternally(cb,
                FileConfigToBrowserTypeMappingCB.class);
    }
}
