/*
 * Copyright 2009-2010 the Fess Project and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package jp.sf.fess.db.bsbhv;

import java.util.List;

import jp.sf.fess.db.allcommon.DBCurrent;
import jp.sf.fess.db.allcommon.DBFluteConfig;
import jp.sf.fess.db.bsentity.dbmeta.WebCrawlingConfigDbm;
import jp.sf.fess.db.cbean.RequestHeaderCB;
import jp.sf.fess.db.cbean.WebAuthenticationCB;
import jp.sf.fess.db.cbean.WebConfigToBrowserTypeMappingCB;
import jp.sf.fess.db.cbean.WebConfigToLabelTypeMappingCB;
import jp.sf.fess.db.cbean.WebConfigToRoleTypeMappingCB;
import jp.sf.fess.db.cbean.WebCrawlingConfigCB;
import jp.sf.fess.db.exbhv.RequestHeaderBhv;
import jp.sf.fess.db.exbhv.WebAuthenticationBhv;
import jp.sf.fess.db.exbhv.WebConfigToBrowserTypeMappingBhv;
import jp.sf.fess.db.exbhv.WebConfigToLabelTypeMappingBhv;
import jp.sf.fess.db.exbhv.WebConfigToRoleTypeMappingBhv;
import jp.sf.fess.db.exentity.RequestHeader;
import jp.sf.fess.db.exentity.WebAuthentication;
import jp.sf.fess.db.exentity.WebConfigToBrowserTypeMapping;
import jp.sf.fess.db.exentity.WebConfigToLabelTypeMapping;
import jp.sf.fess.db.exentity.WebConfigToRoleTypeMapping;
import jp.sf.fess.db.exentity.WebCrawlingConfig;

import org.seasar.dbflute.DBDef;
import org.seasar.dbflute.Entity;
import org.seasar.dbflute.bhv.ConditionBeanSetupper;
import org.seasar.dbflute.bhv.LoadReferrerOption;
import org.seasar.dbflute.cbean.ConditionBean;
import org.seasar.dbflute.cbean.EntityRowHandler;
import org.seasar.dbflute.cbean.ListResultBean;
import org.seasar.dbflute.cbean.PagingBean;
import org.seasar.dbflute.cbean.PagingHandler;
import org.seasar.dbflute.cbean.PagingInvoker;
import org.seasar.dbflute.cbean.PagingResultBean;
import org.seasar.dbflute.cbean.ResultBeanBuilder;
import org.seasar.dbflute.dbmeta.DBMeta;
import org.seasar.dbflute.jdbc.StatementConfig;

/**
 * The behavior of WEB_CRAWLING_CONFIG that the type is TABLE. <br />
 * <pre>
 * [primary-key]
 *     ID
 * 
 * [column]
 *     ID, NAME, URLS, INCLUDED_URLS, EXCLUDED_URLS, INCLUDED_DOC_URLS, EXCLUDED_DOC_URLS, DEPTH, MAX_ACCESS_COUNT, USER_AGENT, NUM_OF_THREAD, INTERVAL_TIME, BOOST, AVAILABLE, SORT_ORDER, CREATED_BY, CREATED_TIME, UPDATED_BY, UPDATED_TIME, DELETED_BY, DELETED_TIME, VERSION_NO
 * 
 * [sequence]
 *     
 * 
 * [identity]
 *     ID
 * 
 * [version-no]
 *     VERSION_NO
 * 
 * [foreign-table]
 *     
 * 
 * [referrer-table]
 *     REQUEST_HEADER, WEB_AUTHENTICATION, WEB_CONFIG_TO_BROWSER_TYPE_MAPPING, WEB_CONFIG_TO_LABEL_TYPE_MAPPING, WEB_CONFIG_TO_ROLE_TYPE_MAPPING
 * 
 * [foreign-property]
 *     
 * 
 * [referrer-property]
 *     requestHeaderList, webAuthenticationList, webConfigToBrowserTypeMappingList, webConfigToLabelTypeMappingList, webConfigToRoleTypeMappingList
 * </pre>
 * @author DBFlute(AutoGenerator)
 */
public abstract class BsWebCrawlingConfigBhv extends
        org.seasar.dbflute.bhv.AbstractBehaviorWritable {

    // ===================================================================================
    //                                                                          Definition
    //                                                                          ==========
    /*df:BehaviorQueryPathBegin*/
    /*df:BehaviorQueryPathEnd*/

    // ===================================================================================
    //                                                                          Table name
    //                                                                          ==========
    /** @return The name on database of table. (NotNull) */
    public String getTableDbName() {
        return "WEB_CRAWLING_CONFIG";
    }

    // ===================================================================================
    //                                                                              DBMeta
    //                                                                              ======
    /** @return The instance of DBMeta. (NotNull) */
    public DBMeta getDBMeta() {
        return WebCrawlingConfigDbm.getInstance();
    }

    /** @return The instance of DBMeta as my table type. (NotNull) */
    public WebCrawlingConfigDbm getMyDBMeta() {
        return WebCrawlingConfigDbm.getInstance();
    }

    // ===================================================================================
    //                                                                        New Instance
    //                                                                        ============
    public Entity newEntity() {
        return newMyEntity();
    }

    public ConditionBean newConditionBean() {
        return newMyConditionBean();
    }

    public WebCrawlingConfig newMyEntity() {
        return new WebCrawlingConfig();
    }

    public WebCrawlingConfigCB newMyConditionBean() {
        return new WebCrawlingConfigCB();
    }

    // ===================================================================================
    //                                                                       Current DBDef
    //                                                                       =============
    @Override
    protected DBDef getCurrentDBDef() {
        return DBCurrent.getInstance().currentDBDef();
    }

    // ===================================================================================
    //                                                             Default StatementConfig
    //                                                             =======================
    @Override
    protected StatementConfig getDefaultStatementConfig() {
        return DBFluteConfig.getInstance().getDefaultStatementConfig();
    }

    // ===================================================================================
    //                                                                        Count Select
    //                                                                        ============
    /**
     * Select the count by the condition-bean. {IgnorePagingCondition}
     * @param cb The condition-bean of WebCrawlingConfig. (NotNull)
     * @return The selected count.
     */
    public int selectCount(WebCrawlingConfigCB cb) {
        assertCBNotNull(cb);
        return delegateSelectCount(cb);
    }

    // ===================================================================================
    //                                                                       Cursor Select
    //                                                                       =============
    /**
     * Select the cursor by the condition-bean. <br />
     * Attention: It has a mapping cost from result set to entity.
     * @param cb The condition-bean of WebCrawlingConfig. (NotNull)
     * @param entityRowHandler The handler of entity row of WebCrawlingConfig. (NotNull)
     */
    public void selectCursor(WebCrawlingConfigCB cb,
            EntityRowHandler<WebCrawlingConfig> entityRowHandler) {
        assertCBNotNull(cb);
        assertObjectNotNull("entityRowHandler<WebCrawlingConfig>",
                entityRowHandler);
        delegateSelectCursor(cb, entityRowHandler);
    }

    // ===================================================================================
    //                                                                       Entity Select
    //                                                                       =============
    /**
     * Select the entity by the condition-bean.
     * @param cb The condition-bean of WebCrawlingConfig. (NotNull)
     * @return The selected entity. (Nullalble)
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     */
    public WebCrawlingConfig selectEntity(final WebCrawlingConfigCB cb) {
        return helpSelectEntityInternally(
                cb,
                new InternalSelectEntityCallback<WebCrawlingConfig, WebCrawlingConfigCB>() {
                    public List<WebCrawlingConfig> callbackSelectList(
                            WebCrawlingConfigCB cb) {
                        return selectList(cb);
                    }
                });
    }

    /**
     * Select the entity by the condition-bean with deleted check.
     * @param cb The condition-bean of WebCrawlingConfig. (NotNull)
     * @return The selected entity. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     */
    public WebCrawlingConfig selectEntityWithDeletedCheck(
            final WebCrawlingConfigCB cb) {
        return helpSelectEntityWithDeletedCheckInternally(
                cb,
                new InternalSelectEntityWithDeletedCheckCallback<WebCrawlingConfig, WebCrawlingConfigCB>() {
                    public List<WebCrawlingConfig> callbackSelectList(
                            WebCrawlingConfigCB cb) {
                        return selectList(cb);
                    }
                });
    }

    /* (non-javadoc)
     * Select the entity with deleted check. {by primary-key value}
     * @param primaryKey The keys of primary.
     * @return The selected entity. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     */
    public WebCrawlingConfig selectByPKValueWithDeletedCheck(Long id) {
        WebCrawlingConfig entity = new WebCrawlingConfig();
        entity.setId(id);
        final WebCrawlingConfigCB cb = newMyConditionBean();
        cb.acceptPrimaryKeyMapString(getDBMeta().extractPrimaryKeyMapString(
                entity));
        return selectEntityWithDeletedCheck(cb);
    }

    // ===================================================================================
    //                                                                         List Select
    //                                                                         ===========
    /**
     * Select the list as result bean.
     * @param cb The condition-bean of WebCrawlingConfig. (NotNull)
     * @return The result bean of selected list. (NotNull)
     */
    public ListResultBean<WebCrawlingConfig> selectList(WebCrawlingConfigCB cb) {
        assertCBNotNull(cb);
        return new ResultBeanBuilder<WebCrawlingConfig>(getTableDbName())
                .buildListResultBean(cb, delegateSelectList(cb));
    }

    // ===================================================================================
    //                                                                         Page Select
    //                                                                         ===========
    /**
     * Select the page as result bean.
     * @param cb The condition-bean of WebCrawlingConfig. (NotNull)
     * @return The result bean of selected page. (NotNull)
     */
    public PagingResultBean<WebCrawlingConfig> selectPage(
            final WebCrawlingConfigCB cb) {
        assertCBNotNull(cb);
        final PagingInvoker<WebCrawlingConfig> invoker = new PagingInvoker<WebCrawlingConfig>(
                getTableDbName());
        final PagingHandler<WebCrawlingConfig> handler = new PagingHandler<WebCrawlingConfig>() {
            public PagingBean getPagingBean() {
                return cb;
            }

            public int count() {
                return selectCount(cb);
            }

            public List<WebCrawlingConfig> paging() {
                return selectList(cb);
            }
        };
        return invoker.invokePaging(handler);
    }

    // ===================================================================================
    //                                                                       Scalar Select
    //                                                                       =============
    /**
     * Select the scalar value derived by a function. <br />
     * Call a function method after this method called like as follows:
     * <pre>
     * webCrawlingConfigBhv.scalarSelect(Date.class).max(new ScalarQuery(WebCrawlingConfigCB cb) {
     *     cb.specify().columnXxxDatetime(); // the required specification of target column
     *     cb.query().setXxxName_PrefixSearch("S"); // query as you like it
     * });
     * </pre>
     * @param <RESULT> The type of result.
     * @param resultType The type of result. (NotNull)
     * @return The scalar value derived by a function. (Nullable)
     */
    public <RESULT> SLFunction<WebCrawlingConfigCB, RESULT> scalarSelect(
            Class<RESULT> resultType) {
        WebCrawlingConfigCB cb = newMyConditionBean();
        cb.xsetupForScalarSelect();
        cb.getSqlClause().disableSelectIndex(); // for when you use union
        return new SLFunction<WebCrawlingConfigCB, RESULT>(cb, resultType);
    }

    // ===================================================================================
    //                                                                       Load Referrer
    //                                                                       =============
    /**
     * {Refer to overload method that has an argument of the list of entity.}
     * @param webCrawlingConfig The entity of webCrawlingConfig. (NotNull)
     * @param conditionBeanSetupper The instance of referrer condition-bean setupper for registering referrer condition. (NotNull)
     */
    public void loadRequestHeaderList(WebCrawlingConfig webCrawlingConfig,
            ConditionBeanSetupper<RequestHeaderCB> conditionBeanSetupper) {
        xassLRArg(webCrawlingConfig, conditionBeanSetupper);
        loadRequestHeaderList(xnewLRLs(webCrawlingConfig),
                conditionBeanSetupper);
    }

    /**
     * Load referrer of requestHeaderList with the setupper for condition-bean of referrer. <br />
     * About internal policy, the value of primary key(and others too) is treated as case-insensitive. <br />
     * The condition-bean that the setupper provides have settings before you touch it. It is as follows:
     * <pre>
     * cb.query().setWebCrawlingConfigId_InScope(pkList);
     * cb.query().addOrderBy_WebCrawlingConfigId_Asc();
     * </pre>
     * @param webCrawlingConfigList The entity list of webCrawlingConfig. (NotNull)
     * @param conditionBeanSetupper The instance of referrer condition-bean setupper for registering referrer condition. (NotNull)
     */
    public void loadRequestHeaderList(
            List<WebCrawlingConfig> webCrawlingConfigList,
            ConditionBeanSetupper<RequestHeaderCB> conditionBeanSetupper) {
        xassLRArg(webCrawlingConfigList, conditionBeanSetupper);
        loadRequestHeaderList(webCrawlingConfigList,
                new LoadReferrerOption<RequestHeaderCB, RequestHeader>(
                        conditionBeanSetupper));
    }

    /**
     * {Refer to overload method that has an argument of the list of entity.}
     * @param webCrawlingConfig The entity of webCrawlingConfig. (NotNull)
     * @param loadReferrerOption The option of load-referrer. (NotNull)
     */
    public void loadRequestHeaderList(
            WebCrawlingConfig webCrawlingConfig,
            LoadReferrerOption<RequestHeaderCB, RequestHeader> loadReferrerOption) {
        xassLRArg(webCrawlingConfig, loadReferrerOption);
        loadRequestHeaderList(xnewLRLs(webCrawlingConfig), loadReferrerOption);
    }

    /**
     * {Refer to overload method that has an argument of condition-bean setupper.}
     * @param webCrawlingConfigList The entity list of webCrawlingConfig. (NotNull)
     * @param loadReferrerOption The option of load-referrer. (NotNull)
     */
    public void loadRequestHeaderList(
            List<WebCrawlingConfig> webCrawlingConfigList,
            LoadReferrerOption<RequestHeaderCB, RequestHeader> loadReferrerOption) {
        xassLRArg(webCrawlingConfigList, loadReferrerOption);
        if (webCrawlingConfigList.isEmpty()) {
            return;
        }
        final RequestHeaderBhv referrerBhv = xgetBSFLR().select(
                RequestHeaderBhv.class);
        helpLoadReferrerInternally(
                webCrawlingConfigList,
                loadReferrerOption,
                new InternalLoadReferrerCallback<WebCrawlingConfig, Long, RequestHeaderCB, RequestHeader>() {
                    public Long callbackBase_getPrimaryKeyValue(
                            WebCrawlingConfig entity) {
                        return entity.getId();
                    }

                    public void callbackBase_setReferrerList(
                            WebCrawlingConfig entity,
                            List<RequestHeader> referrerList) {
                        entity.setRequestHeaderList(referrerList);
                    }

                    public RequestHeaderCB callbackReferrer_newMyConditionBean() {
                        return referrerBhv.newMyConditionBean();
                    }

                    public void callbackReferrer_queryForeignKeyInScope(
                            RequestHeaderCB cb, List<Long> pkList) {
                        cb.query().setWebCrawlingConfigId_InScope(pkList);
                    }

                    public void callbackReferrer_queryAddOrderByForeignKeyAsc(
                            RequestHeaderCB cb) {
                        cb.query().addOrderBy_WebCrawlingConfigId_Asc();
                    }

                    public List<RequestHeader> callbackReferrer_selectList(
                            RequestHeaderCB cb) {
                        return referrerBhv.selectList(cb);
                    }

                    public Long callbackReferrer_getForeignKeyValue(
                            RequestHeader entity) {
                        return entity.getWebCrawlingConfigId();
                    }

                    public void callbackReferrer_setForeignEntity(
                            RequestHeader referrerEntity,
                            WebCrawlingConfig baseEntity) {
                        referrerEntity.setWebCrawlingConfig(baseEntity);
                    }
                });
    }

    /**
     * {Refer to overload method that has an argument of the list of entity.}
     * @param webCrawlingConfig The entity of webCrawlingConfig. (NotNull)
     * @param conditionBeanSetupper The instance of referrer condition-bean setupper for registering referrer condition. (NotNull)
     */
    public void loadWebAuthenticationList(WebCrawlingConfig webCrawlingConfig,
            ConditionBeanSetupper<WebAuthenticationCB> conditionBeanSetupper) {
        xassLRArg(webCrawlingConfig, conditionBeanSetupper);
        loadWebAuthenticationList(xnewLRLs(webCrawlingConfig),
                conditionBeanSetupper);
    }

    /**
     * Load referrer of webAuthenticationList with the setupper for condition-bean of referrer. <br />
     * About internal policy, the value of primary key(and others too) is treated as case-insensitive. <br />
     * The condition-bean that the setupper provides have settings before you touch it. It is as follows:
     * <pre>
     * cb.query().setWebCrawlingConfigId_InScope(pkList);
     * cb.query().addOrderBy_WebCrawlingConfigId_Asc();
     * </pre>
     * @param webCrawlingConfigList The entity list of webCrawlingConfig. (NotNull)
     * @param conditionBeanSetupper The instance of referrer condition-bean setupper for registering referrer condition. (NotNull)
     */
    public void loadWebAuthenticationList(
            List<WebCrawlingConfig> webCrawlingConfigList,
            ConditionBeanSetupper<WebAuthenticationCB> conditionBeanSetupper) {
        xassLRArg(webCrawlingConfigList, conditionBeanSetupper);
        loadWebAuthenticationList(webCrawlingConfigList,
                new LoadReferrerOption<WebAuthenticationCB, WebAuthentication>(
                        conditionBeanSetupper));
    }

    /**
     * {Refer to overload method that has an argument of the list of entity.}
     * @param webCrawlingConfig The entity of webCrawlingConfig. (NotNull)
     * @param loadReferrerOption The option of load-referrer. (NotNull)
     */
    public void loadWebAuthenticationList(
            WebCrawlingConfig webCrawlingConfig,
            LoadReferrerOption<WebAuthenticationCB, WebAuthentication> loadReferrerOption) {
        xassLRArg(webCrawlingConfig, loadReferrerOption);
        loadWebAuthenticationList(xnewLRLs(webCrawlingConfig),
                loadReferrerOption);
    }

    /**
     * {Refer to overload method that has an argument of condition-bean setupper.}
     * @param webCrawlingConfigList The entity list of webCrawlingConfig. (NotNull)
     * @param loadReferrerOption The option of load-referrer. (NotNull)
     */
    public void loadWebAuthenticationList(
            List<WebCrawlingConfig> webCrawlingConfigList,
            LoadReferrerOption<WebAuthenticationCB, WebAuthentication> loadReferrerOption) {
        xassLRArg(webCrawlingConfigList, loadReferrerOption);
        if (webCrawlingConfigList.isEmpty()) {
            return;
        }
        final WebAuthenticationBhv referrerBhv = xgetBSFLR().select(
                WebAuthenticationBhv.class);
        helpLoadReferrerInternally(
                webCrawlingConfigList,
                loadReferrerOption,
                new InternalLoadReferrerCallback<WebCrawlingConfig, Long, WebAuthenticationCB, WebAuthentication>() {
                    public Long callbackBase_getPrimaryKeyValue(
                            WebCrawlingConfig entity) {
                        return entity.getId();
                    }

                    public void callbackBase_setReferrerList(
                            WebCrawlingConfig entity,
                            List<WebAuthentication> referrerList) {
                        entity.setWebAuthenticationList(referrerList);
                    }

                    public WebAuthenticationCB callbackReferrer_newMyConditionBean() {
                        return referrerBhv.newMyConditionBean();
                    }

                    public void callbackReferrer_queryForeignKeyInScope(
                            WebAuthenticationCB cb, List<Long> pkList) {
                        cb.query().setWebCrawlingConfigId_InScope(pkList);
                    }

                    public void callbackReferrer_queryAddOrderByForeignKeyAsc(
                            WebAuthenticationCB cb) {
                        cb.query().addOrderBy_WebCrawlingConfigId_Asc();
                    }

                    public List<WebAuthentication> callbackReferrer_selectList(
                            WebAuthenticationCB cb) {
                        return referrerBhv.selectList(cb);
                    }

                    public Long callbackReferrer_getForeignKeyValue(
                            WebAuthentication entity) {
                        return entity.getWebCrawlingConfigId();
                    }

                    public void callbackReferrer_setForeignEntity(
                            WebAuthentication referrerEntity,
                            WebCrawlingConfig baseEntity) {
                        referrerEntity.setWebCrawlingConfig(baseEntity);
                    }
                });
    }

    /**
     * {Refer to overload method that has an argument of the list of entity.}
     * @param webCrawlingConfig The entity of webCrawlingConfig. (NotNull)
     * @param conditionBeanSetupper The instance of referrer condition-bean setupper for registering referrer condition. (NotNull)
     */
    public void loadWebConfigToBrowserTypeMappingList(
            WebCrawlingConfig webCrawlingConfig,
            ConditionBeanSetupper<WebConfigToBrowserTypeMappingCB> conditionBeanSetupper) {
        xassLRArg(webCrawlingConfig, conditionBeanSetupper);
        loadWebConfigToBrowserTypeMappingList(xnewLRLs(webCrawlingConfig),
                conditionBeanSetupper);
    }

    /**
     * Load referrer of webConfigToBrowserTypeMappingList with the setupper for condition-bean of referrer. <br />
     * About internal policy, the value of primary key(and others too) is treated as case-insensitive. <br />
     * The condition-bean that the setupper provides have settings before you touch it. It is as follows:
     * <pre>
     * cb.query().setWebConfigId_InScope(pkList);
     * cb.query().addOrderBy_WebConfigId_Asc();
     * </pre>
     * @param webCrawlingConfigList The entity list of webCrawlingConfig. (NotNull)
     * @param conditionBeanSetupper The instance of referrer condition-bean setupper for registering referrer condition. (NotNull)
     */
    public void loadWebConfigToBrowserTypeMappingList(
            List<WebCrawlingConfig> webCrawlingConfigList,
            ConditionBeanSetupper<WebConfigToBrowserTypeMappingCB> conditionBeanSetupper) {
        xassLRArg(webCrawlingConfigList, conditionBeanSetupper);
        loadWebConfigToBrowserTypeMappingList(
                webCrawlingConfigList,
                new LoadReferrerOption<WebConfigToBrowserTypeMappingCB, WebConfigToBrowserTypeMapping>(
                        conditionBeanSetupper));
    }

    /**
     * {Refer to overload method that has an argument of the list of entity.}
     * @param webCrawlingConfig The entity of webCrawlingConfig. (NotNull)
     * @param loadReferrerOption The option of load-referrer. (NotNull)
     */
    public void loadWebConfigToBrowserTypeMappingList(
            WebCrawlingConfig webCrawlingConfig,
            LoadReferrerOption<WebConfigToBrowserTypeMappingCB, WebConfigToBrowserTypeMapping> loadReferrerOption) {
        xassLRArg(webCrawlingConfig, loadReferrerOption);
        loadWebConfigToBrowserTypeMappingList(xnewLRLs(webCrawlingConfig),
                loadReferrerOption);
    }

    /**
     * {Refer to overload method that has an argument of condition-bean setupper.}
     * @param webCrawlingConfigList The entity list of webCrawlingConfig. (NotNull)
     * @param loadReferrerOption The option of load-referrer. (NotNull)
     */
    public void loadWebConfigToBrowserTypeMappingList(
            List<WebCrawlingConfig> webCrawlingConfigList,
            LoadReferrerOption<WebConfigToBrowserTypeMappingCB, WebConfigToBrowserTypeMapping> loadReferrerOption) {
        xassLRArg(webCrawlingConfigList, loadReferrerOption);
        if (webCrawlingConfigList.isEmpty()) {
            return;
        }
        final WebConfigToBrowserTypeMappingBhv referrerBhv = xgetBSFLR()
                .select(WebConfigToBrowserTypeMappingBhv.class);
        helpLoadReferrerInternally(
                webCrawlingConfigList,
                loadReferrerOption,
                new InternalLoadReferrerCallback<WebCrawlingConfig, Long, WebConfigToBrowserTypeMappingCB, WebConfigToBrowserTypeMapping>() {
                    public Long callbackBase_getPrimaryKeyValue(
                            WebCrawlingConfig entity) {
                        return entity.getId();
                    }

                    public void callbackBase_setReferrerList(
                            WebCrawlingConfig entity,
                            List<WebConfigToBrowserTypeMapping> referrerList) {
                        entity
                                .setWebConfigToBrowserTypeMappingList(referrerList);
                    }

                    public WebConfigToBrowserTypeMappingCB callbackReferrer_newMyConditionBean() {
                        return referrerBhv.newMyConditionBean();
                    }

                    public void callbackReferrer_queryForeignKeyInScope(
                            WebConfigToBrowserTypeMappingCB cb,
                            List<Long> pkList) {
                        cb.query().setWebConfigId_InScope(pkList);
                    }

                    public void callbackReferrer_queryAddOrderByForeignKeyAsc(
                            WebConfigToBrowserTypeMappingCB cb) {
                        cb.query().addOrderBy_WebConfigId_Asc();
                    }

                    public List<WebConfigToBrowserTypeMapping> callbackReferrer_selectList(
                            WebConfigToBrowserTypeMappingCB cb) {
                        return referrerBhv.selectList(cb);
                    }

                    public Long callbackReferrer_getForeignKeyValue(
                            WebConfigToBrowserTypeMapping entity) {
                        return entity.getWebConfigId();
                    }

                    public void callbackReferrer_setForeignEntity(
                            WebConfigToBrowserTypeMapping referrerEntity,
                            WebCrawlingConfig baseEntity) {
                        referrerEntity.setWebCrawlingConfig(baseEntity);
                    }
                });
    }

    /**
     * {Refer to overload method that has an argument of the list of entity.}
     * @param webCrawlingConfig The entity of webCrawlingConfig. (NotNull)
     * @param conditionBeanSetupper The instance of referrer condition-bean setupper for registering referrer condition. (NotNull)
     */
    public void loadWebConfigToLabelTypeMappingList(
            WebCrawlingConfig webCrawlingConfig,
            ConditionBeanSetupper<WebConfigToLabelTypeMappingCB> conditionBeanSetupper) {
        xassLRArg(webCrawlingConfig, conditionBeanSetupper);
        loadWebConfigToLabelTypeMappingList(xnewLRLs(webCrawlingConfig),
                conditionBeanSetupper);
    }

    /**
     * Load referrer of webConfigToLabelTypeMappingList with the setupper for condition-bean of referrer. <br />
     * About internal policy, the value of primary key(and others too) is treated as case-insensitive. <br />
     * The condition-bean that the setupper provides have settings before you touch it. It is as follows:
     * <pre>
     * cb.query().setWebConfigId_InScope(pkList);
     * cb.query().addOrderBy_WebConfigId_Asc();
     * </pre>
     * @param webCrawlingConfigList The entity list of webCrawlingConfig. (NotNull)
     * @param conditionBeanSetupper The instance of referrer condition-bean setupper for registering referrer condition. (NotNull)
     */
    public void loadWebConfigToLabelTypeMappingList(
            List<WebCrawlingConfig> webCrawlingConfigList,
            ConditionBeanSetupper<WebConfigToLabelTypeMappingCB> conditionBeanSetupper) {
        xassLRArg(webCrawlingConfigList, conditionBeanSetupper);
        loadWebConfigToLabelTypeMappingList(
                webCrawlingConfigList,
                new LoadReferrerOption<WebConfigToLabelTypeMappingCB, WebConfigToLabelTypeMapping>(
                        conditionBeanSetupper));
    }

    /**
     * {Refer to overload method that has an argument of the list of entity.}
     * @param webCrawlingConfig The entity of webCrawlingConfig. (NotNull)
     * @param loadReferrerOption The option of load-referrer. (NotNull)
     */
    public void loadWebConfigToLabelTypeMappingList(
            WebCrawlingConfig webCrawlingConfig,
            LoadReferrerOption<WebConfigToLabelTypeMappingCB, WebConfigToLabelTypeMapping> loadReferrerOption) {
        xassLRArg(webCrawlingConfig, loadReferrerOption);
        loadWebConfigToLabelTypeMappingList(xnewLRLs(webCrawlingConfig),
                loadReferrerOption);
    }

    /**
     * {Refer to overload method that has an argument of condition-bean setupper.}
     * @param webCrawlingConfigList The entity list of webCrawlingConfig. (NotNull)
     * @param loadReferrerOption The option of load-referrer. (NotNull)
     */
    public void loadWebConfigToLabelTypeMappingList(
            List<WebCrawlingConfig> webCrawlingConfigList,
            LoadReferrerOption<WebConfigToLabelTypeMappingCB, WebConfigToLabelTypeMapping> loadReferrerOption) {
        xassLRArg(webCrawlingConfigList, loadReferrerOption);
        if (webCrawlingConfigList.isEmpty()) {
            return;
        }
        final WebConfigToLabelTypeMappingBhv referrerBhv = xgetBSFLR().select(
                WebConfigToLabelTypeMappingBhv.class);
        helpLoadReferrerInternally(
                webCrawlingConfigList,
                loadReferrerOption,
                new InternalLoadReferrerCallback<WebCrawlingConfig, Long, WebConfigToLabelTypeMappingCB, WebConfigToLabelTypeMapping>() {
                    public Long callbackBase_getPrimaryKeyValue(
                            WebCrawlingConfig entity) {
                        return entity.getId();
                    }

                    public void callbackBase_setReferrerList(
                            WebCrawlingConfig entity,
                            List<WebConfigToLabelTypeMapping> referrerList) {
                        entity.setWebConfigToLabelTypeMappingList(referrerList);
                    }

                    public WebConfigToLabelTypeMappingCB callbackReferrer_newMyConditionBean() {
                        return referrerBhv.newMyConditionBean();
                    }

                    public void callbackReferrer_queryForeignKeyInScope(
                            WebConfigToLabelTypeMappingCB cb, List<Long> pkList) {
                        cb.query().setWebConfigId_InScope(pkList);
                    }

                    public void callbackReferrer_queryAddOrderByForeignKeyAsc(
                            WebConfigToLabelTypeMappingCB cb) {
                        cb.query().addOrderBy_WebConfigId_Asc();
                    }

                    public List<WebConfigToLabelTypeMapping> callbackReferrer_selectList(
                            WebConfigToLabelTypeMappingCB cb) {
                        return referrerBhv.selectList(cb);
                    }

                    public Long callbackReferrer_getForeignKeyValue(
                            WebConfigToLabelTypeMapping entity) {
                        return entity.getWebConfigId();
                    }

                    public void callbackReferrer_setForeignEntity(
                            WebConfigToLabelTypeMapping referrerEntity,
                            WebCrawlingConfig baseEntity) {
                        referrerEntity.setWebCrawlingConfig(baseEntity);
                    }
                });
    }

    /**
     * {Refer to overload method that has an argument of the list of entity.}
     * @param webCrawlingConfig The entity of webCrawlingConfig. (NotNull)
     * @param conditionBeanSetupper The instance of referrer condition-bean setupper for registering referrer condition. (NotNull)
     */
    public void loadWebConfigToRoleTypeMappingList(
            WebCrawlingConfig webCrawlingConfig,
            ConditionBeanSetupper<WebConfigToRoleTypeMappingCB> conditionBeanSetupper) {
        xassLRArg(webCrawlingConfig, conditionBeanSetupper);
        loadWebConfigToRoleTypeMappingList(xnewLRLs(webCrawlingConfig),
                conditionBeanSetupper);
    }

    /**
     * Load referrer of webConfigToRoleTypeMappingList with the setupper for condition-bean of referrer. <br />
     * About internal policy, the value of primary key(and others too) is treated as case-insensitive. <br />
     * The condition-bean that the setupper provides have settings before you touch it. It is as follows:
     * <pre>
     * cb.query().setWebConfigId_InScope(pkList);
     * cb.query().addOrderBy_WebConfigId_Asc();
     * </pre>
     * @param webCrawlingConfigList The entity list of webCrawlingConfig. (NotNull)
     * @param conditionBeanSetupper The instance of referrer condition-bean setupper for registering referrer condition. (NotNull)
     */
    public void loadWebConfigToRoleTypeMappingList(
            List<WebCrawlingConfig> webCrawlingConfigList,
            ConditionBeanSetupper<WebConfigToRoleTypeMappingCB> conditionBeanSetupper) {
        xassLRArg(webCrawlingConfigList, conditionBeanSetupper);
        loadWebConfigToRoleTypeMappingList(
                webCrawlingConfigList,
                new LoadReferrerOption<WebConfigToRoleTypeMappingCB, WebConfigToRoleTypeMapping>(
                        conditionBeanSetupper));
    }

    /**
     * {Refer to overload method that has an argument of the list of entity.}
     * @param webCrawlingConfig The entity of webCrawlingConfig. (NotNull)
     * @param loadReferrerOption The option of load-referrer. (NotNull)
     */
    public void loadWebConfigToRoleTypeMappingList(
            WebCrawlingConfig webCrawlingConfig,
            LoadReferrerOption<WebConfigToRoleTypeMappingCB, WebConfigToRoleTypeMapping> loadReferrerOption) {
        xassLRArg(webCrawlingConfig, loadReferrerOption);
        loadWebConfigToRoleTypeMappingList(xnewLRLs(webCrawlingConfig),
                loadReferrerOption);
    }

    /**
     * {Refer to overload method that has an argument of condition-bean setupper.}
     * @param webCrawlingConfigList The entity list of webCrawlingConfig. (NotNull)
     * @param loadReferrerOption The option of load-referrer. (NotNull)
     */
    public void loadWebConfigToRoleTypeMappingList(
            List<WebCrawlingConfig> webCrawlingConfigList,
            LoadReferrerOption<WebConfigToRoleTypeMappingCB, WebConfigToRoleTypeMapping> loadReferrerOption) {
        xassLRArg(webCrawlingConfigList, loadReferrerOption);
        if (webCrawlingConfigList.isEmpty()) {
            return;
        }
        final WebConfigToRoleTypeMappingBhv referrerBhv = xgetBSFLR().select(
                WebConfigToRoleTypeMappingBhv.class);
        helpLoadReferrerInternally(
                webCrawlingConfigList,
                loadReferrerOption,
                new InternalLoadReferrerCallback<WebCrawlingConfig, Long, WebConfigToRoleTypeMappingCB, WebConfigToRoleTypeMapping>() {
                    public Long callbackBase_getPrimaryKeyValue(
                            WebCrawlingConfig entity) {
                        return entity.getId();
                    }

                    public void callbackBase_setReferrerList(
                            WebCrawlingConfig entity,
                            List<WebConfigToRoleTypeMapping> referrerList) {
                        entity.setWebConfigToRoleTypeMappingList(referrerList);
                    }

                    public WebConfigToRoleTypeMappingCB callbackReferrer_newMyConditionBean() {
                        return referrerBhv.newMyConditionBean();
                    }

                    public void callbackReferrer_queryForeignKeyInScope(
                            WebConfigToRoleTypeMappingCB cb, List<Long> pkList) {
                        cb.query().setWebConfigId_InScope(pkList);
                    }

                    public void callbackReferrer_queryAddOrderByForeignKeyAsc(
                            WebConfigToRoleTypeMappingCB cb) {
                        cb.query().addOrderBy_WebConfigId_Asc();
                    }

                    public List<WebConfigToRoleTypeMapping> callbackReferrer_selectList(
                            WebConfigToRoleTypeMappingCB cb) {
                        return referrerBhv.selectList(cb);
                    }

                    public Long callbackReferrer_getForeignKeyValue(
                            WebConfigToRoleTypeMapping entity) {
                        return entity.getWebConfigId();
                    }

                    public void callbackReferrer_setForeignEntity(
                            WebConfigToRoleTypeMapping referrerEntity,
                            WebCrawlingConfig baseEntity) {
                        referrerEntity.setWebCrawlingConfig(baseEntity);
                    }
                });
    }

    // ===================================================================================
    //                                                                    Pull out Foreign
    //                                                                    ================

    // ===================================================================================
    //                                                                       Entity Update
    //                                                                       =============
    /**
     * Insert the entity.
     * @param webCrawlingConfig The entity of insert target. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void insert(WebCrawlingConfig webCrawlingConfig) {
        assertEntityNotNull(webCrawlingConfig);
        delegateInsert(webCrawlingConfig);
    }

    @Override
    protected void doCreate(Entity webCrawlingConfig) {
        insert((WebCrawlingConfig) webCrawlingConfig);
    }

    /**
     * Update the entity modified-only. {UpdateCountZeroException, ConcurrencyControl}
     * @param webCrawlingConfig The entity of update target. (NotNull) {PrimaryKeyRequired, ConcurrencyColumnRequired}
     * @exception org.seasar.dbflute.exception.EntityAlreadyUpdatedException When the entity has already been updated.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void update(final WebCrawlingConfig webCrawlingConfig) {
        helpUpdateInternally(webCrawlingConfig,
                new InternalUpdateCallback<WebCrawlingConfig>() {
                    public int callbackDelegateUpdate(WebCrawlingConfig entity) {
                        return delegateUpdate(entity);
                    }
                });
    }

    @Override
    protected void doModify(Entity entity) {
        update((WebCrawlingConfig) entity);
    }

    /**
     * Update the entity non-strictly modified-only. {UpdateCountZeroException, NonConcurrencyControl}
     * @param webCrawlingConfig The entity of update target. (NotNull) {PrimaryKeyRequired}
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void updateNonstrict(final WebCrawlingConfig webCrawlingConfig) {
        helpUpdateNonstrictInternally(webCrawlingConfig,
                new InternalUpdateNonstrictCallback<WebCrawlingConfig>() {
                    public int callbackDelegateUpdateNonstrict(
                            WebCrawlingConfig entity) {
                        return delegateUpdateNonstrict(entity);
                    }
                });
    }

    @Override
    protected void doModifyNonstrict(Entity entity) {
        updateNonstrict((WebCrawlingConfig) entity);
    }

    /**
     * Insert or update the entity modified-only. {ConcurrencyControl(when update)}
     * @param webCrawlingConfig The entity of insert or update target. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyUpdatedException When the entity has already been updated.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void insertOrUpdate(final WebCrawlingConfig webCrawlingConfig) {
        helpInsertOrUpdateInternally(
                webCrawlingConfig,
                new InternalInsertOrUpdateCallback<WebCrawlingConfig, WebCrawlingConfigCB>() {
                    public void callbackInsert(WebCrawlingConfig entity) {
                        insert(entity);
                    }

                    public void callbackUpdate(WebCrawlingConfig entity) {
                        update(entity);
                    }

                    public WebCrawlingConfigCB callbackNewMyConditionBean() {
                        return newMyConditionBean();
                    }

                    public int callbackSelectCount(WebCrawlingConfigCB cb) {
                        return selectCount(cb);
                    }
                });
    }

    @Override
    protected void doCreateOrUpdate(Entity webCrawlingConfig) {
        insertOrUpdate((WebCrawlingConfig) webCrawlingConfig);
    }

    /**
     * Insert or update the entity non-strictly modified-only. {NonConcurrencyControl(when update)}
     * @param webCrawlingConfig The entity of insert or update target. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void insertOrUpdateNonstrict(WebCrawlingConfig webCrawlingConfig) {
        helpInsertOrUpdateInternally(
                webCrawlingConfig,
                new InternalInsertOrUpdateNonstrictCallback<WebCrawlingConfig>() {
                    public void callbackInsert(WebCrawlingConfig entity) {
                        insert(entity);
                    }

                    public void callbackUpdateNonstrict(WebCrawlingConfig entity) {
                        updateNonstrict(entity);
                    }
                });
    }

    @Override
    protected void doCreateOrUpdateNonstrict(Entity entity) {
        insertOrUpdateNonstrict((WebCrawlingConfig) entity);
    }

    /**
     * Delete the entity. {UpdateCountZeroException, ConcurrencyControl}
     * @param webCrawlingConfig The entity of delete target. (NotNull) {PrimaryKeyRequired, ConcurrencyColumnRequired}
     * @exception org.seasar.dbflute.exception.EntityAlreadyUpdatedException When the entity has already been updated.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     */
    public void delete(WebCrawlingConfig webCrawlingConfig) {
        helpDeleteInternally(webCrawlingConfig,
                new InternalDeleteCallback<WebCrawlingConfig>() {
                    public int callbackDelegateDelete(WebCrawlingConfig entity) {
                        return delegateDelete(entity);
                    }
                });
    }

    @Override
    protected void doRemove(Entity webCrawlingConfig) {
        delete((WebCrawlingConfig) webCrawlingConfig);
    }

    /**
     * Delete the entity non-strictly. {UpdateCountZeroException, NonConcurrencyControl}
     * @param webCrawlingConfig Entity. (NotNull) {PrimaryKeyRequired}
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     */
    public void deleteNonstrict(WebCrawlingConfig webCrawlingConfig) {
        helpDeleteNonstrictInternally(webCrawlingConfig,
                new InternalDeleteNonstrictCallback<WebCrawlingConfig>() {
                    public int callbackDelegateDeleteNonstrict(
                            WebCrawlingConfig entity) {
                        return delegateDeleteNonstrict(entity);
                    }
                });
    }

    /**
     * Delete the entity non-strictly ignoring deleted. {UpdateCountZeroException, NonConcurrencyControl}
     * @param webCrawlingConfig Entity. (NotNull) {PrimaryKeyRequired}
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     */
    public void deleteNonstrictIgnoreDeleted(WebCrawlingConfig webCrawlingConfig) {
        helpDeleteNonstrictIgnoreDeletedInternally(
                webCrawlingConfig,
                new InternalDeleteNonstrictIgnoreDeletedCallback<WebCrawlingConfig>() {
                    public int callbackDelegateDeleteNonstrict(
                            WebCrawlingConfig entity) {
                        return delegateDeleteNonstrict(entity);
                    }
                });
    }

    // ===================================================================================
    //                                                                        Batch Update
    //                                                                        ============
    /**
     * Batch insert the list. This method use 'Batch Update' of java.sql.PreparedStatement.
     * @param webCrawlingConfigList The list of the entity. (NotNull)
     * @return The array of inserted count.
     */
    public int[] batchInsert(List<WebCrawlingConfig> webCrawlingConfigList) {
        assertObjectNotNull("webCrawlingConfigList", webCrawlingConfigList);
        return delegateInsertList(webCrawlingConfigList);
    }

    /**
     * Batch update the list. All columns are update target. {NOT modified only} <br />
     * This method use 'Batch Update' of java.sql.PreparedStatement.
     * @param webCrawlingConfigList The list of the entity. (NotNull)
     * @return The array of updated count.
     * @exception org.seasar.dbflute.exception.BatchEntityAlreadyUpdatedException When the entity has already been updated. This exception extends EntityAlreadyUpdatedException.
     */
    public int[] batchUpdate(List<WebCrawlingConfig> webCrawlingConfigList) {
        assertObjectNotNull("webCrawlingConfigList", webCrawlingConfigList);
        return delegateUpdateList(webCrawlingConfigList);
    }

    /**
     * Batch update the list non-strictly. All columns are update target. {NOT modified only} <br />
     * This method use 'Batch Update' of java.sql.PreparedStatement.
     * @param webCrawlingConfigList The list of the entity. (NotNull)
     * @return The array of updated count.
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     */
    public int[] batchUpdateNonstrict(
            List<WebCrawlingConfig> webCrawlingConfigList) {
        assertObjectNotNull("webCrawlingConfigList", webCrawlingConfigList);
        return delegateUpdateListNonstrict(webCrawlingConfigList);
    }

    /**
     * Batch delete the list. <br />
     * This method use 'Batch Update' of java.sql.PreparedStatement.
     * @param webCrawlingConfigList The list of the entity. (NotNull)
     * @return The array of deleted count.
     * @exception org.seasar.dbflute.exception.BatchEntityAlreadyUpdatedException When the entity has already been updated. This exception extends EntityAlreadyUpdatedException.
     */
    public int[] batchDelete(List<WebCrawlingConfig> webCrawlingConfigList) {
        assertObjectNotNull("webCrawlingConfigList", webCrawlingConfigList);
        return delegateDeleteList(webCrawlingConfigList);
    }

    /**
     * Batch delete the list non-strictly. <br />
     * This method use 'Batch Update' of java.sql.PreparedStatement.
     * @param webCrawlingConfigList The list of the entity. (NotNull)
     * @return The array of deleted count.
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     */
    public int[] batchDeleteNonstrict(
            List<WebCrawlingConfig> webCrawlingConfigList) {
        assertObjectNotNull("webCrawlingConfigList", webCrawlingConfigList);
        return delegateDeleteListNonstrict(webCrawlingConfigList);
    }

    // ===================================================================================
    //                                                                        Query Update
    //                                                                        ============
    /**
     * Query update the several entities. {NoConcurrencyControl}
     * @param webCrawlingConfig Entity. (NotNull) {PrimaryKeyNotRequired}
     * @param cb Condition-bean. (NotNull)
     * @return The updated count.
     */
    public int queryUpdate(WebCrawlingConfig webCrawlingConfig,
            WebCrawlingConfigCB cb) {
        assertObjectNotNull("webCrawlingConfig", webCrawlingConfig);
        assertCBNotNull(cb);
        setupCommonColumnOfUpdateIfNeeds(webCrawlingConfig);
        filterEntityOfUpdate(webCrawlingConfig);
        assertEntityOfUpdate(webCrawlingConfig);
        return invoke(createQueryUpdateEntityCBCommand(webCrawlingConfig, cb));
    }

    /**
     * Query delete the several entities. {NoConcurrencyControl}
     * @param cb Condition-bean. (NotNull)
     * @return The deleted count.
     */
    public int queryDelete(WebCrawlingConfigCB cb) {
        assertCBNotNull(cb);
        return invoke(createQueryDeleteCBCommand(cb));
    }

    // ===================================================================================
    //                                                                     Delegate Method
    //                                                                     ===============
    // [Behavior Command]
    // -----------------------------------------------------
    //                                                Select
    //                                                ------
    protected int delegateSelectCount(WebCrawlingConfigCB cb) {
        return invoke(createSelectCountCBCommand(cb));
    }

    protected void delegateSelectCursor(WebCrawlingConfigCB cb,
            EntityRowHandler<WebCrawlingConfig> entityRowHandler) {
        invoke(createSelectCursorCBCommand(cb, entityRowHandler,
                WebCrawlingConfig.class));
    }

    protected int doCallReadCount(ConditionBean cb) {
        return delegateSelectCount((WebCrawlingConfigCB) cb);
    }

    protected List<WebCrawlingConfig> delegateSelectList(WebCrawlingConfigCB cb) {
        return invoke(createSelectListCBCommand(cb, WebCrawlingConfig.class));
    }

    @SuppressWarnings("unchecked")
    protected List<Entity> doCallReadList(ConditionBean cb) {
        return (List) delegateSelectList((WebCrawlingConfigCB) cb);
    }

    // -----------------------------------------------------
    //                                                Update
    //                                                ------
    protected int delegateInsert(WebCrawlingConfig e) {
        if (!processBeforeInsert(e)) {
            return 1;
        }
        return invoke(createInsertEntityCommand(e));
    }

    protected int doCallCreate(Entity entity) {
        return delegateInsert(downcast(entity));
    }

    protected int delegateUpdate(WebCrawlingConfig e) {
        if (!processBeforeUpdate(e)) {
            return 1;
        }
        return invoke(createUpdateEntityCommand(e));
    }

    protected int doCallModify(Entity entity) {
        return delegateUpdate(downcast(entity));
    }

    protected int delegateUpdateNonstrict(WebCrawlingConfig e) {
        if (!processBeforeUpdate(e)) {
            return 1;
        }
        return invoke(createUpdateNonstrictEntityCommand(e));
    }

    protected int delegateDelete(WebCrawlingConfig e) {
        if (!processBeforeDelete(e)) {
            return 1;
        }
        return invoke(createDeleteEntityCommand(e));
    }

    protected int doCallRemove(Entity entity) {
        return delegateDelete(downcast(entity));
    }

    protected int delegateDeleteNonstrict(WebCrawlingConfig e) {
        if (!processBeforeDelete(e)) {
            return 1;
        }
        return invoke(createDeleteNonstrictEntityCommand(e));
    }

    protected int[] delegateInsertList(List<WebCrawlingConfig> ls) {
        if (ls.isEmpty()) {
            return new int[] {};
        }
        return invoke(createBatchInsertEntityCommand(helpFilterBeforeInsertInternally(ls)));
    }

    @SuppressWarnings("unchecked")
    protected int[] doCreateList(List<Entity> ls) {
        return delegateInsertList((List) ls);
    }

    protected int[] delegateUpdateList(List<WebCrawlingConfig> ls) {
        if (ls.isEmpty()) {
            return new int[] {};
        }
        return invoke(createBatchUpdateEntityCommand(helpFilterBeforeUpdateInternally(ls)));
    }

    @SuppressWarnings("unchecked")
    protected int[] doModifyList(List<Entity> ls) {
        return delegateUpdateList((List) ls);
    }

    protected int[] delegateUpdateListNonstrict(List<WebCrawlingConfig> ls) {
        if (ls.isEmpty()) {
            return new int[] {};
        }
        return invoke(createBatchUpdateNonstrictEntityCommand(helpFilterBeforeUpdateInternally(ls)));
    }

    protected int[] delegateDeleteList(List<WebCrawlingConfig> ls) {
        if (ls.isEmpty()) {
            return new int[] {};
        }
        return invoke(createBatchDeleteEntityCommand(helpFilterBeforeDeleteInternally(ls)));
    }

    @SuppressWarnings("unchecked")
    protected int[] doRemoveList(List<Entity> ls) {
        return delegateDeleteList((List) ls);
    }

    protected int[] delegateDeleteListNonstrict(List<WebCrawlingConfig> ls) {
        if (ls.isEmpty()) {
            return new int[] {};
        }
        return invoke(createBatchDeleteNonstrictEntityCommand(helpFilterBeforeDeleteInternally(ls)));
    }

    // ===================================================================================
    //                                                                Optimistic Lock Info
    //                                                                ====================
    @Override
    protected boolean hasVersionNoValue(Entity entity) {
        return !(downcast(entity).getVersionNo() + "").equals("null");// For primitive type
    }

    @Override
    protected boolean hasUpdateDateValue(Entity entity) {
        return false;
    }

    // ===================================================================================
    //                                                                              Helper
    //                                                                              ======
    protected WebCrawlingConfig downcast(Entity entity) {
        return helpDowncastInternally(entity, WebCrawlingConfig.class);
    }
}
