/*
 * Copyright 2009-2012 the Fess Project and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */

package jp.sf.fess.db.bsbhv.pmbean;

import java.io.Serializable;
import java.util.Date;

import jp.sf.fess.db.allcommon.DBFluteConfig;
import jp.sf.fess.db.exbhv.ClickLogBhv;
import jp.sf.fess.db.exentity.customize.ClickUrlRanking;

import org.seasar.dbflute.cbean.SimplePagingBean;
import org.seasar.dbflute.cbean.coption.FromToOption;
import org.seasar.dbflute.jdbc.FetchBean;
import org.seasar.dbflute.jdbc.ParameterUtil;
import org.seasar.dbflute.jdbc.ParameterUtil.ShortCharHandlingMode;
import org.seasar.dbflute.outsidesql.typed.AutoPagingHandlingPmb;
import org.seasar.dbflute.outsidesql.typed.EntityHandlingPmb;
import org.seasar.dbflute.util.DfTypeUtil;

/**
 * The base class for typed parameter-bean of ClickUrlRanking. <br />
 * This is related to "<span style="color: #AD4747">selectClickUrlRanking</span>" on ClickLogBhv.
 * @author DBFlute(AutoGenerator)
 */
public class BsClickUrlRankingPmb extends SimplePagingBean implements
        EntityHandlingPmb<ClickLogBhv, ClickUrlRanking>,
        AutoPagingHandlingPmb<ClickLogBhv, ClickUrlRanking>, FetchBean,
        Serializable {

    // ===================================================================================
    //                                                                          Definition
    //                                                                          ==========
    /** Serial version UID. (Default) */
    private static final long serialVersionUID = 1L;

    // ===================================================================================
    //                                                                           Attribute
    //                                                                           =========
    /** The parameter of fromRequestedTime:fromDate. */
    protected Date _fromRequestedTime;

    /** The parameter of toRequestedTime:toDate. */
    protected Date _toRequestedTime;

    // ===================================================================================
    //                                                                         Constructor
    //                                                                         ===========
    /**
     * Constructor for the typed parameter-bean of ClickUrlRanking. <br />
     * This is related to "<span style="color: #AD4747">selectClickUrlRanking</span>" on ClickLogBhv.
     */
    public BsClickUrlRankingPmb() {
    }

    // ===================================================================================
    //                                                                Typed Implementation
    //                                                                ====================
    /**
     * {@inheritDoc}
     */
    @Override
    public String getOutsideSqlPath() {
        return "selectClickUrlRanking";
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public Class<ClickUrlRanking> getEntityType() {
        return ClickUrlRanking.class;
    }

    // ===================================================================================
    //                                                                       Assist Helper
    //                                                                       =============
    protected String filterStringParameter(final String value) {
        if (isEmptyStringParameterAllowed()) {
            return value;
        }
        return convertEmptyToNull(value);
    }

    protected boolean isEmptyStringParameterAllowed() {
        return DBFluteConfig.getInstance().isEmptyStringParameterAllowed();
    }

    protected String convertEmptyToNull(final String value) {
        return ParameterUtil.convertEmptyToNull(value);
    }

    protected String handleShortChar(final String propertyName,
            final String value, final Integer size) {
        final ShortCharHandlingMode mode = getShortCharHandlingMode(
                propertyName, value, size);
        return ParameterUtil.handleShortChar(propertyName, value, size, mode);
    }

    protected ShortCharHandlingMode getShortCharHandlingMode(
            final String propertyName, final String value, final Integer size) {
        return ShortCharHandlingMode.NONE;
    }

    @SuppressWarnings("unchecked")
    protected <NUMBER extends Number> NUMBER toNumber(final Object obj,
            final Class<NUMBER> type) {
        return (NUMBER) DfTypeUtil.toNumber(obj, type);
    }

    protected Boolean toBoolean(final Object obj) {
        return DfTypeUtil.toBoolean(obj);
    }

    protected Date toUtilDate(final Date date) {
        return DfTypeUtil.toDate(date); // if sub class, re-create as pure date
    }

    protected String formatUtilDate(final Date date) {
        final String pattern = "yyyy-MM-dd";
        return DfTypeUtil.toString(date, pattern);
    }

    protected String formatByteArray(final byte[] bytes) {
        return "byte["
                + (bytes != null ? String.valueOf(bytes.length) : "null") + "]";
    }

    // ===================================================================================
    //                                                                      Basic Override
    //                                                                      ==============
    /**
     * @return The display string of all parameters. (NotNull)
     */
    @Override
    public String toString() {
        final StringBuilder sb = new StringBuilder();
        sb.append(DfTypeUtil.toClassTitle(this)).append(":");
        sb.append(xbuildColumnString());
        return sb.toString();
    }

    private String xbuildColumnString() {
        final String c = ", ";
        final StringBuilder sb = new StringBuilder();
        sb.append(c).append(formatUtilDate(_fromRequestedTime));
        sb.append(c).append(formatUtilDate(_toRequestedTime));
        if (sb.length() > 0) {
            sb.delete(0, c.length());
        }
        sb.insert(0, "{").append("}");
        return sb.toString();
    }

    // ===================================================================================
    //                                                                            Accessor
    //                                                                            ========
    /**
     * [get] fromRequestedTime:fromDate
     * @return The value of fromRequestedTime. (Nullable, NotEmptyString(when String): if empty string, returns null)
     */
    public Date getFromRequestedTime() {
        return toUtilDate(_fromRequestedTime);
    }

    /**
     * [set as fromDate] fromRequestedTime:fromDate
     * @param fromRequestedTime The value of fromRequestedTime. (NullAllowed)
     */
    public void setFromRequestedTime_FromDate(final Date fromRequestedTime) {
        _fromRequestedTime = new FromToOption().compareAsDate().filterFromDate(
                fromRequestedTime);
    }

    /**
     * [get] toRequestedTime:toDate
     * @return The value of toRequestedTime. (Nullable, NotEmptyString(when String): if empty string, returns null)
     */
    public Date getToRequestedTime() {
        return toUtilDate(_toRequestedTime);
    }

    /**
     * [set as toDate] toRequestedTime:toDate
     * @param toRequestedTime The value of toRequestedTime. (NullAllowed)
     */
    public void setToRequestedTime_ToDate(final Date toRequestedTime) {
        _toRequestedTime = new FromToOption().compareAsDate().filterToDate(
                toRequestedTime);
    }

}
