/*
 * Copyright 2009-2010 the Fess Project and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */

package jp.sf.fess.crud.action.admin;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;

import jp.sf.fess.crud.CommonConstants;
import jp.sf.fess.crud.CrudMessageException;
import jp.sf.fess.crud.util.SAStrutsUtil;
import jp.sf.fess.db.exentity.BrowserType;
import jp.sf.fess.form.admin.BrowserTypeForm;
import jp.sf.fess.pager.BrowserTypePager;
import jp.sf.fess.service.BrowserTypeService;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.seasar.framework.beans.util.Beans;
import org.seasar.framework.util.StringUtil;
import org.seasar.struts.annotation.ActionForm;
import org.seasar.struts.annotation.Execute;
import org.seasar.struts.exception.ActionMessagesException;

public class BsBrowserTypeAction implements Serializable {

    private static final long serialVersionUID = 1L;

    private static final Log log = LogFactory.getLog(BsBrowserTypeAction.class);

    // for list

    public List<BrowserType> browserTypeItems;

    // for edit/confirm/delete

    @ActionForm
    @Resource
    protected BrowserTypeForm browserTypeForm;

    @Resource
    protected BrowserTypeService browserTypeService;

    @Resource
    protected BrowserTypePager browserTypePager;

    protected String displayList(boolean redirect) {
        // page navi
        browserTypeItems = browserTypeService
                .getBrowserTypeList(browserTypePager);

        // restore from pager
        Beans.copy(browserTypePager, browserTypeForm.searchParams).excludes(
                CommonConstants.PAGER_CONVERSION_RULE).execute();

        if (redirect) {
            return "index?redirect=true";
        } else {
            return "index.jsp";
        }
    }

    @Execute(validator = false, input = "error.jsp")
    public String index() {
        return displayList(false);
    }

    @Execute(validator = false, input = "error.jsp", urlPattern = "list/{pageNumber}")
    public String list() {
        // page navi
        if (StringUtil.isNotBlank(browserTypeForm.pageNumber)) {
            try {
                browserTypePager.setCurrentPageNumber(Integer
                        .parseInt(browserTypeForm.pageNumber));
            } catch (NumberFormatException e) {
                if (log.isDebugEnabled()) {
                    log
                            .debug("Invalid value: "
                                    + browserTypeForm.pageNumber, e);
                }
            }
        }

        return displayList(false);
    }

    @Execute(validator = false, input = "error.jsp")
    public String search() {
        Beans.copy(browserTypeForm.searchParams, browserTypePager).excludes(
                CommonConstants.PAGER_CONVERSION_RULE).execute();

        return displayList(false);
    }

    @Execute(validator = false, input = "error.jsp")
    public String reset() {
        browserTypePager.clear();

        return displayList(false);
    }

    @Execute(validator = false, input = "error.jsp")
    public String back() {
        return displayList(false);
    }

    @Execute(validator = false, input = "error.jsp")
    public String editagain() {
        return "edit.jsp";
    }

    @Execute(validator = false, input = "error.jsp", urlPattern = "confirmpage/{crudMode}/{id}")
    public String confirmpage() {
        if (browserTypeForm.crudMode != CommonConstants.CONFIRM_MODE) {
            throw new ActionMessagesException("errors.crud_invalid_mode",
                    new Object[] { CommonConstants.CONFIRM_MODE,
                            browserTypeForm.crudMode });
        }

        loadBrowserType();

        return "confirm.jsp";
    }

    @Execute(validator = false, input = "error.jsp")
    public String createpage() {
        // page navi
        browserTypeForm.initialize();
        browserTypeForm.crudMode = CommonConstants.CREATE_MODE;

        return "edit.jsp";
    }

    @Execute(validator = false, input = "error.jsp", urlPattern = "editpage/{crudMode}/{id}")
    public String editpage() {
        if (browserTypeForm.crudMode != CommonConstants.EDIT_MODE) {
            throw new ActionMessagesException("errors.crud_invalid_mode",
                    new Object[] { CommonConstants.EDIT_MODE,
                            browserTypeForm.crudMode });
        }

        loadBrowserType();

        return "edit.jsp";
    }

    @Execute(validator = false, input = "error.jsp")
    public String editfromconfirm() {
        browserTypeForm.crudMode = CommonConstants.EDIT_MODE;

        loadBrowserType();

        return "edit.jsp";
    }

    @Execute(validator = true, input = "edit.jsp")
    public String confirmfromcreate() {
        return "confirm.jsp";
    }

    @Execute(validator = true, input = "edit.jsp")
    public String confirmfromupdate() {
        return "confirm.jsp";
    }

    @Execute(validator = false, input = "error.jsp", urlPattern = "deletepage/{crudMode}/{id}")
    public String deletepage() {
        if (browserTypeForm.crudMode != CommonConstants.DELETE_MODE) {
            throw new ActionMessagesException("errors.crud_invalid_mode",
                    new Object[] { CommonConstants.DELETE_MODE,
                            browserTypeForm.crudMode });
        }

        loadBrowserType();

        return "confirm.jsp";
    }

    @Execute(validator = false, input = "error.jsp")
    public String deletefromconfirm() {
        browserTypeForm.crudMode = CommonConstants.DELETE_MODE;

        loadBrowserType();

        return "confirm.jsp";
    }

    @Execute(validator = true, input = "edit.jsp")
    public String create() {
        try {
            BrowserType browserType = createBrowserType();
            browserTypeService.store(browserType);
            SAStrutsUtil.addSessionMessage("success.crud_create_crud_table");

            return displayList(true);
        } catch (ActionMessagesException e) {
            log.error(e.getMessage(), e);
            throw e;
        } catch (CrudMessageException e) {
            log.error(e.getMessage(), e);
            throw new ActionMessagesException(e.getMessageId(), e.getArgs());
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            throw new ActionMessagesException(
                    "errors.crud_failed_to_create_crud_table");
        }
    }

    @Execute(validator = true, input = "edit.jsp")
    public String update() {
        try {
            BrowserType browserType = createBrowserType();
            browserTypeService.store(browserType);
            SAStrutsUtil.addSessionMessage("success.crud_update_crud_table");

            return displayList(true);
        } catch (ActionMessagesException e) {
            log.error(e.getMessage(), e);
            throw e;
        } catch (CrudMessageException e) {
            log.error(e.getMessage(), e);
            throw new ActionMessagesException(e.getMessageId(), e.getArgs());
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            throw new ActionMessagesException(
                    "errors.crud_failed_to_update_crud_table");
        }
    }

    @Execute(validator = false, input = "error.jsp")
    public String delete() {
        if (browserTypeForm.crudMode != CommonConstants.DELETE_MODE) {
            throw new ActionMessagesException("errors.crud_invalid_mode",
                    new Object[] { CommonConstants.DELETE_MODE,
                            browserTypeForm.crudMode });
        }

        try {
            BrowserType browserType = browserTypeService
                    .getBrowserType(createKeyMap());
            if (browserType == null) {
                // throw an exception
                throw new ActionMessagesException(
                        "errors.crud_could_not_find_crud_table",

                        new Object[] { browserTypeForm.id });

            }

            browserTypeService.delete(browserType);
            SAStrutsUtil.addSessionMessage("success.crud_delete_crud_table");

            return displayList(true);
        } catch (ActionMessagesException e) {
            log.error(e.getMessage(), e);
            throw e;
        } catch (CrudMessageException e) {
            log.error(e.getMessage(), e);
            throw new ActionMessagesException(e.getMessageId(), e.getArgs());
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            throw new ActionMessagesException(
                    "errors.crud_failed_to_delete_crud_table");
        }
    }

    protected void loadBrowserType() {

        BrowserType browserType = browserTypeService
                .getBrowserType(createKeyMap());
        if (browserType == null) {
            // throw an exception
            throw new ActionMessagesException(
                    "errors.crud_could_not_find_crud_table",

                    new Object[] { browserTypeForm.id });

        }

        Beans.copy(browserType, browserTypeForm).excludes("searchParams",
                "mode").execute();
    }

    protected BrowserType createBrowserType() {
        BrowserType browserType;
        if (browserTypeForm.crudMode == CommonConstants.EDIT_MODE) {
            browserType = browserTypeService.getBrowserType(createKeyMap());
            if (browserType == null) {
                // throw an exception
                throw new ActionMessagesException(
                        "errors.crud_could_not_find_crud_table",

                        new Object[] { browserTypeForm.id });

            }
        } else {
            browserType = new BrowserType();
        }
        Beans.copy(browserTypeForm, browserType).excludes("searchParams",
                "mode").execute();

        return browserType;
    }

    protected Map<String, String> createKeyMap() {
        Map<String, String> keys = new HashMap<String, String>();

        keys.put("id", browserTypeForm.id);

        return keys;
    }
}
