package jp.sf.fess.crud.form.admin;

import java.util.HashMap;
import java.util.Map;

import org.seasar.struts.annotation.DateType;
import org.seasar.struts.annotation.IntegerType;
import org.seasar.struts.annotation.LongType;
import org.seasar.struts.annotation.Required;

public abstract class BsRequestHeaderForm {
    @IntegerType
    public String pageNumber;

    public Map<String, String> searchParams = new HashMap<String, String>();

    @IntegerType
    public int crudMode;

    public String getCurrentPageNumber() {
        return pageNumber;
    }

    @Required(target = "confirmfromupdate,update,delete")
    @LongType
    public String id;

    @Required(target = "confirmfromupdate,update,delete")
    public String name;

    @Required(target = "confirmfromupdate,update,delete")
    public String value;

    @Required(target = "confirmfromupdate,update,delete")
    @LongType
    public String webCrawlingConfigId;

    @Required(target = "confirmfromupdate,update,delete")
    public String createdBy;

    @Required(target = "confirmfromupdate,update,delete")
    @DateType
    public String createdTime;

    public String updatedBy;

    @DateType
    public String updatedTime;

    public String deletedBy;

    @DateType
    public String deletedTime;

    @Required(target = "confirmfromupdate,update,delete")
    @IntegerType
    public String versionNo;

    public void initialize() {

        id = null;
        name = null;
        value = null;
        webCrawlingConfigId = null;
        createdBy = null;
        createdTime = null;
        updatedBy = null;
        updatedTime = null;
        deletedBy = null;
        deletedTime = null;
        versionNo = null;

    }

}
