/*
 * Copyright 2009-2010 the Fess Project and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */

package jp.sf.fess.db.bsbhv;

import java.util.List;

import jp.sf.fess.db.bsentity.dbmeta.RoleTypeDbm;
import jp.sf.fess.db.cbean.DataConfigToRoleTypeMappingCB;
import jp.sf.fess.db.cbean.FileConfigToRoleTypeMappingCB;
import jp.sf.fess.db.cbean.LabelTypeToRoleTypeMappingCB;
import jp.sf.fess.db.cbean.RoleTypeCB;
import jp.sf.fess.db.cbean.WebConfigToRoleTypeMappingCB;
import jp.sf.fess.db.exbhv.DataConfigToRoleTypeMappingBhv;
import jp.sf.fess.db.exbhv.FileConfigToRoleTypeMappingBhv;
import jp.sf.fess.db.exbhv.LabelTypeToRoleTypeMappingBhv;
import jp.sf.fess.db.exbhv.WebConfigToRoleTypeMappingBhv;
import jp.sf.fess.db.exentity.DataConfigToRoleTypeMapping;
import jp.sf.fess.db.exentity.FileConfigToRoleTypeMapping;
import jp.sf.fess.db.exentity.LabelTypeToRoleTypeMapping;
import jp.sf.fess.db.exentity.RoleType;
import jp.sf.fess.db.exentity.WebConfigToRoleTypeMapping;

import org.seasar.dbflute.Entity;
import org.seasar.dbflute.bhv.AbstractBehaviorWritable;
import org.seasar.dbflute.bhv.ConditionBeanSetupper;
import org.seasar.dbflute.bhv.LoadReferrerOption;
import org.seasar.dbflute.bhv.UpdateOption;
import org.seasar.dbflute.cbean.ConditionBean;
import org.seasar.dbflute.cbean.EntityRowHandler;
import org.seasar.dbflute.cbean.ListResultBean;
import org.seasar.dbflute.cbean.PagingResultBean;
import org.seasar.dbflute.dbmeta.DBMeta;

/**
 * The behavior of ROLE_TYPE as TABLE. <br />
 * <pre>
 * [primary-key]
 *     ID
 * 
 * [column]
 *     ID, NAME, VALUE, SORT_ORDER, CREATED_BY, CREATED_TIME, UPDATED_BY, UPDATED_TIME, DELETED_BY, DELETED_TIME, VERSION_NO
 * 
 * [sequence]
 *     
 * 
 * [identity]
 *     ID
 * 
 * [version-no]
 *     VERSION_NO
 * 
 * [foreign-table]
 *     
 * 
 * [referrer-table]
 *     DATA_CONFIG_TO_ROLE_TYPE_MAPPING, FILE_CONFIG_TO_ROLE_TYPE_MAPPING, LABEL_TYPE_TO_ROLE_TYPE_MAPPING, WEB_CONFIG_TO_ROLE_TYPE_MAPPING
 * 
 * [foreign-property]
 *     
 * 
 * [referrer-property]
 *     dataConfigToRoleTypeMappingList, fileConfigToRoleTypeMappingList, labelTypeToRoleTypeMappingList, webConfigToRoleTypeMappingList
 * </pre>
 * @author DBFlute(AutoGenerator)
 */
public abstract class BsRoleTypeBhv extends AbstractBehaviorWritable {

    // ===================================================================================
    //                                                                          Definition
    //                                                                          ==========
    /*df:BehaviorQueryPathBegin*/
    /*df:BehaviorQueryPathEnd*/

    // ===================================================================================
    //                                                                          Table name
    //                                                                          ==========
    /** @return The name on database of table. (NotNull) */
    public String getTableDbName() {
        return "ROLE_TYPE";
    }

    // ===================================================================================
    //                                                                              DBMeta
    //                                                                              ======
    /** @return The instance of DBMeta. (NotNull) */
    public DBMeta getDBMeta() {
        return RoleTypeDbm.getInstance();
    }

    /** @return The instance of DBMeta as my table type. (NotNull) */
    public RoleTypeDbm getMyDBMeta() {
        return RoleTypeDbm.getInstance();
    }

    // ===================================================================================
    //                                                                        New Instance
    //                                                                        ============
    /** {@inheritDoc} */
    public Entity newEntity() {
        return newMyEntity();
    }

    /** {@inheritDoc} */
    public ConditionBean newConditionBean() {
        return newMyConditionBean();
    }

    /** @return The instance of new entity as my table type. (NotNull) */
    public RoleType newMyEntity() {
        return new RoleType();
    }

    /** @return The instance of new condition-bean as my table type. (NotNull) */
    public RoleTypeCB newMyConditionBean() {
        return new RoleTypeCB();
    }

    // ===================================================================================
    //                                                                        Count Select
    //                                                                        ============
    /**
     * Select the count by the condition-bean. {IgnorePagingCondition}
     * <pre>
     * RoleTypeCB cb = new RoleTypeCB();
     * cb.query().setFoo...(value);
     * int count = roleTypeBhv.<span style="color: #FD4747">selectCount</span>(cb);
     * </pre>
     * @param cb The condition-bean of RoleType. (NotNull)
     * @return The selected count.
     */
    public int selectCount(RoleTypeCB cb) {
        return doSelectCount(cb);
    }

    protected int doSelectCount(RoleTypeCB cb) {
        assertCBNotNull(cb);
        return delegateSelectCount(cb);
    }

    @Override
    protected int doReadCount(ConditionBean cb) {
        return selectCount(downcast(cb));
    }

    // ===================================================================================
    //                                                                       Cursor Select
    //                                                                       =============
    /**
     * Select the cursor by the condition-bean.
     * <pre>
     * RoleTypeCB cb = new RoleTypeCB();
     * cb.query().setFoo...(value);
     * roleTypeBhv.<span style="color: #FD4747">selectCursor</span>(cb, new EntityRowHandler&lt;RoleType&gt;() {
     *     public void handle(RoleType entity) {
     *         ... = entity.getFoo...();
     *     }
     * });
     * </pre>
     * @param cb The condition-bean of RoleType. (NotNull)
     * @param entityRowHandler The handler of entity row of RoleType. (NotNull)
     */
    public void selectCursor(RoleTypeCB cb,
            EntityRowHandler<RoleType> entityRowHandler) {
        doSelectCursor(cb, entityRowHandler, RoleType.class);
    }

    protected <ENTITY extends RoleType> void doSelectCursor(RoleTypeCB cb,
            EntityRowHandler<ENTITY> entityRowHandler, Class<ENTITY> entityType) {
        assertCBNotNull(cb);
        assertObjectNotNull("entityRowHandler<RoleType>", entityRowHandler);
        assertObjectNotNull("entityType", entityType);
        assertSpecifyDerivedReferrerEntityProperty(cb, entityType);
        delegateSelectCursor(cb, entityRowHandler, entityType);
    }

    // ===================================================================================
    //                                                                       Entity Select
    //                                                                       =============
    /**
     * Select the entity by the condition-bean.
     * <pre>
     * RoleTypeCB cb = new RoleTypeCB();
     * cb.query().setFoo...(value);
     * RoleType roleType = roleTypeBhv.<span style="color: #FD4747">selectEntity</span>(cb);
     * if (roleType != null) {
     *     ... = roleType.get...();
     * } else {
     *     ...
     * }
     * </pre>
     * @param cb The condition-bean of RoleType. (NotNull)
     * @return The selected entity. (Nullable: If the condition has no data, it returns null)
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.SelectEntityConditionNotFoundException When the condition for selecting an entity is not found.
     */
    public RoleType selectEntity(RoleTypeCB cb) {
        return doSelectEntity(cb, RoleType.class);
    }

    protected <ENTITY extends RoleType> ENTITY doSelectEntity(
            final RoleTypeCB cb, final Class<ENTITY> entityType) {
        return helpSelectEntityInternally(cb,
                new InternalSelectEntityCallback<ENTITY, RoleTypeCB>() {
                    public List<ENTITY> callbackSelectList(RoleTypeCB cb) {
                        return doSelectList(cb, entityType);
                    }
                });
    }

    @Override
    protected Entity doReadEntity(ConditionBean cb) {
        return selectEntity(downcast(cb));
    }

    /**
     * Select the entity by the condition-bean with deleted check.
     * <pre>
     * RoleTypeCB cb = new RoleTypeCB();
     * cb.query().setFoo...(value);
     * RoleType roleType = roleTypeBhv.<span style="color: #FD4747">selectEntityWithDeletedCheck</span>(cb);
     * ... = roleType.get...(); <span style="color: #3F7E5E">// the entity always be not null</span>
     * </pre>
     * @param cb The condition-bean of RoleType. (NotNull)
     * @return The selected entity. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.SelectEntityConditionNotFoundException When the condition for selecting an entity is not found.
     */
    public RoleType selectEntityWithDeletedCheck(RoleTypeCB cb) {
        return doSelectEntityWithDeletedCheck(cb, RoleType.class);
    }

    protected <ENTITY extends RoleType> ENTITY doSelectEntityWithDeletedCheck(
            final RoleTypeCB cb, final Class<ENTITY> entityType) {
        return helpSelectEntityWithDeletedCheckInternally(
                cb,
                new InternalSelectEntityWithDeletedCheckCallback<ENTITY, RoleTypeCB>() {
                    public List<ENTITY> callbackSelectList(RoleTypeCB cb) {
                        return doSelectList(cb, entityType);
                    }
                });
    }

    @Override
    protected Entity doReadEntityWithDeletedCheck(ConditionBean cb) {
        return selectEntityWithDeletedCheck(downcast(cb));
    }

    /**
     * Select the entity by the primary-key value.
     * @param id The one of primary key. (NotNull)
     * @return The selected entity. (Nullable: If the primary-key value has no data, it returns null)
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.SelectEntityConditionNotFoundException When the condition for selecting an entity is not found.
     */
    public RoleType selectByPKValue(Long id) {
        return doSelectByPKValue(id, RoleType.class);
    }

    protected <ENTITY extends RoleType> ENTITY doSelectByPKValue(Long id,
            Class<ENTITY> entityType) {
        return doSelectEntity(buildPKCB(id), entityType);
    }

    /**
     * Select the entity by the primary-key value with deleted check.
     * @param id The one of primary key. (NotNull)
     * @return The selected entity. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.SelectEntityConditionNotFoundException When the condition for selecting an entity is not found.
     */
    public RoleType selectByPKValueWithDeletedCheck(Long id) {
        return doSelectByPKValueWithDeletedCheck(id, RoleType.class);
    }

    protected <ENTITY extends RoleType> ENTITY doSelectByPKValueWithDeletedCheck(
            Long id, Class<ENTITY> entityType) {
        return doSelectEntityWithDeletedCheck(buildPKCB(id), entityType);
    }

    private RoleTypeCB buildPKCB(Long id) {
        assertObjectNotNull("id", id);
        RoleTypeCB cb = newMyConditionBean();
        cb.query().setId_Equal(id);
        return cb;
    }

    // ===================================================================================
    //                                                                         List Select
    //                                                                         ===========
    /**
     * Select the list as result bean.
     * <pre>
     * RoleTypeCB cb = new RoleTypeCB();
     * cb.query().setFoo...(value);
     * cb.query().addOrderBy_Bar...();
     * ListResultBean&lt;RoleType&gt; roleTypeList = roleTypeBhv.<span style="color: #FD4747">selectList</span>(cb);
     * for (RoleType roleType : roleTypeList) {
     *     ... = roleType.get...();
     * }
     * </pre>
     * @param cb The condition-bean of RoleType. (NotNull)
     * @return The result bean of selected list. (NotNull)
     * @exception org.seasar.dbflute.exception.DangerousResultSizeException When the result size is over the specified safety size.
     */
    public ListResultBean<RoleType> selectList(RoleTypeCB cb) {
        return doSelectList(cb, RoleType.class);
    }

    protected <ENTITY extends RoleType> ListResultBean<ENTITY> doSelectList(
            RoleTypeCB cb, Class<ENTITY> entityType) {
        assertCBNotNull(cb);
        assertObjectNotNull("entityType", entityType);
        assertSpecifyDerivedReferrerEntityProperty(cb, entityType);
        return helpSelectListInternally(cb, entityType,
                new InternalSelectListCallback<ENTITY, RoleTypeCB>() {
                    public List<ENTITY> callbackSelectList(RoleTypeCB cb,
                            Class<ENTITY> entityType) {
                        return delegateSelectList(cb, entityType);
                    }
                });
    }

    @Override
    protected ListResultBean<? extends Entity> doReadList(ConditionBean cb) {
        return selectList(downcast(cb));
    }

    // ===================================================================================
    //                                                                         Page Select
    //                                                                         ===========
    /**
     * Select the page as result bean. <br />
     * (both count-select and paging-select are executed)
     * <pre>
     * RoleTypeCB cb = new RoleTypeCB();
     * cb.query().setFoo...(value);
     * cb.query().addOrderBy_Bar...();
     * cb.<span style="color: #FD4747">paging</span>(20, 3); <span style="color: #3F7E5E">// 20 records per a page and current page number is 3</span>
     * PagingResultBean&lt;RoleType&gt; page = roleTypeBhv.<span style="color: #FD4747">selectPage</span>(cb);
     * int allRecordCount = page.getAllRecordCount();
     * int allPageCount = page.getAllPageCount();
     * boolean isExistPrePage = page.isExistPrePage();
     * boolean isExistNextPage = page.isExistNextPage();
     * ...
     * for (RoleType roleType : page) {
     *     ... = roleType.get...();
     * }
     * </pre>
     * @param cb The condition-bean of RoleType. (NotNull)
     * @return The result bean of selected page. (NotNull)
     * @exception org.seasar.dbflute.exception.DangerousResultSizeException When the result size is over the specified safety size.
     */
    public PagingResultBean<RoleType> selectPage(RoleTypeCB cb) {
        return doSelectPage(cb, RoleType.class);
    }

    protected <ENTITY extends RoleType> PagingResultBean<ENTITY> doSelectPage(
            RoleTypeCB cb, Class<ENTITY> entityType) {
        assertCBNotNull(cb);
        assertObjectNotNull("entityType", entityType);
        return helpSelectPageInternally(cb, entityType,
                new InternalSelectPageCallback<ENTITY, RoleTypeCB>() {
                    public int callbackSelectCount(RoleTypeCB cb) {
                        return doSelectCount(cb);
                    }

                    public List<ENTITY> callbackSelectList(RoleTypeCB cb,
                            Class<ENTITY> entityType) {
                        return doSelectList(cb, entityType);
                    }
                });
    }

    @Override
    protected PagingResultBean<? extends Entity> doReadPage(ConditionBean cb) {
        return selectPage(downcast(cb));
    }

    // ===================================================================================
    //                                                                       Scalar Select
    //                                                                       =============
    /**
     * Select the scalar value derived by a function. <br />
     * You should call a function method after this method called like as follows:
     * <pre>
     * roleTypeBhv.<span style="color: #FD4747">scalarSelect</span>(Date.class).max(new ScalarQuery() {
     *     public void query(RoleTypeCB cb) {
     *         cb.specify().<span style="color: #FD4747">columnFooDatetime()</span>; <span style="color: #3F7E5E">// required for a function</span>
     *         cb.query().setBarName_PrefixSearch("S");
     *     }
     * });
     * </pre>
     * @param <RESULT> The type of result.
     * @param resultType The type of result. (NotNull)
     * @return The scalar value derived by a function. (Nullable)
     */
    public <RESULT> SLFunction<RoleTypeCB, RESULT> scalarSelect(
            Class<RESULT> resultType) {
        return doScalarSelect(resultType, newMyConditionBean());
    }

    protected <RESULT, CB extends RoleTypeCB> SLFunction<CB, RESULT> doScalarSelect(
            Class<RESULT> resultType, CB cb) {
        assertObjectNotNull("resultType", resultType);
        assertCBNotNull(cb);
        cb.xsetupForScalarSelect();
        cb.getSqlClause().disableSelectIndex(); // for when you use union
        return new SLFunction<CB, RESULT>(cb, resultType);
    }

    // ===================================================================================
    //                                                                            Sequence
    //                                                                            ========
    @Override
    protected Number doReadNextVal() {
        String msg = "This table is NOT related to sequence: "
                + getTableDbName();
        throw new UnsupportedOperationException(msg);
    }

    // ===================================================================================
    //                                                                       Load Referrer
    //                                                                       =============
    /**
     * {Refer to overload method that has an argument of the list of entity.}
     * @param roleType The entity of roleType. (NotNull)
     * @param conditionBeanSetupper The instance of referrer condition-bean set-upper for registering referrer condition. (NotNull)
     */
    public void loadDataConfigToRoleTypeMappingList(
            RoleType roleType,
            ConditionBeanSetupper<DataConfigToRoleTypeMappingCB> conditionBeanSetupper) {
        xassLRArg(roleType, conditionBeanSetupper);
        loadDataConfigToRoleTypeMappingList(xnewLRLs(roleType),
                conditionBeanSetupper);
    }

    /**
     * Load referrer of dataConfigToRoleTypeMappingList with the set-upper for condition-bean of referrer.
     * <pre>
     * roleTypeBhv.<span style="color: #FD4747">loadDataConfigToRoleTypeMappingList</span>(roleTypeList, new ConditionBeanSetupper&lt;DataConfigToRoleTypeMappingCB&gt;() {
     *     public void setup(DataConfigToRoleTypeMappingCB cb) {
     *         cb.setupSelect...();
     *         cb.query().setFoo...(value);
     *         cb.query().addOrderBy_Bar...(); <span style="color: #3F7E5E">// basically you should order referrer list</span>
     *     }
     * });
     * for (RoleType roleType : roleTypeList) {
     *     ... = roleType.<span style="color: #FD4747">getDataConfigToRoleTypeMappingList()</span>;
     * }
     * </pre>
     * About internal policy, the value of primary key(and others too) is treated as case-insensitive. <br />
     * The condition-bean that the set-upper provides have settings before you touch it. It is as follows:
     * <pre>
     * cb.query().setRoleTypeId_InScope(pkList);
     * cb.query().addOrderBy_RoleTypeId_Asc();
     * </pre>
     * @param roleTypeList The entity list of roleType. (NotNull)
     * @param conditionBeanSetupper The instance of referrer condition-bean set-upper for registering referrer condition. (NotNull)
     */
    public void loadDataConfigToRoleTypeMappingList(
            List<RoleType> roleTypeList,
            ConditionBeanSetupper<DataConfigToRoleTypeMappingCB> conditionBeanSetupper) {
        xassLRArg(roleTypeList, conditionBeanSetupper);
        loadDataConfigToRoleTypeMappingList(
                roleTypeList,
                new LoadReferrerOption<DataConfigToRoleTypeMappingCB, DataConfigToRoleTypeMapping>(
                        conditionBeanSetupper));
    }

    /**
     * {Refer to overload method that has an argument of the list of entity.}
     * @param roleType The entity of roleType. (NotNull)
     * @param loadReferrerOption The option of load-referrer. (NotNull)
     */
    public void loadDataConfigToRoleTypeMappingList(
            RoleType roleType,
            LoadReferrerOption<DataConfigToRoleTypeMappingCB, DataConfigToRoleTypeMapping> loadReferrerOption) {
        xassLRArg(roleType, loadReferrerOption);
        loadDataConfigToRoleTypeMappingList(xnewLRLs(roleType),
                loadReferrerOption);
    }

    /**
     * {Refer to overload method that has an argument of condition-bean setupper.}
     * @param roleTypeList The entity list of roleType. (NotNull)
     * @param loadReferrerOption The option of load-referrer. (NotNull)
     */
    public void loadDataConfigToRoleTypeMappingList(
            List<RoleType> roleTypeList,
            LoadReferrerOption<DataConfigToRoleTypeMappingCB, DataConfigToRoleTypeMapping> loadReferrerOption) {
        xassLRArg(roleTypeList, loadReferrerOption);
        if (roleTypeList.isEmpty()) {
            return;
        }
        final DataConfigToRoleTypeMappingBhv referrerBhv = xgetBSFLR().select(
                DataConfigToRoleTypeMappingBhv.class);
        helpLoadReferrerInternally(
                roleTypeList,
                loadReferrerOption,
                new InternalLoadReferrerCallback<RoleType, Long, DataConfigToRoleTypeMappingCB, DataConfigToRoleTypeMapping>() {
                    public Long getPKVal(RoleType e) {
                        return e.getId();
                    }

                    public void setRfLs(RoleType e,
                            List<DataConfigToRoleTypeMapping> ls) {
                        e.setDataConfigToRoleTypeMappingList(ls);
                    }

                    public DataConfigToRoleTypeMappingCB newMyCB() {
                        return referrerBhv.newMyConditionBean();
                    }

                    public void qyFKIn(DataConfigToRoleTypeMappingCB cb,
                            List<Long> ls) {
                        cb.query().setRoleTypeId_InScope(ls);
                    }

                    public void qyOdFKAsc(DataConfigToRoleTypeMappingCB cb) {
                        cb.query().addOrderBy_RoleTypeId_Asc();
                    }

                    public List<DataConfigToRoleTypeMapping> selRfLs(
                            DataConfigToRoleTypeMappingCB cb) {
                        return referrerBhv.selectList(cb);
                    }

                    public Long getFKVal(DataConfigToRoleTypeMapping e) {
                        return e.getRoleTypeId();
                    }

                    public void setlcEt(DataConfigToRoleTypeMapping re,
                            RoleType le) {
                        re.setRoleType(le);
                    }
                });
    }

    /**
     * {Refer to overload method that has an argument of the list of entity.}
     * @param roleType The entity of roleType. (NotNull)
     * @param conditionBeanSetupper The instance of referrer condition-bean set-upper for registering referrer condition. (NotNull)
     */
    public void loadFileConfigToRoleTypeMappingList(
            RoleType roleType,
            ConditionBeanSetupper<FileConfigToRoleTypeMappingCB> conditionBeanSetupper) {
        xassLRArg(roleType, conditionBeanSetupper);
        loadFileConfigToRoleTypeMappingList(xnewLRLs(roleType),
                conditionBeanSetupper);
    }

    /**
     * Load referrer of fileConfigToRoleTypeMappingList with the set-upper for condition-bean of referrer.
     * <pre>
     * roleTypeBhv.<span style="color: #FD4747">loadFileConfigToRoleTypeMappingList</span>(roleTypeList, new ConditionBeanSetupper&lt;FileConfigToRoleTypeMappingCB&gt;() {
     *     public void setup(FileConfigToRoleTypeMappingCB cb) {
     *         cb.setupSelect...();
     *         cb.query().setFoo...(value);
     *         cb.query().addOrderBy_Bar...(); <span style="color: #3F7E5E">// basically you should order referrer list</span>
     *     }
     * });
     * for (RoleType roleType : roleTypeList) {
     *     ... = roleType.<span style="color: #FD4747">getFileConfigToRoleTypeMappingList()</span>;
     * }
     * </pre>
     * About internal policy, the value of primary key(and others too) is treated as case-insensitive. <br />
     * The condition-bean that the set-upper provides have settings before you touch it. It is as follows:
     * <pre>
     * cb.query().setRoleTypeId_InScope(pkList);
     * cb.query().addOrderBy_RoleTypeId_Asc();
     * </pre>
     * @param roleTypeList The entity list of roleType. (NotNull)
     * @param conditionBeanSetupper The instance of referrer condition-bean set-upper for registering referrer condition. (NotNull)
     */
    public void loadFileConfigToRoleTypeMappingList(
            List<RoleType> roleTypeList,
            ConditionBeanSetupper<FileConfigToRoleTypeMappingCB> conditionBeanSetupper) {
        xassLRArg(roleTypeList, conditionBeanSetupper);
        loadFileConfigToRoleTypeMappingList(
                roleTypeList,
                new LoadReferrerOption<FileConfigToRoleTypeMappingCB, FileConfigToRoleTypeMapping>(
                        conditionBeanSetupper));
    }

    /**
     * {Refer to overload method that has an argument of the list of entity.}
     * @param roleType The entity of roleType. (NotNull)
     * @param loadReferrerOption The option of load-referrer. (NotNull)
     */
    public void loadFileConfigToRoleTypeMappingList(
            RoleType roleType,
            LoadReferrerOption<FileConfigToRoleTypeMappingCB, FileConfigToRoleTypeMapping> loadReferrerOption) {
        xassLRArg(roleType, loadReferrerOption);
        loadFileConfigToRoleTypeMappingList(xnewLRLs(roleType),
                loadReferrerOption);
    }

    /**
     * {Refer to overload method that has an argument of condition-bean setupper.}
     * @param roleTypeList The entity list of roleType. (NotNull)
     * @param loadReferrerOption The option of load-referrer. (NotNull)
     */
    public void loadFileConfigToRoleTypeMappingList(
            List<RoleType> roleTypeList,
            LoadReferrerOption<FileConfigToRoleTypeMappingCB, FileConfigToRoleTypeMapping> loadReferrerOption) {
        xassLRArg(roleTypeList, loadReferrerOption);
        if (roleTypeList.isEmpty()) {
            return;
        }
        final FileConfigToRoleTypeMappingBhv referrerBhv = xgetBSFLR().select(
                FileConfigToRoleTypeMappingBhv.class);
        helpLoadReferrerInternally(
                roleTypeList,
                loadReferrerOption,
                new InternalLoadReferrerCallback<RoleType, Long, FileConfigToRoleTypeMappingCB, FileConfigToRoleTypeMapping>() {
                    public Long getPKVal(RoleType e) {
                        return e.getId();
                    }

                    public void setRfLs(RoleType e,
                            List<FileConfigToRoleTypeMapping> ls) {
                        e.setFileConfigToRoleTypeMappingList(ls);
                    }

                    public FileConfigToRoleTypeMappingCB newMyCB() {
                        return referrerBhv.newMyConditionBean();
                    }

                    public void qyFKIn(FileConfigToRoleTypeMappingCB cb,
                            List<Long> ls) {
                        cb.query().setRoleTypeId_InScope(ls);
                    }

                    public void qyOdFKAsc(FileConfigToRoleTypeMappingCB cb) {
                        cb.query().addOrderBy_RoleTypeId_Asc();
                    }

                    public List<FileConfigToRoleTypeMapping> selRfLs(
                            FileConfigToRoleTypeMappingCB cb) {
                        return referrerBhv.selectList(cb);
                    }

                    public Long getFKVal(FileConfigToRoleTypeMapping e) {
                        return e.getRoleTypeId();
                    }

                    public void setlcEt(FileConfigToRoleTypeMapping re,
                            RoleType le) {
                        re.setRoleType(le);
                    }
                });
    }

    /**
     * {Refer to overload method that has an argument of the list of entity.}
     * @param roleType The entity of roleType. (NotNull)
     * @param conditionBeanSetupper The instance of referrer condition-bean set-upper for registering referrer condition. (NotNull)
     */
    public void loadLabelTypeToRoleTypeMappingList(
            RoleType roleType,
            ConditionBeanSetupper<LabelTypeToRoleTypeMappingCB> conditionBeanSetupper) {
        xassLRArg(roleType, conditionBeanSetupper);
        loadLabelTypeToRoleTypeMappingList(xnewLRLs(roleType),
                conditionBeanSetupper);
    }

    /**
     * Load referrer of labelTypeToRoleTypeMappingList with the set-upper for condition-bean of referrer.
     * <pre>
     * roleTypeBhv.<span style="color: #FD4747">loadLabelTypeToRoleTypeMappingList</span>(roleTypeList, new ConditionBeanSetupper&lt;LabelTypeToRoleTypeMappingCB&gt;() {
     *     public void setup(LabelTypeToRoleTypeMappingCB cb) {
     *         cb.setupSelect...();
     *         cb.query().setFoo...(value);
     *         cb.query().addOrderBy_Bar...(); <span style="color: #3F7E5E">// basically you should order referrer list</span>
     *     }
     * });
     * for (RoleType roleType : roleTypeList) {
     *     ... = roleType.<span style="color: #FD4747">getLabelTypeToRoleTypeMappingList()</span>;
     * }
     * </pre>
     * About internal policy, the value of primary key(and others too) is treated as case-insensitive. <br />
     * The condition-bean that the set-upper provides have settings before you touch it. It is as follows:
     * <pre>
     * cb.query().setRoleTypeId_InScope(pkList);
     * cb.query().addOrderBy_RoleTypeId_Asc();
     * </pre>
     * @param roleTypeList The entity list of roleType. (NotNull)
     * @param conditionBeanSetupper The instance of referrer condition-bean set-upper for registering referrer condition. (NotNull)
     */
    public void loadLabelTypeToRoleTypeMappingList(
            List<RoleType> roleTypeList,
            ConditionBeanSetupper<LabelTypeToRoleTypeMappingCB> conditionBeanSetupper) {
        xassLRArg(roleTypeList, conditionBeanSetupper);
        loadLabelTypeToRoleTypeMappingList(
                roleTypeList,
                new LoadReferrerOption<LabelTypeToRoleTypeMappingCB, LabelTypeToRoleTypeMapping>(
                        conditionBeanSetupper));
    }

    /**
     * {Refer to overload method that has an argument of the list of entity.}
     * @param roleType The entity of roleType. (NotNull)
     * @param loadReferrerOption The option of load-referrer. (NotNull)
     */
    public void loadLabelTypeToRoleTypeMappingList(
            RoleType roleType,
            LoadReferrerOption<LabelTypeToRoleTypeMappingCB, LabelTypeToRoleTypeMapping> loadReferrerOption) {
        xassLRArg(roleType, loadReferrerOption);
        loadLabelTypeToRoleTypeMappingList(xnewLRLs(roleType),
                loadReferrerOption);
    }

    /**
     * {Refer to overload method that has an argument of condition-bean setupper.}
     * @param roleTypeList The entity list of roleType. (NotNull)
     * @param loadReferrerOption The option of load-referrer. (NotNull)
     */
    public void loadLabelTypeToRoleTypeMappingList(
            List<RoleType> roleTypeList,
            LoadReferrerOption<LabelTypeToRoleTypeMappingCB, LabelTypeToRoleTypeMapping> loadReferrerOption) {
        xassLRArg(roleTypeList, loadReferrerOption);
        if (roleTypeList.isEmpty()) {
            return;
        }
        final LabelTypeToRoleTypeMappingBhv referrerBhv = xgetBSFLR().select(
                LabelTypeToRoleTypeMappingBhv.class);
        helpLoadReferrerInternally(
                roleTypeList,
                loadReferrerOption,
                new InternalLoadReferrerCallback<RoleType, Long, LabelTypeToRoleTypeMappingCB, LabelTypeToRoleTypeMapping>() {
                    public Long getPKVal(RoleType e) {
                        return e.getId();
                    }

                    public void setRfLs(RoleType e,
                            List<LabelTypeToRoleTypeMapping> ls) {
                        e.setLabelTypeToRoleTypeMappingList(ls);
                    }

                    public LabelTypeToRoleTypeMappingCB newMyCB() {
                        return referrerBhv.newMyConditionBean();
                    }

                    public void qyFKIn(LabelTypeToRoleTypeMappingCB cb,
                            List<Long> ls) {
                        cb.query().setRoleTypeId_InScope(ls);
                    }

                    public void qyOdFKAsc(LabelTypeToRoleTypeMappingCB cb) {
                        cb.query().addOrderBy_RoleTypeId_Asc();
                    }

                    public List<LabelTypeToRoleTypeMapping> selRfLs(
                            LabelTypeToRoleTypeMappingCB cb) {
                        return referrerBhv.selectList(cb);
                    }

                    public Long getFKVal(LabelTypeToRoleTypeMapping e) {
                        return e.getRoleTypeId();
                    }

                    public void setlcEt(LabelTypeToRoleTypeMapping re,
                            RoleType le) {
                        re.setRoleType(le);
                    }
                });
    }

    /**
     * {Refer to overload method that has an argument of the list of entity.}
     * @param roleType The entity of roleType. (NotNull)
     * @param conditionBeanSetupper The instance of referrer condition-bean set-upper for registering referrer condition. (NotNull)
     */
    public void loadWebConfigToRoleTypeMappingList(
            RoleType roleType,
            ConditionBeanSetupper<WebConfigToRoleTypeMappingCB> conditionBeanSetupper) {
        xassLRArg(roleType, conditionBeanSetupper);
        loadWebConfigToRoleTypeMappingList(xnewLRLs(roleType),
                conditionBeanSetupper);
    }

    /**
     * Load referrer of webConfigToRoleTypeMappingList with the set-upper for condition-bean of referrer.
     * <pre>
     * roleTypeBhv.<span style="color: #FD4747">loadWebConfigToRoleTypeMappingList</span>(roleTypeList, new ConditionBeanSetupper&lt;WebConfigToRoleTypeMappingCB&gt;() {
     *     public void setup(WebConfigToRoleTypeMappingCB cb) {
     *         cb.setupSelect...();
     *         cb.query().setFoo...(value);
     *         cb.query().addOrderBy_Bar...(); <span style="color: #3F7E5E">// basically you should order referrer list</span>
     *     }
     * });
     * for (RoleType roleType : roleTypeList) {
     *     ... = roleType.<span style="color: #FD4747">getWebConfigToRoleTypeMappingList()</span>;
     * }
     * </pre>
     * About internal policy, the value of primary key(and others too) is treated as case-insensitive. <br />
     * The condition-bean that the set-upper provides have settings before you touch it. It is as follows:
     * <pre>
     * cb.query().setRoleTypeId_InScope(pkList);
     * cb.query().addOrderBy_RoleTypeId_Asc();
     * </pre>
     * @param roleTypeList The entity list of roleType. (NotNull)
     * @param conditionBeanSetupper The instance of referrer condition-bean set-upper for registering referrer condition. (NotNull)
     */
    public void loadWebConfigToRoleTypeMappingList(
            List<RoleType> roleTypeList,
            ConditionBeanSetupper<WebConfigToRoleTypeMappingCB> conditionBeanSetupper) {
        xassLRArg(roleTypeList, conditionBeanSetupper);
        loadWebConfigToRoleTypeMappingList(
                roleTypeList,
                new LoadReferrerOption<WebConfigToRoleTypeMappingCB, WebConfigToRoleTypeMapping>(
                        conditionBeanSetupper));
    }

    /**
     * {Refer to overload method that has an argument of the list of entity.}
     * @param roleType The entity of roleType. (NotNull)
     * @param loadReferrerOption The option of load-referrer. (NotNull)
     */
    public void loadWebConfigToRoleTypeMappingList(
            RoleType roleType,
            LoadReferrerOption<WebConfigToRoleTypeMappingCB, WebConfigToRoleTypeMapping> loadReferrerOption) {
        xassLRArg(roleType, loadReferrerOption);
        loadWebConfigToRoleTypeMappingList(xnewLRLs(roleType),
                loadReferrerOption);
    }

    /**
     * {Refer to overload method that has an argument of condition-bean setupper.}
     * @param roleTypeList The entity list of roleType. (NotNull)
     * @param loadReferrerOption The option of load-referrer. (NotNull)
     */
    public void loadWebConfigToRoleTypeMappingList(
            List<RoleType> roleTypeList,
            LoadReferrerOption<WebConfigToRoleTypeMappingCB, WebConfigToRoleTypeMapping> loadReferrerOption) {
        xassLRArg(roleTypeList, loadReferrerOption);
        if (roleTypeList.isEmpty()) {
            return;
        }
        final WebConfigToRoleTypeMappingBhv referrerBhv = xgetBSFLR().select(
                WebConfigToRoleTypeMappingBhv.class);
        helpLoadReferrerInternally(
                roleTypeList,
                loadReferrerOption,
                new InternalLoadReferrerCallback<RoleType, Long, WebConfigToRoleTypeMappingCB, WebConfigToRoleTypeMapping>() {
                    public Long getPKVal(RoleType e) {
                        return e.getId();
                    }

                    public void setRfLs(RoleType e,
                            List<WebConfigToRoleTypeMapping> ls) {
                        e.setWebConfigToRoleTypeMappingList(ls);
                    }

                    public WebConfigToRoleTypeMappingCB newMyCB() {
                        return referrerBhv.newMyConditionBean();
                    }

                    public void qyFKIn(WebConfigToRoleTypeMappingCB cb,
                            List<Long> ls) {
                        cb.query().setRoleTypeId_InScope(ls);
                    }

                    public void qyOdFKAsc(WebConfigToRoleTypeMappingCB cb) {
                        cb.query().addOrderBy_RoleTypeId_Asc();
                    }

                    public List<WebConfigToRoleTypeMapping> selRfLs(
                            WebConfigToRoleTypeMappingCB cb) {
                        return referrerBhv.selectList(cb);
                    }

                    public Long getFKVal(WebConfigToRoleTypeMapping e) {
                        return e.getRoleTypeId();
                    }

                    public void setlcEt(WebConfigToRoleTypeMapping re,
                            RoleType le) {
                        re.setRoleType(le);
                    }
                });
    }

    // ===================================================================================
    //                                                                    Pull out Foreign
    //                                                                    ================

    // ===================================================================================
    //                                                                       Entity Update
    //                                                                       =============
    /**
     * Insert the entity.
     * <pre>
     * RoleType roleType = new RoleType();
     * <span style="color: #3F7E5E">// if auto-increment, you don't need to set the PK value</span>
     * roleType.setFoo...(value);
     * roleType.setBar...(value);
     * roleTypeBhv.<span style="color: #FD4747">insert</span>(roleType);
     * ... = roleType.getPK...(); <span style="color: #3F7E5E">// if auto-increment, you can get the value after</span>
     * </pre>
     * @param roleType The entity of insert target. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void insert(RoleType roleType) {
        assertEntityNotNull(roleType);
        delegateInsert(roleType);
    }

    @Override
    protected void doCreate(Entity entity) {
        insert(downcast(entity));
    }

    /**
     * Update the entity modified-only. {UpdateCountZeroException, ExclusiveControl}
     * <pre>
     * RoleType roleType = new RoleType();
     * roleType.setPK...(value); <span style="color: #3F7E5E">// required</span>
     * roleType.setFoo...(value); <span style="color: #3F7E5E">// you should set only modified columns</span>
     * <span style="color: #3F7E5E">// if exclusive control, the value of exclusive control column is required</span>
     * roleType.<span style="color: #FD4747">setVersionNo</span>(value);
     * try {
     *     roleTypeBhv.<span style="color: #FD4747">update</span>(roleType);
     * } catch (EntityAlreadyUpdatedException e) { <span style="color: #3F7E5E">// if concurrent update</span>
     *     ...
     * } 
     * </pre>
     * @param roleType The entity of update target. (NotNull) {PrimaryKeyRequired, ConcurrencyColumnRequired}
     * @exception org.seasar.dbflute.exception.EntityAlreadyUpdatedException When the entity has already been updated.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void update(final RoleType roleType) {
        helpUpdateInternally(roleType, new InternalUpdateCallback<RoleType>() {
            public int callbackDelegateUpdate(RoleType entity) {
                return delegateUpdate(entity);
            }
        });
    }

    @Override
    protected void doModify(Entity entity) {
        update(downcast(entity));
    }

    /**
     * Update the entity non-strictly modified-only. {UpdateCountZeroException, NonExclusiveControl}
     * <pre>
     * RoleType roleType = new RoleType();
     * roleType.setPK...(value); <span style="color: #3F7E5E">// required</span>
     * roleType.setFoo...(value); <span style="color: #3F7E5E">// you should set only modified columns</span>
     * <span style="color: #3F7E5E">// you don't need to set the value of exclusive control column</span>
     * <span style="color: #3F7E5E">// (auto-increment for version number is valid though non-exclusive control)</span>
     * <span style="color: #3F7E5E">//roleType.setVersionNo(value);</span>
     * roleTypeBhv.<span style="color: #FD4747">updateNonstrict</span>(roleType);
     * </pre>
     * @param roleType The entity of update target. (NotNull) {PrimaryKeyRequired}
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void updateNonstrict(final RoleType roleType) {
        helpUpdateNonstrictInternally(roleType,
                new InternalUpdateNonstrictCallback<RoleType>() {
                    public int callbackDelegateUpdateNonstrict(RoleType entity) {
                        return delegateUpdateNonstrict(entity);
                    }
                });
    }

    @Override
    protected void doModifyNonstrict(Entity entity) {
        updateNonstrict(downcast(entity));
    }

    /**
     * Insert or update the entity modified-only. {ExclusiveControl(when update)}
     * @param roleType The entity of insert or update target. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyUpdatedException When the entity has already been updated.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void insertOrUpdate(final RoleType roleType) {
        helpInsertOrUpdateInternally(roleType,
                new InternalInsertOrUpdateCallback<RoleType, RoleTypeCB>() {
                    public void callbackInsert(RoleType entity) {
                        insert(entity);
                    }

                    public void callbackUpdate(RoleType entity) {
                        update(entity);
                    }

                    public RoleTypeCB callbackNewMyConditionBean() {
                        return newMyConditionBean();
                    }

                    public int callbackSelectCount(RoleTypeCB cb) {
                        return selectCount(cb);
                    }
                });
    }

    @Override
    protected void doCreateOrUpdate(Entity entity) {
        insertOrUpdate(downcast(entity));
    }

    /**
     * Insert or update the entity non-strictly modified-only. {NonExclusiveControl(when update)}
     * @param roleType The entity of insert or update target. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void insertOrUpdateNonstrict(RoleType roleType) {
        helpInsertOrUpdateInternally(roleType,
                new InternalInsertOrUpdateNonstrictCallback<RoleType>() {
                    public void callbackInsert(RoleType entity) {
                        insert(entity);
                    }

                    public void callbackUpdateNonstrict(RoleType entity) {
                        updateNonstrict(entity);
                    }
                });
    }

    @Override
    protected void doCreateOrUpdateNonstrict(Entity entity) {
        insertOrUpdateNonstrict(downcast(entity));
    }

    /**
     * Delete the entity. {UpdateCountZeroException, ExclusiveControl}
     * <pre>
     * RoleType roleType = new RoleType();
     * roleType.setPK...(value); <span style="color: #3F7E5E">// required</span>
     * <span style="color: #3F7E5E">// if exclusive control, the value of exclusive control column is required</span>
     * roleType.<span style="color: #FD4747">setVersionNo</span>(value);
     * try {
     *     roleTypeBhv.<span style="color: #FD4747">delete</span>(roleType);
     * } catch (EntityAlreadyUpdatedException e) { <span style="color: #3F7E5E">// if concurrent update</span>
     *     ...
     * } 
     * </pre>
     * @param roleType The entity of delete target. (NotNull) {PrimaryKeyRequired, ConcurrencyColumnRequired}
     * @exception org.seasar.dbflute.exception.EntityAlreadyUpdatedException When the entity has already been updated.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     */
    public void delete(RoleType roleType) {
        helpDeleteInternally(roleType, new InternalDeleteCallback<RoleType>() {
            public int callbackDelegateDelete(RoleType entity) {
                return delegateDelete(entity);
            }
        });
    }

    @Override
    protected void doRemove(Entity entity) {
        delete(downcast(entity));
    }

    /**
     * Delete the entity non-strictly. {UpdateCountZeroException, NonExclusiveControl}
     * <pre>
     * RoleType roleType = new RoleType();
     * roleType.setPK...(value); <span style="color: #3F7E5E">// required</span>
     * <span style="color: #3F7E5E">// you don't need to set the value of exclusive control column</span>
     * <span style="color: #3F7E5E">// (auto-increment for version number is valid though non-exclusive control)</span>
     * <span style="color: #3F7E5E">//roleType.setVersionNo(value);</span>
     * roleTypeBhv.<span style="color: #FD4747">deleteNonstrict</span>(roleType);
     * </pre>
     * @param roleType Entity. (NotNull) {PrimaryKeyRequired}
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     */
    public void deleteNonstrict(RoleType roleType) {
        helpDeleteNonstrictInternally(roleType,
                new InternalDeleteNonstrictCallback<RoleType>() {
                    public int callbackDelegateDeleteNonstrict(RoleType entity) {
                        return delegateDeleteNonstrict(entity);
                    }
                });
    }

    /**
     * Delete the entity non-strictly ignoring deleted. {UpdateCountZeroException, NonExclusiveControl}
     * <pre>
     * RoleType roleType = new RoleType();
     * roleType.setPK...(value); <span style="color: #3F7E5E">// required</span>
     * <span style="color: #3F7E5E">// you don't need to set the value of exclusive control column</span>
     * <span style="color: #3F7E5E">// (auto-increment for version number is valid though non-exclusive control)</span>
     * <span style="color: #3F7E5E">//roleType.setVersionNo(value);</span>
     * roleTypeBhv.<span style="color: #FD4747">deleteNonstrictIgnoreDeleted</span>(roleType);
     * <span style="color: #3F7E5E">// if the target entity doesn't exist, no exception</span>
     * </pre>
     * @param roleType Entity. (NotNull) {PrimaryKeyRequired}
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     */
    public void deleteNonstrictIgnoreDeleted(RoleType roleType) {
        helpDeleteNonstrictIgnoreDeletedInternally(roleType,
                new InternalDeleteNonstrictIgnoreDeletedCallback<RoleType>() {
                    public int callbackDelegateDeleteNonstrict(RoleType entity) {
                        return delegateDeleteNonstrict(entity);
                    }
                });
    }

    // ===================================================================================
    //                                                                        Batch Update
    //                                                                        ============
    /**
     * Batch-insert the list. This method uses 'Batch Update' of java.sql.PreparedStatement.
     * @param roleTypeList The list of the entity. (NotNull)
     * @return The array of inserted count.
     */
    public int[] batchInsert(List<RoleType> roleTypeList) {
        assertObjectNotNull("roleTypeList", roleTypeList);
        return delegateInsertList(roleTypeList);
    }

    /**
     * Batch-update the list. <br />
     * All columns are update target. {NOT modified only} <br />
     * This method uses 'Batch Update' of java.sql.PreparedStatement.
     * @param roleTypeList The list of the entity. (NotNull)
     * @return The array of updated count.
     * @exception org.seasar.dbflute.exception.BatchEntityAlreadyUpdatedException When the entity has already been updated. This exception extends EntityAlreadyUpdatedException.
     */
    public int[] batchUpdate(List<RoleType> roleTypeList) {
        assertObjectNotNull("roleTypeList", roleTypeList);
        return delegateUpdateList(roleTypeList);
    }

    /**
     * Batch-update the list non-strictly. <br />
     * All columns are update target. {NOT modified only} <br />
     * This method uses 'Batch Update' of java.sql.PreparedStatement.
     * @param roleTypeList The list of the entity. (NotNull)
     * @return The array of updated count.
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     */
    public int[] batchUpdateNonstrict(List<RoleType> roleTypeList) {
        assertObjectNotNull("roleTypeList", roleTypeList);
        return delegateUpdateListNonstrict(roleTypeList);
    }

    /**
     * Batch-delete the list. <br />
     * This method uses 'Batch Update' of java.sql.PreparedStatement.
     * @param roleTypeList The list of the entity. (NotNull)
     * @return The array of deleted count.
     * @exception org.seasar.dbflute.exception.BatchEntityAlreadyUpdatedException When the entity has already been updated. This exception extends EntityAlreadyUpdatedException.
     */
    public int[] batchDelete(List<RoleType> roleTypeList) {
        assertObjectNotNull("roleTypeList", roleTypeList);
        return delegateDeleteList(roleTypeList);
    }

    /**
     * Batch-delete the list non-strictly. <br />
     * This method uses 'Batch Update' of java.sql.PreparedStatement.
     * @param roleTypeList The list of the entity. (NotNull)
     * @return The array of deleted count.
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     */
    public int[] batchDeleteNonstrict(List<RoleType> roleTypeList) {
        assertObjectNotNull("roleTypeList", roleTypeList);
        return delegateDeleteListNonstrict(roleTypeList);
    }

    // ===================================================================================
    //                                                                        Query Update
    //                                                                        ============
    /**
     * Query-update the several entities non-strictly modified-only. {NonExclusiveControl}
     * <pre>
     * RoleType roleType = new RoleType();
     * <span style="color: #3F7E5E">// you don't need to set PK value</span>
     * <span style="color: #3F7E5E">//roleType.setPK...(value);</span>
     * roleType.setFoo...(value); <span style="color: #3F7E5E">// you should set only modified columns</span>
     * <span style="color: #3F7E5E">// you don't need to set the value of exclusive control column</span>
     * <span style="color: #3F7E5E">// (auto-increment for version number is valid though non-exclusive control)</span>
     * <span style="color: #3F7E5E">//roleType.setVersionNo(value);</span>
     * RoleTypeCB cb = new RoleTypeCB();
     * cb.query().setFoo...(value);
     * roleTypeBhv.<span style="color: #FD4747">queryUpdate</span>(roleType, cb);
     * </pre>
     * @param roleType The entity that contains update values. (NotNull) {PrimaryKeyNotRequired}
     * @param cb The condition-bean of RoleType. (NotNull)
     * @return The updated count.
     */
    public int queryUpdate(RoleType roleType, RoleTypeCB cb) {
        return delegateQueryUpdate(roleType, cb);
    }

    /**
     * Query-delete the several entities. {NonExclusiveControl}
     * <pre>
     * RoleTypeCB cb = new RoleTypeCB();
     * cb.query().setFoo...(value);
     * roleTypeBhv.<span style="color: #FD4747">queryDelete</span>(roleType, cb);
     * </pre>
     * @param cb The condition-bean of RoleType. (NotNull)
     * @return The deleted count.
     */
    public int queryDelete(RoleTypeCB cb) {
        return delegateQueryDelete(cb);
    }

    /**
     * Varying-update the entity modified-only. {UpdateCountZeroException, ExclusiveControl}
     * <pre>
     * RoleType roleType = new RoleType();
     * roleType.setPK...(value); <span style="color: #3F7E5E">// required</span>
     * roleType.setOther...(value); <span style="color: #3F7E5E">// you should set only modified columns</span>
     * <span style="color: #3F7E5E">// if exclusive control, the value of exclusive control column is required</span>
     * roleType.<span style="color: #FD4747">setVersionNo</span>(value);
     * try {
     *     UpdateOption&lt;RoleTypeCB&gt; option = new UpdateOption&lt;RoleTypeCB&gt;();
     *     option.self(new SpecifyQuery&lt;RoleTypeCB&gt;() {
     *         public void specify(RoleTypeCB cb) {
     *             cb.specify().<span style="color: #FD4747">columnXxxCount()</span>;
     *         }
     *     }).plus(1); <span style="color: #3F7E5E">// XXX_COUNT = XXX_COUNT + 1</span>
     *     roleTypeBhv.<span style="color: #FD4747">varyingUpdate</span>(roleType, option);
     * } catch (EntityAlreadyUpdatedException e) { <span style="color: #3F7E5E">// if concurrent update</span>
     *     ...
     * }
     * </pre>
     * @param roleType The entity of update target. (NotNull) {PrimaryKeyRequired, ConcurrencyColumnRequired}
     * @param option The option of update for varying values. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyUpdatedException When the entity has already been updated.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void varyingUpdate(RoleType roleType,
            final UpdateOption<RoleTypeCB> option) {
        processVaryingUpdate(option);
        helpUpdateInternally(roleType, new InternalUpdateCallback<RoleType>() {
            public int callbackDelegateUpdate(RoleType entity) {
                return delegateVaryingUpdate(entity, option);
            }
        });
    }

    /**
     * Varying-update the entity non-strictly modified-only. {UpdateCountZeroException, NonExclusiveControl}
     * <pre>
     * RoleType roleType = new RoleType();
     * roleType.setPK...(value); <span style="color: #3F7E5E">// required</span>
     * roleType.setOther...(value); <span style="color: #3F7E5E">// you should set only modified columns</span>
     * <span style="color: #3F7E5E">// you don't need to set the value of exclusive control column</span>
     * <span style="color: #3F7E5E">// (auto-increment for version number is valid though non-exclusive control)</span>
     * <span style="color: #3F7E5E">//roleType.setVersionNo(value);</span>
     * UpdateOption&lt;RoleTypeCB&gt; option = new UpdateOption&lt;RoleTypeCB&gt;();
     * option.self(new SpecifyQuery&lt;RoleTypeCB&gt;() {
     *     public void specify(RoleTypeCB cb) {
     *         cb.specify().<span style="color: #FD4747">columnFooCount()</span>;
     *     }
     * }).plus(1); <span style="color: #3F7E5E">// FOO_COUNT = FOO_COUNT + 1</span>
     * roleTypeBhv.<span style="color: #FD4747">varyingUpdateNonstrict</span>(roleType, option);
     * </pre>
     * @param roleType The entity of update target. (NotNull) {PrimaryKeyRequired}
     * @param option The option of update for varying values. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void varyingUpdateNonstrict(RoleType roleType,
            final UpdateOption<RoleTypeCB> option) {
        processVaryingUpdate(option);
        helpUpdateNonstrictInternally(roleType,
                new InternalUpdateNonstrictCallback<RoleType>() {
                    public int callbackDelegateUpdateNonstrict(RoleType entity) {
                        return delegateVaryingUpdateNonstrict(entity, option);
                    }
                });
    }

    /**
     * Varying-query-update the several entities non-strictly modified-only. {NonExclusiveControl}
     * <pre>
     * RoleType roleType = new RoleType();
     * <span style="color: #3F7E5E">// you don't need to set PK value</span>
     * <span style="color: #3F7E5E">//roleType.setPK...(value);</span>
     * roleType.setOther...(value); <span style="color: #3F7E5E">// you should set only modified columns</span>
     * <span style="color: #3F7E5E">// you don't need to set the value of exclusive control column</span>
     * <span style="color: #3F7E5E">// (auto-increment for version number is valid though non-exclusive control)</span>
     * <span style="color: #3F7E5E">//roleType.setVersionNo(value);</span>
     * RoleTypeCB cb = new RoleTypeCB();
     * cb.query().setFoo...(value);
     * UpdateOption&lt;RoleTypeCB&gt; option = new UpdateOption&lt;RoleTypeCB&gt;();
     * option.self(new SpecifyQuery&lt;RoleTypeCB&gt;() {
     *     public void specify(RoleTypeCB cb) {
     *         cb.specify().<span style="color: #FD4747">columnFooCount()</span>;
     *     }
     * }).plus(1); <span style="color: #3F7E5E">// FOO_COUNT = FOO_COUNT + 1</span>
     * roleTypeBhv.<span style="color: #FD4747">varyingQueryUpdate</span>(roleType, cb, option);
     * </pre>
     * @param roleType The entity that contains update values. (NotNull) {PrimaryKeyNotRequired}
     * @param cb The condition-bean of RoleType. (NotNull)
     * @param option The option of update for varying values. (NotNull)
     * @return The updated count.
     */
    public int varyingQueryUpdate(RoleType roleType, RoleTypeCB cb,
            final UpdateOption<RoleTypeCB> option) {
        processVaryingUpdate(option);
        return delegateVaryingQueryUpdate(roleType, cb, option);
    }

    protected void processVaryingUpdate(UpdateOption<RoleTypeCB> option) {
        assertUpdateOptionNotNull(option);
        RoleTypeCB cb = newMyConditionBean();
        cb.xsetupForVaryingUpdate();
        option.resolveSpecification(cb);
    }

    // ===================================================================================
    //                                                                     Delegate Method
    //                                                                     ===============
    // [Behavior Command]
    // -----------------------------------------------------
    //                                                Select
    //                                                ------
    protected int delegateSelectCount(RoleTypeCB cb) {
        return invoke(createSelectCountCBCommand(cb));
    }

    protected <ENTITY extends RoleType> void delegateSelectCursor(
            RoleTypeCB cb, EntityRowHandler<ENTITY> entityRowHandler,
            Class<ENTITY> entityType) {
        invoke(createSelectCursorCBCommand(cb, entityRowHandler, entityType));
    }

    protected <ENTITY extends RoleType> List<ENTITY> delegateSelectList(
            RoleTypeCB cb, Class<ENTITY> entityType) {
        return invoke(createSelectListCBCommand(cb, entityType));
    }

    // -----------------------------------------------------
    //                                                Update
    //                                                ------
    protected int delegateInsert(RoleType e) {
        if (!processBeforeInsert(e)) {
            return 1;
        }
        return invoke(createInsertEntityCommand(e));
    }

    protected int delegateUpdate(RoleType e) {
        if (!processBeforeUpdate(e)) {
            return 1;
        }
        return invoke(createUpdateEntityCommand(e));
    }

    protected int delegateUpdateNonstrict(RoleType e) {
        if (!processBeforeUpdate(e)) {
            return 1;
        }
        return invoke(createUpdateNonstrictEntityCommand(e));
    }

    protected int delegateDelete(RoleType e) {
        if (!processBeforeDelete(e)) {
            return 1;
        }
        return invoke(createDeleteEntityCommand(e));
    }

    protected int delegateDeleteNonstrict(RoleType e) {
        if (!processBeforeDelete(e)) {
            return 1;
        }
        return invoke(createDeleteNonstrictEntityCommand(e));
    }

    protected int[] delegateInsertList(List<RoleType> ls) {
        if (ls.isEmpty()) {
            return new int[] {};
        }
        return invoke(createBatchInsertEntityCommand(helpFilterBeforeInsertInternally(ls)));
    }

    @SuppressWarnings("unchecked")
    protected int[] doCreateList(List<Entity> ls) {
        return delegateInsertList((List) ls);
    }

    protected int[] delegateUpdateList(List<RoleType> ls) {
        if (ls.isEmpty()) {
            return new int[] {};
        }
        return invoke(createBatchUpdateEntityCommand(helpFilterBeforeUpdateInternally(ls)));
    }

    @SuppressWarnings("unchecked")
    protected int[] doModifyList(List<Entity> ls) {
        return delegateUpdateList((List) ls);
    }

    protected int[] delegateUpdateListNonstrict(List<RoleType> ls) {
        if (ls.isEmpty()) {
            return new int[] {};
        }
        return invoke(createBatchUpdateNonstrictEntityCommand(helpFilterBeforeUpdateInternally(ls)));
    }

    protected int[] delegateDeleteList(List<RoleType> ls) {
        if (ls.isEmpty()) {
            return new int[] {};
        }
        return invoke(createBatchDeleteEntityCommand(helpFilterBeforeDeleteInternally(ls)));
    }

    @SuppressWarnings("unchecked")
    protected int[] doRemoveList(List<Entity> ls) {
        return delegateDeleteList((List) ls);
    }

    protected int[] delegateDeleteListNonstrict(List<RoleType> ls) {
        if (ls.isEmpty()) {
            return new int[] {};
        }
        return invoke(createBatchDeleteNonstrictEntityCommand(helpFilterBeforeDeleteInternally(ls)));
    }

    protected int delegateQueryUpdate(RoleType e, RoleTypeCB cb) {
        if (!processBeforeQueryUpdate(e, cb)) {
            return 0;
        }
        return invoke(createQueryUpdateEntityCBCommand(e, cb));
    }

    protected int delegateQueryDelete(RoleTypeCB cb) {
        if (!processBeforeQueryDelete(cb)) {
            return 0;
        }
        return invoke(createQueryDeleteCBCommand(cb));
    }

    protected int delegateVaryingUpdate(RoleType e, UpdateOption<RoleTypeCB> op) {
        if (!processBeforeUpdate(e)) {
            return 1;
        }
        return invoke(createVaryingUpdateEntityCommand(e, op));
    }

    protected int delegateVaryingUpdateNonstrict(RoleType e,
            UpdateOption<RoleTypeCB> op) {
        if (!processBeforeUpdate(e)) {
            return 1;
        }
        return invoke(createVaryingUpdateNonstrictEntityCommand(e, op));
    }

    protected int delegateVaryingQueryUpdate(RoleType e, RoleTypeCB cb,
            UpdateOption<RoleTypeCB> op) {
        if (!processBeforeQueryUpdate(e, cb)) {
            return 0;
        }
        return invoke(createVaryingQueryUpdateEntityCBCommand(e, cb, op));
    }

    // ===================================================================================
    //                                                                Optimistic Lock Info
    //                                                                ====================
    /**
     * {@inheritDoc}
     */
    @Override
    protected boolean hasVersionNoValue(Entity entity) {
        return !(downcast(entity).getVersionNo() + "").equals("null");// For primitive type
    }

    /**
     * {@inheritDoc}
     */
    @Override
    protected boolean hasUpdateDateValue(Entity entity) {
        return false;
    }

    // ===================================================================================
    //                                                                     Downcast Helper
    //                                                                     ===============
    protected RoleType downcast(Entity entity) {
        return helpEntityDowncastInternally(entity, RoleType.class);
    }

    protected RoleTypeCB downcast(ConditionBean cb) {
        return helpConditionBeanDowncastInternally(cb, RoleTypeCB.class);
    }
}
