/*
 * Copyright 2009-2010 the Fess Project and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package jp.sf.fess.db.bsentity;

import java.io.Serializable;
import java.util.Set;

import jp.sf.fess.db.allcommon.DBMetaInstanceHandler;
import jp.sf.fess.db.exentity.CrawlingSession;

import org.seasar.dbflute.Entity;
import org.seasar.dbflute.dbmeta.DBMeta;

/**
 * The entity of CRAWLING_SESSION_INFO that the type is TABLE. <br />
 * <pre>
 * [primary-key]
 *     ID
 * 
 * [column]
 *     ID, CRAWLING_SESSION_ID, KEY, VALUE, CREATED_TIME
 * 
 * [sequence]
 *     
 * 
 * [identity]
 *     ID
 * 
 * [version-no]
 *     
 * 
 * [foreign-table]
 *     CRAWLING_SESSION
 * 
 * [referrer-table]
 *     
 * 
 * [foreign-property]
 *     crawlingSession
 * 
 * [referrer-property]
 *     
 * </pre>
 * @author DBFlute(AutoGenerator)
 */
public abstract class BsCrawlingSessionInfo implements Entity, Serializable {

    // ===================================================================================
    //                                                                          Definition
    //                                                                          ==========
    /** Serial version UID. (Default) */
    private static final long serialVersionUID = 1L;

    // ===================================================================================
    //                                                                           Attribute
    //                                                                           =========
    // -----------------------------------------------------
    //                                                Column
    //                                                ------
    /** ID: {PK : ID : NotNull : BIGINT} */
    protected Long _id;

    /** CRAWLING_SESSION_ID: {NotNull : BIGINT : FK to CRAWLING_SESSION} */
    protected Long _crawlingSessionId;

    /** KEY: {NotNull : VARCHAR(20)} */
    protected String _key;

    /** VALUE: {NotNull : VARCHAR(100)} */
    protected String _value;

    /** CREATED_TIME: {NotNull : TIMESTAMP} */
    protected java.sql.Timestamp _createdTime;

    // -----------------------------------------------------
    //                                              Internal
    //                                              --------
    /** The attribute of entity modified properties. (for S2Dao) */
    protected EntityModifiedProperties _modifiedProperties = newEntityModifiedProperties();

    // ===================================================================================
    //                                                                          Table Name
    //                                                                          ==========
    public String getTableDbName() {
        return "CRAWLING_SESSION_INFO";
    }

    public String getTablePropertyName() { // as JavaBeansRule
        return "crawlingSessionInfo";
    }

    // ===================================================================================
    //                                                                              DBMeta
    //                                                                              ======
    public DBMeta getDBMeta() {
        return DBMetaInstanceHandler.findDBMeta(getTableDbName());
    }

    // ===================================================================================
    //                                                          Classification Classifying
    //                                                          ==========================
    // ===================================================================================
    //                                                        Classification Determination
    //                                                        ============================
    // ===================================================================================
    //                                                           Classification Name/Alias
    //                                                           =========================
    // ===================================================================================
    //                                                                    Foreign Property
    //                                                                    ================
    /** CRAWLING_SESSION as 'crawlingSession'. */
    protected CrawlingSession _parentCrawlingSession;

    /**
     * CRAWLING_SESSION as 'crawlingSession'. {without lazy-load}
     * @return The entity of foreign property 'crawlingSession'. (Nullable: If the foreign key does not have 'NotNull' constraint, please check null.)
     */
    public CrawlingSession getCrawlingSession() {
        return _parentCrawlingSession;
    }

    /**
     * CRAWLING_SESSION as 'crawlingSession'.
     * @param crawlingSession The entity of foreign property 'crawlingSession'. (Nullable)
     */
    public void setCrawlingSession(CrawlingSession crawlingSession) {
        _parentCrawlingSession = crawlingSession;
    }

    // ===================================================================================
    //                                                                   Referrer Property
    //                                                                   =================
    // ===================================================================================
    //                                                                       Determination
    //                                                                       =============
    public boolean hasPrimaryKeyValue() {
        if (_id == null) {
            return false;
        }
        return true;
    }

    // ===================================================================================
    //                                                                 Modified Properties
    //                                                                 ===================
    public Set<String> getModifiedPropertyNames() {
        return _modifiedProperties.getPropertyNames();
    }

    protected EntityModifiedProperties newEntityModifiedProperties() {
        return new EntityModifiedProperties();
    }

    public void clearModifiedPropertyNames() {
        _modifiedProperties.clear();
    }

    public boolean hasModification() {
        return !_modifiedProperties.isEmpty();
    }

    // ===================================================================================
    //                                                                      Basic Override
    //                                                                      ==============
    /**
     * If the primary-key of the other is same as this one, returns true.
     * @param other Other entity.
     * @return Comparing result.
     */
    public boolean equals(Object other) {
        if (other == null || !(other instanceof BsCrawlingSessionInfo)) {
            return false;
        }
        BsCrawlingSessionInfo otherEntity = (BsCrawlingSessionInfo) other;
        if (!helpComparingValue(getId(), otherEntity.getId())) {
            return false;
        }
        return true;
    }

    protected boolean helpComparingValue(Object value1, Object value2) {
        if (value1 == null && value2 == null) {
            return true;
        }
        return value1 != null && value2 != null && value1.equals(value2);
    }

    /**
     * Calculates hash-code from primary-key.
     * @return Hash-code from primary-key.
     */
    public int hashCode() {
        int result = 17;
        if (getId() != null) {
            result = (31 * result) + getId().hashCode();
        }
        return result;
    }

    /**
     * @return The view string of all columns. (NotNull)
     */
    public String toString() {
        String delimiter = ",";
        StringBuilder sb = new StringBuilder();
        sb.append(delimiter).append(getId());
        sb.append(delimiter).append(getCrawlingSessionId());
        sb.append(delimiter).append(getKey());
        sb.append(delimiter).append(getValue());
        sb.append(delimiter).append(getCreatedTime());
        if (sb.length() > 0) {
            sb.delete(0, delimiter.length());
        }
        sb.insert(0, "{").append("}");
        return sb.toString();
    }

    // ===================================================================================
    //                                                                            Accessor
    //                                                                            ========
    /**
     * ID: {PK : ID : NotNull : BIGINT} <br />
     * @return The value of the column 'ID'. (Nullable)
     */
    public Long getId() {
        return _id;
    }

    /**
     * ID: {PK : ID : NotNull : BIGINT} <br />
     * @param id The value of the column 'ID'. (Nullable)
     */
    public void setId(Long id) {
        _modifiedProperties.addPropertyName("id");
        this._id = id;
    }

    /**
     * CRAWLING_SESSION_ID: {NotNull : BIGINT : FK to CRAWLING_SESSION} <br />
     * @return The value of the column 'CRAWLING_SESSION_ID'. (Nullable)
     */
    public Long getCrawlingSessionId() {
        return _crawlingSessionId;
    }

    /**
     * CRAWLING_SESSION_ID: {NotNull : BIGINT : FK to CRAWLING_SESSION} <br />
     * @param crawlingSessionId The value of the column 'CRAWLING_SESSION_ID'. (Nullable)
     */
    public void setCrawlingSessionId(Long crawlingSessionId) {
        _modifiedProperties.addPropertyName("crawlingSessionId");
        this._crawlingSessionId = crawlingSessionId;
    }

    /**
     * KEY: {NotNull : VARCHAR(20)} <br />
     * @return The value of the column 'KEY'. (Nullable)
     */
    public String getKey() {
        return _key;
    }

    /**
     * KEY: {NotNull : VARCHAR(20)} <br />
     * @param key The value of the column 'KEY'. (Nullable)
     */
    public void setKey(String key) {
        _modifiedProperties.addPropertyName("key");
        this._key = key;
    }

    /**
     * VALUE: {NotNull : VARCHAR(100)} <br />
     * @return The value of the column 'VALUE'. (Nullable)
     */
    public String getValue() {
        return _value;
    }

    /**
     * VALUE: {NotNull : VARCHAR(100)} <br />
     * @param value The value of the column 'VALUE'. (Nullable)
     */
    public void setValue(String value) {
        _modifiedProperties.addPropertyName("value");
        this._value = value;
    }

    /**
     * CREATED_TIME: {NotNull : TIMESTAMP} <br />
     * @return The value of the column 'CREATED_TIME'. (Nullable)
     */
    public java.sql.Timestamp getCreatedTime() {
        return _createdTime;
    }

    /**
     * CREATED_TIME: {NotNull : TIMESTAMP} <br />
     * @param createdTime The value of the column 'CREATED_TIME'. (Nullable)
     */
    public void setCreatedTime(java.sql.Timestamp createdTime) {
        _modifiedProperties.addPropertyName("createdTime");
        this._createdTime = createdTime;
    }
}
