/*
 * Copyright 2009-2009 the Fess Project and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package jp.sf.fess.db.cbean.bs;

import java.util.Map;

import jp.sf.fess.db.allcommon.DBFluteConfig;
import jp.sf.fess.db.allcommon.DBMetaInstanceHandler;
import jp.sf.fess.db.allcommon.ImplementedSqlClauseCreator;
import jp.sf.fess.db.cbean.WebAuthenticationCB;
import jp.sf.fess.db.cbean.WebCrawlingConfigCB;
import jp.sf.fess.db.cbean.cq.WebAuthenticationCQ;
import jp.sf.fess.db.cbean.cq.WebCrawlingConfigCQ;
import jp.sf.fess.db.cbean.nss.WebCrawlingConfigNss;

import org.seasar.dbflute.cbean.AbstractConditionBean;
import org.seasar.dbflute.cbean.ConditionBean;
import org.seasar.dbflute.cbean.ConditionQuery;
import org.seasar.dbflute.cbean.SubQuery;
import org.seasar.dbflute.cbean.UnionQuery;
import org.seasar.dbflute.cbean.sqlclause.SqlClause;
import org.seasar.dbflute.dbmeta.DBMetaProvider;

/**
 * The base condition-bean of WEB_AUTHENTICATION.
 * @author DBFlute(AutoGenerator)
 */
public class BsWebAuthenticationCB extends AbstractConditionBean {

    // ===================================================================================
    //                                                                           Attribute
    //                                                                           =========
    private final DBMetaProvider _dbmetaProvider = new DBMetaInstanceHandler();

    protected WebAuthenticationCQ _conditionQuery;

    // ===================================================================================
    //                                                                           SqlClause
    //                                                                           =========
    @Override
    protected SqlClause createSqlClause() {
        return new ImplementedSqlClauseCreator().createSqlClause(this);
    }

    // ===================================================================================
    //                                                                     DBMeta Provider
    //                                                                     ===============
    @Override
    protected DBMetaProvider getDBMetaProvider() {
        return _dbmetaProvider;
    }

    // ===================================================================================
    //                                                                          Table Name
    //                                                                          ==========
    public String getTableDbName() {
        return "WEB_AUTHENTICATION";
    }

    public String getTableSqlName() {
        return "WEB_AUTHENTICATION";
    }

    // ===================================================================================
    //                                                                      PrimaryKey Map
    //                                                                      ==============
    public void acceptPrimaryKeyMap(Map<String, ? extends Object> primaryKeyMap) {
        assertPrimaryKeyMap(primaryKeyMap);
        {
            Object obj = primaryKeyMap.get("ID");
            if (obj instanceof Long) {
                query().setId_Equal((Long) obj);
            } else {
                query().setId_Equal(new Long((String) obj));
            }
        }

    }

    // ===================================================================================
    //                                                                     OrderBy Setting
    //                                                                     ===============
    public ConditionBean addOrderBy_PK_Asc() {
        query().addOrderBy_Id_Asc();
        return this;
    }

    public ConditionBean addOrderBy_PK_Desc() {
        query().addOrderBy_Id_Desc();
        return this;
    }

    // ===================================================================================
    //                                                                               Query
    //                                                                               =====
    public WebAuthenticationCQ query() {
        return getConditionQuery();
    }

    public WebAuthenticationCQ getConditionQuery() {
        if (_conditionQuery == null) {
            _conditionQuery = new WebAuthenticationCQ(null, getSqlClause(),
                    getSqlClause().getLocalTableAliasName(), 0);
        }
        return _conditionQuery;
    }

    /**
     * {@inheritDoc}
     */
    public ConditionQuery localCQ() {
        return getConditionQuery();
    }

    // ===================================================================================
    //                                                                               Union
    //                                                                               =====
    /**
     * Set up 'union'.
     * <pre>
     * cb.query().union(new UnionQuery&lt;WebAuthenticationCB&gt;() {
     *     public void query(WebAuthenticationCB unionCB) {
     *         unionCB.query().setXxx...
     *     }
     * });
     * </pre>
     * @param unionQuery The query of 'union'. (NotNull)
     */
    public void union(UnionQuery<WebAuthenticationCB> unionQuery) {
        final WebAuthenticationCB cb = new WebAuthenticationCB();
        cb.xsetupForUnion();
        unionQuery.query(cb);
        final WebAuthenticationCQ cq = cb.query();
        query().xsetUnionQuery(cq);
    }

    /**
     * Set up 'union all'.
     * <pre>
     * cb.query().unionAll(new UnionQuery&lt;WebAuthenticationCB&gt;() {
     *     public void query(WebAuthenticationCB unionCB) {
     *         unionCB.query().setXxx...
     *     }
     * });
     * </pre>
     * @param unionQuery The query of 'union'. (NotNull)
     */
    public void unionAll(UnionQuery<WebAuthenticationCB> unionQuery) {
        final WebAuthenticationCB cb = new WebAuthenticationCB();
        cb.xsetupForUnion();
        unionQuery.query(cb);
        final WebAuthenticationCQ cq = cb.query();
        query().xsetUnionAllQuery(cq);
    }

    public boolean hasUnionQueryOrUnionAllQuery() {
        return query().hasUnionQueryOrUnionAllQuery();
    }

    // ===================================================================================
    //                                                                        Setup Select
    //                                                                        ============
    protected WebCrawlingConfigNss _nssWebCrawlingConfig;

    public WebCrawlingConfigNss getNssWebCrawlingConfig() {
        if (_nssWebCrawlingConfig == null) {
            _nssWebCrawlingConfig = new WebCrawlingConfigNss(null);
        }
        return _nssWebCrawlingConfig;
    }

    public WebCrawlingConfigNss setupSelect_WebCrawlingConfig() {
        doSetupSelect(new SsCall() {
            public ConditionQuery qf() {
                return query().queryWebCrawlingConfig();
            }
        });
        if (_nssWebCrawlingConfig == null
                || !_nssWebCrawlingConfig.hasConditionQuery()) {
            _nssWebCrawlingConfig = new WebCrawlingConfigNss(query()
                    .queryWebCrawlingConfig());
        }
        return _nssWebCrawlingConfig;
    }

    // [DBFlute-0.7.4]
    // ===================================================================================
    //                                                                             Specify
    //                                                                             =======
    protected Specification _specification;

    public Specification specify() {
        if (_specification == null) {
            _specification = new Specification(this,
                    new SpQyCall<WebAuthenticationCQ>() {
                        public boolean has() {
                            return true;
                        }

                        public WebAuthenticationCQ qy() {
                            return query();
                        }
                    }, _forDerivedReferrer, _forScalarSelect,
                    _forScalarSubQuery, getDBMetaProvider());
        }
        return _specification;
    }

    public static class Specification extends
            AbstractSpecification<WebAuthenticationCQ> {
        protected SpQyCall<WebAuthenticationCQ> _myQyCall;

        protected WebCrawlingConfigCB.Specification _webCrawlingConfig;

        public Specification(ConditionBean baseCB,
                SpQyCall<WebAuthenticationCQ> qyCall,
                boolean forDeriveReferrer, boolean forScalarSelect,
                boolean forScalarSubQuery, DBMetaProvider dbmetaProvider) {
            super(baseCB, qyCall, forDeriveReferrer, forScalarSelect,
                    forScalarSubQuery, dbmetaProvider);
            _myQyCall = qyCall;
        }

        public void columnId() {
            doColumn("ID");
        }

        public void columnUrlPattern() {
            doColumn("URL_PATTERN");
        }

        public void columnUsername() {
            doColumn("USERNAME");
        }

        public void columnPassword() {
            doColumn("PASSWORD");
        }

        public void columnWebCrawlingConfigId() {
            doColumn("WEB_CRAWLING_CONFIG_ID");
        }

        public void columnCreatedBy() {
            doColumn("CREATED_BY");
        }

        public void columnCreatedTime() {
            doColumn("CREATED_TIME");
        }

        public void columnUpdatedBy() {
            doColumn("UPDATED_BY");
        }

        public void columnUpdatedTime() {
            doColumn("UPDATED_TIME");
        }

        public void columnDeletedBy() {
            doColumn("DELETED_BY");
        }

        public void columnDeletedTime() {
            doColumn("DELETED_TIME");
        }

        public void columnVersionNo() {
            doColumn("VERSION_NO");
        }

        protected void doSpecifyRequiredColumn() {
            columnId(); // PK
            if (_myQyCall.qy().hasConditionQueryWebCrawlingConfig()) {
                columnWebCrawlingConfigId(); // FK
            }
        }

        protected String getTableDbName() {
            return "WEB_AUTHENTICATION";
        }

        public WebCrawlingConfigCB.Specification specifyWebCrawlingConfig() {
            assertForeign("webCrawlingConfig");
            if (_webCrawlingConfig == null) {
                _webCrawlingConfig = new WebCrawlingConfigCB.Specification(
                        _baseCB,
                        new SpQyCall<WebCrawlingConfigCQ>() {
                            public boolean has() {
                                return _myQyCall.has()
                                        && _myQyCall
                                                .qy()
                                                .hasConditionQueryWebCrawlingConfig();
                            }

                            public WebCrawlingConfigCQ qy() {
                                return _myQyCall.qy().queryWebCrawlingConfig();
                            }
                        }, _forDerivedReferrer, _forScalarSelect,
                        _forScalarSubQuery, _dbmetaProvider);
            }
            return _webCrawlingConfig;
        }
    }

    // ===================================================================================
    //                                                                         Display SQL
    //                                                                         ===========
    @Override
    protected String getLogDateFormat() {
        return DBFluteConfig.getInstance().getLogDateFormat();
    }

    @Override
    protected String getLogTimestampFormat() {
        return DBFluteConfig.getInstance().getLogTimestampFormat();
    }

    // ===================================================================================
    //                                                                            Internal
    //                                                                            ========
    // Very Internal (for Suppressing Warn about 'Not Use Import')
    protected String getConditionBeanClassNameInternally() {
        return WebAuthenticationCB.class.getName();
    }

    protected String getConditionQueryClassNameInternally() {
        return WebAuthenticationCQ.class.getName();
    }

    protected String getSubQueryClassNameInternally() {
        return SubQuery.class.getName();
    }
}
