/*
 * Copyright 2009-2010 the Fess Project and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */

package jp.sf.fess.db.bsbhv;

import java.util.List;

import jp.sf.fess.db.allcommon.DBCurrent;
import jp.sf.fess.db.allcommon.DBFluteConfig;
import jp.sf.fess.db.bsentity.dbmeta.DataConfigToRoleTypeMappingDbm;
import jp.sf.fess.db.cbean.DataConfigToRoleTypeMappingCB;
import jp.sf.fess.db.exentity.DataConfigToRoleTypeMapping;
import jp.sf.fess.db.exentity.DataCrawlingConfig;
import jp.sf.fess.db.exentity.RoleType;

import org.seasar.dbflute.DBDef;
import org.seasar.dbflute.Entity;
import org.seasar.dbflute.cbean.ConditionBean;
import org.seasar.dbflute.cbean.EntityRowHandler;
import org.seasar.dbflute.cbean.ListResultBean;
import org.seasar.dbflute.cbean.PagingBean;
import org.seasar.dbflute.cbean.PagingHandler;
import org.seasar.dbflute.cbean.PagingInvoker;
import org.seasar.dbflute.cbean.PagingResultBean;
import org.seasar.dbflute.cbean.ResultBeanBuilder;
import org.seasar.dbflute.dbmeta.DBMeta;
import org.seasar.dbflute.jdbc.StatementConfig;

/**
 * The behavior of DATA_CONFIG_TO_ROLE_TYPE_MAPPING that the type is TABLE. <br />
 * <pre>
 * [primary-key]
 *     ID
 * 
 * [column]
 *     ID, DATA_CONFIG_ID, ROLE_TYPE_ID
 * 
 * [sequence]
 *     
 * 
 * [identity]
 *     ID
 * 
 * [version-no]
 *     
 * 
 * [foreign-table]
 *     DATA_CRAWLING_CONFIG, ROLE_TYPE
 * 
 * [referrer-table]
 *     
 * 
 * [foreign-property]
 *     dataCrawlingConfig, roleType
 * 
 * [referrer-property]
 *     
 * </pre>
 * @author DBFlute(AutoGenerator)
 */
public abstract class BsDataConfigToRoleTypeMappingBhv extends
        org.seasar.dbflute.bhv.AbstractBehaviorWritable {

    // ===================================================================================
    //                                                                          Definition
    //                                                                          ==========
    /*df:BehaviorQueryPathBegin*/
    /*df:BehaviorQueryPathEnd*/

    // ===================================================================================
    //                                                                          Table name
    //                                                                          ==========
    /** @return The name on database of table. (NotNull) */
    public String getTableDbName() {
        return "DATA_CONFIG_TO_ROLE_TYPE_MAPPING";
    }

    // ===================================================================================
    //                                                                              DBMeta
    //                                                                              ======
    /** @return The instance of DBMeta. (NotNull) */
    public DBMeta getDBMeta() {
        return DataConfigToRoleTypeMappingDbm.getInstance();
    }

    /** @return The instance of DBMeta as my table type. (NotNull) */
    public DataConfigToRoleTypeMappingDbm getMyDBMeta() {
        return DataConfigToRoleTypeMappingDbm.getInstance();
    }

    // ===================================================================================
    //                                                                        New Instance
    //                                                                        ============
    public Entity newEntity() {
        return newMyEntity();
    }

    public ConditionBean newConditionBean() {
        return newMyConditionBean();
    }

    public DataConfigToRoleTypeMapping newMyEntity() {
        return new DataConfigToRoleTypeMapping();
    }

    public DataConfigToRoleTypeMappingCB newMyConditionBean() {
        return new DataConfigToRoleTypeMappingCB();
    }

    // ===================================================================================
    //                                                                       Current DBDef
    //                                                                       =============
    @Override
    protected DBDef getCurrentDBDef() {
        return DBCurrent.getInstance().currentDBDef();
    }

    // ===================================================================================
    //                                                             Default StatementConfig
    //                                                             =======================
    @Override
    protected StatementConfig getDefaultStatementConfig() {
        return DBFluteConfig.getInstance().getDefaultStatementConfig();
    }

    // ===================================================================================
    //                                                                        Count Select
    //                                                                        ============
    /**
     * Select the count by the condition-bean. {IgnorePagingCondition}
     * @param cb The condition-bean of DataConfigToRoleTypeMapping. (NotNull)
     * @return The selected count.
     */
    public int selectCount(DataConfigToRoleTypeMappingCB cb) {
        assertCBNotNull(cb);
        return delegateSelectCount(cb);
    }

    // ===================================================================================
    //                                                                       Cursor Select
    //                                                                       =============
    /**
     * Select the cursor by the condition-bean. <br />
     * Attention: It has a mapping cost from result set to entity.
     * @param cb The condition-bean of DataConfigToRoleTypeMapping. (NotNull)
     * @param entityRowHandler The handler of entity row of DataConfigToRoleTypeMapping. (NotNull)
     */
    public void selectCursor(DataConfigToRoleTypeMappingCB cb,
            EntityRowHandler<DataConfigToRoleTypeMapping> entityRowHandler) {
        assertCBNotNull(cb);
        assertObjectNotNull("entityRowHandler<DataConfigToRoleTypeMapping>",
                entityRowHandler);
        delegateSelectCursor(cb, entityRowHandler);
    }

    // ===================================================================================
    //                                                                       Entity Select
    //                                                                       =============
    /**
     * Select the entity by the condition-bean.
     * @param cb The condition-bean of DataConfigToRoleTypeMapping. (NotNull)
     * @return The selected entity. (Nullalble)
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     */
    public DataConfigToRoleTypeMapping selectEntity(
            final DataConfigToRoleTypeMappingCB cb) {
        return helpSelectEntityInternally(
                cb,
                new InternalSelectEntityCallback<DataConfigToRoleTypeMapping, DataConfigToRoleTypeMappingCB>() {
                    public List<DataConfigToRoleTypeMapping> callbackSelectList(
                            DataConfigToRoleTypeMappingCB cb) {
                        return selectList(cb);
                    }
                });
    }

    /**
     * Select the entity by the condition-bean with deleted check.
     * @param cb The condition-bean of DataConfigToRoleTypeMapping. (NotNull)
     * @return The selected entity. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     */
    public DataConfigToRoleTypeMapping selectEntityWithDeletedCheck(
            final DataConfigToRoleTypeMappingCB cb) {
        return helpSelectEntityWithDeletedCheckInternally(
                cb,
                new InternalSelectEntityWithDeletedCheckCallback<DataConfigToRoleTypeMapping, DataConfigToRoleTypeMappingCB>() {
                    public List<DataConfigToRoleTypeMapping> callbackSelectList(
                            DataConfigToRoleTypeMappingCB cb) {
                        return selectList(cb);
                    }
                });
    }

    /* (non-javadoc)
     * Select the entity with deleted check. {by primary-key value}
     * @param primaryKey The keys of primary.
     * @return The selected entity. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     */
    public DataConfigToRoleTypeMapping selectByPKValueWithDeletedCheck(Long id) {
        DataConfigToRoleTypeMapping entity = new DataConfigToRoleTypeMapping();
        entity.setId(id);
        final DataConfigToRoleTypeMappingCB cb = newMyConditionBean();
        cb.acceptPrimaryKeyMapString(getDBMeta().extractPrimaryKeyMapString(
                entity));
        return selectEntityWithDeletedCheck(cb);
    }

    // ===================================================================================
    //                                                                         List Select
    //                                                                         ===========
    /**
     * Select the list as result bean.
     * @param cb The condition-bean of DataConfigToRoleTypeMapping. (NotNull)
     * @return The result bean of selected list. (NotNull)
     */
    public ListResultBean<DataConfigToRoleTypeMapping> selectList(
            DataConfigToRoleTypeMappingCB cb) {
        assertCBNotNull(cb);
        return new ResultBeanBuilder<DataConfigToRoleTypeMapping>(
                getTableDbName()).buildListResultBean(cb,
                delegateSelectList(cb));
    }

    // ===================================================================================
    //                                                                         Page Select
    //                                                                         ===========
    /**
     * Select the page as result bean.
     * @param cb The condition-bean of DataConfigToRoleTypeMapping. (NotNull)
     * @return The result bean of selected page. (NotNull)
     */
    public PagingResultBean<DataConfigToRoleTypeMapping> selectPage(
            final DataConfigToRoleTypeMappingCB cb) {
        assertCBNotNull(cb);
        final PagingInvoker<DataConfigToRoleTypeMapping> invoker = new PagingInvoker<DataConfigToRoleTypeMapping>(
                getTableDbName());
        final PagingHandler<DataConfigToRoleTypeMapping> handler = new PagingHandler<DataConfigToRoleTypeMapping>() {
            public PagingBean getPagingBean() {
                return cb;
            }

            public int count() {
                return selectCount(cb);
            }

            public List<DataConfigToRoleTypeMapping> paging() {
                return selectList(cb);
            }
        };
        return invoker.invokePaging(handler);
    }

    // ===================================================================================
    //                                                                       Scalar Select
    //                                                                       =============
    /**
     * Select the scalar value derived by a function. <br />
     * Call a function method after this method called like as follows:
     * <pre>
     * dataConfigToRoleTypeMappingBhv.scalarSelect(Date.class).max(new ScalarQuery(DataConfigToRoleTypeMappingCB cb) {
     *     cb.specify().columnXxxDatetime(); // the required specification of target column
     *     cb.query().setXxxName_PrefixSearch("S"); // query as you like it
     * });
     * </pre>
     * @param <RESULT> The type of result.
     * @param resultType The type of result. (NotNull)
     * @return The scalar value derived by a function. (Nullable)
     */
    public <RESULT> SLFunction<DataConfigToRoleTypeMappingCB, RESULT> scalarSelect(
            Class<RESULT> resultType) {
        DataConfigToRoleTypeMappingCB cb = newMyConditionBean();
        cb.xsetupForScalarSelect();
        cb.getSqlClause().disableSelectIndex(); // for when you use union
        return new SLFunction<DataConfigToRoleTypeMappingCB, RESULT>(cb,
                resultType);
    }

    // ===================================================================================
    //                                                                       Load Referrer
    //                                                                       =============
    // ===================================================================================
    //                                                                    Pull out Foreign
    //                                                                    ================
    /**
     * Pull out the list of foreign table 'DataCrawlingConfig'.
     * @param dataConfigToRoleTypeMappingList The list of dataConfigToRoleTypeMapping. (NotNull)
     * @return The list of foreign table. (NotNull)
     */
    public List<DataCrawlingConfig> pulloutDataCrawlingConfig(
            List<DataConfigToRoleTypeMapping> dataConfigToRoleTypeMappingList) {
        return helpPulloutInternally(
                dataConfigToRoleTypeMappingList,
                new InternalPulloutCallback<DataConfigToRoleTypeMapping, DataCrawlingConfig>() {
                    public DataCrawlingConfig callbackGetForeignEntity(
                            DataConfigToRoleTypeMapping entity) {
                        return entity.getDataCrawlingConfig();
                    }
                });
    }

    /**
     * Pull out the list of foreign table 'RoleType'.
     * @param dataConfigToRoleTypeMappingList The list of dataConfigToRoleTypeMapping. (NotNull)
     * @return The list of foreign table. (NotNull)
     */
    public List<RoleType> pulloutRoleType(
            List<DataConfigToRoleTypeMapping> dataConfigToRoleTypeMappingList) {
        return helpPulloutInternally(
                dataConfigToRoleTypeMappingList,
                new InternalPulloutCallback<DataConfigToRoleTypeMapping, RoleType>() {
                    public RoleType callbackGetForeignEntity(
                            DataConfigToRoleTypeMapping entity) {
                        return entity.getRoleType();
                    }
                });
    }

    // ===================================================================================
    //                                                                       Entity Update
    //                                                                       =============
    /**
     * Insert the entity.
     * @param dataConfigToRoleTypeMapping The entity of insert target. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void insert(DataConfigToRoleTypeMapping dataConfigToRoleTypeMapping) {
        assertEntityNotNull(dataConfigToRoleTypeMapping);
        delegateInsert(dataConfigToRoleTypeMapping);
    }

    @Override
    protected void doCreate(Entity dataConfigToRoleTypeMapping) {
        insert((DataConfigToRoleTypeMapping) dataConfigToRoleTypeMapping);
    }

    /**
     * Update the entity modified-only. {UpdateCountZeroException, ConcurrencyControl}
     * @param dataConfigToRoleTypeMapping The entity of update target. (NotNull) {PrimaryKeyRequired, ConcurrencyColumnRequired}
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void update(
            final DataConfigToRoleTypeMapping dataConfigToRoleTypeMapping) {
        helpUpdateInternally(dataConfigToRoleTypeMapping,
                new InternalUpdateCallback<DataConfigToRoleTypeMapping>() {
                    public int callbackDelegateUpdate(
                            DataConfigToRoleTypeMapping entity) {
                        return delegateUpdate(entity);
                    }
                });
    }

    @Override
    protected void doModify(Entity entity) {
        update((DataConfigToRoleTypeMapping) entity);
    }

    @Override
    protected void doModifyNonstrict(Entity entity) {
        update((DataConfigToRoleTypeMapping) entity);
    }

    /**
     * Insert or update the entity modified-only. {ConcurrencyControl(when update)}
     * @param dataConfigToRoleTypeMapping The entity of insert or update target. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void insertOrUpdate(
            final DataConfigToRoleTypeMapping dataConfigToRoleTypeMapping) {
        helpInsertOrUpdateInternally(
                dataConfigToRoleTypeMapping,
                new InternalInsertOrUpdateCallback<DataConfigToRoleTypeMapping, DataConfigToRoleTypeMappingCB>() {
                    public void callbackInsert(
                            DataConfigToRoleTypeMapping entity) {
                        insert(entity);
                    }

                    public void callbackUpdate(
                            DataConfigToRoleTypeMapping entity) {
                        update(entity);
                    }

                    public DataConfigToRoleTypeMappingCB callbackNewMyConditionBean() {
                        return newMyConditionBean();
                    }

                    public int callbackSelectCount(
                            DataConfigToRoleTypeMappingCB cb) {
                        return selectCount(cb);
                    }
                });
    }

    @Override
    protected void doCreateOrUpdate(Entity dataConfigToRoleTypeMapping) {
        insertOrUpdate((DataConfigToRoleTypeMapping) dataConfigToRoleTypeMapping);
    }

    @Override
    protected void doCreateOrUpdateNonstrict(Entity entity) {
        insertOrUpdate((DataConfigToRoleTypeMapping) entity);
    }

    /**
     * Delete the entity. {UpdateCountZeroException, ConcurrencyControl}
     * @param dataConfigToRoleTypeMapping The entity of delete target. (NotNull) {PrimaryKeyRequired, ConcurrencyColumnRequired}
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     */
    public void delete(DataConfigToRoleTypeMapping dataConfigToRoleTypeMapping) {
        helpDeleteInternally(dataConfigToRoleTypeMapping,
                new InternalDeleteCallback<DataConfigToRoleTypeMapping>() {
                    public int callbackDelegateDelete(
                            DataConfigToRoleTypeMapping entity) {
                        return delegateDelete(entity);
                    }
                });
    }

    @Override
    protected void doRemove(Entity dataConfigToRoleTypeMapping) {
        delete((DataConfigToRoleTypeMapping) dataConfigToRoleTypeMapping);
    }

    // ===================================================================================
    //                                                                        Batch Update
    //                                                                        ============
    /**
     * Batch insert the list. This method use 'Batch Update' of java.sql.PreparedStatement.
     * @param dataConfigToRoleTypeMappingList The list of the entity. (NotNull)
     * @return The array of inserted count.
     */
    public int[] batchInsert(
            List<DataConfigToRoleTypeMapping> dataConfigToRoleTypeMappingList) {
        assertObjectNotNull("dataConfigToRoleTypeMappingList",
                dataConfigToRoleTypeMappingList);
        return delegateInsertList(dataConfigToRoleTypeMappingList);
    }

    /**
     * Batch update the list. All columns are update target. {NOT modified only} <br />
     * This method use 'Batch Update' of java.sql.PreparedStatement.
     * @param dataConfigToRoleTypeMappingList The list of the entity. (NotNull)
     * @return The array of updated count.
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     */
    public int[] batchUpdate(
            List<DataConfigToRoleTypeMapping> dataConfigToRoleTypeMappingList) {
        assertObjectNotNull("dataConfigToRoleTypeMappingList",
                dataConfigToRoleTypeMappingList);
        return delegateUpdateList(dataConfigToRoleTypeMappingList);
    }

    /**
     * Batch delete the list. <br />
     * This method use 'Batch Update' of java.sql.PreparedStatement.
     * @param dataConfigToRoleTypeMappingList The list of the entity. (NotNull)
     * @return The array of deleted count.
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     */
    public int[] batchDelete(
            List<DataConfigToRoleTypeMapping> dataConfigToRoleTypeMappingList) {
        assertObjectNotNull("dataConfigToRoleTypeMappingList",
                dataConfigToRoleTypeMappingList);
        return delegateDeleteList(dataConfigToRoleTypeMappingList);
    }

    // ===================================================================================
    //                                                                        Query Update
    //                                                                        ============
    /**
     * Query update the several entities. {NoConcurrencyControl}
     * @param dataConfigToRoleTypeMapping Entity. (NotNull) {PrimaryKeyNotRequired}
     * @param cb Condition-bean. (NotNull)
     * @return The updated count.
     */
    public int queryUpdate(
            DataConfigToRoleTypeMapping dataConfigToRoleTypeMapping,
            DataConfigToRoleTypeMappingCB cb) {
        assertObjectNotNull("dataConfigToRoleTypeMapping",
                dataConfigToRoleTypeMapping);
        assertCBNotNull(cb);
        setupCommonColumnOfUpdateIfNeeds(dataConfigToRoleTypeMapping);
        filterEntityOfUpdate(dataConfigToRoleTypeMapping);
        assertEntityOfUpdate(dataConfigToRoleTypeMapping);
        return invoke(createQueryUpdateEntityCBCommand(
                dataConfigToRoleTypeMapping, cb));
    }

    /**
     * Query delete the several entities. {NoConcurrencyControl}
     * @param cb Condition-bean. (NotNull)
     * @return The deleted count.
     */
    public int queryDelete(DataConfigToRoleTypeMappingCB cb) {
        assertCBNotNull(cb);
        return invoke(createQueryDeleteCBCommand(cb));
    }

    // ===================================================================================
    //                                                                     Delegate Method
    //                                                                     ===============
    // [Behavior Command]
    // -----------------------------------------------------
    //                                                Select
    //                                                ------
    protected int delegateSelectCount(DataConfigToRoleTypeMappingCB cb) {
        return invoke(createSelectCountCBCommand(cb));
    }

    protected void delegateSelectCursor(DataConfigToRoleTypeMappingCB cb,
            EntityRowHandler<DataConfigToRoleTypeMapping> entityRowHandler) {
        invoke(createSelectCursorCBCommand(cb, entityRowHandler,
                DataConfigToRoleTypeMapping.class));
    }

    protected int doCallReadCount(ConditionBean cb) {
        return delegateSelectCount((DataConfigToRoleTypeMappingCB) cb);
    }

    protected List<DataConfigToRoleTypeMapping> delegateSelectList(
            DataConfigToRoleTypeMappingCB cb) {
        return invoke(createSelectListCBCommand(cb,
                DataConfigToRoleTypeMapping.class));
    }

    @SuppressWarnings("unchecked")
    protected List<Entity> doCallReadList(ConditionBean cb) {
        return (List) delegateSelectList((DataConfigToRoleTypeMappingCB) cb);
    }

    // -----------------------------------------------------
    //                                                Update
    //                                                ------
    protected int delegateInsert(DataConfigToRoleTypeMapping e) {
        if (!processBeforeInsert(e)) {
            return 1;
        }
        return invoke(createInsertEntityCommand(e));
    }

    protected int doCallCreate(Entity entity) {
        return delegateInsert(downcast(entity));
    }

    protected int delegateUpdate(DataConfigToRoleTypeMapping e) {
        if (!processBeforeUpdate(e)) {
            return 1;
        }
        return invoke(createUpdateEntityCommand(e));
    }

    protected int doCallModify(Entity entity) {
        return delegateUpdate(downcast(entity));
    }

    protected int delegateDelete(DataConfigToRoleTypeMapping e) {
        if (!processBeforeDelete(e)) {
            return 1;
        }
        return invoke(createDeleteEntityCommand(e));
    }

    protected int doCallRemove(Entity entity) {
        return delegateDelete(downcast(entity));
    }

    protected int[] delegateInsertList(List<DataConfigToRoleTypeMapping> ls) {
        if (ls.isEmpty()) {
            return new int[] {};
        }
        return invoke(createBatchInsertEntityCommand(helpFilterBeforeInsertInternally(ls)));
    }

    @SuppressWarnings("unchecked")
    protected int[] doCreateList(List<Entity> ls) {
        return delegateInsertList((List) ls);
    }

    protected int[] delegateUpdateList(List<DataConfigToRoleTypeMapping> ls) {
        if (ls.isEmpty()) {
            return new int[] {};
        }
        return invoke(createBatchUpdateEntityCommand(helpFilterBeforeUpdateInternally(ls)));
    }

    @SuppressWarnings("unchecked")
    protected int[] doModifyList(List<Entity> ls) {
        return delegateUpdateList((List) ls);
    }

    protected int[] delegateDeleteList(List<DataConfigToRoleTypeMapping> ls) {
        if (ls.isEmpty()) {
            return new int[] {};
        }
        return invoke(createBatchDeleteEntityCommand(helpFilterBeforeDeleteInternally(ls)));
    }

    @SuppressWarnings("unchecked")
    protected int[] doRemoveList(List<Entity> ls) {
        return delegateDeleteList((List) ls);
    }

    // ===================================================================================
    //                                                                Optimistic Lock Info
    //                                                                ====================
    @Override
    protected boolean hasVersionNoValue(Entity entity) {
        return false;
    }

    @Override
    protected boolean hasUpdateDateValue(Entity entity) {
        return false;
    }

    // ===================================================================================
    //                                                                              Helper
    //                                                                              ======
    protected DataConfigToRoleTypeMapping downcast(Entity entity) {
        return helpDowncastInternally(entity, DataConfigToRoleTypeMapping.class);
    }
}
