/*
 * Copyright 2009-2011 the Fess Project and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */

package jp.sf.fess.upload;

import java.io.File;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;

import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileUploadBase.SizeLimitExceededException;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.FileCleanerCleanup;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.io.FileCleaningTracker;
import org.apache.struts.Globals;
import org.apache.struts.config.ModuleConfig;
import org.apache.struts.upload.MultipartRequestHandler;
import org.seasar.struts.upload.S2MultipartRequestHandler;
import org.seasar.struts.util.ServletContextUtil;

public class FessMultipartRequestHandler extends S2MultipartRequestHandler {
    @SuppressWarnings("unchecked")
    @Override
    public void handleRequest(HttpServletRequest request)
            throws ServletException {
        ModuleConfig ac = (ModuleConfig) request
                .getAttribute(Globals.MODULE_KEY);
        FileCleaningTracker fileCleaningTracker = FileCleanerCleanup
                .getFileCleaningTracker(ServletContextUtil.getServletContext());
        DiskFileItemFactory fileItemFactory = new DiskFileItemFactory(
                (int) getSizeThreshold(ac), new File(getRepositoryPath(ac)));
        fileItemFactory.setFileCleaningTracker(fileCleaningTracker);
        ServletFileUpload upload = new ServletFileUpload(fileItemFactory);
        upload.setHeaderEncoding(request.getCharacterEncoding());
        upload.setSizeMax(getSizeMax(ac));
        elementsText = new Hashtable();
        elementsFile = new Hashtable();
        elementsAll = new Hashtable();
        List items = null;
        try {
            items = upload.parseRequest(request);
        } catch (SizeLimitExceededException e) {
            request.setAttribute(
                    MultipartRequestHandler.ATTRIBUTE_MAX_LENGTH_EXCEEDED,
                    Boolean.TRUE);
            request.setAttribute(SIZE_EXCEPTION_KEY, e);
            try {
                InputStream is = request.getInputStream();
                try {
                    byte[] buf = new byte[1024];
                    @SuppressWarnings("unused")
                    int len = 0;
                    while ((len = is.read(buf)) != -1) {
                    }
                } catch (Exception ignore) {
                } finally {
                    try {
                        is.close();
                    } catch (Exception ignore) {
                    }
                }
            } catch (Exception ignore) {
            }
            return;
        } catch (FileUploadException e) {
            log.error("Failed to parse multipart request", e);
            throw new ServletException(e);
        }

        // Partition the items into form fields and files.
        Iterator iter = items.iterator();
        while (iter.hasNext()) {
            FileItem item = (FileItem) iter.next();

            if (item.isFormField()) {
                addTextParameter(request, item);
            } else {
                addFileParameter(item);
            }
        }
    }
}
