/*
 * Copyright 2009-2010 the Fess Project and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */

package jp.sf.fess.db.bsbhv;

import java.util.List;

import jp.sf.fess.db.bsentity.dbmeta.DataCrawlingConfigDbm;
import jp.sf.fess.db.cbean.DataConfigToBrowserTypeMappingCB;
import jp.sf.fess.db.cbean.DataConfigToLabelTypeMappingCB;
import jp.sf.fess.db.cbean.DataConfigToRoleTypeMappingCB;
import jp.sf.fess.db.cbean.DataCrawlingConfigCB;
import jp.sf.fess.db.exbhv.DataConfigToBrowserTypeMappingBhv;
import jp.sf.fess.db.exbhv.DataConfigToLabelTypeMappingBhv;
import jp.sf.fess.db.exbhv.DataConfigToRoleTypeMappingBhv;
import jp.sf.fess.db.exentity.DataConfigToBrowserTypeMapping;
import jp.sf.fess.db.exentity.DataConfigToLabelTypeMapping;
import jp.sf.fess.db.exentity.DataConfigToRoleTypeMapping;
import jp.sf.fess.db.exentity.DataCrawlingConfig;

import org.seasar.dbflute.Entity;
import org.seasar.dbflute.bhv.AbstractBehaviorWritable;
import org.seasar.dbflute.bhv.ConditionBeanSetupper;
import org.seasar.dbflute.bhv.LoadReferrerOption;
import org.seasar.dbflute.bhv.UpdateOption;
import org.seasar.dbflute.cbean.ConditionBean;
import org.seasar.dbflute.cbean.EntityRowHandler;
import org.seasar.dbflute.cbean.ListResultBean;
import org.seasar.dbflute.cbean.PagingResultBean;
import org.seasar.dbflute.dbmeta.DBMeta;

/**
 * The behavior of DATA_CRAWLING_CONFIG as TABLE. <br />
 * <pre>
 * [primary-key]
 *     ID
 * 
 * [column]
 *     ID, NAME, HANDLER_NAME, HANDLER_PARAMETER, HANDLER_SCRIPT, BOOST, AVAILABLE, SORT_ORDER, CREATED_BY, CREATED_TIME, UPDATED_BY, UPDATED_TIME, DELETED_BY, DELETED_TIME, VERSION_NO
 * 
 * [sequence]
 *     
 * 
 * [identity]
 *     ID
 * 
 * [version-no]
 *     VERSION_NO
 * 
 * [foreign-table]
 *     
 * 
 * [referrer-table]
 *     DATA_CONFIG_TO_BROWSER_TYPE_MAPPING, DATA_CONFIG_TO_LABEL_TYPE_MAPPING, DATA_CONFIG_TO_ROLE_TYPE_MAPPING
 * 
 * [foreign-property]
 *     
 * 
 * [referrer-property]
 *     dataConfigToBrowserTypeMappingList, dataConfigToLabelTypeMappingList, dataConfigToRoleTypeMappingList
 * </pre>
 * @author DBFlute(AutoGenerator)
 */
public abstract class BsDataCrawlingConfigBhv extends AbstractBehaviorWritable {

    // ===================================================================================
    //                                                                          Definition
    //                                                                          ==========
    /*df:BehaviorQueryPathBegin*/
    /*df:BehaviorQueryPathEnd*/

    // ===================================================================================
    //                                                                          Table name
    //                                                                          ==========
    /** @return The name on database of table. (NotNull) */
    public String getTableDbName() {
        return "DATA_CRAWLING_CONFIG";
    }

    // ===================================================================================
    //                                                                              DBMeta
    //                                                                              ======
    /** @return The instance of DBMeta. (NotNull) */
    public DBMeta getDBMeta() {
        return DataCrawlingConfigDbm.getInstance();
    }

    /** @return The instance of DBMeta as my table type. (NotNull) */
    public DataCrawlingConfigDbm getMyDBMeta() {
        return DataCrawlingConfigDbm.getInstance();
    }

    // ===================================================================================
    //                                                                        New Instance
    //                                                                        ============
    /** {@inheritDoc} */
    public Entity newEntity() {
        return newMyEntity();
    }

    /** {@inheritDoc} */
    public ConditionBean newConditionBean() {
        return newMyConditionBean();
    }

    /** @return The instance of new entity as my table type. (NotNull) */
    public DataCrawlingConfig newMyEntity() {
        return new DataCrawlingConfig();
    }

    /** @return The instance of new condition-bean as my table type. (NotNull) */
    public DataCrawlingConfigCB newMyConditionBean() {
        return new DataCrawlingConfigCB();
    }

    // ===================================================================================
    //                                                                        Count Select
    //                                                                        ============
    /**
     * Select the count by the condition-bean. {IgnorePagingCondition}
     * <pre>
     * DataCrawlingConfigCB cb = new DataCrawlingConfigCB();
     * cb.query().setFoo...(value);
     * int count = dataCrawlingConfigBhv.<span style="color: #FD4747">selectCount</span>(cb);
     * </pre>
     * @param cb The condition-bean of DataCrawlingConfig. (NotNull)
     * @return The selected count.
     */
    public int selectCount(DataCrawlingConfigCB cb) {
        return doSelectCount(cb);
    }

    protected int doSelectCount(DataCrawlingConfigCB cb) {
        assertCBNotNull(cb);
        return delegateSelectCount(cb);
    }

    @Override
    protected int doReadCount(ConditionBean cb) {
        return selectCount(downcast(cb));
    }

    // ===================================================================================
    //                                                                       Cursor Select
    //                                                                       =============
    /**
     * Select the cursor by the condition-bean.
     * <pre>
     * DataCrawlingConfigCB cb = new DataCrawlingConfigCB();
     * cb.query().setFoo...(value);
     * dataCrawlingConfigBhv.<span style="color: #FD4747">selectCursor</span>(cb, new EntityRowHandler&lt;DataCrawlingConfig&gt;() {
     *     public void handle(DataCrawlingConfig entity) {
     *         ... = entity.getFoo...();
     *     }
     * });
     * </pre>
     * @param cb The condition-bean of DataCrawlingConfig. (NotNull)
     * @param entityRowHandler The handler of entity row of DataCrawlingConfig. (NotNull)
     */
    public void selectCursor(DataCrawlingConfigCB cb,
            EntityRowHandler<DataCrawlingConfig> entityRowHandler) {
        doSelectCursor(cb, entityRowHandler, DataCrawlingConfig.class);
    }

    protected <ENTITY extends DataCrawlingConfig> void doSelectCursor(
            DataCrawlingConfigCB cb, EntityRowHandler<ENTITY> entityRowHandler,
            Class<ENTITY> entityType) {
        assertCBNotNull(cb);
        assertObjectNotNull("entityRowHandler<DataCrawlingConfig>",
                entityRowHandler);
        assertObjectNotNull("entityType", entityType);
        assertSpecifyDerivedReferrerEntityProperty(cb, entityType);
        delegateSelectCursor(cb, entityRowHandler, entityType);
    }

    // ===================================================================================
    //                                                                       Entity Select
    //                                                                       =============
    /**
     * Select the entity by the condition-bean.
     * <pre>
     * DataCrawlingConfigCB cb = new DataCrawlingConfigCB();
     * cb.query().setFoo...(value);
     * DataCrawlingConfig dataCrawlingConfig = dataCrawlingConfigBhv.<span style="color: #FD4747">selectEntity</span>(cb);
     * if (dataCrawlingConfig != null) {
     *     ... = dataCrawlingConfig.get...();
     * } else {
     *     ...
     * }
     * </pre>
     * @param cb The condition-bean of DataCrawlingConfig. (NotNull)
     * @return The selected entity. (Nullable: If the condition has no data, it returns null)
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.SelectEntityConditionNotFoundException When the condition for selecting an entity is not found.
     */
    public DataCrawlingConfig selectEntity(DataCrawlingConfigCB cb) {
        return doSelectEntity(cb, DataCrawlingConfig.class);
    }

    protected <ENTITY extends DataCrawlingConfig> ENTITY doSelectEntity(
            final DataCrawlingConfigCB cb, final Class<ENTITY> entityType) {
        return helpSelectEntityInternally(
                cb,
                new InternalSelectEntityCallback<ENTITY, DataCrawlingConfigCB>() {
                    public List<ENTITY> callbackSelectList(
                            DataCrawlingConfigCB cb) {
                        return doSelectList(cb, entityType);
                    }
                });
    }

    @Override
    protected Entity doReadEntity(ConditionBean cb) {
        return selectEntity(downcast(cb));
    }

    /**
     * Select the entity by the condition-bean with deleted check.
     * <pre>
     * DataCrawlingConfigCB cb = new DataCrawlingConfigCB();
     * cb.query().setFoo...(value);
     * DataCrawlingConfig dataCrawlingConfig = dataCrawlingConfigBhv.<span style="color: #FD4747">selectEntityWithDeletedCheck</span>(cb);
     * ... = dataCrawlingConfig.get...(); <span style="color: #3F7E5E">// the entity always be not null</span>
     * </pre>
     * @param cb The condition-bean of DataCrawlingConfig. (NotNull)
     * @return The selected entity. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.SelectEntityConditionNotFoundException When the condition for selecting an entity is not found.
     */
    public DataCrawlingConfig selectEntityWithDeletedCheck(
            DataCrawlingConfigCB cb) {
        return doSelectEntityWithDeletedCheck(cb, DataCrawlingConfig.class);
    }

    protected <ENTITY extends DataCrawlingConfig> ENTITY doSelectEntityWithDeletedCheck(
            final DataCrawlingConfigCB cb, final Class<ENTITY> entityType) {
        return helpSelectEntityWithDeletedCheckInternally(
                cb,
                new InternalSelectEntityWithDeletedCheckCallback<ENTITY, DataCrawlingConfigCB>() {
                    public List<ENTITY> callbackSelectList(
                            DataCrawlingConfigCB cb) {
                        return doSelectList(cb, entityType);
                    }
                });
    }

    @Override
    protected Entity doReadEntityWithDeletedCheck(ConditionBean cb) {
        return selectEntityWithDeletedCheck(downcast(cb));
    }

    /**
     * Select the entity by the primary-key value.
     * @param id The one of primary key. (NotNull)
     * @return The selected entity. (Nullable: If the primary-key value has no data, it returns null)
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.SelectEntityConditionNotFoundException When the condition for selecting an entity is not found.
     */
    public DataCrawlingConfig selectByPKValue(Long id) {
        return doSelectByPKValue(id, DataCrawlingConfig.class);
    }

    protected <ENTITY extends DataCrawlingConfig> ENTITY doSelectByPKValue(
            Long id, Class<ENTITY> entityType) {
        return doSelectEntity(buildPKCB(id), entityType);
    }

    /**
     * Select the entity by the primary-key value with deleted check.
     * @param id The one of primary key. (NotNull)
     * @return The selected entity. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.SelectEntityConditionNotFoundException When the condition for selecting an entity is not found.
     */
    public DataCrawlingConfig selectByPKValueWithDeletedCheck(Long id) {
        return doSelectByPKValueWithDeletedCheck(id, DataCrawlingConfig.class);
    }

    protected <ENTITY extends DataCrawlingConfig> ENTITY doSelectByPKValueWithDeletedCheck(
            Long id, Class<ENTITY> entityType) {
        return doSelectEntityWithDeletedCheck(buildPKCB(id), entityType);
    }

    private DataCrawlingConfigCB buildPKCB(Long id) {
        assertObjectNotNull("id", id);
        DataCrawlingConfigCB cb = newMyConditionBean();
        cb.query().setId_Equal(id);
        return cb;
    }

    // ===================================================================================
    //                                                                         List Select
    //                                                                         ===========
    /**
     * Select the list as result bean.
     * <pre>
     * DataCrawlingConfigCB cb = new DataCrawlingConfigCB();
     * cb.query().setFoo...(value);
     * cb.query().addOrderBy_Bar...();
     * ListResultBean&lt;DataCrawlingConfig&gt; dataCrawlingConfigList = dataCrawlingConfigBhv.<span style="color: #FD4747">selectList</span>(cb);
     * for (DataCrawlingConfig dataCrawlingConfig : dataCrawlingConfigList) {
     *     ... = dataCrawlingConfig.get...();
     * }
     * </pre>
     * @param cb The condition-bean of DataCrawlingConfig. (NotNull)
     * @return The result bean of selected list. (NotNull)
     * @exception org.seasar.dbflute.exception.DangerousResultSizeException When the result size is over the specified safety size.
     */
    public ListResultBean<DataCrawlingConfig> selectList(DataCrawlingConfigCB cb) {
        return doSelectList(cb, DataCrawlingConfig.class);
    }

    protected <ENTITY extends DataCrawlingConfig> ListResultBean<ENTITY> doSelectList(
            DataCrawlingConfigCB cb, Class<ENTITY> entityType) {
        assertCBNotNull(cb);
        assertObjectNotNull("entityType", entityType);
        assertSpecifyDerivedReferrerEntityProperty(cb, entityType);
        return helpSelectListInternally(cb, entityType,
                new InternalSelectListCallback<ENTITY, DataCrawlingConfigCB>() {
                    public List<ENTITY> callbackSelectList(
                            DataCrawlingConfigCB cb, Class<ENTITY> entityType) {
                        return delegateSelectList(cb, entityType);
                    }
                });
    }

    @Override
    protected ListResultBean<? extends Entity> doReadList(ConditionBean cb) {
        return selectList(downcast(cb));
    }

    // ===================================================================================
    //                                                                         Page Select
    //                                                                         ===========
    /**
     * Select the page as result bean. <br />
     * (both count-select and paging-select are executed)
     * <pre>
     * DataCrawlingConfigCB cb = new DataCrawlingConfigCB();
     * cb.query().setFoo...(value);
     * cb.query().addOrderBy_Bar...();
     * cb.<span style="color: #FD4747">paging</span>(20, 3); <span style="color: #3F7E5E">// 20 records per a page and current page number is 3</span>
     * PagingResultBean&lt;DataCrawlingConfig&gt; page = dataCrawlingConfigBhv.<span style="color: #FD4747">selectPage</span>(cb);
     * int allRecordCount = page.getAllRecordCount();
     * int allPageCount = page.getAllPageCount();
     * boolean isExistPrePage = page.isExistPrePage();
     * boolean isExistNextPage = page.isExistNextPage();
     * ...
     * for (DataCrawlingConfig dataCrawlingConfig : page) {
     *     ... = dataCrawlingConfig.get...();
     * }
     * </pre>
     * @param cb The condition-bean of DataCrawlingConfig. (NotNull)
     * @return The result bean of selected page. (NotNull)
     * @exception org.seasar.dbflute.exception.DangerousResultSizeException When the result size is over the specified safety size.
     */
    public PagingResultBean<DataCrawlingConfig> selectPage(
            DataCrawlingConfigCB cb) {
        return doSelectPage(cb, DataCrawlingConfig.class);
    }

    protected <ENTITY extends DataCrawlingConfig> PagingResultBean<ENTITY> doSelectPage(
            DataCrawlingConfigCB cb, Class<ENTITY> entityType) {
        assertCBNotNull(cb);
        assertObjectNotNull("entityType", entityType);
        return helpSelectPageInternally(cb, entityType,
                new InternalSelectPageCallback<ENTITY, DataCrawlingConfigCB>() {
                    public int callbackSelectCount(DataCrawlingConfigCB cb) {
                        return doSelectCount(cb);
                    }

                    public List<ENTITY> callbackSelectList(
                            DataCrawlingConfigCB cb, Class<ENTITY> entityType) {
                        return doSelectList(cb, entityType);
                    }
                });
    }

    @Override
    protected PagingResultBean<? extends Entity> doReadPage(ConditionBean cb) {
        return selectPage(downcast(cb));
    }

    // ===================================================================================
    //                                                                       Scalar Select
    //                                                                       =============
    /**
     * Select the scalar value derived by a function. <br />
     * You should call a function method after this method called like as follows:
     * <pre>
     * dataCrawlingConfigBhv.<span style="color: #FD4747">scalarSelect</span>(Date.class).max(new ScalarQuery() {
     *     public void query(DataCrawlingConfigCB cb) {
     *         cb.specify().<span style="color: #FD4747">columnFooDatetime()</span>; <span style="color: #3F7E5E">// required for a function</span>
     *         cb.query().setBarName_PrefixSearch("S");
     *     }
     * });
     * </pre>
     * @param <RESULT> The type of result.
     * @param resultType The type of result. (NotNull)
     * @return The scalar value derived by a function. (Nullable)
     */
    public <RESULT> SLFunction<DataCrawlingConfigCB, RESULT> scalarSelect(
            Class<RESULT> resultType) {
        return doScalarSelect(resultType, newMyConditionBean());
    }

    protected <RESULT, CB extends DataCrawlingConfigCB> SLFunction<CB, RESULT> doScalarSelect(
            Class<RESULT> resultType, CB cb) {
        assertObjectNotNull("resultType", resultType);
        assertCBNotNull(cb);
        cb.xsetupForScalarSelect();
        cb.getSqlClause().disableSelectIndex(); // for when you use union
        return new SLFunction<CB, RESULT>(cb, resultType);
    }

    // ===================================================================================
    //                                                                            Sequence
    //                                                                            ========
    @Override
    protected Number doReadNextVal() {
        String msg = "This table is NOT related to sequence: "
                + getTableDbName();
        throw new UnsupportedOperationException(msg);
    }

    // ===================================================================================
    //                                                                       Load Referrer
    //                                                                       =============
    /**
     * {Refer to overload method that has an argument of the list of entity.}
     * @param dataCrawlingConfig The entity of dataCrawlingConfig. (NotNull)
     * @param conditionBeanSetupper The instance of referrer condition-bean set-upper for registering referrer condition. (NotNull)
     */
    public void loadDataConfigToBrowserTypeMappingList(
            DataCrawlingConfig dataCrawlingConfig,
            ConditionBeanSetupper<DataConfigToBrowserTypeMappingCB> conditionBeanSetupper) {
        xassLRArg(dataCrawlingConfig, conditionBeanSetupper);
        loadDataConfigToBrowserTypeMappingList(xnewLRLs(dataCrawlingConfig),
                conditionBeanSetupper);
    }

    /**
     * Load referrer of dataConfigToBrowserTypeMappingList with the set-upper for condition-bean of referrer.
     * <pre>
     * dataCrawlingConfigBhv.<span style="color: #FD4747">loadDataConfigToBrowserTypeMappingList</span>(dataCrawlingConfigList, new ConditionBeanSetupper&lt;DataConfigToBrowserTypeMappingCB&gt;() {
     *     public void setup(DataConfigToBrowserTypeMappingCB cb) {
     *         cb.setupSelect...();
     *         cb.query().setFoo...(value);
     *         cb.query().addOrderBy_Bar...(); <span style="color: #3F7E5E">// basically you should order referrer list</span>
     *     }
     * });
     * for (DataCrawlingConfig dataCrawlingConfig : dataCrawlingConfigList) {
     *     ... = dataCrawlingConfig.<span style="color: #FD4747">getDataConfigToBrowserTypeMappingList()</span>;
     * }
     * </pre>
     * About internal policy, the value of primary key(and others too) is treated as case-insensitive. <br />
     * The condition-bean that the set-upper provides have settings before you touch it. It is as follows:
     * <pre>
     * cb.query().setDataConfigId_InScope(pkList);
     * cb.query().addOrderBy_DataConfigId_Asc();
     * </pre>
     * @param dataCrawlingConfigList The entity list of dataCrawlingConfig. (NotNull)
     * @param conditionBeanSetupper The instance of referrer condition-bean set-upper for registering referrer condition. (NotNull)
     */
    public void loadDataConfigToBrowserTypeMappingList(
            List<DataCrawlingConfig> dataCrawlingConfigList,
            ConditionBeanSetupper<DataConfigToBrowserTypeMappingCB> conditionBeanSetupper) {
        xassLRArg(dataCrawlingConfigList, conditionBeanSetupper);
        loadDataConfigToBrowserTypeMappingList(
                dataCrawlingConfigList,
                new LoadReferrerOption<DataConfigToBrowserTypeMappingCB, DataConfigToBrowserTypeMapping>(
                        conditionBeanSetupper));
    }

    /**
     * {Refer to overload method that has an argument of the list of entity.}
     * @param dataCrawlingConfig The entity of dataCrawlingConfig. (NotNull)
     * @param loadReferrerOption The option of load-referrer. (NotNull)
     */
    public void loadDataConfigToBrowserTypeMappingList(
            DataCrawlingConfig dataCrawlingConfig,
            LoadReferrerOption<DataConfigToBrowserTypeMappingCB, DataConfigToBrowserTypeMapping> loadReferrerOption) {
        xassLRArg(dataCrawlingConfig, loadReferrerOption);
        loadDataConfigToBrowserTypeMappingList(xnewLRLs(dataCrawlingConfig),
                loadReferrerOption);
    }

    /**
     * {Refer to overload method that has an argument of condition-bean setupper.}
     * @param dataCrawlingConfigList The entity list of dataCrawlingConfig. (NotNull)
     * @param loadReferrerOption The option of load-referrer. (NotNull)
     */
    public void loadDataConfigToBrowserTypeMappingList(
            List<DataCrawlingConfig> dataCrawlingConfigList,
            LoadReferrerOption<DataConfigToBrowserTypeMappingCB, DataConfigToBrowserTypeMapping> loadReferrerOption) {
        xassLRArg(dataCrawlingConfigList, loadReferrerOption);
        if (dataCrawlingConfigList.isEmpty()) {
            return;
        }
        final DataConfigToBrowserTypeMappingBhv referrerBhv = xgetBSFLR()
                .select(DataConfigToBrowserTypeMappingBhv.class);
        helpLoadReferrerInternally(
                dataCrawlingConfigList,
                loadReferrerOption,
                new InternalLoadReferrerCallback<DataCrawlingConfig, Long, DataConfigToBrowserTypeMappingCB, DataConfigToBrowserTypeMapping>() {
                    public Long getPKVal(DataCrawlingConfig e) {
                        return e.getId();
                    }

                    public void setRfLs(DataCrawlingConfig e,
                            List<DataConfigToBrowserTypeMapping> ls) {
                        e.setDataConfigToBrowserTypeMappingList(ls);
                    }

                    public DataConfigToBrowserTypeMappingCB newMyCB() {
                        return referrerBhv.newMyConditionBean();
                    }

                    public void qyFKIn(DataConfigToBrowserTypeMappingCB cb,
                            List<Long> ls) {
                        cb.query().setDataConfigId_InScope(ls);
                    }

                    public void qyOdFKAsc(DataConfigToBrowserTypeMappingCB cb) {
                        cb.query().addOrderBy_DataConfigId_Asc();
                    }

                    public List<DataConfigToBrowserTypeMapping> selRfLs(
                            DataConfigToBrowserTypeMappingCB cb) {
                        return referrerBhv.selectList(cb);
                    }

                    public Long getFKVal(DataConfigToBrowserTypeMapping e) {
                        return e.getDataConfigId();
                    }

                    public void setlcEt(DataConfigToBrowserTypeMapping re,
                            DataCrawlingConfig le) {
                        re.setDataCrawlingConfig(le);
                    }
                });
    }

    /**
     * {Refer to overload method that has an argument of the list of entity.}
     * @param dataCrawlingConfig The entity of dataCrawlingConfig. (NotNull)
     * @param conditionBeanSetupper The instance of referrer condition-bean set-upper for registering referrer condition. (NotNull)
     */
    public void loadDataConfigToLabelTypeMappingList(
            DataCrawlingConfig dataCrawlingConfig,
            ConditionBeanSetupper<DataConfigToLabelTypeMappingCB> conditionBeanSetupper) {
        xassLRArg(dataCrawlingConfig, conditionBeanSetupper);
        loadDataConfigToLabelTypeMappingList(xnewLRLs(dataCrawlingConfig),
                conditionBeanSetupper);
    }

    /**
     * Load referrer of dataConfigToLabelTypeMappingList with the set-upper for condition-bean of referrer.
     * <pre>
     * dataCrawlingConfigBhv.<span style="color: #FD4747">loadDataConfigToLabelTypeMappingList</span>(dataCrawlingConfigList, new ConditionBeanSetupper&lt;DataConfigToLabelTypeMappingCB&gt;() {
     *     public void setup(DataConfigToLabelTypeMappingCB cb) {
     *         cb.setupSelect...();
     *         cb.query().setFoo...(value);
     *         cb.query().addOrderBy_Bar...(); <span style="color: #3F7E5E">// basically you should order referrer list</span>
     *     }
     * });
     * for (DataCrawlingConfig dataCrawlingConfig : dataCrawlingConfigList) {
     *     ... = dataCrawlingConfig.<span style="color: #FD4747">getDataConfigToLabelTypeMappingList()</span>;
     * }
     * </pre>
     * About internal policy, the value of primary key(and others too) is treated as case-insensitive. <br />
     * The condition-bean that the set-upper provides have settings before you touch it. It is as follows:
     * <pre>
     * cb.query().setDataConfigId_InScope(pkList);
     * cb.query().addOrderBy_DataConfigId_Asc();
     * </pre>
     * @param dataCrawlingConfigList The entity list of dataCrawlingConfig. (NotNull)
     * @param conditionBeanSetupper The instance of referrer condition-bean set-upper for registering referrer condition. (NotNull)
     */
    public void loadDataConfigToLabelTypeMappingList(
            List<DataCrawlingConfig> dataCrawlingConfigList,
            ConditionBeanSetupper<DataConfigToLabelTypeMappingCB> conditionBeanSetupper) {
        xassLRArg(dataCrawlingConfigList, conditionBeanSetupper);
        loadDataConfigToLabelTypeMappingList(
                dataCrawlingConfigList,
                new LoadReferrerOption<DataConfigToLabelTypeMappingCB, DataConfigToLabelTypeMapping>(
                        conditionBeanSetupper));
    }

    /**
     * {Refer to overload method that has an argument of the list of entity.}
     * @param dataCrawlingConfig The entity of dataCrawlingConfig. (NotNull)
     * @param loadReferrerOption The option of load-referrer. (NotNull)
     */
    public void loadDataConfigToLabelTypeMappingList(
            DataCrawlingConfig dataCrawlingConfig,
            LoadReferrerOption<DataConfigToLabelTypeMappingCB, DataConfigToLabelTypeMapping> loadReferrerOption) {
        xassLRArg(dataCrawlingConfig, loadReferrerOption);
        loadDataConfigToLabelTypeMappingList(xnewLRLs(dataCrawlingConfig),
                loadReferrerOption);
    }

    /**
     * {Refer to overload method that has an argument of condition-bean setupper.}
     * @param dataCrawlingConfigList The entity list of dataCrawlingConfig. (NotNull)
     * @param loadReferrerOption The option of load-referrer. (NotNull)
     */
    public void loadDataConfigToLabelTypeMappingList(
            List<DataCrawlingConfig> dataCrawlingConfigList,
            LoadReferrerOption<DataConfigToLabelTypeMappingCB, DataConfigToLabelTypeMapping> loadReferrerOption) {
        xassLRArg(dataCrawlingConfigList, loadReferrerOption);
        if (dataCrawlingConfigList.isEmpty()) {
            return;
        }
        final DataConfigToLabelTypeMappingBhv referrerBhv = xgetBSFLR().select(
                DataConfigToLabelTypeMappingBhv.class);
        helpLoadReferrerInternally(
                dataCrawlingConfigList,
                loadReferrerOption,
                new InternalLoadReferrerCallback<DataCrawlingConfig, Long, DataConfigToLabelTypeMappingCB, DataConfigToLabelTypeMapping>() {
                    public Long getPKVal(DataCrawlingConfig e) {
                        return e.getId();
                    }

                    public void setRfLs(DataCrawlingConfig e,
                            List<DataConfigToLabelTypeMapping> ls) {
                        e.setDataConfigToLabelTypeMappingList(ls);
                    }

                    public DataConfigToLabelTypeMappingCB newMyCB() {
                        return referrerBhv.newMyConditionBean();
                    }

                    public void qyFKIn(DataConfigToLabelTypeMappingCB cb,
                            List<Long> ls) {
                        cb.query().setDataConfigId_InScope(ls);
                    }

                    public void qyOdFKAsc(DataConfigToLabelTypeMappingCB cb) {
                        cb.query().addOrderBy_DataConfigId_Asc();
                    }

                    public List<DataConfigToLabelTypeMapping> selRfLs(
                            DataConfigToLabelTypeMappingCB cb) {
                        return referrerBhv.selectList(cb);
                    }

                    public Long getFKVal(DataConfigToLabelTypeMapping e) {
                        return e.getDataConfigId();
                    }

                    public void setlcEt(DataConfigToLabelTypeMapping re,
                            DataCrawlingConfig le) {
                        re.setDataCrawlingConfig(le);
                    }
                });
    }

    /**
     * {Refer to overload method that has an argument of the list of entity.}
     * @param dataCrawlingConfig The entity of dataCrawlingConfig. (NotNull)
     * @param conditionBeanSetupper The instance of referrer condition-bean set-upper for registering referrer condition. (NotNull)
     */
    public void loadDataConfigToRoleTypeMappingList(
            DataCrawlingConfig dataCrawlingConfig,
            ConditionBeanSetupper<DataConfigToRoleTypeMappingCB> conditionBeanSetupper) {
        xassLRArg(dataCrawlingConfig, conditionBeanSetupper);
        loadDataConfigToRoleTypeMappingList(xnewLRLs(dataCrawlingConfig),
                conditionBeanSetupper);
    }

    /**
     * Load referrer of dataConfigToRoleTypeMappingList with the set-upper for condition-bean of referrer.
     * <pre>
     * dataCrawlingConfigBhv.<span style="color: #FD4747">loadDataConfigToRoleTypeMappingList</span>(dataCrawlingConfigList, new ConditionBeanSetupper&lt;DataConfigToRoleTypeMappingCB&gt;() {
     *     public void setup(DataConfigToRoleTypeMappingCB cb) {
     *         cb.setupSelect...();
     *         cb.query().setFoo...(value);
     *         cb.query().addOrderBy_Bar...(); <span style="color: #3F7E5E">// basically you should order referrer list</span>
     *     }
     * });
     * for (DataCrawlingConfig dataCrawlingConfig : dataCrawlingConfigList) {
     *     ... = dataCrawlingConfig.<span style="color: #FD4747">getDataConfigToRoleTypeMappingList()</span>;
     * }
     * </pre>
     * About internal policy, the value of primary key(and others too) is treated as case-insensitive. <br />
     * The condition-bean that the set-upper provides have settings before you touch it. It is as follows:
     * <pre>
     * cb.query().setDataConfigId_InScope(pkList);
     * cb.query().addOrderBy_DataConfigId_Asc();
     * </pre>
     * @param dataCrawlingConfigList The entity list of dataCrawlingConfig. (NotNull)
     * @param conditionBeanSetupper The instance of referrer condition-bean set-upper for registering referrer condition. (NotNull)
     */
    public void loadDataConfigToRoleTypeMappingList(
            List<DataCrawlingConfig> dataCrawlingConfigList,
            ConditionBeanSetupper<DataConfigToRoleTypeMappingCB> conditionBeanSetupper) {
        xassLRArg(dataCrawlingConfigList, conditionBeanSetupper);
        loadDataConfigToRoleTypeMappingList(
                dataCrawlingConfigList,
                new LoadReferrerOption<DataConfigToRoleTypeMappingCB, DataConfigToRoleTypeMapping>(
                        conditionBeanSetupper));
    }

    /**
     * {Refer to overload method that has an argument of the list of entity.}
     * @param dataCrawlingConfig The entity of dataCrawlingConfig. (NotNull)
     * @param loadReferrerOption The option of load-referrer. (NotNull)
     */
    public void loadDataConfigToRoleTypeMappingList(
            DataCrawlingConfig dataCrawlingConfig,
            LoadReferrerOption<DataConfigToRoleTypeMappingCB, DataConfigToRoleTypeMapping> loadReferrerOption) {
        xassLRArg(dataCrawlingConfig, loadReferrerOption);
        loadDataConfigToRoleTypeMappingList(xnewLRLs(dataCrawlingConfig),
                loadReferrerOption);
    }

    /**
     * {Refer to overload method that has an argument of condition-bean setupper.}
     * @param dataCrawlingConfigList The entity list of dataCrawlingConfig. (NotNull)
     * @param loadReferrerOption The option of load-referrer. (NotNull)
     */
    public void loadDataConfigToRoleTypeMappingList(
            List<DataCrawlingConfig> dataCrawlingConfigList,
            LoadReferrerOption<DataConfigToRoleTypeMappingCB, DataConfigToRoleTypeMapping> loadReferrerOption) {
        xassLRArg(dataCrawlingConfigList, loadReferrerOption);
        if (dataCrawlingConfigList.isEmpty()) {
            return;
        }
        final DataConfigToRoleTypeMappingBhv referrerBhv = xgetBSFLR().select(
                DataConfigToRoleTypeMappingBhv.class);
        helpLoadReferrerInternally(
                dataCrawlingConfigList,
                loadReferrerOption,
                new InternalLoadReferrerCallback<DataCrawlingConfig, Long, DataConfigToRoleTypeMappingCB, DataConfigToRoleTypeMapping>() {
                    public Long getPKVal(DataCrawlingConfig e) {
                        return e.getId();
                    }

                    public void setRfLs(DataCrawlingConfig e,
                            List<DataConfigToRoleTypeMapping> ls) {
                        e.setDataConfigToRoleTypeMappingList(ls);
                    }

                    public DataConfigToRoleTypeMappingCB newMyCB() {
                        return referrerBhv.newMyConditionBean();
                    }

                    public void qyFKIn(DataConfigToRoleTypeMappingCB cb,
                            List<Long> ls) {
                        cb.query().setDataConfigId_InScope(ls);
                    }

                    public void qyOdFKAsc(DataConfigToRoleTypeMappingCB cb) {
                        cb.query().addOrderBy_DataConfigId_Asc();
                    }

                    public List<DataConfigToRoleTypeMapping> selRfLs(
                            DataConfigToRoleTypeMappingCB cb) {
                        return referrerBhv.selectList(cb);
                    }

                    public Long getFKVal(DataConfigToRoleTypeMapping e) {
                        return e.getDataConfigId();
                    }

                    public void setlcEt(DataConfigToRoleTypeMapping re,
                            DataCrawlingConfig le) {
                        re.setDataCrawlingConfig(le);
                    }
                });
    }

    // ===================================================================================
    //                                                                    Pull out Foreign
    //                                                                    ================

    // ===================================================================================
    //                                                                       Entity Update
    //                                                                       =============
    /**
     * Insert the entity.
     * <pre>
     * DataCrawlingConfig dataCrawlingConfig = new DataCrawlingConfig();
     * <span style="color: #3F7E5E">// if auto-increment, you don't need to set the PK value</span>
     * dataCrawlingConfig.setFoo...(value);
     * dataCrawlingConfig.setBar...(value);
     * dataCrawlingConfigBhv.<span style="color: #FD4747">insert</span>(dataCrawlingConfig);
     * ... = dataCrawlingConfig.getPK...(); <span style="color: #3F7E5E">// if auto-increment, you can get the value after</span>
     * </pre>
     * @param dataCrawlingConfig The entity of insert target. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void insert(DataCrawlingConfig dataCrawlingConfig) {
        assertEntityNotNull(dataCrawlingConfig);
        delegateInsert(dataCrawlingConfig);
    }

    @Override
    protected void doCreate(Entity entity) {
        insert(downcast(entity));
    }

    /**
     * Update the entity modified-only. {UpdateCountZeroException, ExclusiveControl}
     * <pre>
     * DataCrawlingConfig dataCrawlingConfig = new DataCrawlingConfig();
     * dataCrawlingConfig.setPK...(value); <span style="color: #3F7E5E">// required</span>
     * dataCrawlingConfig.setFoo...(value); <span style="color: #3F7E5E">// you should set only modified columns</span>
     * <span style="color: #3F7E5E">// if exclusive control, the value of exclusive control column is required</span>
     * dataCrawlingConfig.<span style="color: #FD4747">setVersionNo</span>(value);
     * try {
     *     dataCrawlingConfigBhv.<span style="color: #FD4747">update</span>(dataCrawlingConfig);
     * } catch (EntityAlreadyUpdatedException e) { <span style="color: #3F7E5E">// if concurrent update</span>
     *     ...
     * } 
     * </pre>
     * @param dataCrawlingConfig The entity of update target. (NotNull) {PrimaryKeyRequired, ConcurrencyColumnRequired}
     * @exception org.seasar.dbflute.exception.EntityAlreadyUpdatedException When the entity has already been updated.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void update(final DataCrawlingConfig dataCrawlingConfig) {
        helpUpdateInternally(dataCrawlingConfig,
                new InternalUpdateCallback<DataCrawlingConfig>() {
                    public int callbackDelegateUpdate(DataCrawlingConfig entity) {
                        return delegateUpdate(entity);
                    }
                });
    }

    @Override
    protected void doModify(Entity entity) {
        update(downcast(entity));
    }

    /**
     * Update the entity non-strictly modified-only. {UpdateCountZeroException, NonExclusiveControl}
     * <pre>
     * DataCrawlingConfig dataCrawlingConfig = new DataCrawlingConfig();
     * dataCrawlingConfig.setPK...(value); <span style="color: #3F7E5E">// required</span>
     * dataCrawlingConfig.setFoo...(value); <span style="color: #3F7E5E">// you should set only modified columns</span>
     * <span style="color: #3F7E5E">// you don't need to set the value of exclusive control column</span>
     * <span style="color: #3F7E5E">// (auto-increment for version number is valid though non-exclusive control)</span>
     * <span style="color: #3F7E5E">//dataCrawlingConfig.setVersionNo(value);</span>
     * dataCrawlingConfigBhv.<span style="color: #FD4747">updateNonstrict</span>(dataCrawlingConfig);
     * </pre>
     * @param dataCrawlingConfig The entity of update target. (NotNull) {PrimaryKeyRequired}
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void updateNonstrict(final DataCrawlingConfig dataCrawlingConfig) {
        helpUpdateNonstrictInternally(dataCrawlingConfig,
                new InternalUpdateNonstrictCallback<DataCrawlingConfig>() {
                    public int callbackDelegateUpdateNonstrict(
                            DataCrawlingConfig entity) {
                        return delegateUpdateNonstrict(entity);
                    }
                });
    }

    @Override
    protected void doModifyNonstrict(Entity entity) {
        updateNonstrict(downcast(entity));
    }

    /**
     * Insert or update the entity modified-only. {ExclusiveControl(when update)}
     * @param dataCrawlingConfig The entity of insert or update target. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyUpdatedException When the entity has already been updated.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void insertOrUpdate(final DataCrawlingConfig dataCrawlingConfig) {
        helpInsertOrUpdateInternally(
                dataCrawlingConfig,
                new InternalInsertOrUpdateCallback<DataCrawlingConfig, DataCrawlingConfigCB>() {
                    public void callbackInsert(DataCrawlingConfig entity) {
                        insert(entity);
                    }

                    public void callbackUpdate(DataCrawlingConfig entity) {
                        update(entity);
                    }

                    public DataCrawlingConfigCB callbackNewMyConditionBean() {
                        return newMyConditionBean();
                    }

                    public int callbackSelectCount(DataCrawlingConfigCB cb) {
                        return selectCount(cb);
                    }
                });
    }

    @Override
    protected void doCreateOrUpdate(Entity entity) {
        insertOrUpdate(downcast(entity));
    }

    /**
     * Insert or update the entity non-strictly modified-only. {NonExclusiveControl(when update)}
     * @param dataCrawlingConfig The entity of insert or update target. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void insertOrUpdateNonstrict(DataCrawlingConfig dataCrawlingConfig) {
        helpInsertOrUpdateInternally(
                dataCrawlingConfig,
                new InternalInsertOrUpdateNonstrictCallback<DataCrawlingConfig>() {
                    public void callbackInsert(DataCrawlingConfig entity) {
                        insert(entity);
                    }

                    public void callbackUpdateNonstrict(
                            DataCrawlingConfig entity) {
                        updateNonstrict(entity);
                    }
                });
    }

    @Override
    protected void doCreateOrUpdateNonstrict(Entity entity) {
        insertOrUpdateNonstrict(downcast(entity));
    }

    /**
     * Delete the entity. {UpdateCountZeroException, ExclusiveControl}
     * <pre>
     * DataCrawlingConfig dataCrawlingConfig = new DataCrawlingConfig();
     * dataCrawlingConfig.setPK...(value); <span style="color: #3F7E5E">// required</span>
     * <span style="color: #3F7E5E">// if exclusive control, the value of exclusive control column is required</span>
     * dataCrawlingConfig.<span style="color: #FD4747">setVersionNo</span>(value);
     * try {
     *     dataCrawlingConfigBhv.<span style="color: #FD4747">delete</span>(dataCrawlingConfig);
     * } catch (EntityAlreadyUpdatedException e) { <span style="color: #3F7E5E">// if concurrent update</span>
     *     ...
     * } 
     * </pre>
     * @param dataCrawlingConfig The entity of delete target. (NotNull) {PrimaryKeyRequired, ConcurrencyColumnRequired}
     * @exception org.seasar.dbflute.exception.EntityAlreadyUpdatedException When the entity has already been updated.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     */
    public void delete(DataCrawlingConfig dataCrawlingConfig) {
        helpDeleteInternally(dataCrawlingConfig,
                new InternalDeleteCallback<DataCrawlingConfig>() {
                    public int callbackDelegateDelete(DataCrawlingConfig entity) {
                        return delegateDelete(entity);
                    }
                });
    }

    @Override
    protected void doRemove(Entity entity) {
        delete(downcast(entity));
    }

    /**
     * Delete the entity non-strictly. {UpdateCountZeroException, NonExclusiveControl}
     * <pre>
     * DataCrawlingConfig dataCrawlingConfig = new DataCrawlingConfig();
     * dataCrawlingConfig.setPK...(value); <span style="color: #3F7E5E">// required</span>
     * <span style="color: #3F7E5E">// you don't need to set the value of exclusive control column</span>
     * <span style="color: #3F7E5E">// (auto-increment for version number is valid though non-exclusive control)</span>
     * <span style="color: #3F7E5E">//dataCrawlingConfig.setVersionNo(value);</span>
     * dataCrawlingConfigBhv.<span style="color: #FD4747">deleteNonstrict</span>(dataCrawlingConfig);
     * </pre>
     * @param dataCrawlingConfig Entity. (NotNull) {PrimaryKeyRequired}
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     */
    public void deleteNonstrict(DataCrawlingConfig dataCrawlingConfig) {
        helpDeleteNonstrictInternally(dataCrawlingConfig,
                new InternalDeleteNonstrictCallback<DataCrawlingConfig>() {
                    public int callbackDelegateDeleteNonstrict(
                            DataCrawlingConfig entity) {
                        return delegateDeleteNonstrict(entity);
                    }
                });
    }

    /**
     * Delete the entity non-strictly ignoring deleted. {UpdateCountZeroException, NonExclusiveControl}
     * <pre>
     * DataCrawlingConfig dataCrawlingConfig = new DataCrawlingConfig();
     * dataCrawlingConfig.setPK...(value); <span style="color: #3F7E5E">// required</span>
     * <span style="color: #3F7E5E">// you don't need to set the value of exclusive control column</span>
     * <span style="color: #3F7E5E">// (auto-increment for version number is valid though non-exclusive control)</span>
     * <span style="color: #3F7E5E">//dataCrawlingConfig.setVersionNo(value);</span>
     * dataCrawlingConfigBhv.<span style="color: #FD4747">deleteNonstrictIgnoreDeleted</span>(dataCrawlingConfig);
     * <span style="color: #3F7E5E">// if the target entity doesn't exist, no exception</span>
     * </pre>
     * @param dataCrawlingConfig Entity. (NotNull) {PrimaryKeyRequired}
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     */
    public void deleteNonstrictIgnoreDeleted(
            DataCrawlingConfig dataCrawlingConfig) {
        helpDeleteNonstrictIgnoreDeletedInternally(
                dataCrawlingConfig,
                new InternalDeleteNonstrictIgnoreDeletedCallback<DataCrawlingConfig>() {
                    public int callbackDelegateDeleteNonstrict(
                            DataCrawlingConfig entity) {
                        return delegateDeleteNonstrict(entity);
                    }
                });
    }

    // ===================================================================================
    //                                                                        Batch Update
    //                                                                        ============
    /**
     * Batch-insert the list. This method uses 'Batch Update' of java.sql.PreparedStatement.
     * @param dataCrawlingConfigList The list of the entity. (NotNull)
     * @return The array of inserted count.
     */
    public int[] batchInsert(List<DataCrawlingConfig> dataCrawlingConfigList) {
        assertObjectNotNull("dataCrawlingConfigList", dataCrawlingConfigList);
        return delegateInsertList(dataCrawlingConfigList);
    }

    /**
     * Batch-update the list. <br />
     * All columns are update target. {NOT modified only} <br />
     * This method uses 'Batch Update' of java.sql.PreparedStatement.
     * @param dataCrawlingConfigList The list of the entity. (NotNull)
     * @return The array of updated count.
     * @exception org.seasar.dbflute.exception.BatchEntityAlreadyUpdatedException When the entity has already been updated. This exception extends EntityAlreadyUpdatedException.
     */
    public int[] batchUpdate(List<DataCrawlingConfig> dataCrawlingConfigList) {
        assertObjectNotNull("dataCrawlingConfigList", dataCrawlingConfigList);
        return delegateUpdateList(dataCrawlingConfigList);
    }

    /**
     * Batch-update the list non-strictly. <br />
     * All columns are update target. {NOT modified only} <br />
     * This method uses 'Batch Update' of java.sql.PreparedStatement.
     * @param dataCrawlingConfigList The list of the entity. (NotNull)
     * @return The array of updated count.
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     */
    public int[] batchUpdateNonstrict(
            List<DataCrawlingConfig> dataCrawlingConfigList) {
        assertObjectNotNull("dataCrawlingConfigList", dataCrawlingConfigList);
        return delegateUpdateListNonstrict(dataCrawlingConfigList);
    }

    /**
     * Batch-delete the list. <br />
     * This method uses 'Batch Update' of java.sql.PreparedStatement.
     * @param dataCrawlingConfigList The list of the entity. (NotNull)
     * @return The array of deleted count.
     * @exception org.seasar.dbflute.exception.BatchEntityAlreadyUpdatedException When the entity has already been updated. This exception extends EntityAlreadyUpdatedException.
     */
    public int[] batchDelete(List<DataCrawlingConfig> dataCrawlingConfigList) {
        assertObjectNotNull("dataCrawlingConfigList", dataCrawlingConfigList);
        return delegateDeleteList(dataCrawlingConfigList);
    }

    /**
     * Batch-delete the list non-strictly. <br />
     * This method uses 'Batch Update' of java.sql.PreparedStatement.
     * @param dataCrawlingConfigList The list of the entity. (NotNull)
     * @return The array of deleted count.
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     */
    public int[] batchDeleteNonstrict(
            List<DataCrawlingConfig> dataCrawlingConfigList) {
        assertObjectNotNull("dataCrawlingConfigList", dataCrawlingConfigList);
        return delegateDeleteListNonstrict(dataCrawlingConfigList);
    }

    // ===================================================================================
    //                                                                        Query Update
    //                                                                        ============
    /**
     * Query-update the several entities non-strictly modified-only. {NonExclusiveControl}
     * <pre>
     * DataCrawlingConfig dataCrawlingConfig = new DataCrawlingConfig();
     * <span style="color: #3F7E5E">// you don't need to set PK value</span>
     * <span style="color: #3F7E5E">//dataCrawlingConfig.setPK...(value);</span>
     * dataCrawlingConfig.setFoo...(value); <span style="color: #3F7E5E">// you should set only modified columns</span>
     * <span style="color: #3F7E5E">// you don't need to set the value of exclusive control column</span>
     * <span style="color: #3F7E5E">// (auto-increment for version number is valid though non-exclusive control)</span>
     * <span style="color: #3F7E5E">//dataCrawlingConfig.setVersionNo(value);</span>
     * DataCrawlingConfigCB cb = new DataCrawlingConfigCB();
     * cb.query().setFoo...(value);
     * dataCrawlingConfigBhv.<span style="color: #FD4747">queryUpdate</span>(dataCrawlingConfig, cb);
     * </pre>
     * @param dataCrawlingConfig The entity that contains update values. (NotNull) {PrimaryKeyNotRequired}
     * @param cb The condition-bean of DataCrawlingConfig. (NotNull)
     * @return The updated count.
     */
    public int queryUpdate(DataCrawlingConfig dataCrawlingConfig,
            DataCrawlingConfigCB cb) {
        return delegateQueryUpdate(dataCrawlingConfig, cb);
    }

    /**
     * Query-delete the several entities. {NonExclusiveControl}
     * <pre>
     * DataCrawlingConfigCB cb = new DataCrawlingConfigCB();
     * cb.query().setFoo...(value);
     * dataCrawlingConfigBhv.<span style="color: #FD4747">queryDelete</span>(dataCrawlingConfig, cb);
     * </pre>
     * @param cb The condition-bean of DataCrawlingConfig. (NotNull)
     * @return The deleted count.
     */
    public int queryDelete(DataCrawlingConfigCB cb) {
        return delegateQueryDelete(cb);
    }

    /**
     * Varying-update the entity modified-only. {UpdateCountZeroException, ExclusiveControl}
     * <pre>
     * DataCrawlingConfig dataCrawlingConfig = new DataCrawlingConfig();
     * dataCrawlingConfig.setPK...(value); <span style="color: #3F7E5E">// required</span>
     * dataCrawlingConfig.setOther...(value); <span style="color: #3F7E5E">// you should set only modified columns</span>
     * <span style="color: #3F7E5E">// if exclusive control, the value of exclusive control column is required</span>
     * dataCrawlingConfig.<span style="color: #FD4747">setVersionNo</span>(value);
     * try {
     *     UpdateOption&lt;DataCrawlingConfigCB&gt; option = new UpdateOption&lt;DataCrawlingConfigCB&gt;();
     *     option.self(new SpecifyQuery&lt;DataCrawlingConfigCB&gt;() {
     *         public void specify(DataCrawlingConfigCB cb) {
     *             cb.specify().<span style="color: #FD4747">columnXxxCount()</span>;
     *         }
     *     }).plus(1); <span style="color: #3F7E5E">// XXX_COUNT = XXX_COUNT + 1</span>
     *     dataCrawlingConfigBhv.<span style="color: #FD4747">varyingUpdate</span>(dataCrawlingConfig, option);
     * } catch (EntityAlreadyUpdatedException e) { <span style="color: #3F7E5E">// if concurrent update</span>
     *     ...
     * }
     * </pre>
     * @param dataCrawlingConfig The entity of update target. (NotNull) {PrimaryKeyRequired, ConcurrencyColumnRequired}
     * @param option The option of update for varying values. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyUpdatedException When the entity has already been updated.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void varyingUpdate(DataCrawlingConfig dataCrawlingConfig,
            final UpdateOption<DataCrawlingConfigCB> option) {
        processVaryingUpdate(option);
        helpUpdateInternally(dataCrawlingConfig,
                new InternalUpdateCallback<DataCrawlingConfig>() {
                    public int callbackDelegateUpdate(DataCrawlingConfig entity) {
                        return delegateVaryingUpdate(entity, option);
                    }
                });
    }

    /**
     * Varying-update the entity non-strictly modified-only. {UpdateCountZeroException, NonExclusiveControl}
     * <pre>
     * DataCrawlingConfig dataCrawlingConfig = new DataCrawlingConfig();
     * dataCrawlingConfig.setPK...(value); <span style="color: #3F7E5E">// required</span>
     * dataCrawlingConfig.setOther...(value); <span style="color: #3F7E5E">// you should set only modified columns</span>
     * <span style="color: #3F7E5E">// you don't need to set the value of exclusive control column</span>
     * <span style="color: #3F7E5E">// (auto-increment for version number is valid though non-exclusive control)</span>
     * <span style="color: #3F7E5E">//dataCrawlingConfig.setVersionNo(value);</span>
     * UpdateOption&lt;DataCrawlingConfigCB&gt; option = new UpdateOption&lt;DataCrawlingConfigCB&gt;();
     * option.self(new SpecifyQuery&lt;DataCrawlingConfigCB&gt;() {
     *     public void specify(DataCrawlingConfigCB cb) {
     *         cb.specify().<span style="color: #FD4747">columnFooCount()</span>;
     *     }
     * }).plus(1); <span style="color: #3F7E5E">// FOO_COUNT = FOO_COUNT + 1</span>
     * dataCrawlingConfigBhv.<span style="color: #FD4747">varyingUpdateNonstrict</span>(dataCrawlingConfig, option);
     * </pre>
     * @param dataCrawlingConfig The entity of update target. (NotNull) {PrimaryKeyRequired}
     * @param option The option of update for varying values. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void varyingUpdateNonstrict(DataCrawlingConfig dataCrawlingConfig,
            final UpdateOption<DataCrawlingConfigCB> option) {
        processVaryingUpdate(option);
        helpUpdateNonstrictInternally(dataCrawlingConfig,
                new InternalUpdateNonstrictCallback<DataCrawlingConfig>() {
                    public int callbackDelegateUpdateNonstrict(
                            DataCrawlingConfig entity) {
                        return delegateVaryingUpdateNonstrict(entity, option);
                    }
                });
    }

    /**
     * Varying-query-update the several entities non-strictly modified-only. {NonExclusiveControl}
     * <pre>
     * DataCrawlingConfig dataCrawlingConfig = new DataCrawlingConfig();
     * <span style="color: #3F7E5E">// you don't need to set PK value</span>
     * <span style="color: #3F7E5E">//dataCrawlingConfig.setPK...(value);</span>
     * dataCrawlingConfig.setOther...(value); <span style="color: #3F7E5E">// you should set only modified columns</span>
     * <span style="color: #3F7E5E">// you don't need to set the value of exclusive control column</span>
     * <span style="color: #3F7E5E">// (auto-increment for version number is valid though non-exclusive control)</span>
     * <span style="color: #3F7E5E">//dataCrawlingConfig.setVersionNo(value);</span>
     * DataCrawlingConfigCB cb = new DataCrawlingConfigCB();
     * cb.query().setFoo...(value);
     * UpdateOption&lt;DataCrawlingConfigCB&gt; option = new UpdateOption&lt;DataCrawlingConfigCB&gt;();
     * option.self(new SpecifyQuery&lt;DataCrawlingConfigCB&gt;() {
     *     public void specify(DataCrawlingConfigCB cb) {
     *         cb.specify().<span style="color: #FD4747">columnFooCount()</span>;
     *     }
     * }).plus(1); <span style="color: #3F7E5E">// FOO_COUNT = FOO_COUNT + 1</span>
     * dataCrawlingConfigBhv.<span style="color: #FD4747">varyingQueryUpdate</span>(dataCrawlingConfig, cb, option);
     * </pre>
     * @param dataCrawlingConfig The entity that contains update values. (NotNull) {PrimaryKeyNotRequired}
     * @param cb The condition-bean of DataCrawlingConfig. (NotNull)
     * @param option The option of update for varying values. (NotNull)
     * @return The updated count.
     */
    public int varyingQueryUpdate(DataCrawlingConfig dataCrawlingConfig,
            DataCrawlingConfigCB cb,
            final UpdateOption<DataCrawlingConfigCB> option) {
        processVaryingUpdate(option);
        return delegateVaryingQueryUpdate(dataCrawlingConfig, cb, option);
    }

    protected void processVaryingUpdate(
            UpdateOption<DataCrawlingConfigCB> option) {
        assertUpdateOptionNotNull(option);
        DataCrawlingConfigCB cb = newMyConditionBean();
        cb.xsetupForVaryingUpdate();
        option.resolveSpecification(cb);
    }

    // ===================================================================================
    //                                                                     Delegate Method
    //                                                                     ===============
    // [Behavior Command]
    // -----------------------------------------------------
    //                                                Select
    //                                                ------
    protected int delegateSelectCount(DataCrawlingConfigCB cb) {
        return invoke(createSelectCountCBCommand(cb));
    }

    protected <ENTITY extends DataCrawlingConfig> void delegateSelectCursor(
            DataCrawlingConfigCB cb, EntityRowHandler<ENTITY> entityRowHandler,
            Class<ENTITY> entityType) {
        invoke(createSelectCursorCBCommand(cb, entityRowHandler, entityType));
    }

    protected <ENTITY extends DataCrawlingConfig> List<ENTITY> delegateSelectList(
            DataCrawlingConfigCB cb, Class<ENTITY> entityType) {
        return invoke(createSelectListCBCommand(cb, entityType));
    }

    // -----------------------------------------------------
    //                                                Update
    //                                                ------
    protected int delegateInsert(DataCrawlingConfig e) {
        if (!processBeforeInsert(e)) {
            return 1;
        }
        return invoke(createInsertEntityCommand(e));
    }

    protected int delegateUpdate(DataCrawlingConfig e) {
        if (!processBeforeUpdate(e)) {
            return 1;
        }
        return invoke(createUpdateEntityCommand(e));
    }

    protected int delegateUpdateNonstrict(DataCrawlingConfig e) {
        if (!processBeforeUpdate(e)) {
            return 1;
        }
        return invoke(createUpdateNonstrictEntityCommand(e));
    }

    protected int delegateDelete(DataCrawlingConfig e) {
        if (!processBeforeDelete(e)) {
            return 1;
        }
        return invoke(createDeleteEntityCommand(e));
    }

    protected int delegateDeleteNonstrict(DataCrawlingConfig e) {
        if (!processBeforeDelete(e)) {
            return 1;
        }
        return invoke(createDeleteNonstrictEntityCommand(e));
    }

    protected int[] delegateInsertList(List<DataCrawlingConfig> ls) {
        if (ls.isEmpty()) {
            return new int[] {};
        }
        return invoke(createBatchInsertEntityCommand(helpFilterBeforeInsertInternally(ls)));
    }

    @SuppressWarnings("unchecked")
    protected int[] doCreateList(List<Entity> ls) {
        return delegateInsertList((List) ls);
    }

    protected int[] delegateUpdateList(List<DataCrawlingConfig> ls) {
        if (ls.isEmpty()) {
            return new int[] {};
        }
        return invoke(createBatchUpdateEntityCommand(helpFilterBeforeUpdateInternally(ls)));
    }

    @SuppressWarnings("unchecked")
    protected int[] doModifyList(List<Entity> ls) {
        return delegateUpdateList((List) ls);
    }

    protected int[] delegateUpdateListNonstrict(List<DataCrawlingConfig> ls) {
        if (ls.isEmpty()) {
            return new int[] {};
        }
        return invoke(createBatchUpdateNonstrictEntityCommand(helpFilterBeforeUpdateInternally(ls)));
    }

    protected int[] delegateDeleteList(List<DataCrawlingConfig> ls) {
        if (ls.isEmpty()) {
            return new int[] {};
        }
        return invoke(createBatchDeleteEntityCommand(helpFilterBeforeDeleteInternally(ls)));
    }

    @SuppressWarnings("unchecked")
    protected int[] doRemoveList(List<Entity> ls) {
        return delegateDeleteList((List) ls);
    }

    protected int[] delegateDeleteListNonstrict(List<DataCrawlingConfig> ls) {
        if (ls.isEmpty()) {
            return new int[] {};
        }
        return invoke(createBatchDeleteNonstrictEntityCommand(helpFilterBeforeDeleteInternally(ls)));
    }

    protected int delegateQueryUpdate(DataCrawlingConfig e,
            DataCrawlingConfigCB cb) {
        if (!processBeforeQueryUpdate(e, cb)) {
            return 0;
        }
        return invoke(createQueryUpdateEntityCBCommand(e, cb));
    }

    protected int delegateQueryDelete(DataCrawlingConfigCB cb) {
        if (!processBeforeQueryDelete(cb)) {
            return 0;
        }
        return invoke(createQueryDeleteCBCommand(cb));
    }

    protected int delegateVaryingUpdate(DataCrawlingConfig e,
            UpdateOption<DataCrawlingConfigCB> op) {
        if (!processBeforeUpdate(e)) {
            return 1;
        }
        return invoke(createVaryingUpdateEntityCommand(e, op));
    }

    protected int delegateVaryingUpdateNonstrict(DataCrawlingConfig e,
            UpdateOption<DataCrawlingConfigCB> op) {
        if (!processBeforeUpdate(e)) {
            return 1;
        }
        return invoke(createVaryingUpdateNonstrictEntityCommand(e, op));
    }

    protected int delegateVaryingQueryUpdate(DataCrawlingConfig e,
            DataCrawlingConfigCB cb, UpdateOption<DataCrawlingConfigCB> op) {
        if (!processBeforeQueryUpdate(e, cb)) {
            return 0;
        }
        return invoke(createVaryingQueryUpdateEntityCBCommand(e, cb, op));
    }

    // ===================================================================================
    //                                                                Optimistic Lock Info
    //                                                                ====================
    /**
     * {@inheritDoc}
     */
    @Override
    protected boolean hasVersionNoValue(Entity entity) {
        return !(downcast(entity).getVersionNo() + "").equals("null");// For primitive type
    }

    /**
     * {@inheritDoc}
     */
    @Override
    protected boolean hasUpdateDateValue(Entity entity) {
        return false;
    }

    // ===================================================================================
    //                                                                     Downcast Helper
    //                                                                     ===============
    protected DataCrawlingConfig downcast(Entity entity) {
        return helpEntityDowncastInternally(entity, DataCrawlingConfig.class);
    }

    protected DataCrawlingConfigCB downcast(ConditionBean cb) {
        return helpConditionBeanDowncastInternally(cb,
                DataCrawlingConfigCB.class);
    }
}
