/*
 * Copyright 2009-2010 the Fess Project and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */

package jp.sf.fess.db.bsentity;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

import jp.sf.fess.db.allcommon.DBMetaInstanceHandler;
import jp.sf.fess.db.exentity.DataConfigToBrowserTypeMapping;
import jp.sf.fess.db.exentity.DataConfigToLabelTypeMapping;
import jp.sf.fess.db.exentity.DataConfigToRoleTypeMapping;

import org.seasar.dbflute.Entity;
import org.seasar.dbflute.dbmeta.DBMeta;

/**
 * The entity of DATA_CRAWLING_CONFIG as TABLE. <br />
 * <pre>
 * [primary-key]
 *     ID
 * 
 * [column]
 *     ID, NAME, HANDLER_NAME, HANDLER_PARAMETER, HANDLER_SCRIPT, BOOST, AVAILABLE, SORT_ORDER, CREATED_BY, CREATED_TIME, UPDATED_BY, UPDATED_TIME, DELETED_BY, DELETED_TIME, VERSION_NO
 * 
 * [sequence]
 *     
 * 
 * [identity]
 *     ID
 * 
 * [version-no]
 *     VERSION_NO
 * 
 * [foreign-table]
 *     
 * 
 * [referrer-table]
 *     DATA_CONFIG_TO_BROWSER_TYPE_MAPPING, DATA_CONFIG_TO_LABEL_TYPE_MAPPING, DATA_CONFIG_TO_ROLE_TYPE_MAPPING
 * 
 * [foreign-property]
 *     
 * 
 * [referrer-property]
 *     dataConfigToBrowserTypeMappingList, dataConfigToLabelTypeMappingList, dataConfigToRoleTypeMappingList
 * </pre>
 * @author DBFlute(AutoGenerator)
 */
public abstract class BsDataCrawlingConfig implements Entity, Serializable {

    // ===================================================================================
    //                                                                          Definition
    //                                                                          ==========
    /** Serial version UID. (Default) */
    private static final long serialVersionUID = 1L;

    // ===================================================================================
    //                                                                           Attribute
    //                                                                           =========
    // -----------------------------------------------------
    //                                                Column
    //                                                ------
    /** ID: {PK, ID, NotNull, BIGINT(19)} */
    protected Long _id;

    /** NAME: {NotNull, VARCHAR(200)} */
    protected String _name;

    /** HANDLER_NAME: {NotNull, VARCHAR(200)} */
    protected String _handlerName;

    /** HANDLER_PARAMETER: {VARCHAR(4000)} */
    protected String _handlerParameter;

    /** HANDLER_SCRIPT: {VARCHAR(4000)} */
    protected String _handlerScript;

    /** BOOST: {NotNull, DOUBLE(17)} */
    protected java.math.BigDecimal _boost;

    /** AVAILABLE: {NotNull, VARCHAR(1)} */
    protected String _available;

    /** SORT_ORDER: {NotNull, INTEGER(10)} */
    protected Integer _sortOrder;

    /** CREATED_BY: {NotNull, VARCHAR(255)} */
    protected String _createdBy;

    /** CREATED_TIME: {NotNull, TIMESTAMP(23, 10)} */
    protected java.sql.Timestamp _createdTime;

    /** UPDATED_BY: {VARCHAR(255)} */
    protected String _updatedBy;

    /** UPDATED_TIME: {TIMESTAMP(23, 10)} */
    protected java.sql.Timestamp _updatedTime;

    /** DELETED_BY: {VARCHAR(255)} */
    protected String _deletedBy;

    /** DELETED_TIME: {TIMESTAMP(23, 10)} */
    protected java.sql.Timestamp _deletedTime;

    /** VERSION_NO: {NotNull, INTEGER(10)} */
    protected Integer _versionNo;

    // -----------------------------------------------------
    //                                              Internal
    //                                              --------
    /** The modified properties for this entity. */
    protected EntityModifiedProperties _modifiedProperties = newEntityModifiedProperties();

    // ===================================================================================
    //                                                                          Table Name
    //                                                                          ==========
    /**
     * {@inheritDoc}
     */
    public String getTableDbName() {
        return "DATA_CRAWLING_CONFIG";
    }

    /**
     * {@inheritDoc}
     */
    public String getTablePropertyName() { // according to Java Beans rule
        return "dataCrawlingConfig";
    }

    // ===================================================================================
    //                                                                              DBMeta
    //                                                                              ======
    /**
     * {@inheritDoc}
     */
    public DBMeta getDBMeta() {
        return DBMetaInstanceHandler.findDBMeta(getTableDbName());
    }

    // ===================================================================================
    //                                                                         Primary Key
    //                                                                         ===========
    /**
     * {@inheritDoc}
     */
    public boolean hasPrimaryKeyValue() {
        if (getId() == null) {
            return false;
        }
        return true;
    }

    // ===================================================================================
    //                                                                    Foreign Property
    //                                                                    ================
    // ===================================================================================
    //                                                                   Referrer Property
    //                                                                   =================
    /** DATA_CONFIG_TO_BROWSER_TYPE_MAPPING as 'dataConfigToBrowserTypeMappingList'. */
    protected List<DataConfigToBrowserTypeMapping> _dataConfigToBrowserTypeMappingList;

    /**
     * DATA_CONFIG_TO_BROWSER_TYPE_MAPPING as 'dataConfigToBrowserTypeMappingList'.
     * @return The entity list of referrer property 'dataConfigToBrowserTypeMappingList'. (NotNull: If it's not loaded yet, initializes the list instance of referrer as empty and returns it.)
     */
    public List<DataConfigToBrowserTypeMapping> getDataConfigToBrowserTypeMappingList() {
        if (_dataConfigToBrowserTypeMappingList == null) {
            _dataConfigToBrowserTypeMappingList = new ArrayList<DataConfigToBrowserTypeMapping>();
        }
        return _dataConfigToBrowserTypeMappingList;
    }

    /**
     * DATA_CONFIG_TO_BROWSER_TYPE_MAPPING as 'dataConfigToBrowserTypeMappingList'.
     * @param dataConfigToBrowserTypeMappingList The entity list of referrer property 'dataConfigToBrowserTypeMappingList'. (Nullable)
     */
    public void setDataConfigToBrowserTypeMappingList(
            List<DataConfigToBrowserTypeMapping> dataConfigToBrowserTypeMappingList) {
        _dataConfigToBrowserTypeMappingList = dataConfigToBrowserTypeMappingList;
    }

    /** DATA_CONFIG_TO_LABEL_TYPE_MAPPING as 'dataConfigToLabelTypeMappingList'. */
    protected List<DataConfigToLabelTypeMapping> _dataConfigToLabelTypeMappingList;

    /**
     * DATA_CONFIG_TO_LABEL_TYPE_MAPPING as 'dataConfigToLabelTypeMappingList'.
     * @return The entity list of referrer property 'dataConfigToLabelTypeMappingList'. (NotNull: If it's not loaded yet, initializes the list instance of referrer as empty and returns it.)
     */
    public List<DataConfigToLabelTypeMapping> getDataConfigToLabelTypeMappingList() {
        if (_dataConfigToLabelTypeMappingList == null) {
            _dataConfigToLabelTypeMappingList = new ArrayList<DataConfigToLabelTypeMapping>();
        }
        return _dataConfigToLabelTypeMappingList;
    }

    /**
     * DATA_CONFIG_TO_LABEL_TYPE_MAPPING as 'dataConfigToLabelTypeMappingList'.
     * @param dataConfigToLabelTypeMappingList The entity list of referrer property 'dataConfigToLabelTypeMappingList'. (Nullable)
     */
    public void setDataConfigToLabelTypeMappingList(
            List<DataConfigToLabelTypeMapping> dataConfigToLabelTypeMappingList) {
        _dataConfigToLabelTypeMappingList = dataConfigToLabelTypeMappingList;
    }

    /** DATA_CONFIG_TO_ROLE_TYPE_MAPPING as 'dataConfigToRoleTypeMappingList'. */
    protected List<DataConfigToRoleTypeMapping> _dataConfigToRoleTypeMappingList;

    /**
     * DATA_CONFIG_TO_ROLE_TYPE_MAPPING as 'dataConfigToRoleTypeMappingList'.
     * @return The entity list of referrer property 'dataConfigToRoleTypeMappingList'. (NotNull: If it's not loaded yet, initializes the list instance of referrer as empty and returns it.)
     */
    public List<DataConfigToRoleTypeMapping> getDataConfigToRoleTypeMappingList() {
        if (_dataConfigToRoleTypeMappingList == null) {
            _dataConfigToRoleTypeMappingList = new ArrayList<DataConfigToRoleTypeMapping>();
        }
        return _dataConfigToRoleTypeMappingList;
    }

    /**
     * DATA_CONFIG_TO_ROLE_TYPE_MAPPING as 'dataConfigToRoleTypeMappingList'.
     * @param dataConfigToRoleTypeMappingList The entity list of referrer property 'dataConfigToRoleTypeMappingList'. (Nullable)
     */
    public void setDataConfigToRoleTypeMappingList(
            List<DataConfigToRoleTypeMapping> dataConfigToRoleTypeMappingList) {
        _dataConfigToRoleTypeMappingList = dataConfigToRoleTypeMappingList;
    }

    // ===================================================================================
    //                                                                 Modified Properties
    //                                                                 ===================
    /**
     * {@inheritDoc}
     */
    public Set<String> getModifiedPropertyNames() {
        return _modifiedProperties.getPropertyNames();
    }

    protected EntityModifiedProperties newEntityModifiedProperties() {
        return new EntityModifiedProperties();
    }

    /**
     * {@inheritDoc}
     */
    public void clearModifiedPropertyNames() {
        _modifiedProperties.clear();
    }

    /**
     * {@inheritDoc}
     */
    public boolean hasModification() {
        return !_modifiedProperties.isEmpty();
    }

    // ===================================================================================
    //                                                                      Basic Override
    //                                                                      ==============
    /**
     * If primary-keys or columns of the other are same as this one, returns true.
     * @param other The other entity. (Nullable)
     * @return Comparing result.
     */
    public boolean equals(Object other) {
        if (other == null || !(other instanceof BsDataCrawlingConfig)) {
            return false;
        }
        BsDataCrawlingConfig otherEntity = (BsDataCrawlingConfig) other;
        if (!xSV(getId(), otherEntity.getId())) {
            return false;
        }
        return true;
    }

    protected boolean xSV(Object value1, Object value2) { // isSameValue()
        return InternalUtil.isSameValue(value1, value2);
    }

    /**
     * Calculates the hash-code from primary-keys or columns.
     * @return The hash-code from primary-key or columns.
     */
    public int hashCode() {
        int result = 17;
        result = xCH(result, getId());
        return result;
    }

    protected int xCH(int result, Object value) { // calculateHashcode()
        return InternalUtil.calculateHashcode(result, value);
    }

    /**
     * @return The display string of all columns and relation existences. (NotNull)
     */
    public String toString() {
        return buildDisplayString(InternalUtil.toClassTitle(this), true, true);
    }

    /**
     * @return The display string of basic informations with one-nested relation values. (NotNull)
     */
    public String toStringWithRelation() {
        StringBuilder sb = new StringBuilder();
        sb.append(toString());
        String l = "\n  ";
        if (_dataConfigToBrowserTypeMappingList != null) {
            for (Entity e : _dataConfigToBrowserTypeMappingList) {
                if (e != null) {
                    sb.append(l).append(
                            xbRDS(e, "dataConfigToBrowserTypeMappingList"));
                }
            }
        }
        if (_dataConfigToLabelTypeMappingList != null) {
            for (Entity e : _dataConfigToLabelTypeMappingList) {
                if (e != null) {
                    sb.append(l).append(
                            xbRDS(e, "dataConfigToLabelTypeMappingList"));
                }
            }
        }
        if (_dataConfigToRoleTypeMappingList != null) {
            for (Entity e : _dataConfigToRoleTypeMappingList) {
                if (e != null) {
                    sb.append(l).append(
                            xbRDS(e, "dataConfigToRoleTypeMappingList"));
                }
            }
        }
        return sb.toString();
    }

    protected String xbRDS(Entity e, String name) { // buildRelationDisplayString()
        return e.buildDisplayString(name, true, true);
    }

    /**
     * @param name The name for display. (Nullable: If it's null, it does not have a name)
     * @param column Does it contains column values or not?
     * @param relation Does it contains relation existences or not?
     * @return The display string for this entity. (NotNull)
     */
    public String buildDisplayString(String name, boolean column,
            boolean relation) {
        StringBuilder sb = new StringBuilder();
        if (name != null) {
            sb.append(name).append(column || relation ? ":" : "");
        }
        if (column) {
            sb.append(buildColumnString());
        }
        if (relation) {
            sb.append(buildRelationString());
        }
        sb.append("@").append(Integer.toHexString(hashCode()));
        return sb.toString();
    }

    protected String buildColumnString() {
        String c = ", ";
        StringBuilder sb = new StringBuilder();
        sb.append(c).append(getId());
        sb.append(c).append(getName());
        sb.append(c).append(getHandlerName());
        sb.append(c).append(getHandlerParameter());
        sb.append(c).append(getHandlerScript());
        sb.append(c).append(getBoost());
        sb.append(c).append(getAvailable());
        sb.append(c).append(getSortOrder());
        sb.append(c).append(getCreatedBy());
        sb.append(c).append(getCreatedTime());
        sb.append(c).append(getUpdatedBy());
        sb.append(c).append(getUpdatedTime());
        sb.append(c).append(getDeletedBy());
        sb.append(c).append(getDeletedTime());
        sb.append(c).append(getVersionNo());
        if (sb.length() > 0) {
            sb.delete(0, c.length());
        }
        sb.insert(0, "{").append("}");
        return sb.toString();
    }

    protected String buildRelationString() {
        StringBuilder sb = new StringBuilder();
        String c = ",";
        if (_dataConfigToBrowserTypeMappingList != null
                && !_dataConfigToBrowserTypeMappingList.isEmpty()) {
            sb.append(c).append("dataConfigToBrowserTypeMappingList");
        }
        if (_dataConfigToLabelTypeMappingList != null
                && !_dataConfigToLabelTypeMappingList.isEmpty()) {
            sb.append(c).append("dataConfigToLabelTypeMappingList");
        }
        if (_dataConfigToRoleTypeMappingList != null
                && !_dataConfigToRoleTypeMappingList.isEmpty()) {
            sb.append(c).append("dataConfigToRoleTypeMappingList");
        }
        if (sb.length() > 0) {
            sb.delete(0, c.length()).insert(0, "(").append(")");
        }
        return sb.toString();
    }

    // ===================================================================================
    //                                                                            Accessor
    //                                                                            ========
    /**
     * [get] ID: {PK, ID, NotNull, BIGINT(19)} <br />
     * @return The value of the column 'ID'. (Nullable)
     */
    public Long getId() {
        return _id;
    }

    /**
     * [set] ID: {PK, ID, NotNull, BIGINT(19)} <br />
     * @param id The value of the column 'ID'. (Nullable)
     */
    public void setId(Long id) {
        _modifiedProperties.addPropertyName("id");
        this._id = id;
    }

    /**
     * [get] NAME: {NotNull, VARCHAR(200)} <br />
     * @return The value of the column 'NAME'. (Nullable)
     */
    public String getName() {
        return _name;
    }

    /**
     * [set] NAME: {NotNull, VARCHAR(200)} <br />
     * @param name The value of the column 'NAME'. (Nullable)
     */
    public void setName(String name) {
        _modifiedProperties.addPropertyName("name");
        this._name = name;
    }

    /**
     * [get] HANDLER_NAME: {NotNull, VARCHAR(200)} <br />
     * @return The value of the column 'HANDLER_NAME'. (Nullable)
     */
    public String getHandlerName() {
        return _handlerName;
    }

    /**
     * [set] HANDLER_NAME: {NotNull, VARCHAR(200)} <br />
     * @param handlerName The value of the column 'HANDLER_NAME'. (Nullable)
     */
    public void setHandlerName(String handlerName) {
        _modifiedProperties.addPropertyName("handlerName");
        this._handlerName = handlerName;
    }

    /**
     * [get] HANDLER_PARAMETER: {VARCHAR(4000)} <br />
     * @return The value of the column 'HANDLER_PARAMETER'. (Nullable)
     */
    public String getHandlerParameter() {
        return _handlerParameter;
    }

    /**
     * [set] HANDLER_PARAMETER: {VARCHAR(4000)} <br />
     * @param handlerParameter The value of the column 'HANDLER_PARAMETER'. (Nullable)
     */
    public void setHandlerParameter(String handlerParameter) {
        _modifiedProperties.addPropertyName("handlerParameter");
        this._handlerParameter = handlerParameter;
    }

    /**
     * [get] HANDLER_SCRIPT: {VARCHAR(4000)} <br />
     * @return The value of the column 'HANDLER_SCRIPT'. (Nullable)
     */
    public String getHandlerScript() {
        return _handlerScript;
    }

    /**
     * [set] HANDLER_SCRIPT: {VARCHAR(4000)} <br />
     * @param handlerScript The value of the column 'HANDLER_SCRIPT'. (Nullable)
     */
    public void setHandlerScript(String handlerScript) {
        _modifiedProperties.addPropertyName("handlerScript");
        this._handlerScript = handlerScript;
    }

    /**
     * [get] BOOST: {NotNull, DOUBLE(17)} <br />
     * @return The value of the column 'BOOST'. (Nullable)
     */
    public java.math.BigDecimal getBoost() {
        return _boost;
    }

    /**
     * [set] BOOST: {NotNull, DOUBLE(17)} <br />
     * @param boost The value of the column 'BOOST'. (Nullable)
     */
    public void setBoost(java.math.BigDecimal boost) {
        _modifiedProperties.addPropertyName("boost");
        this._boost = boost;
    }

    /**
     * [get] AVAILABLE: {NotNull, VARCHAR(1)} <br />
     * @return The value of the column 'AVAILABLE'. (Nullable)
     */
    public String getAvailable() {
        return _available;
    }

    /**
     * [set] AVAILABLE: {NotNull, VARCHAR(1)} <br />
     * @param available The value of the column 'AVAILABLE'. (Nullable)
     */
    public void setAvailable(String available) {
        _modifiedProperties.addPropertyName("available");
        this._available = available;
    }

    /**
     * [get] SORT_ORDER: {NotNull, INTEGER(10)} <br />
     * @return The value of the column 'SORT_ORDER'. (Nullable)
     */
    public Integer getSortOrder() {
        return _sortOrder;
    }

    /**
     * [set] SORT_ORDER: {NotNull, INTEGER(10)} <br />
     * @param sortOrder The value of the column 'SORT_ORDER'. (Nullable)
     */
    public void setSortOrder(Integer sortOrder) {
        _modifiedProperties.addPropertyName("sortOrder");
        this._sortOrder = sortOrder;
    }

    /**
     * [get] CREATED_BY: {NotNull, VARCHAR(255)} <br />
     * @return The value of the column 'CREATED_BY'. (Nullable)
     */
    public String getCreatedBy() {
        return _createdBy;
    }

    /**
     * [set] CREATED_BY: {NotNull, VARCHAR(255)} <br />
     * @param createdBy The value of the column 'CREATED_BY'. (Nullable)
     */
    public void setCreatedBy(String createdBy) {
        _modifiedProperties.addPropertyName("createdBy");
        this._createdBy = createdBy;
    }

    /**
     * [get] CREATED_TIME: {NotNull, TIMESTAMP(23, 10)} <br />
     * @return The value of the column 'CREATED_TIME'. (Nullable)
     */
    public java.sql.Timestamp getCreatedTime() {
        return _createdTime;
    }

    /**
     * [set] CREATED_TIME: {NotNull, TIMESTAMP(23, 10)} <br />
     * @param createdTime The value of the column 'CREATED_TIME'. (Nullable)
     */
    public void setCreatedTime(java.sql.Timestamp createdTime) {
        _modifiedProperties.addPropertyName("createdTime");
        this._createdTime = createdTime;
    }

    /**
     * [get] UPDATED_BY: {VARCHAR(255)} <br />
     * @return The value of the column 'UPDATED_BY'. (Nullable)
     */
    public String getUpdatedBy() {
        return _updatedBy;
    }

    /**
     * [set] UPDATED_BY: {VARCHAR(255)} <br />
     * @param updatedBy The value of the column 'UPDATED_BY'. (Nullable)
     */
    public void setUpdatedBy(String updatedBy) {
        _modifiedProperties.addPropertyName("updatedBy");
        this._updatedBy = updatedBy;
    }

    /**
     * [get] UPDATED_TIME: {TIMESTAMP(23, 10)} <br />
     * @return The value of the column 'UPDATED_TIME'. (Nullable)
     */
    public java.sql.Timestamp getUpdatedTime() {
        return _updatedTime;
    }

    /**
     * [set] UPDATED_TIME: {TIMESTAMP(23, 10)} <br />
     * @param updatedTime The value of the column 'UPDATED_TIME'. (Nullable)
     */
    public void setUpdatedTime(java.sql.Timestamp updatedTime) {
        _modifiedProperties.addPropertyName("updatedTime");
        this._updatedTime = updatedTime;
    }

    /**
     * [get] DELETED_BY: {VARCHAR(255)} <br />
     * @return The value of the column 'DELETED_BY'. (Nullable)
     */
    public String getDeletedBy() {
        return _deletedBy;
    }

    /**
     * [set] DELETED_BY: {VARCHAR(255)} <br />
     * @param deletedBy The value of the column 'DELETED_BY'. (Nullable)
     */
    public void setDeletedBy(String deletedBy) {
        _modifiedProperties.addPropertyName("deletedBy");
        this._deletedBy = deletedBy;
    }

    /**
     * [get] DELETED_TIME: {TIMESTAMP(23, 10)} <br />
     * @return The value of the column 'DELETED_TIME'. (Nullable)
     */
    public java.sql.Timestamp getDeletedTime() {
        return _deletedTime;
    }

    /**
     * [set] DELETED_TIME: {TIMESTAMP(23, 10)} <br />
     * @param deletedTime The value of the column 'DELETED_TIME'. (Nullable)
     */
    public void setDeletedTime(java.sql.Timestamp deletedTime) {
        _modifiedProperties.addPropertyName("deletedTime");
        this._deletedTime = deletedTime;
    }

    /**
     * [get] VERSION_NO: {NotNull, INTEGER(10)} <br />
     * @return The value of the column 'VERSION_NO'. (Nullable)
     */
    public Integer getVersionNo() {
        return _versionNo;
    }

    /**
     * [set] VERSION_NO: {NotNull, INTEGER(10)} <br />
     * @param versionNo The value of the column 'VERSION_NO'. (Nullable)
     */
    public void setVersionNo(Integer versionNo) {
        _modifiedProperties.addPropertyName("versionNo");
        this._versionNo = versionNo;
    }
}
