/*
 * Copyright 2009-2010 the Fess Project and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */

package jp.sf.fess.db.bsbhv;

import java.util.List;

import jp.sf.fess.db.allcommon.DBCurrent;
import jp.sf.fess.db.allcommon.DBFluteConfig;
import jp.sf.fess.db.bsentity.dbmeta.DataConfigToLabelTypeMappingDbm;
import jp.sf.fess.db.cbean.DataConfigToLabelTypeMappingCB;
import jp.sf.fess.db.exentity.DataConfigToLabelTypeMapping;
import jp.sf.fess.db.exentity.DataCrawlingConfig;
import jp.sf.fess.db.exentity.LabelType;

import org.seasar.dbflute.DBDef;
import org.seasar.dbflute.Entity;
import org.seasar.dbflute.cbean.ConditionBean;
import org.seasar.dbflute.cbean.EntityRowHandler;
import org.seasar.dbflute.cbean.ListResultBean;
import org.seasar.dbflute.cbean.PagingBean;
import org.seasar.dbflute.cbean.PagingHandler;
import org.seasar.dbflute.cbean.PagingInvoker;
import org.seasar.dbflute.cbean.PagingResultBean;
import org.seasar.dbflute.cbean.ResultBeanBuilder;
import org.seasar.dbflute.dbmeta.DBMeta;
import org.seasar.dbflute.jdbc.StatementConfig;

/**
 * The behavior of DATA_CONFIG_TO_LABEL_TYPE_MAPPING that the type is TABLE. <br />
 * <pre>
 * [primary-key]
 *     ID
 * 
 * [column]
 *     ID, DATA_CONFIG_ID, LABEL_TYPE_ID
 * 
 * [sequence]
 *     
 * 
 * [identity]
 *     ID
 * 
 * [version-no]
 *     
 * 
 * [foreign-table]
 *     DATA_CRAWLING_CONFIG, LABEL_TYPE
 * 
 * [referrer-table]
 *     
 * 
 * [foreign-property]
 *     dataCrawlingConfig, labelType
 * 
 * [referrer-property]
 *     
 * </pre>
 * @author DBFlute(AutoGenerator)
 */
public abstract class BsDataConfigToLabelTypeMappingBhv extends
        org.seasar.dbflute.bhv.AbstractBehaviorWritable {

    // ===================================================================================
    //                                                                          Definition
    //                                                                          ==========
    /*df:BehaviorQueryPathBegin*/
    /*df:BehaviorQueryPathEnd*/

    // ===================================================================================
    //                                                                          Table name
    //                                                                          ==========
    /** @return The name on database of table. (NotNull) */
    public String getTableDbName() {
        return "DATA_CONFIG_TO_LABEL_TYPE_MAPPING";
    }

    // ===================================================================================
    //                                                                              DBMeta
    //                                                                              ======
    /** @return The instance of DBMeta. (NotNull) */
    public DBMeta getDBMeta() {
        return DataConfigToLabelTypeMappingDbm.getInstance();
    }

    /** @return The instance of DBMeta as my table type. (NotNull) */
    public DataConfigToLabelTypeMappingDbm getMyDBMeta() {
        return DataConfigToLabelTypeMappingDbm.getInstance();
    }

    // ===================================================================================
    //                                                                        New Instance
    //                                                                        ============
    public Entity newEntity() {
        return newMyEntity();
    }

    public ConditionBean newConditionBean() {
        return newMyConditionBean();
    }

    public DataConfigToLabelTypeMapping newMyEntity() {
        return new DataConfigToLabelTypeMapping();
    }

    public DataConfigToLabelTypeMappingCB newMyConditionBean() {
        return new DataConfigToLabelTypeMappingCB();
    }

    // ===================================================================================
    //                                                                       Current DBDef
    //                                                                       =============
    @Override
    protected DBDef getCurrentDBDef() {
        return DBCurrent.getInstance().currentDBDef();
    }

    // ===================================================================================
    //                                                             Default StatementConfig
    //                                                             =======================
    @Override
    protected StatementConfig getDefaultStatementConfig() {
        return DBFluteConfig.getInstance().getDefaultStatementConfig();
    }

    // ===================================================================================
    //                                                                        Count Select
    //                                                                        ============
    /**
     * Select the count by the condition-bean. {IgnorePagingCondition}
     * @param cb The condition-bean of DataConfigToLabelTypeMapping. (NotNull)
     * @return The selected count.
     */
    public int selectCount(DataConfigToLabelTypeMappingCB cb) {
        assertCBNotNull(cb);
        return delegateSelectCount(cb);
    }

    // ===================================================================================
    //                                                                       Cursor Select
    //                                                                       =============
    /**
     * Select the cursor by the condition-bean. <br />
     * Attention: It has a mapping cost from result set to entity.
     * @param cb The condition-bean of DataConfigToLabelTypeMapping. (NotNull)
     * @param entityRowHandler The handler of entity row of DataConfigToLabelTypeMapping. (NotNull)
     */
    public void selectCursor(DataConfigToLabelTypeMappingCB cb,
            EntityRowHandler<DataConfigToLabelTypeMapping> entityRowHandler) {
        assertCBNotNull(cb);
        assertObjectNotNull("entityRowHandler<DataConfigToLabelTypeMapping>",
                entityRowHandler);
        delegateSelectCursor(cb, entityRowHandler);
    }

    // ===================================================================================
    //                                                                       Entity Select
    //                                                                       =============
    /**
     * Select the entity by the condition-bean.
     * @param cb The condition-bean of DataConfigToLabelTypeMapping. (NotNull)
     * @return The selected entity. (Nullalble)
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     */
    public DataConfigToLabelTypeMapping selectEntity(
            final DataConfigToLabelTypeMappingCB cb) {
        return helpSelectEntityInternally(
                cb,
                new InternalSelectEntityCallback<DataConfigToLabelTypeMapping, DataConfigToLabelTypeMappingCB>() {
                    public List<DataConfigToLabelTypeMapping> callbackSelectList(
                            DataConfigToLabelTypeMappingCB cb) {
                        return selectList(cb);
                    }
                });
    }

    /**
     * Select the entity by the condition-bean with deleted check.
     * @param cb The condition-bean of DataConfigToLabelTypeMapping. (NotNull)
     * @return The selected entity. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     */
    public DataConfigToLabelTypeMapping selectEntityWithDeletedCheck(
            final DataConfigToLabelTypeMappingCB cb) {
        return helpSelectEntityWithDeletedCheckInternally(
                cb,
                new InternalSelectEntityWithDeletedCheckCallback<DataConfigToLabelTypeMapping, DataConfigToLabelTypeMappingCB>() {
                    public List<DataConfigToLabelTypeMapping> callbackSelectList(
                            DataConfigToLabelTypeMappingCB cb) {
                        return selectList(cb);
                    }
                });
    }

    /* (non-javadoc)
     * Select the entity with deleted check. {by primary-key value}
     * @param primaryKey The keys of primary.
     * @return The selected entity. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     */
    public DataConfigToLabelTypeMapping selectByPKValueWithDeletedCheck(Long id) {
        DataConfigToLabelTypeMapping entity = new DataConfigToLabelTypeMapping();
        entity.setId(id);
        final DataConfigToLabelTypeMappingCB cb = newMyConditionBean();
        cb.acceptPrimaryKeyMapString(getDBMeta().extractPrimaryKeyMapString(
                entity));
        return selectEntityWithDeletedCheck(cb);
    }

    // ===================================================================================
    //                                                                         List Select
    //                                                                         ===========
    /**
     * Select the list as result bean.
     * @param cb The condition-bean of DataConfigToLabelTypeMapping. (NotNull)
     * @return The result bean of selected list. (NotNull)
     */
    public ListResultBean<DataConfigToLabelTypeMapping> selectList(
            DataConfigToLabelTypeMappingCB cb) {
        assertCBNotNull(cb);
        return new ResultBeanBuilder<DataConfigToLabelTypeMapping>(
                getTableDbName()).buildListResultBean(cb,
                delegateSelectList(cb));
    }

    // ===================================================================================
    //                                                                         Page Select
    //                                                                         ===========
    /**
     * Select the page as result bean.
     * @param cb The condition-bean of DataConfigToLabelTypeMapping. (NotNull)
     * @return The result bean of selected page. (NotNull)
     */
    public PagingResultBean<DataConfigToLabelTypeMapping> selectPage(
            final DataConfigToLabelTypeMappingCB cb) {
        assertCBNotNull(cb);
        final PagingInvoker<DataConfigToLabelTypeMapping> invoker = new PagingInvoker<DataConfigToLabelTypeMapping>(
                getTableDbName());
        final PagingHandler<DataConfigToLabelTypeMapping> handler = new PagingHandler<DataConfigToLabelTypeMapping>() {
            public PagingBean getPagingBean() {
                return cb;
            }

            public int count() {
                return selectCount(cb);
            }

            public List<DataConfigToLabelTypeMapping> paging() {
                return selectList(cb);
            }
        };
        return invoker.invokePaging(handler);
    }

    // ===================================================================================
    //                                                                       Scalar Select
    //                                                                       =============
    /**
     * Select the scalar value derived by a function. <br />
     * Call a function method after this method called like as follows:
     * <pre>
     * dataConfigToLabelTypeMappingBhv.scalarSelect(Date.class).max(new ScalarQuery(DataConfigToLabelTypeMappingCB cb) {
     *     cb.specify().columnXxxDatetime(); // the required specification of target column
     *     cb.query().setXxxName_PrefixSearch("S"); // query as you like it
     * });
     * </pre>
     * @param <RESULT> The type of result.
     * @param resultType The type of result. (NotNull)
     * @return The scalar value derived by a function. (Nullable)
     */
    public <RESULT> SLFunction<DataConfigToLabelTypeMappingCB, RESULT> scalarSelect(
            Class<RESULT> resultType) {
        DataConfigToLabelTypeMappingCB cb = newMyConditionBean();
        cb.xsetupForScalarSelect();
        cb.getSqlClause().disableSelectIndex(); // for when you use union
        return new SLFunction<DataConfigToLabelTypeMappingCB, RESULT>(cb,
                resultType);
    }

    // ===================================================================================
    //                                                                       Load Referrer
    //                                                                       =============
    // ===================================================================================
    //                                                                    Pull out Foreign
    //                                                                    ================
    /**
     * Pull out the list of foreign table 'DataCrawlingConfig'.
     * @param dataConfigToLabelTypeMappingList The list of dataConfigToLabelTypeMapping. (NotNull)
     * @return The list of foreign table. (NotNull)
     */
    public List<DataCrawlingConfig> pulloutDataCrawlingConfig(
            List<DataConfigToLabelTypeMapping> dataConfigToLabelTypeMappingList) {
        return helpPulloutInternally(
                dataConfigToLabelTypeMappingList,
                new InternalPulloutCallback<DataConfigToLabelTypeMapping, DataCrawlingConfig>() {
                    public DataCrawlingConfig callbackGetForeignEntity(
                            DataConfigToLabelTypeMapping entity) {
                        return entity.getDataCrawlingConfig();
                    }
                });
    }

    /**
     * Pull out the list of foreign table 'LabelType'.
     * @param dataConfigToLabelTypeMappingList The list of dataConfigToLabelTypeMapping. (NotNull)
     * @return The list of foreign table. (NotNull)
     */
    public List<LabelType> pulloutLabelType(
            List<DataConfigToLabelTypeMapping> dataConfigToLabelTypeMappingList) {
        return helpPulloutInternally(
                dataConfigToLabelTypeMappingList,
                new InternalPulloutCallback<DataConfigToLabelTypeMapping, LabelType>() {
                    public LabelType callbackGetForeignEntity(
                            DataConfigToLabelTypeMapping entity) {
                        return entity.getLabelType();
                    }
                });
    }

    // ===================================================================================
    //                                                                       Entity Update
    //                                                                       =============
    /**
     * Insert the entity.
     * @param dataConfigToLabelTypeMapping The entity of insert target. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void insert(DataConfigToLabelTypeMapping dataConfigToLabelTypeMapping) {
        assertEntityNotNull(dataConfigToLabelTypeMapping);
        delegateInsert(dataConfigToLabelTypeMapping);
    }

    @Override
    protected void doCreate(Entity dataConfigToLabelTypeMapping) {
        insert((DataConfigToLabelTypeMapping) dataConfigToLabelTypeMapping);
    }

    /**
     * Update the entity modified-only. {UpdateCountZeroException, ConcurrencyControl}
     * @param dataConfigToLabelTypeMapping The entity of update target. (NotNull) {PrimaryKeyRequired, ConcurrencyColumnRequired}
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void update(
            final DataConfigToLabelTypeMapping dataConfigToLabelTypeMapping) {
        helpUpdateInternally(dataConfigToLabelTypeMapping,
                new InternalUpdateCallback<DataConfigToLabelTypeMapping>() {
                    public int callbackDelegateUpdate(
                            DataConfigToLabelTypeMapping entity) {
                        return delegateUpdate(entity);
                    }
                });
    }

    @Override
    protected void doModify(Entity entity) {
        update((DataConfigToLabelTypeMapping) entity);
    }

    @Override
    protected void doModifyNonstrict(Entity entity) {
        update((DataConfigToLabelTypeMapping) entity);
    }

    /**
     * Insert or update the entity modified-only. {ConcurrencyControl(when update)}
     * @param dataConfigToLabelTypeMapping The entity of insert or update target. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void insertOrUpdate(
            final DataConfigToLabelTypeMapping dataConfigToLabelTypeMapping) {
        helpInsertOrUpdateInternally(
                dataConfigToLabelTypeMapping,
                new InternalInsertOrUpdateCallback<DataConfigToLabelTypeMapping, DataConfigToLabelTypeMappingCB>() {
                    public void callbackInsert(
                            DataConfigToLabelTypeMapping entity) {
                        insert(entity);
                    }

                    public void callbackUpdate(
                            DataConfigToLabelTypeMapping entity) {
                        update(entity);
                    }

                    public DataConfigToLabelTypeMappingCB callbackNewMyConditionBean() {
                        return newMyConditionBean();
                    }

                    public int callbackSelectCount(
                            DataConfigToLabelTypeMappingCB cb) {
                        return selectCount(cb);
                    }
                });
    }

    @Override
    protected void doCreateOrUpdate(Entity dataConfigToLabelTypeMapping) {
        insertOrUpdate((DataConfigToLabelTypeMapping) dataConfigToLabelTypeMapping);
    }

    @Override
    protected void doCreateOrUpdateNonstrict(Entity entity) {
        insertOrUpdate((DataConfigToLabelTypeMapping) entity);
    }

    /**
     * Delete the entity. {UpdateCountZeroException, ConcurrencyControl}
     * @param dataConfigToLabelTypeMapping The entity of delete target. (NotNull) {PrimaryKeyRequired, ConcurrencyColumnRequired}
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     */
    public void delete(DataConfigToLabelTypeMapping dataConfigToLabelTypeMapping) {
        helpDeleteInternally(dataConfigToLabelTypeMapping,
                new InternalDeleteCallback<DataConfigToLabelTypeMapping>() {
                    public int callbackDelegateDelete(
                            DataConfigToLabelTypeMapping entity) {
                        return delegateDelete(entity);
                    }
                });
    }

    @Override
    protected void doRemove(Entity dataConfigToLabelTypeMapping) {
        delete((DataConfigToLabelTypeMapping) dataConfigToLabelTypeMapping);
    }

    // ===================================================================================
    //                                                                        Batch Update
    //                                                                        ============
    /**
     * Batch insert the list. This method use 'Batch Update' of java.sql.PreparedStatement.
     * @param dataConfigToLabelTypeMappingList The list of the entity. (NotNull)
     * @return The array of inserted count.
     */
    public int[] batchInsert(
            List<DataConfigToLabelTypeMapping> dataConfigToLabelTypeMappingList) {
        assertObjectNotNull("dataConfigToLabelTypeMappingList",
                dataConfigToLabelTypeMappingList);
        return delegateInsertList(dataConfigToLabelTypeMappingList);
    }

    /**
     * Batch update the list. All columns are update target. {NOT modified only} <br />
     * This method use 'Batch Update' of java.sql.PreparedStatement.
     * @param dataConfigToLabelTypeMappingList The list of the entity. (NotNull)
     * @return The array of updated count.
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     */
    public int[] batchUpdate(
            List<DataConfigToLabelTypeMapping> dataConfigToLabelTypeMappingList) {
        assertObjectNotNull("dataConfigToLabelTypeMappingList",
                dataConfigToLabelTypeMappingList);
        return delegateUpdateList(dataConfigToLabelTypeMappingList);
    }

    /**
     * Batch delete the list. <br />
     * This method use 'Batch Update' of java.sql.PreparedStatement.
     * @param dataConfigToLabelTypeMappingList The list of the entity. (NotNull)
     * @return The array of deleted count.
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     */
    public int[] batchDelete(
            List<DataConfigToLabelTypeMapping> dataConfigToLabelTypeMappingList) {
        assertObjectNotNull("dataConfigToLabelTypeMappingList",
                dataConfigToLabelTypeMappingList);
        return delegateDeleteList(dataConfigToLabelTypeMappingList);
    }

    // ===================================================================================
    //                                                                        Query Update
    //                                                                        ============
    /**
     * Query update the several entities. {NoConcurrencyControl}
     * @param dataConfigToLabelTypeMapping Entity. (NotNull) {PrimaryKeyNotRequired}
     * @param cb Condition-bean. (NotNull)
     * @return The updated count.
     */
    public int queryUpdate(
            DataConfigToLabelTypeMapping dataConfigToLabelTypeMapping,
            DataConfigToLabelTypeMappingCB cb) {
        assertObjectNotNull("dataConfigToLabelTypeMapping",
                dataConfigToLabelTypeMapping);
        assertCBNotNull(cb);
        setupCommonColumnOfUpdateIfNeeds(dataConfigToLabelTypeMapping);
        filterEntityOfUpdate(dataConfigToLabelTypeMapping);
        assertEntityOfUpdate(dataConfigToLabelTypeMapping);
        return invoke(createQueryUpdateEntityCBCommand(
                dataConfigToLabelTypeMapping, cb));
    }

    /**
     * Query delete the several entities. {NoConcurrencyControl}
     * @param cb Condition-bean. (NotNull)
     * @return The deleted count.
     */
    public int queryDelete(DataConfigToLabelTypeMappingCB cb) {
        assertCBNotNull(cb);
        return invoke(createQueryDeleteCBCommand(cb));
    }

    // ===================================================================================
    //                                                                     Delegate Method
    //                                                                     ===============
    // [Behavior Command]
    // -----------------------------------------------------
    //                                                Select
    //                                                ------
    protected int delegateSelectCount(DataConfigToLabelTypeMappingCB cb) {
        return invoke(createSelectCountCBCommand(cb));
    }

    protected void delegateSelectCursor(DataConfigToLabelTypeMappingCB cb,
            EntityRowHandler<DataConfigToLabelTypeMapping> entityRowHandler) {
        invoke(createSelectCursorCBCommand(cb, entityRowHandler,
                DataConfigToLabelTypeMapping.class));
    }

    protected int doCallReadCount(ConditionBean cb) {
        return delegateSelectCount((DataConfigToLabelTypeMappingCB) cb);
    }

    protected List<DataConfigToLabelTypeMapping> delegateSelectList(
            DataConfigToLabelTypeMappingCB cb) {
        return invoke(createSelectListCBCommand(cb,
                DataConfigToLabelTypeMapping.class));
    }

    @SuppressWarnings("unchecked")
    protected List<Entity> doCallReadList(ConditionBean cb) {
        return (List) delegateSelectList((DataConfigToLabelTypeMappingCB) cb);
    }

    // -----------------------------------------------------
    //                                                Update
    //                                                ------
    protected int delegateInsert(DataConfigToLabelTypeMapping e) {
        if (!processBeforeInsert(e)) {
            return 1;
        }
        return invoke(createInsertEntityCommand(e));
    }

    protected int doCallCreate(Entity entity) {
        return delegateInsert(downcast(entity));
    }

    protected int delegateUpdate(DataConfigToLabelTypeMapping e) {
        if (!processBeforeUpdate(e)) {
            return 1;
        }
        return invoke(createUpdateEntityCommand(e));
    }

    protected int doCallModify(Entity entity) {
        return delegateUpdate(downcast(entity));
    }

    protected int delegateDelete(DataConfigToLabelTypeMapping e) {
        if (!processBeforeDelete(e)) {
            return 1;
        }
        return invoke(createDeleteEntityCommand(e));
    }

    protected int doCallRemove(Entity entity) {
        return delegateDelete(downcast(entity));
    }

    protected int[] delegateInsertList(List<DataConfigToLabelTypeMapping> ls) {
        if (ls.isEmpty()) {
            return new int[] {};
        }
        return invoke(createBatchInsertEntityCommand(helpFilterBeforeInsertInternally(ls)));
    }

    @SuppressWarnings("unchecked")
    protected int[] doCreateList(List<Entity> ls) {
        return delegateInsertList((List) ls);
    }

    protected int[] delegateUpdateList(List<DataConfigToLabelTypeMapping> ls) {
        if (ls.isEmpty()) {
            return new int[] {};
        }
        return invoke(createBatchUpdateEntityCommand(helpFilterBeforeUpdateInternally(ls)));
    }

    @SuppressWarnings("unchecked")
    protected int[] doModifyList(List<Entity> ls) {
        return delegateUpdateList((List) ls);
    }

    protected int[] delegateDeleteList(List<DataConfigToLabelTypeMapping> ls) {
        if (ls.isEmpty()) {
            return new int[] {};
        }
        return invoke(createBatchDeleteEntityCommand(helpFilterBeforeDeleteInternally(ls)));
    }

    @SuppressWarnings("unchecked")
    protected int[] doRemoveList(List<Entity> ls) {
        return delegateDeleteList((List) ls);
    }

    // ===================================================================================
    //                                                                Optimistic Lock Info
    //                                                                ====================
    @Override
    protected boolean hasVersionNoValue(Entity entity) {
        return false;
    }

    @Override
    protected boolean hasUpdateDateValue(Entity entity) {
        return false;
    }

    // ===================================================================================
    //                                                                              Helper
    //                                                                              ======
    protected DataConfigToLabelTypeMapping downcast(Entity entity) {
        return helpDowncastInternally(entity,
                DataConfigToLabelTypeMapping.class);
    }
}
