/*
 * Copyright 2009-2011 the Fess Project and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */

package jp.sf.fess.crud.action.admin;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;

import jp.sf.fess.crud.CommonConstants;
import jp.sf.fess.crud.CrudMessageException;
import jp.sf.fess.crud.util.SAStrutsUtil;
import jp.sf.fess.db.exentity.FileCrawlingConfig;
import jp.sf.fess.form.admin.FileCrawlingConfigForm;
import jp.sf.fess.pager.FileCrawlingConfigPager;
import jp.sf.fess.service.FileCrawlingConfigService;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.seasar.framework.beans.util.Beans;
import org.seasar.framework.util.StringUtil;
import org.seasar.struts.annotation.ActionForm;
import org.seasar.struts.annotation.Execute;
import org.seasar.struts.exception.ActionMessagesException;

public class BsFileCrawlingConfigAction implements Serializable {

    private static final long serialVersionUID = 1L;

    private static final Log log = LogFactory
            .getLog(BsFileCrawlingConfigAction.class);

    // for list

    public List<FileCrawlingConfig> fileCrawlingConfigItems;

    // for edit/confirm/delete

    @ActionForm
    @Resource
    protected FileCrawlingConfigForm fileCrawlingConfigForm;

    @Resource
    protected FileCrawlingConfigService fileCrawlingConfigService;

    @Resource
    protected FileCrawlingConfigPager fileCrawlingConfigPager;

    protected String displayList(boolean redirect) {
        // page navi
        fileCrawlingConfigItems = fileCrawlingConfigService
                .getFileCrawlingConfigList(fileCrawlingConfigPager);

        // restore from pager
        Beans.copy(fileCrawlingConfigPager, fileCrawlingConfigForm.searchParams)
                .excludes(CommonConstants.PAGER_CONVERSION_RULE).execute();

        if (redirect) {
            return "index?redirect=true";
        } else {
            return "index.jsp";
        }
    }

    @Execute(validator = false, input = "error.jsp")
    public String index() {
        return displayList(false);
    }

    @Execute(validator = false, input = "error.jsp", urlPattern = "list/{pageNumber}")
    public String list() {
        // page navi
        if (StringUtil.isNotBlank(fileCrawlingConfigForm.pageNumber)) {
            try {
                fileCrawlingConfigPager.setCurrentPageNumber(Integer
                        .parseInt(fileCrawlingConfigForm.pageNumber));
            } catch (NumberFormatException e) {
                if (log.isDebugEnabled()) {
                    log.debug("Invalid value: "
                            + fileCrawlingConfigForm.pageNumber, e);
                }
            }
        }

        return displayList(false);
    }

    @Execute(validator = false, input = "error.jsp")
    public String search() {
        Beans.copy(fileCrawlingConfigForm.searchParams, fileCrawlingConfigPager)
                .excludes(CommonConstants.PAGER_CONVERSION_RULE).execute();

        return displayList(false);
    }

    @Execute(validator = false, input = "error.jsp")
    public String reset() {
        fileCrawlingConfigPager.clear();

        return displayList(false);
    }

    @Execute(validator = false, input = "error.jsp")
    public String back() {
        return displayList(false);
    }

    @Execute(validator = false, input = "error.jsp")
    public String editagain() {
        return "edit.jsp";
    }

    @Execute(validator = false, input = "error.jsp", urlPattern = "confirmpage/{crudMode}/{id}")
    public String confirmpage() {
        if (fileCrawlingConfigForm.crudMode != CommonConstants.CONFIRM_MODE) {
            throw new ActionMessagesException("errors.crud_invalid_mode",
                    new Object[] { CommonConstants.CONFIRM_MODE,
                            fileCrawlingConfigForm.crudMode });
        }

        loadFileCrawlingConfig();

        return "confirm.jsp";
    }

    @Execute(validator = false, input = "error.jsp")
    public String createpage() {
        // page navi
        fileCrawlingConfigForm.initialize();
        fileCrawlingConfigForm.crudMode = CommonConstants.CREATE_MODE;

        return "edit.jsp";
    }

    @Execute(validator = false, input = "error.jsp", urlPattern = "editpage/{crudMode}/{id}")
    public String editpage() {
        if (fileCrawlingConfigForm.crudMode != CommonConstants.EDIT_MODE) {
            throw new ActionMessagesException("errors.crud_invalid_mode",
                    new Object[] { CommonConstants.EDIT_MODE,
                            fileCrawlingConfigForm.crudMode });
        }

        loadFileCrawlingConfig();

        return "edit.jsp";
    }

    @Execute(validator = false, input = "error.jsp")
    public String editfromconfirm() {
        fileCrawlingConfigForm.crudMode = CommonConstants.EDIT_MODE;

        loadFileCrawlingConfig();

        return "edit.jsp";
    }

    @Execute(validator = true, input = "edit.jsp")
    public String confirmfromcreate() {
        return "confirm.jsp";
    }

    @Execute(validator = true, input = "edit.jsp")
    public String confirmfromupdate() {
        return "confirm.jsp";
    }

    @Execute(validator = false, input = "error.jsp", urlPattern = "deletepage/{crudMode}/{id}")
    public String deletepage() {
        if (fileCrawlingConfigForm.crudMode != CommonConstants.DELETE_MODE) {
            throw new ActionMessagesException("errors.crud_invalid_mode",
                    new Object[] { CommonConstants.DELETE_MODE,
                            fileCrawlingConfigForm.crudMode });
        }

        loadFileCrawlingConfig();

        return "confirm.jsp";
    }

    @Execute(validator = false, input = "error.jsp")
    public String deletefromconfirm() {
        fileCrawlingConfigForm.crudMode = CommonConstants.DELETE_MODE;

        loadFileCrawlingConfig();

        return "confirm.jsp";
    }

    @Execute(validator = true, input = "edit.jsp")
    public String create() {
        try {
            FileCrawlingConfig fileCrawlingConfig = createFileCrawlingConfig();
            fileCrawlingConfigService.store(fileCrawlingConfig);
            SAStrutsUtil.addSessionMessage("success.crud_create_crud_table");

            return displayList(true);
        } catch (ActionMessagesException e) {
            log.error(e.getMessage(), e);
            throw e;
        } catch (CrudMessageException e) {
            log.error(e.getMessage(), e);
            throw new ActionMessagesException(e.getMessageId(), e.getArgs());
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            throw new ActionMessagesException(
                    "errors.crud_failed_to_create_crud_table");
        }
    }

    @Execute(validator = true, input = "edit.jsp")
    public String update() {
        try {
            FileCrawlingConfig fileCrawlingConfig = createFileCrawlingConfig();
            fileCrawlingConfigService.store(fileCrawlingConfig);
            SAStrutsUtil.addSessionMessage("success.crud_update_crud_table");

            return displayList(true);
        } catch (ActionMessagesException e) {
            log.error(e.getMessage(), e);
            throw e;
        } catch (CrudMessageException e) {
            log.error(e.getMessage(), e);
            throw new ActionMessagesException(e.getMessageId(), e.getArgs());
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            throw new ActionMessagesException(
                    "errors.crud_failed_to_update_crud_table");
        }
    }

    @Execute(validator = false, input = "error.jsp")
    public String delete() {
        if (fileCrawlingConfigForm.crudMode != CommonConstants.DELETE_MODE) {
            throw new ActionMessagesException("errors.crud_invalid_mode",
                    new Object[] { CommonConstants.DELETE_MODE,
                            fileCrawlingConfigForm.crudMode });
        }

        try {
            FileCrawlingConfig fileCrawlingConfig = fileCrawlingConfigService
                    .getFileCrawlingConfig(createKeyMap());
            if (fileCrawlingConfig == null) {
                // throw an exception
                throw new ActionMessagesException(
                        "errors.crud_could_not_find_crud_table",

                        new Object[] { fileCrawlingConfigForm.id });

            }

            fileCrawlingConfigService.delete(fileCrawlingConfig);
            SAStrutsUtil.addSessionMessage("success.crud_delete_crud_table");

            return displayList(true);
        } catch (ActionMessagesException e) {
            log.error(e.getMessage(), e);
            throw e;
        } catch (CrudMessageException e) {
            log.error(e.getMessage(), e);
            throw new ActionMessagesException(e.getMessageId(), e.getArgs());
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            throw new ActionMessagesException(
                    "errors.crud_failed_to_delete_crud_table");
        }
    }

    protected void loadFileCrawlingConfig() {

        FileCrawlingConfig fileCrawlingConfig = fileCrawlingConfigService
                .getFileCrawlingConfig(createKeyMap());
        if (fileCrawlingConfig == null) {
            // throw an exception
            throw new ActionMessagesException(
                    "errors.crud_could_not_find_crud_table",

                    new Object[] { fileCrawlingConfigForm.id });

        }

        Beans.copy(fileCrawlingConfig, fileCrawlingConfigForm)
                .excludes("searchParams", "mode").execute();
    }

    protected FileCrawlingConfig createFileCrawlingConfig() {
        FileCrawlingConfig fileCrawlingConfig;
        if (fileCrawlingConfigForm.crudMode == CommonConstants.EDIT_MODE) {
            fileCrawlingConfig = fileCrawlingConfigService
                    .getFileCrawlingConfig(createKeyMap());
            if (fileCrawlingConfig == null) {
                // throw an exception
                throw new ActionMessagesException(
                        "errors.crud_could_not_find_crud_table",

                        new Object[] { fileCrawlingConfigForm.id });

            }
        } else {
            fileCrawlingConfig = new FileCrawlingConfig();
        }
        Beans.copy(fileCrawlingConfigForm, fileCrawlingConfig)
                .excludes("searchParams", "mode").execute();

        return fileCrawlingConfig;
    }

    protected Map<String, String> createKeyMap() {
        Map<String, String> keys = new HashMap<String, String>();

        keys.put("id", fileCrawlingConfigForm.id);

        return keys;
    }
}
