/*
 * Copyright 2009-2010 the Fess Project and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */

package jp.sf.fess.db.cbean.cq.bs;

import java.util.Collection;

import jp.sf.fess.db.allcommon.DBMetaInstanceHandler;
import jp.sf.fess.db.cbean.DataConfigToLabelTypeMappingCB;
import jp.sf.fess.db.cbean.DataCrawlingConfigCB;
import jp.sf.fess.db.cbean.LabelTypeCB;
import jp.sf.fess.db.cbean.cq.DataConfigToLabelTypeMappingCQ;
import jp.sf.fess.db.cbean.cq.DataCrawlingConfigCQ;
import jp.sf.fess.db.cbean.cq.LabelTypeCQ;

import org.seasar.dbflute.cbean.AbstractConditionQuery;
import org.seasar.dbflute.cbean.ConditionQuery;
import org.seasar.dbflute.cbean.SubQuery;
import org.seasar.dbflute.cbean.ckey.ConditionKey;
import org.seasar.dbflute.cbean.coption.LikeSearchOption;
import org.seasar.dbflute.cbean.cvalue.ConditionValue;
import org.seasar.dbflute.cbean.sqlclause.SqlClause;
import org.seasar.dbflute.dbmeta.DBMetaProvider;

/**
 * The abstract condition-query of DATA_CONFIG_TO_LABEL_TYPE_MAPPING.
 * @author DBFlute(AutoGenerator)
 */
public abstract class AbstractBsDataConfigToLabelTypeMappingCQ extends
        AbstractConditionQuery {

    // ===================================================================================
    //                                                                           Attribute
    //                                                                           =========
    protected final DBMetaProvider _dbmetaProvider = new DBMetaInstanceHandler();

    // ===================================================================================
    //                                                                         Constructor
    //                                                                         ===========
    public AbstractBsDataConfigToLabelTypeMappingCQ(ConditionQuery childQuery,
            SqlClause sqlClause, String aliasName, int nestLevel) {
        super(childQuery, sqlClause, aliasName, nestLevel);
    }

    // ===================================================================================
    //                                                                     DBMeta Provider
    //                                                                     ===============
    @Override
    protected DBMetaProvider getDBMetaProvider() {
        return _dbmetaProvider;
    }

    // ===================================================================================
    //                                                                          Table Name
    //                                                                          ==========
    public String getTableDbName() {
        return "DATA_CONFIG_TO_LABEL_TYPE_MAPPING";
    }

    public String getTableSqlName() {
        return "DATA_CONFIG_TO_LABEL_TYPE_MAPPING";
    }

    // ===================================================================================
    //                                                                               Query
    //                                                                               =====

    /**
     * Equal(=). And NullIgnored, OnlyOnceRegistered. {PK : ID : NotNull : BIGINT}
     * @param id The value of id as equal.
     */
    public void setId_Equal(Long id) {
        regId(CK_EQ, id);
    }

    /**
     * NotEqual(!=). And NullIgnored, OnlyOnceRegistered.
     * @param id The value of id as notEqual.
     */
    public void setId_NotEqual(Long id) {
        regId(CK_NE, id);
    }

    /**
     * GreaterThan(&gt;). And NullIgnored, OnlyOnceRegistered.
     * @param id The value of id as greaterThan.
     */
    public void setId_GreaterThan(Long id) {
        regId(CK_GT, id);
    }

    /**
     * LessThan(&lt;). And NullIgnored, OnlyOnceRegistered.
     * @param id The value of id as lessThan.
     */
    public void setId_LessThan(Long id) {
        regId(CK_LT, id);
    }

    /**
     * GreaterEqual(&gt;=). And NullIgnored, OnlyOnceRegistered.
     * @param id The value of id as greaterEqual.
     */
    public void setId_GreaterEqual(Long id) {
        regId(CK_GE, id);
    }

    /**
     * LessEqual(&lt;=). And NullIgnored, OnlyOnceRegistered.
     * @param id The value of id as lessEqual.
     */
    public void setId_LessEqual(Long id) {
        regId(CK_LE, id);
    }

    /**
     * InScope(in (1, 2)). And NullIgnored, NullElementIgnored, SeveralRegistered.
     * @param idList The collection of id as inScope.
     */
    public void setId_InScope(Collection<Long> idList) {
        regINS(CK_INS, cTL(idList), getCValueId(), "ID");
    }

    /**
     * NotInScope(not in (1, 2)). And NullIgnored, NullElementIgnored, SeveralRegistered.
     * @param idList The collection of id as notInScope.
     */
    public void setId_NotInScope(Collection<Long> idList) {
        regINS(CK_NINS, cTL(idList), getCValueId(), "ID");
    }

    /**
     * IsNull(is null). And OnlyOnceRegistered.
     */
    public void setId_IsNull() {
        regId(CK_ISN, DOBJ);
    }

    /**
     * IsNotNull(is not null). And OnlyOnceRegistered.
     */
    public void setId_IsNotNull() {
        regId(CK_ISNN, DOBJ);
    }

    protected void regId(ConditionKey k, Object v) {
        regQ(k, v, getCValueId(), "ID");
    }

    abstract protected ConditionValue getCValueId();

    /**
     * Equal(=). And NullIgnored, OnlyOnceRegistered. {NotNull : BIGINT : FK to DATA_CRAWLING_CONFIG}
     * @param dataConfigId The value of dataConfigId as equal.
     */
    public void setDataConfigId_Equal(Long dataConfigId) {
        regDataConfigId(CK_EQ, dataConfigId);
    }

    /**
     * NotEqual(!=). And NullIgnored, OnlyOnceRegistered.
     * @param dataConfigId The value of dataConfigId as notEqual.
     */
    public void setDataConfigId_NotEqual(Long dataConfigId) {
        regDataConfigId(CK_NE, dataConfigId);
    }

    /**
     * GreaterThan(&gt;). And NullIgnored, OnlyOnceRegistered.
     * @param dataConfigId The value of dataConfigId as greaterThan.
     */
    public void setDataConfigId_GreaterThan(Long dataConfigId) {
        regDataConfigId(CK_GT, dataConfigId);
    }

    /**
     * LessThan(&lt;). And NullIgnored, OnlyOnceRegistered.
     * @param dataConfigId The value of dataConfigId as lessThan.
     */
    public void setDataConfigId_LessThan(Long dataConfigId) {
        regDataConfigId(CK_LT, dataConfigId);
    }

    /**
     * GreaterEqual(&gt;=). And NullIgnored, OnlyOnceRegistered.
     * @param dataConfigId The value of dataConfigId as greaterEqual.
     */
    public void setDataConfigId_GreaterEqual(Long dataConfigId) {
        regDataConfigId(CK_GE, dataConfigId);
    }

    /**
     * LessEqual(&lt;=). And NullIgnored, OnlyOnceRegistered.
     * @param dataConfigId The value of dataConfigId as lessEqual.
     */
    public void setDataConfigId_LessEqual(Long dataConfigId) {
        regDataConfigId(CK_LE, dataConfigId);
    }

    /**
     * InScope(in (1, 2)). And NullIgnored, NullElementIgnored, SeveralRegistered.
     * @param dataConfigIdList The collection of dataConfigId as inScope.
     */
    public void setDataConfigId_InScope(Collection<Long> dataConfigIdList) {
        regINS(CK_INS, cTL(dataConfigIdList), getCValueDataConfigId(),
                "DATA_CONFIG_ID");
    }

    /**
     * NotInScope(not in (1, 2)). And NullIgnored, NullElementIgnored, SeveralRegistered.
     * @param dataConfigIdList The collection of dataConfigId as notInScope.
     */
    public void setDataConfigId_NotInScope(Collection<Long> dataConfigIdList) {
        regINS(CK_NINS, cTL(dataConfigIdList), getCValueDataConfigId(),
                "DATA_CONFIG_ID");
    }

    public void inScopeDataCrawlingConfig(
            SubQuery<DataCrawlingConfigCB> subQuery) {
        assertObjectNotNull("subQuery<DataCrawlingConfigCB>", subQuery);
        DataCrawlingConfigCB cb = new DataCrawlingConfigCB();
        cb.xsetupForInScopeSubQuery();
        subQuery.query(cb);
        String subQueryPropertyName = keepDataConfigId_InScopeSubQuery_DataCrawlingConfig(cb
                .query()); // for saving query-value.
        registerInScopeSubQuery(cb.query(), "DATA_CONFIG_ID", "ID",
                subQueryPropertyName);
    }

    public abstract String keepDataConfigId_InScopeSubQuery_DataCrawlingConfig(
            DataCrawlingConfigCQ subQuery);

    protected void regDataConfigId(ConditionKey k, Object v) {
        regQ(k, v, getCValueDataConfigId(), "DATA_CONFIG_ID");
    }

    abstract protected ConditionValue getCValueDataConfigId();

    /**
     * Equal(=). And NullIgnored, OnlyOnceRegistered. {NotNull : BIGINT : FK to LABEL_TYPE}
     * @param labelTypeId The value of labelTypeId as equal.
     */
    public void setLabelTypeId_Equal(Long labelTypeId) {
        regLabelTypeId(CK_EQ, labelTypeId);
    }

    /**
     * NotEqual(!=). And NullIgnored, OnlyOnceRegistered.
     * @param labelTypeId The value of labelTypeId as notEqual.
     */
    public void setLabelTypeId_NotEqual(Long labelTypeId) {
        regLabelTypeId(CK_NE, labelTypeId);
    }

    /**
     * GreaterThan(&gt;). And NullIgnored, OnlyOnceRegistered.
     * @param labelTypeId The value of labelTypeId as greaterThan.
     */
    public void setLabelTypeId_GreaterThan(Long labelTypeId) {
        regLabelTypeId(CK_GT, labelTypeId);
    }

    /**
     * LessThan(&lt;). And NullIgnored, OnlyOnceRegistered.
     * @param labelTypeId The value of labelTypeId as lessThan.
     */
    public void setLabelTypeId_LessThan(Long labelTypeId) {
        regLabelTypeId(CK_LT, labelTypeId);
    }

    /**
     * GreaterEqual(&gt;=). And NullIgnored, OnlyOnceRegistered.
     * @param labelTypeId The value of labelTypeId as greaterEqual.
     */
    public void setLabelTypeId_GreaterEqual(Long labelTypeId) {
        regLabelTypeId(CK_GE, labelTypeId);
    }

    /**
     * LessEqual(&lt;=). And NullIgnored, OnlyOnceRegistered.
     * @param labelTypeId The value of labelTypeId as lessEqual.
     */
    public void setLabelTypeId_LessEqual(Long labelTypeId) {
        regLabelTypeId(CK_LE, labelTypeId);
    }

    /**
     * InScope(in (1, 2)). And NullIgnored, NullElementIgnored, SeveralRegistered.
     * @param labelTypeIdList The collection of labelTypeId as inScope.
     */
    public void setLabelTypeId_InScope(Collection<Long> labelTypeIdList) {
        regINS(CK_INS, cTL(labelTypeIdList), getCValueLabelTypeId(),
                "LABEL_TYPE_ID");
    }

    /**
     * NotInScope(not in (1, 2)). And NullIgnored, NullElementIgnored, SeveralRegistered.
     * @param labelTypeIdList The collection of labelTypeId as notInScope.
     */
    public void setLabelTypeId_NotInScope(Collection<Long> labelTypeIdList) {
        regINS(CK_NINS, cTL(labelTypeIdList), getCValueLabelTypeId(),
                "LABEL_TYPE_ID");
    }

    public void inScopeLabelType(SubQuery<LabelTypeCB> subQuery) {
        assertObjectNotNull("subQuery<LabelTypeCB>", subQuery);
        LabelTypeCB cb = new LabelTypeCB();
        cb.xsetupForInScopeSubQuery();
        subQuery.query(cb);
        String subQueryPropertyName = keepLabelTypeId_InScopeSubQuery_LabelType(cb
                .query()); // for saving query-value.
        registerInScopeSubQuery(cb.query(), "LABEL_TYPE_ID", "ID",
                subQueryPropertyName);
    }

    public abstract String keepLabelTypeId_InScopeSubQuery_LabelType(
            LabelTypeCQ subQuery);

    protected void regLabelTypeId(ConditionKey k, Object v) {
        regQ(k, v, getCValueLabelTypeId(), "LABEL_TYPE_ID");
    }

    abstract protected ConditionValue getCValueLabelTypeId();

    // ===================================================================================
    //                                                                     Scalar SubQuery
    //                                                                     ===============
    public SSQFunction<DataConfigToLabelTypeMappingCB> scalar_Equal() {
        return xcreateSSQFunction("=");
    }

    public SSQFunction<DataConfigToLabelTypeMappingCB> scalar_GreaterEqual() {
        return xcreateSSQFunction(">=");
    }

    public SSQFunction<DataConfigToLabelTypeMappingCB> scalar_GreaterThan() {
        return xcreateSSQFunction(">");
    }

    public SSQFunction<DataConfigToLabelTypeMappingCB> scalar_LessEqual() {
        return xcreateSSQFunction("<=");
    }

    public SSQFunction<DataConfigToLabelTypeMappingCB> scalar_LessThan() {
        return xcreateSSQFunction("<");
    }

    protected SSQFunction<DataConfigToLabelTypeMappingCB> xcreateSSQFunction(
            final String operand) {
        return new SSQFunction<DataConfigToLabelTypeMappingCB>(
                new SSQSetupper<DataConfigToLabelTypeMappingCB>() {
                    public void setup(String function,
                            SubQuery<DataConfigToLabelTypeMappingCB> subQuery) {
                        xscalarSubQuery(function, subQuery, operand);
                    }
                });
    }

    protected void xscalarSubQuery(String function,
            SubQuery<DataConfigToLabelTypeMappingCB> subQuery, String operand) {
        assertObjectNotNull("subQuery<DataConfigToLabelTypeMappingCB>",
                subQuery);
        DataConfigToLabelTypeMappingCB cb = new DataConfigToLabelTypeMappingCB();
        cb.xsetupForScalarSubQuery();
        subQuery.query(cb);
        String subQueryPropertyName = keepScalarSubQuery(cb.query()); // for saving query-value.
        registerScalarSubQuery(function, cb.query(), subQueryPropertyName,
                operand);
    }

    public abstract String keepScalarSubQuery(
            DataConfigToLabelTypeMappingCQ subQuery);

    // ===================================================================================
    //                                                             MySelf InScope SubQuery
    //                                                             =======================
    /**
     * Myself InScope SubQuery. {mainly for CLOB and Union}
     * @param subQuery The implementation of sub query. (NotNull)
     */
    public void myselfInScope(SubQuery<DataConfigToLabelTypeMappingCB> subQuery) {
        assertObjectNotNull("subQuery<DataConfigToLabelTypeMappingCB>",
                subQuery);
        DataConfigToLabelTypeMappingCB cb = new DataConfigToLabelTypeMappingCB();
        cb.xsetupForInScopeSubQuery();
        subQuery.query(cb);
        String subQueryPropertyName = keepMyselfInScopeSubQuery(cb.query()); // for saving query-value.
        registerInScopeSubQuery(cb.query(), "ID", "ID", subQueryPropertyName);
    }

    public abstract String keepMyselfInScopeSubQuery(
            DataConfigToLabelTypeMappingCQ subQuery);

    // ===================================================================================
    //                                                                       Very Internal
    //                                                                       =============
    // Very Internal (for Suppressing Warn about 'Not Use Import')
    String xCB() {
        return DataConfigToLabelTypeMappingCB.class.getName();
    }

    String xCQ() {
        return DataConfigToLabelTypeMappingCQ.class.getName();
    }

    String xLSO() {
        return LikeSearchOption.class.getName();
    }
}
