/*
 * Copyright 2009-2012 the Fess Project and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */

package jp.sf.fess.db.bsbhv;

import java.util.List;

import jp.sf.fess.db.bsentity.dbmeta.WebConfigToRoleTypeMappingDbm;
import jp.sf.fess.db.cbean.WebConfigToRoleTypeMappingCB;
import jp.sf.fess.db.exbhv.WebConfigToRoleTypeMappingBhv;
import jp.sf.fess.db.exentity.RoleType;
import jp.sf.fess.db.exentity.WebConfigToRoleTypeMapping;
import jp.sf.fess.db.exentity.WebCrawlingConfig;

import org.seasar.dbflute.Entity;
import org.seasar.dbflute.bhv.AbstractBehaviorWritable;
import org.seasar.dbflute.bhv.DeleteOption;
import org.seasar.dbflute.bhv.InsertOption;
import org.seasar.dbflute.bhv.QueryInsertSetupper;
import org.seasar.dbflute.bhv.UpdateOption;
import org.seasar.dbflute.cbean.ConditionBean;
import org.seasar.dbflute.cbean.EntityRowHandler;
import org.seasar.dbflute.cbean.ListResultBean;
import org.seasar.dbflute.cbean.PagingResultBean;
import org.seasar.dbflute.cbean.SpecifyQuery;
import org.seasar.dbflute.dbmeta.DBMeta;
import org.seasar.dbflute.outsidesql.executor.OutsideSqlBasicExecutor;

/**
 * The behavior of WEB_CONFIG_TO_ROLE_TYPE_MAPPING as TABLE. <br />
 * <pre>
 * [primary key]
 *     ID
 * 
 * [column]
 *     ID, WEB_CONFIG_ID, ROLE_TYPE_ID
 * 
 * [sequence]
 *     
 * 
 * [identity]
 *     ID
 * 
 * [version-no]
 *     
 * 
 * [foreign table]
 *     WEB_CRAWLING_CONFIG, ROLE_TYPE
 * 
 * [referrer table]
 *     
 * 
 * [foreign property]
 *     webCrawlingConfig, roleType
 * 
 * [referrer property]
 *     
 * </pre>
 * @author DBFlute(AutoGenerator)
 */
public abstract class BsWebConfigToRoleTypeMappingBhv extends
        AbstractBehaviorWritable {

    // ===================================================================================
    //                                                                          Definition
    //                                                                          ==========
    /*df:beginQueryPath*/
    /*df:endQueryPath*/

    // ===================================================================================
    //                                                                          Table name
    //                                                                          ==========
    /** @return The name on database of table. (NotNull) */
    @Override
    public String getTableDbName() {
        return "WEB_CONFIG_TO_ROLE_TYPE_MAPPING";
    }

    // ===================================================================================
    //                                                                              DBMeta
    //                                                                              ======
    /** @return The instance of DBMeta. (NotNull) */
    @Override
    public DBMeta getDBMeta() {
        return WebConfigToRoleTypeMappingDbm.getInstance();
    }

    /** @return The instance of DBMeta as my table type. (NotNull) */
    public WebConfigToRoleTypeMappingDbm getMyDBMeta() {
        return WebConfigToRoleTypeMappingDbm.getInstance();
    }

    // ===================================================================================
    //                                                                        New Instance
    //                                                                        ============
    /** {@inheritDoc} */
    @Override
    public Entity newEntity() {
        return newMyEntity();
    }

    /** {@inheritDoc} */
    @Override
    public ConditionBean newConditionBean() {
        return newMyConditionBean();
    }

    /** @return The instance of new entity as my table type. (NotNull) */
    public WebConfigToRoleTypeMapping newMyEntity() {
        return new WebConfigToRoleTypeMapping();
    }

    /** @return The instance of new condition-bean as my table type. (NotNull) */
    public WebConfigToRoleTypeMappingCB newMyConditionBean() {
        return new WebConfigToRoleTypeMappingCB();
    }

    // ===================================================================================
    //                                                                        Count Select
    //                                                                        ============
    /**
     * Select the count of uniquely-selected records by the condition-bean. {IgnorePagingCondition, IgnoreSpecifyColumn}<br />
     * SpecifyColumn is ignored but you can use it only to remove text type column for union's distinct.
     * <pre>
     * WebConfigToRoleTypeMappingCB cb = new WebConfigToRoleTypeMappingCB();
     * cb.query().setFoo...(value);
     * int count = webConfigToRoleTypeMappingBhv.<span style="color: #FD4747">selectCount</span>(cb);
     * </pre>
     * @param cb The condition-bean of WebConfigToRoleTypeMapping. (NotNull)
     * @return The selected count.
     */
    public int selectCount(final WebConfigToRoleTypeMappingCB cb) {
        return doSelectCountUniquely(cb);
    }

    protected int doSelectCountUniquely(final WebConfigToRoleTypeMappingCB cb) { // called by selectCount(cb) 
        assertCBStateValid(cb);
        return delegateSelectCountUniquely(cb);
    }

    protected int doSelectCountPlainly(final WebConfigToRoleTypeMappingCB cb) { // called by selectPage(cb)
        assertCBStateValid(cb);
        return delegateSelectCountPlainly(cb);
    }

    @Override
    protected int doReadCount(final ConditionBean cb) {
        return selectCount(downcast(cb));
    }

    // ===================================================================================
    //                                                                       Cursor Select
    //                                                                       =============
    /**
     * Select the cursor by the condition-bean.
     * <pre>
     * WebConfigToRoleTypeMappingCB cb = new WebConfigToRoleTypeMappingCB();
     * cb.query().setFoo...(value);
     * webConfigToRoleTypeMappingBhv.<span style="color: #FD4747">selectCursor</span>(cb, new EntityRowHandler&lt;WebConfigToRoleTypeMapping&gt;() {
     *     public void handle(WebConfigToRoleTypeMapping entity) {
     *         ... = entity.getFoo...();
     *     }
     * });
     * </pre>
     * @param cb The condition-bean of WebConfigToRoleTypeMapping. (NotNull)
     * @param entityRowHandler The handler of entity row of WebConfigToRoleTypeMapping. (NotNull)
     */
    public void selectCursor(final WebConfigToRoleTypeMappingCB cb,
            final EntityRowHandler<WebConfigToRoleTypeMapping> entityRowHandler) {
        doSelectCursor(cb, entityRowHandler, WebConfigToRoleTypeMapping.class);
    }

    protected <ENTITY extends WebConfigToRoleTypeMapping> void doSelectCursor(
            final WebConfigToRoleTypeMappingCB cb,
            final EntityRowHandler<ENTITY> entityRowHandler,
            final Class<ENTITY> entityType) {
        assertCBStateValid(cb);
        assertObjectNotNull("entityRowHandler<WebConfigToRoleTypeMapping>",
                entityRowHandler);
        assertObjectNotNull("entityType", entityType);
        assertSpecifyDerivedReferrerEntityProperty(cb, entityType);
        delegateSelectCursor(cb, entityRowHandler, entityType);
    }

    // ===================================================================================
    //                                                                       Entity Select
    //                                                                       =============
    /**
     * Select the entity by the condition-bean.
     * <pre>
     * WebConfigToRoleTypeMappingCB cb = new WebConfigToRoleTypeMappingCB();
     * cb.query().setFoo...(value);
     * WebConfigToRoleTypeMapping webConfigToRoleTypeMapping = webConfigToRoleTypeMappingBhv.<span style="color: #FD4747">selectEntity</span>(cb);
     * if (webConfigToRoleTypeMapping != null) {
     *     ... = webConfigToRoleTypeMapping.get...();
     * } else {
     *     ...
     * }
     * </pre>
     * @param cb The condition-bean of WebConfigToRoleTypeMapping. (NotNull)
     * @return The selected entity. (NullAllowed: If the condition has no data, it returns null)
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.SelectEntityConditionNotFoundException When the condition for selecting an entity is not found.
     */
    public WebConfigToRoleTypeMapping selectEntity(
            final WebConfigToRoleTypeMappingCB cb) {
        return doSelectEntity(cb, WebConfigToRoleTypeMapping.class);
    }

    protected <ENTITY extends WebConfigToRoleTypeMapping> ENTITY doSelectEntity(
            final WebConfigToRoleTypeMappingCB cb,
            final Class<ENTITY> entityType) {
        assertCBStateValid(cb);
        return helpSelectEntityInternally(
                cb,
                new InternalSelectEntityCallback<ENTITY, WebConfigToRoleTypeMappingCB>() {
                    @Override
                    public List<ENTITY> callbackSelectList(
                            final WebConfigToRoleTypeMappingCB cb) {
                        return doSelectList(cb, entityType);
                    }
                });
    }

    @Override
    protected Entity doReadEntity(final ConditionBean cb) {
        return selectEntity(downcast(cb));
    }

    /**
     * Select the entity by the condition-bean with deleted check.
     * <pre>
     * WebConfigToRoleTypeMappingCB cb = new WebConfigToRoleTypeMappingCB();
     * cb.query().setFoo...(value);
     * WebConfigToRoleTypeMapping webConfigToRoleTypeMapping = webConfigToRoleTypeMappingBhv.<span style="color: #FD4747">selectEntityWithDeletedCheck</span>(cb);
     * ... = webConfigToRoleTypeMapping.get...(); <span style="color: #3F7E5E">// the entity always be not null</span>
     * </pre>
     * @param cb The condition-bean of WebConfigToRoleTypeMapping. (NotNull)
     * @return The selected entity. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.SelectEntityConditionNotFoundException When the condition for selecting an entity is not found.
     */
    public WebConfigToRoleTypeMapping selectEntityWithDeletedCheck(
            final WebConfigToRoleTypeMappingCB cb) {
        return doSelectEntityWithDeletedCheck(cb,
                WebConfigToRoleTypeMapping.class);
    }

    protected <ENTITY extends WebConfigToRoleTypeMapping> ENTITY doSelectEntityWithDeletedCheck(
            final WebConfigToRoleTypeMappingCB cb,
            final Class<ENTITY> entityType) {
        assertCBStateValid(cb);
        return helpSelectEntityWithDeletedCheckInternally(
                cb,
                new InternalSelectEntityWithDeletedCheckCallback<ENTITY, WebConfigToRoleTypeMappingCB>() {
                    @Override
                    public List<ENTITY> callbackSelectList(
                            final WebConfigToRoleTypeMappingCB cb) {
                        return doSelectList(cb, entityType);
                    }
                });
    }

    @Override
    protected Entity doReadEntityWithDeletedCheck(final ConditionBean cb) {
        return selectEntityWithDeletedCheck(downcast(cb));
    }

    /**
     * Select the entity by the primary-key value.
     * @param id The one of primary key. (NotNull)
     * @return The selected entity. (NullAllowed: If the primary-key value has no data, it returns null)
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.SelectEntityConditionNotFoundException When the condition for selecting an entity is not found.
     */
    public WebConfigToRoleTypeMapping selectByPKValue(final Long id) {
        return doSelectByPKValue(id, WebConfigToRoleTypeMapping.class);
    }

    protected <ENTITY extends WebConfigToRoleTypeMapping> ENTITY doSelectByPKValue(
            final Long id, final Class<ENTITY> entityType) {
        return doSelectEntity(buildPKCB(id), entityType);
    }

    /**
     * Select the entity by the primary-key value with deleted check.
     * @param id The one of primary key. (NotNull)
     * @return The selected entity. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.SelectEntityConditionNotFoundException When the condition for selecting an entity is not found.
     */
    public WebConfigToRoleTypeMapping selectByPKValueWithDeletedCheck(
            final Long id) {
        return doSelectByPKValueWithDeletedCheck(id,
                WebConfigToRoleTypeMapping.class);
    }

    protected <ENTITY extends WebConfigToRoleTypeMapping> ENTITY doSelectByPKValueWithDeletedCheck(
            final Long id, final Class<ENTITY> entityType) {
        return doSelectEntityWithDeletedCheck(buildPKCB(id), entityType);
    }

    private WebConfigToRoleTypeMappingCB buildPKCB(final Long id) {
        assertObjectNotNull("id", id);
        final WebConfigToRoleTypeMappingCB cb = newMyConditionBean();
        cb.query().setId_Equal(id);
        return cb;
    }

    // ===================================================================================
    //                                                                         List Select
    //                                                                         ===========
    /**
     * Select the list as result bean.
     * <pre>
     * WebConfigToRoleTypeMappingCB cb = new WebConfigToRoleTypeMappingCB();
     * cb.query().setFoo...(value);
     * cb.query().addOrderBy_Bar...();
     * ListResultBean&lt;WebConfigToRoleTypeMapping&gt; webConfigToRoleTypeMappingList = webConfigToRoleTypeMappingBhv.<span style="color: #FD4747">selectList</span>(cb);
     * for (WebConfigToRoleTypeMapping webConfigToRoleTypeMapping : webConfigToRoleTypeMappingList) {
     *     ... = webConfigToRoleTypeMapping.get...();
     * }
     * </pre>
     * @param cb The condition-bean of WebConfigToRoleTypeMapping. (NotNull)
     * @return The result bean of selected list. (NotNull)
     * @exception org.seasar.dbflute.exception.DangerousResultSizeException When the result size is over the specified safety size.
     */
    public ListResultBean<WebConfigToRoleTypeMapping> selectList(
            final WebConfigToRoleTypeMappingCB cb) {
        return doSelectList(cb, WebConfigToRoleTypeMapping.class);
    }

    protected <ENTITY extends WebConfigToRoleTypeMapping> ListResultBean<ENTITY> doSelectList(
            final WebConfigToRoleTypeMappingCB cb,
            final Class<ENTITY> entityType) {
        assertCBStateValid(cb);
        assertObjectNotNull("entityType", entityType);
        assertSpecifyDerivedReferrerEntityProperty(cb, entityType);
        return helpSelectListInternally(
                cb,
                entityType,
                new InternalSelectListCallback<ENTITY, WebConfigToRoleTypeMappingCB>() {
                    @Override
                    public List<ENTITY> callbackSelectList(
                            final WebConfigToRoleTypeMappingCB cb,
                            final Class<ENTITY> entityType) {
                        return delegateSelectList(cb, entityType);
                    }
                });
    }

    @Override
    protected ListResultBean<? extends Entity> doReadList(final ConditionBean cb) {
        return selectList(downcast(cb));
    }

    // ===================================================================================
    //                                                                         Page Select
    //                                                                         ===========
    /**
     * Select the page as result bean. <br />
     * (both count-select and paging-select are executed)
     * <pre>
     * WebConfigToRoleTypeMappingCB cb = new WebConfigToRoleTypeMappingCB();
     * cb.query().setFoo...(value);
     * cb.query().addOrderBy_Bar...();
     * cb.<span style="color: #FD4747">paging</span>(20, 3); <span style="color: #3F7E5E">// 20 records per a page and current page number is 3</span>
     * PagingResultBean&lt;WebConfigToRoleTypeMapping&gt; page = webConfigToRoleTypeMappingBhv.<span style="color: #FD4747">selectPage</span>(cb);
     * int allRecordCount = page.getAllRecordCount();
     * int allPageCount = page.getAllPageCount();
     * boolean isExistPrePage = page.isExistPrePage();
     * boolean isExistNextPage = page.isExistNextPage();
     * ...
     * for (WebConfigToRoleTypeMapping webConfigToRoleTypeMapping : page) {
     *     ... = webConfigToRoleTypeMapping.get...();
     * }
     * </pre>
     * @param cb The condition-bean of WebConfigToRoleTypeMapping. (NotNull)
     * @return The result bean of selected page. (NotNull)
     * @exception org.seasar.dbflute.exception.DangerousResultSizeException When the result size is over the specified safety size.
     */
    public PagingResultBean<WebConfigToRoleTypeMapping> selectPage(
            final WebConfigToRoleTypeMappingCB cb) {
        return doSelectPage(cb, WebConfigToRoleTypeMapping.class);
    }

    protected <ENTITY extends WebConfigToRoleTypeMapping> PagingResultBean<ENTITY> doSelectPage(
            final WebConfigToRoleTypeMappingCB cb,
            final Class<ENTITY> entityType) {
        assertCBStateValid(cb);
        assertObjectNotNull("entityType", entityType);
        return helpSelectPageInternally(
                cb,
                entityType,
                new InternalSelectPageCallback<ENTITY, WebConfigToRoleTypeMappingCB>() {
                    @Override
                    public int callbackSelectCount(
                            final WebConfigToRoleTypeMappingCB cb) {
                        return doSelectCountPlainly(cb);
                    }

                    @Override
                    public List<ENTITY> callbackSelectList(
                            final WebConfigToRoleTypeMappingCB cb,
                            final Class<ENTITY> entityType) {
                        return doSelectList(cb, entityType);
                    }
                });
    }

    @Override
    protected PagingResultBean<? extends Entity> doReadPage(
            final ConditionBean cb) {
        return selectPage(downcast(cb));
    }

    // ===================================================================================
    //                                                                       Scalar Select
    //                                                                       =============
    /**
     * Select the scalar value derived by a function from uniquely-selected records. <br />
     * You should call a function method after this method called like as follows:
     * <pre>
     * webConfigToRoleTypeMappingBhv.<span style="color: #FD4747">scalarSelect</span>(Date.class).max(new ScalarQuery() {
     *     public void query(WebConfigToRoleTypeMappingCB cb) {
     *         cb.specify().<span style="color: #FD4747">columnFooDatetime()</span>; <span style="color: #3F7E5E">// required for a function</span>
     *         cb.query().setBarName_PrefixSearch("S");
     *     }
     * });
     * </pre>
     * @param <RESULT> The type of result.
     * @param resultType The type of result. (NotNull)
     * @return The scalar value derived by a function. (NullAllowed)
     */
    public <RESULT> SLFunction<WebConfigToRoleTypeMappingCB, RESULT> scalarSelect(
            final Class<RESULT> resultType) {
        return doScalarSelect(resultType, newMyConditionBean());
    }

    protected <RESULT, CB extends WebConfigToRoleTypeMappingCB> SLFunction<CB, RESULT> doScalarSelect(
            final Class<RESULT> resultType, final CB cb) {
        assertObjectNotNull("resultType", resultType);
        assertCBStateValid(cb);
        cb.xsetupForScalarSelect();
        cb.getSqlClause().disableSelectIndex(); // for when you use union
        return new SLFunction<CB, RESULT>(cb, resultType);
    }

    // ===================================================================================
    //                                                                            Sequence
    //                                                                            ========
    @Override
    protected Number doReadNextVal() {
        final String msg = "This table is NOT related to sequence: "
                + getTableDbName();
        throw new UnsupportedOperationException(msg);
    }

    // ===================================================================================
    //                                                                    Pull out Foreign
    //                                                                    ================
    /**
     * Pull out the list of foreign table 'WebCrawlingConfig'.
     * @param webConfigToRoleTypeMappingList The list of webConfigToRoleTypeMapping. (NotNull)
     * @return The list of foreign table. (NotNull)
     */
    public List<WebCrawlingConfig> pulloutWebCrawlingConfig(
            final List<WebConfigToRoleTypeMapping> webConfigToRoleTypeMappingList) {
        return helpPulloutInternally(
                webConfigToRoleTypeMappingList,
                new InternalPulloutCallback<WebConfigToRoleTypeMapping, WebCrawlingConfig>() {
                    @Override
                    public WebCrawlingConfig getFr(
                            final WebConfigToRoleTypeMapping e) {
                        return e.getWebCrawlingConfig();
                    }

                    @Override
                    public boolean hasRf() {
                        return true;
                    }

                    @Override
                    public void setRfLs(final WebCrawlingConfig e,
                            final List<WebConfigToRoleTypeMapping> ls) {
                        e.setWebConfigToRoleTypeMappingList(ls);
                    }
                });
    }

    /**
     * Pull out the list of foreign table 'RoleType'.
     * @param webConfigToRoleTypeMappingList The list of webConfigToRoleTypeMapping. (NotNull)
     * @return The list of foreign table. (NotNull)
     */
    public List<RoleType> pulloutRoleType(
            final List<WebConfigToRoleTypeMapping> webConfigToRoleTypeMappingList) {
        return helpPulloutInternally(
                webConfigToRoleTypeMappingList,
                new InternalPulloutCallback<WebConfigToRoleTypeMapping, RoleType>() {
                    @Override
                    public RoleType getFr(final WebConfigToRoleTypeMapping e) {
                        return e.getRoleType();
                    }

                    @Override
                    public boolean hasRf() {
                        return true;
                    }

                    @Override
                    public void setRfLs(final RoleType e,
                            final List<WebConfigToRoleTypeMapping> ls) {
                        e.setWebConfigToRoleTypeMappingList(ls);
                    }
                });
    }

    // ===================================================================================
    //                                                                       Entity Update
    //                                                                       =============
    /**
     * Insert the entity.
     * <pre>
     * WebConfigToRoleTypeMapping webConfigToRoleTypeMapping = new WebConfigToRoleTypeMapping();
     * <span style="color: #3F7E5E">// if auto-increment, you don't need to set the PK value</span>
     * webConfigToRoleTypeMapping.setFoo...(value);
     * webConfigToRoleTypeMapping.setBar...(value);
     * <span style="color: #3F7E5E">// you don't need to set values of common columns</span>
     * <span style="color: #3F7E5E">//webConfigToRoleTypeMapping.setRegisterUser(value);</span>
     * <span style="color: #3F7E5E">//webConfigToRoleTypeMapping.set...;</span>
     * webConfigToRoleTypeMappingBhv.<span style="color: #FD4747">insert</span>(webConfigToRoleTypeMapping);
     * ... = webConfigToRoleTypeMapping.getPK...(); <span style="color: #3F7E5E">// if auto-increment, you can get the value after</span>
     * </pre>
     * @param webConfigToRoleTypeMapping The entity of insert target. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void insert(
            final WebConfigToRoleTypeMapping webConfigToRoleTypeMapping) {
        doInsert(webConfigToRoleTypeMapping, null);
    }

    protected void doInsert(
            final WebConfigToRoleTypeMapping webConfigToRoleTypeMapping,
            final InsertOption<WebConfigToRoleTypeMappingCB> option) {
        assertObjectNotNull("webConfigToRoleTypeMapping",
                webConfigToRoleTypeMapping);
        prepareInsertOption(option);
        delegateInsert(webConfigToRoleTypeMapping, option);
    }

    protected void prepareInsertOption(
            final InsertOption<WebConfigToRoleTypeMappingCB> option) {
        if (option == null) {
            return;
        }
        assertInsertOptionStatus(option);
    }

    @Override
    protected void doCreate(final Entity entity,
            final InsertOption<? extends ConditionBean> option) {
        if (option == null) {
            insert(downcast(entity));
        } else {
            varyingInsert(downcast(entity), downcast(option));
        }
    }

    /**
     * Update the entity modified-only. {UpdateCountZeroException, ExclusiveControl}
     * <pre>
     * WebConfigToRoleTypeMapping webConfigToRoleTypeMapping = new WebConfigToRoleTypeMapping();
     * webConfigToRoleTypeMapping.setPK...(value); <span style="color: #3F7E5E">// required</span>
     * webConfigToRoleTypeMapping.setFoo...(value); <span style="color: #3F7E5E">// you should set only modified columns</span>
     * <span style="color: #3F7E5E">// you don't need to set values of common columns</span>
     * <span style="color: #3F7E5E">//webConfigToRoleTypeMapping.setRegisterUser(value);</span>
     * <span style="color: #3F7E5E">//webConfigToRoleTypeMapping.set...;</span>
     * <span style="color: #3F7E5E">// if exclusive control, the value of exclusive control column is required</span>
     * webConfigToRoleTypeMapping.<span style="color: #FD4747">setVersionNo</span>(value);
     * try {
     *     webConfigToRoleTypeMappingBhv.<span style="color: #FD4747">update</span>(webConfigToRoleTypeMapping);
     * } catch (EntityAlreadyUpdatedException e) { <span style="color: #3F7E5E">// if concurrent update</span>
     *     ...
     * } 
     * </pre>
     * @param webConfigToRoleTypeMapping The entity of update target. (NotNull) {PrimaryKeyRequired, ConcurrencyColumnRequired}
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void update(
            final WebConfigToRoleTypeMapping webConfigToRoleTypeMapping) {
        doUpdate(webConfigToRoleTypeMapping, null);
    }

    protected void doUpdate(
            final WebConfigToRoleTypeMapping webConfigToRoleTypeMapping,
            final UpdateOption<WebConfigToRoleTypeMappingCB> option) {
        assertObjectNotNull("webConfigToRoleTypeMapping",
                webConfigToRoleTypeMapping);
        prepareUpdateOption(option);
        helpUpdateInternally(webConfigToRoleTypeMapping,
                new InternalUpdateCallback<WebConfigToRoleTypeMapping>() {
                    @Override
                    public int callbackDelegateUpdate(
                            final WebConfigToRoleTypeMapping entity) {
                        return delegateUpdate(entity, option);
                    }
                });
    }

    protected void prepareUpdateOption(
            final UpdateOption<WebConfigToRoleTypeMappingCB> option) {
        if (option == null) {
            return;
        }
        assertUpdateOptionStatus(option);
        if (option.hasSelfSpecification()) {
            option.resolveSelfSpecification(createCBForVaryingUpdate());
        }
        if (option.hasSpecifiedUpdateColumn()) {
            option.resolveUpdateColumnSpecification(createCBForSpecifiedUpdate());
        }
    }

    protected WebConfigToRoleTypeMappingCB createCBForVaryingUpdate() {
        final WebConfigToRoleTypeMappingCB cb = newMyConditionBean();
        cb.xsetupForVaryingUpdate();
        return cb;
    }

    protected WebConfigToRoleTypeMappingCB createCBForSpecifiedUpdate() {
        final WebConfigToRoleTypeMappingCB cb = newMyConditionBean();
        cb.xsetupForSpecifiedUpdate();
        return cb;
    }

    @Override
    protected void doModify(final Entity entity,
            final UpdateOption<? extends ConditionBean> option) {
        if (option == null) {
            update(downcast(entity));
        } else {
            varyingUpdate(downcast(entity), downcast(option));
        }
    }

    @Override
    protected void doModifyNonstrict(final Entity entity,
            final UpdateOption<? extends ConditionBean> option) {
        doModify(entity, option);
    }

    /**
     * Insert or update the entity modified-only. {ExclusiveControl(when update)}
     * @param webConfigToRoleTypeMapping The entity of insert or update target. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void insertOrUpdate(
            final WebConfigToRoleTypeMapping webConfigToRoleTypeMapping) {
        doInesrtOrUpdate(webConfigToRoleTypeMapping, null, null);
    }

    protected void doInesrtOrUpdate(
            final WebConfigToRoleTypeMapping webConfigToRoleTypeMapping,
            final InsertOption<WebConfigToRoleTypeMappingCB> insertOption,
            final UpdateOption<WebConfigToRoleTypeMappingCB> updateOption) {
        helpInsertOrUpdateInternally(
                webConfigToRoleTypeMapping,
                new InternalInsertOrUpdateCallback<WebConfigToRoleTypeMapping, WebConfigToRoleTypeMappingCB>() {
                    @Override
                    public void callbackInsert(
                            final WebConfigToRoleTypeMapping entity) {
                        doInsert(entity, insertOption);
                    }

                    @Override
                    public void callbackUpdate(
                            final WebConfigToRoleTypeMapping entity) {
                        doUpdate(entity, updateOption);
                    }

                    @Override
                    public WebConfigToRoleTypeMappingCB callbackNewMyConditionBean() {
                        return newMyConditionBean();
                    }

                    @Override
                    public int callbackSelectCount(
                            final WebConfigToRoleTypeMappingCB cb) {
                        return selectCount(cb);
                    }
                });
    }

    @Override
    protected void doCreateOrModify(final Entity entity,
            InsertOption<? extends ConditionBean> insertOption,
            UpdateOption<? extends ConditionBean> updateOption) {
        if (insertOption == null && updateOption == null) {
            insertOrUpdate(downcast(entity));
        } else {
            insertOption = insertOption == null ? new InsertOption<WebConfigToRoleTypeMappingCB>()
                    : insertOption;
            updateOption = updateOption == null ? new UpdateOption<WebConfigToRoleTypeMappingCB>()
                    : updateOption;
            varyingInsertOrUpdate(downcast(entity), downcast(insertOption),
                    downcast(updateOption));
        }
    }

    @Override
    protected void doCreateOrModifyNonstrict(final Entity entity,
            final InsertOption<? extends ConditionBean> insertOption,
            final UpdateOption<? extends ConditionBean> updateOption) {
        doCreateOrModify(entity, insertOption, updateOption);
    }

    /**
     * Delete the entity. {UpdateCountZeroException, ExclusiveControl}
     * <pre>
     * WebConfigToRoleTypeMapping webConfigToRoleTypeMapping = new WebConfigToRoleTypeMapping();
     * webConfigToRoleTypeMapping.setPK...(value); <span style="color: #3F7E5E">// required</span>
     * <span style="color: #3F7E5E">// if exclusive control, the value of exclusive control column is required</span>
     * webConfigToRoleTypeMapping.<span style="color: #FD4747">setVersionNo</span>(value);
     * try {
     *     webConfigToRoleTypeMappingBhv.<span style="color: #FD4747">delete</span>(webConfigToRoleTypeMapping);
     * } catch (EntityAlreadyUpdatedException e) { <span style="color: #3F7E5E">// if concurrent update</span>
     *     ...
     * } 
     * </pre>
     * @param webConfigToRoleTypeMapping The entity of delete target. (NotNull) {PrimaryKeyRequired, ConcurrencyColumnRequired}
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     */
    public void delete(
            final WebConfigToRoleTypeMapping webConfigToRoleTypeMapping) {
        doDelete(webConfigToRoleTypeMapping, null);
    }

    protected void doDelete(
            final WebConfigToRoleTypeMapping webConfigToRoleTypeMapping,
            final DeleteOption<WebConfigToRoleTypeMappingCB> option) {
        assertObjectNotNull("webConfigToRoleTypeMapping",
                webConfigToRoleTypeMapping);
        prepareDeleteOption(option);
        helpDeleteInternally(webConfigToRoleTypeMapping,
                new InternalDeleteCallback<WebConfigToRoleTypeMapping>() {
                    @Override
                    public int callbackDelegateDelete(
                            final WebConfigToRoleTypeMapping entity) {
                        return delegateDelete(entity, option);
                    }
                });
    }

    protected void prepareDeleteOption(
            final DeleteOption<WebConfigToRoleTypeMappingCB> option) {
        if (option == null) {
            return;
        }
        assertDeleteOptionStatus(option);
    }

    @Override
    protected void doRemove(final Entity entity,
            final DeleteOption<? extends ConditionBean> option) {
        if (option == null) {
            delete(downcast(entity));
        } else {
            varyingDelete(downcast(entity), downcast(option));
        }
    }

    @Override
    protected void doRemoveNonstrict(final Entity entity,
            final DeleteOption<? extends ConditionBean> option) {
        doRemove(entity, option);
    }

    // ===================================================================================
    //                                                                        Batch Update
    //                                                                        ============
    /**
     * Batch-insert the list. <br />
     * This method uses 'Batch Update' of java.sql.PreparedStatement. <br />
     * All columns are insert target. (so default constraints are not available) <br />
     * And if the table has an identity, entities after the process do not have incremented values.
     * (When you use the (normal) insert(), an entity after the process has an incremented value)
     * @param webConfigToRoleTypeMappingList The list of the entity. (NotNull)
     * @return The array of inserted count.
     */
    public int[] batchInsert(
            final List<WebConfigToRoleTypeMapping> webConfigToRoleTypeMappingList) {
        return doBatchInsert(webConfigToRoleTypeMappingList, null);
    }

    protected int[] doBatchInsert(
            final List<WebConfigToRoleTypeMapping> webConfigToRoleTypeMappingList,
            final InsertOption<WebConfigToRoleTypeMappingCB> option) {
        assertObjectNotNull("webConfigToRoleTypeMappingList",
                webConfigToRoleTypeMappingList);
        prepareInsertOption(option);
        return delegateBatchInsert(webConfigToRoleTypeMappingList, option);
    }

    @Override
    protected int[] doLumpCreate(final List<Entity> ls,
            final InsertOption<? extends ConditionBean> option) {
        if (option == null) {
            return batchInsert(downcast(ls));
        } else {
            return varyingBatchInsert(downcast(ls), downcast(option));
        }
    }

    /**
     * Batch-update the list. <br />
     * This method uses 'Batch Update' of java.sql.PreparedStatement. <br />
     * All columns are update target. {NOT modified only}
     * @param webConfigToRoleTypeMappingList The list of the entity. (NotNull)
     * @return The array of updated count.
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     */
    public int[] batchUpdate(
            final List<WebConfigToRoleTypeMapping> webConfigToRoleTypeMappingList) {
        return doBatchUpdate(webConfigToRoleTypeMappingList, null);
    }

    protected int[] doBatchUpdate(
            final List<WebConfigToRoleTypeMapping> webConfigToRoleTypeMappingList,
            final UpdateOption<WebConfigToRoleTypeMappingCB> option) {
        assertObjectNotNull("webConfigToRoleTypeMappingList",
                webConfigToRoleTypeMappingList);
        prepareUpdateOption(option);
        return delegateBatchUpdate(webConfigToRoleTypeMappingList, option);
    }

    @Override
    protected int[] doLumpModify(final List<Entity> ls,
            final UpdateOption<? extends ConditionBean> option) {
        if (option == null) {
            return batchUpdate(downcast(ls));
        } else {
            return varyingBatchUpdate(downcast(ls), downcast(option));
        }
    }

    /**
     * Batch-update the list. <br />
     * This method uses 'Batch Update' of java.sql.PreparedStatement. <br />
     * You can specify update columns used on set clause of update statement.
     * However you do not need to specify common columns for update
     * and an optimistick lock column because they are specified implicitly.
     * @param webConfigToRoleTypeMappingList The list of the entity. (NotNull)
     * @param updateColumnSpec The specification of update columns. (NotNull)
     * @return The array of updated count.
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     */
    public int[] batchUpdate(
            final List<WebConfigToRoleTypeMapping> webConfigToRoleTypeMappingList,
            final SpecifyQuery<WebConfigToRoleTypeMappingCB> updateColumnSpec) {
        return doBatchUpdate(webConfigToRoleTypeMappingList,
                createSpecifiedUpdateOption(updateColumnSpec));
    }

    @Override
    protected int[] doLumpModifyNonstrict(final List<Entity> ls,
            final UpdateOption<? extends ConditionBean> option) {
        return doLumpModify(ls, option);
    }

    /**
     * Batch-delete the list. <br />
     * This method uses 'Batch Update' of java.sql.PreparedStatement.
     * @param webConfigToRoleTypeMappingList The list of the entity. (NotNull)
     * @return The array of deleted count.
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     */
    public int[] batchDelete(
            final List<WebConfigToRoleTypeMapping> webConfigToRoleTypeMappingList) {
        return doBatchDelete(webConfigToRoleTypeMappingList, null);
    }

    protected int[] doBatchDelete(
            final List<WebConfigToRoleTypeMapping> webConfigToRoleTypeMappingList,
            final DeleteOption<WebConfigToRoleTypeMappingCB> option) {
        assertObjectNotNull("webConfigToRoleTypeMappingList",
                webConfigToRoleTypeMappingList);
        prepareDeleteOption(option);
        return delegateBatchDelete(webConfigToRoleTypeMappingList, option);
    }

    @Override
    protected int[] doLumpRemove(final List<Entity> ls,
            final DeleteOption<? extends ConditionBean> option) {
        if (option == null) {
            return batchDelete(downcast(ls));
        } else {
            return varyingBatchDelete(downcast(ls), downcast(option));
        }
    }

    @Override
    protected int[] doLumpRemoveNonstrict(final List<Entity> ls,
            final DeleteOption<? extends ConditionBean> option) {
        return doLumpRemove(ls, option);
    }

    // ===================================================================================
    //                                                                        Query Update
    //                                                                        ============
    /**
     * Insert the several entities by query (modified-only for fixed value).
     * <pre>
     * webConfigToRoleTypeMappingBhv.<span style="color: #FD4747">queryInsert</span>(new QueryInsertSetupper&lt;WebConfigToRoleTypeMapping, WebConfigToRoleTypeMappingCB&gt;() {
     *     public ConditionBean setup(webConfigToRoleTypeMapping entity, WebConfigToRoleTypeMappingCB intoCB) {
     *         FooCB cb = FooCB();
     *         cb.setupSelect_Bar();
     * 
     *         <span style="color: #3F7E5E">// mapping</span>
     *         intoCB.specify().columnMyName().mappedFrom(cb.specify().columnFooName());
     *         intoCB.specify().columnMyCount().mappedFrom(cb.specify().columnFooCount());
     *         intoCB.specify().columnMyDate().mappedFrom(cb.specify().specifyBar().columnBarDate());
     *         entity.setMyFixedValue("foo"); <span style="color: #3F7E5E">// fixed value</span>
     *         <span style="color: #3F7E5E">// you don't need to set values of common columns</span>
     *         <span style="color: #3F7E5E">//entity.setRegisterUser(value);</span>
     *         <span style="color: #3F7E5E">//entity.set...;</span>
     *         <span style="color: #3F7E5E">// you don't need to set a value of exclusive control column</span>
     *         <span style="color: #3F7E5E">//entity.setVersionNo(value);</span>
     * 
     *         return cb;
     *     }
     * });
     * </pre>
     * @param setupper The setup-per of query-insert. (NotNull)
     * @return The inserted count.
     */
    public int queryInsert(
            final QueryInsertSetupper<WebConfigToRoleTypeMapping, WebConfigToRoleTypeMappingCB> setupper) {
        return doQueryInsert(setupper, null);
    }

    protected int doQueryInsert(
            final QueryInsertSetupper<WebConfigToRoleTypeMapping, WebConfigToRoleTypeMappingCB> setupper,
            final InsertOption<WebConfigToRoleTypeMappingCB> option) {
        assertObjectNotNull("setupper", setupper);
        prepareInsertOption(option);
        final WebConfigToRoleTypeMapping entity = new WebConfigToRoleTypeMapping();
        final WebConfigToRoleTypeMappingCB intoCB = createCBForQueryInsert();
        final ConditionBean resourceCB = setupper.setup(entity, intoCB);
        return delegateQueryInsert(entity, intoCB, resourceCB, option);
    }

    protected WebConfigToRoleTypeMappingCB createCBForQueryInsert() {
        final WebConfigToRoleTypeMappingCB cb = newMyConditionBean();
        cb.xsetupForQueryInsert();
        return cb;
    }

    @Override
    protected int doRangeCreate(
            final QueryInsertSetupper<? extends Entity, ? extends ConditionBean> setupper,
            final InsertOption<? extends ConditionBean> option) {
        if (option == null) {
            return queryInsert(downcast(setupper));
        } else {
            return varyingQueryInsert(downcast(setupper), downcast(option));
        }
    }

    /**
     * Update the several entities by query non-strictly modified-only. {NonExclusiveControl}
     * <pre>
     * WebConfigToRoleTypeMapping webConfigToRoleTypeMapping = new WebConfigToRoleTypeMapping();
     * <span style="color: #3F7E5E">// you don't need to set PK value</span>
     * <span style="color: #3F7E5E">//webConfigToRoleTypeMapping.setPK...(value);</span>
     * webConfigToRoleTypeMapping.setFoo...(value); <span style="color: #3F7E5E">// you should set only modified columns</span>
     * <span style="color: #3F7E5E">// you don't need to set values of common columns</span>
     * <span style="color: #3F7E5E">//webConfigToRoleTypeMapping.setRegisterUser(value);</span>
     * <span style="color: #3F7E5E">//webConfigToRoleTypeMapping.set...;</span>
     * <span style="color: #3F7E5E">// you don't need to set a value of exclusive control column</span>
     * <span style="color: #3F7E5E">// (auto-increment for version number is valid though non-exclusive control)</span>
     * <span style="color: #3F7E5E">//webConfigToRoleTypeMapping.setVersionNo(value);</span>
     * WebConfigToRoleTypeMappingCB cb = new WebConfigToRoleTypeMappingCB();
     * cb.query().setFoo...(value);
     * webConfigToRoleTypeMappingBhv.<span style="color: #FD4747">queryUpdate</span>(webConfigToRoleTypeMapping, cb);
     * </pre>
     * @param webConfigToRoleTypeMapping The entity that contains update values. (NotNull, PrimaryKeyNullAllowed)
     * @param cb The condition-bean of WebConfigToRoleTypeMapping. (NotNull)
     * @return The updated count.
     * @exception org.seasar.dbflute.exception.NonQueryUpdateNotAllowedException When the query has no condition.
     */
    public int queryUpdate(
            final WebConfigToRoleTypeMapping webConfigToRoleTypeMapping,
            final WebConfigToRoleTypeMappingCB cb) {
        return doQueryUpdate(webConfigToRoleTypeMapping, cb, null);
    }

    protected int doQueryUpdate(
            final WebConfigToRoleTypeMapping webConfigToRoleTypeMapping,
            final WebConfigToRoleTypeMappingCB cb,
            final UpdateOption<WebConfigToRoleTypeMappingCB> option) {
        assertObjectNotNull("webConfigToRoleTypeMapping",
                webConfigToRoleTypeMapping);
        assertCBStateValid(cb);
        prepareUpdateOption(option);
        return delegateQueryUpdate(webConfigToRoleTypeMapping, cb, option);
    }

    @Override
    protected int doRangeModify(final Entity entity, final ConditionBean cb,
            final UpdateOption<? extends ConditionBean> option) {
        if (option == null) {
            return queryUpdate(downcast(entity),
                    (WebConfigToRoleTypeMappingCB) cb);
        } else {
            return varyingQueryUpdate(downcast(entity),
                    (WebConfigToRoleTypeMappingCB) cb, downcast(option));
        }
    }

    /**
     * Delete the several entities by query. {NonExclusiveControl}
     * <pre>
     * WebConfigToRoleTypeMappingCB cb = new WebConfigToRoleTypeMappingCB();
     * cb.query().setFoo...(value);
     * webConfigToRoleTypeMappingBhv.<span style="color: #FD4747">queryDelete</span>(webConfigToRoleTypeMapping, cb);
     * </pre>
     * @param cb The condition-bean of WebConfigToRoleTypeMapping. (NotNull)
     * @return The deleted count.
     * @exception org.seasar.dbflute.exception.NonQueryDeleteNotAllowedException When the query has no condition.
     */
    public int queryDelete(final WebConfigToRoleTypeMappingCB cb) {
        return doQueryDelete(cb, null);
    }

    protected int doQueryDelete(final WebConfigToRoleTypeMappingCB cb,
            final DeleteOption<WebConfigToRoleTypeMappingCB> option) {
        assertCBStateValid(cb);
        prepareDeleteOption(option);
        return delegateQueryDelete(cb, option);
    }

    @Override
    protected int doRangeRemove(final ConditionBean cb,
            final DeleteOption<? extends ConditionBean> option) {
        if (option == null) {
            return queryDelete((WebConfigToRoleTypeMappingCB) cb);
        } else {
            return varyingQueryDelete((WebConfigToRoleTypeMappingCB) cb,
                    downcast(option));
        }
    }

    // ===================================================================================
    //                                                                      Varying Update
    //                                                                      ==============
    // -----------------------------------------------------
    //                                         Entity Update
    //                                         -------------
    /**
     * Insert the entity with varying requests. <br />
     * For example, disableCommonColumnAutoSetup(), disablePrimaryKeyIdentity(). <br />
     * Other specifications are same as insert(entity).
     * <pre>
     * WebConfigToRoleTypeMapping webConfigToRoleTypeMapping = new WebConfigToRoleTypeMapping();
     * <span style="color: #3F7E5E">// if auto-increment, you don't need to set the PK value</span>
     * webConfigToRoleTypeMapping.setFoo...(value);
     * webConfigToRoleTypeMapping.setBar...(value);
     * InsertOption<WebConfigToRoleTypeMappingCB> option = new InsertOption<WebConfigToRoleTypeMappingCB>();
     * <span style="color: #3F7E5E">// you can insert by your values for common columns</span>
     * option.disableCommonColumnAutoSetup();
     * webConfigToRoleTypeMappingBhv.<span style="color: #FD4747">varyingInsert</span>(webConfigToRoleTypeMapping, option);
     * ... = webConfigToRoleTypeMapping.getPK...(); <span style="color: #3F7E5E">// if auto-increment, you can get the value after</span>
     * </pre>
     * @param webConfigToRoleTypeMapping The entity of insert target. (NotNull)
     * @param option The option of insert for varying requests. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void varyingInsert(
            final WebConfigToRoleTypeMapping webConfigToRoleTypeMapping,
            final InsertOption<WebConfigToRoleTypeMappingCB> option) {
        assertInsertOptionNotNull(option);
        doInsert(webConfigToRoleTypeMapping, option);
    }

    /**
     * Update the entity with varying requests modified-only. {UpdateCountZeroException, ExclusiveControl} <br />
     * For example, self(selfCalculationSpecification), specify(updateColumnSpecification), disableCommonColumnAutoSetup(). <br />
     * Other specifications are same as update(entity).
     * <pre>
     * WebConfigToRoleTypeMapping webConfigToRoleTypeMapping = new WebConfigToRoleTypeMapping();
     * webConfigToRoleTypeMapping.setPK...(value); <span style="color: #3F7E5E">// required</span>
     * webConfigToRoleTypeMapping.setOther...(value); <span style="color: #3F7E5E">// you should set only modified columns</span>
     * <span style="color: #3F7E5E">// if exclusive control, the value of exclusive control column is required</span>
     * webConfigToRoleTypeMapping.<span style="color: #FD4747">setVersionNo</span>(value);
     * try {
     *     <span style="color: #3F7E5E">// you can update by self calculation values</span>
     *     UpdateOption&lt;WebConfigToRoleTypeMappingCB&gt; option = new UpdateOption&lt;WebConfigToRoleTypeMappingCB&gt;();
     *     option.self(new SpecifyQuery&lt;WebConfigToRoleTypeMappingCB&gt;() {
     *         public void specify(WebConfigToRoleTypeMappingCB cb) {
     *             cb.specify().<span style="color: #FD4747">columnXxxCount()</span>;
     *         }
     *     }).plus(1); <span style="color: #3F7E5E">// XXX_COUNT = XXX_COUNT + 1</span>
     *     webConfigToRoleTypeMappingBhv.<span style="color: #FD4747">varyingUpdate</span>(webConfigToRoleTypeMapping, option);
     * } catch (EntityAlreadyUpdatedException e) { <span style="color: #3F7E5E">// if concurrent update</span>
     *     ...
     * }
     * </pre>
     * @param webConfigToRoleTypeMapping The entity of update target. (NotNull) {PrimaryKeyRequired, ConcurrencyColumnRequired}
     * @param option The option of update for varying requests. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void varyingUpdate(
            final WebConfigToRoleTypeMapping webConfigToRoleTypeMapping,
            final UpdateOption<WebConfigToRoleTypeMappingCB> option) {
        assertUpdateOptionNotNull(option);
        doUpdate(webConfigToRoleTypeMapping, option);
    }

    /**
     * Insert or update the entity with varying requests. {ExclusiveControl(when update)}<br />
     * Other specifications are same as insertOrUpdate(entity).
     * @param webConfigToRoleTypeMapping The entity of insert or update target. (NotNull)
     * @param insertOption The option of insert for varying requests. (NotNull)
     * @param updateOption The option of update for varying requests. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void varyingInsertOrUpdate(
            final WebConfigToRoleTypeMapping webConfigToRoleTypeMapping,
            final InsertOption<WebConfigToRoleTypeMappingCB> insertOption,
            final UpdateOption<WebConfigToRoleTypeMappingCB> updateOption) {
        assertInsertOptionNotNull(insertOption);
        assertUpdateOptionNotNull(updateOption);
        doInesrtOrUpdate(webConfigToRoleTypeMapping, insertOption, updateOption);
    }

    /**
     * Delete the entity with varying requests. {UpdateCountZeroException, ExclusiveControl} <br />
     * Now a valid option does not exist. <br />
     * Other specifications are same as delete(entity).
     * @param webConfigToRoleTypeMapping The entity of delete target. (NotNull) {PrimaryKeyRequired, ConcurrencyColumnRequired}
     * @param option The option of update for varying requests. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     */
    public void varyingDelete(
            final WebConfigToRoleTypeMapping webConfigToRoleTypeMapping,
            final DeleteOption<WebConfigToRoleTypeMappingCB> option) {
        assertDeleteOptionNotNull(option);
        doDelete(webConfigToRoleTypeMapping, option);
    }

    // -----------------------------------------------------
    //                                          Batch Update
    //                                          ------------
    /**
     * Batch-insert the list with varying requests. <br />
     * For example, disableCommonColumnAutoSetup()
     * , disablePrimaryKeyIdentity(), limitBatchInsertLogging(). <br />
     * Other specifications are same as batchInsert(entityList).
     * @param webConfigToRoleTypeMappingList The list of the entity. (NotNull)
     * @param option The option of insert for varying requests. (NotNull)
     * @return The array of inserted count.
     */
    public int[] varyingBatchInsert(
            final List<WebConfigToRoleTypeMapping> webConfigToRoleTypeMappingList,
            final InsertOption<WebConfigToRoleTypeMappingCB> option) {
        assertInsertOptionNotNull(option);
        return doBatchInsert(webConfigToRoleTypeMappingList, option);
    }

    /**
     * Batch-update the list with varying requests. <br />
     * For example, self(selfCalculationSpecification), specify(updateColumnSpecification)
     * , disableCommonColumnAutoSetup(), limitBatchUpdateLogging(). <br />
     * Other specifications are same as batchUpdate(entityList).
     * @param webConfigToRoleTypeMappingList The list of the entity. (NotNull)
     * @param option The option of update for varying requests. (NotNull)
     * @return The array of updated count.
     */
    public int[] varyingBatchUpdate(
            final List<WebConfigToRoleTypeMapping> webConfigToRoleTypeMappingList,
            final UpdateOption<WebConfigToRoleTypeMappingCB> option) {
        assertUpdateOptionNotNull(option);
        return doBatchUpdate(webConfigToRoleTypeMappingList, option);
    }

    /**
     * Batch-delete the list with varying requests. <br />
     * For example, limitBatchDeleteLogging(). <br />
     * Other specifications are same as batchDelete(entityList).
     * @param webConfigToRoleTypeMappingList The list of the entity. (NotNull)
     * @param option The option of delete for varying requests. (NotNull)
     * @return The array of deleted count.
     */
    public int[] varyingBatchDelete(
            final List<WebConfigToRoleTypeMapping> webConfigToRoleTypeMappingList,
            final DeleteOption<WebConfigToRoleTypeMappingCB> option) {
        assertDeleteOptionNotNull(option);
        return doBatchDelete(webConfigToRoleTypeMappingList, option);
    }

    // -----------------------------------------------------
    //                                          Query Update
    //                                          ------------
    /**
     * Insert the several entities by query with varying requests (modified-only for fixed value). <br />
     * For example, disableCommonColumnAutoSetup(), disablePrimaryKeyIdentity(). <br />
     * Other specifications are same as queryInsert(entity, setupper). 
     * @param setupper The setup-per of query-insert. (NotNull)
     * @param option The option of insert for varying requests. (NotNull)
     * @return The inserted count.
     */
    public int varyingQueryInsert(
            final QueryInsertSetupper<WebConfigToRoleTypeMapping, WebConfigToRoleTypeMappingCB> setupper,
            final InsertOption<WebConfigToRoleTypeMappingCB> option) {
        assertInsertOptionNotNull(option);
        return doQueryInsert(setupper, option);
    }

    /**
     * Update the several entities by query with varying requests non-strictly modified-only. {NonExclusiveControl} <br />
     * For example, self(selfCalculationSpecification), specify(updateColumnSpecification)
     * , disableCommonColumnAutoSetup(), allowNonQueryUpdate(). <br />
     * Other specifications are same as queryUpdate(entity, cb). 
     * <pre>
     * <span style="color: #3F7E5E">// ex) you can update by self calculation values</span>
     * WebConfigToRoleTypeMapping webConfigToRoleTypeMapping = new WebConfigToRoleTypeMapping();
     * <span style="color: #3F7E5E">// you don't need to set PK value</span>
     * <span style="color: #3F7E5E">//webConfigToRoleTypeMapping.setPK...(value);</span>
     * webConfigToRoleTypeMapping.setOther...(value); <span style="color: #3F7E5E">// you should set only modified columns</span>
     * <span style="color: #3F7E5E">// you don't need to set a value of exclusive control column</span>
     * <span style="color: #3F7E5E">// (auto-increment for version number is valid though non-exclusive control)</span>
     * <span style="color: #3F7E5E">//webConfigToRoleTypeMapping.setVersionNo(value);</span>
     * WebConfigToRoleTypeMappingCB cb = new WebConfigToRoleTypeMappingCB();
     * cb.query().setFoo...(value);
     * UpdateOption&lt;WebConfigToRoleTypeMappingCB&gt; option = new UpdateOption&lt;WebConfigToRoleTypeMappingCB&gt;();
     * option.self(new SpecifyQuery&lt;WebConfigToRoleTypeMappingCB&gt;() {
     *     public void specify(WebConfigToRoleTypeMappingCB cb) {
     *         cb.specify().<span style="color: #FD4747">columnFooCount()</span>;
     *     }
     * }).plus(1); <span style="color: #3F7E5E">// FOO_COUNT = FOO_COUNT + 1</span>
     * webConfigToRoleTypeMappingBhv.<span style="color: #FD4747">varyingQueryUpdate</span>(webConfigToRoleTypeMapping, cb, option);
     * </pre>
     * @param webConfigToRoleTypeMapping The entity that contains update values. (NotNull) {PrimaryKeyNotRequired}
     * @param cb The condition-bean of WebConfigToRoleTypeMapping. (NotNull)
     * @param option The option of update for varying requests. (NotNull)
     * @return The updated count.
     * @exception org.seasar.dbflute.exception.NonQueryUpdateNotAllowedException When the query has no condition (if not allowed).
     */
    public int varyingQueryUpdate(
            final WebConfigToRoleTypeMapping webConfigToRoleTypeMapping,
            final WebConfigToRoleTypeMappingCB cb,
            final UpdateOption<WebConfigToRoleTypeMappingCB> option) {
        assertUpdateOptionNotNull(option);
        return doQueryUpdate(webConfigToRoleTypeMapping, cb, option);
    }

    /**
     * Delete the several entities by query with varying requests non-strictly. <br />
     * For example, allowNonQueryDelete(). <br />
     * Other specifications are same as batchUpdateNonstrict(entityList).
     * @param cb The condition-bean of WebConfigToRoleTypeMapping. (NotNull)
     * @param option The option of delete for varying requests. (NotNull)
     * @return The deleted count.
     * @exception org.seasar.dbflute.exception.NonQueryDeleteNotAllowedException When the query has no condition (if not allowed).
     */
    public int varyingQueryDelete(final WebConfigToRoleTypeMappingCB cb,
            final DeleteOption<WebConfigToRoleTypeMappingCB> option) {
        assertDeleteOptionNotNull(option);
        return doQueryDelete(cb, option);
    }

    // ===================================================================================
    //                                                                          OutsideSql
    //                                                                          ==========
    /**
     * Prepare the basic executor of outside-SQL to execute it. <br />
     * The invoker of behavior command should be not null when you call this method.
     * <pre>
     * You can use the methods for outside-SQL are as follows:
     * {Basic}
     *   o selectList()
     *   o execute()
     *   o call()
     * 
     * {Entity}
     *   o entityHandling().selectEntity()
     *   o entityHandling().selectEntityWithDeletedCheck()
     * 
     * {Paging}
     *   o autoPaging().selectList()
     *   o autoPaging().selectPage()
     *   o manualPaging().selectList()
     *   o manualPaging().selectPage()
     * 
     * {Cursor}
     *   o cursorHandling().selectCursor()
     * 
     * {Option}
     *   o dynamicBinding().selectList()
     *   o removeBlockComment().selectList()
     *   o removeLineComment().selectList()
     *   o formatSql().selectList()
     * </pre>
     * @return The basic executor of outside-SQL. (NotNull) 
     */
    public OutsideSqlBasicExecutor<WebConfigToRoleTypeMappingBhv> outsideSql() {
        return doOutsideSql();
    }

    // ===================================================================================
    //                                                                     Delegate Method
    //                                                                     ===============
    // [Behavior Command]
    // -----------------------------------------------------
    //                                                Select
    //                                                ------
    protected int delegateSelectCountUniquely(
            final WebConfigToRoleTypeMappingCB cb) {
        return invoke(createSelectCountCBCommand(cb, true));
    }

    protected int delegateSelectCountPlainly(
            final WebConfigToRoleTypeMappingCB cb) {
        return invoke(createSelectCountCBCommand(cb, false));
    }

    protected <ENTITY extends WebConfigToRoleTypeMapping> void delegateSelectCursor(
            final WebConfigToRoleTypeMappingCB cb,
            final EntityRowHandler<ENTITY> erh, final Class<ENTITY> et) {
        invoke(createSelectCursorCBCommand(cb, erh, et));
    }

    protected <ENTITY extends WebConfigToRoleTypeMapping> List<ENTITY> delegateSelectList(
            final WebConfigToRoleTypeMappingCB cb, final Class<ENTITY> et) {
        return invoke(createSelectListCBCommand(cb, et));
    }

    // -----------------------------------------------------
    //                                                Update
    //                                                ------
    protected int delegateInsert(final WebConfigToRoleTypeMapping e,
            final InsertOption<WebConfigToRoleTypeMappingCB> op) {
        if (!processBeforeInsert(e, op)) {
            return 0;
        }
        return invoke(createInsertEntityCommand(e, op));
    }

    protected int delegateUpdate(final WebConfigToRoleTypeMapping e,
            final UpdateOption<WebConfigToRoleTypeMappingCB> op) {
        if (!processBeforeUpdate(e, op)) {
            return 0;
        }
        return delegateUpdateNonstrict(e, op);
    }

    protected int delegateUpdateNonstrict(final WebConfigToRoleTypeMapping e,
            final UpdateOption<WebConfigToRoleTypeMappingCB> op) {
        if (!processBeforeUpdate(e, op)) {
            return 0;
        }
        return invoke(createUpdateNonstrictEntityCommand(e, op));
    }

    protected int delegateDelete(final WebConfigToRoleTypeMapping e,
            final DeleteOption<WebConfigToRoleTypeMappingCB> op) {
        if (!processBeforeDelete(e, op)) {
            return 0;
        }
        return delegateDeleteNonstrict(e, op);
    }

    protected int delegateDeleteNonstrict(final WebConfigToRoleTypeMapping e,
            final DeleteOption<WebConfigToRoleTypeMappingCB> op) {
        if (!processBeforeDelete(e, op)) {
            return 0;
        }
        return invoke(createDeleteNonstrictEntityCommand(e, op));
    }

    protected int[] delegateBatchInsert(
            final List<WebConfigToRoleTypeMapping> ls,
            final InsertOption<WebConfigToRoleTypeMappingCB> op) {
        if (ls.isEmpty()) {
            return new int[] {};
        }
        return invoke(createBatchInsertCommand(processBatchInternally(ls, op),
                op));
    }

    protected int[] delegateBatchUpdate(
            final List<WebConfigToRoleTypeMapping> ls,
            final UpdateOption<WebConfigToRoleTypeMappingCB> op) {
        if (ls.isEmpty()) {
            return new int[] {};
        }
        return delegateBatchUpdateNonstrict(ls, op);
    }

    protected int[] delegateBatchUpdateNonstrict(
            final List<WebConfigToRoleTypeMapping> ls,
            final UpdateOption<WebConfigToRoleTypeMappingCB> op) {
        if (ls.isEmpty()) {
            return new int[] {};
        }
        return invoke(createBatchUpdateNonstrictCommand(
                processBatchInternally(ls, op, true), op));
    }

    protected int[] delegateBatchDelete(
            final List<WebConfigToRoleTypeMapping> ls,
            final DeleteOption<WebConfigToRoleTypeMappingCB> op) {
        if (ls.isEmpty()) {
            return new int[] {};
        }
        return delegateBatchDeleteNonstrict(ls, op);
    }

    protected int[] delegateBatchDeleteNonstrict(
            final List<WebConfigToRoleTypeMapping> ls,
            final DeleteOption<WebConfigToRoleTypeMappingCB> op) {
        if (ls.isEmpty()) {
            return new int[] {};
        }
        return invoke(createBatchDeleteNonstrictCommand(
                processBatchInternally(ls, op, true), op));
    }

    protected int delegateQueryInsert(final WebConfigToRoleTypeMapping e,
            final WebConfigToRoleTypeMappingCB inCB, final ConditionBean resCB,
            final InsertOption<WebConfigToRoleTypeMappingCB> op) {
        if (!processBeforeQueryInsert(e, inCB, resCB, op)) {
            return 0;
        }
        return invoke(createQueryInsertCBCommand(e, inCB, resCB, op));
    }

    protected int delegateQueryUpdate(final WebConfigToRoleTypeMapping e,
            final WebConfigToRoleTypeMappingCB cb,
            final UpdateOption<WebConfigToRoleTypeMappingCB> op) {
        if (!processBeforeQueryUpdate(e, cb, op)) {
            return 0;
        }
        return invoke(createQueryUpdateCBCommand(e, cb, op));
    }

    protected int delegateQueryDelete(final WebConfigToRoleTypeMappingCB cb,
            final DeleteOption<WebConfigToRoleTypeMappingCB> op) {
        if (!processBeforeQueryDelete(cb, op)) {
            return 0;
        }
        return invoke(createQueryDeleteCBCommand(cb, op));
    }

    // ===================================================================================
    //                                                                Optimistic Lock Info
    //                                                                ====================
    /**
     * {@inheritDoc}
     */
    @Override
    protected boolean hasVersionNoValue(final Entity entity) {
        return false;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    protected boolean hasUpdateDateValue(final Entity entity) {
        return false;
    }

    // ===================================================================================
    //                                                                     Downcast Helper
    //                                                                     ===============
    protected WebConfigToRoleTypeMapping downcast(final Entity entity) {
        return helpEntityDowncastInternally(entity,
                WebConfigToRoleTypeMapping.class);
    }

    protected WebConfigToRoleTypeMappingCB downcast(final ConditionBean cb) {
        return helpConditionBeanDowncastInternally(cb,
                WebConfigToRoleTypeMappingCB.class);
    }

    @SuppressWarnings("unchecked")
    protected List<WebConfigToRoleTypeMapping> downcast(
            final List<? extends Entity> entityList) {
        return (List<WebConfigToRoleTypeMapping>) entityList;
    }

    @SuppressWarnings("unchecked")
    protected InsertOption<WebConfigToRoleTypeMappingCB> downcast(
            final InsertOption<? extends ConditionBean> option) {
        return (InsertOption<WebConfigToRoleTypeMappingCB>) option;
    }

    @SuppressWarnings("unchecked")
    protected UpdateOption<WebConfigToRoleTypeMappingCB> downcast(
            final UpdateOption<? extends ConditionBean> option) {
        return (UpdateOption<WebConfigToRoleTypeMappingCB>) option;
    }

    @SuppressWarnings("unchecked")
    protected DeleteOption<WebConfigToRoleTypeMappingCB> downcast(
            final DeleteOption<? extends ConditionBean> option) {
        return (DeleteOption<WebConfigToRoleTypeMappingCB>) option;
    }

    @SuppressWarnings("unchecked")
    protected QueryInsertSetupper<WebConfigToRoleTypeMapping, WebConfigToRoleTypeMappingCB> downcast(
            final QueryInsertSetupper<? extends Entity, ? extends ConditionBean> option) {
        return (QueryInsertSetupper<WebConfigToRoleTypeMapping, WebConfigToRoleTypeMappingCB>) option;
    }
}
