/*
 * Copyright 2009-2012 the Fess Project and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */

package jp.sf.fess.db.bsbhv;

import java.util.List;

import jp.sf.fess.db.bsentity.dbmeta.FailureUrlDbm;
import jp.sf.fess.db.cbean.FailureUrlCB;
import jp.sf.fess.db.exbhv.FailureUrlBhv;
import jp.sf.fess.db.exentity.FailureUrl;
import jp.sf.fess.db.exentity.FileCrawlingConfig;
import jp.sf.fess.db.exentity.WebCrawlingConfig;

import org.seasar.dbflute.Entity;
import org.seasar.dbflute.bhv.AbstractBehaviorWritable;
import org.seasar.dbflute.bhv.DeleteOption;
import org.seasar.dbflute.bhv.InsertOption;
import org.seasar.dbflute.bhv.QueryInsertSetupper;
import org.seasar.dbflute.bhv.UpdateOption;
import org.seasar.dbflute.cbean.ConditionBean;
import org.seasar.dbflute.cbean.EntityRowHandler;
import org.seasar.dbflute.cbean.ListResultBean;
import org.seasar.dbflute.cbean.PagingResultBean;
import org.seasar.dbflute.cbean.SpecifyQuery;
import org.seasar.dbflute.dbmeta.DBMeta;
import org.seasar.dbflute.outsidesql.executor.OutsideSqlBasicExecutor;

/**
 * The behavior of FAILURE_URL as TABLE. <br />
 * <pre>
 * [primary key]
 *     ID
 * 
 * [column]
 *     ID, URL, THREAD_NAME, ERROR_NAME, ERROR_LOG, ERROR_COUNT, LAST_ACCESS_TIME, WEB_CONFIG_ID, FILE_CONFIG_ID
 * 
 * [sequence]
 *     
 * 
 * [identity]
 *     ID
 * 
 * [version-no]
 *     
 * 
 * [foreign table]
 *     FILE_CRAWLING_CONFIG, WEB_CRAWLING_CONFIG
 * 
 * [referrer table]
 *     
 * 
 * [foreign property]
 *     fileCrawlingConfig, webCrawlingConfig
 * 
 * [referrer property]
 *     
 * </pre>
 * @author DBFlute(AutoGenerator)
 */
public abstract class BsFailureUrlBhv extends AbstractBehaviorWritable {

    // ===================================================================================
    //                                                                          Definition
    //                                                                          ==========
    /*df:beginQueryPath*/
    /*df:endQueryPath*/

    // ===================================================================================
    //                                                                          Table name
    //                                                                          ==========
    /** @return The name on database of table. (NotNull) */
    @Override
    public String getTableDbName() {
        return "FAILURE_URL";
    }

    // ===================================================================================
    //                                                                              DBMeta
    //                                                                              ======
    /** @return The instance of DBMeta. (NotNull) */
    @Override
    public DBMeta getDBMeta() {
        return FailureUrlDbm.getInstance();
    }

    /** @return The instance of DBMeta as my table type. (NotNull) */
    public FailureUrlDbm getMyDBMeta() {
        return FailureUrlDbm.getInstance();
    }

    // ===================================================================================
    //                                                                        New Instance
    //                                                                        ============
    /** {@inheritDoc} */
    @Override
    public Entity newEntity() {
        return newMyEntity();
    }

    /** {@inheritDoc} */
    @Override
    public ConditionBean newConditionBean() {
        return newMyConditionBean();
    }

    /** @return The instance of new entity as my table type. (NotNull) */
    public FailureUrl newMyEntity() {
        return new FailureUrl();
    }

    /** @return The instance of new condition-bean as my table type. (NotNull) */
    public FailureUrlCB newMyConditionBean() {
        return new FailureUrlCB();
    }

    // ===================================================================================
    //                                                                        Count Select
    //                                                                        ============
    /**
     * Select the count of uniquely-selected records by the condition-bean. {IgnorePagingCondition, IgnoreSpecifyColumn}<br />
     * SpecifyColumn is ignored but you can use it only to remove text type column for union's distinct.
     * <pre>
     * FailureUrlCB cb = new FailureUrlCB();
     * cb.query().setFoo...(value);
     * int count = failureUrlBhv.<span style="color: #FD4747">selectCount</span>(cb);
     * </pre>
     * @param cb The condition-bean of FailureUrl. (NotNull)
     * @return The selected count.
     */
    public int selectCount(final FailureUrlCB cb) {
        return doSelectCountUniquely(cb);
    }

    protected int doSelectCountUniquely(final FailureUrlCB cb) { // called by selectCount(cb) 
        assertCBStateValid(cb);
        return delegateSelectCountUniquely(cb);
    }

    protected int doSelectCountPlainly(final FailureUrlCB cb) { // called by selectPage(cb)
        assertCBStateValid(cb);
        return delegateSelectCountPlainly(cb);
    }

    @Override
    protected int doReadCount(final ConditionBean cb) {
        return selectCount(downcast(cb));
    }

    // ===================================================================================
    //                                                                       Cursor Select
    //                                                                       =============
    /**
     * Select the cursor by the condition-bean.
     * <pre>
     * FailureUrlCB cb = new FailureUrlCB();
     * cb.query().setFoo...(value);
     * failureUrlBhv.<span style="color: #FD4747">selectCursor</span>(cb, new EntityRowHandler&lt;FailureUrl&gt;() {
     *     public void handle(FailureUrl entity) {
     *         ... = entity.getFoo...();
     *     }
     * });
     * </pre>
     * @param cb The condition-bean of FailureUrl. (NotNull)
     * @param entityRowHandler The handler of entity row of FailureUrl. (NotNull)
     */
    public void selectCursor(final FailureUrlCB cb,
            final EntityRowHandler<FailureUrl> entityRowHandler) {
        doSelectCursor(cb, entityRowHandler, FailureUrl.class);
    }

    protected <ENTITY extends FailureUrl> void doSelectCursor(
            final FailureUrlCB cb,
            final EntityRowHandler<ENTITY> entityRowHandler,
            final Class<ENTITY> entityType) {
        assertCBStateValid(cb);
        assertObjectNotNull("entityRowHandler<FailureUrl>", entityRowHandler);
        assertObjectNotNull("entityType", entityType);
        assertSpecifyDerivedReferrerEntityProperty(cb, entityType);
        delegateSelectCursor(cb, entityRowHandler, entityType);
    }

    // ===================================================================================
    //                                                                       Entity Select
    //                                                                       =============
    /**
     * Select the entity by the condition-bean.
     * <pre>
     * FailureUrlCB cb = new FailureUrlCB();
     * cb.query().setFoo...(value);
     * FailureUrl failureUrl = failureUrlBhv.<span style="color: #FD4747">selectEntity</span>(cb);
     * if (failureUrl != null) {
     *     ... = failureUrl.get...();
     * } else {
     *     ...
     * }
     * </pre>
     * @param cb The condition-bean of FailureUrl. (NotNull)
     * @return The selected entity. (NullAllowed: If the condition has no data, it returns null)
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.SelectEntityConditionNotFoundException When the condition for selecting an entity is not found.
     */
    public FailureUrl selectEntity(final FailureUrlCB cb) {
        return doSelectEntity(cb, FailureUrl.class);
    }

    protected <ENTITY extends FailureUrl> ENTITY doSelectEntity(
            final FailureUrlCB cb, final Class<ENTITY> entityType) {
        assertCBStateValid(cb);
        return helpSelectEntityInternally(cb,
                new InternalSelectEntityCallback<ENTITY, FailureUrlCB>() {
                    @Override
                    public List<ENTITY> callbackSelectList(final FailureUrlCB cb) {
                        return doSelectList(cb, entityType);
                    }
                });
    }

    @Override
    protected Entity doReadEntity(final ConditionBean cb) {
        return selectEntity(downcast(cb));
    }

    /**
     * Select the entity by the condition-bean with deleted check.
     * <pre>
     * FailureUrlCB cb = new FailureUrlCB();
     * cb.query().setFoo...(value);
     * FailureUrl failureUrl = failureUrlBhv.<span style="color: #FD4747">selectEntityWithDeletedCheck</span>(cb);
     * ... = failureUrl.get...(); <span style="color: #3F7E5E">// the entity always be not null</span>
     * </pre>
     * @param cb The condition-bean of FailureUrl. (NotNull)
     * @return The selected entity. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.SelectEntityConditionNotFoundException When the condition for selecting an entity is not found.
     */
    public FailureUrl selectEntityWithDeletedCheck(final FailureUrlCB cb) {
        return doSelectEntityWithDeletedCheck(cb, FailureUrl.class);
    }

    protected <ENTITY extends FailureUrl> ENTITY doSelectEntityWithDeletedCheck(
            final FailureUrlCB cb, final Class<ENTITY> entityType) {
        assertCBStateValid(cb);
        return helpSelectEntityWithDeletedCheckInternally(
                cb,
                new InternalSelectEntityWithDeletedCheckCallback<ENTITY, FailureUrlCB>() {
                    @Override
                    public List<ENTITY> callbackSelectList(final FailureUrlCB cb) {
                        return doSelectList(cb, entityType);
                    }
                });
    }

    @Override
    protected Entity doReadEntityWithDeletedCheck(final ConditionBean cb) {
        return selectEntityWithDeletedCheck(downcast(cb));
    }

    /**
     * Select the entity by the primary-key value.
     * @param id The one of primary key. (NotNull)
     * @return The selected entity. (NullAllowed: If the primary-key value has no data, it returns null)
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.SelectEntityConditionNotFoundException When the condition for selecting an entity is not found.
     */
    public FailureUrl selectByPKValue(final Long id) {
        return doSelectByPKValue(id, FailureUrl.class);
    }

    protected <ENTITY extends FailureUrl> ENTITY doSelectByPKValue(
            final Long id, final Class<ENTITY> entityType) {
        return doSelectEntity(buildPKCB(id), entityType);
    }

    /**
     * Select the entity by the primary-key value with deleted check.
     * @param id The one of primary key. (NotNull)
     * @return The selected entity. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.SelectEntityConditionNotFoundException When the condition for selecting an entity is not found.
     */
    public FailureUrl selectByPKValueWithDeletedCheck(final Long id) {
        return doSelectByPKValueWithDeletedCheck(id, FailureUrl.class);
    }

    protected <ENTITY extends FailureUrl> ENTITY doSelectByPKValueWithDeletedCheck(
            final Long id, final Class<ENTITY> entityType) {
        return doSelectEntityWithDeletedCheck(buildPKCB(id), entityType);
    }

    private FailureUrlCB buildPKCB(final Long id) {
        assertObjectNotNull("id", id);
        final FailureUrlCB cb = newMyConditionBean();
        cb.query().setId_Equal(id);
        return cb;
    }

    // ===================================================================================
    //                                                                         List Select
    //                                                                         ===========
    /**
     * Select the list as result bean.
     * <pre>
     * FailureUrlCB cb = new FailureUrlCB();
     * cb.query().setFoo...(value);
     * cb.query().addOrderBy_Bar...();
     * ListResultBean&lt;FailureUrl&gt; failureUrlList = failureUrlBhv.<span style="color: #FD4747">selectList</span>(cb);
     * for (FailureUrl failureUrl : failureUrlList) {
     *     ... = failureUrl.get...();
     * }
     * </pre>
     * @param cb The condition-bean of FailureUrl. (NotNull)
     * @return The result bean of selected list. (NotNull)
     * @exception org.seasar.dbflute.exception.DangerousResultSizeException When the result size is over the specified safety size.
     */
    public ListResultBean<FailureUrl> selectList(final FailureUrlCB cb) {
        return doSelectList(cb, FailureUrl.class);
    }

    protected <ENTITY extends FailureUrl> ListResultBean<ENTITY> doSelectList(
            final FailureUrlCB cb, final Class<ENTITY> entityType) {
        assertCBStateValid(cb);
        assertObjectNotNull("entityType", entityType);
        assertSpecifyDerivedReferrerEntityProperty(cb, entityType);
        return helpSelectListInternally(cb, entityType,
                new InternalSelectListCallback<ENTITY, FailureUrlCB>() {
                    @Override
                    public List<ENTITY> callbackSelectList(
                            final FailureUrlCB cb,
                            final Class<ENTITY> entityType) {
                        return delegateSelectList(cb, entityType);
                    }
                });
    }

    @Override
    protected ListResultBean<? extends Entity> doReadList(final ConditionBean cb) {
        return selectList(downcast(cb));
    }

    // ===================================================================================
    //                                                                         Page Select
    //                                                                         ===========
    /**
     * Select the page as result bean. <br />
     * (both count-select and paging-select are executed)
     * <pre>
     * FailureUrlCB cb = new FailureUrlCB();
     * cb.query().setFoo...(value);
     * cb.query().addOrderBy_Bar...();
     * cb.<span style="color: #FD4747">paging</span>(20, 3); <span style="color: #3F7E5E">// 20 records per a page and current page number is 3</span>
     * PagingResultBean&lt;FailureUrl&gt; page = failureUrlBhv.<span style="color: #FD4747">selectPage</span>(cb);
     * int allRecordCount = page.getAllRecordCount();
     * int allPageCount = page.getAllPageCount();
     * boolean isExistPrePage = page.isExistPrePage();
     * boolean isExistNextPage = page.isExistNextPage();
     * ...
     * for (FailureUrl failureUrl : page) {
     *     ... = failureUrl.get...();
     * }
     * </pre>
     * @param cb The condition-bean of FailureUrl. (NotNull)
     * @return The result bean of selected page. (NotNull)
     * @exception org.seasar.dbflute.exception.DangerousResultSizeException When the result size is over the specified safety size.
     */
    public PagingResultBean<FailureUrl> selectPage(final FailureUrlCB cb) {
        return doSelectPage(cb, FailureUrl.class);
    }

    protected <ENTITY extends FailureUrl> PagingResultBean<ENTITY> doSelectPage(
            final FailureUrlCB cb, final Class<ENTITY> entityType) {
        assertCBStateValid(cb);
        assertObjectNotNull("entityType", entityType);
        return helpSelectPageInternally(cb, entityType,
                new InternalSelectPageCallback<ENTITY, FailureUrlCB>() {
                    @Override
                    public int callbackSelectCount(final FailureUrlCB cb) {
                        return doSelectCountPlainly(cb);
                    }

                    @Override
                    public List<ENTITY> callbackSelectList(
                            final FailureUrlCB cb,
                            final Class<ENTITY> entityType) {
                        return doSelectList(cb, entityType);
                    }
                });
    }

    @Override
    protected PagingResultBean<? extends Entity> doReadPage(
            final ConditionBean cb) {
        return selectPage(downcast(cb));
    }

    // ===================================================================================
    //                                                                       Scalar Select
    //                                                                       =============
    /**
     * Select the scalar value derived by a function from uniquely-selected records. <br />
     * You should call a function method after this method called like as follows:
     * <pre>
     * failureUrlBhv.<span style="color: #FD4747">scalarSelect</span>(Date.class).max(new ScalarQuery() {
     *     public void query(FailureUrlCB cb) {
     *         cb.specify().<span style="color: #FD4747">columnFooDatetime()</span>; <span style="color: #3F7E5E">// required for a function</span>
     *         cb.query().setBarName_PrefixSearch("S");
     *     }
     * });
     * </pre>
     * @param <RESULT> The type of result.
     * @param resultType The type of result. (NotNull)
     * @return The scalar value derived by a function. (NullAllowed)
     */
    public <RESULT> SLFunction<FailureUrlCB, RESULT> scalarSelect(
            final Class<RESULT> resultType) {
        return doScalarSelect(resultType, newMyConditionBean());
    }

    protected <RESULT, CB extends FailureUrlCB> SLFunction<CB, RESULT> doScalarSelect(
            final Class<RESULT> resultType, final CB cb) {
        assertObjectNotNull("resultType", resultType);
        assertCBStateValid(cb);
        cb.xsetupForScalarSelect();
        cb.getSqlClause().disableSelectIndex(); // for when you use union
        return new SLFunction<CB, RESULT>(cb, resultType);
    }

    // ===================================================================================
    //                                                                            Sequence
    //                                                                            ========
    @Override
    protected Number doReadNextVal() {
        final String msg = "This table is NOT related to sequence: "
                + getTableDbName();
        throw new UnsupportedOperationException(msg);
    }

    // ===================================================================================
    //                                                                    Pull out Foreign
    //                                                                    ================
    /**
     * Pull out the list of foreign table 'FileCrawlingConfig'.
     * @param failureUrlList The list of failureUrl. (NotNull)
     * @return The list of foreign table. (NotNull)
     */
    public List<FileCrawlingConfig> pulloutFileCrawlingConfig(
            final List<FailureUrl> failureUrlList) {
        return helpPulloutInternally(failureUrlList,
                new InternalPulloutCallback<FailureUrl, FileCrawlingConfig>() {
                    @Override
                    public FileCrawlingConfig getFr(final FailureUrl e) {
                        return e.getFileCrawlingConfig();
                    }

                    @Override
                    public boolean hasRf() {
                        return true;
                    }

                    @Override
                    public void setRfLs(final FileCrawlingConfig e,
                            final List<FailureUrl> ls) {
                        e.setFailureUrlList(ls);
                    }
                });
    }

    /**
     * Pull out the list of foreign table 'WebCrawlingConfig'.
     * @param failureUrlList The list of failureUrl. (NotNull)
     * @return The list of foreign table. (NotNull)
     */
    public List<WebCrawlingConfig> pulloutWebCrawlingConfig(
            final List<FailureUrl> failureUrlList) {
        return helpPulloutInternally(failureUrlList,
                new InternalPulloutCallback<FailureUrl, WebCrawlingConfig>() {
                    @Override
                    public WebCrawlingConfig getFr(final FailureUrl e) {
                        return e.getWebCrawlingConfig();
                    }

                    @Override
                    public boolean hasRf() {
                        return true;
                    }

                    @Override
                    public void setRfLs(final WebCrawlingConfig e,
                            final List<FailureUrl> ls) {
                        e.setFailureUrlList(ls);
                    }
                });
    }

    // ===================================================================================
    //                                                                       Entity Update
    //                                                                       =============
    /**
     * Insert the entity.
     * <pre>
     * FailureUrl failureUrl = new FailureUrl();
     * <span style="color: #3F7E5E">// if auto-increment, you don't need to set the PK value</span>
     * failureUrl.setFoo...(value);
     * failureUrl.setBar...(value);
     * <span style="color: #3F7E5E">// you don't need to set values of common columns</span>
     * <span style="color: #3F7E5E">//failureUrl.setRegisterUser(value);</span>
     * <span style="color: #3F7E5E">//failureUrl.set...;</span>
     * failureUrlBhv.<span style="color: #FD4747">insert</span>(failureUrl);
     * ... = failureUrl.getPK...(); <span style="color: #3F7E5E">// if auto-increment, you can get the value after</span>
     * </pre>
     * @param failureUrl The entity of insert target. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void insert(final FailureUrl failureUrl) {
        doInsert(failureUrl, null);
    }

    protected void doInsert(final FailureUrl failureUrl,
            final InsertOption<FailureUrlCB> option) {
        assertObjectNotNull("failureUrl", failureUrl);
        prepareInsertOption(option);
        delegateInsert(failureUrl, option);
    }

    protected void prepareInsertOption(final InsertOption<FailureUrlCB> option) {
        if (option == null) {
            return;
        }
        assertInsertOptionStatus(option);
    }

    @Override
    protected void doCreate(final Entity entity,
            final InsertOption<? extends ConditionBean> option) {
        if (option == null) {
            insert(downcast(entity));
        } else {
            varyingInsert(downcast(entity), downcast(option));
        }
    }

    /**
     * Update the entity modified-only. {UpdateCountZeroException, ExclusiveControl}
     * <pre>
     * FailureUrl failureUrl = new FailureUrl();
     * failureUrl.setPK...(value); <span style="color: #3F7E5E">// required</span>
     * failureUrl.setFoo...(value); <span style="color: #3F7E5E">// you should set only modified columns</span>
     * <span style="color: #3F7E5E">// you don't need to set values of common columns</span>
     * <span style="color: #3F7E5E">//failureUrl.setRegisterUser(value);</span>
     * <span style="color: #3F7E5E">//failureUrl.set...;</span>
     * <span style="color: #3F7E5E">// if exclusive control, the value of exclusive control column is required</span>
     * failureUrl.<span style="color: #FD4747">setVersionNo</span>(value);
     * try {
     *     failureUrlBhv.<span style="color: #FD4747">update</span>(failureUrl);
     * } catch (EntityAlreadyUpdatedException e) { <span style="color: #3F7E5E">// if concurrent update</span>
     *     ...
     * } 
     * </pre>
     * @param failureUrl The entity of update target. (NotNull) {PrimaryKeyRequired, ConcurrencyColumnRequired}
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void update(final FailureUrl failureUrl) {
        doUpdate(failureUrl, null);
    }

    protected void doUpdate(final FailureUrl failureUrl,
            final UpdateOption<FailureUrlCB> option) {
        assertObjectNotNull("failureUrl", failureUrl);
        prepareUpdateOption(option);
        helpUpdateInternally(failureUrl,
                new InternalUpdateCallback<FailureUrl>() {
                    @Override
                    public int callbackDelegateUpdate(final FailureUrl entity) {
                        return delegateUpdate(entity, option);
                    }
                });
    }

    protected void prepareUpdateOption(final UpdateOption<FailureUrlCB> option) {
        if (option == null) {
            return;
        }
        assertUpdateOptionStatus(option);
        if (option.hasSelfSpecification()) {
            option.resolveSelfSpecification(createCBForVaryingUpdate());
        }
        if (option.hasSpecifiedUpdateColumn()) {
            option.resolveUpdateColumnSpecification(createCBForSpecifiedUpdate());
        }
    }

    protected FailureUrlCB createCBForVaryingUpdate() {
        final FailureUrlCB cb = newMyConditionBean();
        cb.xsetupForVaryingUpdate();
        return cb;
    }

    protected FailureUrlCB createCBForSpecifiedUpdate() {
        final FailureUrlCB cb = newMyConditionBean();
        cb.xsetupForSpecifiedUpdate();
        return cb;
    }

    @Override
    protected void doModify(final Entity entity,
            final UpdateOption<? extends ConditionBean> option) {
        if (option == null) {
            update(downcast(entity));
        } else {
            varyingUpdate(downcast(entity), downcast(option));
        }
    }

    @Override
    protected void doModifyNonstrict(final Entity entity,
            final UpdateOption<? extends ConditionBean> option) {
        doModify(entity, option);
    }

    /**
     * Insert or update the entity modified-only. {ExclusiveControl(when update)}
     * @param failureUrl The entity of insert or update target. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void insertOrUpdate(final FailureUrl failureUrl) {
        doInesrtOrUpdate(failureUrl, null, null);
    }

    protected void doInesrtOrUpdate(final FailureUrl failureUrl,
            final InsertOption<FailureUrlCB> insertOption,
            final UpdateOption<FailureUrlCB> updateOption) {
        helpInsertOrUpdateInternally(failureUrl,
                new InternalInsertOrUpdateCallback<FailureUrl, FailureUrlCB>() {
                    @Override
                    public void callbackInsert(final FailureUrl entity) {
                        doInsert(entity, insertOption);
                    }

                    @Override
                    public void callbackUpdate(final FailureUrl entity) {
                        doUpdate(entity, updateOption);
                    }

                    @Override
                    public FailureUrlCB callbackNewMyConditionBean() {
                        return newMyConditionBean();
                    }

                    @Override
                    public int callbackSelectCount(final FailureUrlCB cb) {
                        return selectCount(cb);
                    }
                });
    }

    @Override
    protected void doCreateOrModify(final Entity entity,
            InsertOption<? extends ConditionBean> insertOption,
            UpdateOption<? extends ConditionBean> updateOption) {
        if (insertOption == null && updateOption == null) {
            insertOrUpdate(downcast(entity));
        } else {
            insertOption = insertOption == null ? new InsertOption<FailureUrlCB>()
                    : insertOption;
            updateOption = updateOption == null ? new UpdateOption<FailureUrlCB>()
                    : updateOption;
            varyingInsertOrUpdate(downcast(entity), downcast(insertOption),
                    downcast(updateOption));
        }
    }

    @Override
    protected void doCreateOrModifyNonstrict(final Entity entity,
            final InsertOption<? extends ConditionBean> insertOption,
            final UpdateOption<? extends ConditionBean> updateOption) {
        doCreateOrModify(entity, insertOption, updateOption);
    }

    /**
     * Delete the entity. {UpdateCountZeroException, ExclusiveControl}
     * <pre>
     * FailureUrl failureUrl = new FailureUrl();
     * failureUrl.setPK...(value); <span style="color: #3F7E5E">// required</span>
     * <span style="color: #3F7E5E">// if exclusive control, the value of exclusive control column is required</span>
     * failureUrl.<span style="color: #FD4747">setVersionNo</span>(value);
     * try {
     *     failureUrlBhv.<span style="color: #FD4747">delete</span>(failureUrl);
     * } catch (EntityAlreadyUpdatedException e) { <span style="color: #3F7E5E">// if concurrent update</span>
     *     ...
     * } 
     * </pre>
     * @param failureUrl The entity of delete target. (NotNull) {PrimaryKeyRequired, ConcurrencyColumnRequired}
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     */
    public void delete(final FailureUrl failureUrl) {
        doDelete(failureUrl, null);
    }

    protected void doDelete(final FailureUrl failureUrl,
            final DeleteOption<FailureUrlCB> option) {
        assertObjectNotNull("failureUrl", failureUrl);
        prepareDeleteOption(option);
        helpDeleteInternally(failureUrl,
                new InternalDeleteCallback<FailureUrl>() {
                    @Override
                    public int callbackDelegateDelete(final FailureUrl entity) {
                        return delegateDelete(entity, option);
                    }
                });
    }

    protected void prepareDeleteOption(final DeleteOption<FailureUrlCB> option) {
        if (option == null) {
            return;
        }
        assertDeleteOptionStatus(option);
    }

    @Override
    protected void doRemove(final Entity entity,
            final DeleteOption<? extends ConditionBean> option) {
        if (option == null) {
            delete(downcast(entity));
        } else {
            varyingDelete(downcast(entity), downcast(option));
        }
    }

    @Override
    protected void doRemoveNonstrict(final Entity entity,
            final DeleteOption<? extends ConditionBean> option) {
        doRemove(entity, option);
    }

    // ===================================================================================
    //                                                                        Batch Update
    //                                                                        ============
    /**
     * Batch-insert the list. <br />
     * This method uses 'Batch Update' of java.sql.PreparedStatement. <br />
     * All columns are insert target. (so default constraints are not available) <br />
     * And if the table has an identity, entities after the process do not have incremented values.
     * (When you use the (normal) insert(), an entity after the process has an incremented value)
     * @param failureUrlList The list of the entity. (NotNull)
     * @return The array of inserted count.
     */
    public int[] batchInsert(final List<FailureUrl> failureUrlList) {
        return doBatchInsert(failureUrlList, null);
    }

    protected int[] doBatchInsert(final List<FailureUrl> failureUrlList,
            final InsertOption<FailureUrlCB> option) {
        assertObjectNotNull("failureUrlList", failureUrlList);
        prepareInsertOption(option);
        return delegateBatchInsert(failureUrlList, option);
    }

    @Override
    protected int[] doLumpCreate(final List<Entity> ls,
            final InsertOption<? extends ConditionBean> option) {
        if (option == null) {
            return batchInsert(downcast(ls));
        } else {
            return varyingBatchInsert(downcast(ls), downcast(option));
        }
    }

    /**
     * Batch-update the list. <br />
     * This method uses 'Batch Update' of java.sql.PreparedStatement. <br />
     * All columns are update target. {NOT modified only}
     * @param failureUrlList The list of the entity. (NotNull)
     * @return The array of updated count.
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     */
    public int[] batchUpdate(final List<FailureUrl> failureUrlList) {
        return doBatchUpdate(failureUrlList, null);
    }

    protected int[] doBatchUpdate(final List<FailureUrl> failureUrlList,
            final UpdateOption<FailureUrlCB> option) {
        assertObjectNotNull("failureUrlList", failureUrlList);
        prepareUpdateOption(option);
        return delegateBatchUpdate(failureUrlList, option);
    }

    @Override
    protected int[] doLumpModify(final List<Entity> ls,
            final UpdateOption<? extends ConditionBean> option) {
        if (option == null) {
            return batchUpdate(downcast(ls));
        } else {
            return varyingBatchUpdate(downcast(ls), downcast(option));
        }
    }

    /**
     * Batch-update the list. <br />
     * This method uses 'Batch Update' of java.sql.PreparedStatement. <br />
     * You can specify update columns used on set clause of update statement.
     * However you do not need to specify common columns for update
     * and an optimistick lock column because they are specified implicitly.
     * @param failureUrlList The list of the entity. (NotNull)
     * @param updateColumnSpec The specification of update columns. (NotNull)
     * @return The array of updated count.
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     */
    public int[] batchUpdate(final List<FailureUrl> failureUrlList,
            final SpecifyQuery<FailureUrlCB> updateColumnSpec) {
        return doBatchUpdate(failureUrlList,
                createSpecifiedUpdateOption(updateColumnSpec));
    }

    @Override
    protected int[] doLumpModifyNonstrict(final List<Entity> ls,
            final UpdateOption<? extends ConditionBean> option) {
        return doLumpModify(ls, option);
    }

    /**
     * Batch-delete the list. <br />
     * This method uses 'Batch Update' of java.sql.PreparedStatement.
     * @param failureUrlList The list of the entity. (NotNull)
     * @return The array of deleted count.
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     */
    public int[] batchDelete(final List<FailureUrl> failureUrlList) {
        return doBatchDelete(failureUrlList, null);
    }

    protected int[] doBatchDelete(final List<FailureUrl> failureUrlList,
            final DeleteOption<FailureUrlCB> option) {
        assertObjectNotNull("failureUrlList", failureUrlList);
        prepareDeleteOption(option);
        return delegateBatchDelete(failureUrlList, option);
    }

    @Override
    protected int[] doLumpRemove(final List<Entity> ls,
            final DeleteOption<? extends ConditionBean> option) {
        if (option == null) {
            return batchDelete(downcast(ls));
        } else {
            return varyingBatchDelete(downcast(ls), downcast(option));
        }
    }

    @Override
    protected int[] doLumpRemoveNonstrict(final List<Entity> ls,
            final DeleteOption<? extends ConditionBean> option) {
        return doLumpRemove(ls, option);
    }

    // ===================================================================================
    //                                                                        Query Update
    //                                                                        ============
    /**
     * Insert the several entities by query (modified-only for fixed value).
     * <pre>
     * failureUrlBhv.<span style="color: #FD4747">queryInsert</span>(new QueryInsertSetupper&lt;FailureUrl, FailureUrlCB&gt;() {
     *     public ConditionBean setup(failureUrl entity, FailureUrlCB intoCB) {
     *         FooCB cb = FooCB();
     *         cb.setupSelect_Bar();
     * 
     *         <span style="color: #3F7E5E">// mapping</span>
     *         intoCB.specify().columnMyName().mappedFrom(cb.specify().columnFooName());
     *         intoCB.specify().columnMyCount().mappedFrom(cb.specify().columnFooCount());
     *         intoCB.specify().columnMyDate().mappedFrom(cb.specify().specifyBar().columnBarDate());
     *         entity.setMyFixedValue("foo"); <span style="color: #3F7E5E">// fixed value</span>
     *         <span style="color: #3F7E5E">// you don't need to set values of common columns</span>
     *         <span style="color: #3F7E5E">//entity.setRegisterUser(value);</span>
     *         <span style="color: #3F7E5E">//entity.set...;</span>
     *         <span style="color: #3F7E5E">// you don't need to set a value of exclusive control column</span>
     *         <span style="color: #3F7E5E">//entity.setVersionNo(value);</span>
     * 
     *         return cb;
     *     }
     * });
     * </pre>
     * @param setupper The setup-per of query-insert. (NotNull)
     * @return The inserted count.
     */
    public int queryInsert(
            final QueryInsertSetupper<FailureUrl, FailureUrlCB> setupper) {
        return doQueryInsert(setupper, null);
    }

    protected int doQueryInsert(
            final QueryInsertSetupper<FailureUrl, FailureUrlCB> setupper,
            final InsertOption<FailureUrlCB> option) {
        assertObjectNotNull("setupper", setupper);
        prepareInsertOption(option);
        final FailureUrl entity = new FailureUrl();
        final FailureUrlCB intoCB = createCBForQueryInsert();
        final ConditionBean resourceCB = setupper.setup(entity, intoCB);
        return delegateQueryInsert(entity, intoCB, resourceCB, option);
    }

    protected FailureUrlCB createCBForQueryInsert() {
        final FailureUrlCB cb = newMyConditionBean();
        cb.xsetupForQueryInsert();
        return cb;
    }

    @Override
    protected int doRangeCreate(
            final QueryInsertSetupper<? extends Entity, ? extends ConditionBean> setupper,
            final InsertOption<? extends ConditionBean> option) {
        if (option == null) {
            return queryInsert(downcast(setupper));
        } else {
            return varyingQueryInsert(downcast(setupper), downcast(option));
        }
    }

    /**
     * Update the several entities by query non-strictly modified-only. {NonExclusiveControl}
     * <pre>
     * FailureUrl failureUrl = new FailureUrl();
     * <span style="color: #3F7E5E">// you don't need to set PK value</span>
     * <span style="color: #3F7E5E">//failureUrl.setPK...(value);</span>
     * failureUrl.setFoo...(value); <span style="color: #3F7E5E">// you should set only modified columns</span>
     * <span style="color: #3F7E5E">// you don't need to set values of common columns</span>
     * <span style="color: #3F7E5E">//failureUrl.setRegisterUser(value);</span>
     * <span style="color: #3F7E5E">//failureUrl.set...;</span>
     * <span style="color: #3F7E5E">// you don't need to set a value of exclusive control column</span>
     * <span style="color: #3F7E5E">// (auto-increment for version number is valid though non-exclusive control)</span>
     * <span style="color: #3F7E5E">//failureUrl.setVersionNo(value);</span>
     * FailureUrlCB cb = new FailureUrlCB();
     * cb.query().setFoo...(value);
     * failureUrlBhv.<span style="color: #FD4747">queryUpdate</span>(failureUrl, cb);
     * </pre>
     * @param failureUrl The entity that contains update values. (NotNull, PrimaryKeyNullAllowed)
     * @param cb The condition-bean of FailureUrl. (NotNull)
     * @return The updated count.
     * @exception org.seasar.dbflute.exception.NonQueryUpdateNotAllowedException When the query has no condition.
     */
    public int queryUpdate(final FailureUrl failureUrl, final FailureUrlCB cb) {
        return doQueryUpdate(failureUrl, cb, null);
    }

    protected int doQueryUpdate(final FailureUrl failureUrl,
            final FailureUrlCB cb, final UpdateOption<FailureUrlCB> option) {
        assertObjectNotNull("failureUrl", failureUrl);
        assertCBStateValid(cb);
        prepareUpdateOption(option);
        return delegateQueryUpdate(failureUrl, cb, option);
    }

    @Override
    protected int doRangeModify(final Entity entity, final ConditionBean cb,
            final UpdateOption<? extends ConditionBean> option) {
        if (option == null) {
            return queryUpdate(downcast(entity), (FailureUrlCB) cb);
        } else {
            return varyingQueryUpdate(downcast(entity), (FailureUrlCB) cb,
                    downcast(option));
        }
    }

    /**
     * Delete the several entities by query. {NonExclusiveControl}
     * <pre>
     * FailureUrlCB cb = new FailureUrlCB();
     * cb.query().setFoo...(value);
     * failureUrlBhv.<span style="color: #FD4747">queryDelete</span>(failureUrl, cb);
     * </pre>
     * @param cb The condition-bean of FailureUrl. (NotNull)
     * @return The deleted count.
     * @exception org.seasar.dbflute.exception.NonQueryDeleteNotAllowedException When the query has no condition.
     */
    public int queryDelete(final FailureUrlCB cb) {
        return doQueryDelete(cb, null);
    }

    protected int doQueryDelete(final FailureUrlCB cb,
            final DeleteOption<FailureUrlCB> option) {
        assertCBStateValid(cb);
        prepareDeleteOption(option);
        return delegateQueryDelete(cb, option);
    }

    @Override
    protected int doRangeRemove(final ConditionBean cb,
            final DeleteOption<? extends ConditionBean> option) {
        if (option == null) {
            return queryDelete((FailureUrlCB) cb);
        } else {
            return varyingQueryDelete((FailureUrlCB) cb, downcast(option));
        }
    }

    // ===================================================================================
    //                                                                      Varying Update
    //                                                                      ==============
    // -----------------------------------------------------
    //                                         Entity Update
    //                                         -------------
    /**
     * Insert the entity with varying requests. <br />
     * For example, disableCommonColumnAutoSetup(), disablePrimaryKeyIdentity(). <br />
     * Other specifications are same as insert(entity).
     * <pre>
     * FailureUrl failureUrl = new FailureUrl();
     * <span style="color: #3F7E5E">// if auto-increment, you don't need to set the PK value</span>
     * failureUrl.setFoo...(value);
     * failureUrl.setBar...(value);
     * InsertOption<FailureUrlCB> option = new InsertOption<FailureUrlCB>();
     * <span style="color: #3F7E5E">// you can insert by your values for common columns</span>
     * option.disableCommonColumnAutoSetup();
     * failureUrlBhv.<span style="color: #FD4747">varyingInsert</span>(failureUrl, option);
     * ... = failureUrl.getPK...(); <span style="color: #3F7E5E">// if auto-increment, you can get the value after</span>
     * </pre>
     * @param failureUrl The entity of insert target. (NotNull)
     * @param option The option of insert for varying requests. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void varyingInsert(final FailureUrl failureUrl,
            final InsertOption<FailureUrlCB> option) {
        assertInsertOptionNotNull(option);
        doInsert(failureUrl, option);
    }

    /**
     * Update the entity with varying requests modified-only. {UpdateCountZeroException, ExclusiveControl} <br />
     * For example, self(selfCalculationSpecification), specify(updateColumnSpecification), disableCommonColumnAutoSetup(). <br />
     * Other specifications are same as update(entity).
     * <pre>
     * FailureUrl failureUrl = new FailureUrl();
     * failureUrl.setPK...(value); <span style="color: #3F7E5E">// required</span>
     * failureUrl.setOther...(value); <span style="color: #3F7E5E">// you should set only modified columns</span>
     * <span style="color: #3F7E5E">// if exclusive control, the value of exclusive control column is required</span>
     * failureUrl.<span style="color: #FD4747">setVersionNo</span>(value);
     * try {
     *     <span style="color: #3F7E5E">// you can update by self calculation values</span>
     *     UpdateOption&lt;FailureUrlCB&gt; option = new UpdateOption&lt;FailureUrlCB&gt;();
     *     option.self(new SpecifyQuery&lt;FailureUrlCB&gt;() {
     *         public void specify(FailureUrlCB cb) {
     *             cb.specify().<span style="color: #FD4747">columnXxxCount()</span>;
     *         }
     *     }).plus(1); <span style="color: #3F7E5E">// XXX_COUNT = XXX_COUNT + 1</span>
     *     failureUrlBhv.<span style="color: #FD4747">varyingUpdate</span>(failureUrl, option);
     * } catch (EntityAlreadyUpdatedException e) { <span style="color: #3F7E5E">// if concurrent update</span>
     *     ...
     * }
     * </pre>
     * @param failureUrl The entity of update target. (NotNull) {PrimaryKeyRequired, ConcurrencyColumnRequired}
     * @param option The option of update for varying requests. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void varyingUpdate(final FailureUrl failureUrl,
            final UpdateOption<FailureUrlCB> option) {
        assertUpdateOptionNotNull(option);
        doUpdate(failureUrl, option);
    }

    /**
     * Insert or update the entity with varying requests. {ExclusiveControl(when update)}<br />
     * Other specifications are same as insertOrUpdate(entity).
     * @param failureUrl The entity of insert or update target. (NotNull)
     * @param insertOption The option of insert for varying requests. (NotNull)
     * @param updateOption The option of update for varying requests. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void varyingInsertOrUpdate(final FailureUrl failureUrl,
            final InsertOption<FailureUrlCB> insertOption,
            final UpdateOption<FailureUrlCB> updateOption) {
        assertInsertOptionNotNull(insertOption);
        assertUpdateOptionNotNull(updateOption);
        doInesrtOrUpdate(failureUrl, insertOption, updateOption);
    }

    /**
     * Delete the entity with varying requests. {UpdateCountZeroException, ExclusiveControl} <br />
     * Now a valid option does not exist. <br />
     * Other specifications are same as delete(entity).
     * @param failureUrl The entity of delete target. (NotNull) {PrimaryKeyRequired, ConcurrencyColumnRequired}
     * @param option The option of update for varying requests. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     */
    public void varyingDelete(final FailureUrl failureUrl,
            final DeleteOption<FailureUrlCB> option) {
        assertDeleteOptionNotNull(option);
        doDelete(failureUrl, option);
    }

    // -----------------------------------------------------
    //                                          Batch Update
    //                                          ------------
    /**
     * Batch-insert the list with varying requests. <br />
     * For example, disableCommonColumnAutoSetup()
     * , disablePrimaryKeyIdentity(), limitBatchInsertLogging(). <br />
     * Other specifications are same as batchInsert(entityList).
     * @param failureUrlList The list of the entity. (NotNull)
     * @param option The option of insert for varying requests. (NotNull)
     * @return The array of inserted count.
     */
    public int[] varyingBatchInsert(final List<FailureUrl> failureUrlList,
            final InsertOption<FailureUrlCB> option) {
        assertInsertOptionNotNull(option);
        return doBatchInsert(failureUrlList, option);
    }

    /**
     * Batch-update the list with varying requests. <br />
     * For example, self(selfCalculationSpecification), specify(updateColumnSpecification)
     * , disableCommonColumnAutoSetup(), limitBatchUpdateLogging(). <br />
     * Other specifications are same as batchUpdate(entityList).
     * @param failureUrlList The list of the entity. (NotNull)
     * @param option The option of update for varying requests. (NotNull)
     * @return The array of updated count.
     */
    public int[] varyingBatchUpdate(final List<FailureUrl> failureUrlList,
            final UpdateOption<FailureUrlCB> option) {
        assertUpdateOptionNotNull(option);
        return doBatchUpdate(failureUrlList, option);
    }

    /**
     * Batch-delete the list with varying requests. <br />
     * For example, limitBatchDeleteLogging(). <br />
     * Other specifications are same as batchDelete(entityList).
     * @param failureUrlList The list of the entity. (NotNull)
     * @param option The option of delete for varying requests. (NotNull)
     * @return The array of deleted count.
     */
    public int[] varyingBatchDelete(final List<FailureUrl> failureUrlList,
            final DeleteOption<FailureUrlCB> option) {
        assertDeleteOptionNotNull(option);
        return doBatchDelete(failureUrlList, option);
    }

    // -----------------------------------------------------
    //                                          Query Update
    //                                          ------------
    /**
     * Insert the several entities by query with varying requests (modified-only for fixed value). <br />
     * For example, disableCommonColumnAutoSetup(), disablePrimaryKeyIdentity(). <br />
     * Other specifications are same as queryInsert(entity, setupper). 
     * @param setupper The setup-per of query-insert. (NotNull)
     * @param option The option of insert for varying requests. (NotNull)
     * @return The inserted count.
     */
    public int varyingQueryInsert(
            final QueryInsertSetupper<FailureUrl, FailureUrlCB> setupper,
            final InsertOption<FailureUrlCB> option) {
        assertInsertOptionNotNull(option);
        return doQueryInsert(setupper, option);
    }

    /**
     * Update the several entities by query with varying requests non-strictly modified-only. {NonExclusiveControl} <br />
     * For example, self(selfCalculationSpecification), specify(updateColumnSpecification)
     * , disableCommonColumnAutoSetup(), allowNonQueryUpdate(). <br />
     * Other specifications are same as queryUpdate(entity, cb). 
     * <pre>
     * <span style="color: #3F7E5E">// ex) you can update by self calculation values</span>
     * FailureUrl failureUrl = new FailureUrl();
     * <span style="color: #3F7E5E">// you don't need to set PK value</span>
     * <span style="color: #3F7E5E">//failureUrl.setPK...(value);</span>
     * failureUrl.setOther...(value); <span style="color: #3F7E5E">// you should set only modified columns</span>
     * <span style="color: #3F7E5E">// you don't need to set a value of exclusive control column</span>
     * <span style="color: #3F7E5E">// (auto-increment for version number is valid though non-exclusive control)</span>
     * <span style="color: #3F7E5E">//failureUrl.setVersionNo(value);</span>
     * FailureUrlCB cb = new FailureUrlCB();
     * cb.query().setFoo...(value);
     * UpdateOption&lt;FailureUrlCB&gt; option = new UpdateOption&lt;FailureUrlCB&gt;();
     * option.self(new SpecifyQuery&lt;FailureUrlCB&gt;() {
     *     public void specify(FailureUrlCB cb) {
     *         cb.specify().<span style="color: #FD4747">columnFooCount()</span>;
     *     }
     * }).plus(1); <span style="color: #3F7E5E">// FOO_COUNT = FOO_COUNT + 1</span>
     * failureUrlBhv.<span style="color: #FD4747">varyingQueryUpdate</span>(failureUrl, cb, option);
     * </pre>
     * @param failureUrl The entity that contains update values. (NotNull) {PrimaryKeyNotRequired}
     * @param cb The condition-bean of FailureUrl. (NotNull)
     * @param option The option of update for varying requests. (NotNull)
     * @return The updated count.
     * @exception org.seasar.dbflute.exception.NonQueryUpdateNotAllowedException When the query has no condition (if not allowed).
     */
    public int varyingQueryUpdate(final FailureUrl failureUrl,
            final FailureUrlCB cb, final UpdateOption<FailureUrlCB> option) {
        assertUpdateOptionNotNull(option);
        return doQueryUpdate(failureUrl, cb, option);
    }

    /**
     * Delete the several entities by query with varying requests non-strictly. <br />
     * For example, allowNonQueryDelete(). <br />
     * Other specifications are same as batchUpdateNonstrict(entityList).
     * @param cb The condition-bean of FailureUrl. (NotNull)
     * @param option The option of delete for varying requests. (NotNull)
     * @return The deleted count.
     * @exception org.seasar.dbflute.exception.NonQueryDeleteNotAllowedException When the query has no condition (if not allowed).
     */
    public int varyingQueryDelete(final FailureUrlCB cb,
            final DeleteOption<FailureUrlCB> option) {
        assertDeleteOptionNotNull(option);
        return doQueryDelete(cb, option);
    }

    // ===================================================================================
    //                                                                          OutsideSql
    //                                                                          ==========
    /**
     * Prepare the basic executor of outside-SQL to execute it. <br />
     * The invoker of behavior command should be not null when you call this method.
     * <pre>
     * You can use the methods for outside-SQL are as follows:
     * {Basic}
     *   o selectList()
     *   o execute()
     *   o call()
     * 
     * {Entity}
     *   o entityHandling().selectEntity()
     *   o entityHandling().selectEntityWithDeletedCheck()
     * 
     * {Paging}
     *   o autoPaging().selectList()
     *   o autoPaging().selectPage()
     *   o manualPaging().selectList()
     *   o manualPaging().selectPage()
     * 
     * {Cursor}
     *   o cursorHandling().selectCursor()
     * 
     * {Option}
     *   o dynamicBinding().selectList()
     *   o removeBlockComment().selectList()
     *   o removeLineComment().selectList()
     *   o formatSql().selectList()
     * </pre>
     * @return The basic executor of outside-SQL. (NotNull) 
     */
    public OutsideSqlBasicExecutor<FailureUrlBhv> outsideSql() {
        return doOutsideSql();
    }

    // ===================================================================================
    //                                                                     Delegate Method
    //                                                                     ===============
    // [Behavior Command]
    // -----------------------------------------------------
    //                                                Select
    //                                                ------
    protected int delegateSelectCountUniquely(final FailureUrlCB cb) {
        return invoke(createSelectCountCBCommand(cb, true));
    }

    protected int delegateSelectCountPlainly(final FailureUrlCB cb) {
        return invoke(createSelectCountCBCommand(cb, false));
    }

    protected <ENTITY extends FailureUrl> void delegateSelectCursor(
            final FailureUrlCB cb, final EntityRowHandler<ENTITY> erh,
            final Class<ENTITY> et) {
        invoke(createSelectCursorCBCommand(cb, erh, et));
    }

    protected <ENTITY extends FailureUrl> List<ENTITY> delegateSelectList(
            final FailureUrlCB cb, final Class<ENTITY> et) {
        return invoke(createSelectListCBCommand(cb, et));
    }

    // -----------------------------------------------------
    //                                                Update
    //                                                ------
    protected int delegateInsert(final FailureUrl e,
            final InsertOption<FailureUrlCB> op) {
        if (!processBeforeInsert(e, op)) {
            return 0;
        }
        return invoke(createInsertEntityCommand(e, op));
    }

    protected int delegateUpdate(final FailureUrl e,
            final UpdateOption<FailureUrlCB> op) {
        if (!processBeforeUpdate(e, op)) {
            return 0;
        }
        return delegateUpdateNonstrict(e, op);
    }

    protected int delegateUpdateNonstrict(final FailureUrl e,
            final UpdateOption<FailureUrlCB> op) {
        if (!processBeforeUpdate(e, op)) {
            return 0;
        }
        return invoke(createUpdateNonstrictEntityCommand(e, op));
    }

    protected int delegateDelete(final FailureUrl e,
            final DeleteOption<FailureUrlCB> op) {
        if (!processBeforeDelete(e, op)) {
            return 0;
        }
        return delegateDeleteNonstrict(e, op);
    }

    protected int delegateDeleteNonstrict(final FailureUrl e,
            final DeleteOption<FailureUrlCB> op) {
        if (!processBeforeDelete(e, op)) {
            return 0;
        }
        return invoke(createDeleteNonstrictEntityCommand(e, op));
    }

    protected int[] delegateBatchInsert(final List<FailureUrl> ls,
            final InsertOption<FailureUrlCB> op) {
        if (ls.isEmpty()) {
            return new int[] {};
        }
        return invoke(createBatchInsertCommand(processBatchInternally(ls, op),
                op));
    }

    protected int[] delegateBatchUpdate(final List<FailureUrl> ls,
            final UpdateOption<FailureUrlCB> op) {
        if (ls.isEmpty()) {
            return new int[] {};
        }
        return delegateBatchUpdateNonstrict(ls, op);
    }

    protected int[] delegateBatchUpdateNonstrict(final List<FailureUrl> ls,
            final UpdateOption<FailureUrlCB> op) {
        if (ls.isEmpty()) {
            return new int[] {};
        }
        return invoke(createBatchUpdateNonstrictCommand(
                processBatchInternally(ls, op, true), op));
    }

    protected int[] delegateBatchDelete(final List<FailureUrl> ls,
            final DeleteOption<FailureUrlCB> op) {
        if (ls.isEmpty()) {
            return new int[] {};
        }
        return delegateBatchDeleteNonstrict(ls, op);
    }

    protected int[] delegateBatchDeleteNonstrict(final List<FailureUrl> ls,
            final DeleteOption<FailureUrlCB> op) {
        if (ls.isEmpty()) {
            return new int[] {};
        }
        return invoke(createBatchDeleteNonstrictCommand(
                processBatchInternally(ls, op, true), op));
    }

    protected int delegateQueryInsert(final FailureUrl e,
            final FailureUrlCB inCB, final ConditionBean resCB,
            final InsertOption<FailureUrlCB> op) {
        if (!processBeforeQueryInsert(e, inCB, resCB, op)) {
            return 0;
        }
        return invoke(createQueryInsertCBCommand(e, inCB, resCB, op));
    }

    protected int delegateQueryUpdate(final FailureUrl e,
            final FailureUrlCB cb, final UpdateOption<FailureUrlCB> op) {
        if (!processBeforeQueryUpdate(e, cb, op)) {
            return 0;
        }
        return invoke(createQueryUpdateCBCommand(e, cb, op));
    }

    protected int delegateQueryDelete(final FailureUrlCB cb,
            final DeleteOption<FailureUrlCB> op) {
        if (!processBeforeQueryDelete(cb, op)) {
            return 0;
        }
        return invoke(createQueryDeleteCBCommand(cb, op));
    }

    // ===================================================================================
    //                                                                Optimistic Lock Info
    //                                                                ====================
    /**
     * {@inheritDoc}
     */
    @Override
    protected boolean hasVersionNoValue(final Entity entity) {
        return false;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    protected boolean hasUpdateDateValue(final Entity entity) {
        return false;
    }

    // ===================================================================================
    //                                                                     Downcast Helper
    //                                                                     ===============
    protected FailureUrl downcast(final Entity entity) {
        return helpEntityDowncastInternally(entity, FailureUrl.class);
    }

    protected FailureUrlCB downcast(final ConditionBean cb) {
        return helpConditionBeanDowncastInternally(cb, FailureUrlCB.class);
    }

    @SuppressWarnings("unchecked")
    protected List<FailureUrl> downcast(final List<? extends Entity> entityList) {
        return (List<FailureUrl>) entityList;
    }

    @SuppressWarnings("unchecked")
    protected InsertOption<FailureUrlCB> downcast(
            final InsertOption<? extends ConditionBean> option) {
        return (InsertOption<FailureUrlCB>) option;
    }

    @SuppressWarnings("unchecked")
    protected UpdateOption<FailureUrlCB> downcast(
            final UpdateOption<? extends ConditionBean> option) {
        return (UpdateOption<FailureUrlCB>) option;
    }

    @SuppressWarnings("unchecked")
    protected DeleteOption<FailureUrlCB> downcast(
            final DeleteOption<? extends ConditionBean> option) {
        return (DeleteOption<FailureUrlCB>) option;
    }

    @SuppressWarnings("unchecked")
    protected QueryInsertSetupper<FailureUrl, FailureUrlCB> downcast(
            final QueryInsertSetupper<? extends Entity, ? extends ConditionBean> option) {
        return (QueryInsertSetupper<FailureUrl, FailureUrlCB>) option;
    }
}
