/*
 * Copyright 2009-2012 the Fess Project and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */

package jp.sf.fess.db.bsbhv;

import java.util.List;

import jp.sf.fess.db.bsentity.dbmeta.BrowserTypeDbm;
import jp.sf.fess.db.cbean.BrowserTypeCB;
import jp.sf.fess.db.cbean.DataConfigToBrowserTypeMappingCB;
import jp.sf.fess.db.cbean.FileConfigToBrowserTypeMappingCB;
import jp.sf.fess.db.cbean.WebConfigToBrowserTypeMappingCB;
import jp.sf.fess.db.exbhv.BrowserTypeBhv;
import jp.sf.fess.db.exbhv.DataConfigToBrowserTypeMappingBhv;
import jp.sf.fess.db.exbhv.FileConfigToBrowserTypeMappingBhv;
import jp.sf.fess.db.exbhv.WebConfigToBrowserTypeMappingBhv;
import jp.sf.fess.db.exentity.BrowserType;
import jp.sf.fess.db.exentity.DataConfigToBrowserTypeMapping;
import jp.sf.fess.db.exentity.FileConfigToBrowserTypeMapping;
import jp.sf.fess.db.exentity.WebConfigToBrowserTypeMapping;

import org.seasar.dbflute.Entity;
import org.seasar.dbflute.bhv.AbstractBehaviorWritable;
import org.seasar.dbflute.bhv.ConditionBeanSetupper;
import org.seasar.dbflute.bhv.DeleteOption;
import org.seasar.dbflute.bhv.InsertOption;
import org.seasar.dbflute.bhv.LoadReferrerOption;
import org.seasar.dbflute.bhv.QueryInsertSetupper;
import org.seasar.dbflute.bhv.UpdateOption;
import org.seasar.dbflute.cbean.ConditionBean;
import org.seasar.dbflute.cbean.EntityRowHandler;
import org.seasar.dbflute.cbean.ListResultBean;
import org.seasar.dbflute.cbean.PagingResultBean;
import org.seasar.dbflute.cbean.SpecifyQuery;
import org.seasar.dbflute.dbmeta.DBMeta;
import org.seasar.dbflute.outsidesql.executor.OutsideSqlBasicExecutor;

/**
 * The behavior of BROWSER_TYPE as TABLE. <br />
 * <pre>
 * [primary key]
 *     ID
 * 
 * [column]
 *     ID, NAME, VALUE, SORT_ORDER, CREATED_BY, CREATED_TIME, UPDATED_BY, UPDATED_TIME, DELETED_BY, DELETED_TIME, VERSION_NO
 * 
 * [sequence]
 *     
 * 
 * [identity]
 *     ID
 * 
 * [version-no]
 *     VERSION_NO
 * 
 * [foreign table]
 *     
 * 
 * [referrer table]
 *     DATA_CONFIG_TO_BROWSER_TYPE_MAPPING, FILE_CONFIG_TO_BROWSER_TYPE_MAPPING, WEB_CONFIG_TO_BROWSER_TYPE_MAPPING
 * 
 * [foreign property]
 *     
 * 
 * [referrer property]
 *     dataConfigToBrowserTypeMappingList, fileConfigToBrowserTypeMappingList, webConfigToBrowserTypeMappingList
 * </pre>
 * @author DBFlute(AutoGenerator)
 */
public abstract class BsBrowserTypeBhv extends AbstractBehaviorWritable {

    // ===================================================================================
    //                                                                          Definition
    //                                                                          ==========
    /*df:beginQueryPath*/
    /*df:endQueryPath*/

    // ===================================================================================
    //                                                                          Table name
    //                                                                          ==========
    /** @return The name on database of table. (NotNull) */
    @Override
    public String getTableDbName() {
        return "BROWSER_TYPE";
    }

    // ===================================================================================
    //                                                                              DBMeta
    //                                                                              ======
    /** @return The instance of DBMeta. (NotNull) */
    @Override
    public DBMeta getDBMeta() {
        return BrowserTypeDbm.getInstance();
    }

    /** @return The instance of DBMeta as my table type. (NotNull) */
    public BrowserTypeDbm getMyDBMeta() {
        return BrowserTypeDbm.getInstance();
    }

    // ===================================================================================
    //                                                                        New Instance
    //                                                                        ============
    /** {@inheritDoc} */
    @Override
    public Entity newEntity() {
        return newMyEntity();
    }

    /** {@inheritDoc} */
    @Override
    public ConditionBean newConditionBean() {
        return newMyConditionBean();
    }

    /** @return The instance of new entity as my table type. (NotNull) */
    public BrowserType newMyEntity() {
        return new BrowserType();
    }

    /** @return The instance of new condition-bean as my table type. (NotNull) */
    public BrowserTypeCB newMyConditionBean() {
        return new BrowserTypeCB();
    }

    // ===================================================================================
    //                                                                        Count Select
    //                                                                        ============
    /**
     * Select the count of uniquely-selected records by the condition-bean. {IgnorePagingCondition, IgnoreSpecifyColumn}<br />
     * SpecifyColumn is ignored but you can use it only to remove text type column for union's distinct.
     * <pre>
     * BrowserTypeCB cb = new BrowserTypeCB();
     * cb.query().setFoo...(value);
     * int count = browserTypeBhv.<span style="color: #FD4747">selectCount</span>(cb);
     * </pre>
     * @param cb The condition-bean of BrowserType. (NotNull)
     * @return The selected count.
     */
    public int selectCount(final BrowserTypeCB cb) {
        return doSelectCountUniquely(cb);
    }

    protected int doSelectCountUniquely(final BrowserTypeCB cb) { // called by selectCount(cb) 
        assertCBStateValid(cb);
        return delegateSelectCountUniquely(cb);
    }

    protected int doSelectCountPlainly(final BrowserTypeCB cb) { // called by selectPage(cb)
        assertCBStateValid(cb);
        return delegateSelectCountPlainly(cb);
    }

    @Override
    protected int doReadCount(final ConditionBean cb) {
        return selectCount(downcast(cb));
    }

    // ===================================================================================
    //                                                                       Cursor Select
    //                                                                       =============
    /**
     * Select the cursor by the condition-bean.
     * <pre>
     * BrowserTypeCB cb = new BrowserTypeCB();
     * cb.query().setFoo...(value);
     * browserTypeBhv.<span style="color: #FD4747">selectCursor</span>(cb, new EntityRowHandler&lt;BrowserType&gt;() {
     *     public void handle(BrowserType entity) {
     *         ... = entity.getFoo...();
     *     }
     * });
     * </pre>
     * @param cb The condition-bean of BrowserType. (NotNull)
     * @param entityRowHandler The handler of entity row of BrowserType. (NotNull)
     */
    public void selectCursor(final BrowserTypeCB cb,
            final EntityRowHandler<BrowserType> entityRowHandler) {
        doSelectCursor(cb, entityRowHandler, BrowserType.class);
    }

    protected <ENTITY extends BrowserType> void doSelectCursor(
            final BrowserTypeCB cb,
            final EntityRowHandler<ENTITY> entityRowHandler,
            final Class<ENTITY> entityType) {
        assertCBStateValid(cb);
        assertObjectNotNull("entityRowHandler<BrowserType>", entityRowHandler);
        assertObjectNotNull("entityType", entityType);
        assertSpecifyDerivedReferrerEntityProperty(cb, entityType);
        delegateSelectCursor(cb, entityRowHandler, entityType);
    }

    // ===================================================================================
    //                                                                       Entity Select
    //                                                                       =============
    /**
     * Select the entity by the condition-bean.
     * <pre>
     * BrowserTypeCB cb = new BrowserTypeCB();
     * cb.query().setFoo...(value);
     * BrowserType browserType = browserTypeBhv.<span style="color: #FD4747">selectEntity</span>(cb);
     * if (browserType != null) {
     *     ... = browserType.get...();
     * } else {
     *     ...
     * }
     * </pre>
     * @param cb The condition-bean of BrowserType. (NotNull)
     * @return The selected entity. (NullAllowed: If the condition has no data, it returns null)
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.SelectEntityConditionNotFoundException When the condition for selecting an entity is not found.
     */
    public BrowserType selectEntity(final BrowserTypeCB cb) {
        return doSelectEntity(cb, BrowserType.class);
    }

    protected <ENTITY extends BrowserType> ENTITY doSelectEntity(
            final BrowserTypeCB cb, final Class<ENTITY> entityType) {
        assertCBStateValid(cb);
        return helpSelectEntityInternally(cb,
                new InternalSelectEntityCallback<ENTITY, BrowserTypeCB>() {
                    @Override
                    public List<ENTITY> callbackSelectList(
                            final BrowserTypeCB cb) {
                        return doSelectList(cb, entityType);
                    }
                });
    }

    @Override
    protected Entity doReadEntity(final ConditionBean cb) {
        return selectEntity(downcast(cb));
    }

    /**
     * Select the entity by the condition-bean with deleted check.
     * <pre>
     * BrowserTypeCB cb = new BrowserTypeCB();
     * cb.query().setFoo...(value);
     * BrowserType browserType = browserTypeBhv.<span style="color: #FD4747">selectEntityWithDeletedCheck</span>(cb);
     * ... = browserType.get...(); <span style="color: #3F7E5E">// the entity always be not null</span>
     * </pre>
     * @param cb The condition-bean of BrowserType. (NotNull)
     * @return The selected entity. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.SelectEntityConditionNotFoundException When the condition for selecting an entity is not found.
     */
    public BrowserType selectEntityWithDeletedCheck(final BrowserTypeCB cb) {
        return doSelectEntityWithDeletedCheck(cb, BrowserType.class);
    }

    protected <ENTITY extends BrowserType> ENTITY doSelectEntityWithDeletedCheck(
            final BrowserTypeCB cb, final Class<ENTITY> entityType) {
        assertCBStateValid(cb);
        return helpSelectEntityWithDeletedCheckInternally(
                cb,
                new InternalSelectEntityWithDeletedCheckCallback<ENTITY, BrowserTypeCB>() {
                    @Override
                    public List<ENTITY> callbackSelectList(
                            final BrowserTypeCB cb) {
                        return doSelectList(cb, entityType);
                    }
                });
    }

    @Override
    protected Entity doReadEntityWithDeletedCheck(final ConditionBean cb) {
        return selectEntityWithDeletedCheck(downcast(cb));
    }

    /**
     * Select the entity by the primary-key value.
     * @param id The one of primary key. (NotNull)
     * @return The selected entity. (NullAllowed: If the primary-key value has no data, it returns null)
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.SelectEntityConditionNotFoundException When the condition for selecting an entity is not found.
     */
    public BrowserType selectByPKValue(final Long id) {
        return doSelectByPKValue(id, BrowserType.class);
    }

    protected <ENTITY extends BrowserType> ENTITY doSelectByPKValue(
            final Long id, final Class<ENTITY> entityType) {
        return doSelectEntity(buildPKCB(id), entityType);
    }

    /**
     * Select the entity by the primary-key value with deleted check.
     * @param id The one of primary key. (NotNull)
     * @return The selected entity. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.SelectEntityConditionNotFoundException When the condition for selecting an entity is not found.
     */
    public BrowserType selectByPKValueWithDeletedCheck(final Long id) {
        return doSelectByPKValueWithDeletedCheck(id, BrowserType.class);
    }

    protected <ENTITY extends BrowserType> ENTITY doSelectByPKValueWithDeletedCheck(
            final Long id, final Class<ENTITY> entityType) {
        return doSelectEntityWithDeletedCheck(buildPKCB(id), entityType);
    }

    private BrowserTypeCB buildPKCB(final Long id) {
        assertObjectNotNull("id", id);
        final BrowserTypeCB cb = newMyConditionBean();
        cb.query().setId_Equal(id);
        return cb;
    }

    // ===================================================================================
    //                                                                         List Select
    //                                                                         ===========
    /**
     * Select the list as result bean.
     * <pre>
     * BrowserTypeCB cb = new BrowserTypeCB();
     * cb.query().setFoo...(value);
     * cb.query().addOrderBy_Bar...();
     * ListResultBean&lt;BrowserType&gt; browserTypeList = browserTypeBhv.<span style="color: #FD4747">selectList</span>(cb);
     * for (BrowserType browserType : browserTypeList) {
     *     ... = browserType.get...();
     * }
     * </pre>
     * @param cb The condition-bean of BrowserType. (NotNull)
     * @return The result bean of selected list. (NotNull)
     * @exception org.seasar.dbflute.exception.DangerousResultSizeException When the result size is over the specified safety size.
     */
    public ListResultBean<BrowserType> selectList(final BrowserTypeCB cb) {
        return doSelectList(cb, BrowserType.class);
    }

    protected <ENTITY extends BrowserType> ListResultBean<ENTITY> doSelectList(
            final BrowserTypeCB cb, final Class<ENTITY> entityType) {
        assertCBStateValid(cb);
        assertObjectNotNull("entityType", entityType);
        assertSpecifyDerivedReferrerEntityProperty(cb, entityType);
        return helpSelectListInternally(cb, entityType,
                new InternalSelectListCallback<ENTITY, BrowserTypeCB>() {
                    @Override
                    public List<ENTITY> callbackSelectList(
                            final BrowserTypeCB cb,
                            final Class<ENTITY> entityType) {
                        return delegateSelectList(cb, entityType);
                    }
                });
    }

    @Override
    protected ListResultBean<? extends Entity> doReadList(final ConditionBean cb) {
        return selectList(downcast(cb));
    }

    // ===================================================================================
    //                                                                         Page Select
    //                                                                         ===========
    /**
     * Select the page as result bean. <br />
     * (both count-select and paging-select are executed)
     * <pre>
     * BrowserTypeCB cb = new BrowserTypeCB();
     * cb.query().setFoo...(value);
     * cb.query().addOrderBy_Bar...();
     * cb.<span style="color: #FD4747">paging</span>(20, 3); <span style="color: #3F7E5E">// 20 records per a page and current page number is 3</span>
     * PagingResultBean&lt;BrowserType&gt; page = browserTypeBhv.<span style="color: #FD4747">selectPage</span>(cb);
     * int allRecordCount = page.getAllRecordCount();
     * int allPageCount = page.getAllPageCount();
     * boolean isExistPrePage = page.isExistPrePage();
     * boolean isExistNextPage = page.isExistNextPage();
     * ...
     * for (BrowserType browserType : page) {
     *     ... = browserType.get...();
     * }
     * </pre>
     * @param cb The condition-bean of BrowserType. (NotNull)
     * @return The result bean of selected page. (NotNull)
     * @exception org.seasar.dbflute.exception.DangerousResultSizeException When the result size is over the specified safety size.
     */
    public PagingResultBean<BrowserType> selectPage(final BrowserTypeCB cb) {
        return doSelectPage(cb, BrowserType.class);
    }

    protected <ENTITY extends BrowserType> PagingResultBean<ENTITY> doSelectPage(
            final BrowserTypeCB cb, final Class<ENTITY> entityType) {
        assertCBStateValid(cb);
        assertObjectNotNull("entityType", entityType);
        return helpSelectPageInternally(cb, entityType,
                new InternalSelectPageCallback<ENTITY, BrowserTypeCB>() {
                    @Override
                    public int callbackSelectCount(final BrowserTypeCB cb) {
                        return doSelectCountPlainly(cb);
                    }

                    @Override
                    public List<ENTITY> callbackSelectList(
                            final BrowserTypeCB cb,
                            final Class<ENTITY> entityType) {
                        return doSelectList(cb, entityType);
                    }
                });
    }

    @Override
    protected PagingResultBean<? extends Entity> doReadPage(
            final ConditionBean cb) {
        return selectPage(downcast(cb));
    }

    // ===================================================================================
    //                                                                       Scalar Select
    //                                                                       =============
    /**
     * Select the scalar value derived by a function from uniquely-selected records. <br />
     * You should call a function method after this method called like as follows:
     * <pre>
     * browserTypeBhv.<span style="color: #FD4747">scalarSelect</span>(Date.class).max(new ScalarQuery() {
     *     public void query(BrowserTypeCB cb) {
     *         cb.specify().<span style="color: #FD4747">columnFooDatetime()</span>; <span style="color: #3F7E5E">// required for a function</span>
     *         cb.query().setBarName_PrefixSearch("S");
     *     }
     * });
     * </pre>
     * @param <RESULT> The type of result.
     * @param resultType The type of result. (NotNull)
     * @return The scalar value derived by a function. (NullAllowed)
     */
    public <RESULT> SLFunction<BrowserTypeCB, RESULT> scalarSelect(
            final Class<RESULT> resultType) {
        return doScalarSelect(resultType, newMyConditionBean());
    }

    protected <RESULT, CB extends BrowserTypeCB> SLFunction<CB, RESULT> doScalarSelect(
            final Class<RESULT> resultType, final CB cb) {
        assertObjectNotNull("resultType", resultType);
        assertCBStateValid(cb);
        cb.xsetupForScalarSelect();
        cb.getSqlClause().disableSelectIndex(); // for when you use union
        return new SLFunction<CB, RESULT>(cb, resultType);
    }

    // ===================================================================================
    //                                                                            Sequence
    //                                                                            ========
    @Override
    protected Number doReadNextVal() {
        final String msg = "This table is NOT related to sequence: "
                + getTableDbName();
        throw new UnsupportedOperationException(msg);
    }

    // ===================================================================================
    //                                                                       Load Referrer
    //                                                                       =============
    /**
     * {Refer to overload method that has an argument of the list of entity.}
     * @param browserType The entity of browserType. (NotNull)
     * @param conditionBeanSetupper The instance of referrer condition-bean set-upper for registering referrer condition. (NotNull)
     */
    public void loadDataConfigToBrowserTypeMappingList(
            final BrowserType browserType,
            final ConditionBeanSetupper<DataConfigToBrowserTypeMappingCB> conditionBeanSetupper) {
        xassLRArg(browserType, conditionBeanSetupper);
        loadDataConfigToBrowserTypeMappingList(xnewLRLs(browserType),
                conditionBeanSetupper);
    }

    /**
     * Load referrer of dataConfigToBrowserTypeMappingList with the set-upper for condition-bean of referrer. <br />
     * DATA_CONFIG_TO_BROWSER_TYPE_MAPPING by your BROWSER_TYPE_ID, named 'dataConfigToBrowserTypeMappingList'.
     * <pre>
     * browserTypeBhv.<span style="color: #FD4747">loadDataConfigToBrowserTypeMappingList</span>(browserTypeList, new ConditionBeanSetupper&lt;DataConfigToBrowserTypeMappingCB&gt;() {
     *     public void setup(DataConfigToBrowserTypeMappingCB cb) {
     *         cb.setupSelect...();
     *         cb.query().setFoo...(value);
     *         cb.query().addOrderBy_Bar...(); <span style="color: #3F7E5E">// basically you should order referrer list</span>
     *     }
     * });
     * for (BrowserType browserType : browserTypeList) {
     *     ... = browserType.<span style="color: #FD4747">getDataConfigToBrowserTypeMappingList()</span>;
     * }
     * </pre>
     * About internal policy, the value of primary key(and others too) is treated as case-insensitive. <br />
     * The condition-bean that the set-upper provides have settings before you touch it. It is as follows:
     * <pre>
     * cb.query().setBrowserTypeId_InScope(pkList);
     * cb.query().addOrderBy_BrowserTypeId_Asc();
     * </pre>
     * @param browserTypeList The entity list of browserType. (NotNull)
     * @param conditionBeanSetupper The instance of referrer condition-bean set-upper for registering referrer condition. (NotNull)
     */
    public void loadDataConfigToBrowserTypeMappingList(
            final List<BrowserType> browserTypeList,
            final ConditionBeanSetupper<DataConfigToBrowserTypeMappingCB> conditionBeanSetupper) {
        xassLRArg(browserTypeList, conditionBeanSetupper);
        loadDataConfigToBrowserTypeMappingList(
                browserTypeList,
                new LoadReferrerOption<DataConfigToBrowserTypeMappingCB, DataConfigToBrowserTypeMapping>()
                        .xinit(conditionBeanSetupper));
    }

    /**
     * {Refer to overload method that has an argument of the list of entity.}
     * @param browserType The entity of browserType. (NotNull)
     * @param loadReferrerOption The option of load-referrer. (NotNull)
     */
    public void loadDataConfigToBrowserTypeMappingList(
            final BrowserType browserType,
            final LoadReferrerOption<DataConfigToBrowserTypeMappingCB, DataConfigToBrowserTypeMapping> loadReferrerOption) {
        xassLRArg(browserType, loadReferrerOption);
        loadDataConfigToBrowserTypeMappingList(xnewLRLs(browserType),
                loadReferrerOption);
    }

    /**
     * {Refer to overload method that has an argument of condition-bean setupper.}
     * @param browserTypeList The entity list of browserType. (NotNull)
     * @param loadReferrerOption The option of load-referrer. (NotNull)
     */
    public void loadDataConfigToBrowserTypeMappingList(
            final List<BrowserType> browserTypeList,
            final LoadReferrerOption<DataConfigToBrowserTypeMappingCB, DataConfigToBrowserTypeMapping> loadReferrerOption) {
        xassLRArg(browserTypeList, loadReferrerOption);
        if (browserTypeList.isEmpty()) {
            return;
        }
        final DataConfigToBrowserTypeMappingBhv referrerBhv = xgetBSFLR()
                .select(DataConfigToBrowserTypeMappingBhv.class);
        helpLoadReferrerInternally(
                browserTypeList,
                loadReferrerOption,
                new InternalLoadReferrerCallback<BrowserType, Long, DataConfigToBrowserTypeMappingCB, DataConfigToBrowserTypeMapping>() {
                    @Override
                    public Long getPKVal(final BrowserType e) {
                        return e.getId();
                    }

                    @Override
                    public void setRfLs(final BrowserType e,
                            final List<DataConfigToBrowserTypeMapping> ls) {
                        e.setDataConfigToBrowserTypeMappingList(ls);
                    }

                    @Override
                    public DataConfigToBrowserTypeMappingCB newMyCB() {
                        return referrerBhv.newMyConditionBean();
                    }

                    @Override
                    public void qyFKIn(
                            final DataConfigToBrowserTypeMappingCB cb,
                            final List<Long> ls) {
                        cb.query().setBrowserTypeId_InScope(ls);
                    }

                    @Override
                    public void qyOdFKAsc(
                            final DataConfigToBrowserTypeMappingCB cb) {
                        cb.query().addOrderBy_BrowserTypeId_Asc();
                    }

                    @Override
                    public void spFKCol(
                            final DataConfigToBrowserTypeMappingCB cb) {
                        cb.specify().columnBrowserTypeId();
                    }

                    @Override
                    public List<DataConfigToBrowserTypeMapping> selRfLs(
                            final DataConfigToBrowserTypeMappingCB cb) {
                        return referrerBhv.selectList(cb);
                    }

                    @Override
                    public Long getFKVal(final DataConfigToBrowserTypeMapping e) {
                        return e.getBrowserTypeId();
                    }

                    @Override
                    public void setlcEt(
                            final DataConfigToBrowserTypeMapping re,
                            final BrowserType le) {
                        re.setBrowserType(le);
                    }

                    @Override
                    public String getRfPrNm() {
                        return "dataConfigToBrowserTypeMappingList";
                    }
                });
    }

    /**
     * {Refer to overload method that has an argument of the list of entity.}
     * @param browserType The entity of browserType. (NotNull)
     * @param conditionBeanSetupper The instance of referrer condition-bean set-upper for registering referrer condition. (NotNull)
     */
    public void loadFileConfigToBrowserTypeMappingList(
            final BrowserType browserType,
            final ConditionBeanSetupper<FileConfigToBrowserTypeMappingCB> conditionBeanSetupper) {
        xassLRArg(browserType, conditionBeanSetupper);
        loadFileConfigToBrowserTypeMappingList(xnewLRLs(browserType),
                conditionBeanSetupper);
    }

    /**
     * Load referrer of fileConfigToBrowserTypeMappingList with the set-upper for condition-bean of referrer. <br />
     * FILE_CONFIG_TO_BROWSER_TYPE_MAPPING by your BROWSER_TYPE_ID, named 'fileConfigToBrowserTypeMappingList'.
     * <pre>
     * browserTypeBhv.<span style="color: #FD4747">loadFileConfigToBrowserTypeMappingList</span>(browserTypeList, new ConditionBeanSetupper&lt;FileConfigToBrowserTypeMappingCB&gt;() {
     *     public void setup(FileConfigToBrowserTypeMappingCB cb) {
     *         cb.setupSelect...();
     *         cb.query().setFoo...(value);
     *         cb.query().addOrderBy_Bar...(); <span style="color: #3F7E5E">// basically you should order referrer list</span>
     *     }
     * });
     * for (BrowserType browserType : browserTypeList) {
     *     ... = browserType.<span style="color: #FD4747">getFileConfigToBrowserTypeMappingList()</span>;
     * }
     * </pre>
     * About internal policy, the value of primary key(and others too) is treated as case-insensitive. <br />
     * The condition-bean that the set-upper provides have settings before you touch it. It is as follows:
     * <pre>
     * cb.query().setBrowserTypeId_InScope(pkList);
     * cb.query().addOrderBy_BrowserTypeId_Asc();
     * </pre>
     * @param browserTypeList The entity list of browserType. (NotNull)
     * @param conditionBeanSetupper The instance of referrer condition-bean set-upper for registering referrer condition. (NotNull)
     */
    public void loadFileConfigToBrowserTypeMappingList(
            final List<BrowserType> browserTypeList,
            final ConditionBeanSetupper<FileConfigToBrowserTypeMappingCB> conditionBeanSetupper) {
        xassLRArg(browserTypeList, conditionBeanSetupper);
        loadFileConfigToBrowserTypeMappingList(
                browserTypeList,
                new LoadReferrerOption<FileConfigToBrowserTypeMappingCB, FileConfigToBrowserTypeMapping>()
                        .xinit(conditionBeanSetupper));
    }

    /**
     * {Refer to overload method that has an argument of the list of entity.}
     * @param browserType The entity of browserType. (NotNull)
     * @param loadReferrerOption The option of load-referrer. (NotNull)
     */
    public void loadFileConfigToBrowserTypeMappingList(
            final BrowserType browserType,
            final LoadReferrerOption<FileConfigToBrowserTypeMappingCB, FileConfigToBrowserTypeMapping> loadReferrerOption) {
        xassLRArg(browserType, loadReferrerOption);
        loadFileConfigToBrowserTypeMappingList(xnewLRLs(browserType),
                loadReferrerOption);
    }

    /**
     * {Refer to overload method that has an argument of condition-bean setupper.}
     * @param browserTypeList The entity list of browserType. (NotNull)
     * @param loadReferrerOption The option of load-referrer. (NotNull)
     */
    public void loadFileConfigToBrowserTypeMappingList(
            final List<BrowserType> browserTypeList,
            final LoadReferrerOption<FileConfigToBrowserTypeMappingCB, FileConfigToBrowserTypeMapping> loadReferrerOption) {
        xassLRArg(browserTypeList, loadReferrerOption);
        if (browserTypeList.isEmpty()) {
            return;
        }
        final FileConfigToBrowserTypeMappingBhv referrerBhv = xgetBSFLR()
                .select(FileConfigToBrowserTypeMappingBhv.class);
        helpLoadReferrerInternally(
                browserTypeList,
                loadReferrerOption,
                new InternalLoadReferrerCallback<BrowserType, Long, FileConfigToBrowserTypeMappingCB, FileConfigToBrowserTypeMapping>() {
                    @Override
                    public Long getPKVal(final BrowserType e) {
                        return e.getId();
                    }

                    @Override
                    public void setRfLs(final BrowserType e,
                            final List<FileConfigToBrowserTypeMapping> ls) {
                        e.setFileConfigToBrowserTypeMappingList(ls);
                    }

                    @Override
                    public FileConfigToBrowserTypeMappingCB newMyCB() {
                        return referrerBhv.newMyConditionBean();
                    }

                    @Override
                    public void qyFKIn(
                            final FileConfigToBrowserTypeMappingCB cb,
                            final List<Long> ls) {
                        cb.query().setBrowserTypeId_InScope(ls);
                    }

                    @Override
                    public void qyOdFKAsc(
                            final FileConfigToBrowserTypeMappingCB cb) {
                        cb.query().addOrderBy_BrowserTypeId_Asc();
                    }

                    @Override
                    public void spFKCol(
                            final FileConfigToBrowserTypeMappingCB cb) {
                        cb.specify().columnBrowserTypeId();
                    }

                    @Override
                    public List<FileConfigToBrowserTypeMapping> selRfLs(
                            final FileConfigToBrowserTypeMappingCB cb) {
                        return referrerBhv.selectList(cb);
                    }

                    @Override
                    public Long getFKVal(final FileConfigToBrowserTypeMapping e) {
                        return e.getBrowserTypeId();
                    }

                    @Override
                    public void setlcEt(
                            final FileConfigToBrowserTypeMapping re,
                            final BrowserType le) {
                        re.setBrowserType(le);
                    }

                    @Override
                    public String getRfPrNm() {
                        return "fileConfigToBrowserTypeMappingList";
                    }
                });
    }

    /**
     * {Refer to overload method that has an argument of the list of entity.}
     * @param browserType The entity of browserType. (NotNull)
     * @param conditionBeanSetupper The instance of referrer condition-bean set-upper for registering referrer condition. (NotNull)
     */
    public void loadWebConfigToBrowserTypeMappingList(
            final BrowserType browserType,
            final ConditionBeanSetupper<WebConfigToBrowserTypeMappingCB> conditionBeanSetupper) {
        xassLRArg(browserType, conditionBeanSetupper);
        loadWebConfigToBrowserTypeMappingList(xnewLRLs(browserType),
                conditionBeanSetupper);
    }

    /**
     * Load referrer of webConfigToBrowserTypeMappingList with the set-upper for condition-bean of referrer. <br />
     * WEB_CONFIG_TO_BROWSER_TYPE_MAPPING by your BROWSER_TYPE_ID, named 'webConfigToBrowserTypeMappingList'.
     * <pre>
     * browserTypeBhv.<span style="color: #FD4747">loadWebConfigToBrowserTypeMappingList</span>(browserTypeList, new ConditionBeanSetupper&lt;WebConfigToBrowserTypeMappingCB&gt;() {
     *     public void setup(WebConfigToBrowserTypeMappingCB cb) {
     *         cb.setupSelect...();
     *         cb.query().setFoo...(value);
     *         cb.query().addOrderBy_Bar...(); <span style="color: #3F7E5E">// basically you should order referrer list</span>
     *     }
     * });
     * for (BrowserType browserType : browserTypeList) {
     *     ... = browserType.<span style="color: #FD4747">getWebConfigToBrowserTypeMappingList()</span>;
     * }
     * </pre>
     * About internal policy, the value of primary key(and others too) is treated as case-insensitive. <br />
     * The condition-bean that the set-upper provides have settings before you touch it. It is as follows:
     * <pre>
     * cb.query().setBrowserTypeId_InScope(pkList);
     * cb.query().addOrderBy_BrowserTypeId_Asc();
     * </pre>
     * @param browserTypeList The entity list of browserType. (NotNull)
     * @param conditionBeanSetupper The instance of referrer condition-bean set-upper for registering referrer condition. (NotNull)
     */
    public void loadWebConfigToBrowserTypeMappingList(
            final List<BrowserType> browserTypeList,
            final ConditionBeanSetupper<WebConfigToBrowserTypeMappingCB> conditionBeanSetupper) {
        xassLRArg(browserTypeList, conditionBeanSetupper);
        loadWebConfigToBrowserTypeMappingList(
                browserTypeList,
                new LoadReferrerOption<WebConfigToBrowserTypeMappingCB, WebConfigToBrowserTypeMapping>()
                        .xinit(conditionBeanSetupper));
    }

    /**
     * {Refer to overload method that has an argument of the list of entity.}
     * @param browserType The entity of browserType. (NotNull)
     * @param loadReferrerOption The option of load-referrer. (NotNull)
     */
    public void loadWebConfigToBrowserTypeMappingList(
            final BrowserType browserType,
            final LoadReferrerOption<WebConfigToBrowserTypeMappingCB, WebConfigToBrowserTypeMapping> loadReferrerOption) {
        xassLRArg(browserType, loadReferrerOption);
        loadWebConfigToBrowserTypeMappingList(xnewLRLs(browserType),
                loadReferrerOption);
    }

    /**
     * {Refer to overload method that has an argument of condition-bean setupper.}
     * @param browserTypeList The entity list of browserType. (NotNull)
     * @param loadReferrerOption The option of load-referrer. (NotNull)
     */
    public void loadWebConfigToBrowserTypeMappingList(
            final List<BrowserType> browserTypeList,
            final LoadReferrerOption<WebConfigToBrowserTypeMappingCB, WebConfigToBrowserTypeMapping> loadReferrerOption) {
        xassLRArg(browserTypeList, loadReferrerOption);
        if (browserTypeList.isEmpty()) {
            return;
        }
        final WebConfigToBrowserTypeMappingBhv referrerBhv = xgetBSFLR()
                .select(WebConfigToBrowserTypeMappingBhv.class);
        helpLoadReferrerInternally(
                browserTypeList,
                loadReferrerOption,
                new InternalLoadReferrerCallback<BrowserType, Long, WebConfigToBrowserTypeMappingCB, WebConfigToBrowserTypeMapping>() {
                    @Override
                    public Long getPKVal(final BrowserType e) {
                        return e.getId();
                    }

                    @Override
                    public void setRfLs(final BrowserType e,
                            final List<WebConfigToBrowserTypeMapping> ls) {
                        e.setWebConfigToBrowserTypeMappingList(ls);
                    }

                    @Override
                    public WebConfigToBrowserTypeMappingCB newMyCB() {
                        return referrerBhv.newMyConditionBean();
                    }

                    @Override
                    public void qyFKIn(
                            final WebConfigToBrowserTypeMappingCB cb,
                            final List<Long> ls) {
                        cb.query().setBrowserTypeId_InScope(ls);
                    }

                    @Override
                    public void qyOdFKAsc(
                            final WebConfigToBrowserTypeMappingCB cb) {
                        cb.query().addOrderBy_BrowserTypeId_Asc();
                    }

                    @Override
                    public void spFKCol(final WebConfigToBrowserTypeMappingCB cb) {
                        cb.specify().columnBrowserTypeId();
                    }

                    @Override
                    public List<WebConfigToBrowserTypeMapping> selRfLs(
                            final WebConfigToBrowserTypeMappingCB cb) {
                        return referrerBhv.selectList(cb);
                    }

                    @Override
                    public Long getFKVal(final WebConfigToBrowserTypeMapping e) {
                        return e.getBrowserTypeId();
                    }

                    @Override
                    public void setlcEt(final WebConfigToBrowserTypeMapping re,
                            final BrowserType le) {
                        re.setBrowserType(le);
                    }

                    @Override
                    public String getRfPrNm() {
                        return "webConfigToBrowserTypeMappingList";
                    }
                });
    }

    // ===================================================================================
    //                                                                    Pull out Foreign
    //                                                                    ================

    // ===================================================================================
    //                                                                       Entity Update
    //                                                                       =============
    /**
     * Insert the entity.
     * <pre>
     * BrowserType browserType = new BrowserType();
     * <span style="color: #3F7E5E">// if auto-increment, you don't need to set the PK value</span>
     * browserType.setFoo...(value);
     * browserType.setBar...(value);
     * <span style="color: #3F7E5E">// you don't need to set values of common columns</span>
     * <span style="color: #3F7E5E">//browserType.setRegisterUser(value);</span>
     * <span style="color: #3F7E5E">//browserType.set...;</span>
     * browserTypeBhv.<span style="color: #FD4747">insert</span>(browserType);
     * ... = browserType.getPK...(); <span style="color: #3F7E5E">// if auto-increment, you can get the value after</span>
     * </pre>
     * @param browserType The entity of insert target. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void insert(final BrowserType browserType) {
        doInsert(browserType, null);
    }

    protected void doInsert(final BrowserType browserType,
            final InsertOption<BrowserTypeCB> option) {
        assertObjectNotNull("browserType", browserType);
        prepareInsertOption(option);
        delegateInsert(browserType, option);
    }

    protected void prepareInsertOption(final InsertOption<BrowserTypeCB> option) {
        if (option == null) {
            return;
        }
        assertInsertOptionStatus(option);
    }

    @Override
    protected void doCreate(final Entity entity,
            final InsertOption<? extends ConditionBean> option) {
        if (option == null) {
            insert(downcast(entity));
        } else {
            varyingInsert(downcast(entity), downcast(option));
        }
    }

    /**
     * Update the entity modified-only. {UpdateCountZeroException, ExclusiveControl}
     * <pre>
     * BrowserType browserType = new BrowserType();
     * browserType.setPK...(value); <span style="color: #3F7E5E">// required</span>
     * browserType.setFoo...(value); <span style="color: #3F7E5E">// you should set only modified columns</span>
     * <span style="color: #3F7E5E">// you don't need to set values of common columns</span>
     * <span style="color: #3F7E5E">//browserType.setRegisterUser(value);</span>
     * <span style="color: #3F7E5E">//browserType.set...;</span>
     * <span style="color: #3F7E5E">// if exclusive control, the value of exclusive control column is required</span>
     * browserType.<span style="color: #FD4747">setVersionNo</span>(value);
     * try {
     *     browserTypeBhv.<span style="color: #FD4747">update</span>(browserType);
     * } catch (EntityAlreadyUpdatedException e) { <span style="color: #3F7E5E">// if concurrent update</span>
     *     ...
     * } 
     * </pre>
     * @param browserType The entity of update target. (NotNull) {PrimaryKeyRequired, ConcurrencyColumnRequired}
     * @exception org.seasar.dbflute.exception.EntityAlreadyUpdatedException When the entity has already been updated.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void update(final BrowserType browserType) {
        doUpdate(browserType, null);
    }

    protected void doUpdate(final BrowserType browserType,
            final UpdateOption<BrowserTypeCB> option) {
        assertObjectNotNull("browserType", browserType);
        prepareUpdateOption(option);
        helpUpdateInternally(browserType,
                new InternalUpdateCallback<BrowserType>() {
                    @Override
                    public int callbackDelegateUpdate(final BrowserType entity) {
                        return delegateUpdate(entity, option);
                    }
                });
    }

    protected void prepareUpdateOption(final UpdateOption<BrowserTypeCB> option) {
        if (option == null) {
            return;
        }
        assertUpdateOptionStatus(option);
        if (option.hasSelfSpecification()) {
            option.resolveSelfSpecification(createCBForVaryingUpdate());
        }
        if (option.hasSpecifiedUpdateColumn()) {
            option.resolveUpdateColumnSpecification(createCBForSpecifiedUpdate());
        }
    }

    protected BrowserTypeCB createCBForVaryingUpdate() {
        final BrowserTypeCB cb = newMyConditionBean();
        cb.xsetupForVaryingUpdate();
        return cb;
    }

    protected BrowserTypeCB createCBForSpecifiedUpdate() {
        final BrowserTypeCB cb = newMyConditionBean();
        cb.xsetupForSpecifiedUpdate();
        return cb;
    }

    @Override
    protected void doModify(final Entity entity,
            final UpdateOption<? extends ConditionBean> option) {
        if (option == null) {
            update(downcast(entity));
        } else {
            varyingUpdate(downcast(entity), downcast(option));
        }
    }

    /**
     * Update the entity non-strictly modified-only. {UpdateCountZeroException, NonExclusiveControl}
     * <pre>
     * BrowserType browserType = new BrowserType();
     * browserType.setPK...(value); <span style="color: #3F7E5E">// required</span>
     * browserType.setFoo...(value); <span style="color: #3F7E5E">// you should set only modified columns</span>
     * <span style="color: #3F7E5E">// you don't need to set values of common columns</span>
     * <span style="color: #3F7E5E">//browserType.setRegisterUser(value);</span>
     * <span style="color: #3F7E5E">//browserType.set...;</span>
     * <span style="color: #3F7E5E">// you don't need to set a value of exclusive control column</span>
     * <span style="color: #3F7E5E">// (auto-increment for version number is valid though non-exclusive control)</span>
     * <span style="color: #3F7E5E">//browserType.setVersionNo(value);</span>
     * browserTypeBhv.<span style="color: #FD4747">updateNonstrict</span>(browserType);
     * </pre>
     * @param browserType The entity of update target. (NotNull) {PrimaryKeyRequired}
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void updateNonstrict(final BrowserType browserType) {
        doUpdateNonstrict(browserType, null);
    }

    protected void doUpdateNonstrict(final BrowserType browserType,
            final UpdateOption<BrowserTypeCB> option) {
        assertObjectNotNull("browserType", browserType);
        prepareUpdateOption(option);
        helpUpdateNonstrictInternally(browserType,
                new InternalUpdateNonstrictCallback<BrowserType>() {
                    @Override
                    public int callbackDelegateUpdateNonstrict(
                            final BrowserType entity) {
                        return delegateUpdateNonstrict(entity, option);
                    }
                });
    }

    @Override
    protected void doModifyNonstrict(final Entity entity,
            final UpdateOption<? extends ConditionBean> option) {
        if (option == null) {
            updateNonstrict(downcast(entity));
        } else {
            varyingUpdateNonstrict(downcast(entity), downcast(option));
        }
    }

    /**
     * Insert or update the entity modified-only. {ExclusiveControl(when update)}
     * @param browserType The entity of insert or update target. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyUpdatedException When the entity has already been updated.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void insertOrUpdate(final BrowserType browserType) {
        doInesrtOrUpdate(browserType, null, null);
    }

    protected void doInesrtOrUpdate(final BrowserType browserType,
            final InsertOption<BrowserTypeCB> insertOption,
            final UpdateOption<BrowserTypeCB> updateOption) {
        helpInsertOrUpdateInternally(
                browserType,
                new InternalInsertOrUpdateCallback<BrowserType, BrowserTypeCB>() {
                    @Override
                    public void callbackInsert(final BrowserType entity) {
                        doInsert(entity, insertOption);
                    }

                    @Override
                    public void callbackUpdate(final BrowserType entity) {
                        doUpdate(entity, updateOption);
                    }

                    @Override
                    public BrowserTypeCB callbackNewMyConditionBean() {
                        return newMyConditionBean();
                    }

                    @Override
                    public int callbackSelectCount(final BrowserTypeCB cb) {
                        return selectCount(cb);
                    }
                });
    }

    @Override
    protected void doCreateOrModify(final Entity entity,
            InsertOption<? extends ConditionBean> insertOption,
            UpdateOption<? extends ConditionBean> updateOption) {
        if (insertOption == null && updateOption == null) {
            insertOrUpdate(downcast(entity));
        } else {
            insertOption = insertOption == null ? new InsertOption<BrowserTypeCB>()
                    : insertOption;
            updateOption = updateOption == null ? new UpdateOption<BrowserTypeCB>()
                    : updateOption;
            varyingInsertOrUpdate(downcast(entity), downcast(insertOption),
                    downcast(updateOption));
        }
    }

    /**
     * Insert or update the entity non-strictly modified-only. {NonExclusiveControl(when update)}
     * @param browserType The entity of insert or update target. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void insertOrUpdateNonstrict(final BrowserType browserType) {
        doInesrtOrUpdateNonstrict(browserType, null, null);
    }

    protected void doInesrtOrUpdateNonstrict(final BrowserType browserType,
            final InsertOption<BrowserTypeCB> insertOption,
            final UpdateOption<BrowserTypeCB> updateOption) {
        helpInsertOrUpdateInternally(browserType,
                new InternalInsertOrUpdateNonstrictCallback<BrowserType>() {
                    @Override
                    public void callbackInsert(final BrowserType entity) {
                        doInsert(entity, insertOption);
                    }

                    @Override
                    public void callbackUpdateNonstrict(final BrowserType entity) {
                        doUpdateNonstrict(entity, updateOption);
                    }
                });
    }

    @Override
    protected void doCreateOrModifyNonstrict(final Entity entity,
            InsertOption<? extends ConditionBean> insertOption,
            UpdateOption<? extends ConditionBean> updateOption) {
        if (insertOption == null && updateOption == null) {
            insertOrUpdateNonstrict(downcast(entity));
        } else {
            insertOption = insertOption == null ? new InsertOption<BrowserTypeCB>()
                    : insertOption;
            updateOption = updateOption == null ? new UpdateOption<BrowserTypeCB>()
                    : updateOption;
            varyingInsertOrUpdateNonstrict(downcast(entity),
                    downcast(insertOption), downcast(updateOption));
        }
    }

    /**
     * Delete the entity. {UpdateCountZeroException, ExclusiveControl}
     * <pre>
     * BrowserType browserType = new BrowserType();
     * browserType.setPK...(value); <span style="color: #3F7E5E">// required</span>
     * <span style="color: #3F7E5E">// if exclusive control, the value of exclusive control column is required</span>
     * browserType.<span style="color: #FD4747">setVersionNo</span>(value);
     * try {
     *     browserTypeBhv.<span style="color: #FD4747">delete</span>(browserType);
     * } catch (EntityAlreadyUpdatedException e) { <span style="color: #3F7E5E">// if concurrent update</span>
     *     ...
     * } 
     * </pre>
     * @param browserType The entity of delete target. (NotNull) {PrimaryKeyRequired, ConcurrencyColumnRequired}
     * @exception org.seasar.dbflute.exception.EntityAlreadyUpdatedException When the entity has already been updated.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     */
    public void delete(final BrowserType browserType) {
        doDelete(browserType, null);
    }

    protected void doDelete(final BrowserType browserType,
            final DeleteOption<BrowserTypeCB> option) {
        assertObjectNotNull("browserType", browserType);
        prepareDeleteOption(option);
        helpDeleteInternally(browserType,
                new InternalDeleteCallback<BrowserType>() {
                    @Override
                    public int callbackDelegateDelete(final BrowserType entity) {
                        return delegateDelete(entity, option);
                    }
                });
    }

    protected void prepareDeleteOption(final DeleteOption<BrowserTypeCB> option) {
        if (option == null) {
            return;
        }
        assertDeleteOptionStatus(option);
    }

    @Override
    protected void doRemove(final Entity entity,
            final DeleteOption<? extends ConditionBean> option) {
        if (option == null) {
            delete(downcast(entity));
        } else {
            varyingDelete(downcast(entity), downcast(option));
        }
    }

    /**
     * Delete the entity non-strictly. {UpdateCountZeroException, NonExclusiveControl}
     * <pre>
     * BrowserType browserType = new BrowserType();
     * browserType.setPK...(value); <span style="color: #3F7E5E">// required</span>
     * <span style="color: #3F7E5E">// you don't need to set a value of exclusive control column</span>
     * <span style="color: #3F7E5E">// (auto-increment for version number is valid though non-exclusive control)</span>
     * <span style="color: #3F7E5E">//browserType.setVersionNo(value);</span>
     * browserTypeBhv.<span style="color: #FD4747">deleteNonstrict</span>(browserType);
     * </pre>
     * @param browserType The entity of delete target. (NotNull) {PrimaryKeyRequired}
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     */
    public void deleteNonstrict(final BrowserType browserType) {
        doDeleteNonstrict(browserType, null);
    }

    protected void doDeleteNonstrict(final BrowserType browserType,
            final DeleteOption<BrowserTypeCB> option) {
        assertObjectNotNull("browserType", browserType);
        prepareDeleteOption(option);
        helpDeleteNonstrictInternally(browserType,
                new InternalDeleteNonstrictCallback<BrowserType>() {
                    @Override
                    public int callbackDelegateDeleteNonstrict(
                            final BrowserType entity) {
                        return delegateDeleteNonstrict(entity, option);
                    }
                });
    }

    /**
     * Delete the entity non-strictly ignoring deleted. {UpdateCountZeroException, NonExclusiveControl}
     * <pre>
     * BrowserType browserType = new BrowserType();
     * browserType.setPK...(value); <span style="color: #3F7E5E">// required</span>
     * <span style="color: #3F7E5E">// you don't need to set a value of exclusive control column</span>
     * <span style="color: #3F7E5E">// (auto-increment for version number is valid though non-exclusive control)</span>
     * <span style="color: #3F7E5E">//browserType.setVersionNo(value);</span>
     * browserTypeBhv.<span style="color: #FD4747">deleteNonstrictIgnoreDeleted</span>(browserType);
     * <span style="color: #3F7E5E">// if the target entity doesn't exist, no exception</span>
     * </pre>
     * @param browserType The entity of delete target. (NotNull) {PrimaryKeyRequired}
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     */
    public void deleteNonstrictIgnoreDeleted(final BrowserType browserType) {
        doDeleteNonstrictIgnoreDeleted(browserType, null);
    }

    protected void doDeleteNonstrictIgnoreDeleted(
            final BrowserType browserType,
            final DeleteOption<BrowserTypeCB> option) {
        assertObjectNotNull("browserType", browserType);
        prepareDeleteOption(option);
        helpDeleteNonstrictIgnoreDeletedInternally(
                browserType,
                new InternalDeleteNonstrictIgnoreDeletedCallback<BrowserType>() {
                    @Override
                    public int callbackDelegateDeleteNonstrict(
                            final BrowserType entity) {
                        return delegateDeleteNonstrict(entity, option);
                    }
                });
    }

    @Override
    protected void doRemoveNonstrict(final Entity entity,
            final DeleteOption<? extends ConditionBean> option) {
        if (option == null) {
            deleteNonstrict(downcast(entity));
        } else {
            varyingDeleteNonstrict(downcast(entity), downcast(option));
        }
    }

    // ===================================================================================
    //                                                                        Batch Update
    //                                                                        ============
    /**
     * Batch-insert the list. <br />
     * This method uses 'Batch Update' of java.sql.PreparedStatement. <br />
     * All columns are insert target. (so default constraints are not available) <br />
     * And if the table has an identity, entities after the process do not have incremented values.
     * (When you use the (normal) insert(), an entity after the process has an incremented value)
     * @param browserTypeList The list of the entity. (NotNull)
     * @return The array of inserted count.
     */
    public int[] batchInsert(final List<BrowserType> browserTypeList) {
        return doBatchInsert(browserTypeList, null);
    }

    protected int[] doBatchInsert(final List<BrowserType> browserTypeList,
            final InsertOption<BrowserTypeCB> option) {
        assertObjectNotNull("browserTypeList", browserTypeList);
        prepareInsertOption(option);
        return delegateBatchInsert(browserTypeList, option);
    }

    @Override
    protected int[] doLumpCreate(final List<Entity> ls,
            final InsertOption<? extends ConditionBean> option) {
        if (option == null) {
            return batchInsert(downcast(ls));
        } else {
            return varyingBatchInsert(downcast(ls), downcast(option));
        }
    }

    /**
     * Batch-update the list. <br />
     * This method uses 'Batch Update' of java.sql.PreparedStatement. <br />
     * All columns are update target. {NOT modified only}
     * @param browserTypeList The list of the entity. (NotNull)
     * @return The array of updated count.
     * @exception org.seasar.dbflute.exception.BatchEntityAlreadyUpdatedException When the entity has already been updated. This exception extends EntityAlreadyUpdatedException.
     */
    public int[] batchUpdate(final List<BrowserType> browserTypeList) {
        return doBatchUpdate(browserTypeList, null);
    }

    protected int[] doBatchUpdate(final List<BrowserType> browserTypeList,
            final UpdateOption<BrowserTypeCB> option) {
        assertObjectNotNull("browserTypeList", browserTypeList);
        prepareUpdateOption(option);
        return delegateBatchUpdate(browserTypeList, option);
    }

    @Override
    protected int[] doLumpModify(final List<Entity> ls,
            final UpdateOption<? extends ConditionBean> option) {
        if (option == null) {
            return batchUpdate(downcast(ls));
        } else {
            return varyingBatchUpdate(downcast(ls), downcast(option));
        }
    }

    /**
     * Batch-update the list. <br />
     * This method uses 'Batch Update' of java.sql.PreparedStatement. <br />
     * You can specify update columns used on set clause of update statement.
     * However you do not need to specify common columns for update
     * and an optimistick lock column because they are specified implicitly.
     * @param browserTypeList The list of the entity. (NotNull)
     * @param updateColumnSpec The specification of update columns. (NotNull)
     * @return The array of updated count.
     * @exception org.seasar.dbflute.exception.BatchEntityAlreadyUpdatedException When the entity has already been updated. This exception extends EntityAlreadyUpdatedException.
     */
    public int[] batchUpdate(final List<BrowserType> browserTypeList,
            final SpecifyQuery<BrowserTypeCB> updateColumnSpec) {
        return doBatchUpdate(browserTypeList,
                createSpecifiedUpdateOption(updateColumnSpec));
    }

    /**
     * Batch-update the list non-strictly. <br />
     * This method uses 'Batch Update' of java.sql.PreparedStatement. <br />
     * All columns are update target. {NOT modified only}
     * @param browserTypeList The list of the entity. (NotNull)
     * @return The array of updated count.
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     */
    public int[] batchUpdateNonstrict(final List<BrowserType> browserTypeList) {
        return doBatchUpdateNonstrict(browserTypeList, null);
    }

    protected int[] doBatchUpdateNonstrict(
            final List<BrowserType> browserTypeList,
            final UpdateOption<BrowserTypeCB> option) {
        assertObjectNotNull("browserTypeList", browserTypeList);
        prepareUpdateOption(option);
        return delegateBatchUpdateNonstrict(browserTypeList, option);
    }

    /**
     * Batch-update the list non-strictly. <br />
     * This method uses 'Batch Update' of java.sql.PreparedStatement. <br />
     * You can specify update columns used on set clause of update statement.
     * However you do not need to specify common columns for update
     * and an optimistick lock column because they are specified implicitly.
     * @param browserTypeList The list of the entity. (NotNull)
     * @param updateColumnSpec The specification of update columns. (NotNull)
     * @return The array of updated count.
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     */
    public int[] batchUpdateNonstrict(final List<BrowserType> browserTypeList,
            final SpecifyQuery<BrowserTypeCB> updateColumnSpec) {
        return doBatchUpdateNonstrict(browserTypeList,
                createSpecifiedUpdateOption(updateColumnSpec));
    }

    @Override
    protected int[] doLumpModifyNonstrict(final List<Entity> ls,
            final UpdateOption<? extends ConditionBean> option) {
        if (option == null) {
            return batchUpdateNonstrict(downcast(ls));
        } else {
            return varyingBatchUpdateNonstrict(downcast(ls), downcast(option));
        }
    }

    /**
     * Batch-delete the list. <br />
     * This method uses 'Batch Update' of java.sql.PreparedStatement.
     * @param browserTypeList The list of the entity. (NotNull)
     * @return The array of deleted count.
     * @exception org.seasar.dbflute.exception.BatchEntityAlreadyUpdatedException When the entity has already been updated. This exception extends EntityAlreadyUpdatedException.
     */
    public int[] batchDelete(final List<BrowserType> browserTypeList) {
        return doBatchDelete(browserTypeList, null);
    }

    protected int[] doBatchDelete(final List<BrowserType> browserTypeList,
            final DeleteOption<BrowserTypeCB> option) {
        assertObjectNotNull("browserTypeList", browserTypeList);
        prepareDeleteOption(option);
        return delegateBatchDelete(browserTypeList, option);
    }

    @Override
    protected int[] doLumpRemove(final List<Entity> ls,
            final DeleteOption<? extends ConditionBean> option) {
        if (option == null) {
            return batchDelete(downcast(ls));
        } else {
            return varyingBatchDelete(downcast(ls), downcast(option));
        }
    }

    /**
     * Batch-delete the list non-strictly. <br />
     * This method uses 'Batch Update' of java.sql.PreparedStatement.
     * @param browserTypeList The list of the entity. (NotNull)
     * @return The array of deleted count.
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     */
    public int[] batchDeleteNonstrict(final List<BrowserType> browserTypeList) {
        return doBatchDeleteNonstrict(browserTypeList, null);
    }

    protected int[] doBatchDeleteNonstrict(
            final List<BrowserType> browserTypeList,
            final DeleteOption<BrowserTypeCB> option) {
        assertObjectNotNull("browserTypeList", browserTypeList);
        prepareDeleteOption(option);
        return delegateBatchDeleteNonstrict(browserTypeList, option);
    }

    @Override
    protected int[] doLumpRemoveNonstrict(final List<Entity> ls,
            final DeleteOption<? extends ConditionBean> option) {
        if (option == null) {
            return batchDeleteNonstrict(downcast(ls));
        } else {
            return varyingBatchDeleteNonstrict(downcast(ls), downcast(option));
        }
    }

    // ===================================================================================
    //                                                                        Query Update
    //                                                                        ============
    /**
     * Insert the several entities by query (modified-only for fixed value).
     * <pre>
     * browserTypeBhv.<span style="color: #FD4747">queryInsert</span>(new QueryInsertSetupper&lt;BrowserType, BrowserTypeCB&gt;() {
     *     public ConditionBean setup(browserType entity, BrowserTypeCB intoCB) {
     *         FooCB cb = FooCB();
     *         cb.setupSelect_Bar();
     * 
     *         <span style="color: #3F7E5E">// mapping</span>
     *         intoCB.specify().columnMyName().mappedFrom(cb.specify().columnFooName());
     *         intoCB.specify().columnMyCount().mappedFrom(cb.specify().columnFooCount());
     *         intoCB.specify().columnMyDate().mappedFrom(cb.specify().specifyBar().columnBarDate());
     *         entity.setMyFixedValue("foo"); <span style="color: #3F7E5E">// fixed value</span>
     *         <span style="color: #3F7E5E">// you don't need to set values of common columns</span>
     *         <span style="color: #3F7E5E">//entity.setRegisterUser(value);</span>
     *         <span style="color: #3F7E5E">//entity.set...;</span>
     *         <span style="color: #3F7E5E">// you don't need to set a value of exclusive control column</span>
     *         <span style="color: #3F7E5E">//entity.setVersionNo(value);</span>
     * 
     *         return cb;
     *     }
     * });
     * </pre>
     * @param setupper The setup-per of query-insert. (NotNull)
     * @return The inserted count.
     */
    public int queryInsert(
            final QueryInsertSetupper<BrowserType, BrowserTypeCB> setupper) {
        return doQueryInsert(setupper, null);
    }

    protected int doQueryInsert(
            final QueryInsertSetupper<BrowserType, BrowserTypeCB> setupper,
            final InsertOption<BrowserTypeCB> option) {
        assertObjectNotNull("setupper", setupper);
        prepareInsertOption(option);
        final BrowserType entity = new BrowserType();
        final BrowserTypeCB intoCB = createCBForQueryInsert();
        final ConditionBean resourceCB = setupper.setup(entity, intoCB);
        return delegateQueryInsert(entity, intoCB, resourceCB, option);
    }

    protected BrowserTypeCB createCBForQueryInsert() {
        final BrowserTypeCB cb = newMyConditionBean();
        cb.xsetupForQueryInsert();
        return cb;
    }

    @Override
    protected int doRangeCreate(
            final QueryInsertSetupper<? extends Entity, ? extends ConditionBean> setupper,
            final InsertOption<? extends ConditionBean> option) {
        if (option == null) {
            return queryInsert(downcast(setupper));
        } else {
            return varyingQueryInsert(downcast(setupper), downcast(option));
        }
    }

    /**
     * Update the several entities by query non-strictly modified-only. {NonExclusiveControl}
     * <pre>
     * BrowserType browserType = new BrowserType();
     * <span style="color: #3F7E5E">// you don't need to set PK value</span>
     * <span style="color: #3F7E5E">//browserType.setPK...(value);</span>
     * browserType.setFoo...(value); <span style="color: #3F7E5E">// you should set only modified columns</span>
     * <span style="color: #3F7E5E">// you don't need to set values of common columns</span>
     * <span style="color: #3F7E5E">//browserType.setRegisterUser(value);</span>
     * <span style="color: #3F7E5E">//browserType.set...;</span>
     * <span style="color: #3F7E5E">// you don't need to set a value of exclusive control column</span>
     * <span style="color: #3F7E5E">// (auto-increment for version number is valid though non-exclusive control)</span>
     * <span style="color: #3F7E5E">//browserType.setVersionNo(value);</span>
     * BrowserTypeCB cb = new BrowserTypeCB();
     * cb.query().setFoo...(value);
     * browserTypeBhv.<span style="color: #FD4747">queryUpdate</span>(browserType, cb);
     * </pre>
     * @param browserType The entity that contains update values. (NotNull, PrimaryKeyNullAllowed)
     * @param cb The condition-bean of BrowserType. (NotNull)
     * @return The updated count.
     * @exception org.seasar.dbflute.exception.NonQueryUpdateNotAllowedException When the query has no condition.
     */
    public int queryUpdate(final BrowserType browserType, final BrowserTypeCB cb) {
        return doQueryUpdate(browserType, cb, null);
    }

    protected int doQueryUpdate(final BrowserType browserType,
            final BrowserTypeCB cb, final UpdateOption<BrowserTypeCB> option) {
        assertObjectNotNull("browserType", browserType);
        assertCBStateValid(cb);
        prepareUpdateOption(option);
        return delegateQueryUpdate(browserType, cb, option);
    }

    @Override
    protected int doRangeModify(final Entity entity, final ConditionBean cb,
            final UpdateOption<? extends ConditionBean> option) {
        if (option == null) {
            return queryUpdate(downcast(entity), (BrowserTypeCB) cb);
        } else {
            return varyingQueryUpdate(downcast(entity), (BrowserTypeCB) cb,
                    downcast(option));
        }
    }

    /**
     * Delete the several entities by query. {NonExclusiveControl}
     * <pre>
     * BrowserTypeCB cb = new BrowserTypeCB();
     * cb.query().setFoo...(value);
     * browserTypeBhv.<span style="color: #FD4747">queryDelete</span>(browserType, cb);
     * </pre>
     * @param cb The condition-bean of BrowserType. (NotNull)
     * @return The deleted count.
     * @exception org.seasar.dbflute.exception.NonQueryDeleteNotAllowedException When the query has no condition.
     */
    public int queryDelete(final BrowserTypeCB cb) {
        return doQueryDelete(cb, null);
    }

    protected int doQueryDelete(final BrowserTypeCB cb,
            final DeleteOption<BrowserTypeCB> option) {
        assertCBStateValid(cb);
        prepareDeleteOption(option);
        return delegateQueryDelete(cb, option);
    }

    @Override
    protected int doRangeRemove(final ConditionBean cb,
            final DeleteOption<? extends ConditionBean> option) {
        if (option == null) {
            return queryDelete((BrowserTypeCB) cb);
        } else {
            return varyingQueryDelete((BrowserTypeCB) cb, downcast(option));
        }
    }

    // ===================================================================================
    //                                                                      Varying Update
    //                                                                      ==============
    // -----------------------------------------------------
    //                                         Entity Update
    //                                         -------------
    /**
     * Insert the entity with varying requests. <br />
     * For example, disableCommonColumnAutoSetup(), disablePrimaryKeyIdentity(). <br />
     * Other specifications are same as insert(entity).
     * <pre>
     * BrowserType browserType = new BrowserType();
     * <span style="color: #3F7E5E">// if auto-increment, you don't need to set the PK value</span>
     * browserType.setFoo...(value);
     * browserType.setBar...(value);
     * InsertOption<BrowserTypeCB> option = new InsertOption<BrowserTypeCB>();
     * <span style="color: #3F7E5E">// you can insert by your values for common columns</span>
     * option.disableCommonColumnAutoSetup();
     * browserTypeBhv.<span style="color: #FD4747">varyingInsert</span>(browserType, option);
     * ... = browserType.getPK...(); <span style="color: #3F7E5E">// if auto-increment, you can get the value after</span>
     * </pre>
     * @param browserType The entity of insert target. (NotNull)
     * @param option The option of insert for varying requests. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void varyingInsert(final BrowserType browserType,
            final InsertOption<BrowserTypeCB> option) {
        assertInsertOptionNotNull(option);
        doInsert(browserType, option);
    }

    /**
     * Update the entity with varying requests modified-only. {UpdateCountZeroException, ExclusiveControl} <br />
     * For example, self(selfCalculationSpecification), specify(updateColumnSpecification), disableCommonColumnAutoSetup(). <br />
     * Other specifications are same as update(entity).
     * <pre>
     * BrowserType browserType = new BrowserType();
     * browserType.setPK...(value); <span style="color: #3F7E5E">// required</span>
     * browserType.setOther...(value); <span style="color: #3F7E5E">// you should set only modified columns</span>
     * <span style="color: #3F7E5E">// if exclusive control, the value of exclusive control column is required</span>
     * browserType.<span style="color: #FD4747">setVersionNo</span>(value);
     * try {
     *     <span style="color: #3F7E5E">// you can update by self calculation values</span>
     *     UpdateOption&lt;BrowserTypeCB&gt; option = new UpdateOption&lt;BrowserTypeCB&gt;();
     *     option.self(new SpecifyQuery&lt;BrowserTypeCB&gt;() {
     *         public void specify(BrowserTypeCB cb) {
     *             cb.specify().<span style="color: #FD4747">columnXxxCount()</span>;
     *         }
     *     }).plus(1); <span style="color: #3F7E5E">// XXX_COUNT = XXX_COUNT + 1</span>
     *     browserTypeBhv.<span style="color: #FD4747">varyingUpdate</span>(browserType, option);
     * } catch (EntityAlreadyUpdatedException e) { <span style="color: #3F7E5E">// if concurrent update</span>
     *     ...
     * }
     * </pre>
     * @param browserType The entity of update target. (NotNull) {PrimaryKeyRequired, ConcurrencyColumnRequired}
     * @param option The option of update for varying requests. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyUpdatedException When the entity has already been updated.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void varyingUpdate(final BrowserType browserType,
            final UpdateOption<BrowserTypeCB> option) {
        assertUpdateOptionNotNull(option);
        doUpdate(browserType, option);
    }

    /**
     * Update the entity with varying requests non-strictly modified-only. {UpdateCountZeroException, NonExclusiveControl} <br />
     * For example, self(selfCalculationSpecification), specify(updateColumnSpecification), disableCommonColumnAutoSetup(). <br />
     * Other specifications are same as updateNonstrict(entity).
     * <pre>
     * <span style="color: #3F7E5E">// ex) you can update by self calculation values</span>
     * BrowserType browserType = new BrowserType();
     * browserType.setPK...(value); <span style="color: #3F7E5E">// required</span>
     * browserType.setOther...(value); <span style="color: #3F7E5E">// you should set only modified columns</span>
     * <span style="color: #3F7E5E">// you don't need to set a value of exclusive control column</span>
     * <span style="color: #3F7E5E">// (auto-increment for version number is valid though non-exclusive control)</span>
     * <span style="color: #3F7E5E">//browserType.setVersionNo(value);</span>
     * UpdateOption&lt;BrowserTypeCB&gt; option = new UpdateOption&lt;BrowserTypeCB&gt;();
     * option.self(new SpecifyQuery&lt;BrowserTypeCB&gt;() {
     *     public void specify(BrowserTypeCB cb) {
     *         cb.specify().<span style="color: #FD4747">columnFooCount()</span>;
     *     }
     * }).plus(1); <span style="color: #3F7E5E">// FOO_COUNT = FOO_COUNT + 1</span>
     * browserTypeBhv.<span style="color: #FD4747">varyingUpdateNonstrict</span>(browserType, option);
     * </pre>
     * @param browserType The entity of update target. (NotNull) {PrimaryKeyRequired}
     * @param option The option of update for varying requests. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void varyingUpdateNonstrict(final BrowserType browserType,
            final UpdateOption<BrowserTypeCB> option) {
        assertUpdateOptionNotNull(option);
        doUpdateNonstrict(browserType, option);
    }

    /**
     * Insert or update the entity with varying requests. {ExclusiveControl(when update)}<br />
     * Other specifications are same as insertOrUpdate(entity).
     * @param browserType The entity of insert or update target. (NotNull)
     * @param insertOption The option of insert for varying requests. (NotNull)
     * @param updateOption The option of update for varying requests. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyUpdatedException When the entity has already been updated.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void varyingInsertOrUpdate(final BrowserType browserType,
            final InsertOption<BrowserTypeCB> insertOption,
            final UpdateOption<BrowserTypeCB> updateOption) {
        assertInsertOptionNotNull(insertOption);
        assertUpdateOptionNotNull(updateOption);
        doInesrtOrUpdate(browserType, insertOption, updateOption);
    }

    /**
     * Insert or update the entity with varying requests non-strictly. {NonExclusiveControl(when update)}<br />
     * Other specifications are same as insertOrUpdateNonstrict(entity).
     * @param browserType The entity of insert or update target. (NotNull)
     * @param insertOption The option of insert for varying requests. (NotNull)
     * @param updateOption The option of update for varying requests. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void varyingInsertOrUpdateNonstrict(final BrowserType browserType,
            final InsertOption<BrowserTypeCB> insertOption,
            final UpdateOption<BrowserTypeCB> updateOption) {
        assertInsertOptionNotNull(insertOption);
        assertUpdateOptionNotNull(updateOption);
        doInesrtOrUpdateNonstrict(browserType, insertOption, updateOption);
    }

    /**
     * Delete the entity with varying requests. {UpdateCountZeroException, ExclusiveControl} <br />
     * Now a valid option does not exist. <br />
     * Other specifications are same as delete(entity).
     * @param browserType The entity of delete target. (NotNull) {PrimaryKeyRequired, ConcurrencyColumnRequired}
     * @param option The option of update for varying requests. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyUpdatedException When the entity has already been updated.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     */
    public void varyingDelete(final BrowserType browserType,
            final DeleteOption<BrowserTypeCB> option) {
        assertDeleteOptionNotNull(option);
        doDelete(browserType, option);
    }

    /**
     * Delete the entity with varying requests non-strictly. {UpdateCountZeroException, NonExclusiveControl} <br />
     * Now a valid option does not exist. <br />
     * Other specifications are same as deleteNonstrict(entity).
     * @param browserType The entity of delete target. (NotNull) {PrimaryKeyRequired, ConcurrencyColumnRequired}
     * @param option The option of update for varying requests. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     */
    public void varyingDeleteNonstrict(final BrowserType browserType,
            final DeleteOption<BrowserTypeCB> option) {
        assertDeleteOptionNotNull(option);
        doDeleteNonstrict(browserType, option);
    }

    // -----------------------------------------------------
    //                                          Batch Update
    //                                          ------------
    /**
     * Batch-insert the list with varying requests. <br />
     * For example, disableCommonColumnAutoSetup()
     * , disablePrimaryKeyIdentity(), limitBatchInsertLogging(). <br />
     * Other specifications are same as batchInsert(entityList).
     * @param browserTypeList The list of the entity. (NotNull)
     * @param option The option of insert for varying requests. (NotNull)
     * @return The array of inserted count.
     */
    public int[] varyingBatchInsert(final List<BrowserType> browserTypeList,
            final InsertOption<BrowserTypeCB> option) {
        assertInsertOptionNotNull(option);
        return doBatchInsert(browserTypeList, option);
    }

    /**
     * Batch-update the list with varying requests. <br />
     * For example, self(selfCalculationSpecification), specify(updateColumnSpecification)
     * , disableCommonColumnAutoSetup(), limitBatchUpdateLogging(). <br />
     * Other specifications are same as batchUpdate(entityList).
     * @param browserTypeList The list of the entity. (NotNull)
     * @param option The option of update for varying requests. (NotNull)
     * @return The array of updated count.
     */
    public int[] varyingBatchUpdate(final List<BrowserType> browserTypeList,
            final UpdateOption<BrowserTypeCB> option) {
        assertUpdateOptionNotNull(option);
        return doBatchUpdate(browserTypeList, option);
    }

    /**
     * Batch-update the list with varying requests non-strictly. <br />
     * For example, self(selfCalculationSpecification), specify(updateColumnSpecification)
     * , disableCommonColumnAutoSetup(), limitBatchUpdateLogging(). <br />
     * Other specifications are same as batchUpdateNonstrict(entityList).
     * @param browserTypeList The list of the entity. (NotNull)
     * @param option The option of update for varying requests. (NotNull)
     * @return The array of updated count.
     */
    public int[] varyingBatchUpdateNonstrict(
            final List<BrowserType> browserTypeList,
            final UpdateOption<BrowserTypeCB> option) {
        assertUpdateOptionNotNull(option);
        return doBatchUpdateNonstrict(browserTypeList, option);
    }

    /**
     * Batch-delete the list with varying requests. <br />
     * For example, limitBatchDeleteLogging(). <br />
     * Other specifications are same as batchDelete(entityList).
     * @param browserTypeList The list of the entity. (NotNull)
     * @param option The option of delete for varying requests. (NotNull)
     * @return The array of deleted count.
     */
    public int[] varyingBatchDelete(final List<BrowserType> browserTypeList,
            final DeleteOption<BrowserTypeCB> option) {
        assertDeleteOptionNotNull(option);
        return doBatchDelete(browserTypeList, option);
    }

    /**
     * Batch-delete the list with varying requests non-strictly. <br />
     * For example, limitBatchDeleteLogging(). <br />
     * Other specifications are same as batchDeleteNonstrict(entityList).
     * @param browserTypeList The list of the entity. (NotNull)
     * @param option The option of delete for varying requests. (NotNull)
     * @return The array of deleted count.
     */
    public int[] varyingBatchDeleteNonstrict(
            final List<BrowserType> browserTypeList,
            final DeleteOption<BrowserTypeCB> option) {
        assertDeleteOptionNotNull(option);
        return doBatchDeleteNonstrict(browserTypeList, option);
    }

    // -----------------------------------------------------
    //                                          Query Update
    //                                          ------------
    /**
     * Insert the several entities by query with varying requests (modified-only for fixed value). <br />
     * For example, disableCommonColumnAutoSetup(), disablePrimaryKeyIdentity(). <br />
     * Other specifications are same as queryInsert(entity, setupper). 
     * @param setupper The setup-per of query-insert. (NotNull)
     * @param option The option of insert for varying requests. (NotNull)
     * @return The inserted count.
     */
    public int varyingQueryInsert(
            final QueryInsertSetupper<BrowserType, BrowserTypeCB> setupper,
            final InsertOption<BrowserTypeCB> option) {
        assertInsertOptionNotNull(option);
        return doQueryInsert(setupper, option);
    }

    /**
     * Update the several entities by query with varying requests non-strictly modified-only. {NonExclusiveControl} <br />
     * For example, self(selfCalculationSpecification), specify(updateColumnSpecification)
     * , disableCommonColumnAutoSetup(), allowNonQueryUpdate(). <br />
     * Other specifications are same as queryUpdate(entity, cb). 
     * <pre>
     * <span style="color: #3F7E5E">// ex) you can update by self calculation values</span>
     * BrowserType browserType = new BrowserType();
     * <span style="color: #3F7E5E">// you don't need to set PK value</span>
     * <span style="color: #3F7E5E">//browserType.setPK...(value);</span>
     * browserType.setOther...(value); <span style="color: #3F7E5E">// you should set only modified columns</span>
     * <span style="color: #3F7E5E">// you don't need to set a value of exclusive control column</span>
     * <span style="color: #3F7E5E">// (auto-increment for version number is valid though non-exclusive control)</span>
     * <span style="color: #3F7E5E">//browserType.setVersionNo(value);</span>
     * BrowserTypeCB cb = new BrowserTypeCB();
     * cb.query().setFoo...(value);
     * UpdateOption&lt;BrowserTypeCB&gt; option = new UpdateOption&lt;BrowserTypeCB&gt;();
     * option.self(new SpecifyQuery&lt;BrowserTypeCB&gt;() {
     *     public void specify(BrowserTypeCB cb) {
     *         cb.specify().<span style="color: #FD4747">columnFooCount()</span>;
     *     }
     * }).plus(1); <span style="color: #3F7E5E">// FOO_COUNT = FOO_COUNT + 1</span>
     * browserTypeBhv.<span style="color: #FD4747">varyingQueryUpdate</span>(browserType, cb, option);
     * </pre>
     * @param browserType The entity that contains update values. (NotNull) {PrimaryKeyNotRequired}
     * @param cb The condition-bean of BrowserType. (NotNull)
     * @param option The option of update for varying requests. (NotNull)
     * @return The updated count.
     * @exception org.seasar.dbflute.exception.NonQueryUpdateNotAllowedException When the query has no condition (if not allowed).
     */
    public int varyingQueryUpdate(final BrowserType browserType,
            final BrowserTypeCB cb, final UpdateOption<BrowserTypeCB> option) {
        assertUpdateOptionNotNull(option);
        return doQueryUpdate(browserType, cb, option);
    }

    /**
     * Delete the several entities by query with varying requests non-strictly. <br />
     * For example, allowNonQueryDelete(). <br />
     * Other specifications are same as batchUpdateNonstrict(entityList).
     * @param cb The condition-bean of BrowserType. (NotNull)
     * @param option The option of delete for varying requests. (NotNull)
     * @return The deleted count.
     * @exception org.seasar.dbflute.exception.NonQueryDeleteNotAllowedException When the query has no condition (if not allowed).
     */
    public int varyingQueryDelete(final BrowserTypeCB cb,
            final DeleteOption<BrowserTypeCB> option) {
        assertDeleteOptionNotNull(option);
        return doQueryDelete(cb, option);
    }

    // ===================================================================================
    //                                                                          OutsideSql
    //                                                                          ==========
    /**
     * Prepare the basic executor of outside-SQL to execute it. <br />
     * The invoker of behavior command should be not null when you call this method.
     * <pre>
     * You can use the methods for outside-SQL are as follows:
     * {Basic}
     *   o selectList()
     *   o execute()
     *   o call()
     * 
     * {Entity}
     *   o entityHandling().selectEntity()
     *   o entityHandling().selectEntityWithDeletedCheck()
     * 
     * {Paging}
     *   o autoPaging().selectList()
     *   o autoPaging().selectPage()
     *   o manualPaging().selectList()
     *   o manualPaging().selectPage()
     * 
     * {Cursor}
     *   o cursorHandling().selectCursor()
     * 
     * {Option}
     *   o dynamicBinding().selectList()
     *   o removeBlockComment().selectList()
     *   o removeLineComment().selectList()
     *   o formatSql().selectList()
     * </pre>
     * @return The basic executor of outside-SQL. (NotNull) 
     */
    public OutsideSqlBasicExecutor<BrowserTypeBhv> outsideSql() {
        return doOutsideSql();
    }

    // ===================================================================================
    //                                                                     Delegate Method
    //                                                                     ===============
    // [Behavior Command]
    // -----------------------------------------------------
    //                                                Select
    //                                                ------
    protected int delegateSelectCountUniquely(final BrowserTypeCB cb) {
        return invoke(createSelectCountCBCommand(cb, true));
    }

    protected int delegateSelectCountPlainly(final BrowserTypeCB cb) {
        return invoke(createSelectCountCBCommand(cb, false));
    }

    protected <ENTITY extends BrowserType> void delegateSelectCursor(
            final BrowserTypeCB cb, final EntityRowHandler<ENTITY> erh,
            final Class<ENTITY> et) {
        invoke(createSelectCursorCBCommand(cb, erh, et));
    }

    protected <ENTITY extends BrowserType> List<ENTITY> delegateSelectList(
            final BrowserTypeCB cb, final Class<ENTITY> et) {
        return invoke(createSelectListCBCommand(cb, et));
    }

    // -----------------------------------------------------
    //                                                Update
    //                                                ------
    protected int delegateInsert(final BrowserType e,
            final InsertOption<BrowserTypeCB> op) {
        if (!processBeforeInsert(e, op)) {
            return 0;
        }
        return invoke(createInsertEntityCommand(e, op));
    }

    protected int delegateUpdate(final BrowserType e,
            final UpdateOption<BrowserTypeCB> op) {
        if (!processBeforeUpdate(e, op)) {
            return 0;
        }
        return invoke(createUpdateEntityCommand(e, op));
    }

    protected int delegateUpdateNonstrict(final BrowserType e,
            final UpdateOption<BrowserTypeCB> op) {
        if (!processBeforeUpdate(e, op)) {
            return 0;
        }
        return invoke(createUpdateNonstrictEntityCommand(e, op));
    }

    protected int delegateDelete(final BrowserType e,
            final DeleteOption<BrowserTypeCB> op) {
        if (!processBeforeDelete(e, op)) {
            return 0;
        }
        return invoke(createDeleteEntityCommand(e, op));
    }

    protected int delegateDeleteNonstrict(final BrowserType e,
            final DeleteOption<BrowserTypeCB> op) {
        if (!processBeforeDelete(e, op)) {
            return 0;
        }
        return invoke(createDeleteNonstrictEntityCommand(e, op));
    }

    protected int[] delegateBatchInsert(final List<BrowserType> ls,
            final InsertOption<BrowserTypeCB> op) {
        if (ls.isEmpty()) {
            return new int[] {};
        }
        return invoke(createBatchInsertCommand(processBatchInternally(ls, op),
                op));
    }

    protected int[] delegateBatchUpdate(final List<BrowserType> ls,
            final UpdateOption<BrowserTypeCB> op) {
        if (ls.isEmpty()) {
            return new int[] {};
        }
        return invoke(createBatchUpdateCommand(
                processBatchInternally(ls, op, false), op));
    }

    protected int[] delegateBatchUpdateNonstrict(final List<BrowserType> ls,
            final UpdateOption<BrowserTypeCB> op) {
        if (ls.isEmpty()) {
            return new int[] {};
        }
        return invoke(createBatchUpdateNonstrictCommand(
                processBatchInternally(ls, op, true), op));
    }

    protected int[] delegateBatchDelete(final List<BrowserType> ls,
            final DeleteOption<BrowserTypeCB> op) {
        if (ls.isEmpty()) {
            return new int[] {};
        }
        return invoke(createBatchDeleteCommand(
                processBatchInternally(ls, op, false), op));
    }

    protected int[] delegateBatchDeleteNonstrict(final List<BrowserType> ls,
            final DeleteOption<BrowserTypeCB> op) {
        if (ls.isEmpty()) {
            return new int[] {};
        }
        return invoke(createBatchDeleteNonstrictCommand(
                processBatchInternally(ls, op, true), op));
    }

    protected int delegateQueryInsert(final BrowserType e,
            final BrowserTypeCB inCB, final ConditionBean resCB,
            final InsertOption<BrowserTypeCB> op) {
        if (!processBeforeQueryInsert(e, inCB, resCB, op)) {
            return 0;
        }
        return invoke(createQueryInsertCBCommand(e, inCB, resCB, op));
    }

    protected int delegateQueryUpdate(final BrowserType e,
            final BrowserTypeCB cb, final UpdateOption<BrowserTypeCB> op) {
        if (!processBeforeQueryUpdate(e, cb, op)) {
            return 0;
        }
        return invoke(createQueryUpdateCBCommand(e, cb, op));
    }

    protected int delegateQueryDelete(final BrowserTypeCB cb,
            final DeleteOption<BrowserTypeCB> op) {
        if (!processBeforeQueryDelete(cb, op)) {
            return 0;
        }
        return invoke(createQueryDeleteCBCommand(cb, op));
    }

    // ===================================================================================
    //                                                                Optimistic Lock Info
    //                                                                ====================
    /**
     * {@inheritDoc}
     */
    @Override
    protected boolean hasVersionNoValue(final Entity entity) {
        return !(downcast(entity).getVersionNo() + "").equals("null");// For primitive type
    }

    /**
     * {@inheritDoc}
     */
    @Override
    protected boolean hasUpdateDateValue(final Entity entity) {
        return false;
    }

    // ===================================================================================
    //                                                                     Downcast Helper
    //                                                                     ===============
    protected BrowserType downcast(final Entity entity) {
        return helpEntityDowncastInternally(entity, BrowserType.class);
    }

    protected BrowserTypeCB downcast(final ConditionBean cb) {
        return helpConditionBeanDowncastInternally(cb, BrowserTypeCB.class);
    }

    @SuppressWarnings("unchecked")
    protected List<BrowserType> downcast(final List<? extends Entity> entityList) {
        return (List<BrowserType>) entityList;
    }

    @SuppressWarnings("unchecked")
    protected InsertOption<BrowserTypeCB> downcast(
            final InsertOption<? extends ConditionBean> option) {
        return (InsertOption<BrowserTypeCB>) option;
    }

    @SuppressWarnings("unchecked")
    protected UpdateOption<BrowserTypeCB> downcast(
            final UpdateOption<? extends ConditionBean> option) {
        return (UpdateOption<BrowserTypeCB>) option;
    }

    @SuppressWarnings("unchecked")
    protected DeleteOption<BrowserTypeCB> downcast(
            final DeleteOption<? extends ConditionBean> option) {
        return (DeleteOption<BrowserTypeCB>) option;
    }

    @SuppressWarnings("unchecked")
    protected QueryInsertSetupper<BrowserType, BrowserTypeCB> downcast(
            final QueryInsertSetupper<? extends Entity, ? extends ConditionBean> option) {
        return (QueryInsertSetupper<BrowserType, BrowserTypeCB>) option;
    }
}
