/*
 * Copyright 2009-2010 the Fess Project and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package jp.sf.fess.helper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.seasar.extension.unit.S2TestCase;

public class CrawlingSessionHelperTest extends S2TestCase {

    public CrawlingSessionHelper crawlingSessionHelper;

    @Override
    protected String getRootDicon() throws Throwable {
        return "app.dicon";
    }

    public void test_generateId() {
        Map<String, Object> dataMap = new HashMap<String, Object>();
        dataMap.put("url", "http://hoge.com/");

        assertEquals("http://hoge.com/", crawlingSessionHelper
                .generateId(dataMap));

        List<String> browserTypeList = new ArrayList<String>();
        dataMap.put("type", browserTypeList);
        List<String> roleTypeList = new ArrayList<String>();
        dataMap.put("role", roleTypeList);

        assertEquals("http://hoge.com/", crawlingSessionHelper
                .generateId(dataMap));
    }

    public void test_generateId_browserType() {
        Map<String, Object> dataMap = new HashMap<String, Object>();
        dataMap.put("url", "http://hoge.com/");
        List<String> browserTypeList = new ArrayList<String>();
        browserTypeList.add("pc");
        dataMap.put("type", browserTypeList);

        assertEquals("http://hoge.com/;type=pc", crawlingSessionHelper
                .generateId(dataMap));

        browserTypeList.add("docomo");
        browserTypeList.add("softbank");
        browserTypeList.add("au");

        assertEquals("http://hoge.com/;type=au,docomo,pc,softbank",
                crawlingSessionHelper.generateId(dataMap));

        List<String> roleTypeList = new ArrayList<String>();
        dataMap.put("role", roleTypeList);

        assertEquals("http://hoge.com/;type=au,docomo,pc,softbank",
                crawlingSessionHelper.generateId(dataMap));
    }

    public void test_generateId_roleType() {
        Map<String, Object> dataMap = new HashMap<String, Object>();
        dataMap.put("url", "http://hoge.com/");
        List<String> roleTypeList = new ArrayList<String>();
        roleTypeList.add("admin");
        dataMap.put("role", roleTypeList);

        assertEquals("http://hoge.com/;role=admin", crawlingSessionHelper
                .generateId(dataMap));

        roleTypeList.add("guest");

        assertEquals("http://hoge.com/;role=admin,guest", crawlingSessionHelper
                .generateId(dataMap));

        List<String> browserTypeList = new ArrayList<String>();
        dataMap.put("type", browserTypeList);

        assertEquals("http://hoge.com/;role=admin,guest", crawlingSessionHelper
                .generateId(dataMap));
    }

    public void test_generateId_browserType_roleType() {
        Map<String, Object> dataMap = new HashMap<String, Object>();
        dataMap.put("url", "http://hoge.com/");
        List<String> browserTypeList = new ArrayList<String>();
        browserTypeList.add("pc");
        browserTypeList.add("docomo");
        dataMap.put("type", browserTypeList);
        List<String> roleTypeList = new ArrayList<String>();
        roleTypeList.add("admin");
        roleTypeList.add("guest");
        dataMap.put("role", roleTypeList);

        assertEquals("http://hoge.com/;type=docomo,pc;role=admin,guest",
                crawlingSessionHelper.generateId(dataMap));
    }
}
