/*
 * Copyright 2009-2009 the Fess Project and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package jp.sf.fess.action.admin;

import java.io.Serializable;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

import javax.annotation.Resource;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;

import jp.sf.fess.crud.util.SAStrutsUtil;
import jp.sf.fess.form.admin.DataForm;
import jp.sf.fess.service.DatabaseService;

import org.seasar.struts.annotation.ActionForm;
import org.seasar.struts.annotation.Execute;
import org.seasar.struts.exception.ActionMessagesException;
import org.seasar.struts.util.ResponseUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataAction implements Serializable {

    private static final long serialVersionUID = 1L;

    private static final Logger logger = LoggerFactory
            .getLogger(DataAction.class);

    @Resource
    @ActionForm
    protected DataForm dataForm;

    @Resource
    protected DatabaseService databaseService;

    @Execute(validator = false)
    public String index() {
        // set a default value
        dataForm.overwrite = "on";
        return "index.jsp";
    }

    @Execute(validator = false)
    public String download() {
        DateFormat df = new SimpleDateFormat("yyyyMMddHHmmss");
        StringBuilder buf = new StringBuilder();
        buf.append("backup-");
        buf.append(df.format(new Date()));
        buf.append(".xml");

        HttpServletResponse response = ResponseUtil.getResponse();
        response.setContentType("application/octet-stream");
        response.setHeader("Content-Disposition", "attachment; filename=\""
                + buf.toString() + "\"");

        try {
            ServletOutputStream sos = response.getOutputStream();
            try {
                databaseService.exportData(sos);
                sos.flush();
            } finally {
                sos.close();
            }
            return null;
        } catch (Exception e) {
            logger.error("Failed to export data.", e);
            throw new ActionMessagesException("errors.failed_to_export_data", e);
        }
    }

    @Execute(validator = false)
    public String upload() {
        try {
            databaseService.importData(dataForm.uploadedFile.getInputStream(),
                    dataForm.overwrite != null
                            && "on".equalsIgnoreCase(dataForm.overwrite));
            SAStrutsUtil.addSessionMessage("success.importing_data");
            return "index?redirect=true";
        } catch (Exception e) {
            logger.error("Failed to import data.", e);
            throw new ActionMessagesException("errors.failed_to_import_data", e);
        }
    }
}