package jp.sf.fess.suggest.converter;

import static org.hamcrest.core.Is.is;
import static org.junit.Assert.assertThat;

import org.junit.Test;

public class SymbolConverterTest {

    @Test
    public void convert() {
        final SymbolConveter symbolConveter = new SymbolConveter();
        assertThat(symbolConveter.convert("123abcあいうえおアイウエオ"),
                is("123abcあいうえおアイウエオ"));
        symbolConveter.addSymbol("あ");
        assertThat(symbolConveter.convert("123abcあいうえおアイウエオ"),
                is("123abc__ID0__いうえおアイウエオ"));
        symbolConveter.addSymbol("ア");
        assertThat(symbolConveter.convert("123abcあいうえおアイウエオ"),
                is("123abc__ID0__いうえお__ID1__イウエオ"));
        symbolConveter.addSymbol("a");
        assertThat(symbolConveter.convert("123abcあいうえおアイウエオ"),
                is("123__ID2__bc__ID0__いうえお__ID1__イウエオ"));
    }

}
