package jp.sf.fess.suggest.converter;

import static org.hamcrest.core.Is.is;
import static org.junit.Assert.assertThat;

import java.util.Enumeration;

import org.junit.Test;

import com.ibm.icu.text.Transliterator;

public class ICUConverterTest {

    @Test
    public void convertFullwidthHalfwidth() {
        final ICUConverter icuConverter = new ICUConverter(
                "Fullwidth-Halfwidth");
        assertThat(icuConverter.convert("123"), is("123"));
        assertThat(icuConverter.convert("１２３"), is("123"));
        assertThat(icuConverter.convert("abc"), is("abc"));
        assertThat(icuConverter.convert("ａｂｃ"), is("abc"));
        assertThat(icuConverter.convert("ABC"), is("ABC"));
        assertThat(icuConverter.convert("ＡＢＣ"), is("ABC"));
        assertThat(icuConverter.convert("!\"#$%&'()~"), is("!\"#$%&'()~"));
        assertThat(icuConverter.convert("！”＃＄％＆’（）〜"), is("!”#$%&’()〜"));
        assertThat(icuConverter.convert("-^\\=~|"), is("-^\\=~|"));
        assertThat(icuConverter.convert("ー＾￥＝〜｜"), is("ｰ^¥=〜|"));
        assertThat(icuConverter.convert("@[;:]`{+*}"), is("@[;:]`{+*}"));
        assertThat(icuConverter.convert("＠「；：」｀｛＋＊｝"), is("@｢;:｣`{+*}"));
        assertThat(icuConverter.convert(",./<>?_"), is(",./<>?_"));
        assertThat(icuConverter.convert("、。・＜＞？＿"), is("､｡･<>?_"));
        assertThat(icuConverter.convert("あいうえお"), is("あいうえお"));
        assertThat(icuConverter.convert("アイウエオ"), is("ｱｲｳｴｵ"));
        assertThat(icuConverter.convert("ｱｲｳｴｵ"), is("ｱｲｳｴｵ"));
        assertThat(icuConverter.convert("漢字"), is("漢字"));
        assertThat(icuConverter.convert(" 　"), is("  "));

    }

    @Test
    public void convertHalfwidthFullwidth() {
        final ICUConverter icuConverter = new ICUConverter(
                "Halfwidth-Fullwidth");
        assertThat(icuConverter.convert("123"), is("１２３"));
        assertThat(icuConverter.convert("１２３"), is("１２３"));
        assertThat(icuConverter.convert("abc"), is("ａｂｃ"));
        assertThat(icuConverter.convert("ａｂｃ"), is("ａｂｃ"));
        assertThat(icuConverter.convert("ABC"), is("ＡＢＣ"));
        assertThat(icuConverter.convert("ＡＢＣ"), is("ＡＢＣ"));
        assertThat(icuConverter.convert("!\"#$%&'()~"), is("！＂＃＄％＆＇（）～"));
        assertThat(icuConverter.convert("！”＃＄％＆’（）〜"), is("！”＃＄％＆’（）〜"));
        assertThat(icuConverter.convert("-^\\=~|"), is("－＾＼＝～｜"));
        assertThat(icuConverter.convert("ー＾￥＝〜｜"), is("ー＾￥＝〜｜"));
        assertThat(icuConverter.convert("@[;:]`{+*}"), is("＠［；：］｀｛＋＊｝"));
        assertThat(icuConverter.convert("＠「；：」｀｛＋＊｝"), is("＠「；：」｀｛＋＊｝"));
        assertThat(icuConverter.convert(",./<>?_"), is("，．／＜＞？＿"));
        assertThat(icuConverter.convert("、。・＜＞？＿"), is("、。・＜＞？＿"));
        assertThat(icuConverter.convert("あいうえお"), is("あいうえお"));
        assertThat(icuConverter.convert("アイウエオ"), is("アイウエオ"));
        assertThat(icuConverter.convert("ｱｲｳｴｵ"), is("アイウエオ"));
        assertThat(icuConverter.convert("漢字"), is("漢字"));
        assertThat(icuConverter.convert(" 　"), is("　　"));

    }

    @Test
    public void convertKatakanaHiragana() {
        final ICUConverter icuConverter = new ICUConverter("Katakana-Hiragana");
        assertThat(icuConverter.convert("123"), is("123"));
        assertThat(icuConverter.convert("１２３"), is("１２３"));
        assertThat(icuConverter.convert("abc"), is("abc"));
        assertThat(icuConverter.convert("ａｂｃ"), is("ａｂｃ"));
        assertThat(icuConverter.convert("ABC"), is("ABC"));
        assertThat(icuConverter.convert("ＡＢＣ"), is("ＡＢＣ"));
        assertThat(icuConverter.convert("!\"#$%&'()~"), is("!\"#$%&'()~"));
        assertThat(icuConverter.convert("！”＃＄％＆’（）〜"), is("！”＃＄％＆’（）〜"));
        assertThat(icuConverter.convert("-^\\=~|"), is("-^\\=~|"));
        assertThat(icuConverter.convert("ー＾￥＝〜｜"), is("ー＾￥＝〜｜"));
        assertThat(icuConverter.convert("@[;:]`{+*}"), is("@[;:]`{+*}"));
        assertThat(icuConverter.convert("＠「；：」｀｛＋＊｝"), is("＠「；：」｀｛＋＊｝"));
        assertThat(icuConverter.convert(",./<>?_"), is(",./<>?_"));
        assertThat(icuConverter.convert("、。・＜＞？＿"), is("、。・＜＞？＿"));
        assertThat(icuConverter.convert("あいうえお"), is("あいうえお"));
        assertThat(icuConverter.convert("アイウエオ"), is("あいうえお"));
        assertThat(icuConverter.convert("ｱｲｳｴｵ"), is("あいうえお"));
        assertThat(icuConverter.convert("漢字"), is("漢字"));
        assertThat(icuConverter.convert(" 　"), is(" 　"));

    }

    @Test
    public void convertHiraganaKatakana() {
        final ICUConverter icuConverter = new ICUConverter("Hiragana-Katakana");
        assertThat(icuConverter.convert("123"), is("123"));
        assertThat(icuConverter.convert("１２３"), is("１２３"));
        assertThat(icuConverter.convert("abc"), is("abc"));
        assertThat(icuConverter.convert("ａｂｃ"), is("ａｂｃ"));
        assertThat(icuConverter.convert("ABC"), is("ABC"));
        assertThat(icuConverter.convert("ＡＢＣ"), is("ＡＢＣ"));
        assertThat(icuConverter.convert("!\"#$%&'()~"), is("!\"#$%&'()~"));
        assertThat(icuConverter.convert("！”＃＄％＆’（）〜"), is("！”＃＄％＆’（）〜"));
        assertThat(icuConverter.convert("-^\\=~|"), is("-^\\=~|"));
        assertThat(icuConverter.convert("ー＾￥＝〜｜"), is("ー＾￥＝〜｜"));
        assertThat(icuConverter.convert("@[;:]`{+*}"), is("@[;:]`{+*}"));
        assertThat(icuConverter.convert("＠「；：」｀｛＋＊｝"), is("＠「；：」｀｛＋＊｝"));
        assertThat(icuConverter.convert(",./<>?_"), is(",./<>?_"));
        assertThat(icuConverter.convert("、。・＜＞？＿"), is("、。・＜＞？＿"));
        assertThat(icuConverter.convert("あいうえお"), is("アイウエオ"));
        assertThat(icuConverter.convert("アイウエオ"), is("アイウエオ"));
        assertThat(icuConverter.convert("ｱｲｳｴｵ"), is("アイウエオ"));
        assertThat(icuConverter.convert("漢字"), is("漢字"));
        assertThat(icuConverter.convert(" 　"), is(" 　"));

    }

    private void printTransliteratorIDs() {
        final Enumeration<String> availableIDs = Transliterator
                .getAvailableIDs();
        while (availableIDs.hasMoreElements()) {
            System.out.println("ID: " + availableIDs.nextElement());
        }
    }

}
