package jp.sf.fess.suggest.converter;

import java.util.ArrayList;
import java.util.List;

public class SymbolConveter implements SuggestConverter {

    protected List<String> symbolList = new ArrayList<String>();

    protected String symbolPrefix;

    protected String symbolSuffix;

    public SymbolConveter() {
        this("__ID", "__");
    }

    public SymbolConveter(final String prefix, final String suffix) {
        symbolPrefix = prefix;
        symbolSuffix = suffix;
    }

    @Override
    public String convert(final String query) {

        String target = query;
        for (int i = 0; i < symbolList.size(); i++) {
            target = target.replaceAll(symbolList.get(i), symbolPrefix
                    + Integer.valueOf(i) + symbolSuffix);
        }
        return target;
    }

    public void addSymbol(final String symbol) {
        if (symbol != null) {
            symbolList.add(symbol);
        }
    }

}
