/*
 * Copyright 2009-2012 the Fess Project and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */

package jp.sf.fess.db.bsentity;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

import jp.sf.fess.db.allcommon.DBMetaInstanceHandler;
import jp.sf.fess.db.exentity.FailureUrl;
import jp.sf.fess.db.exentity.FileAuthentication;
import jp.sf.fess.db.exentity.FileConfigToBrowserTypeMapping;
import jp.sf.fess.db.exentity.FileConfigToLabelTypeMapping;
import jp.sf.fess.db.exentity.FileConfigToRoleTypeMapping;

import org.seasar.dbflute.Entity;
import org.seasar.dbflute.dbmeta.DBMeta;

/**
 * The entity of FILE_CRAWLING_CONFIG as TABLE. <br />
 * <pre>
 * [primary-key]
 *     ID
 * 
 * [column]
 *     ID, NAME, PATHS, INCLUDED_PATHS, EXCLUDED_PATHS, INCLUDED_DOC_PATHS, EXCLUDED_DOC_PATHS, DEPTH, MAX_ACCESS_COUNT, NUM_OF_THREAD, INTERVAL_TIME, BOOST, AVAILABLE, SORT_ORDER, CREATED_BY, CREATED_TIME, UPDATED_BY, UPDATED_TIME, DELETED_BY, DELETED_TIME, VERSION_NO
 * 
 * [sequence]
 *     
 * 
 * [identity]
 *     ID
 * 
 * [version-no]
 *     VERSION_NO
 * 
 * [foreign-table]
 *     
 * 
 * [referrer-table]
 *     FAILURE_URL, FILE_AUTHENTICATION, FILE_CONFIG_TO_BROWSER_TYPE_MAPPING, FILE_CONFIG_TO_LABEL_TYPE_MAPPING, FILE_CONFIG_TO_ROLE_TYPE_MAPPING
 * 
 * [foreign-property]
 *     
 * 
 * [referrer-property]
 *     failureUrlList, fileAuthenticationList, fileConfigToBrowserTypeMappingList, fileConfigToLabelTypeMappingList, fileConfigToRoleTypeMappingList
 * </pre>
 * @author DBFlute(AutoGenerator)
 */
public abstract class BsFileCrawlingConfig implements Entity, Serializable {

    // ===================================================================================
    //                                                                          Definition
    //                                                                          ==========
    /** Serial version UID. (Default) */
    private static final long serialVersionUID = 1L;

    // ===================================================================================
    //                                                                           Attribute
    //                                                                           =========
    // -----------------------------------------------------
    //                                                Column
    //                                                ------
    /** ID: {PK, ID, NotNull, BIGINT(19)} */
    protected Long _id;

    /** NAME: {NotNull, VARCHAR(200)} */
    protected String _name;

    /** PATHS: {NotNull, VARCHAR(4000)} */
    protected String _paths;

    /** INCLUDED_PATHS: {VARCHAR(4000)} */
    protected String _includedPaths;

    /** EXCLUDED_PATHS: {VARCHAR(4000)} */
    protected String _excludedPaths;

    /** INCLUDED_DOC_PATHS: {VARCHAR(4000)} */
    protected String _includedDocPaths;

    /** EXCLUDED_DOC_PATHS: {VARCHAR(4000)} */
    protected String _excludedDocPaths;

    /** DEPTH: {INTEGER(10)} */
    protected Integer _depth;

    /** MAX_ACCESS_COUNT: {BIGINT(19)} */
    protected Long _maxAccessCount;

    /** NUM_OF_THREAD: {NotNull, INTEGER(10)} */
    protected Integer _numOfThread;

    /** INTERVAL_TIME: {NotNull, INTEGER(10)} */
    protected Integer _intervalTime;

    /** BOOST: {NotNull, DOUBLE(17)} */
    protected java.math.BigDecimal _boost;

    /** AVAILABLE: {NotNull, VARCHAR(1)} */
    protected String _available;

    /** SORT_ORDER: {NotNull, INTEGER(10)} */
    protected Integer _sortOrder;

    /** CREATED_BY: {NotNull, VARCHAR(255)} */
    protected String _createdBy;

    /** CREATED_TIME: {NotNull, TIMESTAMP(23, 10)} */
    protected java.sql.Timestamp _createdTime;

    /** UPDATED_BY: {VARCHAR(255)} */
    protected String _updatedBy;

    /** UPDATED_TIME: {TIMESTAMP(23, 10)} */
    protected java.sql.Timestamp _updatedTime;

    /** DELETED_BY: {VARCHAR(255)} */
    protected String _deletedBy;

    /** DELETED_TIME: {TIMESTAMP(23, 10)} */
    protected java.sql.Timestamp _deletedTime;

    /** VERSION_NO: {NotNull, INTEGER(10)} */
    protected Integer _versionNo;

    // -----------------------------------------------------
    //                                              Internal
    //                                              --------
    /** The modified properties for this entity. */
    protected final EntityModifiedProperties __modifiedProperties = newModifiedProperties();

    // ===================================================================================
    //                                                                          Table Name
    //                                                                          ==========
    /**
     * {@inheritDoc}
     */
    @Override
    public String getTableDbName() {
        return "FILE_CRAWLING_CONFIG";
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public String getTablePropertyName() { // according to Java Beans rule
        return "fileCrawlingConfig";
    }

    // ===================================================================================
    //                                                                              DBMeta
    //                                                                              ======
    /**
     * {@inheritDoc}
     */
    @Override
    public DBMeta getDBMeta() {
        return DBMetaInstanceHandler.findDBMeta(getTableDbName());
    }

    // ===================================================================================
    //                                                                         Primary Key
    //                                                                         ===========
    /**
     * {@inheritDoc}
     */
    @Override
    public boolean hasPrimaryKeyValue() {
        if (getId() == null) {
            return false;
        }
        return true;
    }

    // ===================================================================================
    //                                                                    Foreign Property
    //                                                                    ================
    // ===================================================================================
    //                                                                   Referrer Property
    //                                                                   =================
    /** FAILURE_URL as 'failureUrlList'. */
    protected List<FailureUrl> _failureUrlList;

    /**
     * FAILURE_URL as 'failureUrlList'.
     * @return The entity list of referrer property 'failureUrlList'. (NotNull: If it's not loaded yet, initializes the list instance of referrer as empty and returns it.)
     */
    public List<FailureUrl> getFailureUrlList() {
        if (_failureUrlList == null) {
            _failureUrlList = new ArrayList<FailureUrl>();
        }
        return _failureUrlList;
    }

    /**
     * FAILURE_URL as 'failureUrlList'.
     * @param failureUrlList The entity list of referrer property 'failureUrlList'. (NullAllowed)
     */
    public void setFailureUrlList(final List<FailureUrl> failureUrlList) {
        _failureUrlList = failureUrlList;
    }

    /** FILE_AUTHENTICATION as 'fileAuthenticationList'. */
    protected List<FileAuthentication> _fileAuthenticationList;

    /**
     * FILE_AUTHENTICATION as 'fileAuthenticationList'.
     * @return The entity list of referrer property 'fileAuthenticationList'. (NotNull: If it's not loaded yet, initializes the list instance of referrer as empty and returns it.)
     */
    public List<FileAuthentication> getFileAuthenticationList() {
        if (_fileAuthenticationList == null) {
            _fileAuthenticationList = new ArrayList<FileAuthentication>();
        }
        return _fileAuthenticationList;
    }

    /**
     * FILE_AUTHENTICATION as 'fileAuthenticationList'.
     * @param fileAuthenticationList The entity list of referrer property 'fileAuthenticationList'. (NullAllowed)
     */
    public void setFileAuthenticationList(
            final List<FileAuthentication> fileAuthenticationList) {
        _fileAuthenticationList = fileAuthenticationList;
    }

    /** FILE_CONFIG_TO_BROWSER_TYPE_MAPPING as 'fileConfigToBrowserTypeMappingList'. */
    protected List<FileConfigToBrowserTypeMapping> _fileConfigToBrowserTypeMappingList;

    /**
     * FILE_CONFIG_TO_BROWSER_TYPE_MAPPING as 'fileConfigToBrowserTypeMappingList'.
     * @return The entity list of referrer property 'fileConfigToBrowserTypeMappingList'. (NotNull: If it's not loaded yet, initializes the list instance of referrer as empty and returns it.)
     */
    public List<FileConfigToBrowserTypeMapping> getFileConfigToBrowserTypeMappingList() {
        if (_fileConfigToBrowserTypeMappingList == null) {
            _fileConfigToBrowserTypeMappingList = new ArrayList<FileConfigToBrowserTypeMapping>();
        }
        return _fileConfigToBrowserTypeMappingList;
    }

    /**
     * FILE_CONFIG_TO_BROWSER_TYPE_MAPPING as 'fileConfigToBrowserTypeMappingList'.
     * @param fileConfigToBrowserTypeMappingList The entity list of referrer property 'fileConfigToBrowserTypeMappingList'. (NullAllowed)
     */
    public void setFileConfigToBrowserTypeMappingList(
            final List<FileConfigToBrowserTypeMapping> fileConfigToBrowserTypeMappingList) {
        _fileConfigToBrowserTypeMappingList = fileConfigToBrowserTypeMappingList;
    }

    /** FILE_CONFIG_TO_LABEL_TYPE_MAPPING as 'fileConfigToLabelTypeMappingList'. */
    protected List<FileConfigToLabelTypeMapping> _fileConfigToLabelTypeMappingList;

    /**
     * FILE_CONFIG_TO_LABEL_TYPE_MAPPING as 'fileConfigToLabelTypeMappingList'.
     * @return The entity list of referrer property 'fileConfigToLabelTypeMappingList'. (NotNull: If it's not loaded yet, initializes the list instance of referrer as empty and returns it.)
     */
    public List<FileConfigToLabelTypeMapping> getFileConfigToLabelTypeMappingList() {
        if (_fileConfigToLabelTypeMappingList == null) {
            _fileConfigToLabelTypeMappingList = new ArrayList<FileConfigToLabelTypeMapping>();
        }
        return _fileConfigToLabelTypeMappingList;
    }

    /**
     * FILE_CONFIG_TO_LABEL_TYPE_MAPPING as 'fileConfigToLabelTypeMappingList'.
     * @param fileConfigToLabelTypeMappingList The entity list of referrer property 'fileConfigToLabelTypeMappingList'. (NullAllowed)
     */
    public void setFileConfigToLabelTypeMappingList(
            final List<FileConfigToLabelTypeMapping> fileConfigToLabelTypeMappingList) {
        _fileConfigToLabelTypeMappingList = fileConfigToLabelTypeMappingList;
    }

    /** FILE_CONFIG_TO_ROLE_TYPE_MAPPING as 'fileConfigToRoleTypeMappingList'. */
    protected List<FileConfigToRoleTypeMapping> _fileConfigToRoleTypeMappingList;

    /**
     * FILE_CONFIG_TO_ROLE_TYPE_MAPPING as 'fileConfigToRoleTypeMappingList'.
     * @return The entity list of referrer property 'fileConfigToRoleTypeMappingList'. (NotNull: If it's not loaded yet, initializes the list instance of referrer as empty and returns it.)
     */
    public List<FileConfigToRoleTypeMapping> getFileConfigToRoleTypeMappingList() {
        if (_fileConfigToRoleTypeMappingList == null) {
            _fileConfigToRoleTypeMappingList = new ArrayList<FileConfigToRoleTypeMapping>();
        }
        return _fileConfigToRoleTypeMappingList;
    }

    /**
     * FILE_CONFIG_TO_ROLE_TYPE_MAPPING as 'fileConfigToRoleTypeMappingList'.
     * @param fileConfigToRoleTypeMappingList The entity list of referrer property 'fileConfigToRoleTypeMappingList'. (NullAllowed)
     */
    public void setFileConfigToRoleTypeMappingList(
            final List<FileConfigToRoleTypeMapping> fileConfigToRoleTypeMappingList) {
        _fileConfigToRoleTypeMappingList = fileConfigToRoleTypeMappingList;
    }

    // ===================================================================================
    //                                                                 Modified Properties
    //                                                                 ===================
    /**
     * {@inheritDoc}
     */
    @Override
    public Set<String> modifiedProperties() {
        return __modifiedProperties.getPropertyNames();
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public void clearModifiedInfo() {
        __modifiedProperties.clear();
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public boolean hasModification() {
        return !__modifiedProperties.isEmpty();
    }

    protected EntityModifiedProperties newModifiedProperties() {
        return new EntityModifiedProperties();
    }

    // ===================================================================================
    //                                                                      Basic Override
    //                                                                      ==============
    /**
     * If primary-keys or columns of the other are same as this one, returns true.
     * @param other The other entity. (NullAllowed)
     * @return Comparing result.
     */
    @Override
    public boolean equals(final Object other) {
        if (other == null || !(other instanceof BsFileCrawlingConfig)) {
            return false;
        }
        final BsFileCrawlingConfig otherEntity = (BsFileCrawlingConfig) other;
        if (!xSV(getId(), otherEntity.getId())) {
            return false;
        }
        return true;
    }

    protected boolean xSV(final Object value1, final Object value2) { // isSameValue()
        return InternalUtil.isSameValue(value1, value2);
    }

    /**
     * Calculates the hash-code from primary-keys or columns.
     * @return The hash-code from primary-key or columns.
     */
    @Override
    public int hashCode() {
        int result = 17;
        result = xCH(result, getTableDbName());
        result = xCH(result, getId());
        return result;
    }

    protected int xCH(final int result, final Object value) { // calculateHashcode()
        return InternalUtil.calculateHashcode(result, value);
    }

    /**
     * @return The display string of all columns and relation existences. (NotNull)
     */
    @Override
    public String toString() {
        return buildDisplayString(InternalUtil.toClassTitle(this), true, true);
    }

    /**
     * @return The display string of basic informations with one-nested relation values. (NotNull)
     */
    @Override
    public String toStringWithRelation() {
        final StringBuilder sb = new StringBuilder();
        sb.append(toString());
        final String l = "\n  ";
        if (_failureUrlList != null) {
            for (final Entity e : _failureUrlList) {
                if (e != null) {
                    sb.append(l).append(xbRDS(e, "failureUrlList"));
                }
            }
        }
        if (_fileAuthenticationList != null) {
            for (final Entity e : _fileAuthenticationList) {
                if (e != null) {
                    sb.append(l).append(xbRDS(e, "fileAuthenticationList"));
                }
            }
        }
        if (_fileConfigToBrowserTypeMappingList != null) {
            for (final Entity e : _fileConfigToBrowserTypeMappingList) {
                if (e != null) {
                    sb.append(l).append(
                            xbRDS(e, "fileConfigToBrowserTypeMappingList"));
                }
            }
        }
        if (_fileConfigToLabelTypeMappingList != null) {
            for (final Entity e : _fileConfigToLabelTypeMappingList) {
                if (e != null) {
                    sb.append(l).append(
                            xbRDS(e, "fileConfigToLabelTypeMappingList"));
                }
            }
        }
        if (_fileConfigToRoleTypeMappingList != null) {
            for (final Entity e : _fileConfigToRoleTypeMappingList) {
                if (e != null) {
                    sb.append(l).append(
                            xbRDS(e, "fileConfigToRoleTypeMappingList"));
                }
            }
        }
        return sb.toString();
    }

    protected String xbRDS(final Entity e, final String name) { // buildRelationDisplayString()
        return e.buildDisplayString(name, true, true);
    }

    /**
     * @param name The name for display. (NullAllowed: If it's null, it does not have a name)
     * @param column Does it contains column values or not?
     * @param relation Does it contains relation existences or not?
     * @return The display string for this entity. (NotNull)
     */
    @Override
    public String buildDisplayString(final String name, final boolean column,
            final boolean relation) {
        final StringBuilder sb = new StringBuilder();
        if (name != null) {
            sb.append(name).append(column || relation ? ":" : "");
        }
        if (column) {
            sb.append(buildColumnString());
        }
        if (relation) {
            sb.append(buildRelationString());
        }
        sb.append("@").append(Integer.toHexString(hashCode()));
        return sb.toString();
    }

    protected String buildColumnString() {
        final String c = ", ";
        final StringBuilder sb = new StringBuilder();
        sb.append(c).append(getId());
        sb.append(c).append(getName());
        sb.append(c).append(getPaths());
        sb.append(c).append(getIncludedPaths());
        sb.append(c).append(getExcludedPaths());
        sb.append(c).append(getIncludedDocPaths());
        sb.append(c).append(getExcludedDocPaths());
        sb.append(c).append(getDepth());
        sb.append(c).append(getMaxAccessCount());
        sb.append(c).append(getNumOfThread());
        sb.append(c).append(getIntervalTime());
        sb.append(c).append(getBoost());
        sb.append(c).append(getAvailable());
        sb.append(c).append(getSortOrder());
        sb.append(c).append(getCreatedBy());
        sb.append(c).append(getCreatedTime());
        sb.append(c).append(getUpdatedBy());
        sb.append(c).append(getUpdatedTime());
        sb.append(c).append(getDeletedBy());
        sb.append(c).append(getDeletedTime());
        sb.append(c).append(getVersionNo());
        if (sb.length() > 0) {
            sb.delete(0, c.length());
        }
        sb.insert(0, "{").append("}");
        return sb.toString();
    }

    protected String buildRelationString() {
        final StringBuilder sb = new StringBuilder();
        final String c = ",";
        if (_failureUrlList != null && !_failureUrlList.isEmpty()) {
            sb.append(c).append("failureUrlList");
        }
        if (_fileAuthenticationList != null
                && !_fileAuthenticationList.isEmpty()) {
            sb.append(c).append("fileAuthenticationList");
        }
        if (_fileConfigToBrowserTypeMappingList != null
                && !_fileConfigToBrowserTypeMappingList.isEmpty()) {
            sb.append(c).append("fileConfigToBrowserTypeMappingList");
        }
        if (_fileConfigToLabelTypeMappingList != null
                && !_fileConfigToLabelTypeMappingList.isEmpty()) {
            sb.append(c).append("fileConfigToLabelTypeMappingList");
        }
        if (_fileConfigToRoleTypeMappingList != null
                && !_fileConfigToRoleTypeMappingList.isEmpty()) {
            sb.append(c).append("fileConfigToRoleTypeMappingList");
        }
        if (sb.length() > 0) {
            sb.delete(0, c.length()).insert(0, "(").append(")");
        }
        return sb.toString();
    }

    // ===================================================================================
    //                                                                            Accessor
    //                                                                            ========
    /**
     * [get] ID: {PK, ID, NotNull, BIGINT(19)} <br />
     * @return The value of the column 'ID'. (NullAllowed)
     */
    public Long getId() {
        return _id;
    }

    /**
     * [set] ID: {PK, ID, NotNull, BIGINT(19)} <br />
     * @param id The value of the column 'ID'. (NullAllowed)
     */
    public void setId(final Long id) {
        __modifiedProperties.addPropertyName("id");
        _id = id;
    }

    /**
     * [get] NAME: {NotNull, VARCHAR(200)} <br />
     * @return The value of the column 'NAME'. (NullAllowed)
     */
    public String getName() {
        return _name;
    }

    /**
     * [set] NAME: {NotNull, VARCHAR(200)} <br />
     * @param name The value of the column 'NAME'. (NullAllowed)
     */
    public void setName(final String name) {
        __modifiedProperties.addPropertyName("name");
        _name = name;
    }

    /**
     * [get] PATHS: {NotNull, VARCHAR(4000)} <br />
     * @return The value of the column 'PATHS'. (NullAllowed)
     */
    public String getPaths() {
        return _paths;
    }

    /**
     * [set] PATHS: {NotNull, VARCHAR(4000)} <br />
     * @param paths The value of the column 'PATHS'. (NullAllowed)
     */
    public void setPaths(final String paths) {
        __modifiedProperties.addPropertyName("paths");
        _paths = paths;
    }

    /**
     * [get] INCLUDED_PATHS: {VARCHAR(4000)} <br />
     * @return The value of the column 'INCLUDED_PATHS'. (NullAllowed)
     */
    public String getIncludedPaths() {
        return _includedPaths;
    }

    /**
     * [set] INCLUDED_PATHS: {VARCHAR(4000)} <br />
     * @param includedPaths The value of the column 'INCLUDED_PATHS'. (NullAllowed)
     */
    public void setIncludedPaths(final String includedPaths) {
        __modifiedProperties.addPropertyName("includedPaths");
        _includedPaths = includedPaths;
    }

    /**
     * [get] EXCLUDED_PATHS: {VARCHAR(4000)} <br />
     * @return The value of the column 'EXCLUDED_PATHS'. (NullAllowed)
     */
    public String getExcludedPaths() {
        return _excludedPaths;
    }

    /**
     * [set] EXCLUDED_PATHS: {VARCHAR(4000)} <br />
     * @param excludedPaths The value of the column 'EXCLUDED_PATHS'. (NullAllowed)
     */
    public void setExcludedPaths(final String excludedPaths) {
        __modifiedProperties.addPropertyName("excludedPaths");
        _excludedPaths = excludedPaths;
    }

    /**
     * [get] INCLUDED_DOC_PATHS: {VARCHAR(4000)} <br />
     * @return The value of the column 'INCLUDED_DOC_PATHS'. (NullAllowed)
     */
    public String getIncludedDocPaths() {
        return _includedDocPaths;
    }

    /**
     * [set] INCLUDED_DOC_PATHS: {VARCHAR(4000)} <br />
     * @param includedDocPaths The value of the column 'INCLUDED_DOC_PATHS'. (NullAllowed)
     */
    public void setIncludedDocPaths(final String includedDocPaths) {
        __modifiedProperties.addPropertyName("includedDocPaths");
        _includedDocPaths = includedDocPaths;
    }

    /**
     * [get] EXCLUDED_DOC_PATHS: {VARCHAR(4000)} <br />
     * @return The value of the column 'EXCLUDED_DOC_PATHS'. (NullAllowed)
     */
    public String getExcludedDocPaths() {
        return _excludedDocPaths;
    }

    /**
     * [set] EXCLUDED_DOC_PATHS: {VARCHAR(4000)} <br />
     * @param excludedDocPaths The value of the column 'EXCLUDED_DOC_PATHS'. (NullAllowed)
     */
    public void setExcludedDocPaths(final String excludedDocPaths) {
        __modifiedProperties.addPropertyName("excludedDocPaths");
        _excludedDocPaths = excludedDocPaths;
    }

    /**
     * [get] DEPTH: {INTEGER(10)} <br />
     * @return The value of the column 'DEPTH'. (NullAllowed)
     */
    public Integer getDepth() {
        return _depth;
    }

    /**
     * [set] DEPTH: {INTEGER(10)} <br />
     * @param depth The value of the column 'DEPTH'. (NullAllowed)
     */
    public void setDepth(final Integer depth) {
        __modifiedProperties.addPropertyName("depth");
        _depth = depth;
    }

    /**
     * [get] MAX_ACCESS_COUNT: {BIGINT(19)} <br />
     * @return The value of the column 'MAX_ACCESS_COUNT'. (NullAllowed)
     */
    public Long getMaxAccessCount() {
        return _maxAccessCount;
    }

    /**
     * [set] MAX_ACCESS_COUNT: {BIGINT(19)} <br />
     * @param maxAccessCount The value of the column 'MAX_ACCESS_COUNT'. (NullAllowed)
     */
    public void setMaxAccessCount(final Long maxAccessCount) {
        __modifiedProperties.addPropertyName("maxAccessCount");
        _maxAccessCount = maxAccessCount;
    }

    /**
     * [get] NUM_OF_THREAD: {NotNull, INTEGER(10)} <br />
     * @return The value of the column 'NUM_OF_THREAD'. (NullAllowed)
     */
    public Integer getNumOfThread() {
        return _numOfThread;
    }

    /**
     * [set] NUM_OF_THREAD: {NotNull, INTEGER(10)} <br />
     * @param numOfThread The value of the column 'NUM_OF_THREAD'. (NullAllowed)
     */
    public void setNumOfThread(final Integer numOfThread) {
        __modifiedProperties.addPropertyName("numOfThread");
        _numOfThread = numOfThread;
    }

    /**
     * [get] INTERVAL_TIME: {NotNull, INTEGER(10)} <br />
     * @return The value of the column 'INTERVAL_TIME'. (NullAllowed)
     */
    public Integer getIntervalTime() {
        return _intervalTime;
    }

    /**
     * [set] INTERVAL_TIME: {NotNull, INTEGER(10)} <br />
     * @param intervalTime The value of the column 'INTERVAL_TIME'. (NullAllowed)
     */
    public void setIntervalTime(final Integer intervalTime) {
        __modifiedProperties.addPropertyName("intervalTime");
        _intervalTime = intervalTime;
    }

    /**
     * [get] BOOST: {NotNull, DOUBLE(17)} <br />
     * @return The value of the column 'BOOST'. (NullAllowed)
     */
    public java.math.BigDecimal getBoost() {
        return _boost;
    }

    /**
     * [set] BOOST: {NotNull, DOUBLE(17)} <br />
     * @param boost The value of the column 'BOOST'. (NullAllowed)
     */
    public void setBoost(final java.math.BigDecimal boost) {
        __modifiedProperties.addPropertyName("boost");
        _boost = boost;
    }

    /**
     * [get] AVAILABLE: {NotNull, VARCHAR(1)} <br />
     * @return The value of the column 'AVAILABLE'. (NullAllowed)
     */
    public String getAvailable() {
        return _available;
    }

    /**
     * [set] AVAILABLE: {NotNull, VARCHAR(1)} <br />
     * @param available The value of the column 'AVAILABLE'. (NullAllowed)
     */
    public void setAvailable(final String available) {
        __modifiedProperties.addPropertyName("available");
        _available = available;
    }

    /**
     * [get] SORT_ORDER: {NotNull, INTEGER(10)} <br />
     * @return The value of the column 'SORT_ORDER'. (NullAllowed)
     */
    public Integer getSortOrder() {
        return _sortOrder;
    }

    /**
     * [set] SORT_ORDER: {NotNull, INTEGER(10)} <br />
     * @param sortOrder The value of the column 'SORT_ORDER'. (NullAllowed)
     */
    public void setSortOrder(final Integer sortOrder) {
        __modifiedProperties.addPropertyName("sortOrder");
        _sortOrder = sortOrder;
    }

    /**
     * [get] CREATED_BY: {NotNull, VARCHAR(255)} <br />
     * @return The value of the column 'CREATED_BY'. (NullAllowed)
     */
    public String getCreatedBy() {
        return _createdBy;
    }

    /**
     * [set] CREATED_BY: {NotNull, VARCHAR(255)} <br />
     * @param createdBy The value of the column 'CREATED_BY'. (NullAllowed)
     */
    public void setCreatedBy(final String createdBy) {
        __modifiedProperties.addPropertyName("createdBy");
        _createdBy = createdBy;
    }

    /**
     * [get] CREATED_TIME: {NotNull, TIMESTAMP(23, 10)} <br />
     * @return The value of the column 'CREATED_TIME'. (NullAllowed)
     */
    public java.sql.Timestamp getCreatedTime() {
        return _createdTime;
    }

    /**
     * [set] CREATED_TIME: {NotNull, TIMESTAMP(23, 10)} <br />
     * @param createdTime The value of the column 'CREATED_TIME'. (NullAllowed)
     */
    public void setCreatedTime(final java.sql.Timestamp createdTime) {
        __modifiedProperties.addPropertyName("createdTime");
        _createdTime = createdTime;
    }

    /**
     * [get] UPDATED_BY: {VARCHAR(255)} <br />
     * @return The value of the column 'UPDATED_BY'. (NullAllowed)
     */
    public String getUpdatedBy() {
        return _updatedBy;
    }

    /**
     * [set] UPDATED_BY: {VARCHAR(255)} <br />
     * @param updatedBy The value of the column 'UPDATED_BY'. (NullAllowed)
     */
    public void setUpdatedBy(final String updatedBy) {
        __modifiedProperties.addPropertyName("updatedBy");
        _updatedBy = updatedBy;
    }

    /**
     * [get] UPDATED_TIME: {TIMESTAMP(23, 10)} <br />
     * @return The value of the column 'UPDATED_TIME'. (NullAllowed)
     */
    public java.sql.Timestamp getUpdatedTime() {
        return _updatedTime;
    }

    /**
     * [set] UPDATED_TIME: {TIMESTAMP(23, 10)} <br />
     * @param updatedTime The value of the column 'UPDATED_TIME'. (NullAllowed)
     */
    public void setUpdatedTime(final java.sql.Timestamp updatedTime) {
        __modifiedProperties.addPropertyName("updatedTime");
        _updatedTime = updatedTime;
    }

    /**
     * [get] DELETED_BY: {VARCHAR(255)} <br />
     * @return The value of the column 'DELETED_BY'. (NullAllowed)
     */
    public String getDeletedBy() {
        return _deletedBy;
    }

    /**
     * [set] DELETED_BY: {VARCHAR(255)} <br />
     * @param deletedBy The value of the column 'DELETED_BY'. (NullAllowed)
     */
    public void setDeletedBy(final String deletedBy) {
        __modifiedProperties.addPropertyName("deletedBy");
        _deletedBy = deletedBy;
    }

    /**
     * [get] DELETED_TIME: {TIMESTAMP(23, 10)} <br />
     * @return The value of the column 'DELETED_TIME'. (NullAllowed)
     */
    public java.sql.Timestamp getDeletedTime() {
        return _deletedTime;
    }

    /**
     * [set] DELETED_TIME: {TIMESTAMP(23, 10)} <br />
     * @param deletedTime The value of the column 'DELETED_TIME'. (NullAllowed)
     */
    public void setDeletedTime(final java.sql.Timestamp deletedTime) {
        __modifiedProperties.addPropertyName("deletedTime");
        _deletedTime = deletedTime;
    }

    /**
     * [get] VERSION_NO: {NotNull, INTEGER(10)} <br />
     * @return The value of the column 'VERSION_NO'. (NullAllowed)
     */
    public Integer getVersionNo() {
        return _versionNo;
    }

    /**
     * [set] VERSION_NO: {NotNull, INTEGER(10)} <br />
     * @param versionNo The value of the column 'VERSION_NO'. (NullAllowed)
     */
    public void setVersionNo(final Integer versionNo) {
        __modifiedProperties.addPropertyName("versionNo");
        _versionNo = versionNo;
    }
}
