/*
 * Copyright 2009-2009 the Fess Project and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package jp.sf.fess.db.cbean.bs;

import java.util.Map;

import jp.sf.fess.db.allcommon.DBFluteConfig;
import jp.sf.fess.db.allcommon.DBMetaInstanceHandler;
import jp.sf.fess.db.allcommon.ImplementedSqlClauseCreator;
import jp.sf.fess.db.cbean.BrowserTypeCB;
import jp.sf.fess.db.cbean.FileConfigToBrowserTypeMappingCB;
import jp.sf.fess.db.cbean.FileCrawlingConfigCB;
import jp.sf.fess.db.cbean.cq.BrowserTypeCQ;
import jp.sf.fess.db.cbean.cq.FileConfigToBrowserTypeMappingCQ;
import jp.sf.fess.db.cbean.cq.FileCrawlingConfigCQ;
import jp.sf.fess.db.cbean.nss.BrowserTypeNss;
import jp.sf.fess.db.cbean.nss.FileCrawlingConfigNss;

import org.seasar.dbflute.cbean.AbstractConditionBean;
import org.seasar.dbflute.cbean.ConditionBean;
import org.seasar.dbflute.cbean.ConditionQuery;
import org.seasar.dbflute.cbean.SubQuery;
import org.seasar.dbflute.cbean.UnionQuery;
import org.seasar.dbflute.cbean.sqlclause.SqlClause;
import org.seasar.dbflute.dbmeta.DBMetaProvider;

/**
 * The base condition-bean of FILE_CONFIG_TO_BROWSER_TYPE_MAPPING.
 * @author DBFlute(AutoGenerator)
 */
public class BsFileConfigToBrowserTypeMappingCB extends AbstractConditionBean {

    // ===================================================================================
    //                                                                           Attribute
    //                                                                           =========
    private final DBMetaProvider _dbmetaProvider = new DBMetaInstanceHandler();

    protected FileConfigToBrowserTypeMappingCQ _conditionQuery;

    // ===================================================================================
    //                                                                           SqlClause
    //                                                                           =========
    @Override
    protected SqlClause createSqlClause() {
        return new ImplementedSqlClauseCreator().createSqlClause(this);
    }

    // ===================================================================================
    //                                                                     DBMeta Provider
    //                                                                     ===============
    @Override
    protected DBMetaProvider getDBMetaProvider() {
        return _dbmetaProvider;
    }

    // ===================================================================================
    //                                                                          Table Name
    //                                                                          ==========
    public String getTableDbName() {
        return "FILE_CONFIG_TO_BROWSER_TYPE_MAPPING";
    }

    public String getTableSqlName() {
        return "FILE_CONFIG_TO_BROWSER_TYPE_MAPPING";
    }

    // ===================================================================================
    //                                                                      PrimaryKey Map
    //                                                                      ==============
    public void acceptPrimaryKeyMap(Map<String, ? extends Object> primaryKeyMap) {
        assertPrimaryKeyMap(primaryKeyMap);
        {
            Object obj = primaryKeyMap.get("ID");
            if (obj instanceof Long) {
                query().setId_Equal((Long) obj);
            } else {
                query().setId_Equal(new Long((String) obj));
            }
        }

    }

    // ===================================================================================
    //                                                                     OrderBy Setting
    //                                                                     ===============
    public ConditionBean addOrderBy_PK_Asc() {
        query().addOrderBy_Id_Asc();
        return this;
    }

    public ConditionBean addOrderBy_PK_Desc() {
        query().addOrderBy_Id_Desc();
        return this;
    }

    // ===================================================================================
    //                                                                               Query
    //                                                                               =====
    public FileConfigToBrowserTypeMappingCQ query() {
        return getConditionQuery();
    }

    public FileConfigToBrowserTypeMappingCQ getConditionQuery() {
        if (_conditionQuery == null) {
            _conditionQuery = new FileConfigToBrowserTypeMappingCQ(null,
                    getSqlClause(), getSqlClause().getLocalTableAliasName(), 0);
        }
        return _conditionQuery;
    }

    /**
     * {@inheritDoc}
     */
    public ConditionQuery localCQ() {
        return getConditionQuery();
    }

    // ===================================================================================
    //                                                                               Union
    //                                                                               =====
    /**
     * Set up 'union'.
     * <pre>
     * cb.query().union(new UnionQuery&lt;FileConfigToBrowserTypeMappingCB&gt;() {
     *     public void query(FileConfigToBrowserTypeMappingCB unionCB) {
     *         unionCB.query().setXxx...
     *     }
     * });
     * </pre>
     * @param unionQuery The query of 'union'. (NotNull)
     */
    public void union(UnionQuery<FileConfigToBrowserTypeMappingCB> unionQuery) {
        final FileConfigToBrowserTypeMappingCB cb = new FileConfigToBrowserTypeMappingCB();
        cb.xsetupForUnion();
        unionQuery.query(cb);
        final FileConfigToBrowserTypeMappingCQ cq = cb.query();
        query().xsetUnionQuery(cq);
    }

    /**
     * Set up 'union all'.
     * <pre>
     * cb.query().unionAll(new UnionQuery&lt;FileConfigToBrowserTypeMappingCB&gt;() {
     *     public void query(FileConfigToBrowserTypeMappingCB unionCB) {
     *         unionCB.query().setXxx...
     *     }
     * });
     * </pre>
     * @param unionQuery The query of 'union'. (NotNull)
     */
    public void unionAll(UnionQuery<FileConfigToBrowserTypeMappingCB> unionQuery) {
        final FileConfigToBrowserTypeMappingCB cb = new FileConfigToBrowserTypeMappingCB();
        cb.xsetupForUnion();
        unionQuery.query(cb);
        final FileConfigToBrowserTypeMappingCQ cq = cb.query();
        query().xsetUnionAllQuery(cq);
    }

    public boolean hasUnionQueryOrUnionAllQuery() {
        return query().hasUnionQueryOrUnionAllQuery();
    }

    // ===================================================================================
    //                                                                        Setup Select
    //                                                                        ============
    protected BrowserTypeNss _nssBrowserType;

    public BrowserTypeNss getNssBrowserType() {
        if (_nssBrowserType == null) {
            _nssBrowserType = new BrowserTypeNss(null);
        }
        return _nssBrowserType;
    }

    public BrowserTypeNss setupSelect_BrowserType() {
        doSetupSelect(new SsCall() {
            public ConditionQuery qf() {
                return query().queryBrowserType();
            }
        });
        if (_nssBrowserType == null || !_nssBrowserType.hasConditionQuery()) {
            _nssBrowserType = new BrowserTypeNss(query().queryBrowserType());
        }
        return _nssBrowserType;
    }

    protected FileCrawlingConfigNss _nssFileCrawlingConfig;

    public FileCrawlingConfigNss getNssFileCrawlingConfig() {
        if (_nssFileCrawlingConfig == null) {
            _nssFileCrawlingConfig = new FileCrawlingConfigNss(null);
        }
        return _nssFileCrawlingConfig;
    }

    public FileCrawlingConfigNss setupSelect_FileCrawlingConfig() {
        doSetupSelect(new SsCall() {
            public ConditionQuery qf() {
                return query().queryFileCrawlingConfig();
            }
        });
        if (_nssFileCrawlingConfig == null
                || !_nssFileCrawlingConfig.hasConditionQuery()) {
            _nssFileCrawlingConfig = new FileCrawlingConfigNss(query()
                    .queryFileCrawlingConfig());
        }
        return _nssFileCrawlingConfig;
    }

    // [DBFlute-0.7.4]
    // ===================================================================================
    //                                                                             Specify
    //                                                                             =======
    protected Specification _specification;

    public Specification specify() {
        if (_specification == null) {
            _specification = new Specification(this,
                    new SpQyCall<FileConfigToBrowserTypeMappingCQ>() {
                        public boolean has() {
                            return true;
                        }

                        public FileConfigToBrowserTypeMappingCQ qy() {
                            return query();
                        }
                    }, _forDerivedReferrer, _forScalarSelect,
                    _forScalarSubQuery, getDBMetaProvider());
        }
        return _specification;
    }

    public static class Specification extends
            AbstractSpecification<FileConfigToBrowserTypeMappingCQ> {
        protected SpQyCall<FileConfigToBrowserTypeMappingCQ> _myQyCall;

        protected BrowserTypeCB.Specification _browserType;

        protected FileCrawlingConfigCB.Specification _fileCrawlingConfig;

        public Specification(ConditionBean baseCB,
                SpQyCall<FileConfigToBrowserTypeMappingCQ> qyCall,
                boolean forDeriveReferrer, boolean forScalarSelect,
                boolean forScalarSubQuery, DBMetaProvider dbmetaProvider) {
            super(baseCB, qyCall, forDeriveReferrer, forScalarSelect,
                    forScalarSubQuery, dbmetaProvider);
            _myQyCall = qyCall;
        }

        public void columnId() {
            doColumn("ID");
        }

        public void columnFileConfigId() {
            doColumn("FILE_CONFIG_ID");
        }

        public void columnBrowserTypeId() {
            doColumn("BROWSER_TYPE_ID");
        }

        protected void doSpecifyRequiredColumn() {
            columnId(); // PK
            if (_myQyCall.qy().hasConditionQueryBrowserType()) {
                columnBrowserTypeId(); // FK
            }
            if (_myQyCall.qy().hasConditionQueryFileCrawlingConfig()) {
                columnFileConfigId(); // FK
            }
        }

        protected String getTableDbName() {
            return "FILE_CONFIG_TO_BROWSER_TYPE_MAPPING";
        }

        public BrowserTypeCB.Specification specifyBrowserType() {
            assertForeign("browserType");
            if (_browserType == null) {
                _browserType = new BrowserTypeCB.Specification(
                        _baseCB,
                        new SpQyCall<BrowserTypeCQ>() {
                            public boolean has() {
                                return _myQyCall.has()
                                        && _myQyCall.qy()
                                                .hasConditionQueryBrowserType();
                            }

                            public BrowserTypeCQ qy() {
                                return _myQyCall.qy().queryBrowserType();
                            }
                        }, _forDerivedReferrer, _forScalarSelect,
                        _forScalarSubQuery, _dbmetaProvider);
            }
            return _browserType;
        }

        public FileCrawlingConfigCB.Specification specifyFileCrawlingConfig() {
            assertForeign("fileCrawlingConfig");
            if (_fileCrawlingConfig == null) {
                _fileCrawlingConfig = new FileCrawlingConfigCB.Specification(
                        _baseCB,
                        new SpQyCall<FileCrawlingConfigCQ>() {
                            public boolean has() {
                                return _myQyCall.has()
                                        && _myQyCall
                                                .qy()
                                                .hasConditionQueryFileCrawlingConfig();
                            }

                            public FileCrawlingConfigCQ qy() {
                                return _myQyCall.qy().queryFileCrawlingConfig();
                            }
                        }, _forDerivedReferrer, _forScalarSelect,
                        _forScalarSubQuery, _dbmetaProvider);
            }
            return _fileCrawlingConfig;
        }
    }

    // ===================================================================================
    //                                                                         Display SQL
    //                                                                         ===========
    @Override
    protected String getLogDateFormat() {
        return DBFluteConfig.getInstance().getLogDateFormat();
    }

    @Override
    protected String getLogTimestampFormat() {
        return DBFluteConfig.getInstance().getLogTimestampFormat();
    }

    // ===================================================================================
    //                                                                            Internal
    //                                                                            ========
    // Very Internal (for Suppressing Warn about 'Not Use Import')
    protected String getConditionBeanClassNameInternally() {
        return FileConfigToBrowserTypeMappingCB.class.getName();
    }

    protected String getConditionQueryClassNameInternally() {
        return FileConfigToBrowserTypeMappingCQ.class.getName();
    }

    protected String getSubQueryClassNameInternally() {
        return SubQuery.class.getName();
    }
}
