/*
 * Copyright 2009-2010 the Fess Project and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package jp.sf.fess.db.cbean.cq.bs;

import java.util.Collection;

import jp.sf.fess.db.allcommon.DBMetaInstanceHandler;
import jp.sf.fess.db.cbean.FileConfigToRoleTypeMappingCB;
import jp.sf.fess.db.cbean.FileCrawlingConfigCB;
import jp.sf.fess.db.cbean.RoleTypeCB;
import jp.sf.fess.db.cbean.cq.FileConfigToRoleTypeMappingCQ;
import jp.sf.fess.db.cbean.cq.FileCrawlingConfigCQ;
import jp.sf.fess.db.cbean.cq.RoleTypeCQ;

import org.seasar.dbflute.cbean.AbstractConditionQuery;
import org.seasar.dbflute.cbean.ConditionQuery;
import org.seasar.dbflute.cbean.SubQuery;
import org.seasar.dbflute.cbean.ckey.ConditionKey;
import org.seasar.dbflute.cbean.coption.LikeSearchOption;
import org.seasar.dbflute.cbean.cvalue.ConditionValue;
import org.seasar.dbflute.cbean.sqlclause.SqlClause;
import org.seasar.dbflute.dbmeta.DBMetaProvider;

/**
 * The abstract condition-query of FILE_CONFIG_TO_ROLE_TYPE_MAPPING.
 * @author DBFlute(AutoGenerator)
 */
public abstract class AbstractBsFileConfigToRoleTypeMappingCQ extends
        AbstractConditionQuery {

    // ===================================================================================
    //                                                                           Attribute
    //                                                                           =========
    protected final DBMetaProvider _dbmetaProvider = new DBMetaInstanceHandler();

    // ===================================================================================
    //                                                                         Constructor
    //                                                                         ===========
    public AbstractBsFileConfigToRoleTypeMappingCQ(ConditionQuery childQuery,
            SqlClause sqlClause, String aliasName, int nestLevel) {
        super(childQuery, sqlClause, aliasName, nestLevel);
    }

    // ===================================================================================
    //                                                                     DBMeta Provider
    //                                                                     ===============
    @Override
    protected DBMetaProvider getDBMetaProvider() {
        return _dbmetaProvider;
    }

    // ===================================================================================
    //                                                                          Table Name
    //                                                                          ==========
    public String getTableDbName() {
        return "FILE_CONFIG_TO_ROLE_TYPE_MAPPING";
    }

    public String getTableSqlName() {
        return "FILE_CONFIG_TO_ROLE_TYPE_MAPPING";
    }

    // ===================================================================================
    //                                                                               Query
    //                                                                               =====

    /**
     * Equal(=). And NullIgnored, OnlyOnceRegistered. {PK : ID : NotNull : BIGINT}
     * @param id The value of id as equal.
     */
    public void setId_Equal(Long id) {
        regId(CK_EQ, id);
    }

    /**
     * NotEqual(!=). And NullIgnored, OnlyOnceRegistered.
     * @param id The value of id as notEqual.
     */
    public void setId_NotEqual(Long id) {
        regId(CK_NE, id);
    }

    /**
     * GreaterThan(&gt;). And NullIgnored, OnlyOnceRegistered.
     * @param id The value of id as greaterThan.
     */
    public void setId_GreaterThan(Long id) {
        regId(CK_GT, id);
    }

    /**
     * LessThan(&lt;). And NullIgnored, OnlyOnceRegistered.
     * @param id The value of id as lessThan.
     */
    public void setId_LessThan(Long id) {
        regId(CK_LT, id);
    }

    /**
     * GreaterEqual(&gt;=). And NullIgnored, OnlyOnceRegistered.
     * @param id The value of id as greaterEqual.
     */
    public void setId_GreaterEqual(Long id) {
        regId(CK_GE, id);
    }

    /**
     * LessEqual(&lt;=). And NullIgnored, OnlyOnceRegistered.
     * @param id The value of id as lessEqual.
     */
    public void setId_LessEqual(Long id) {
        regId(CK_LE, id);
    }

    /**
     * InScope(in (1, 2)). And NullIgnored, NullElementIgnored, SeveralRegistered.
     * @param idList The collection of id as inScope.
     */
    public void setId_InScope(Collection<Long> idList) {
        regINS(CK_INS, cTL(idList), getCValueId(), "ID");
    }

    /**
     * NotInScope(not in (1, 2)). And NullIgnored, NullElementIgnored, SeveralRegistered.
     * @param idList The collection of id as notInScope.
     */
    public void setId_NotInScope(Collection<Long> idList) {
        regINS(CK_NINS, cTL(idList), getCValueId(), "ID");
    }

    /**
     * IsNull(is null). And OnlyOnceRegistered.
     */
    public void setId_IsNull() {
        regId(CK_ISN, DOBJ);
    }

    /**
     * IsNotNull(is not null). And OnlyOnceRegistered.
     */
    public void setId_IsNotNull() {
        regId(CK_ISNN, DOBJ);
    }

    protected void regId(ConditionKey k, Object v) {
        regQ(k, v, getCValueId(), "ID");
    }

    abstract protected ConditionValue getCValueId();

    /**
     * Equal(=). And NullIgnored, OnlyOnceRegistered. {NotNull : BIGINT : FK to FILE_CRAWLING_CONFIG}
     * @param fileConfigId The value of fileConfigId as equal.
     */
    public void setFileConfigId_Equal(Long fileConfigId) {
        regFileConfigId(CK_EQ, fileConfigId);
    }

    /**
     * NotEqual(!=). And NullIgnored, OnlyOnceRegistered.
     * @param fileConfigId The value of fileConfigId as notEqual.
     */
    public void setFileConfigId_NotEqual(Long fileConfigId) {
        regFileConfigId(CK_NE, fileConfigId);
    }

    /**
     * GreaterThan(&gt;). And NullIgnored, OnlyOnceRegistered.
     * @param fileConfigId The value of fileConfigId as greaterThan.
     */
    public void setFileConfigId_GreaterThan(Long fileConfigId) {
        regFileConfigId(CK_GT, fileConfigId);
    }

    /**
     * LessThan(&lt;). And NullIgnored, OnlyOnceRegistered.
     * @param fileConfigId The value of fileConfigId as lessThan.
     */
    public void setFileConfigId_LessThan(Long fileConfigId) {
        regFileConfigId(CK_LT, fileConfigId);
    }

    /**
     * GreaterEqual(&gt;=). And NullIgnored, OnlyOnceRegistered.
     * @param fileConfigId The value of fileConfigId as greaterEqual.
     */
    public void setFileConfigId_GreaterEqual(Long fileConfigId) {
        regFileConfigId(CK_GE, fileConfigId);
    }

    /**
     * LessEqual(&lt;=). And NullIgnored, OnlyOnceRegistered.
     * @param fileConfigId The value of fileConfigId as lessEqual.
     */
    public void setFileConfigId_LessEqual(Long fileConfigId) {
        regFileConfigId(CK_LE, fileConfigId);
    }

    /**
     * InScope(in (1, 2)). And NullIgnored, NullElementIgnored, SeveralRegistered.
     * @param fileConfigIdList The collection of fileConfigId as inScope.
     */
    public void setFileConfigId_InScope(Collection<Long> fileConfigIdList) {
        regINS(CK_INS, cTL(fileConfigIdList), getCValueFileConfigId(),
                "FILE_CONFIG_ID");
    }

    /**
     * NotInScope(not in (1, 2)). And NullIgnored, NullElementIgnored, SeveralRegistered.
     * @param fileConfigIdList The collection of fileConfigId as notInScope.
     */
    public void setFileConfigId_NotInScope(Collection<Long> fileConfigIdList) {
        regINS(CK_NINS, cTL(fileConfigIdList), getCValueFileConfigId(),
                "FILE_CONFIG_ID");
    }

    public void inScopeFileCrawlingConfig(
            SubQuery<FileCrawlingConfigCB> subQuery) {
        assertObjectNotNull("subQuery<FileCrawlingConfigCB>", subQuery);
        FileCrawlingConfigCB cb = new FileCrawlingConfigCB();
        cb.xsetupForInScopeSubQuery();
        subQuery.query(cb);
        String subQueryPropertyName = keepFileConfigId_InScopeSubQuery_FileCrawlingConfig(cb
                .query()); // for saving query-value.
        registerInScopeSubQuery(cb.query(), "FILE_CONFIG_ID", "ID",
                subQueryPropertyName);
    }

    public abstract String keepFileConfigId_InScopeSubQuery_FileCrawlingConfig(
            FileCrawlingConfigCQ subQuery);

    protected void regFileConfigId(ConditionKey k, Object v) {
        regQ(k, v, getCValueFileConfigId(), "FILE_CONFIG_ID");
    }

    abstract protected ConditionValue getCValueFileConfigId();

    /**
     * Equal(=). And NullIgnored, OnlyOnceRegistered. {NotNull : BIGINT : FK to ROLE_TYPE}
     * @param roleTypeId The value of roleTypeId as equal.
     */
    public void setRoleTypeId_Equal(Long roleTypeId) {
        regRoleTypeId(CK_EQ, roleTypeId);
    }

    /**
     * NotEqual(!=). And NullIgnored, OnlyOnceRegistered.
     * @param roleTypeId The value of roleTypeId as notEqual.
     */
    public void setRoleTypeId_NotEqual(Long roleTypeId) {
        regRoleTypeId(CK_NE, roleTypeId);
    }

    /**
     * GreaterThan(&gt;). And NullIgnored, OnlyOnceRegistered.
     * @param roleTypeId The value of roleTypeId as greaterThan.
     */
    public void setRoleTypeId_GreaterThan(Long roleTypeId) {
        regRoleTypeId(CK_GT, roleTypeId);
    }

    /**
     * LessThan(&lt;). And NullIgnored, OnlyOnceRegistered.
     * @param roleTypeId The value of roleTypeId as lessThan.
     */
    public void setRoleTypeId_LessThan(Long roleTypeId) {
        regRoleTypeId(CK_LT, roleTypeId);
    }

    /**
     * GreaterEqual(&gt;=). And NullIgnored, OnlyOnceRegistered.
     * @param roleTypeId The value of roleTypeId as greaterEqual.
     */
    public void setRoleTypeId_GreaterEqual(Long roleTypeId) {
        regRoleTypeId(CK_GE, roleTypeId);
    }

    /**
     * LessEqual(&lt;=). And NullIgnored, OnlyOnceRegistered.
     * @param roleTypeId The value of roleTypeId as lessEqual.
     */
    public void setRoleTypeId_LessEqual(Long roleTypeId) {
        regRoleTypeId(CK_LE, roleTypeId);
    }

    /**
     * InScope(in (1, 2)). And NullIgnored, NullElementIgnored, SeveralRegistered.
     * @param roleTypeIdList The collection of roleTypeId as inScope.
     */
    public void setRoleTypeId_InScope(Collection<Long> roleTypeIdList) {
        regINS(CK_INS, cTL(roleTypeIdList), getCValueRoleTypeId(),
                "ROLE_TYPE_ID");
    }

    /**
     * NotInScope(not in (1, 2)). And NullIgnored, NullElementIgnored, SeveralRegistered.
     * @param roleTypeIdList The collection of roleTypeId as notInScope.
     */
    public void setRoleTypeId_NotInScope(Collection<Long> roleTypeIdList) {
        regINS(CK_NINS, cTL(roleTypeIdList), getCValueRoleTypeId(),
                "ROLE_TYPE_ID");
    }

    public void inScopeRoleType(SubQuery<RoleTypeCB> subQuery) {
        assertObjectNotNull("subQuery<RoleTypeCB>", subQuery);
        RoleTypeCB cb = new RoleTypeCB();
        cb.xsetupForInScopeSubQuery();
        subQuery.query(cb);
        String subQueryPropertyName = keepRoleTypeId_InScopeSubQuery_RoleType(cb
                .query()); // for saving query-value.
        registerInScopeSubQuery(cb.query(), "ROLE_TYPE_ID", "ID",
                subQueryPropertyName);
    }

    public abstract String keepRoleTypeId_InScopeSubQuery_RoleType(
            RoleTypeCQ subQuery);

    protected void regRoleTypeId(ConditionKey k, Object v) {
        regQ(k, v, getCValueRoleTypeId(), "ROLE_TYPE_ID");
    }

    abstract protected ConditionValue getCValueRoleTypeId();

    // ===================================================================================
    //                                                                     Scalar SubQuery
    //                                                                     ===============
    public SSQFunction<FileConfigToRoleTypeMappingCB> scalar_Equal() {
        return xcreateSSQFunction("=");
    }

    public SSQFunction<FileConfigToRoleTypeMappingCB> scalar_GreaterEqual() {
        return xcreateSSQFunction(">=");
    }

    public SSQFunction<FileConfigToRoleTypeMappingCB> scalar_GreaterThan() {
        return xcreateSSQFunction(">");
    }

    public SSQFunction<FileConfigToRoleTypeMappingCB> scalar_LessEqual() {
        return xcreateSSQFunction("<=");
    }

    public SSQFunction<FileConfigToRoleTypeMappingCB> scalar_LessThan() {
        return xcreateSSQFunction("<");
    }

    protected SSQFunction<FileConfigToRoleTypeMappingCB> xcreateSSQFunction(
            final String operand) {
        return new SSQFunction<FileConfigToRoleTypeMappingCB>(
                new SSQSetupper<FileConfigToRoleTypeMappingCB>() {
                    public void setup(String function,
                            SubQuery<FileConfigToRoleTypeMappingCB> subQuery) {
                        xscalarSubQuery(function, subQuery, operand);
                    }
                });
    }

    protected void xscalarSubQuery(String function,
            SubQuery<FileConfigToRoleTypeMappingCB> subQuery, String operand) {
        assertObjectNotNull("subQuery<FileConfigToRoleTypeMappingCB>", subQuery);
        FileConfigToRoleTypeMappingCB cb = new FileConfigToRoleTypeMappingCB();
        cb.xsetupForScalarSubQuery();
        subQuery.query(cb);
        String subQueryPropertyName = keepScalarSubQuery(cb.query()); // for saving query-value.
        registerScalarSubQuery(function, cb.query(), subQueryPropertyName,
                operand);
    }

    public abstract String keepScalarSubQuery(
            FileConfigToRoleTypeMappingCQ subQuery);

    // ===================================================================================
    //                                                             MySelf InScope SubQuery
    //                                                             =======================
    /**
     * Myself InScope SubQuery. {mainly for CLOB and Union}
     * @param subQuery The implementation of sub query. (NotNull)
     */
    public void myselfInScope(SubQuery<FileConfigToRoleTypeMappingCB> subQuery) {
        assertObjectNotNull("subQuery<FileConfigToRoleTypeMappingCB>", subQuery);
        FileConfigToRoleTypeMappingCB cb = new FileConfigToRoleTypeMappingCB();
        cb.xsetupForInScopeSubQuery();
        subQuery.query(cb);
        String subQueryPropertyName = keepMyselfInScopeSubQuery(cb.query()); // for saving query-value.
        registerInScopeSubQuery(cb.query(), "ID", "ID", subQueryPropertyName);
    }

    public abstract String keepMyselfInScopeSubQuery(
            FileConfigToRoleTypeMappingCQ subQuery);

    // ===================================================================================
    //                                                                       Very Internal
    //                                                                       =============
    // Very Internal (for Suppressing Warn about 'Not Use Import')
    String xCB() {
        return FileConfigToRoleTypeMappingCB.class.getName();
    }

    String xCQ() {
        return FileConfigToRoleTypeMappingCQ.class.getName();
    }

    String xLSO() {
        return LikeSearchOption.class.getName();
    }
}
