/*
 * Copyright 2009-2011 the Fess Project and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */

package jp.sf.fess.helper;

public class IntervalControlHelper {
    private volatile boolean crawlerRunning = true;

    public long crawlerWaitMillis = 10000;

    public void checkCrawlerStatus() {
        while (!crawlerRunning) {
            try {
                Thread.sleep(crawlerWaitMillis);
            } catch (final InterruptedException e) {
            }
        }
    }

    public boolean isCrawlerRunning() {
        return crawlerRunning;
    }

    public void setCrawlerRunning(final boolean crawlerRunning) {
        this.crawlerRunning = crawlerRunning;
    }

}
