/*
 * Copyright 2009-2009 the Fess Project and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package jp.sf.fess.service;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;

import jp.sf.fess.Constants;
import jp.sf.fess.crud.CrudMessageException;
import jp.sf.fess.crud.service.BsFileCrawlingConfigService;
import jp.sf.fess.db.cbean.FileConfigToBrowserTypeMappingCB;
import jp.sf.fess.db.cbean.FileCrawlingConfigCB;
import jp.sf.fess.db.exbhv.FileConfigToBrowserTypeMappingBhv;
import jp.sf.fess.db.exentity.FileConfigToBrowserTypeMapping;
import jp.sf.fess.db.exentity.FileCrawlingConfig;
import jp.sf.fess.pager.FileCrawlingConfigPager;

import org.seasar.dbflute.bhv.ConditionBeanSetupper;

public class FileCrawlingConfigService extends BsFileCrawlingConfigService
        implements Serializable {

    private static final long serialVersionUID = 1L;

    @Resource
    protected FileConfigToBrowserTypeMappingBhv fileConfigToBrowserTypeMappingBhv;

    public List<FileCrawlingConfig> getAllFileCrawlingConfigList() {
        FileCrawlingConfigCB cb = new FileCrawlingConfigCB();
        cb.query().setDeletedBy_IsNull();
        cb.query().setAvailable_Equal(Constants.T);
        List<FileCrawlingConfig> list = fileCrawlingConfigBhv.selectList(cb);
        final ConditionBeanSetupper<FileConfigToBrowserTypeMappingCB> setupper = new ConditionBeanSetupper<FileConfigToBrowserTypeMappingCB>() {
            public void setup(FileConfigToBrowserTypeMappingCB cb) {
                cb.setupSelect_BrowserType();
                cb.query().queryBrowserType().setDeletedBy_IsNull();
                cb.query().queryBrowserType().addOrderBy_SortOrder_Asc();
            }

        };
        fileCrawlingConfigBhv.loadFileConfigToBrowserTypeMappingList(list,
                setupper);
        return list;
    }

    public FileCrawlingConfig getFileCrawlingConfig(Map<String, String> keys) {
        FileCrawlingConfig fileCrawlingConfig = super
                .getFileCrawlingConfig(keys);

        if (fileCrawlingConfig != null) {
            FileConfigToBrowserTypeMappingCB cb = new FileConfigToBrowserTypeMappingCB();
            cb.query().setFileConfigId_Equal(fileCrawlingConfig.getId());
            cb.query().queryBrowserType().setDeletedBy_IsNull();
            cb.query().queryFileCrawlingConfig().setDeletedBy_IsNull();
            List<FileConfigToBrowserTypeMapping> list = fileConfigToBrowserTypeMappingBhv
                    .selectList(cb);
            if (!list.isEmpty()) {
                List<String> browserTypeIds = new ArrayList<String>(list.size());
                for (FileConfigToBrowserTypeMapping mapping : list) {
                    browserTypeIds.add(Long
                            .toString(mapping.getBrowserTypeId()));
                }
                fileCrawlingConfig.setBrowserTypeIds(browserTypeIds
                        .toArray(new String[browserTypeIds.size()]));
            }
        }

        return fileCrawlingConfig;
    }

    public void store(FileCrawlingConfig fileCrawlingConfig)
            throws CrudMessageException {
        boolean isNew = fileCrawlingConfig.getId() == null;
        String[] ids = fileCrawlingConfig.getBrowserTypeIds();
        super.store(fileCrawlingConfig);
        Long FileConfigId = fileCrawlingConfig.getId();
        if (ids != null) {
            if (isNew) {
                // Insert
                List<FileConfigToBrowserTypeMapping> list = new ArrayList<FileConfigToBrowserTypeMapping>();
                for (String id : ids) {
                    FileConfigToBrowserTypeMapping mapping = new FileConfigToBrowserTypeMapping();
                    mapping.setFileConfigId(FileConfigId);
                    mapping.setBrowserTypeId(Long.parseLong(id));
                    list.add(mapping);
                }
                fileConfigToBrowserTypeMappingBhv.batchInsert(list);
            } else {
                // Update
                FileConfigToBrowserTypeMappingCB cb = new FileConfigToBrowserTypeMappingCB();
                cb.query().setFileConfigId_Equal(FileConfigId);
                List<FileConfigToBrowserTypeMapping> list = fileConfigToBrowserTypeMappingBhv
                        .selectList(cb);
                List<FileConfigToBrowserTypeMapping> newList = new ArrayList<FileConfigToBrowserTypeMapping>();
                List<FileConfigToBrowserTypeMapping> matchedList = new ArrayList<FileConfigToBrowserTypeMapping>();
                for (String id : ids) {
                    Long browserTypeId = Long.parseLong(id);
                    boolean exist = false;
                    for (FileConfigToBrowserTypeMapping mapping : list) {
                        if (mapping.getBrowserTypeId().equals(browserTypeId)) {
                            exist = true;
                            matchedList.add(mapping);
                            break;
                        }
                    }
                    if (!exist) {
                        // new
                        FileConfigToBrowserTypeMapping mapping = new FileConfigToBrowserTypeMapping();
                        mapping.setFileConfigId(FileConfigId);
                        mapping.setBrowserTypeId(Long.parseLong(id));
                        newList.add(mapping);
                    }
                }
                list.removeAll(matchedList);
                fileConfigToBrowserTypeMappingBhv.batchInsert(newList);
                fileConfigToBrowserTypeMappingBhv.batchDelete(list);
            }
        }
    }

    protected void setupListCondition(FileCrawlingConfigCB cb,
            FileCrawlingConfigPager fileCrawlingConfigPager) {
        super.setupListCondition(cb, fileCrawlingConfigPager);

        // setup condition
        cb.query().setDeletedBy_IsNull();
        cb.query().addOrderBy_SortOrder_Asc();

        // search

    }

    protected void setupEntityCondition(FileCrawlingConfigCB cb,
            Map<String, String> keys) {
        super.setupEntityCondition(cb, keys);

        // setup condition
        cb.query().setDeletedBy_IsNull();

    }

    protected void setupStoreCondition(FileCrawlingConfig fileCrawlingConfig) {
        super.setupStoreCondition(fileCrawlingConfig);

        // setup condition

    }

    protected void setupDeleteCondition(FileCrawlingConfig fileCrawlingConfig) {
        super.setupDeleteCondition(fileCrawlingConfig);

        // setup condition

    }

}
