using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.Threading;
using FelicaLib;

namespace FelicaBalViewer
{
    public partial class MainForm : Form
    {
        const int pollingInterval = 500;
        Thread pollingThread;
        bool doPolling = true;

        Object thisLock = new Object();
        bool felicaExist = false;
        string felicaType = "";
        string felicaBal = "";

        delegate void GuiChange();

        public MainForm()
        {
            InitializeComponent();
            pollingThread = new Thread(new ThreadStart(polling));
            pollingThread.Start();
        }

        private void polling()
        {
            FelicaInfo prevInfo = null, newInfo = null;
            while (doPolling)
            {
                try
                {
                    newInfo = getBalance();
                }
                catch (Exception)
                {
                    newInfo = null;
                    doPolling = false;
                    MessageBox.Show("Failed to access PaSoRi", "Error", MessageBoxButtons.OK, MessageBoxIcon.Error);
                }
                
                if (newInfo != null && ! newInfo.isSameIDm(prevInfo) ||
                    newInfo == null && prevInfo != null) 
                {
                    lock (thisLock)
                    {
                        felicaExist = (newInfo != null);
                        if (felicaExist)
                        {
                            felicaType = newInfo.type;
                            felicaBal = newInfo.bal.ToString("#,##0");
                        }
                    }
                    applyGuiChange(new GuiChange(setText) + new GuiChange(setVisible));
                }
                // else no change.
                prevInfo = newInfo;

                if (doPolling)
                {
                    Thread.Sleep(pollingInterval);
                }
            }

            global::FelicaBalViewer.Properties.Settings.Default.MyTitlebarChecked = this.titlebarToolStripMenuItem.Checked;
            global::FelicaBalViewer.Properties.Settings.Default.MyTitlebarCheckState = this.titlebarToolStripMenuItem.CheckState;
            global::FelicaBalViewer.Properties.Settings.Default.MyTrayChecked = this.trayToolStripMenuItem.Checked;
            global::FelicaBalViewer.Properties.Settings.Default.MyTrayCheckState = this.trayToolStripMenuItem.CheckState;
            
            //lazy.. to avoid invalid size/location is saved.
            if (this.WindowState != FormWindowState.Minimized)
            {
                Properties.Settings.Default.Save();
            }
            applyGuiChange(Dispose);
            System.Environment.Exit(0);
        }
 
        private FelicaInfo getBalance()
        {
            //this throws exception
            Felica f = new Felica();

            FelicaInfo ret = new FelicaInfo();
            
            try
            {
                f.Polling((int)SystemCode.Common);
                ret.IDm = f.IDm();
                
                // EDY/NANACO/WAON
                //try NANACO first

                byte[] b;
                if ((b = f.ReadWithoutEncryption(0x564f, 0)) != null)
                {
                    //NANACO
                    ret.bal = (b[7] << 8) + b[8];
                    ret.type = "nanaco";
                    goto BalRetrieved;
                }
                else if ((b = f.ReadWithoutEncryption(0x170f, 0)) != null)
                {
                    //EDY
                    ret.bal = (b[14] << 8) + b[15];
                    ret.type = "Edy";
                    goto BalRetrieved;
                }
                else if ((b = f.ReadWithoutEncryption(0x680b, 0)) != null)
                {
                    //WAON
                    int seq = (b[13] << 8) + b[14];
                    int pos = 0;

                    for (; pos < 2; pos++)
                    {
                        b = f.ReadWithoutEncryption(0x680b, (pos+1)*2);
                        if ( b == null || seq > (b[13] << 8) + b[14])
                        {
                            break;
                        }
                        seq = (b[13] << 8) + b[14];
                    }
                    //if (pos == 3) pos--;
                    b = f.ReadWithoutEncryption(0x680b, pos*2 + 1);
                    if (b != null)
                    {
                        ret.bal = ((b[5] & 0x1f) << 11) + (b[6] << 3) + (b[7] >> 5);
                        ret.type = "WAON";
                        goto BalRetrieved;
                    }
                }

            }
            catch (Exception)
            {
            }


            try
            {
                f.Polling((int)SystemCode.Suica);
                ret.IDm = f.IDm();
                byte[] b;
                if ((b = f.ReadWithoutEncryption(0x090f, 0)) != null)
                {
                    //HIT
                    ret.bal = (b[11] << 8) + b[10];
                    ret.type = "Suica";
                    goto BalRetrieved;
                }
            }
            catch (Exception)
            {
            }
            ret = null;

            BalRetrieved:

            try
            {
                f.Dispose();
            }
            catch (Exception)
            {
            }




            return ret;
        }

        private static Felica getFelica(SystemCode[] codes)
        {
            Felica f = new Felica();
            foreach (SystemCode code in codes)
            {
                try
                {
                    return f;
                }
                catch (Exception)
                {
                    //ignore
                }
            }
            f.Dispose();
            return null;
        }

        private void applyGuiChange(GuiChange v)
        {
            try
            {
                if (this.InvokeRequired)
                {
                    this.Invoke(v);
                }
                else
                {
                    lock (thisLock)
                    {
                        v();
                    }
                }
            }
            catch (Exception)
            {
            }
        }

        private void setText()
        {
            if (felicaExist)
            {
                label1.Text = felicaType;
                label1.Left = (this.Width - label1.Width) / 2;
                label2.Text = felicaBal;
                label2.Left = (this.Width - label2.Width) / 2;
            }
            else
            {
                label1.Text = "";
                label2.Text = "";
            }

        }

        private void setVisible()
        {
            if (felicaExist || !trayToolStripMenuItem.Checked) {
                //show
                this.Visible = true;
            } else { 
                //hide
                this.Visible = false;
            }
        }

        private void setTrayIconVisible() {
            notifyIcon1.Visible = trayToolStripMenuItem.Checked;
            // don't know why, but size changes after ShowInTaskbar change.
            Size s = this.Size;
            this.ShowInTaskbar = !trayToolStripMenuItem.Checked;
            this.Size = s;

        }
        private string titleStr = null;
        private void setTitlebarVisible()
        {
            //titlebarToolStripMenuItem.Checked = !titlebarToolStripMenuItem.Checked;
            if (!titlebarToolStripMenuItem.Checked)
            {

                titleStr = this.Text;
                this.Text = "";
                this.ControlBox = false;
            }
            else
            {
                if (titleStr != null)
                {
                    //at begininng
                    this.Text = titleStr;
                }
                this.ControlBox = true;
                // below line doesn't work. icon won't be shown in titlebar.
                this.ShowIcon = true;

            }

        }


        private class FelicaInfo
        {
            public byte[] IDm;
            public int bal;
            public string type;

            public bool isSameIDm(FelicaInfo b)
            {
                //no validation
                if (b == null || IDm.Length != b.IDm.Length)
                {
                    return false;
                }
                for (int i = 0; i < IDm.Length; i++)
                {
                    if (IDm[i] != b.IDm[i])
                    {
                        return false;
                    }
                }
                return true;
            }
        }

        private void trayToolStripMenuItem_Click(object sender, EventArgs e)
        {
            applyGuiChange(new GuiChange(setVisible) + new GuiChange(setTrayIconVisible));
        }

        private void titlebarToolStripMenuItem_Click(object sender, EventArgs e)
        {
            applyGuiChange(new GuiChange(setTitlebarVisible));
        }



        private Point mousePoint;
        private void MainForm_MouseDown(object sender, MouseEventArgs e)
        {
            if ((e.Button & MouseButtons.Left) == MouseButtons.Left)
            {
                //ʒuL
                mousePoint = new Point(e.X, e.Y);

            }
        }

        private void MainForm_MouseMove(object sender, MouseEventArgs e)
        {


            if ((e.Button & MouseButtons.Left) == MouseButtons.Left)
            {
                this.Left += e.X - mousePoint.X;
                this.Top += e.Y - mousePoint.Y;
            }
        }

        private void exitToolStripMenuItem_Click(object sender, EventArgs e)
        {
            doPolling = false;
        }

        private void notifyIcon1_MouseClick(object sender, MouseEventArgs e)
        {

            if ((e.Button & MouseButtons.Left) == MouseButtons.Left)
            {
                this.setVisible();
            }

        }

        private void MainForm_FormClosing(object sender, FormClosingEventArgs e)
        {
            Properties.Settings.Default.Save();
        }

        private void MainForm_Load(object sender, EventArgs e)
        {
            applyGuiChange(new GuiChange(setTitlebarVisible) +
                new GuiChange(setTrayIconVisible) +
                new GuiChange(setVisible));
        }

    }

}


/*
        delegate void SetVisibleCallback(Boolean v);
        private void SetVisible(Boolean v)
        {
            try
            {
                if (this.InvokeRequired)
                {
                    SetVisibleCallback d = new SetVisibleCallback(SetVisible);
                    this.Invoke(d, new object[] { v });
                }
                else
                {
                    this.Visible = v;
                    if (v)
                    {
                        if (this.WindowState == FormWindowState.Minimized)
                            this.WindowState = FormWindowState.Normal;
                    }

                }
            }
            catch (Exception)
            {
            }
        }
*/