#fdmodules.rb
module FDModules
  FDMod = Struct.new(:events,:methods,:requires)
  
  FormModules = {
    :VRDestroySensitive => FDMod[['self_destroy'],[],'vrhandler'],
    :VRClosingSensitive => FDMod[['self_close'],[],'vrhandler'],
    :VRClipboardObserver => FDMod[['self_drawclipboard'],[],'vrclipboard']
  }
  
  ParentModules = {
    :VRLayoutManager => FDMod[[],['rearrange'],'vrlayout'],
    :VRVertLayoutManager => FDMod[[],['addControl(type,name,caption,astyle)'],'vrlayout'],
    :VRHorizLayoutManager => FDMod[[],['addControl(type,name,caption,astyle)'],'vrlayout'],
    :VRGridLayoutManager => FDMod[[],['addControl(type,name,caption,astyle)',
                                      'setDimension(x,y)'],'vrlayout'],
    :VRTwoPane => FDMod[[],['addPanedControl(type,name,caption,astyle)'],'vrtwopane'],
    :VRVertTwoPane => FDMod[[],['addPanedControl(type,name,caption,astyle)'],'vrtwopane'],
    :VRHorizTwoPane => FDMod[[],['addPanedControl(type,name,caption,astyle)'],'vrtwopane']
  }
  
  StdModules = {
    :VRDrawable => FDMod[['self_paint'],[]],
   # :VRMessageHandler => FDMod[[],['acceptEvents(ev_array)',
   #                      'addHandler(msg,handlername,argtype,argparsestr)']],
    :VRResizeSensitive => FDMod[['self_resize(w,h)'],[]],
    :VRMouseFeasible => FDMod[[
      'self_lbuttonup(shift,x,y)',
      'self_lbuttondown(shift,x,y)',
      'self_rbuttonup(shift,x,y)',
      'self_rbuttondown(shift,x,y)',
      'self_mousemove(shift,x,y)',
    ],[],'vrhandler'],
    :VRFocusSensitive => FDMod[[
      'self_gotfocus()',
      'self_lostfocus()'
      ],[],'vrhandler'],
    :VRKeyFeasible  => FDMod[[
      'self_char(keycode,keydata)',
      'self_deadchar(keycode,keydata)',
      'self_syschar(keycode,keydata)',
      'self_sysdeadchar(keycode,keydata)'
    ],[],'vrhandler'],
    :VROwnerDrawControlContainer => FDMod[[
    'self_vrwmdrawitem(wParam,args)'
    ],[],'vrowndraw'],
    :VRDropFileTarget => FDMod[['self_dropfiles(files)'],[],'vrddrop'],
    :VRDragFileSource => FDMod[['dragStart(files)'],[],'vrddrop']
  }
  MMModules = {
    :VRMediaViewModeNotifier => FDMod[[],[],'']
  }
  
end
