#Transparent window which covers designform to hook messages and rubber banding.
#

require 'vr/vruby'
require 'vr/vrhandler'
require 'fdvr/fdwin32'

class FDCoverForm < VRForm
  include VRUserMessageUseable
  include VRMouseFeasible
  include VRDrawable
  include User32
  include GDI32
  
  attr_reader :selected, :paste_to,
              :selected_point, :opend_holes
  
  def vrinit
    super
    self.exstyle = User32::WS_EX_TRANSPARENT
    registerUserMessage(0x11, 'paint_handles')
  end
  
  def construct
    @span=$ini.read('settings','span',8).to_i
    @hitobj = nil
    @selected = nil
    @from = Point[0, 0]
    @paste_to   = nil
    @hitrect = Rect[0, 0, 0, 0]
    @selected_point = nil
    @opend_holes = {}
    @focusrect = nil
    @parentobj = parent
    @enableGrid = true
  end
  
  def step(v)
    if @enableGrid then v-v%@span else  v  end
  end
  
  def setPenMode(mode)
    GDI32.setROP2(@hdc,mode)
  end

  def rect(x1,y1,x2,y2)
    dopaint(@hdc) do
      grMoveTo(x1, y1)
      grLineTo(x2, y1)
      grLineTo(x2, y2)
      grLineTo(x1, y2)
      grLineTo(x1, y1)
    end
  end
  
  def self_paint
    parent.refresh
  end
  
  def self_paint_handles(wParam,lParam)
    if @selected
      GC.disable
      dopaint do
        @selected.each_with_index do |i,idx|
          if idx == 0
            setBrush(0)
          else
            setBrush(0xffffff)
          end
          paint9rect(i.rect.l, i.rect.t, i.rect.r, i.rect.b)
        end
        setBrush(0)
      end
      GC.enable
    end 
  end
    
  def paint9rect(l, t, r, b)
    fillRect(l-5, t-5, l, t)
    fillRect(r+5, b+5, r, b)
    fillRect(l-5, b+5, l, b)
    fillRect(r+5, t-5, r, t)
    fillRect(l-5, (t+b)/2-3, l, (t+b)/2+2)
    fillRect(r+5, (t+b)/2-3, r, (t+b)/2+2)
    fillRect((l+r)/2-3, t-5, (l+r)/2+2, t)
    fillRect((l+r)/2-3, b+5, (l+r)/2+2, b)
  end
  
  def show_and_resize
    wx,wy,ww,wh = parent.windowrect
    cx,cy,cw,ch = parent.clientrect
    e = (ww-cw) / 2
    self.move wx,wy,ww,wh
    sx,sy,sw,sh = self.clientrect
    hrgn = GDI32.createRectRgn(cx+e,wh-ch-e,cx+e+cw,wh-e)
    User32.setWindowRgn(self.hWnd,hrgn,0)
    self.show unless self.visible?
  end
  
  def resize
    wx,wy,ww,wh = parent.windowrect
    self.move wx,wy,ww,wh
#    parent.refresh
  end
  
  
  def hittest(obj,x,y)
    r = obj #;p [obj,obj.controls]
    obj.controls.each_value do |i|
      _x, _y, _w, _h = i.windowrect
      if i.visible? && (_x<=x) && (x<=_x+_w) && (_y<=y) && (y<=_y+_h)
        next unless i.respond_to?(:_ext_init)
        r = i
        if r.is_a?(FDContainer) 
          return r
        elsif i.respond_to?(:addControl) && !i.is_a?(FDContainer)
          r = hittest(i, x, y)
          r = self unless r
        elsif r
          rx, ry, rw, rh = r.windowrect
#          p [r,[rx, ry, rw, rh],[_x, _y, _w, _h]]
          if  (rx < _x) && (ry < _y) && (rx+rw > _x+_w) && (ry+rh > _y+_h)
            r = i
          else
            next
          end
        else
          r = i
        end
      end
    end
    r
  end
  
  def set_hitrect
    return unless @hitobj
    x, y, w, h = @hitobj.windowrect
    _x,_y = screen_to_client(self, x, y)
    @hitrect.l, @hitrect.t, @hitrect.r, @hitrect.b, = _x,_y,_x+w,_y+h
  end
  
  Hole = Struct.new(:l, :t, :r, :b, :curs, :sendto)
  
  def open_hole(obj, l, t, r, b, curs, sendto)
    raise '6th arg must be a SWin::Cursor' unless curs.is_a? SWin::Cursor
    l, t = screen_to_client(self, *client_to_screen(sendto, l, t))
    r, b = screen_to_client(self, *client_to_screen(sendto, r, b))
    @opend_holes[obj] =  Hole[l, t, r, b, curs, sendto]
  end
  
  def move_hole(obj, l, t, r, b)
    if o = @opend_holes[obj]
      l, t = screen_to_client(self, *client_to_screen(o.sendto, l, t))
      r, b = screen_to_client(self, *client_to_screen(o.sendto, r, b))
      o.l = l; o.t = t; o.r = r; o.b = b
    end
  end
  
  def get_hole(obj)
    @opend_holes[obj]
  end
  
  def close_hole(obj)
    @opend_holes.delete(obj)
  end
  
  def on_the_hole?(x,y,obj=nil)
    @opend_holes.each_pair{|k, v|
      return v if v.l <= x && x <= v.r && v.t <= y && y <= v.b}
    nil
  end
  
  def erase_holes(prnt)
    prnt.controls.each{|k,o|
      close_hole(o.substance) if o.respond_to?(:substance)
      erase_holes(o) if o.respond_to?(:addControl)
    }
  end
  
  def  use_parent_of?(obj)
    obj.is_a?(FDContainer) || !obj.respond_to?(:addControl)
  end
  
  def self_lbuttondown(shift, x, y)
    parent.top
    if (obj = on_the_hole?(x,y))
      obj.sendto.sendMessage(WMsg::WM_LBUTTONDOWN,shift,
          MAKELPARAM(*screen_to_client(obj.sendto,*client_to_screen(self,x,y))))
      @send_to = obj.sendto
      return
    end
    @hdc = getDC(self.hWnd)
    @creation = $main.creation
    _x, _y = client_to_screen(self, x, y)
    @from.x = step(x); @from.y = step(y)
    @hitobj = hittest(parent, _x, _y)
    if @hitobj.is_a?(VRTabbedPanel)
      @hitobj.sendMessage(WMsg::WM_LBUTTONDOWN , 0,
                                 MAKELPARAM(*screen_to_client(@hitobj,_x,_y)))
    end
    if shift!=9 && !(@selected && @selected.find{|i|i.obj == @hitobj})
      # 9 is Ctrl state. Shift is 5.
      clear_select
    end
    @hitobj = @hitobj.parent if (@hitobj!=$designfrm) && @hitobj.margined 
    set_hitrect
    if $main.creation
      if @creation.klass <= SWin::Window
        @parentobj = use_parent_of?(@hitobj) ? @hitobj.parent : @hitobj
      elsif (@creation.createmethods == :NewFD2Pane) ||
                                       (@creation.createmethods == :NewFDLayout)
        @parentobj = use_parent_of?(@hitobj) ? @hitobj.parent : @hitobj
      else
        @parentobj = self.parent # $designfrm
      end
      @dragging = Point[@from.x, @from.y]
      setPenMode(GDI32::R2_NOTXORPEN)
      setCapture
    elsif focused && (@drag_state=get_focus_state(x,y,@selected[0].rect))
      if @hitobj.parent.class.const_defined?(:USE_THIS_PARENT)
        @hitobj = @hitobj.parent
        set_hitrect
        @parentobj=@hitobj.parent
      end
      if @drag_state == Moving
        set_focus(@hitobj) if focused != @hitobj
        @dragging = Point[@from.x, @from.y]
      elsif @drag_state > Moving
        clear_select
        @hitobj = focused
        @parentobj=@hitobj.parent
        set_hitrect
        cx, cy = (@hitrect.l+@hitrect.r)/2, (@hitrect.t+@hitrect.b)/2
        case @drag_state
        when ResizeALL
          if    x  <= cx && y  <= cy
            @from.x, @from.y = @hitrect.r, @hitrect.b
          elsif cx <  x  && y  <= cy
            @from.x, @from.y = @hitrect.l, @hitrect.b
          elsif cx <  x  && cy < y
            @from.x, @from.y = @hitrect.l, @hitrect.t
          else
            @from.x, @from.y = @hitrect.r, @hitrect.t
          end
          @dragging = Point[@from.x, @from.y]
        when ResizeLR
          if    x  <= cx
            @from.x, @from.y = @hitrect.r, @hitrect.t
          else
            @from.x, @from.y = @hitrect.l, @hitrect.t
          end
          @dragging = Point[@from.x, @hitrect.b]
        when ResizeUD
          if y <= cy
            @from.x, @from.y = @hitrect.l, @hitrect.b
          else
            @from.x, @from.y = @hitrect.l, @hitrect.t
          end
          @dragging = Point[@hitrect.r, @from.y]
       end
      else
        # focused is not hit
      end
      setPenMode(GDI32::R2_NOTXORPEN)
      setCapture
    elsif focused && shift == 9
      if @hitobj != parent && focused.parent == @hitobj.parent
        if so = @selected.find{|i| i.obj == @hitobj}
          @selected.delete(so)
        else
          add_select(@hitobj)
        end
        @drag_state = Moving
      end
    elsif @hitobj != parent
      if @hitobj.parent.class.const_defined?(:USE_THIS_PARENT)
        @hitobj = @hitobj.parent
        set_hitrect
        @parentobj=@hitobj.parent
      end
      if !selected || (@selected && @selected.size <= 1)
        set_focus(@hitobj)
      end
      @drag_state = Moving
      @dragging = Point[@from.x, @from.y]
      setPenMode(GDI32::R2_NOTXORPEN)
      setCapture
    else # form is hit
      @dragging = nil
      set_focus(nil)
      @parentobj = @hitobj
    end
    set_focus(@hitobj) if !focused && shift != 9
    @hitobj == parent ? parent.refresh : @hitobj.parent.refresh
    parent.update_inspectfrm(@hitobj)
  end
  
  def update_menues
    if @hitobj == parent
      $main.disable_edit_menues
      $main.disable_delete_menues
    elsif @hitobj.is_a?(FDContainer)
      $main.disable_edit_menues
      $main.enable_delete_menues
    else
      $main.enable_edit_menues
      $main.enable_delete_menues
    end
    unless parent.copy_buff.empty?
      $main.enable_paste_menu
    else
      $main.disable_paste_menu
    end
  end
  
  def self_rbuttondown(shift,x,y)
    parent.top
    _x, _y = client_to_screen(parent,x,y)
    sx, sy = step(x), step(y)
    @hitobj = hittest(parent, _x, _y)
    @paste_to = use_parent_of?(@hitobj) ? @hitobj.parent : @hitobj
    @selected_point = Point[*client_to_screen(self, sx, sy)]
    o = @hitobj.parent.class.const_defined?(:USE_THIS_PARENT) ? @hitobj.parent :
                                                                @hitobj
    if !(@selected && @selected.find{|i|i.obj == @hitobj})
      clear_select
      set_focus(o)
      refresh
    end
    update_menues
    $main.popupMenu($main.amenu.menu, *screen_to_client($main, _x, _y))
  end
  
  Moving    = 1
  ResizeALL = 2
  ResizeLR  = 3
  ResizeUD  = 4
  
  Curs = SWin::Application::SysCursors
  
  def get_focus_state(x, y, rect)
    e = 4
    l = rect.l; t = rect.t; r = rect.r; b = rect.b
    if    l-e <= x && x <= l+e || r-e <= x && x <= r+e
      if    t+e < y && y < b-e
        ResizeLR
      elsif t-e < y && y < b+e
        ResizeALL
      else
        nil
      end
    elsif t-e <= y && y <= t+e || b-e <= y && y <= b+e
      if    l+e < x && x < r-e
        ResizeUD
      elsif l-e < x && x < r+e
        ResizeAL
      else
        nil
      end
    elsif l+e < x && x < r-e && t+e < y && y < b-e
      Moving
    else
      nil
    end
  end
  
  def self_lbuttonup(shift, x, y)
    return unless shift == 0
    if @send_to
      @send_to.sendMessage(WMsg::WM_LBUTTONUP,shift,
             MAKELPARAM(*screen_to_client(@send_to,*client_to_screen(self,x,y))))
      @send_to = nil
    end
    sx, sy = client_to_screen(self, step(x), step(y))
    fx, fy = client_to_screen(self, @from.x, @from.y)
    x1, y1 = screen_to_client(@parentobj, fx, fy)
    x2, y2 = screen_to_client(@parentobj, sx, sy)
    if cr = $main.creation
      nam = parent.get_serial_name(cr.inst + "1")
      if x1 == x2 || y1 == y2
        _x, _w = x1, cr.dflt_w
        _y, _h = y1, cr.dflt_h
      else
        _x, _w = (x1 <= x2) ? [x1, x2-x1] : [x2, x1-x2]
        _y, _h = (y1 <= y2) ? [y1, y2-y1] : [y2, y1-y2]
      end
      
     #c = @parentobj.send("#{cr.createMethod}",@parentobj,cr,nam,nam,_x,_y,_w,_h)
     #c.parent.child_created(c) if c.parent.respond_to?(:child_created)
      if cr.klass <= SWin::Window
        c = @parentobj.newFDControl(@parentobj, cr, nam, nam, _x, _y, _w, _h)
      else
        c = @parentobj.newFDContainer(@parentobj, cr, nam, nam, _x, _y, _w, _h)
      end
      return unless c.is_a?(SWin::Window)
      c.parent.child_created(c) if c.parent.respond_to?(:child_created)
      @hitobj = c
      set_focus(c)
      $designfrm.refreshCntName
      @selected_point = nil
    elsif @hitobj && @hitobj != $designfrm
      if @drag_state == Moving
        dx, dy = x2-x1, y2-y1
        @selected.each do |i|
          ix,iy,iw,ih = i.obj.windowrect
          ix,iy = screen_to_client(i.obj.parent,ix,iy)
          _x ,_y = ix + dx, iy + dy
          i.obj.move(_x, _y, iw, ih)
          i.rect.l = i.rect.l + dx
          i.rect.t = i.rect.t + dy
          i.rect.r = i.rect.r + dx
          i.rect.b = i.rect.b + dy
        end if @selected
      elsif @drag_state > Moving
        case @drag_state
        when ResizeALL
          _x, _w = x1 <= x2 ? [x1, x2-x1] : [x2, x1-x2]
          _y, _h = y1 <= y2 ? [y1, y2-y1] : [y2, y1-y2]
        when ResizeLR
          _x, _w = x1 <= x2 ? [x1, x2-x1] : [x2, x1-x2]
          _y, _h = y1 <= y2 ? [y1, @hitobj.h] : [y2, @hitobj.h]
        when ResizeUD
          _x, _w = x1 <= x2 ? [x1,@hitobj.w] : [x2, @hitobj.w]
          _y, _h = y1 <= y2 ? [y1, y2-y1] : [y2, y1-y2]
        end
        @hitobj.move(_x, _y, _w, _h)
        set_focus(@hitobj)
      end
      if use_parent_of?(@hitobj)
        @pasete_to = @hitobj.parent
        @selected_point = nil
      else
        @pasete_to = @hitobj
        @selected_point = Point[*client_to_screen(self,sx,sy)]
      end
    else
      @pasete_to = parent
      @selected_point = Point[*client_to_screen(self,sx,sy)]
    end
    @dragging = nil
    cr = nil
    releaseCapture
    set_focus(@hitobj) unless focused
    $main.inc_modified
    $main.tab.noselectAll
    @hitobj.sendMessage(WMsg::WM_SIZE, 0,
                                MAKELPARAM(*@hitobj.clientrect[2,2])) if @hitobj
    if @hitobj && @hitobj != $designfrm
      @hitobj.parent.sendMessage(WMsg::WM_SIZE, 0,
                                    MAKELPARAM(*@hitobj.parent.clientrect[2,2]))
    end
    bring_to_top_container(parent)
    update_menues
    parent.refresh
    parent.update_inspectfrm(@hitobj)
    @hitobj = nil
  end
  
  def bring_to_top_container(obj)
    obj.controls.each do |id,win|
      if win.is_a? FDContainer
        win.top(false)
      elsif win.respond_to?(:addControl)
        bring_to_top_container(win)
      end
    end
  end
  
  Selected = Struct.new(:obj,:rect)
  
  def set_focus(obj)
    if obj && obj != parent
      _x, _y, _w, _h = obj.windowrect
      l, t = screen_to_client(self, _x, _y)
      @selected = [Selected[obj, Rect[l, t, l+_w, t+_h]]]
    else
      @selected = nil
    end 
    parent.update_inspectfrm(obj)
#    obj.refresh if obj
  end
  
  def focused
    @selected[0].obj if @selected
  end
  
  def clear_select
    @selected = [@selected[0]] if @selected
  end
  
  def add_select(obj)
    _x, _y, _w, _h = obj.windowrect
    l, t = screen_to_client(self, _x, _y)
    @selected << Selected[obj, Rect[l, t, l+_w, t+_h]]
    parent.refresh
  end
  
  def resizecursor(x,y) # from visualu.rb
    return unless  @selected
    fr = @selected[0].rect
    l,r,t,b = 
    (x-fr.l).abs < 4 && fr.b+4 > y && y > fr.t-4,
    (x-fr.r).abs < 4 && fr.b+4 > y && y > fr.t-4,
    (y-fr.t).abs < 4 && fr.r+4 > x && x > fr.l-4,
    (y-fr.b).abs < 4 && fr.r+4 > x && x > fr.l-4 
    if l 
      if t 
        Curs.SizeNWSE
      elsif b
        Curs.SizeNESW
      else
        Curs.SizeWE
      end
     elsif r
      if t 
        Curs.SizeNESW
      elsif b 
        Curs.SizeNWSE
      else
        Curs.SizeWE
      end
    elsif t or b 
      Curs.SizeNS
    else
      Curs.Arrow
    end
  end
  
  def self_mousemove(shift,x,y)
    return if shift > 1
    if  (shift&1) == 1 && @send_to
      @send_to.sendMessage(WMsg::WM_MOUSEMOVE,shift,
            MAKELPARAM(*screen_to_client(@send_to,*client_to_screen(self,x,y))))
      return
    end
    if (r = on_the_hole?(x,y))
      SWin::Application.setCursor(r.curs)
      return
    end
#    SWin::Application.doevents
    sx = step(x < 0xefff ? x : x-0x10000)
    sy = step(y < 0xefff ? y : y-0x10000)
    if  $main.creation
      SWin::Application.setCursor Curs.Cross
      if (shift&1) == 1  && @dragging  #shift1: left button down
        # erase previous lines
        rect(@from.x, @from.y, @dragging.x, @dragging.y)
        # draw new lines
        rect(@from.x, @from.y, sx, sy)
        @dragging.x = sx ; @dragging.y = sy
      end
    elsif  (shift&1) == 1 && @dragging
      case @drag_state
      when Moving
        dx = @dragging.x - @from.x ; dy = @dragging.y - @from.y
        rect(@hitrect.l+dx,@hitrect.t+dy,@hitrect.r+dx,@hitrect.b+dy)
        @selected.each{|i|
          rect(i.rect.l+dx,i.rect.t+dy,i.rect.r+dx,i.rect.b+dy)if i.obj!=@hitobj
        }if @selected
        dx = sx - @from.x ; dy = sy - @from.y
        rect(@hitrect.l+dx,@hitrect.t+dy,@hitrect.r+dx,@hitrect.b+dy)
        @selected.each{|i|
          rect(i.rect.l+dx,i.rect.t+dy,i.rect.r+dx,i.rect.b+dy)if i.obj!=@hitobj
        }if @selected
        @dragging.x = sx ; @dragging.y = sy
      when ResizeALL
        rect(@from.x, @from.y, @dragging.x, @dragging.y)
        rect(@from.x, @from.y, sx, sy)
        @dragging.x = sx ; @dragging.y = sy
      when ResizeLR
        rect(@from.x, @from.y, @dragging.x, @dragging.y)
        rect(@from.x, @from.y, sx, @dragging.y)
        @dragging.x = sx
      when ResizeUD
        rect(@from.x, @from.y, @dragging.x, @dragging.y)
        rect(@from.x, @from.y, @dragging.x, sy)
         @dragging.y = sy
      else
      end
    elsif focused
      SWin::Application.setCursor(resizecursor(x,y))
    else
      SWin::Application.setCursor(Curs.Arrow)
    end
  end
  
end
