# fdcontrols.rb
# Controls on pallets
#
# Programmed by yukimi_sake@mbi.nifty.com
# Copyright 2001-2003 Yukio Sakaue

require 'vr/vrmgdlayout'
require 'fdvr/m17n'
require 'fdvr/fdmodules'
require 'fdvr/fdresources'
require 'yaml'

class Hash
  def << (h) self.update h end
  def + (h) r = self.clone; r.update h end
end


module FDControls
  include FDBmps
  include FDItems
  include FDFakeClass
  include FDModules
#  include FDWStyle
#  include FDExStyle
#  include FDOwnerDraw
  include VRMarginedFrameUseable
  attr_reader(:prBevel)

  FDStruct=Struct.new :klass,:inst,:dflt_w,:dflt_h,:maskstyle,:required,
  :included,:precreation,:createmethods,:info,:attrs,:events,:mthds,:mods,
  :items,:bmp,:styles,:source
  FDPallet = Struct.new(:title,:items)
  
# Description of attribute metohd definition
  def controls_init
#    @prStyle = 'sprintf("%#8X",c.style)'
    @prStyle = 'st = (c.style|c.owndraw)-c._default_style;
      st == 0 ? "default" : sprintf("%#x",st)'
    @prFont = 'getFontName(c)'
    @prTab = 'c.tab_order'
    @prArray = ' "click ->"'
    @prMenuItem = '"click ->"'
    @prModule = '"click ->"'
    @prAccel = 'c.getaccel ? "true" : "false" '
    @prCCS = 'FDWStyle::CCSStr[c.style & 0x2f]'
    @prOwnerDraw = 'c.owndraw_used?'
    @prLayout =  '"click ->"'
    @prBevel = '{VRMgdTwoPaneFrame::BevelNone=>"None",
                 VRMgdTwoPaneFrame::BevelGroove1=>"Groove1",
                 VRMgdTwoPaneFrame::BevelGroove2=>"Groove2",
                 VRMgdTwoPaneFrame::BevelRaise1=>"Raise1",
                 VRMgdTwoPaneFrame::BevelRaise2=>"Raise2",
                 VRMgdTwoPaneFrame::BevelSunken1=>"Sunken1",
                 VRMgdTwoPaneFrame::BevelSunken2=>"Sunken2"}[c.substance.bevel]'
    std_attr = ["name","caption","x","y","w","h",["font",@prFont,:_btFont],
               ["style",@prStyle,:_btStyle],
               ["modules",@prModule,:_btModule], ["tabOrder", @prTab,:_btTab],
               ["owndraw",@prOwnerDraw,:_cbOwnDraw]]
#    a = arrange_yml(YAML.load_file($program_dir + '/fddefault.yml'))
#    begin
#      a1 = arrange_yml(YAML.load_file($program_dir + '/fduser.yml'))
#    rescue
#      messageBox $!, "user definition loading error", 16
#      a
#    else
#      a + a1
#    end
    
    load("#{$program_dir}/default_pallet.rb")
    a = hash2struct($__default_pallet)
#    begin
      load("#{$program_dir}/user_pallet.rb")
      a1 = hash2struct($__user_pallet)
#    rescue
#      messageBox "#{$!}\n#{$@}", "user definition loading error", 16
#    end
    $conf = a1 ? merge_pallets(a, a1) : a
  end
  
  def arrange_yml(a)
    a.each{|i|
      i.items.each{|j|
        require j.source if j.source
        j.klass = eval(j.klass)
      }
    }
    a
  end
  
  def hash2struct(o)
    if o.is_a? Array
      r = o.map{|i| (i.is_a?(Array) || i.is_a?(Hash)) ? hash2struct(i) : i}
    elsif o.is_a? Hash
      o.each_pair{|k,v| o[k]=hash2struct(v) if (v.is_a?(Array)||v.is_a?(Hash))}
      if s = o[:__Struct__]
        if o[:source]
          require(o[:source])
        end
        r = s.new
        r.each_pair{|k,v|
          r[k] = (k==:klass) ? eval(o[k].to_s) : o[k]
        }
      else
        r = o
      end
    end
    r
  end
  
  def merge_pallets(d,u)
    r = []
    d.each do |i|
      r << i
      if a = u.find{|j| j[:title] == i[:title]}
        u.delete(a)
        r.last[:items].concat a[:items]
      end
    end
    r.concat u
  end
end
__END__

if $0 == __FILE__
  require 'pp'
  require 'vr/vrrichedit'
  require 'vr/vrmmedia'
  require 'fdwstyle'
  include FDControls
  include FDWStyle
  include FDExStyle
  include FDOwnerDraw
  
  
  def check_mod_const(v)
    return nil
    case v
    when FormModules
      "FormModules"
    when ParentModules
      "ParentModules"
    when StdModules
      "StdModules"
    when MMModules
      "MMModules"
    when LVSExStyles
      "LVSExStyles"
    when WStyles
      "WStyles"
    when CtlStyles
      "CtlStyles"
    when LVMStr
      "LVMStr"
    when LVMConst
      "LVMConst"
    when CCSStr
      "CCSStr"
    when CCSConst
      "CCSConst"
    when ExStyles
      "ExStyles"
    when 
      "LVSExStyles"
    when ODConst
      "ODConst"
    end
  end
  
  def p_fdstruct(a, lv0)
    r = []
    lv = lv0 + 1
    a.each_pair do |m,v|
      if s=check_mod_const(v)
        r << "  " * lv + ":#{m} => #{s}"
      elsif v.is_a? Array
        r << "  " * lv + ":#{m} => #{p_array(v, lv + 1)}"
#      elsif v.is_a? Struct
#        r << "  "*lv + v.class.to_s.split['::'].last
      elsif v.is_a? Hash
        r << "  " * lv + ":#{m} => #{p_hash(v, lv + 1)}"
      elsif v.is_a?(String) || v.is_a?(Symbol)
        if m == :bmp
          v = [Zlib::Inflate.inflate(v.unpack('m')[0])].pack('m')
        end
          r << "  " * lv + ":#{m} => #{v.inspect}"
      elsif v.is_a? Integer
        s = (m.to_s == "maskstyle") ? sprintf("0x%x", v) : v.to_s
        r << "  " * lv + ":#{m} => #{s}" 
      else
        v = v || 'nil'
        v = ":#{v.to_s.split('::').last}" if m.to_s == 'klass'
        r << "  " * lv + ":#{m} => #{v}"
      end
    end
    rs = "  "*lv0  + "{:__Struct__ => #{a.class.to_s.split('::').last},\n"+
           r.join(",\n") + "\n" + "  "*lv0 + "}"
    a.source ? [nil, rs] : [rs, nil]
  end
  
  def p_hash(a, lv)
    r = []
    a.each_pair do |m,v|
      if s=check_mod_const(v)
        r << ":#{m} => #{s}"
      elsif v.is_a? Array
        r << ":#{m} => #{p_array(v, lv+1)}"
      elsif v.is_a? Hash
        r << ":#{m} => #{p_hash(v, lv+1)}"
      elsif v.is_a? Struct
        r << ":#{m} => #{p_struct(v, lv+1)}"
      elsif v.is_a?(String) || v.is_a?(Symbol)
        r << ":#{m} => #{v.inspect}"
      elsif v.is_a? Integer
        s = sprintf("0x%x", v)
        r << ":#{m} => #{s}" 
      else
        v = v || 'nil'
        r << ":#{m} => #{v}"
      end
    end
    "{" + r.join(",") + "}"
  end
  
  def p_struct(a, lv)
    r = []
    a.each_pair do |m,v|
      if s=check_mod_const(v)
        r << ":#{m} => #{s}"
      elsif v.is_a? Array
        r << ":#{m} => #{p_array(v, lv+1)}"
      elsif v.is_a? Hash
        r << ":#{m} => #{p_hash(v, lv+1)}"
      elsif v.is_a? Struct
        r << ":#{m} => #{p_struct(v, lv+1)}"
      elsif v.is_a?(String) || v.is_a?(Symbol)
        r << ":#{m} => #{v.inspect}"
      elsif v.is_a? Integer
        s = sprintf("0x%x", v)
        r << ":#{m} => #{s}" 
      else
        v = v || 'nil'
        r << ":#{m} => #{v}"
      end
    end
    "{:__Struct__ => #{a.class.to_s.split('::').last}," + r.join(",") + "}"
  end
  
  def p_array(a, lv)
    r = []
    a.each do |v|
      if s=check_mod_const(v)
        r << ":#{s}"
      elsif v.is_a? Array
        r <<  p_array(v, lv+1)
      elsif v.is_a? Hash
        r << p_hash(v, lv+1)
      elsif v.is_a? Struct
        r << "#{p_struct(v, lv+1)}"
      elsif v.is_a?(String) || v.is_a?(Symbol)
        r << "#{v.inspect}"
      elsif v.is_a? Integer
        s = sprintf("0x%x", v)
        r << s
      else
        v = v || 'nil'
        r << "#{v}"
      end
    end
    "[" + r.join(",")  + "]"
  end
  
  
  $program_dir = File.dirname($0)
  a = controls_init
  rd = []
  ru = []
  a.each do |i|
    default = []; user = []
    i.items.each do |j|
      d, u = p_fdstruct(j,2)
      default << d if d
      user << u if u
    end
    rd << "  {:__Struct__ => FDPallet,:title => #{i.title.inspect},:items => [\n#{default.join(",\n")}\n  ]}" unless default.empty?
    ru << "  {:__Struct__ => FDPallet,:title => #{i.title.inspect},:items => [\n#{user.join(",\n")}\n  ]}" unless user.empty?
  end
  sd = "module FDControls\n@__default_pallet =\n[\n#{rd.join(",\n")}\n]\nend"
  su = "module FDControls\n@__user_pallet =\n[\n#{ru.join(",\n")}\n]\nend"
#  sd = "@__default_pallet =\n[\n#{rd.join(",\n")}\n]"
#  su = "@__user_pallet =\n[\n#{ru.join(",\n")}\n]\n"
  File.open("#{$program_dir}/default_pallet.rb",'w'){|f| f.puts sd}
  File.open("#{$program_dir}/user_pallet.rb",'w'){|f| f.puts su}
  load("#{$program_dir}/default_pallet.rb")
  load("#{$program_dir}/user_pallet.rb")
  aa = merge_pallets(@__default_pallet,@__user_pallet)
  r = hash2struct(aa)
  p r
  exit
end
