# fdcontroldesign.rb
# The form to controls Programmed
#
# designing by yukimi_sake@mbi.nifty.com
# Copyright 2001-2004 Yukio Sakaue

require 'vr/vruby'
require 'vr/sysmod'
require 'vr/vrcontrol'
require 'vr/vrcomctl'
require 'vr/vrhandler'
require 'vr/winconst'
require 'vr/rscutil'
require 'vr/vrrichedit'
require 'vr/vrtooltip'
require 'vr/contrib/inifile'
require 'vr/vrtimer'
require 'vr/vrddrop'
require 'vr/vrclipboard'
require 'vr/vrddrop'
require 'vr/vrmmedia'
require 'vr/vrmargin'
require 'vr/vrmgdlayout'

require 'fdvr/fdwin32'
require 'fdvr/fdparser'
require 'fdvr/fdwstyle'
require 'fdvr/fdmodules'
require 'fdvr/fdresources'
require 'fdvr/fdcfg'
require 'fdvr/fdcoverfrm'
#require 'vbic/vbic'

module FDMouseControl
  def step(v)
    if @enableGrid then v-v%@span else  v  end
  end
end

class ModStruct
  attr_reader :name, :oldname
  attr_accessor :childs, :parent, :tline, :sline, :eline
  def initialize(oldname,name,parent,childs=[])
    @oldname = oldname
    @name = name
    @parent = parent
    @childs = childs
    @tline = nil
    @sline = nil
    @eline = nil
  end
  
  def find(str)
    self.childs.find{|i| i.oldname == str}
  end
end

module FDControlDesign  # for DesignForm
  include VRFocusSensitive
  include VRMenuUseable
  include VRToolbarUseable
  include VRDrawable
  include VRResizeable
  include VRClosingSensitive
  include VRCommonDialog
  include VRParent
#  include VRMarginedFrameUseable
  include VRDropFileTarget
  include FDMouseControl
  include VRTimerFeasible
  include CreateCtrl #from 'fdcfg'
  include FDCommonMethod
  include WConst
  include FDParent
  include FDFakeClass
  
  attr_reader :controls, :modules, :names, :copy_buff
  attr_accessor :form, :type_of_form, :creation, :span, :enableGrid, :name
  attr_accessor :oldname, :sender, :focused, :focusExists, :buff1, :linscan2
  attr_accessor :cntnmodules, :_return_val, :tabOrders, :_default_font
  #  attr_accessor :focusrect
  
  def vrinit
    super
    addHandler WMsg::WM_MOUSEMOVE,  'mousemove',  MSGTYPE::ARGINTINTINT, nil
    addHandler WMsg::WM_MOVE,  'move',  MSGTYPE::ARGLINTINT,0
    acceptEvents [WMsg::WM_MOUSEMOVE,WMsg::WM_MOVE]
    
    @controls = OHash.new
    @app=@screen.application
    @curs=@app::SysCursors
  end
  
  def construct
    begin SWin::Application.setAccel(self,@parent) ;rescue ;end
    lpRect = ' ' * 16
    @span=$ini.read('settings','span',8).to_i
    @paste_to=nil
    init_designfrm
    @coverfrm = @screen.newform(self, nil, FDCoverForm)
    @coverfrm.create
    @coverfrm.move(*self.windowrect)
  end

  def init_designfrm
    @form=self
    @type_of_form=VRForm
    @names=[]
    @moving=false; @resizing=false
    @x1=@x2=@y1=@y2=0
    @enableGrid=true
    @required=["vruby"]
    @included=[]
    @modules=[]
    @tabOrders=[]
    @_hsh_font={}
    @temp_fonts=[]
    @_font_array=[]
    @font_hash={}
    @name="form1"
    @oldname="form1"
    @buff=""
    @frm_sizebox = 'true'
    @frm_maximizebox = 'true'
#    @focused = nil
    @cut_mode=nil
    @copy_buff = []
    @undo_buff = []
    @redo_buff = []
#    arrydlgcreate
    moddlgcreate
    controls_init
#    createinit
    fd_parent_init
    refreshCntName
    update_inspectfrm(nil)
  end
  
  def addControl(*args)
    r = super
    if @_default_font then
      r.setFont(@_default_font)
    end
    r
  end
  
  def moddlgcreate
    tpl = VRDialogTemplate.new
    tpl.style = WS_CAPTION | WS_SYSMENU | DS_MODALFRAME | DS_SETFONT
    tpl.fontname = "Terminal"
    tpl.fontsize = 10
    tpl.caption="Modules"
    btok = tpl.addDlgControl(VRButton,"O   K",5,182,40,12)
    btcan = tpl.addDlgControl(VRButton,"Cancel",50,182,40,12)
    lb1 = tpl.addDlgControl(VRListbox,"",2,2,100,164,0x0060)
    @moddlg=ListBoxDlg.new(@screen,tpl)
    @moddlg.options ={"target"=>lb1,"okbutton"=>btok,
                      "cancelbutton"=>btcan,"default" => [["",0]]}
  end
  
  def get_serial_name(s)
    s1 = s.dup
    if @names.index(s1) then
      s1.sub! /(\d+)$/ , ""
      s1 << "#{$1.to_i+1}"
      get_serial_name(s1)
    else
      @names << s1
      s1
    end
  end

  def delete_serial_name(s)
    @names.delete(s)
  end

  def self_paint
    GC.disable
    if @enableGrid
      a=clientrect
      GDI32.setROP2(hdc,8)
      nh=(a[2]/@span).to_i;nv=(a[3]/@span).to_i
      setBrush(0)
      dc=self.hdc
      i=0
      #draw grids
      0.upto(nh){|i| grMoveTo(i*@span,0); grLineTo(i*@span,nv*@span)}
      0.upto(nv){|i| grMoveTo(0,i*@span); grLineTo(nh*@span,i*@span)}
      GDI32.setROP2(hdc,13)
    end
    @coverfrm.userMessage('paint_handles')
    GC.enable
  end
  
  def getFontName(c)    
    if c.respond_to? :addControl
      hf = c._default_font ? c._default_font.hfont : 0
      f = @_hsh_font[hf]
    else
      hf=c.sendMessage(WMsg::WM_GETFONT,0,0)
      hf=hf+0x100000000 if hf < 0
      f = @_hsh_font[hf]
      f = nil if c.parent._default_font && c.parent._default_font == f
    end
    if  f
      f.fontname + ',' +f.params[1].abs.to_s
    else
      r = "default"
    end
  end

  def update_inspectfrm(c)
    return unless c.respond_to?(:_ext_init) || c == self
    if  ! c
      c = self
    elsif c != self
      c_x,c_y,c_w,c_h = c.get_client_pos
      client_pos = { 'x'=>c_x,'y'=>c_y,'w'=>c_w,'h'=>c_h}
    else
    end
    r = nil
    el = []
    c.modules.each{|i|
      if j = FDModules::StdModules["#{i}".intern]
        el = el + j.events
      elsif j = FDModules::FormModules["#{i}".intern]
        el = el + j.events
      end
    } unless c.modules.empty?
    el << 'ownerdraw(iid,action,state,hwnd,hdc,left,top,right,bottom,data)' if
                                       c != self && c.owndraw && (c.owndraw > 0)
    if c != self then
      r = findPalletItem(c)
      attrs = []
      r.attrs.each{|i|
        next if i.is_a?(Array)&&c.parent.is_a?(VRTabbedPanel)&&
                                             (i[0]=="style" || i[0]=="font")
        attrs <<
        if i.is_a?(Array) then
          [i[0],eval(i[1]),i[2]]
        elsif c.is_a? FDContainer
          case i
          when 'name','caption','x','y'
            [i,c.instance_eval(i).to_s]
          else
            [i,c.substance.instance_eval(i).to_s]
          end
        elsif c == self
          [i,c.instance_eval(i).to_s]
        else
          case i
          when 'x','y','w','h'
            [i,client_pos[i].to_s]
          else
            [i,c.instance_eval(i).to_s]
          end
        end
      } #;p [258,c, c.respond_to?(:margined),c.margined]
      if c.respond_to?(:mgLeft) #&& c.margined
        attrs = attrs + [
          ["mgLeft","#{c.mgLeft}","numnil"],
          ["mgTop","#{c.mgTop}","numnil"],
          ["mgRight","#{c.mgRight}","numnil"],
          ["mgBottom","#{c.mgBottom}","numnil"]]
      elsif c.is_a?(FDContainer) && c.substance.respond_to?(:initMargin)
        attrs = attrs + [
          ["mgLeft","#{c.substance.mgLeft}","num"],
          ["mgTop","#{c.substance.mgTop}","num"],
          ["mgRight","#{c.substance.mgRight}","num"],
          ["mgBottom","#{c.substance.mgBottom}","num"]]
      end
      if r then
        if r.events
          $inspectfrm.skip_ctrl_name = false
          el = r.events + el
          $inspectfrm.evtList.setListStrings(el)
       else #e.g. menu,toolbar
          $inspectfrm.skip_ctrl_name = true
          $inspectfrm.evtList.setListStrings(c.eventList)
        end
      end
      $inspectfrm.mthdList.setListStrings(r.mthds) if r
    elsif self.type_of_form <= VRDialogComponent
      c = self
      a = c.windowrect
      attrs = [["name",c.name],["caption",c.caption],["x",a[0].to_s],
               ["y",a[1].to_s],["w",a[2].to_s],["h",a[3].to_s],
               ["FONT", eval(@prFont), :_btFont],
               ["style",'',:nil],
               ["modules", eval(@prModule), :_btModule]]
      $inspectfrm.evtList.setListStrings(el)
      if !@parent.forms[0] || @parent.forms[0]==self
        $inspectfrm.mthdList.setListStrings([
          "modelessform","setButtonAs(button,dlgbuttonid)","centering"])
      elsif self.type_of_form==VRModalDialog
        $inspectfrm.mthdList.setListStrings([
          "openModalDialog","setButtonAs(button,dlgbuttonid)","centering"])
      else
        $inspectfrm.mthdList.setListStrings([
          "openModelessDialog","setButtonAs(button,dlgbuttonid)","centering"])
      end
    else
      c = self
      a = c.windowrect
      attrs = [["name",c.name],["caption",c.caption],["x",a[0].to_s],
               ["y",a[1].to_s],["w",a[2].to_s],["h",a[3].to_s],
               ['sizebox',@frm_sizebox.to_s,:_cbTF],
               ['maximizebox',@frm_maximizebox.to_s,:_cbTF],
               ["FONT", eval(@prFont), :_btFont],
               ["style",'',:nil],
               ["modules", eval(@prModule), :_btModule]]
      $inspectfrm.evtList.setListStrings(el)
      if !@parent.forms[0] || @parent.forms[0]==self
        $inspectfrm.mthdList.setListStrings(["start"])
      else
        $inspectfrm.mthdList.setListStrings(["showForm"])
      end
    end
    if c == self then
      s = "#{c.name}:#{c.type_of_form}"
#      parent.form_edit_menu
    else
      s = "#{c.name}:#{c.class}"
#      if c.is_a?(FDContainer) &&(c.substance.is_a?(VRTwoPaneFrame)||
#                   c.substance.is_a?(VRLayoutFrame)||c.substance.is_a?(VRMenu))
#        parent.inhibit_paste_menu
#      else
#        parent.enable_paste_menu
#      end
    end
    
    i= $inspectfrm.cbControl.findString(s)
    $inspectfrm.cbControl.select(i)
    $inspectfrm.setItems(attrs)
    $inspectfrm.stb2.caption = ""
  end

  def setControlsList(c)
    c.each do |id,item|
      next unless item.respond_to?(:_ext_init)
      if item.respond_to?(:controls) && item.controls
        setControlsList(item.controls)
      end
      unless item.parent.is_a?(VRTabbedPanel) && item.is_a?(VRPanel)
        s="#{item.name}:#{item.class}"
        $inspectfrm.cbControl.addString(s)
      end
    end
  end

  def refreshCntName
    $inspectfrm.cbControl.clearStrings
    s="#{self.name}:#{self.type_of_form}"
    $inspectfrm.cbControl.addString(s)
    setControlsList(@controls)
#    $inspectfrm.cbControl.select(
#                            $inspectfrm.cbControl.findString(s))
  end

  def moveC(c)
    if c.kind_of?(SWin::Window)
      x, y, w, h = getFormPos(c, true)
      if c.respond_to? :initMargin
        x = x - (c.mgLeft ? c.mgLeft : 0)
        y = y - (c.mgTop ? c.mgTop : 0)
        w = w + (c.mgLeft ? c.mgLeft : 0) + (c.mgRight ? c.mgRight : 0)
        h = h + (c.mgTop ? c.mgTop : 0) + (c.mgBottom ? c.mgBottom : 0)
      end
      c.move(x, y, w, h)
    end
  end

  def check_container(c,n = 1)
    c.name + "+" + n.to_s
    c.parent.parent.instance_eval("@#{c.name}")
    c.parent.parent.controls if c.parent.parent.kind_of? VRGroupbox
    if  c.parent.parent
      if c.parent.parent.instance_eval("@#{c.name}")
        r = true ; return(true)
      else
        r = check_container(c.parent,n+1)
      end
    end
    r
  end

  def update_target(name,caption,x,y,w,h,*arg)
    if cf = @coverfrm.focused
      unless cf.name == name
        oldname=cf.name.dup
        cf.name=name
        cf.parent.instance_eval("@#{name} = @#{oldname}")
        cf.parent.instance_eval("@#{oldname} = nil")
        @names.delete(oldname)
        @names << name
        cf.parent.update_items(oldname, name) if
                                            cf.parent.respond_to? :update_items
        if cf.respond_to?(:addControl)
          @buff.gsub!(/\_#{oldname}/,"_#{name}") if @buff
        end
      end
      if cf.respond_to?(:initMargin)
        lf=cf.mgLeft; tp=cf.mgTop;
        ri=cf.mgRight; bt=cf.mgBottom
      end
      arg.each do |i|
        v = ((v = eval(i[1])) == "") ? nil : v
        if cf.is_a? FDContainer
          unless cf.substance.instance_eval("#{i[0]}") == v
            cf.substance.instance_eval("#{i[0]} = #{i[1]}")
            break
          end
        else
          unless cf.instance_eval("#{i[0]}") == v
            cf.instance_eval("#{i[0]} = #{i[1]}")
            break
          end
        end
      end
      pr = cf ? cf.parent : self
      cf.caption=caption
      cf.move(x,y,w,h)
      if cf.respond_to?(:initMargin)
        cf.instance_eval("@__org_x = @__org_x + @__org_w - #{w};
                          @__org_w = #{w}") unless lf || cf.mgLeft
        cf.instance_eval("@__org_y = @__org_y + @__org_h - #{h};
                          @__org_h = #{h}") unless tp || cf.mgTop
        cf.instance_eval("@__org_w = #{w}") unless ri ||cf.mgRight
        cf.instance_eval("@__org_h = #{h}") unless bt ||cf.mgBottom
        if !cf.mgTop && !tp && !cf.mgBottom && !bt &&
          !cf.mgLeft && !lf && !cf.mgRight && !ri
          cf.instance_eval("@__org_y=#{y};@__org_x=#{x}")
        elsif !cf.mgLeft && !lf && !cf.mgRight && !ri
          cf.instance_eval("@__org_x=#{x}")
        elsif !cf.mgTop && !tp && !cf.mgBottom && !bt
          cf.instance_eval("@__org_y =#{y}")
        end
      end
      pr.sendMessage(WMsg::WM_SIZE,0,MAKELPARAM(*pr.clientrect[2,2]))
#      setFocusRgn(cf)
    else # if form
      oldname=self.name
      @buff.gsub!(/\_#{oldname}/,"_#{name}") if @buff
      self.name=name
      self.caption=caption
      move(x,y,w,h)
      @parent.update_menu(self)
    end
    @parent.inc_modified
    refreshCntName
    update_inspectfrm(cf)
    cf.refresh if cf
  end
  
  def save_window(cnt)
    x0,y0,w0,h0 = cnt.windowrect
    x0,y0 = screen_to_client(cnt.parent,x0,y0)
    it = nil
    if cnt.respond_to? :_fd_items
      if cnt.is_a?(VRRebar) && cnt._fd_items.size==1 &&
                                           cnt._fd_items[0][0]=="@__#{cnt.name}"
        cnt.instance_eval("deleteControl @__#{cnt.name}")
        it = nil
      else
        it = cnt._fd_items.dup
      end
    end
    hf0 = cnt.sendMessage(WMsg::WM_GETFONT,0,0)
    hf0 = hf0 + 0x100000000 if hf0 < 0
    hf = !(_hsh_font[hf0])||(cnt.parent._prev_dflt_hfont == hf0) ? 0 : hf0
    r = {
      :type => cnt.class,
      :name => cnt.name,
      :oldname => cnt.oldname,
      :caption => cnt.caption,
      :style => cnt.style,
      :x => x0,
      :y => y0,
      :w => w0,
      :h => h0,
      :id => cnt.etc,
      :form => cnt.form,
      :hfont => hf,
      :items => it,
      :mods => cnt.modules && cnt.modules.dup,
      :owndraw => cnt.owndraw,
      :registerd_to => (cnt.registerd_to && cnt.registerd_to.empty? ? [] :
                               [cnt.registerd_to[0].name, cnt.registerd_to[1]]),
      :controls => [],
      :attributes => {},
      :optional => nil
      }
    r[:substance] = cnt.substance if cnt.is_a? FDContainer
    unless cnt.registerd_to.empty?
      unless cnt.is_a? FDContainer
        r[:x] = cnt.__org_x
        r[:y] = cnt.__org_y
        r[:w] = cnt.__org_w
        r[:h] = cnt.__org_h
        r[:left] = cnt.mgLeft
        r[:top] = cnt.mgTop
        r[:right] = cnt.mgRight
        r[:bottom] = cnt.mgBottom
      end
      if (r0=cnt.registerd_to[0].substance).is_a? VRTwoPaneFrame
        if cnt.registerd_to[1] == 0
          if cnt.is_a? FDContainer
            r[:regist_index] = r0.pane1.index(cnt.substance)
          else
            r[:regist_index] = r0.pane1.index(cnt)
          end
        else
          if cnt.is_a? FDContainer
            r[:regist_index] = r0.pane2.index(cnt.substance)
          else
            r[:regist_index] = r0.pane2.index(cnt)
          end
        end
        if hole = @coverfrm.get_hole(r0)
          r[:optional] ={:l=>hole.l, :t => hole.t, :r => hole.r, :b => hole.b,
                                                            :curs => hole.curs}
          @coverfrm.close_hole(r0)
        end
      elsif r0.is_a? VRGridLayoutFrame
        if cnt.is_a? FDContainer
          r[:regist_index] = r0._vr_layoutclients.each_with_index{|c,i|
            break i if c[0] == cnt.substance}
        else
          r[:regist_index] = r0._vr_layoutclients.each_with_index{|c,i|
            break i if c[0] == cnt}
        end
      else
        if cnt.is_a? FDContainer
          r[:regist_index] = r0._vr_layoutclients.index(cnt.substance)
        else
          r[:regist_index] = r0._vr_layoutclients.index(cnt)
        end
      end
    end
    if cnt.respond_to?(:addControl)
      r[:_default_font] = cnt._default_font
      controls=cnt.controls.dup
      save_layouts = lambda do |frame|
        r[:controls] << save_window(controls.delete(frame.container.etc))
        if frame.is_a? VRTwoPaneFrame
          frame.pane1.each{|i|
            if i.is_a? SWin::Window
              r[:controls] << save_window(controls.delete(i.etc))
            else
              save_layouts.call(i) if i
            end }if frame.pane1
          frame.pane2.each{|i|
            if i.is_a? SWin::Window
              r[:controls] << save_window(controls.delete(i.etc))
            else
              save_layouts.call(i) if i
            end } if frame.pane2
        elsif frame.is_a? VRGridLayoutFrame
          frame._vr_layoutclients.each{|i|
            if i[0].is_a? SWin::Window
              r[:controls] << save_window(controls.delete(i[0].etc))
            else
              save_layouts.call(i[0]) if i[0]
            end }
        else
          frame._vr_layoutclients.each{|i|
            if i.is_a? SWin::Window
              r[:controls] << save_window(controls.delete(i.etc))
            else
              save_layouts.call(i) if i
            end }
        end
      end
      if cnt.__regsterd_vr_margined_frame
        r[:registerd_frame] = cnt.__regsterd_vr_margined_frame 
        save_layouts.call(cnt.__regsterd_vr_margined_frame)
      end
      controls.each{|i,c|
        r[:controls] << save_window(c) if c.respond_to?(:_ext_init)
      } unless controls.empty?
    end
    cnt.attributes.each{|i|
      if i[2] == "num" || i[2] == "str"
        if cnt.is_a?(FDContainer)
          r[:attributes][i[0]] = cnt.substance.send(i[0])
        else
          r[:attributes][i[0]] = cnt.send(i[0])
        end
      end
    }
    r
  end
  
  
  def saveandclosewindow(cnt)
    return unless cnt
    r = save_window(cnt)
    cnt.terminate if cnt.respond_to?(:terminate)
    @coverfrm.erase_holes(cnt) if cnt.respond_to?(:addControl)
    cnt.parent.deleteControl(cnt)
    cnt.parent.child_deleted(cnt) if cnt.parent.respond_to? :child_deleted
    r
  end

  def recreate1(c_parent, a, offset=[0,0], paste_mode=nil, addstyle=nil)
    if a[:type] <= FDContainer
      item = findPalletItem(a[:substance].class)
    else
      item = findPalletItem(a[:type])
    end
    if paste_mode then
      newname = get_serial_name(a[:name])
    else
      newname=a[:name]
    end
    addstyle = a[:style]|a[:owndraw] unless addstyle
    x0 = a[:x] + offset[0]
    y0 = a[:y] + offset[1]
    if item.klass <= SWin::Window
      c = c_parent.newFDControl(c_parent, item.klass,
             newname,a[:caption], x0, y0, a[:w], a[:h], addstyle,a[:items])
      
    else
      c = c_parent.newFDContainer(c_parent, item.klass,
             newname,a[:caption], x0, y0, a[:w], a[:h], addstyle,a[:items])
    end
    c_parent.child_created(c) if c_parent.respond_to? :child_created
    c.sendMessage(WMsg::WM_SETFONT,a[:hfont],0) unless a[:hfont] == 0
    c.modules = a[:mods]
    c.form = a[:form]
    if newname == a[:name]
      c.oldname = a[:oldname]
    else
      c.oldname = a[:name]
    end
    if a[:registerd_to].empty?
      c.registerd_to =  []
    else
      rt = c.parent.controls.find{|k,i|i.oldname == a[:registerd_to][0]}
      c.registerd_to = [rt[1], a[:registerd_to][1]]
    end
    unless a[:registerd_to].empty?
      if (r0=c.registerd_to[0].substance).is_a? VRTwoPaneFrame
        if c.registerd_to[1] == 0
          if c.is_a? FDContainer
            r0.pane1[a[:regist_index],0] = c.substance
          else
            r0.pane1[a[:regist_index],0] = c
          end 
        else
          if c.is_a? FDContainer
            r0.pane2[a[:regist_index],0] = c.substance
          else
            r0.pane2[a[:regist_index],0] = c
          end
        end
        if o=a[:optional]
          @coverfrm.open_hole(r0, o[:l],o[:t],o[:r],o[:b],o[:curs],c.parent)
        end
      elsif r0.is_a? VRGridLayoutFrame
        if c.is_a? FDContainer
          r0._vr_layoutclients[a[:regist_index],0] = c.substance
        else
          r0._vr_layoutclients[a[:regist_index],0] = [[c,c.x,c.y,c.w,c.h]]
        end
      else
        if c.is_a? FDContainer
          r0._vr_layoutclients[a[:regist_index],0] = c.substance
        else
          r0._vr_layoutclients[a[:regist_index],0] = c
        end
      end
      unless c.is_a? FDContainer
        c.extend(VRMargin).initMargin(a[:left],a[:top],a[:right],a[:bottom])
        c.margined = true
      end
    end
    if c.is_a?(FDContainer) && (cs=c.substance).is_a?(VRTwoPaneFrame)
      as = a[:substance]
      cs.ratio = as.ratio
      cs.position = as.position
      cs.gap = as.gap
      cs.bevel = as.bevel
      cs.lLimit = as.lLimit
      cs.setMargin(as.mgLeft,as.mgTop,as.mgRight,as.mgBottom)
      if cs.is_a?(VRHorizTwoPaneFrame)
        cs.rLimit = as.rLimit
      else
        cs.uLimit = as.uLimit
      end
    elsif cs && cs.is_a?(VRGridLayoutFrame)
      as = a[:substance]
      cs.instance_eval("@_vr_xsize = #{as.instance_eval("@_vr_xsize")}")
      cs.instance_eval("@_vr_ysize = #{as.instance_eval("@_vr_ysize")}")
      cs.setMargin(as.mgLeft,as.mgTop,as.mgRight,as.mgBottom)
    elsif cs && cs.is_a?(VRLayoutFrame)
      as = a[:substance]
      cs.setMargin(as.mgLeft,as.mgTop,as.mgRight,as.mgBottom)
    elsif cs
      as = a[:substance]
      if paste_mode
        cs=as.dup
      else
        cs=as
      end
    elsif c.is_a? VRTabbedPanel
      c._default_font = a[:_default_font]
      c.panels.each_index{|i|
#        c.panels[i].extend(FDCommonMethod)
#        c.panels[i].extend(FDParent).fd_parent_init
#        c.panels[i].extend CreateCtrl
        c.panels[i]._default_font = c._default_font
        a[:controls].find{|j| j[:name] == "panel#{i}"}[:controls].each{|j|
                                      recreate1(c.panels[i],j,[0,0],paste_mode)}
      }
    elsif c.is_a? VRRebar
      c._fd_items.each{|i|
        recreate1(c,a[:controls].select{|j|
           j[:name]==i[0].sub(/^@/,'')}[0],[0,0],paste_mode)} if a[:items]
    elsif c.respond_to?(:addControl) then
      c._default_font = a[:_default_font]
      c.extend(FDCommonMethod)
      c.extend(FDParent).fd_parent_init
      c.extend CreateCtrl
      a[:controls].each{|i|recreate1(c,i,[0,0],paste_mode)}
      if paste_mode then
        c.controls.each{|k,i| i.oldname = i.name}
        c.oldname = c.name
      end
      c.sendMessage(WMsg::WM_SIZE,0,MAKELPARAM(*c.clientrect[2,2]))
    end
    a[:attributes].each{|k,v|
      if c.is_a?(FDContainer)
        c.substance.send("#{k}=",v)
      else
        c.send("#{k}=",v)
      end
    }
    c
  end

  def recreateControl(cnt, parent = nil, style = nil)
    parent = cnt.parent unless parent
    idx = @tabOrders.index(cnt.etc)
    @tabOrders.delete_at(idx) if idx
    a = saveandclosewindow(cnt)
    @coverfrm.set_focus(recreate1(parent, a,[0,0], nil, style))
    @tabOrders[idx, 0] = @coverfrm.focused.etc if idx
    @coverfrm.focused.parent.sendMessage(WMsg::WM_SIZE,0,
                                 MAKELPARAM(*@coverfrm.focused.clientrect[2,2]))
    update_inspectfrm(@coverfrm.focused)
  end
  
  def delete_cont1(obj)
    unless @coverfrm.use_parent_of?(obj)
      obj.delete_child_controls
    end
    par = obj.parent
    par.tabOrders.delete(obj.etc)
    obj.terminate if obj.respond_to? :terminate
    par.deleteControl(obj)
    par.child_deleted(obj) if par.respond_to? :child_deleted
    delete_serial_name(obj.name)
  end
  
  def deleteCont
    return unless @coverfrm.selected
#    delete_cont1(@coverfrm.focused)if @coverfrm.focused
    @coverfrm.selected.each{|i| delete_cont1(i.obj)}
    @coverfrm.set_focus(nil)
    @coverfrm.clear_select
    refresh
    refreshCntName
    update_inspectfrm(nil)
    @parent.inc_modified
  end
  
  def cutCont
    retun unless @coverfrm.selected
    @cut_mode=true
    @copy_buff.clear
#    @copy_buff << saveandclosewindow(@coverfrm.focused)
    @coverfrm.selected.each{|i|@copy_buff << saveandclosewindow(i.obj)}
    @coverfrm.set_focus(nil)
    update_inspectfrm(nil)
    refresh
  end
  
  def copyCont
    retun unless @coverfrm.selected
    if @coverfrm.focused
      @copy_buff.clear
#      @copy_buff << save_window(@coverfrm.focused)
      @coverfrm.selected.each{|i|@copy_buff << save_window(i.obj)}
    end
  end
  
  def pasteCont
    unless @copy_buff.empty?
      a=[]
      org = Point[@copy_buff[0][:x], @copy_buff[0][:y]]
      paste_to = @coverfrm.paste_to ? @coverfrm.paste_to : self
      if @coverfrm.selected_point
        cpos = Point[*screen_to_client(paste_to, *@coverfrm.selected_point)]
        @c_offset = nil
      else
        @c_offset = @c_offset ?  @c_offset + 32 : 32
        cpos = Point[org.x + @c_offset, org.y + @c_offset]
      end
      @copy_buff.each do |c|
        cp2 = [cpos.x - org.x, cpos.y - org.y]
        a << recreate1(paste_to, c, cp2, !@cut_mode)
      end
      @cut_mode=nil
      @coverfrm.set_focus(a.shift)
      @coverfrm.clear_select
      a.each{|i| @coverfrm.add_select(i)}
      refreshCntName
      update_inspectfrm(@coverfrm.focused)
      refresh
    end
  end
  
  def backToParent
    return unless @coverfrm.focused
    if @coverfrm.focused.parent.parent.is_a? VRTabbedPanel
      @coverfrm.focused=@coverfrm.focused.parent.parent
    elsif @coverfrm.focused.parent != self
      @coverfrm.set_focus(@coverfrm.focused.parent)
    else
      @coverfrm.set_focus(nil)
    end
    c=@coverfrm.focused ? @coverfrm.focused : self
    refreshCntName
    update_inspectfrm(@coverfrm.focused)
    c.controls.each{|k,i|
      if i.is_a? FDContainer
        i.top(false)
      end
    }
    c.refresh
  end
  
  def setWinStyle(s = :style)
    return unless @coverfrm.focused || @coverfrm.focused == self
    ct = findPalletItem(@coverfrm.focused)
    return unless ct[:styles][:style]
    obj = @coverfrm.focused
    StyleDlg.args = [
        @coverfrm.focused.class,
        setWSArray(@coverfrm.focused.style,ct[:styles][:style]),
        setWSOption(@coverfrm.focused.style,ct[:styles][:option]),
        (ct[:styles] ? ct[:styles][:toggle] : nil)
    ]
    $main.dialog_running = 'Window Style'
    r = @screen.openModalDialog self, nil, StyleDlg
    $main.dialog_running = nil
    if r 
      ropt = r.shift
      rint = wsArray2int(r, ct[:styles][:style])
      st = ropt >= 0 ? rint | ropt : rint
      obj.style = st
      recreateControl(obj, nil, st)
      $main.inc_modified
    end
  end

  def _add_style(s2,style,hash)
    a=[]
    s2.each{|i|
      s = style & hash[i]
      a << [i.to_s , (hash[i] != s ? 0 : 1)]
    }
    a
  end

  def setWSOption(style,hash)
    r = [0] ; a = [] ; n = 0
    if hash && ! hash.empty?
      a1 = hash.dup.to_a#.sort
      a1.each{|i|
        s = [i[0].to_s,i[1]]
        ns = (s0=style & 0x3f) < 4 ? s0 : s0 & 0x3e
        r[0] = n if ns == s[1]
        a << s
        n += 1
      }
     r += a
    end
    r
  end

  def setWSArray(style,hash)
    a=[]
    s2 = hash.keys.dup
    a = a + _add_style(s2,style,hash)
    a.sort
  end

  def wsArray2int(a,hash)
    r =0 
    a.each{|i|
      c = hash[i[0].to_sym]
      r |=  c * i[1]
    }
    r |= @coverfrm.focused.owndraw unless @coverfrm.focused.is_a? VRButton
    r
  end
  
  def setExStyle(s = :exstyle)
    if @coverfrm.focused
      ct = findPalletItem(@coverfrm.focused)
      return unless ct[:styles][s]
      StyleDlg.args = [
        @coverfrm.focused.class,
      setWSArray(@coverfrm.focused.instance_eval("#{s}"),ct[:styles][s]),nil,nil
      ]
      @parent.dialog_running = 'Extended Style'
      r = @screen.openModalDialog self, nil, StyleDlg
      @parent.dialog_running = nil
      if r then
        r.shift
        rint = wsArray2int(r, ct[:styles][s])
        @coverfrm.focused.instance_eval("self.#{s} = #{rint}")
        update_inspectfrm(@coverfrm.focused)
        @parent.inc_modified
      end
    end
  end
  
  def setModules
    c = @coverfrm.focused ? @coverfrm.focused : self
    @moddlg.options["default"] = getModArray(c)
    @moddlg.move 0,0,104,195
    @parent.dialog_running = 'Modules'
    r = @moddlg.open(self)
    @parent.dialog_running = nil
    if r then
      c.modules.clear
      r.each{|i|
        c.set_modules(eval(i[0])) if i[1] == 1
      }
      @parent.inc_modified
    end
    update_inspectfrm(c)
  end

  def getModArray(c)
    r = []
    if c == self then
      FDModules::StdModules.each{|key,val|
        n = c.modules.include?(eval(key.to_s)) ? 1 : 0
        r << [key.to_s,n]
      }
      FDModules::FormModules.each{|key,val|
        n = c.modules.include?(eval(key.to_s)) ? 1 : 0
        r << [key.to_s,n]
      }
    else
      a = findPalletItem(c)
      a.mods.each{|key,val|
        n = c.modules.include?(eval(key.to_s)) ? 1 : 0
        r << [key.to_s,n]
        } if a
    end
    r
  end

  def showModDlg(a,w,h)
    @moddlg.options["default"] = a
    @moddlg.move 0,0,w,h
    @parent.dialog_running = 'Modules'
    r=@moddlg.open(self)
    @parent.dialog_running = nil
    if r then
      @parent.inc_modified
    end
    r
  end
  
  def ctrl_Tab_orders
    x0,y0,w0,h0=parent.windowrect
    return unless (obj = @coverfrm.focused)
    TabOrderDlg.args={:x=>x0,:y=>y0,:c=>@coverfrm.focused.parent,:frm=>self}
    $main.dialog_running = 'Tab order'
    @screen.modalform(self,0x02,TabOrderDlg)
    $main.dialog_running = nil
    @coverfrm.set_focus(obj)
    update_inspectfrm(obj)
    obj == self ? self.refresh : obj.parent.refresh
    $main.inc_modified
  end
  
  def changeFocuse(s)
    c = findCtrl(s)
    @coverfrm.set_focus(c)
    update_inspectfrm(c)
    refresh
  end
  
  def ctrl_setFont(to_default = nil)
    def check_default(c,d)
      hf=c.sendMessage(WMsg::WM_GETFONT,0,0)
      hf=hf+0x100000000 if hf < 0
      c.is_a?(FDContainer) || !@_hsh_font[hf] || (d && hf == d.hfont)
    end
    c = @coverfrm.focused ? @coverfrm.focused : self
    if c.respond_to? :addControl
      hf = c._default_font ? c._default_font.hfont : 0
    else
      hf=c.sendMessage(WMsg::WM_GETFONT,0,0)
      hf=hf+0x100000000 if hf < 0
    end
    
    if to_default
      return unless @_hsh_font[hf]
      newfont = c.parent._default_font if c.parent.respond_to? :_default_font
      dflt = nil
    else
      af = @_hsh_font[hf] ? [@_hsh_font[hf].params,0,0] :
                                      [["System",19,0,300,135,0,0,2,128],135,0]
      af[0][1]=(af[0][1]).abs.to_i if af
      @parent.dialog_running = 'Choose font'
      f = SWin::CommonDialog.chooseFont self, af
      @parent.dialog_running = nil
      if f then
        newfont=@_hsh_font[setFontHash(f)]
        dflt = newfont
        @parent.inc_modified
      else
        return
      end
    end
    
    c.setFont(newfont) unless c == self
    if c.respond_to? :addControl
      if c.is_a? VRTabbedPanel
        c.sendMessage(WMsg::WM_SIZE,0,MAKELPARAM(*c.clientrect[2,2]))
        c.panels.each do |i|
          i.controls.each{|k,j| j.setFont(dflt) if
            check_default(i,c._default_font)}
          i._default_font=dflt
        end
      else
        c.controls.each do |id,j|
          j.setFont(dflt) if check_default(j,c._default_font)
        end
      end
      c._default_font=dflt
    else
      x0,y0,w0,h0=c.windowrect
      @coverfrm.focused.move(c.x,c.y,w0,h0)
      @coverfrm.set_focus(c)
    end
      
    update_inspectfrm(@coverfrm.focused)
  end
  
  def setValue(klass,val)
    klass = val
  end

  def setFontHash(f)
    unless  r=@_hsh_font.select{|k,v|
      f[0][0]==v.params[0] &&
      f[0][1]==v.params[1] &&
      f[0][2]==v.params[2] &&
      f[0][3]==v.params[3] &&
      f[0][4]==v.params[4] &&
      f[0][5]==v.params[5] &&
      f[0][6]==v.params[6] &&
      f[0][7]==v.params[7] &&
      f[0][8]==v.params[8]
    }[0] then
      f[0][3] = f[0][3]/100.to_i #weight
      ffont=@screen.factory.newfont *f[0]
      @_hsh_font[ffont.hfont]=ffont
      ffont.handle
    else
      r[0]
    end
  end
  
  def getFontHash(font_handle)
    @_hsh_font[font_handle]
  end
  
  def get_font_number(font_handle)
    return nil unless @_hsh_font[font_handle]
    unless (n=@_font_array.index(font_handle)) then
      @_font_array << font_handle
      @_font_array.size-1
    else
      n
    end
  end
  
=begin
  def showArrayEditDlg(a,w,h)
    @arrydlg.move 0,0,w,h #204,200
    @arrydlg.options["default"] = a.gsub(/\n/,"\r\n").gsub(/\t/,'\t')
    if r=@arrydlg.open(self) then
      r.gsub(/\\t/,"\t").gsub(/\r\n/,"\n").to_s
    end
  end
=end
  
  def setTrueFalse(str,svalue)
    if @coverfrm.focused
      @coverfrm.focused.instance_eval("#{str}(#{svalue})")
    else #this form
      self.instance_eval "@frm_#{str}=svalue"
    end
  end
  
  def registerLayout
    x0, y0, w0, h0 = parent.windowrect
    obj = @coverfrm.focused
    LayoutDlg.args={:x=>x0,:y=>y0,
      :c => obj ? obj.parent : self,
      :frm => self,
      :focused => @coverfrm.focused}
    @parent.dialog_running = 'Register'
    r = @screen.openModalDialog(self,0x02,LayoutDlg)
    @parent.dialog_running = nil
    return unless r
    if (s=obj.substance).is_a?(VRTwoPaneFrame)
      [s.pane1,s.pane2].each_with_index do |pane,j|
      r[j].each_with_index do |v,i|
        unless f = pane.find{|k|
                             k.is_a?(SWin::Window) ? k == v : k.container == v}
          f =  v
          unless f.is_a? FDContainer
            f.extend(VRMargin)
            f.initMargin(0,0,0,0)
            f.margined = true
          end
        end
        unless f.is_a? SWin::Window
          f.container.registerd_to = [obj,j]
        else
          f.registerd_to = [obj,j]
        end
        f = f.substance if f.is_a? FDContainer
        pane.delete(f)
        pane[i,0] = f
      end
      (pane.size-1).downto(r[j].size){|k|
        c = pane.delete_at(k)
        if c.is_a? SWin::Window  
          c.registerd_to.clear
          c.setMargin(nil,nil,nil,nil)
          c.margined = nil # still overridden `write' method.
          recreateControl(c)
        else
          c.container.registerd_to.clear
        end
        } if r[j].size < pane.size
      end
    elsif s.is_a? VRGridLayoutFrame
      r.each_with_index do |v,i|
        unless f = s._vr_layoutclients.find{|j|
                    j[0].is_a?(SWin::Window) ? j[0] == v : j[0].container == v }
          if v.is_a? FDContainer
            f = [v.substance,0,0,v.parent.w,v.parent.h]
          else
            f =  [v,v.x,v.y,v.w,v.h]
          end
          if f[0].is_a? SWin::Window
            f[0].extend(VRMargin).initMargin(0,0,0,0)
            f[0].margined = true
          end
        end
        unless f[0].is_a? SWin::Window then
          f[0].container.registerd_to = [obj,0]
        else
          f[0].registerd_to = [obj,0]
        end
        f[0] = f[0].substance if f[0].is_a? FDContainer
        s._vr_layoutclients.delete(f)
        s._vr_layoutclients[i,0] = [f]
      end
      (s._vr_layoutclients.size-1).downto(r.size){|j|
        c = s._vr_layoutclients.delete_at(j)
        if c[0].is_a? SWin::Window
          c[0].registerd_to.clear
          c[0].setMargin(nil,nil,nil,nil)
          c[0].margined = nil
          recreateControl(c[0])
        else
          c[0].container.registerd_to.clear
        end
      } if r.size < s._vr_layoutclients.size
    else
      r.each_with_index do |v,i|
        unless f = s._vr_layoutclients.find{|j|
            if j.is_a? SWin::Window then j == v else j.container == v end }
          f = v
          unless f.is_a? FDContainer
            f.extend(VRMargin).initMargin(0,0,0,0)
            f.margined = true
          end
        end
        unless f.is_a? SWin::Window
          f.container.registerd_to = [obj,0]
        else
          f.registerd_to = [obj,0]
        end
        f = f.substance if f.is_a? FDContainer
        s._vr_layoutclients.delete(f)
        s._vr_layoutclients[i,0] = f
      end
      (s._vr_layoutclients.size-1).downto(r.size){|j|
        c = s._vr_layoutclients.delete_at(j)
        if c.is_a? SWin::Window
          c.registerd_to.clear
          c.setMargin(nil,nil,nil,nil)
          c.margined = nil
          recreateControl(c)
        else
          c.container.registerd_to.clear
        end
      } if r.size < s._vr_layoutclients.size
    end
    @coverfrm.set_focus(obj)
    obj.parent.sendMessage(WMsg::WM_SIZE, 0,
                                        MAKELPARAM(*obj.parent.clientrect[2,2]))
    update_inspectfrm(obj)
    refresh
  end
  
  def make_fonts_str(a)
    return  nil if a.empty?
    r = "[\n"
    a.each{|i|
      f=@_hsh_font[i].params.to_a
      f[0]="\'#{f[0]}\'"
      f[3]=f[3]/100
      r+="      VRLocalScreen.factory.newfont(#{f.join(',')}),\n"}
    r[r.size-2,1]=""
    r+="    ]\n"
    r
  end
  
  def get_require
    @modules.each{|m|
      if rq = FDModules::FormModules["#{m}".intern ] then
        (@required << rq.requires).uniq!
      elsif rq = FDModules::StdModules["#{m}".intern ] then
        (@required << rq.requires).uniq!
      end
    }
    @required.reject!{|i| !i}
    @required
  end

  def ex_include
    r = ""
    @included.each{|s| r += "  include #{s} if defined? #{s}\n" if s} unless @included.empty?
    @modules.each{|s| r += "  include #{s}\n" if s} unless @modules.empty?
    r
  end
  
  def examine
    a=[]
    @cntnmodules=[]
    rf = []
    rc = []
    ctls = @controls.dup
    x0,y0,w0,h0=self.windowrect
    str = "\n  def construct\n"
    n = str.size
    str += "    self.sizebox=#{@frm_sizebox}\n" if @frm_sizebox == 'false'
    str += "    self.maximizebox=#{@frm_maximizebox}\n" if @frm_maximizebox == 'false'
    str += "    self.caption = '#{self.caption}'\n"
    str += "    self.move(#{x0},#{y0},#{w0},#{h0})\n"
    
    analize_frame = lambda do |frame|
        if frame.is_a? VRTwoPaneFrame
          frame.pane1.each do |i|
            unless i.is_a? SWin::Window
              analize_frame.call(i)
              c = ctls.delete(i.container.etc)
              rf << c.createSourceStr
            end
          end
          frame.pane2.each do |i|
            unless i.is_a? SWin::Window
              analize_frame.call(i)
              c = ctls.delete(i.container.etc)
              rf << c.createSourceStr
            end
          end
        elsif frame.is_a? VRGridLayoutFrame
          frame._vr_layoutclients.each do |i|
            unless i[0].is_a? SWin::Window
              analize_frame.call(i)
              c = ctls.delete(i[0].container.etc)
              rf << c.createSourceStr
           end
          end
        else
          frame._vr_layoutclients.each do |i|
            unless i.is_a? SWin::Window
              analize_frame.call(i)
              c = ctls.delete(i.container.etc)
              rf << c.createSourceStr
            end
          end
        end
    end
    
    if @__regsterd_vr_margined_frame
      analize_frame.call(@__regsterd_vr_margined_frame)
      c = ctls.delete(@__regsterd_vr_margined_frame.container.etc)
      rf << c.createSourceStr
    end 
    ctls.each do |k,i|
      if i.is_a? FDContainer
        c = ctls.delete(i.etc)
        if i.substance.is_a? VRMenu
          str += c.createSourceStr
        else
          rc << c.createSourceStr
        end
      end
    end
    @tabOrders.each do |id|
      item = ctls.delete(id)
      item.style = item.style | WStyle::WS_TABSTOP
      (@required << 'vrowndraw').uniq! if item.respond_to?(:owndraw) &&
                                                          item.owndraw > 0 
      target=item
      str += target.createSourceStr
      item.style = item.style-WStyle::WS_TABSTOP
    end
    ctls.each do |id,item|
      (@required << 'vrowndraw').uniq! if item.respond_to?(:owndraw) &&
                                                          item.owndraw > 0 
      str += item.createSourceStr if item.respond_to? :createSourceStr
    end
    str += rf.join("\n")
    str += rc.join("\n")
    str += "  end \n\n"
    str
  end

  def linscan(a,ptn)
    n = 0 ; r = nil
    while a.size-1 >= n do
      if a[n] =~ ptn then
        r = n+1 ; break
      end
      n += 1
    end
    r
  end

  def linscan2(a,ptn1,ptn2 = nil, n = 0)
    r = nil
    while a.size-1 >= n do
      if a[n] =~ ptn2 then
        break
      elsif a[n] =~ ptn1 then
        r = n+1 ; break
      end
      n += 1
    end
    r
  end

  def make_executive
    @_font_array.clear
    s = examine
    s[0,0] = @cntnmodules.join("") if @cntnmodules
    s[0,0] = "  include VRContainersSet\n" if @type_of_form<=VRDialogComponent
    s[0,0] = ex_include
    s[0,0] = getDEFAULTFONT("  ") if @_default_font
    s[0,0] ="  #{self.name.capitalize1}_fonts="+
                    "#{make_fonts_str(@_font_array)}" unless @_font_array.empty?
    s[0,0] = "\nclass #{self.name.capitalize1} < #{@type_of_form}\n"
    s += "end\n"
    s
  end

  def check_rejectable_modules(j)
    j==VRToolbarUseable || j==VRStdControlContainer || 
    j==VRComCtlContainer || j==VRMarginedFrameUseable ||
    j==VRContainersSet || j==VROwnerDrawControlContainer ||
    j==VRMenuUseable
  end
  
  def readfile(str)
#    str = ""
    parser = FDParser.new(self,true)
#    if f then
      r = true
#      begin
#        open(f){|ff|
#          $tstamp=ff.stat.mtime.to_i
#          ff.each  do |lin|
#            str+=lin
#          end
#        }
        @buff,@nodes,@variables = parser.parse str
        @modules = @nodes["modules"].collect!{|i| eval(i)}.delete_if{|j|
          check_rejectable_modules(j)
        }
        set_controls(self,@nodes)
        set_variables(@variables)
#        refreshCntName
#      rescue
#        messageBox "\nIf you are not going to open the file of an old version\n" +
#                   "or you edited manually,then please contact me.\n\n#{$!}",
#                    "File Reading Error - #{f}",16
#        r = false
#      end
#    end
    update_inspectfrm(nil)
    r
  end
  
  def parse_str(s)
    parser = FDParser.new(self)
    @buff,@nodes,@variables = parser.parse s
    @modules = @nodes["modules"].collect!{|i| eval(i)}.delete_if{|j|
      check_rejectable_modules(j)
    }
    set_controls2(self,@nodes)
    #    set_variables(@variables)
    @coverfrm.bring_to_top_container(self)
  end
  
  def set_controls(c_parent,nodes)
    if c_parent.is_a? VRTabbedPanel
      c_parent.panels.each{|i|
        no=nodes["childs"].select{|j| j["name"] =~ /#{i.name}$/}[0]
        set_controls(i,no)
      }
    end
    r=nil
    nodes["addings"].each{ |i|
      mtd=findPalletItem(i[0]).createMethod
      ctrl=instance_eval("#{mtd}(c_parent,*i)")
      @names << ctrl.name
      unless (f1 = nodes["fonts"]) == {} then
        if f2 = f1["@"+i[1]] then
          if f2.is_a? Integer then
            ctrl.setFont(@_hsh_font[@temp_fonts[f2].hfont])
          else #for old form file
            f = f2
#            ffont=@screen.factory.newfont(f.fontface,f.height,f.style,
#                (f.weight / 100),f.width, f.escapement, f.orientation,
#                f.pitch_family,f.charset,f.point,f.color)
            ffont=setFontHash(f)
            ctrl.setFont(@_hsh_font[ffont])
            ctrl._default_font = @_hsh_font[ffont] if
                                                ctrl.respond_to? :_default_font
          end
        end
      end
      if ctrl.respond_to?(:addControl) && ctrl.class != FDContainer then
        ctrl.extend FDCommonMethod
        ctrl.extend(FDParent).fd_parent_init
        ctrl.extend CreateCtrl
#        r = nodes["childs"].select{|n| n["name"]=="Cntn_#{ctrl.name}"}[0]
        r = nodes["childs"].select{|n| n["name"]=~/Cntn\w*_#{ctrl.name}$/}[0]
        ctrl.modules = r["modules"].collect!{|i| eval(i)}.delete_if{|j|
          check_rejectable_modules(j)
        } if r
        set_controls(ctrl,r)
      else
        r = nodes["childs"].select{|n| n["name"]=~/Extn\w*_#{ctrl.name}/}[0]
        ctrl.modules = r["modules"].collect!{|i| eval(i)}.delete_if{|j|
          check_rejectable_modules(j)
        } if r
      end
      ctrl.parent.child_created(ctrl) if ctrl.parent.respond_to? :child_created
    }
  end
  
  def set_controls2(c_parent,nodes)
    str2inst = lambda do |_ctls|
      if _ctls.is_a?(String)
        [c_parent.instance_eval(_ctls)]
      elsif _ctls.is_a?(Array)
        _ctls.map do |i|
          if i.is_a? Array
            str2inst.call(i)
          elsif i.is_a?(String)
            c_parent.instance_eval(i)
          else
            i
          end
        end
      else
        [_ctls]
      end
    end
    if c_parent.is_a? VRTabbedPanel
      c_parent.panels.each{|i| 
        no=nodes["childs"].select{|j| j["name"] == i.name.capitalize1 }[0]
        set_controls2(i,no)
      }
    end
    c_parent.setFont(@temp_fonts[nodes["fonts"]["self"]]) if
                                                         nodes["fonts"]["self"]
    c_parent._default_font=@temp_fonts[nodes.default_font] if nodes.default_font
    r=nil
    nodes["addings"].each{|i|
#      mtd=findPalletItem(i[0]).createMethod
#      cnt = findPalletItem(i[0])
      i[7] = 0 unless i[7]
      if (i[7] & 0x10000) == 0x10000
        i[7] &= ~0x10000
        #ctrl=instance_eval("#{mtd}(c_parent,*i)")
        ctrl = newFDControl(c_parent, *i)
        c_parent.tabOrders << ctrl.etc
      else 
        if i[0] <= SWin::Window
          ctrl = newFDControl(c_parent, *i)
        else
          ctrl = newFDContainer(c_parent,*i)
        end
#        ctrl=instance_eval("#{mtd}(c_parent,*i)");
      end
      @names << ctrl.name
      if (f1 = nodes["fonts"]) != {} && (f2 = f1["@"+i[1]])
        ctrl.setFont(@_hsh_font[@temp_fonts[f2].hfont]) if f2.is_a? Integer
      end
      if ctrl.respond_to?(:addControl) && ctrl.class != FDContainer
#        ctrl.extend FDCommonMethod;p [1855,ctrl]
#        ctrl.extend(FDParent).fd_parent_init
#        ctrl.extend CreateCtrl
        r = nodes["childs"].select{|n| n["name"]=~/#{ctrl.name.capitalize1}$/}[0]
        ctrl.modules = r["modules"].collect!{|i| eval(i)}.delete_if{|j|
          check_rejectable_modules(j)
        } if r
        set_controls2(ctrl,r)
      else
        r = nodes["childs"].select{|n| n["name"]==ctrl.name.capitalize1}[0]
        ctrl.modules = r["modules"].collect!{|i| eval(i)}.delete_if{|j|
          check_rejectable_modules(j)
        } if r
      end
      ctrl.parent.child_created(ctrl) if ctrl.parent.respond_to? :child_created
    }
    nodes.methods.each{|i|
      case i[1]
      when 'sizebox=','maximizebox='
        instance_eval "@frm_#{i[1]}'#{i[2]}'"
      when /^ctn_([a-z][a-zA-Z0-9_]*)=/
        instance_eval("@#{$1}").set_attrs(i[2])
      else
        if (c=c_parent.instance_eval(i[0])).is_a? FDContainer
          if c.substance.is_a? VRMenu
            c.send(i[1],*str2inst.call(i[2]))
          else
            c.substance.send(i[1],*str2inst.call(i[2]))
          end
        else
          c.send(i[1],*str2inst.call(i[2]))
        end
      end
    }
  end
  
  def makeModStruct(cnt,parent=nil)
    ms=ModStruct.new(cnt.oldname.capitalize1,cnt.name.capitalize1,parent)
    cnt.controls.each{|k,i|
      next unless i.respond_to?(:_ext_init) 
      if !use_parent_of?(i)
        ms.childs << makeModStruct(i,ms)
      elsif !i.modules.empty? || (i.owndraw > 0)
        ms.childs << ModStruct.new(i.name.capitalize1,i.oldname.capitalize1,ms)
      end
    }
    ms
  end
  
  def set_variables(variables)
    variables.each{|var,val|
      case var
      when 'sizebox','maximizebox'
        instance_eval "@frm_#{var}='#{val}'"
      when /^ctn_(\w+)/
        instance_eval "@#{$1}.move #{val[0]},#{val[1]},24,24"
        instance_eval "@#{$1}.set_attrs val[2,val.size-2]"
      else
      end
    }
  end
  
  def self_dropfiles(files)
    parent.open_by_drop(files[0])
  end
  
  def self_gotfocus
#    hwndfore = User32.getForegroundWindow
    $designfrm=self
    @coverfrm.show_and_resize if @coverfrm
    parent.window_menu_set_check(self.etc)
    refreshCntName
    update_inspectfrm(@focused)
#    refresh
  end
  
  def self_lostfocus
#    hwndfore = User32.getForegroundWindow
#    if hwndfore != self.hWnd && hwndfore != @coverfrm.hWnd
#      @coverfrm.hide
#    end
#   refresh
#    @coverfrm.hide
  end
  
#  def self_mousemove(shift,x,y)
#    @coverfrm.show_and_resize
#  end
  
  def self_resize(w,h)
    @coverfrm.resize if @coverfrm
#    x,y,w,h = self.clientrect
#    GDI32.deleteObject(@hrgn)
#    @hrgn=GDI32.createRectRgn(x,y,w,h)
#    GDI32.selectClipRgn(@dc,@hrgn)
    a=windowrect
    $ini.write "designform","top",a[0]
    $ini.write "designform","left",a[1]
    $ini.write "designform","width",a[2]
    $ini.write "designform","height",a[3]
    update_inspectfrm(nil)
  end
  
  def self_move(x0,y0)
    if self.focused?
      _x,_y,_w,_h = self.windowrect
      @coverfrm.move(_x,_y,_w,_h)
      refresh
    end
    update_inspectfrm(self) unless @focused
    parent.inc_modified
  end
  
  def self_close
    SKIP_DEFAULTHANDLER
  end
  
end

