#INspect Window of FormDesigner

require 'vr/vruby'
require 'vr/sysmod'
require 'vr/vrcontrol'
require 'vr/vrcomctl'
require 'vr/vrhandler'
require 'vr/clipboard'
require 'fdvr/fddialogs'

class PnEvt < VRPanel
  include VRResizeable
  def construct
    messageBox self.to_s
    addControl VRListbox,"evtList",""
    @evtList.move 0,0,100,100
  end

  def self_resize(w,h)
    messageBox w.to_s
    r=cleientrect
    @evtList.move 0,0,w,h
  end
end

class PnMtd < VRPanel
  include VRResizeable
  attr :inspectVew
  def construct
    addControl VRButton,"bt1","bt1",0,0,100,25
    addControl VRListview ,"inspectVew", "",0,0,100,100
    @inspectVew.reportview
    @inspectVew.addColumn("name")
    @inspectVew.addColumn("value")
    @inspectVew.setColumnWidthOf(1,78)
    @inspectVew.visible=true
  end
  
  def self_resize(w,h)
    @inspectVew.move(0,0,w,h)
  end
end

class EditableListview <  EDListview

  include VRParent
  include VRStdControlContainer
  attr :ed,1
  attr :btArray,1
  
  def construct
    self.lvexstyle=1
    addControl InplaceEdit,"ed","ed",0,0,10,10,0x80
    #create inplace editor
    addControl VRButton,"btStyle","...",0,0,10,10
    addControl VRButton,"btFont","...",0,0,10,10
    addControl VRButton,"btModule","...",0,0,10,10
    addControl VRButton,"btArray","...",0,0,10,10
    addControl VRCombobox,"cbTF",'true',0,0,10,40
    @ed.setFont $SysFont
    @btStyle.setFont $SysFont
    @btFont.setFont $SysFont
    @btModule.setFont $SysFont
    @cbTF.setFont $SysFont
    @ed.visible=false
    @btStyle.visible=false
    @btFont.visible=false
    @btModule.visible=false
    @btArray.visible=false
    @cbTF.setListStrings ['true','false']
    @cbTF.visible=false
  end

  def setFont(font)
    super
    @ed.setFont(font)
  end
  
  def hideAllContorls
    @controls.each{|i,j| j.visible=false}
  end
  
  def self_lbuttondown(shift,x,y)
    hideAllContorls
    @idx,@subitem,left,top,width,height = *hittest3(x,y)
    selectItem(@idx,false)
    if  @subitem!=1 then
      width = getColumnWidthOf(1)
      left = getColumnWidthOf(0)
      @subitem = 1
    end
    case getItemTextOf(@idx,2)
    when ""
      s=getItemTextOf(@idx,1)
      @ed.move(left-1,top-1,width+2,height+2)
      @ed.text=getItemTextOf(@idx,@subitem)
      @ed.show
      @ed.focus
    when "btStyle"
      @btStyle.move(left+width-height,top,height,height)
      @btStyle.show
    when "btFont"
      @btFont.move(left+width-height,top,height,height)
      @btFont.show
    when "btModule"
      @btModule.move(left+width-height,top,height,height)
      @btModule.show
    when "btArray"
      @btArray.move(left+width-height,top,height,height)
      @btArray.show
    when "cbTF"
      s=getItemTextOf(@idx,1)
      @cbTF.move(left,top-4,width,height+40)
      @cbTF.select s=='true' ? 0 : 1
      @cbTF.show
    else
    end
  end

  def update
    return if getItemTextOf(@idx,1) == @ed.text
    if @idx == 0 && @parent.parent.designfrm.names.index(@ed.text) then
      messageBox "already used name : '#{@ed.text}'",'name definition eror',16
      return
    end
    setItemTextOf(@idx,1,@ed.text)
    @parent.updateCont
  end
  
  def btStyle_clicked
    @parent.parent.designfrm.setWinStyle
  end
  
  def btFont_clicked
    @parent.parent.designfrm.ctrl_setFont
  end
  
  def btModule_clicked
    @parent.parent.designfrm.setModules
  end
  
  def btArray_clicked
    @parent.parent.designfrm.focused.instance_eval("#{getItemTextOf(@idx,0)}")
  end
  
  def cbTF_selchanged
    str = getItemTextOf(@idx,0)
    svalue = @cbTF.getTextOf(@cbTF.selectedString)
    @parent.parent.designfrm.setTrueFalse(str,svalue)
    setItemTextOf(@idx,1,svalue)
  end
end

class FDListboxExt < VRListbox

  def vrinit
    super
    addCommandHandler(WMsg::LBN_DBLCLK, "dblclicked",MSGTYPE::ARGNONE,nil)
  end
end

module FDInspect
  include VRMessageHandler
  include VRResizeable
  include VRDestroySensitive

  attr :cbControl,1
  attr :evtList,1
  attr :mthdList,1
  attr :stb2,1
  attr :skip_ctrl_name,1
  
  def vrinit
    super
    addHandler(WMsg::WM_ACTIVATE,"activate", MSGTYPE::ARGINTINT,0)
#    addHandler(WMsg::WM_CLOSE,"close", MSGTYPE::ARGNONE,nil)
    acceptEvents([WMsg::WM_ACTIVATE])
#    acceptEvents([WMsg::WM_CLOSE])
  end

  def construct
    begin SWin::Application.setAccel(self,@parent) ;rescue ;end
    addControl VRTabControl,"tab1","tab1"
    @tab1.setFont $SysFont
    @tab1.insertTab(0,"Attr")
    @tab1.insertTab(1,"Event")
    @tab1.insertTab(2,"Mthd")
    addControl VRStatusbar,"stb2",""
    addControl FDListboxExt,"evtList",""
    addControl FDListboxExt,"mthdList",""
    @evtList.setFont $SysFont
    @mthdList.setFont $SysFont
    addControl VRCombobox,"cbControl","ComboBox1"
    @cbControl.setFont($SysFont)
    @cbControl.setListStrings(["1","2","4","8","16"])
    @cbControl.select(0)
    @evtList.setListStrings([])
    @evtList.visible=false
    @mthdList.visible=false
    addControl EditableListview ,"inspectVew", ""
    @inspectVew.reportview
    @inspectVew.setFont($SysFont)
    @inspectVew.addColumn("name")
    @inspectVew.addColumn("value")
    @inspectVew.addColumn("option")
    @inspectVew.setColumnWidthOf(1,78)
    @inspectVew.setColumnWidthOf(2,0)
    @inspectVew.enabled=true
  end

  def self_created
    
  end

  def updateCont
    a=[] ; t=[] ; b=[]
    n = @inspectVew.countItems
    for i in 0 .. (n-1) do
      t << @inspectVew.getItemTextOf(i,0)
      a << @inspectVew.getItemTextOf(i,1)
      b << @inspectVew.getItemTextOf(i,2)
    end

    if @parent.designfrm.focused.class == FDContainer then
      if n > 4 then 4.upto(n-1){|i|
          @parent.designfrm.focused.instance_eval("@_#{t[i]}=#{a[i].inspect}") if b[i] == ""
        }
      end
      @parent.designfrm.updateCont(a[0],a[1],a[2].to_i,a[3].to_i,24,24)
    else
      @parent.designfrm.updateCont(a[0],a[1],a[2].to_i,a[3].to_i,a[4].to_i,a[5].to_i)
    end
  end

  def self_activate(wParam,hwnd)
    @inspectVew.hideAllContorls if LOWORD(wParam) == 0
  end

  def self_resize(w,h)
    a=windowrect
    @tab1.move(0,20,w,20)
    @cbControl.move(0,0,w,200)
    @evtList.move(0,40,w,h-60)
    @mthdList.move(0,40,w,h-60)
    @inspectVew.move(0,40,w,h-60)
    $ini.write "inspect","top",a[1]
    $ini.write "inspect","left",a[0]
    $ini.write "inspect","width",a[2]
    $ini.write "inspect","height",a[3]
  end

  def tab1_selchanged
    case @tab1.selectedTab
    when 0
      @evtList.visible=false
      @mthdList.visible=false
      @inspectVew.visible=true
    when 1
      @evtList.visible=true
      @mthdList.visible=false
      @inspectVew.visible=false
    when 2
      @mthdList.visible=true
      @evtList.visible=false
      @inspectVew.visible=false
    end
    @stb2.caption = ""
  end

  def self_destroy
    parent.inspectShow.checked = false
    @controls.each{|i,c| 
      deleteControl(c)
    }
    $ini.flash
  end

  def self_close
#    p "close"
#    self.visible=false
  end

  def setItems(a)
    @inspectVew.clearItems
    a.each do |item|
      @inspectVew.addItem(item)
    end
  end
  
  
  def evtList_selchanged
    if tt=@evtList.getTextOf(@evtList.selectedString) then
      unless tt =~ /^self_\w+/ then
        unless @skip_ctrl_name then
          nm = (@parent.designfrm.focused)?(@parent.designfrm.focused.name) :"self" 
          nm += "_"
        end
      end
      tt="  def #{nm}#{tt}\n  \n  end\n\n"
      @stb2.caption = "Copied to ClipBoard"
      clb1=Clipboard.open(self.hWnd)
      clb1.setText(tt)
      clb1.close
    end
  end
  
  def evtList_dblclicked
    parent.show_editor
  end
   
  def mthdList_selchanged
    if t=@mthdList.getTextOf(@mthdList.selectedString) then
      if @parent.designfrm.focused.class == FDContainer then
        tt = @parent.designfrm.focused.createMthodStr(t)
      else
        n = (@parent.designfrm.focused) ? (@parent.designfrm.focused.name) : ""
        case t
        when /(\A[a-z_]\w*)\s*=\s*(.+)/
          t1 = $1; t2 = "="
        when /(\A[a-z_]\w*)\s*(\(.*\))/
          t1 = $1; t2 = $2  #"(#{$2.gsub(/[^,]/,"")})" which do you like?
        when /(\A[a-z_]\w*)/
          t1 = $1 ; t2 = ""
        end
        tt="@#{n}.#{t1}#{t2}"
      end
      @stb2.caption = "Copied to ClipBoard"
      clb1=Clipboard.open(self.hWnd)
      clb1.setText(tt)
      clb1.close
    end
  end
  
  def mthdList_dblclicked
    parent.show_editor
  end

  def cbControl_selchanged
    @inspectVew.hideAllContorls
    s=@cbControl.getTextOf(@cbControl.selectedString).sub(/(.+):.+/,'\1')
    @parent.designfrm.changeFocuse(s)
  end
end

