# the main window of FormDesiner

require 'set'
require 'Win32API'
require 'swin'
require 'vr/vruby'
require 'vr/vrcontrol'
require 'vr/vrcomctl'
require 'vr/vrhandler'
require 'vr/vrtooltip'
require 'vr/vrtimer'
require 'fdvr/fdresources'

module WConst
  WS_CAPTION=0x00c00000
  WS_SYSMENU=0x00080000
  DS_SETFONT=0x40
  DS_MODALFRAME=0x80
  LBS_NODATA  = 0x2000
  LBS_NOTIFY  = 0x0001
  LBS_OWNERDRAWFIXED = 0x0010
end

class ArrayedToolbar < VRToolbar
  def insertArrayedbutton(num,name,tbStyle=TBSTYLE_BUTTON)
    r = insertButton(num,name+"#{num}",tbStyle)
    @parent.registerControlAsArrayed(num,r,name,r.etc)
  end

  def addArrayedbutton(num,name,tbStyle=TBSTYLE_BUTTON)
    r = addButton(name+"#{num}",tbStyle)
    @parent.registerControlAsArrayed(num,r,name,r.etc)
  end
end

module FDPanelExt
  include VRToolbarUseable
  attr :items
  def setToolbar(items)
    @items = items
    addControl ArrayedToolbar,'tb','tb',0,0,100,40,2048
    @tb.addButton "btnoselect",WConst::TBSTYLE_BUTTON
    @tb.insertButton 1,"btsep",WConst::TBSTYLE_SEP
    items.each_index{|i|
      @tb.addArrayedbutton(i, "bt",WConst::TBSTYLE_CHECKGROUP)
    }
    iml=imagelistCreate(items)
    @tb.setImagelist(imagelistCreate(items))
    @tb.autoSize
    2.upto(@tb.countButtons-1){|i|
      $tooltip.addTool @_vr_toolbar_buttons[@tb.getButton(i)[1]],items[i-2].info
    }
    self.refresh
  end

  def imagelistCreate(a)
    r=@screen.factory.newimagelist(23,23,1)
    bmp=SWin::Bitmap.loadString FDBmps::BmpNoselect
    r.addmasked(bmp,0x00808000)
    if a then
      a.each do |item|
        bmp=SWin::Bitmap.loadString item.bmp
        r.addmasked(bmp,0x00808000)
      end
    end
    r
  end

  def noselection
    for i in 0..@tb.countButtons - 1
      @tb.setButtonStateOf(@tb.indexToCommand(i),4)
      parent.parent.setcontrol nil
    end
  end

  def bt_clicked(i)
    parent.parent.setcontrol @items[i]
  end

  def btnoselect_clicked
    noselection
  end

end

class FDTabbedPanel < VRTabControl #setup Pallets
  include VRParent
  attr :panels

  def vrinit
    super
    @panels = []
    @pallets = []
  end

  def addPanel(pallet)
    i = countTabs
    insertTab i, pallet.title
    x1,y1,w1,h1 = adjustRect(0,0,self.w,self.h,false)
    @pallets << pallet
    @panels << addControl(VRPanel,"panel#{i}","panel#{i}",x1,y1,w1-x1,h1-y1)
    @panels.last.extend VRContainersSet
    @panels.last.extend(FDPanelExt).setToolbar(pallet.items)
    @panels.last.containers_init
    @panels.last.show 0
    @_vr_prevpanel=0
    selectTab 0
  end

  def selectTab(i)
    super
    selchanged
  end

  def selchanged
    @panels[@_vr_prevpanel].show(0) if @_vr_prevpanel
    t=selectedTab
    @panels[t].show
    @_vr_prevpanel=t
    @panels[t].refresh
    @panels[t].noselection
  end

  def noselectAll
    @panels.each {|i| i.noselection}
  end

end

module Toolbarhandler

  def imagelistCreate(a)
    @iml=@screen.factory.newimagelist(23,23,1)
    bmp=SWin::Bitmap.loadString $noselectbmp
    @iml.addmasked(bmp,0x00808000)
    if a then
      a.each { |item|
        bmp=SWin::Bitmap.loadString item.bmp
        @iml.addmasked(bmp,0x00808000)
      }
    end
  end

end #Toolbarhandler

module ExecuteDesignfrm
  include VRDestroySensitive
  def vrinit
    super
    $subwnd = self
  end
  def self_destroy
    $main.exitExec if $main.alive?
  end
end

$newclass = VRLocalScreen.factory.registerWinClass("designfrm",nil,nil,nil,0)

class DesignForm < VRForm
  def DesignForm.winclass
    $newclass
  end
end

class FDControlSelection < VRForm # As Main Form
  attr :inspectfrm
  attr :designfrm
  attr :tab
  attr :formShow
  attr :inspectShow
  attr :amenu
  attr :afont,1
  include VRStatusbarDockable
  include VRMenuUseable
  include VRToolbarUseable
  include VRDestroySensitive
  include VRCommonDialog
  include VRResizeable
  include VRTimerFeasible
  include WConst

  def vrinit
    super
    addHandler(WMsg::WM_ACTIVATEAPP,"activateapp", MSGTYPE::ARGINTINT,0)
    addHandler(WMsg::WM_CLOSE,"close",MSGTYPE::ARGNONE,nil)
    acceptEvents([WMsg::WM_ACTIVATEAPP])
    acceptEvents([WMsg::WM_CLOSE])
    $SysFont = @screen.factory.newfont("lr oSVbN",12)
    $SysFont2 = @screen.factory.newfont("lr oSVbN",10)
  end

  def sorry
    messageBox "Sorry just moment"
  end

  def preferdlgcreate
    tpl=VRDialogTemplate.new
    tpl.style = WS_CAPTION | DS_MODALFRAME | WS_SYSMENU | DS_SETFONT
    tpl.fontname = "MS Gothic"
    tpl.fontsize = 11
    tpl.caption="Preferences"
    stt=tpl.addDlgControl(VRStatic,"Glid Size",7,4,40,12)
    stt2=tpl.addDlgControl(VRStatic,"Editor",7,18,30,12)
    btok=tpl.addDlgControl(VRButton,"O   K",5,50,40,12)
    btcan=tpl.addDlgControl(VRButton,"CANSEL",50,50,40,12)
    btbrowse=tpl.addDlgControl(VRButton,"...",142,16,14,12)
    ed1=tpl.addDlgControl(VREdit,"8",50,2,20,12,0x0880000)
    ed2=tpl.addDlgControl(VREdit,"",40,16,100,12,0x0880000)
    st1=tpl.addDlgControl(VRStatic,"cygwin's line separator:",7,32,100,12)
    chb1=tpl.addDlgControl(VRCheckbox,"LF Only",110,30,50,12)
    @prdlg=PrDlg.new(VRLocalScreen,tpl)
    @prdlg.options ={"target"=>ed1,"target2"=>ed2,"okbutton"=>btok,
      "cancelbutton"=>btcan,"browsebutton"=>btbrowse,"checkbox"=>chb1,
      "default"=>"8","default2"=>"notepad.exe","check"=>false}
  end
  
  def examindlgcreate
    tpl = VRDialogTemplate.new
    tpl.style = WS_CAPTION | WS_SYSMENU | DS_MODALFRAME | DS_SETFONT
    tpl.fontname = "MS Gothic"
    tpl.fontsize = 10
    tpl.caption="Examine"
    btok = tpl.addDlgControl(VRButton,"O   K",140,204,40,12,0x00010000)
    ed1 = tpl.addDlgControl(VRText,"",6,4,320,200,0x00200840)
    @examinedlg=ExamineModalDlg.new(@screen,tpl)
    @examinedlg.options ={"target"=>ed1,"okbutton"=>btok,"default" => [["",0]]}
  end
  

  def construct
    $modified = 0
    @shellExecute = Win32API.new('shell32','ShellExecute','LPPPPI','L')
    @isWindow = Win32API.new('user32','IsWindow','L','L')
    @getForegroundWindow = Win32API.new('user32','GetForegroundWindow','V','L')
    @setForegroundWindow = Win32API.new('user32','SetForegroundWindow','L','L')
    @setActiveWindow = Win32API.new('user32','SetActiveWindow','L','L')
    @destroyWindow = Win32API.new('user32','DestroyWindow','L','L')
    $main=self
    $ini=Inifile.new("fd.ini")
    top=$ini.read("mainform","top",0).to_i
    left=$ini.read("mainform","left",0).to_i
    $editor=$ini.read("settings","editor","notepad.exe")
    if RUBY_PLATFORM =~ /^\w+-cygwin/ && $ini.read("settings",'LFOnly','false')=='false' then
      $n="\r\n"
    else
      $n="\n"
    end
    preferdlgcreate
    examindlgcreate
    @inspectfrm=@screen.newform(self)
    @inspectfrm.extend FDInspect
    @inspectfrm.move left,top+124,140,400
    @inspectfrm.caption="Inspect"
    @inspectfrm.create.show
    new_designfrm
    $tooltip = createTooltip
    # Create Pallets
    addControl FDTabbedPanel,"tab","tab",0,0,self.clientrect[2],58
    @tab.setFont $SysFont
    $conf.each{|i| @tab.addPanel(i)}

    # Set Menu
    @amenu=newMenu(true).set([["&Delete","doDelete"],VRMenu::SEPARATOR,
                                ["&Copy\tCtrl+C","doCopy"],["&Paste\tCtrl+V","doPaste"]])
    setMenu newMenu.set([
                ["&File",   [ ["&NewForm\tCtrl+N","new"],
                              ["&OpenForm\tCtrl+O","open"],
                              ["&SaveForm\tCtrl+S","save"],
                              ["SaveForm&As","saveas"],
                              VRMenu::SEPARATOR,
                              ["Save&ProjectAs","saveProjectAs"],
                              ["&EditProject\tCtrl+E","run_editor"],
                              ["&UpdateProject\tCtrl+U","update_proj"],
                              VRMenu::SEPARATOR,
                              ["E&xit\tAlt+F4","exit"]]],
                ["&Edit",   [ ["&Delete\tDelete","doDelete"],
                              ["Cu&t","cut"],
                              ["&Copy","copy"],
                              ["&Paste","paste"]]],
                ["&Window", [ ["&Form","formShow",VRMenuItem::CHECKED],
                              ["&Inspect","inspectShow",VRMenuItem::CHECKED]]],
                ["&Run",    [ ["E&xecute\tF5","execute"],
                              ["Examine","examine"]]],
                ["&Option", [ ["&Preference","prefer"],
                              VRMenu::SEPARATOR,
                              ["Grid","gridState",VRMenuItem::CHECKED]]],
                ["&Tool",   [ ["Bmp2Str","bmp2str"]]],
                ["&Help",   [ ["Versio&n","version"]]]
                  ]) ,true
    SWin::Application.setAccel(@designfrm,self)
    SWin::Application.setAccel(@inspectfrm,self)
    @sb1=addStatusbar
    self.move left,top,640,124
    @running = false
    @hwndEd = 0
  end

  def new_designfrm
    $modified = 0
    top=$ini.read("mainform","top",0).to_i
    left=$ini.read("mainform","left",0).to_i
    remove_instance_variable(:@designfrm) if defined?(@designfrm)
    @designfrm = @screen.newform(self,nil,DesignForm)
    @designfrm.extend FDControlDesign
    @designfrm.createinit
    @designfrm.move left+140,top+124,500,400
    @designfrm.caption="form1"
    @designfrm.create.show
    self.caption = "FormDesigner"
    @hwndEd = 0
    @workingfile = nil
  end

  def setcontrol(ctrl)
    if @designfrm.creation=ctrl then
      @sb1.setTextOf(0,"choosed:[#{ctrl.info}]") if @sb1
    else
      @sb1.setTextOf(0,"no choice") if @sb1
    end
  end

  def new_clicked
    unless @designfrm.alive? then
      new_designfrm
      @formShow.checked = true
    end
    if $modified > 0 then
      do_new("New file")
    else
      @designfrm.close ; new_designfrm
    end
    #@hinstance = nil
  end

  def do_new(s)
    r = messageBox("Do you save this file?",s,0x0003)
    case r
    when 6
      if save_clicked then
        @designfrm.close ; new_designfrm
      end
    when 7
      @designfrm.close ;
       new_designfrm
    else
      r = nil
    end
    @hinstance=nil
    r
  end

  def open_clicked
    unless @designfrm.alive? then
      new_designfrm
      @formShow.checked = true
    end
    do_new("Open file") if @designfrm.controls != {}
    @workingfile=openFilenameDialog(
                      [["ruby forms","_frm_*.rb"],["ruby scripts","*.rb"]])
    if @designfrm.openfile(@workingfile) then
      self.caption = "FormDesigner - #{@workingfile}"
    else
      @workingfile = nil
    end
  end

  def save_clicked
    if @workingfile then
      save
    else
      saveas_clicked
    end
  end

  def saveas_clicked
    if r = saveFilenameDialog(["ruby forms","_frm_*.rb"]) then
      case r
      when/(.+)\\(.+)\.rb$/
        d = $1;e = $2
      when/(.+)\\(.+)$/
        d = $1;e = $2
      end
      e.sub!(/^_frm_/,'')
      @workingfile= d + '\\_frm_' +  e + '.rb'
      save
    end
    r
  end

  def saveProjectAs_clicked
    if r = saveFilenameDialog(["ruby scripts","*.rb"]) then
      case r
      when /(.+)\\(.+)\.rb$/
        d = $1;e = $2
      when /(.+)\\(.+)$/
        d = $1;e = $2
      end
      e.sub!(/^_frm_/,'')
      @workingfile= d + '\\_frm_' +  e + '.rb'
      save
      saveProject(d + '\\' + e + '.rb')
    end
  end

  def self_activateapp(wParam,hwnd)
    if LOWORD(wParam) == 1 then
      if @workingfile then
        r = checkTstamp($tstamp)
      end

      if r then
        rr=messageBox "This working file was modifyed by other apprication."+
         "\r\nDo you read new file?","Working file was modifyed" ,0x0003
        case rr
        when 6
          $modified = 0
          wf = @workingfile ; ed = @hwndEd
          @designfrm.close
          new_designfrm
          @workingfile = wf ; @hwndEd =ed
          @designfrm.openfile(@workingfile)
          self.caption = "FormDesigner - #{@workingfile}"
        else
          $tstamp=File.stat(@workingfile).mtime.to_i
        end

      end
    else

      if @editorStarting then
        @hwndEd = 0
        @hwndEd = @getForegroundWindow.call until @hwndEd > 0
      end
      @editorStarting = false
    end
  end

  def checkTstamp(time)
    File.stat(@workingfile).mtime.to_i > $tstamp
  end

  def save1
    #b = @workingfile.sub( /.+\\(.+)\.rb/ ,'\1')
    s=@designfrm.make_executive
    open(@workingfile,"w") {|f|
      $tstamp=f.stat.mtime.to_i
      f.write s
    }
    $modified = 0
  end

  def save
    save1
    @sb1.caption = @workingfile + " saved"
    self.caption = "FormDesigner - #{@workingfile}"
    @designfrm.refreshInspect(nil)
  end

  def get_parents_str(c)
    return "" if c.is_a? VRForm
    s = "_#{c.name}"
    s[0,0] = get_parents_str(c.parent) unless c.parent.is_a? VRForm
    s
  end

  def makeContainerInProject(cnt)
    s = ""
    unless cnt.is_a? VRForm
      ps = get_parents_str(cnt.parent)
      s = "module Cntn#{ps}_#{cnt.name}#{$n}#{$n}end#{$n}#{$n}"
    end
    cnt.controls.each{|i,c|
      s += makeContainerInProject(c) if c.respond_to? :addControl
    }
    s
  end

  def makeExtnsionInProject(c_parent)
    s = ""
    c_parent.controls.each{|i,c|
      if c.respond_to? :addControl then
        s += makeExtnsionInProject(c)
      else
       ps = get_parents_str(c_parent)
       s += "module Extn#{ps}_#{c.name}#{$n}#{$n}end#{$n}#{$n}" unless c.is_a?(FDCoverPanel) || c.modules.empty?
      end
    }
    s
  end

  def saveProject(filepath)
    s = filepath.sub( /.+\\(.+\.rb$)/ ,'\1')
    ss = "#! ruby -Ks" + $n
    ss += "require \'vr/vruby\'" + $n
    ss += "require \'_frm_#{s}\'" + $n*2
    ss += makeExtnsionInProject(@designfrm)
    ss += makeContainerInProject(@designfrm)
    ss += "module Frm_#{@designfrm.name}" + $n
    ss += "  def self_created#{$n}    " + $n
    ss += "  end" + $n*2
    ss += "end" + $n*2
    ss += "VRLocalScreen.start Frm_#{@designfrm.name}" + $n
    open(filepath,"w") {|f| f.write ss}
  end

  def run_editor_clicked
    unless @workingfile then
      unless saveas_clicked then return end
    else
      save1 if $modified > 0
    end
    ed = @isWindow.call(@hwndEd) if @hwndEd
    if ! ed || ed == 0  then
      fpath = @workingfile.sub(/_frm_(.+\.rb)/,"")+$1
      saveProject(fpath) unless File.exist?(fpath)
      @hinstance = @shellExecute.call(0,"open",$editor, fpath, nil,1)
      @editorStarting = true
    else
      @setForegroundWindow.call(@hwndEd)
    end
  end

  def getModulesSet(cnt)
    st = Set[]
    unless cnt.is_a? VRForm
      ps = get_parents_str(cnt)
      st << "Cntn#{ps}"
      st << "Extn#{ps}_#{cnt.name}" unless cnt.modules.empty?
    end
    cnt.controls.each{|i,c|
      if c.respond_to? :addControl then
        st = st + getModulesSet(c)
      end
      st << "Extn#{ps}_#{c.name}" unless c.is_a?(FDCoverPanel) || c.modules.empty?
    }
    st
  end

  def update_proj_clicked
    n=messageBox "Have you saved Project from Editor?","Updating Project #{@workingfile}",0x31
    return if n > 1
    unless @workingfile then
      unless saveas_clicked then return end
    else
      save1 if $modified > 0
    end
    fpath = @workingfile.sub(/_frm_(.+\.rb)/,'\1')#+$1
    if  File.exist?(fpath) then
      sa = []
      open(fpath,'r'){|f| sa = f.read.split(/\n|\r\n/)}
      lin_start=sa.each_with_index{|s,i| break(i) if s =~ /^\s*module/ }
      unless lin_start.is_a? Integer then
        messageBox "'#{fpath}' is not a  project file of FormDesigner.",
                                           "Prolect file reading error",16
        return
      end
      sa2=sa.grep(/^\s*module\s+(Cntn|Extn)_\w+/){|i| i.match(/module\s+(\w+)/);$1}
      ss1 = Set.new(sa2)
      ss2 = getModulesSet(@designfrm)
      a2 = []
      ss2.subtract(ss1).each{|i| a2 << "module #{i}#{$n}#{$n}end#{$n}" }
      sa[lin_start,0] = a2 unless a2.empty?
      open(fpath,'w'){|f| f.write sa.flatten.join($n) }
      show_editor
    else
      saveProject(fpath)
      show_editor
    end
  end

  def show_editor
    ed = @isWindow.call(@hwndEd) if @hwndEd
    @setForegroundWindow.call(@hwndEd) if ed && (ed != 0)
  end

  def exit_clicked
    if $modified > 0 then
     n = messageBox("Do you save this file?","558 Close FormDesigner",0x3)
     case n
     when 6
       save_clicked
     when 2
       return
     when 7
       $modified = 0
     end
    end
    self.close
  end

  def doDelete_clicked
    @designfrm.deleteCont
  end

  def setFont_clicked
    @designfrm.ctrl_setFont
  end

  def setWinStyle_clicked
    @designfrm.setWinStyle
  end

  def setWSArray(style)
    a=[] ;s1 =$Style[:win].keys.dup
    s1.each{|i| s = i.dup ;
      a << [s.to_s,((($Style[:win])[i] & style) == 0 ? 0 : 1)]
    }
    a.sort
  end

  def wsArrat2int(a)
    r =0
    a.each{|i|
      r = r | $Style[:win][i[0]]*i[1]
    }
    r
  end

  def examine_clicked
    @examinedlg.options["default"] = @designfrm.make_executive.gsub(/\n/,"\r\n")
    @examinedlg.move 20,20,328,220
    @examinedlg.open(@designfrm)
  end

  def execute_clicked
    unless @running then
      @running=true
      @designfrm.visible = false
      @inspectfrm.visible = false
      s = @designfrm.make_executive
      s.gsub!(/(^module +Frm_\w+)/,'\1;include ExecuteDesignfrm;')
      s1 = $1.sub /^module +/,''
      s << "\nVRLocalScreen.showForm #{s1}"
      eval s
    end
  end

  def exitExec
    @running=false
    @designfrm.visible = true if @designfrm.alive?
    @inspectfrm.visible = true if @inspectfrm.alive?
  end

  def formShow_clicked
    unless @designfrm.alive? then
      new_designfrm
      @formShow.checked = true ; return
    end
    if @designfrm.visible? then
      @formShow.checked = @designfrm.visible = false
    else
      @formShow.checked = @designfrm.visible = true
    end
  end

  def inspectShow_clicked
    unless @inspectfrm.alive? then
      t=$ini.read("inspect","top",0).to_i
      l=$ini.read("inspect","left",0).to_i
      h=$ini.read("inspect","height",400).to_i
      w=$ini.read("inspect","width",140).to_i
      @inspectfrm.move(l,t,w,h)
      @inspectfrm.create.show
      @designfrm.refreshInspect(@designfrm.focused)
      @designfrm.refreshCntName
      @inspectShow.checked = true ; return
    end
    if @inspectfrm.visible? then
      @inspectShow.checked = @inspectfrm.visible = false
    else
      @inspectShow.checked = @inspectfrm.visible = true
    end
  end

  def prefer_clicked
    @prdlg.options["default"] = ($ini.read "settings","span",8)
    @prdlg.options["default2"] = ($ini.read "settings","editor","notepad.exe")
    @prdlg.options["check"] = ($ini.read "settings","LFOnly",'false')=='false' ? false : true
    @prdlg.move 20,20,160,65
    if a1 = @prdlg.open(@designfrm) then
        g=a1[0].to_i
      if 1 < g  && g < 100  then
        $ini.write("settings","span",@designfrm.span=g)
        @designfrm.refresh
      else
        messageBox "Grid span must be in 2 to 100" ,"Warning!!",16
      end
      $editor = a1[1]
      $ini.write("settings","editor",$editor)
      $n = RUBY_PLATFORM =~ /\w+-cygwin/ && !a1[2] ? "\r\n" : "\n"
      $ini.write("settings","LFOnly",a1[2])
    end
  end

  def version_clicked
    @designfrm.messageBox "FormDesigner for VisualuRuby Ver "+$Ver.to_s+
                "\n\nWritten by yukimi_sake@mbi.nifty.com"+
                "\n\nBasic designed by nyasu@osk.3web.ne.jp","Version"
  end

  def gridState_clicked
    if @designfrm.enableGrid then
      @gridState.checked = @designfrm.enableGrid = false
    else
      @gridState.checked = @designfrm.enableGrid = true
    end
    @designfrm.refresh
  end

  def self_resize(w,h)
    @tab.move 0,0,w,58
  end

  def bmp2str_clicked
    str=""
    fi=[]
    if fi=openFilenameDialog([["bitmaps","*.bmp"]]) then
      fi.each do |f|
        bmp = SWin::Bitmap.loadFile(fi)
        str = bmp.dumpString
      end
      clb1=Clipboard.open(self.hWnd)
      clb1.setText(str)
      clb1.close
      @designfrm.messageBox "Base64 string was copied into clipboard"
    end
  end

  def self_close
    if $modified > 0 then
      n = messageBox("Do you save this file?","654 Close FormDesigner",0x3)
      case n
      when 6
        save_clicked
      when 2
        SKIP_DEFAULTHANDLER
      when 7
        $modified = 0
      end
    end
 end

  def self_destroy
    $subwnd.close if $subwnd && $subwnd.alive?
    a=windowrect
    $ini.write "mainform","left",a[0]
    $ini.write "mainform","top",a[1]
    $ini.write "mainform","width",a[2]
    $ini.write "mainform","height",a[3]
    @controls.clear
    $ini.flash
  end
end
