# Sample for customising of FormDesigner

require 'vr/vrcontrol'
require 'vr/vrcomctl'

class UpDownEdit < VREdit
  
  UDS_AUTOBUDDY   = 0x10
  UDS_SETBUDDYINT = 0x2
  UDS_ALIGNRIGHT  = 0x4
  UDS_ALIGNLEFT   = 0x8
  
  ES_RIGHT        = 0x2
  ES_NUMBER       = 0x2000
  
  def vrinit
    super
    @ud.extend IgnoreFormDesigner if defined? FDControlDesign 
  end
  
  def setRange(l, u)
    @ud.setRange(l, u)
  end
  
  def getRange
    @ud.getRange
  end
  
  def uLimit() getRange[1] end
  def lLimit() getRange[0] end
  def uLimit=(u)  l0, u0 = *getRange; setRange(u, l0) end
  def lLimit=(l)  l0, u0 = *getRange; setRange(u0, l) end
    
  if defined? FDControlDesign
    def terminate
      parent.deleteControl @ud
    end
  end
  
end

class UpDownEditR < UpDownEdit
  WINCLASSINFO = ["EDIT", WStyle::ES_AUTOHSCROLL | ES_NUMBER | ES_RIGHT,
                                                     WExStyle::WS_EX_CLIENTEDGE]
  def vrinit
    @ud = parent.addControl VRUpdown,name+'_updn', '', x-16,y, 16, h,
                               UDS_ALIGNRIGHT |  UDS_AUTOBUDDY | UDS_SETBUDDYINT
    super
  end
  
  def windowrect
    x, y, w, h = super
    [x, y, w + @ud.w, h]
  end
  
  alias org_move move
  def move(x, y, w, h)
    if @ud
      org_move(x,y,w-@ud.w,h) 
      @ud.move(x+w-@ud.w, y, @ud.w, h)
    else
      org_move(x, y, w, h)
    end
  end
end

class UpDownEditL < UpDownEdit
  WINCLASSINFO = ["EDIT", WStyle::ES_AUTOHSCROLL | ES_NUMBER,
                                                     WExStyle::WS_EX_CLIENTEDGE]
  def vrinit
    @ud = parent.addControl VRUpdown,name+'_updn', '', x-16,y, 16, h,
                               UDS_ALIGNLEFT |  UDS_AUTOBUDDY | UDS_SETBUDDYINT
    super
  end
  
  def windowrect
    x, y, w, h = super
    [x-@ud.w, y, w + @ud.w, h]
  end
  
  alias org_move move
  def move(x, y, w, h)
    if @ud
      org_move(x+@ud.w, y, w-@ud.w, h) 
      @ud.move(x, y, @ud.w, h)
    else
      org_move(x, y, w, h)
    end
  end
end


if  $0 == __FILE__
  require 'vr/vruby'
  require 'vr/vrcomctl'

  class Form1 < VRForm
    def construct
      self.caption = 'form1'
      self.move(140,124,500,400)
      addControl UpDownEditL, 'ude1', '0', 20, 10, 100, 22
      addControl UpDownEditR, 'ude2', '0', 20, 40, 100, 22
      @ude1.setRange 0, 10
      @ude2.setRange 0, 10
    end 
  end
  
  VRLocalScreen.start Form1
end