require 'fdvr/fdmodules'
require 'fdvr/fdresources'
require 'fdvr/fdmodules'

class Hash
  def << (h) self.update h end

  def + (h) r = self.clone; r.update h end
end


module FDControls
  include FDBmps
  include FDItems
  include FDFakeClass
  include FDModules

  FDStruct=Struct.new :klass,:inst,:dflt_w,:dflt_h,:style,:required,:included,
                      :createMethod,:info,:attrs,:events,:mthds,:mods,:popups,:items,:bmp
  FDPallet = Struct.new(:title,:items)
      # Description of attribute metohd definition
  def controls_init
    @prStyle = Proc.new{|c|"0x"+sprintf("%8X",c.style)}
    @prFont = Proc.new{|c| getFontName(c)}
    @prArray = Proc.new{|c| 'click ->'}
    @prMenuItem = Proc.new{|c| 'click ->'}
    @prModule = Proc.new{|c| 'click ->'}
    @prAccel = Proc.new{|c| if c.getaccel then 'true' else 'false' end}

[
  FDPallet["Standard",[
  #klass,inst,dflt_w,dflt_h,style,required,included,createMethod,info,container
    FDStruct[VRButton,"button",80,24,0,"vrcontrol",nil,:newFDCtrl,"Button",
      ["name","caption","x","y","w","h",["font",@prFont,:btFont],
              ["style",@prStyle,:btStyle],["modules",@prModule,:btModule]], #attrs
      ["clicked","dblclicked"], #events
      [

      ],#mthds
      StdModules,#mods
      [["font","setfont"],["color","setcolor"]],#popups
      nil,#items
      BmpButton
    ],
    FDStruct[VREdit,"edit",120,20,0,"vrcontrol",nil,:newFDCtrl,"Edit",
      ["name","caption","x","y","w","h",["font",@prFont,:btFont],
                  ["style",@prStyle,:btStyle],["modules",@prModule,:btModule]], #attrs
      ["changed"], #events
      [
        "text", "text=(str)","getSel","setSel(st,en,noscroll=0)","setCaret(r)",
        "replaceSel(newstr)","readonly=(b)","limit","modified","modified=(f)",
        "cut","copy","paste","clear","undo"
      ],#mthds
      StdModules,#mods
      [["font","setfont"],["color","setcolor"]],#popups
      nil,#items
      BmpEdit
    ],
    FDStruct[VRText,"text",120,100,0,"vrcontrol",nil,:newFDCtrl,"Text",
      ["name","caption","x","y","w","h",["font",@prFont,:btFont],
                    ["style",@prStyle,:btStyle],["modules",@prModule,:btModule]], #attrs
      ["changed"], #events
      [
        "text", "text=(str)","getSel","setSel(st,en,noscroll=0)","setCaret(r)",
        "replaceSel(newstr)","readonly=(b)","limit","modified","modified=(f)",
        "cut","copy","paste","clear","undo"
      ],#mthds
      StdModules,#mods
      [["font","setfont"],["color","setcolor"]],#popups
      nil,#items
      BmpText
    ],
    FDStruct[VRCheckbox,"checkBox",96,24,0,"vrcontrol",nil,:newFDCtrl,"CheckBox",
      ["name","caption","x","y","w","h",["font",@prFont,:btFont],
                    ["style",@prStyle,:btStyle],["modules",@prModule,:btModule]], #attrs
      ["clicked","dblclicked"], #events
      ["checked?", "check(v)"],#mthds
      StdModules,#mods
      [["font","setfont"],["color","setcolor"]],#popups
      nil,#items
      BmpCheckbox
    ],
    FDStruct[VRRadiobutton,"radioBtn",96,24,0,"vrcontrol",nil,:newFDCtrl,"RadioButton",
      ["name","caption","x","y","w","h",["font",@prFont,:btFont],
                    ["style",@prStyle,:btStyle],["modules",@prModule,:btModule]], #attrs
      ["clicked","dblclicked"], #events
      ["checked?", "check(v)"],#mthds
      StdModules,#mods
      [["font","setfont"],["color","setcolor"]],#popups
      nil,#items
      BmpRadiobutton
    ],
    FDStruct[VRStatic,"static",96,24,0,"vrcontrol",nil,:newFDCtrl,"StaticText",
      ["name","caption","x","y","w","h",["font",@prFont,:btFont],
                    ["style",@prStyle,:btStyle],["modules",@prModule,:btModule]], #attrs
      [], #events
      [],#mthds
      StdModules,#mods
      [["font","setfont"],["color","setcolor"]],#popups
      nil,#items
      BmpStatic
    ],
    FDStruct[VRListbox,"listBox",120,120,0,"vrcontrol",nil,:newFDCtrl,"ListBox",
      ["name","caption","x","y","w","h",["font",@prFont,:btFont],
                    ["style",@prStyle,:btStyle],["modules",@prModule,:btModule]], #attrs
      ["selchanged"], #events
      ["addString(idx,str)","deleteString(idx)","countStrings","clearStrings",
        "eachString{|i|}","setListStrings(strarray)","selectedString","select(idx)",
        "getTextOf(idx)","setDir(fname,opt=0)","findString(findstr,start=0)","getDataOf(idx)",
        "setDataOf(idx,data)"],#mthds
      StdModules,#mods
      [["font","setfont"],["color","setcolor"]],#popups
      nil,#items
      BmpListbox
    ],
    FDStruct[VRCombobox,"comboBox",120,80,0,"vrcontrol",nil,:newFDCtrl,"ComboBox",
      ["name","caption","x","y","w","h",["font",@prFont,:btFont],
                    ["style",@prStyle,:btStyle],["modules",@prModule,:btModule]], #attrs
      ["selchanged"], #events
      ["addString(idx,str)","deleteString(idx)","countStrings","clearStrings",
        "eachString{|i|}","setListStrings(strarray)","selectedString","select(idx)",
        "getTextOf(idx)","setDir(fname,opt=0)","findString(findstr,start=0)","getDataOf(idx)",
        "setDataOf(idx,data)"],#mthds
      StdModules,#mods
      [["font","setfont"],["color","setcolor"]],#popups
      nil,#items
      BmpCombobox
    ],
    FDStruct[VRGroupbox,"groupBox",120,120,0,"vrcontrol",nil,:newFDCtrl,"GroupBox",
      ["name","caption","x","y","w","h",["font",@prFont,:btFont],
                  ["style",@prStyle,:btStyle],["modules",@prModule,:btModule]], #attrs
      [], #events
      [],#mthds
      StdModules,#mods
      [["font","setfont"],["color","setcolor"]],#popups
      nil,#items
      BmpGroupbox
    ],
    FDStruct[VRPanel,"panel",120,120,0,"vrcontrol",nil,:newFDCtrl,"Panel",
      ["name","caption","x","y","w","h",["font",@prFont,:btFont],
                  ["style",@prStyle,:btStyle],["modules",@prModule,:btModule]], #attrs
      [], #events
      [],#mthds
      StdModules,#mods
      [["font","setfont"],["color","setcolor"]],#popups
      nil,#items
      BmpPanel
    ],
    FDStruct[VRCanvasPanel,"canvaspanel",120,120,0,"vrcontrol",nil,:newFDCtrl,"CanvasPanel",
      ["name","caption","x","y","w","h",["font",@prFont,:btFont],
                  ["style",@prStyle,:btStyle],["modules",@prModule,:btModule]], #attrs
      [], #events
      ["createCanvas(w,h,color=0xffffff)","canvas"],#mthds
      StdModules,#mods
      [["font","setfont"],["color","setcolor"]],#popups
      nil,#items
      BmpCanvasPanel
    ],
    FDStruct[VRBitmapPanel,"bmppanel",120,120,0,"vrcontrol",nil,:newFDCtrl,"BmpPanel",
      ["name","caption","x","y","w","h",["font",@prFont,:btFont],
                  ["style",@prStyle,:btStyle],["modules",@prModule,:btModule]], #attrs
      [], #events
      ["loadFile(filename)", "createBitmap(info,bmp)" ,"bmp"],#mthds
      StdModules,#mods
      [["font","setfont"],["color","setcolor"]],#popups
      nil,#items
      BmpBitmapPanel
    ]
  ]],
  FDPallet["Additonal",[
    FDStruct[VRRichedit,"richEdit",150,150,0,"vrrichedit",nil,:newFDCtrl,"RichEdit",
      ["name","caption","x","y","w","h",["font",@prFont,:btFont],
                         ["style",@prStyle,:btStyle],["modules",@prModule,:btModule]],
      ["changed"],
      [
        "text",
        "text=(str)",
        "getSel",
        "setSel(st,en,noscroll=0)",
        "setCaret(r)",
        "replaceSel(newstr)",
        "readonly=(b)",
        "limit",
        "modified",
        "modified=(f)",
        "cut",
        "copy",
        "paste",
        "clear",
        "undo",
        "char2line(ptr)",
        "setTextFont(fontface,height=280,area=SCF_SELECTION)",
        "getTextFont(selarea=true)",
        "setTextColor(col,area=SCF_SELECTION)",
        "getTextColor(selarea=true)",
        "setBold(flag=true,area=SCF_SELECTION)",
        "setItalic(flag=true,area=SCF_SELECTION)",
        "setUnderlined(flag=true,area=SCF_SELECTION)",
        "setStriked(flag=true,area=SCF_SELECTION)",
        "bold?(selarea=true)",
        "italic?(selarea=true)",
        "underlined?(selarea=true)",
        "striked?(selarea=true)",
        "setAlignment(align)",
        "bkcolor=(color)",
        "selformat(area=SCF_SELECTION)",
        "selformat=(format)"
      ],#mthds
      StdModules,#mods
      [["font","setfont"]],#popups
      nil,#items
      BmpRichedit
    ],
    FDStruct[VRToolbar,"toolBar",150,26,0,"vrcomctl",VRToolbarUseable,:newFDToolbar,"Toolbar",
      ["name","caption","x","y","w","h",["font",@prFont,:btFont],
                                    ["style",@prStyle,:btStyle],["buttons",@prArray,:btArray]],
      nil, #events
      [
        "insertButton(i,name,style=TBSTYLE_BUTTON)",
        "addButton(style)",
        "deleteButton(i)",
        "clearButtons",
        "countButtons",
        "setImagelist(imglist)",
        "setParent(hwnd)",
        "autoSize",
        "indeterminateOf(i,bool=true)",
        "commandToIndex(id)",
        "enableButton(i,bool=true)",
        "getButtonStateOf(id)",
        "setButtonStateOf(i,state)",
        "setButtons(buttons)",
        "enumButtons"
      ],#mthds
      StdModules,#mods
      [["font","setfont"]],#popups
      FDItems::FDToolbarTemplate,#items
      BmpToolbar
    ],
    FDStruct[VRRebar,"rebar",150,32,0,"vrcomctl",nil,:newFDRebar,"Rebar",
      ["name","caption","x","y","w","h",["font",@prFont,:btFont],
                            ["style",@prStyle,:btStyle],["bands",@prArray,:btArray]], #attrs
      [], #events
      [
        "insertband(cntl,txt,minx=30,miny=cnt.h+2,band=-1)",
        "bkColor=(c)",
        "bkColor",
        "textColor=(c)",
        "textColor",
        "relayout(x=self.x, y=self.y, w=self.w, h=self.h)"
      ],#mthds
      StdModules,#mods
      [["font","setfont"],["color","setcolor"]],#popups
      nil,#items
      BmpRebar
    ],
    FDStruct[VRListview,"listView",120,120,0,"vrcomctl",nil,:newFDListview,"Listview",
      ["name","caption","x","y","w","h",
                                   ["font",@prFont,:btFont],["style",@prStyle,:btStyle]],#attrs
      ["itemchanged(idx,state)","itemchanging(idx,state)","columnclick(subitem)",
        "begindrag","beginrdrag"], #events
      [
        "setViewMode(mode)",
        "getViewMode",
        "iconview",
        "reportview",
        "smalliconview",
        "listview",
        "setBkColor(color)",
        "bkcolor=(color)",
        "lvexstyle",
        "lvexstyle=(style)",
        "setListviewExStyle(style,mask=0xffffffff)",
        "insertColumn(column,text,width=50,format=0,textsize=title.size)",
        "deleteColumn(column)",
        "clearColumns",
        "countColumns",
        "addColumn(text,width=50,format=0,textsize=title.size)",
        "setImagelist(imagelist,itype=0)",
        "setItemIconOf(hitem,img)",
        "getItemIconOf(hitem)",
        "getColumnWidthOf(column)",
        "setColumnWidthOf(column,width)",
        "getColumnTextOf(column)",
        "setColumnTextOf(column,text)",
        "getColumnFormatOf(column)",
        "setColumnFormatOf(column,format)",
        "insertItem(index,texts,lparam=0,textsize=128)",
        "addItem(texts,lparam=0,textsize=128)",
        "insertMultiItems(index,multitexts)",
        "deleteItem(idx)",
        "clearItems" ,
        "countItems",
        "hittest(x,y)",
        "hittest2(x,y)",
        "getItemRect(idx)",
        "getItemStateOf(idx)",
        "setItemStateOf(idx,state)",
        "selectItem(idx,flag) ",
        "getNextItem(start,flags)",
        "focusedItem",
        "getItemTextOf(idx,subitem=0,textsize=128)",
        "setItemTextOf(idx,subitem,text,textsize=text.size)",
        "getItemLParamOf(idx)",
        "setItemLParamOf(idx,lparam)",
        "selected?(idx)",
        "focused?(idx)",
        "eachSelectedItems",
        "countSelectedItems()",
        "ensureVisible(i,partial=true)",
      ],#mthds
      StdModules,#mods
      [["font","setfont"]],#popups
      nil,#items
      BmpListview
    ],
    FDStruct[VRTreeview,"treeView",120,120,0,"vrcomctl",nil,:newFDCtrl,"Treeview",
      ["name","caption","x","y","w","h",["font",@prFont,:btFont],
                         ["style",@prStyle,:btStyle],["modules",@prModule,:btModule]],
      [
        "selchanged(hitem,lparam)",
        "itemexpanded(hitem,state,lparam)",
        "deleteitem(hitem,lparam)",
        "begindrag(hitem,state,lparam)",
        "beginrdrag(hitem,state,lparam)"
      ],#events
      [
        "insertItem(hparent,hafter,text,lparam=0,textsize=text.size)",
        "insertMultiItems(hparent,hafter,items)",
        "addItem(hparent,text,lparam=0,textsize=text.size)",
        "addMultiItems(hparent,items)",
        "deleteItem(hitem)",
        "clearItems",
        "countItems",
        "selectItem(hitem)",
        "indent",
        "indent=",
        "hittest(x,y)",
        "hittest2(x,y)",
        "getNextItem(hitem,code)",
        "topItem",
        "root",
        "last",
        "selectedItem()",
        "getParentOf(hitem)",
        "getChildOf(hitem)",
        "getNextSiblingOf(hitem)",
        "setImagelist(imagelist)",
        "setItemIconOf(hitem,img,simg)",
        "getItemIconOf(hitem)",
        "setItemLParamOf(hitem,lparam)",
        "getItemLParamOf(hitem)",
        "setItemTextOf(hitem,text)",
        "getItemTextOf(hitem,textsize=128)",
        "setItemStateOf(hitem,state)",
        "getItemStateOf(hitem)"
      ],#mthds
      StdModules,#mods
      [["font","setfont"]],#popups
      nil,#items
      BmpTreeview
    ],
    FDStruct[VRProgressbar,"prgrssBar",120,20,0,"vrcomctl",nil,:newFDCtrl,"Progressbar",
      ["name","caption","x","y","w","h",["font",@prFont,:btFont],
                  ["style",@prStyle,:btStyle],["modules",@prModule,:btModule]], #attrs
      [], #events
      [
      "setRange(minr,maxr)","position","position=(pos)","stepwidth=(st)","step","advance(n=1)"
      ],#mthds
      StdModules,#mods
      [["font","setfont"],["color","setcolor"]],#popups
      nil,#items
      BmpProgressbar
    ],
    FDStruct[VRTrackbar,"trackBar",120,25,0,"vrcomctl",nil,:newFDCtrl,"Trackbar",
      ["name","caption","x","y","w","h",["font",@prFont,:btFont],
                  ["style",@prStyle,:btStyle],["modules",@prModule,:btModule]], #attrs
      [], #events
      [
        "position",
        "position=(pos)",
        "linesize",
        "linesize=(s)",
        "pagesize",
        "pagesize=(p)",
        "rangeMin",
        "rangeMin=(m)",
        "rangeMax",
        "rangeMax=(m)",
        "selStart",
        "selStart=(m)",
        "selEnd",
        "selEnd=(m)",
        "clearSel",
      ],#mthds
      StdModules,#mods
      [["font","setfont"],["color","setcolor"]],#popups
      nil,#items
      BmpTrackbar
    ],
    FDStruct[VRUpdown,"updown",25,16,0,"vrcomctl",nil,:newFDCtrl,"Updown",
      ["name","caption","x","y","w","h",["font",@prFont,:btFont],
                  ["style",@prStyle,:btStyle],["modules",@prModule,:btModule]], #attrs
      ["changed(pos)"], #events
      [
        "setRange(minr,maxr)",
        "getRange",
        "position",
        "position=",
        "base",
        "base=(b)",
      ],#mthds
      StdModules,#mods
      [["font","setfont"],["color","setcolor"]],#popups
      nil,#items
      BmpUpdown
    ],
    FDStruct[VRStatusbar,"statusbar",120,25,0,"vrcomctl",nil,:newFDCtrl,"Statusbar",
      ["name","caption","x","y","w","h",["font",@prFont,:btFont],
                  ["style",@prStyle,:btStyle],["modules",@prModule,:btModule]], #attrs
      [], #events
      [
        "setparts(p,width=[-1])",
        "parts",
        "getTextOf(idx)",
        "setTextOf(idx,text,style=0)",
        "getRectOf(idx)",
        "minheight=(minh)"
      ],#mthds
      StdModules,#mods
      [["font","setfont"],["color","setcolor"]],#popups
      nil,#items
      BmpStatusbar
    ],
    FDStruct[VRTabControl,"tabControl",140,45,0,"vrcomctl",nil,:newFDCtrl,"TabControl",
      ["name","caption","x","y","w","h",["font",@prFont,:btFont],
                  ["style",@prStyle,:btStyle],["modules",@prModule,:btModule]], #attrs
      ["selchanged"], #events
      [
        "insertTab(index,text,textmax=text.size,lparam=0)",
        "clearTabs",
        "deleteTab(idx)",
        "countTabs",
        "selectedTab",
        "selectTab(idx)",
        "setImagelist(imagelist)",
        "setTabSize(width,height)",
        "getTabRect(i)",
        "adjustRect(x,y,w,h,flag=false)",
        "getTabTextOf(idx)",
        "setTabTextOf(idx,text)",
        "getTabImageOf(idx)",
        "setTabImageOf(idx,image)",
        "getTabLParamOf(idx)",
        "setTabLParamOf(idx,lparam)"
      ],#mthds
      StdModules,#mods
      [["font","setfont"],["color","setcolor"]],#popups
      nil,#items
      BmpTabControl
    ],
    FDStruct[VRTabbedPanel,"tabPanel",140,140,0,"vrcomctl",nil,:newFDTabbedPanel,"TabbedPanel",
      ["name","caption","x","y","w","h",["font",@prFont,:btFont],["style",@prStyle,:btStyle],
                  ["modules",@prModule,:btModule],["pages",@prArray,:btArray]], #attrs
      ["selchanged"], #events
      [
        "setupPanels(title-1,title-2,title-3,....)",
        "send_parent2(idx,controlname,eventname)",
        "panels",
        "insertTab(index,text,textmax=text.size,lparam=0)",
        "clearTabs",
        "deleteTab(idx)",
        "countTabs",
        "selectedTab",
        "selectTab(idx)",
        "setImagelist(imagelist)",
        "setTabSize(width,height)",
        "getTabRect(i)",
        "adjustRect(x,y,w,h,flag=false)",
        "getTabTextOf(idx)",
        "setTabTextOf(idx,text)",
        "getTabImageOf(idx)",
        "setTabImageOf(idx,image)",
        "getTabLParamOf(idx)",
        "setTabLParamOf(idx,lparam)"
      ],#mthds
      StdModules,#mods
      [["font","setfont"],["color","setcolor"]],#popups
      ['tab1','tab2'],#items
      BmpTabbedPanel
    ],
    FDStruct[VRMediaView,"mmedia",200,26,0,"vrmmedia",VRMediaViewModeNotifier,
                                                        :newFDListview,"MediaView,",
      ["name","caption","x","y","w","h",
                    ["style",@prStyle,:btStyle],["modules",@prModule,:btModule]], #attrs
      [
        "onerror()",
        "modechanged(newmode)",
        "sizechanged()",
        "mediachanged(str)",
      ], #events
      [
        "mediaopen(filename,flag=0)",
        "mediaclose",
        "mode",
        "modestring(n)",
        "errorstring",
        "play",
        "pause",
        "stop",
        "eject",
        "step(n=1)",
        "seek(pos)",
        "seekHome",
        "seekEnd",
        "playable?",
        "ejectable?",
        "window?",
        "length",
        "position",
        "volume",
        "volume=(vl)",
        "speed",
        "speed=",
        "zoom",
        "zoom="
      ],#mthds
      StdModules,#mods
      [],#popups
      nil,#items
      BmpMmedia
    ]
  ]],

  FDPallet["System" ,[
    FDStruct[VRMenu,"mainmenu",24,24,0,"vrcontrol","VRMenuUseable",:newFDMenu,"Menu",
      ["name","caption","x","y",["accel",@prAccel,:cbTF],["menus",@prMenuItem,:btArray]],
      nil,
      ["append(caption,state)",
       "insert(ptr,caption,state)",
       "delete(id)",
       "count",
       "set(sarr)"
      ],#mthds
      nil,#mods
      [["addItem","addItem"]],
      FDItems::FDMenuTemplate,#items
      BmpMenu
    ],
    FDStruct[FDPopup,"popupmenu",24,24,0,"vrcontrol","VRMenuUseable",:newFDPopup,"PopupMenu",
      ["name","caption","x","y",["menus",@prMenuItem,:btArray]],
      nil,
      ["showPopup(menu)",
       "append(caption,state)",
       "insert(ptr,caption,state)",
       "delete(id)",
       "count",
       "set(sarr)"
      ],#mthds
      nil,#mods
      [["addItem","addItem"]],
      FDItems::FDPopupMenuTemplate,#items
      #FDItems::FDMenuTemplate,#items
      BmpPopupMenu
    ],
    FDStruct[FDOpenDlg,"openDlg",24,24,0,nil,nil,:newFDOpenSaveDlg,"OpenDlg",
      ["name","caption","x","y",
        ["filters",@prArray,:btArray],["flags",@prArray,:btArray],"title","defaultExt"], #attrs
      [], #events
      ["openFilenameDialog(*arg)"],#mthds
      nil,#mods
      [],#popups
      nil,#items
      BmpOpenDlg
    ],
    FDStruct[FDSaveDlg,"saveDlg",24,24,0,nil,nil,:newFDOpenSaveDlg,"SaveDlg",
      ["name","caption","x","y",
        ["filters",@prArray,:btArray],["flags",@prArray,:btArray],"title","defaultExt"], #attrs
      [], #events
      ["saveFilenameDialog(*arg)"],#mthds
      nil,#mods
      [],#popups
      nil,#items
      BmpSaveDlg
    ],
    FDStruct[FDSelectDir,"selectDirectory",24,24,0,nil,nil,:newFDSelectDir,"SelectDirectory",
      ["name","caption","x","y","title","initialdir",["flags",@prArray,:btArray]], #attrs
      [], #events
      ["selectDirectory(*arg)"],#mthds
      nil,#mods
      [],#popups
      nil,#items
      BmpFolder
    ],
    FDStruct[FDFontDlg,"fontDlg",24,24,0,nil,nil,:newFDModule,"FontDlg",
      ["name","caption","x","y"], #attrs
      [], #events
      ["chooseFontDialog(*arg)"],#mthds
      nil,#mods
      [],#popups
      nil,#items
      BmpFontDlg
    ],
    FDStruct[FDColorDlg,"colorDlg",24,24,0,nil,nil,:newFDModule,"ColorDlg",
      ["name","caption","x","y"], #attrs
      [], #events
      ["chooseColorDialog(*arg)"],#mthds
      nil,#mods
      [],#popups
      nil,#items
      BmpColorDlg
    ]
  ]]
]
end
end
