#fdcfg.rb
# FormDesigner for Visualu Ruby Configuraton File

require 'fdvr/fdcontrols'
require 'fdvr/fddialogs'

class Array
  def format
    r = "[\n"
    self.each{|i|
      if i == self.last
        r += "  " + i.inspect + "\n"
      else
        r += "  " + i.inspect + ",\n"
      end
    }
    r += "]\n"
  end
end

class Integer
  def to_x
    sprintf "%#x" ,self
  end
end

class MenuStrMaker
  def _analize(ar,mn=nil)
    @ar += "  "*@n + "[\"#{mn}\",[\n" if mn
    ar.each{|i|
      if i[1].is_a? Array then
        @n += 1
        _analize(i[1],i[0])
        @ar[@ar.size-1,0]=','
      else
        @ar += "  "*(@n+1) + i.inspect + ",\n"
      end
    }
    @ar[@ar.size-2,1]="]"
    @ar += "  "*@n + "]\n"
    @n -= 1
  end
  
  def makeStr(ar)
    @ar="[\n"
    @n = 0
    _analize(ar)
    @ar[@ar.size-4,1]=''
    @ar
  end
end

module FDCommonMethod
  attr :controls

  def vrinit
    super
    @controls={}
  end

  def setcontrols(contorls)
    @controls = contorls
  end

  def checkfocus(x,y)
    p=[0,0,0x100000000,0x100000000]
    r = nil
    @controls.each { |i,c|
      unless c.is_a?(VRToolbar::VRToolbarButton) || c.is_a?(FDCoverPanel) || !c.visible? then
        if (c.x < x) && (c.x+c.w > x) &&
                (c.y < y ) && (c.y+c.h > y) then
          if p[0]<c.x || p[1]<c.y || p[2] >c.w || p[3]>c.h then
            p=[c.x,c.y,c.w,c.h]
            r=c
            if c && c.respond_to?(:addControl) && c.visible? then
              r1 = c.checkfocus(x-c.x,y-c.y)
              r=r1 if r1
            end
          end
        end
      end
    }
    r
  end

  def findCtrl(s)
    c=nil
    @controls.each { |id,item|
      if item.respond_to?(:addControl) then
       return c if c = item.findCtrl( s )
      end
      return item if item.name == s
    }
    c
  end

end


module WMsg
  RB_IDTOINDEX = WM_USER + 16
end

module FDDraggable
  include VRMessageHandler
  def draggable_init
    hookwndproc
    addHandler WMsg::WM_LBUTTONDOWN,"lbuttondown",MSGTYPE::ARGLINTINT,nil
    addHandler WMsg::WM_MOUSEMOVE,  "mousemove",MSGTYPE::ARGINTINTINT,nil
    addHandler WMsg::WM_LBUTTONUP,  "lbuttonup",  MSGTYPE::ARGLINTINT,nil
    addHandler WMsg::WM_RBUTTONUP,  "rbuttonup",  MSGTYPE::ARGINTSINTSINT,nil
    addHandler WMsg::WM_RBUTTONDOWN,"rbuttondown",MSGTYPE::ARGINTSINTSINT,nil
    addHandler WMsg::WM_SIZE, "resize",MSGTYPE::ARGLINTINT,nil
    acceptEvents [WMsg::WM_LBUTTONUP,WMsg::WM_RBUTTONUP,
                  WMsg::WM_LBUTTONDOWN,WMsg::WM_RBUTTONDOWN,
                  WMsg::WM_MOUSEMOVE,WMsg::WM_SIZE]

  end

  def self_lbuttondown(x,y)
    a=self.windowrect
    self.move(self.x,self.y,a[2],a[3])
    self.substance.move(self.x,self.y,a[2],a[3]) if self.is_a? FDCoverPanel
    @parent.send "self_lbuttondown",
               (x < 0xefff ? x+self.x : x+self.x-0x10000),
               (y < 0xefff ? y+self.y : y+self.y-0x10000)
  end

  def self_mousemove(shift,x,y)
    SWin::Application.doevents
    @parent.send :self_mousemove,shift,
               (x < 0xefff ? x+self.x : x+self.x-0x10000),
               (y < 0xefff ? y+self.y : y+self.y-0x10000)
  end

  def self_lbuttonup(x,y)
    a=self.windowrect
    self.move(self.x,self.y,a[2],a[3])
    @parent.send "self_lbuttonup",
               (x < 0xefff ? x+self.x : x+self.x-0x10000),
               (y < 0xefff ? y+self.y : y+self.y-0x10000)
  end

  def self_rbuttondown(shift,x,y)
    a=self.windowrect
    self.move(self.x,self.y,a[2],a[3])
    @parent.send "self_rbuttondown",shift,
               (x < 0xefff ? x+self.x : x+self.x-0x10000),
               (y < 0xefff ? y+self.y : y+self.y-0x10000)
  end

  def self_resize(w,h)
    case self
    when VRTabbedPanel
      x,y,w,h = adjustRect(0,0,self.w,self.h,false)
      @panels.each{|i| i.move x,y,w-x,h-y }
    else
    end
  end

  def self_destroy
    #unhookwndproc
  end
end

module CreateCtrl
  require './fduser' #user defined configuration
  include FDControls

#  include FDBmps
#  include FDItems
#  include FDFakeClass

  attr :cmodules
  attr :cinfo
  attr :_vr_menu
  attr :afont
  attr :required
  attr :modules

  Stylehash = {
      "TBSTYLE_BUTTON"        => 0,
      "TBSTYLE_SEP"           => 1,
      "TBSTYLE_CHECK"         => 2,
      "TBSTYLE_GROUP"         => 4,
      "TBSTYLE_CHECKGROUP"    => 6
    }

  module FDControlExt
    attr :items ,1
    attr :modules,1
    def _ext_init() @modules = [] end
    def set_modules(m) (@modules << m).uniq! end
    def get_parents_str(c)
      return "" if c.is_a? VRForm
      s = "_#{c.name}"
      s[0,0] = get_parents_str(c.parent) unless c.parent.is_a? VRForm
      s
    end
  end

  module FDParent
    include FDCommonMethod
    include CreateCtrl

    attr :included
    attr :names

    def fd_parent_init() @included = [] end

    def delete_child_controls
      @controls.each{|k,v|
        deleteControl(v)
        $frm.delete_serial_name(v.name)
        delete_child_controls if v.respond_to? :addControl
      }
    end

    def get_childs_source(novrinit=nil)
      r=[]
      s=""
      incld1 = []
      @modules.uniq!
      @controls.each{|id,item|
        break if item.class == FDCoverPanel
        if item.kind_of? VRNotifyControl then
          (incld1 << "VRComCtlContainer").uniq!
        else
          (incld1 << "VRStdControlContainer").uniq!
        end
        #r << item.createSourceStr
        r << yield(item)
      }
      unless @modules.empty? then
        incld1 = incld1 + @modules
        @modules.each{|m|
          if rq = FDModules::StdModules["#{m}".intern ] then
            ($frm.required << rq.requires).uniq!
            $frm.required.reject!{|i| !i} #delete nil
          end
        }
      end
      s += "\n  def _cntn_init\n"
      s += "    vrinit\n" unless novrinit
      s += r.to_s
      s1 = []
      incld1.each{|i| s1 << "  include #{i}"}
      @included.each{|m| s1 << "  include #{m} if defined? #{m}" if m} unless @included.empty?
      sp=get_parents_str(self.parent)
      s = s1.join("\n") + "\n" + s
      s = "\nmodule Cntn#{sp}_#{name}\n" + s
      s += "  end\n\n"
      s += "end\n\n"
      s
    end

    def set_include(i)
      @included << i
      @included.uniq!
    end

  end

  module STDSourceMaker

    def getFontStr
      hf=sendMessage(WMsg::WM_GETFONT,0,0)
      hf=hf+0x100000000 if hf < 0
      if  f=$frm.afont[hf] then
              "    @#{name}.setFont(@screen.factory.newfont(\n    "+
              "  \"#{f.fontface}\",#{f.height},#{f.style},"+
              "#{f.weight%100},#{f.width},#{f.escapement},#{f.orientation},"+
              "#{f.pitch_family},#{f.charset},#{f.point},#{f.color}))\n"
      else  nil end
    end


    def addRequire
        unless @modules.empty? then
          @modules.each{|m|
            if rq = FDModules::StdModules["#{m}".intern ] then
              ($frm.required << rq.requires).uniq!
              $frm.required.reject!{|i| !i}
            end
          }
        end
    end

    def addModules
      sp=get_parents_str(self.parent)
      ms = "module Extn#{sp}_#{name}\n"
      @modules.each{|m|
        ms += "  include #{m}\n";
        ($frm.required << FDModules::StdModules["#{m}".intern ].requires).uniq!
        $frm.required.reject!{|i| !i}
      }
      ms += "\n" unless @modules.empty?
      ms += "\  def _cntn_init\n"
      ms += "   vrinit\n"
      ms += "  end\n\n"
      ms += "end\n\n"
      $frm.cntnmodules << ms
    end

    def createStdSourceStr
      str = ""
      sp=get_parents_str(self.parent)
      cnt=self.class.to_s
      str += "    "+
         "addControl(#{cnt},'#{name}','#{caption}',#{x},#{y},#{w},#{h},#{style})\n"
      if respond_to?(:addControl) then
        str += "    @#{name}.extend(Cntn#{sp}_#{name})._cntn_init\n"
        $frm.cntnmodules << get_childs_source{|i| i.createSourceStr}
        addRequire
      elsif !@modules.empty? then
        str += "    @#{name}.extend(Extn#{sp}_#{name})._cntn_init\n"
        addModules
      end
      str+= "#{getFontStr}"
      str
    end

    def createSourceStr
      createStdSourceStr
    end

  end

  def set_modules(m) (@modules << m) ; @modules.uniq! end

  def findPalletItem(cnt)
    r = nil
    if cnt.is_a? FDStruct then
        return cnt
    else
      if cnt.respond_to?(:substance) then c = cnt.substance else c = cnt end
      $conf.each{|pallet|
        r = pallet.items.find{|i| (c == i.klass) || (c.class == i.klass)}
        return(r) if r
      }
    end
    r
  end

  def set_cnt_attr(a,cnt)
    @required = [] unless @required
    @required << cnt.required
    @required.uniq!
    @cmodules={} unless @cmodules
    @cinfo={} unless @cinfo
    @cmodules[a.etc]=a.inspect.sub(/#<(.+):.*>/,'\1')
    @cinfo[a.etc]=cnt.klass
    a.extend(FDDraggable).draggable_init
    a.extend(FDControlExt)._ext_init
  end

  #definiton of creating methods on FormDesigner

  def newFDCtrl(parent,cnt,name,caption,x,y,w,h,addstyle=0,c_items=nil)
    c = findPalletItem(cnt)
    a=parent.addControl(c.klass,name,caption,x,y,w,h,addstyle )
    parent.set_include(c.included)
    a.extend STDSourceMaker
    set_cnt_attr(a,c)
    a.extend(FDParent).fd_parent_init if a.respond_to?(:addControl)
    a
  end

  module FDLisviewExt
    attr :_coverPanel,1
    def move(x,y,w,h)
      super
      @_coverPanel.move(x,y,w,h) if @_coverPanel
    end
  end

  def newFDListview(parent,cnt,name,caption,x,y,w,h,addstyle=0,c_items=nil)
    c = findPalletItem(cnt)
    cv=parent.addControl(FDCoverPanel,'_'+name,'',x,y,w,h)
    a=parent.addControl(c.klass,name,caption,x,y,w,h,addstyle )
    a.extend FDLisviewExt
    parent.set_include(c.included)
    def a.createSourceStr
      str = ""
      sp=get_parents_str(self.parent)
      cnt=self.to_s.sub(/\#\<([A-Za-z]+).*/,'\1')
      str += "    "+
         "addControl(#{cnt},'#{name}','#{caption}',#{x},#{y},#{w},#{h},#{style})\n"
      hf=sendMessage(WMsg::WM_GETFONT,0,0)
      hf=hf+0x100000000 if hf < 0
      if  f=$frm.afont[hf] then
        str+= "    @#{name}.setFont("+
        "@screen.factory.newfont(\n    "+
              "  \"#{f.fontface}\",#{f.height},#{f.style},"+
              "#{f.weight%100},#{f.width},#{f.escapement},#{f.orientation},"+
              "#{f.pitch_family},#{f.charset},#{f.point},#{f.color}))\n"
      end
      str
    end
    def a.terminate
      @parent.deleteControl @_coverPanel
    end

    set_cnt_attr(a,c)
    a._coverPanel = cv
    cv.substance = a
    a
  end

  module FDToolbarExt attr :_vr_toolbar_buttons,1 end

  def newFDToolbar(parent,cnt,name,caption,x,y,w,h,addstyle=4,c_items=nil)
    c = findPalletItem(cnt)
    a=parent.addControl(c.klass,name,caption,x,y,w,h,addstyle )
    parent.extend VRToolbarUseable
    parent.extend FDToolbarExt
    parent.set_include(c.included)
    
    def a.getItemsStr(option=nil)
      s = "["
      0.upto(countButtons-1){|i|
        b = getButton(i)
        st = option ? b[3].to_s : Stylehash.invert[b[3]].to_s
        s << "\n  [\"#{@parent._vr_toolbar_buttons[b[1]].name}\",#{st}],"
      }
      if s[s.size-1] == ','[0] then s[s.size-1,1] = "\n]" else  s << "]" end
      s
    end
    
    def a.getItems2
      s = []
      0.upto(countButtons-1){|i|
        b = getButton(i)
        st = Stylehash.invert[b[3]].to_s
        s << [st,@parent._vr_toolbar_buttons[b[1]].name]
      }
      s
    end

    def a.refreshItems(ar)
      begin
      ar.collect!{|i| [i[1],Stylehash[i[0]]]}
      self.terminate
      setButtons(ar)
      self.items = ar
      rescue Exception
        messageBox $!,'Illegal setting of items',16
      end
    end

    def a.terminate
      (countButtons-1).downto(0){|i|
        b = getButton(i)
        @parent._vr_toolbar_buttons.delete(b[1])
        deleteButton(i)
      }
    end

    def a.createSourceStr
      str = ""
      cnt=self.class.to_s
      str += " "*4+
         "addControl(#{cnt},'#{name}','#{caption}',#{x},#{y},#{w},#{h},#{style})\n"
      if countButtons > 0 then
        str += " "*4+"@#{name}.setButtons(\n#{getItemsStr(true)})\n"
      else
        str += "\n"
      end
    end

    def a.eventList
      as = []
      0.upto(countButtons-1){|i|
        b = getButton(i)
        as << @parent._vr_toolbar_buttons[b[1]].name + "_clicked" unless b[3] == 1
      }
      as
    end

    def a.buttons
#      r=$frm.showArrayEditDlg(getItemsStr,200,200)
      $frm._return_val=nil
      ItemEditDlg::POS[0] = [100,100,400,300]
      ItemEditDlg::LISTWIDTH[0] = 254
      ItemEditDlg::ADDINGNAME[0] = 'toolButton'
      ItemEditDlg::ADDREMOVE[0] = true
      ItemEditDlg::TITLES[0]=[['button style',140],['button name',110]]
      ItemEditDlg::ITEMS[0] = getItems2
      ItemEditDlg::FIXCOLUMN[0] = true
      ItemEditDlg::UPDOWN[0] = true
      ItemEditDlg::STYLES[0]=['TBSTYLE_BUTTON','TBSTYLE_SEP','TBSTYLE_CHECK','TBSTYLE_GROUP',
                                                                         'TBSTYLE_CHECKGROUP']
      VRLocalScreen.modalform $frm ,nil,ItemEditDlg
      r = $frm._return_val
      refreshItems(r) if r
      $frm.refreshInspect(self)
    end

    set_cnt_attr(a,c)
    if c_items then
      a.setButtons(c_items)
      a.items = c_items
    elsif a.items
      a.setButtons(a.items)
    else
      items2=c.items.dup.collect!{|i|
        [get_serial_name(i[0]),i[1]]
      }
      a.setButtons(items2)
      a.items = items2
    end
    a
  end

  def newFDRebar(parent,cnt,name,caption,x,y,w,h,addstyle=WStyle::CCS_NOMOVEY,c_items=nil)
    if parent.is_a? VRRebar then
      messageBox 'cannot arrange VRRebar on VRRebar','Illegal arrangement',16
      return
    end
    c = findPalletItem(cnt)
    a=parent.addControl(c.klass,name,caption,x,y,w,h,addstyle)
    parent.set_include(c.included)
    a.extend STDSourceMaker
    def a.get_childs_source(novrinit=nil)
      r=[]
      s=""
      incld1 = []
      @modules.uniq!
      @items.each{|i|
        ct = instance_eval("#{i[0]}")
        break if ct.is_a?(VRStatic) && i[0] == "@__"+ct.parent.name
        break if ct.class == FDCoverPanel
        if ct.kind_of? VRNotifyControl then
          (incld1 << "VRComCtlContainer").uniq!
        else
          (incld1 << "VRStdControlContainer").uniq!
        end
        r << yield(ct,i[1],i[2],i[3])
      }
      unless @modules.empty? then
        incld1 = incld1 + @modules
        @modules.each{|m|
          if rq = FDModules::StdModules["#{m}".intern ] then
            ($frm.required << rq.requires).uniq!
            $frm.required.reject!{|i| !i} #delete nil
          end
        }
      end
      s += "\n  def _cntn_init\n"
      s += "    vrinit\n" unless novrinit
      s += r.to_s
      s1 = []
      incld1.each{|i| s1 << "  include #{i}"}
      @included.each{|m| s1 << "  include #{m} if defined? #{m}" if m} unless @included.empty?
      sp=get_parents_str(self.parent)
      s = s1.join("\n")+ "\n" + s
      s = "\nmodule Cntn#{sp}_#{name}\n" + s
      s += "  end\n\n"
      s += "end\n\n"
      s
    end

    def  a.createSourceStr
      str = ""
      sp=get_parents_str(self.parent)
      cnt=self.class.to_s
      str += "    "+
         "addControl(#{cnt},'#{name}','#{caption}',#{x},#{y},#{w},#{h},#{style})\n"

      if respond_to?(:addControl) then
        str += "    @#{name}.extend(Cntn#{sp}_#{name})._cntn_init\n"
        $frm.cntnmodules << get_childs_source{|c,t,w,h|
          s=c.createSourceStr
          s.sub! /^ +/,"    @#{c.name}="
          s << "    insertband(@#{c.name},'#{t}',#{w},#{h})\n"
          s
        }
        addRequire
      elsif !@modules.empty? then
        str += "    @#{name}.extend(Extn#{sp}_#{name})._cntn_init\n"
        addModules
      end
      str+= "#{getFontStr}"
      str
    end

    def a.refreshItems(ar)
      @items.each_index{|i|
        i0 =ar.select{|j| @items[i][0] == j[0]}[0]
        @items[i][1] = i0[1]
        @items[i][2] = i0[2].to_i
        @items[i][3] = i0[3].to_i
        setbandattr(i,i0[1],i0[2].to_i,i0[3].to_i)
      }
    end

    def a.bands
      $frm._return_val=nil
      ItemEditDlg::LISTWIDTH[0] = 392
      ItemEditDlg::STYLES[0]=nil
      ItemEditDlg::POS[0] = [100,100,400,300]
      ItemEditDlg::ADDREMOVE[0] = false
      ItemEditDlg::UPDOWN[0] = false
      ItemEditDlg::TITLES[0]=[['control',100],['text',100],['min w',92],['min h',92]]
      ItemEditDlg::ITEMS[0] = @items
      ItemEditDlg::FIXCOLUMN[0] = true
      VRLocalScreen.modalform $frm ,nil,ItemEditDlg
      r = $frm._return_val
      refreshItems(r) if r
    end

    def a.setbandattr(idx,txt="",minx=30,miny=30)
      mask= WConst::RBBIM_TEXT | WConst::RBBIM_STYLE | WConst::RBBIM_CHILD |
                                 WConst::RBBIM_CHILDSIZE | WConst::RBBIM_SIZE
      t= ""
      tis = [56,mask,0,0,0,t,0,0,0,0,0,0,0,0,0].pack("LLLLLP#{t.length}LLLLLLLL")
      sendMessage WMsg::RB_GETBANDINFO,idx,tis
      a = tis.unpack("LLLLLPLLLLLLLL")
      a[5]= txt
      a[9]=minx
      a[10]=miny
      rbbi=a.pack("LLLLLP#{txt.length}LLLLLLLL")
      sendMessage(WMsg::RB_INSERTBAND+5,idx,rbbi)
    end

    def a.deleteband(idx)
      sendMessage WMsg::RB_DELETEBAND,idx,0
    end
    
    def a.update_items(oldname,newname)
      @items.find{|i|i[0]=='@'+oldname}[0] = '@' + newname
    end
    
    def a.terminate
      @items.reject!{|i|
        unless i[0] == "@__#{self.name}"
          deleteControl(instance_eval("#{i[0]}"))
          child_deleted(instance_eval("#{i[0]}"))
        end
        true
      }
    end

    def a.child_created(c)
      if c0=@items.select{|i| i[0] == "@__#{self.name}"}.first then
        deleteControl(instance_eval("#{c0[0]}"))
        @items.delete_at(0)
        deleteband(0)
      end
      @parent.instance_eval("@#{c.name}=nil")
      @parent.instance_eval "@controls.delete(c.etc)"
      @controls[c.etc] = c
      unless itm=@items.select{|i| i[0] == '@'+c.name}[0] then
        @items << itm=['@'+c.name,c.name,30,c.h+2]
      end
      instance_eval "@#{c.name}=c"
      insertband(c,itm[1],itm[2],itm[3])
      relayout
    end

    def a.child_deleted(c)
      idx = @items.index(@items.select{|i| i[0] == '@'+c.name }[0])
      @items.delete_at(idx)
      deleteband(idx)
      if @items.empty? then
        cv=addControl(VRStatic,"__#{name}",'',0,0,25,25)
        @parent.instance_eval("@#{cv.name}=nil")
        @parent.instance_eval "@controls.delete(cv.etc)"
        @controls[cv.etc] = cv
        instance_eval("@#{cv.name}=cv")
        insertband(cv,"",0,30)
        @items = [['@'+cv.name,""]]
        c1 = findPalletItem(cv)
        $frm.set_cnt_attr(cv,c1)
     end
    end

    set_cnt_attr(a,c)
    a.extend(FDParent).fd_parent_init
    unless c_items then
      cv=a.addControl(VRStatic,"__#{name}",'',0,0,25,25)
      a.parent.instance_eval("@#{cv.name}=nil")
      a.parent.instance_eval "@controls.delete(cv.etc)"
      a.controls[cv.etc] = cv
      a.instance_eval("@#{cv.name}=cv")
      a.insertband(cv,"",0,30)
      a.items = [['@'+cv.name,""]]
      c1 = findPalletItem(cv)
      set_cnt_attr(cv,c1)
    else
     a.items = c_items 
    end
    a
  end

  def newFDTabbedPanel(parent,cnt,name,caption,x,y,w,h,addstyle=0,c_items=nil)
    if parent.is_a? VRTabControl then
      messageBox 'cannot arrange VRTabbedPanel on VRTabControl','Illegal arrangement',16
      return
    end
    
    c = findPalletItem(cnt)
    a=parent.addControl(c.klass,name,caption,x,y,w,h,addstyle )
    parent.set_include(c.included)

    def a.getItemsStr(option=nil)
      s = "[\n"
      0.upto(countTabs-1){ |i| s += "  '#{getTabTextOf(i)}',\n"}
      s[s.size-2,2] = "\n]\n"
      s
    end

    def a.getItems2
      s = []
      0.upto(countTabs-1){ |i| s << [@panels[i].name,getTabTextOf(i)]}
      s
    end

    def a.refreshItems(a0)
      @items = a0.collect{|i| i[1]}
      a1 = a0.select{|i| i[0]!=""}.collect{|i| instance_eval('@'+i[0])}
      @panels.each_with_index{|itm,idx|
        unless a1.find{|j| j == itm } then
          @panels[idx].delete_child_controls
          deleteControl(@panels[idx])
          @panels.delete_at(idx)
        end
      }
      @panels.each{|i| 
        instance_eval "@#{i.name}=nil"
        i.name = "___"+i.name
      }
      clearTabs
      0.upto(a0.size-1){|i|
        insertTab(i,a0[i][1])
        if (n=a0[i][0]) != ''  then
          m = 0.upto(@panels.size-1){|j| break j if @panels[j].name == "___#{n}" }
          @panels[i,0] = @panels.delete_at(m)
          instance_eval "@#{@panels[i].name.sub(/^___/,'')}=nil"
          @panels[i].name = "panel#{i}"
          instance_eval "@#{@panels[i].name}=@panels[i]"
        else
          @panels[i,0] = nil
          x,y,w,h = adjustRect(0,0,self.w,self.h,false)
          @panels[i] = addControl(VRPanel,"panel#{i}","panel#{i}",x,y,w-x,h-y)
          @panels[i].extend VRContainersSet
          @panels[i].containers_init
          @panels[i].show 0
          c1 = $frm.findPalletItem(@panels[i])
          $frm.set_cnt_attr(@panels[i],c1)
          @panels[i].extend STDSourceMaker
          @panels[i].extend(FDParent).fd_parent_init
          @panels[i].extend CreateCtrl
        end
      }
      #selectTab 0
    end

    def a.terminate
    end

    def a.createSourceStr
      str = ""
      sp=get_parents_str(self.parent)
      cnt=self.class.to_s
      str += " "*4+
         "addControl(#{cnt},'#{name}','#{caption}',#{x},#{y},#{w},#{h},#{style})\n"
      if @panels.size > 0 then
        str += " "*4+"@#{name}.setupPanels(\n*#{getItemsStr(true)})\n"
      else
        str += "\n"
      end
      str += "    @#{name}.extend(Cntn#{sp}_#{name})._cntn_init\n"
      s1 = "\nmodule Cntn#{sp}_#{name}\n  def _cntn_init\n    vrinit\n"
      s2 = ""
      @panels.each{|i|
        sp2 = get_parents_str(i.parent)
        s1 << "    @#{i.name}.extend(Cntn#{sp2}_#{i.name})._cntn_init\n"
        $frm.cntnmodules << i.get_childs_source(true){|j| j.createSourceStr}
      }
      s1 += "  end\n\nend\n\n"
      $frm.cntnmodules << s1
      hf=sendMessage(WMsg::WM_GETFONT,0,0)
      hf=hf+0x100000000 if hf < 0
      if  f=$frm.afont[hf] then
        str+= "    @#{name}.setFont("+
        "@screen.factory.newfont(\n    "+
              "  \"#{f.fontface}\",#{f.height},#{f.style},"+
              "#{f.weight%100},#{f.width},#{f.escapement},#{f.orientation},"+
              "#{f.pitch_family},#{f.charset},#{f.point},#{f.color}))\n"
      end
      str
    end

    def a.pages
      $frm._return_val=nil
      ItemEditDlg::LISTWIDTH[0] = 392
      ItemEditDlg::STYLES[0]=nil
      ItemEditDlg::POS[0] = [100,100,400,300]
      ItemEditDlg::ADDINGNAME[0] = 'tab'
      ItemEditDlg::ADDREMOVE[0] = true
      ItemEditDlg::UPDOWN[0] = false
      ItemEditDlg::TITLES[0]=[['panel',120],['title',100]]
      ItemEditDlg::ITEMS[0] = getItems2
      ItemEditDlg::FIXCOLUMN[0] = true
      VRLocalScreen.modalform $frm ,nil,ItemEditDlg
      r = $frm._return_val
      refreshItems(r) if r
      $frm.refreshCntName
      $frm.refreshInspect(self)
    end

    set_cnt_attr(a,c)
    a.extend(FDParent).fd_parent_init
    if c_items then
      a.setupPanels(*c_items)
      a.items = c_items
    elsif a.items
      a.setupPanels(*a.items)
    else
      a.setupPanels(*c.items)
      a.items = c.items
    end
    a.panels.each{|i|
      c1 = findPalletItem(i)
      set_cnt_attr(i,c1)
      i.extend STDSourceMaker
      i.extend(FDParent).fd_parent_init
    }
    a
  end

  module FDMenuExt 
    attr :_vr_menus,1 
  end

  def newFDMenu(parent,cnt,name,caption,x,y,w,h,addstyle=0,c_items=nil)
    c = findPalletItem(cnt)
    parent.extend FDMenuExt
    a=addControl(FDContainer,name,caption,x,y,w,h,addstyle )
    parent.set_include(c.included)
    
    def a.createMthodStr(t)
      s= "@#{self.name}.#{t}"
      s
    end
    
    def a.getItemsStr
      mn=MenuStrMaker.new
      mn.makeStr(@items)
    end

    def a.refreshItems(a)
      begin
      self.items = a
      @parent._vr_menus.clear
      self.terminate
      self.substance = @parent.newMenu.set(self.items)
      @parent.setMenu self.substance,false
      rescue Exception
        messageBox $!,'Illegal setting of items',16
      end
    end

    def a.terminate
      @parent.setMenu @parent.newMenu,false if parent.visible?
    end

    def a.set_attrs(a)
      #do nothing
    end

    def a.createSourceStr
      r = "    @#{self.name} = newMenu.set(\n"
      r += self.getItemsStr.gsub(/^/," "*6)
      r += "    )\n"
      @_kb_accel=false unless @_kb_accel
      r += "    setMenu(@#{self.name},#{@_kb_accel})\n"
      r += "    \#$_ctn_#{self.name}=[#{self.x},#{self.y}]\n"
      r
    end

    def a.eventList
      s_ary = []
      @parent._vr_menus.each{|i,c|
        s_ary << c.name + "_clicked" unless c.name == '_vrmenusep'
      }
      s_ary
    end
    
    def a.menus
      a = []
      $frm._return_val=nil
      analizer = MenuAnalizer.new
      MenuEditDlg::ITEMS[0] = analizer.analize(@items)
      MenuEditDlg::POS[0] = [$frm.x+50,$frm.y+50,468,300]
      0.upto(analizer.colCount-1){|i| a << ["#{i+1}",112]}
      MenuEditDlg::TITLES[0]=a
      VRLocalScreen.modalform $frm ,nil,MenuEditDlg
      r = analizer.unanalize($frm._return_val) if $frm._return_val
      refreshItems(r) if r
      $frm.refreshInspect(self)
    end
    
    def a.accel(a = true) @_kb_accel = a end
      
    def a.getaccel() @_kb_accel end
    
    set_cnt_attr(a,c)
    a.bmp=SWin::Bitmap.loadString(c.bmp)
    if c_items then
      a.items=c_items
    elsif c.items
      a.items=c.items
    else
      a.items=FDMenuTemplate
    end
    a.accel(true)
    a.substance = newMenu.set a.items
    self.setMenu a.substance,false
    # "substance" is substantial control or class of this instance(FDContainer)
    a
  end
  
  def newFDPopup(parent,cnt,name,caption,x,y,w,h,addstyle=0,c_items=nil)
    c = findPalletItem(cnt)
    parent.extend FDMenuExt
    a=addControl(FDContainer,name,caption,x,y,w,h,addstyle )
    parent.set_include(c.included)
    
    def a.createMthodStr(t)
      case t
      when /^showPopup/
        s=t.sub /(\(.+\))/,"(@#{self.name})"
      else
        s= "@#{self.name}.#{t}"
      end
      s
    end
    
    def a.getItemsStr
      mn=MenuStrMaker.new
      mn.makeStr(@items)
    end
    
    def a.set_attrs(a)
      #do nothing
    end

    def a.createSourceStr
      r = "    @#{self.name} = newPopupMenu.set(\n"
      r += self.getItemsStr.gsub(/^/," "*6)
      r += "  )\n"
      r += "    \#$_ctn_#{self.name}=[#{self.x},#{self.y}]\n"
      r
    end

    def a.menus
      a = []
      $frm._return_val=nil
      analizer = MenuAnalizer.new
      MenuEditDlg::ITEMS[0] = analizer.analize(@items)
      MenuEditDlg::POS[0] = [$frm.x+50,$frm.y+50,468,300]
      0.upto(analizer.colCount-1){|i| a << ["#{i+1}",112]}
      MenuEditDlg::TITLES[0]=a
      VRLocalScreen.modalform $frm ,nil,MenuEditDlg
      @items = analizer.unanalize($frm._return_val) if $frm._return_val
      $frm.refreshInspect(self)
    end

    def a.eventList
      ar = []
      an = MenuAnalizer.new
      ana = an.analize(@items)
      ana.each{|i|
        level = 0
        flag0 = nil
        a = []
        i.each{|j|
          if j == "" then
            break if flag0
            level += 1
          else
            a << j
            flag0 = true
          end
        }
        ar << a[1]+'_clicked' if a.size > 1 && a[1] != "_vrmenusep"
      }
      ar
    end
    
    set_cnt_attr(a,c)
    if c_items then
      a.items=c_items
    elsif c.items
      a.items=c.items
    else
      a.items=FDItems::FDPopupMenuTemplate
    end
    a.bmp=SWin::Bitmap.loadString(c.bmp)
    a.substance = c.klass.new # this is a fake class which defined fdresources.rb
    a
  end

  def newFDOpenSaveDlg(paernt,cnt,name,caption,x,y,w,h,addstyle=0,info=nil,ext=nil)
    c = findPalletItem(cnt)
    a=addControl(FDContainer,name,caption,x,y,w,h,addstyle )
    def a.init
      @_filters = FDItems::FDDlgFilterTemplate
      if @substance.class == FDOpenDlg
        aryFlags = FDComDlgItems::OpenFileFlag
        @_flags = aryFlags['OFN_FILEMUSTEXIST']
      else
        aryFlags = FDComDlgItems::SaveFileFlag
        @_flags = aryFlags['OFN_OVERWRITEPROMPT']
      end
      @_title = nil
      @_defaultExt = nil
    end

    def a.createSourceStr
      cnt=self.substance.class.name.sub /^.*::/,''
      r =  "    \#$_addControl(#{cnt},'#{name}','#{caption}',#{x},#{y},24,24,#{style})\n"
      r += "    \#$_ctn_#{self.name}=[#{self.x},#{self.y},#{@_filters.inspect},"<<
                "#{@_flags.inspect},#{@_title.inspect},#{@_defaultExt.inspect}]\n"
      r
    end

    def a.createMthodStr(s)
      str = s.sub /\(.*$/ , ''
      fs = @_flags ? @_flags.to_x : 'nil'
      "#{str}(#{@_filters.inspect},#{fs},#{@_title.inspect},#{@_defaultExt.inspect})"
    end

    def a.set_attrs(a)
      @_filters = a[0]
      @_flags = a[1]
      @_title = a[2]
      @_defaultExt = a[3]
    end

    def a.filters
      @_filters = [["all(*.*)","*.*"]] unless @_filters
      $frm._return_val=nil
      ItemEditDlg::LISTWIDTH[0] = 392
      ItemEditDlg::STYLES[0]=nil
      ItemEditDlg::POS[0] = [100,100,400,300]
      ItemEditDlg::ADDINGNAME[0] = '*.*'
      ItemEditDlg::ADDREMOVE[0] = true
      ItemEditDlg::UPDOWN[0] = true
      ItemEditDlg::TITLES[0]=[['title',200],['filter',100]]
      ItemEditDlg::ITEMS[0] = @_filters
      ItemEditDlg::FIXCOLUMN[0] = false
      VRLocalScreen.modalform $frm ,nil,ItemEditDlg
      r = $frm._return_val
      @_filters=r if r
      $frm.refreshInspect(self)
    end

    def a.flags
      if @substance.class == FDOpenDlg
        aryFlags = FDComDlgItems::OpenFileFlag
        @_flags = aryFlags['OFN_FILEMUSTEXIST'] unless @_flags
      else
        aryFlags = FDComDlgItems::SaveFileFlag
        @_flags = aryFlags['OFN_OVERWRITEPROMPT'] unless @_flags
      end
      a = []
      aryFlags.each{|k,v|
        n = ((@_flags & v) == 0 ) ? 0 : 1
        a << [k.dup,n]
      }
      if s = $frm.showModDlg(a,104,195) then
        n = 0
        s.each{|i| n |=  aryFlags[i[0]] if i[1] !=0}
        @_flags=n
      end
      $frm.refreshInspect(self)
    end

    def a.title() @_title end

    def a.defaultExt() @_defaultExt end

    a.substance = c.klass.new # this is a fake class which defined fdresources.rb
    set_cnt_attr(a,c)
    a.bmp=SWin::Bitmap.loadString(c.bmp)
    a.init
    a
  end

  def newFDSelectDir(paernt,cnt,name,caption,x,y,w,h,addstyle=0,info=nil,ext=nil)
    c = findPalletItem(cnt)
    a=addControl(FDContainer,name,caption,x,y,w,h,addstyle )
    def a.init
      @_flags=FDComDlgItems::BrowseFolderFlag["BIF_RETURNONLYFSDIRS"]
    end
    def a.flags
      a = []
      FDComDlgItems::BrowseFolderFlag.each{|k,v|
        n = ((@_flags & v) == 0 ) ? 0 : 1
        a << [k.dup,n]
      }
      if s = $frm.showModDlg(a,104,195) then
        n = 0
        s.each{|i| n |=  FDComDlgItems::BrowseFolderFlag[i[0]] if i[1] !=0}
        @_flags = n
      end
    end
    
    def a.set_attrs(a)
      #do nothing
    end

    def a.title() @_title end

    def a.initialdir() @_initialdir end

    def a.terminate
    end
    def a.createSourceStr
      cnt=self.substance.class.name.sub /^.*::/,''
      r =  "    \#$_addControl(#{cnt},'#{name}','#{caption}',#{x},#{y},24,24,#{style})\n"
      r += "    \#$_ctn_#{self.name}=[#{self.x},#{self.y},#{@_title.inspect},"<<
                "#{@_initialdir.inspect},#{@_flags.inspect}]\n"
      r
    end
    def a.createMthodStr(s)
      str = s.sub /\(.*$/ , ''
      fs = @_flags ? @_flags.to_x : 'nil'
      "#{str}(#{@_title.inspect},#{@_initialdir.inspect},#{fs})"
    end
    a.substance = c.klass.new # this is a fake class which defined fdresources.rb
    set_cnt_attr(a,c)
    a.bmp=SWin::Bitmap.loadString(c.bmp)
    a.init
    a
  end

  def newFDModule(paernt,cnt,name,caption,x,y,w,h,addstyle=0,info=nil,ext=nil)
    c = findPalletItem(cnt)
    a=addControl(FDContainer,name,caption,x,y,w,h,addstyle )
    def a.getItemsStr(option=nil)
      ""
    end
    
    def a.set_attrs(a)
      #do nothing
    end
    
    def a.refreshItems(ar)
    end
    
    def a.terminate
    end
    
    def a.createSourceStr
      cnt=self.substance.class.name.sub /^.*::/,''
      r =  "    \#$_addControl(#{cnt},'#{name}','#{caption}',#{x},#{y},24,24,#{style})\n"
      r += "    \#$_ctn_#{self.name}=[#{self.x},#{self.y}]\n"
      r
    end
    
    def a.createMthodStr(s)
      str = s.sub /\(.*$/ , ''
      "#{str}"
    end
    a.substance = c.klass.new # this is a fake class which defined fdresources.rb
    set_cnt_attr(a,c)
    a.bmp=SWin::Bitmap.loadString(c.bmp)
    a
  end

  def createinit()
    $conf = controls_init
    user_createinit
  end
end

class FDCoverPanel < VRPanel
  include FDDraggable
  undef :addControl
  attr :substance,1
  def vrinit
    super
    draggable_init
  end
end

class FDDummyPanel < VRPanel
  undef :addControl
  def vrinit
    super
    draggable_init
  end
end
