# fdcontroldesign.rb
# The form to controls designing
#
# Programmed by yukimi_sake@mbi.nifty.com
# Copyright 2001-2003 Yukio Sakaue

require 'Win32API'
require 'swin'
require 'vr/vruby'
require 'vr/sysmod'
require 'vr/vrcontrol'
require 'vr/vrcomctl'
require 'vr/vrhandler'
require 'vr/winconst'
require 'vr/rscutil'
require 'vr/vrrichedit'
require 'vr/vrtooltip'
require 'vr/contrib/inifile'
require 'vr/vrtimer'
require 'vr/vrddrop'
require 'vr/vrclipboard'
require 'vr/vrmmedia'
require 'fdvr/fdparser'
require 'fdvr/fdwstyle'
require 'fdvr/fdmodules'
require 'fdvr/fdresources'
require 'fdvr/fdcfg'

module FDMouseControl
    R2_COPYPEN   = 13
    R2_NOTXORPEN = 10

  def step(v)
    if @enableGrid then v-v%@span else  v  end
  end

end

class FDContainer < VRBitmapPanel
  include FDDraggable
  attr :substance,1
  attr :items,1
  undef :addControl

  def self_destroy
    #unhookwndproc
    self.terminate if defined? self.terminate
  end

end

module FDControlDesign  # for DesignForm
  include VRMenuUseable
  include VRToolbarUseable
  include VRDrawable
  include VRResizeable
  include VRDestroySensitive
  include VRCommonDialog
  include VRParent
  include FDMouseControl
  include VRTimerFeasible
  include CreateCtrl #from 'fdcfg'
  include FDCommonMethod
  include WConst
  include FDParent
  include FDFakeClass

  attr :creation,1
  attr :span,1
  attr :enableGrid,1
  attr :name,1
  attr :sender,1
  attr :focused,1
  attr :focusExists,1
  attr :controls
  attr :buff1,1
  attr :linscan2,1
  attr :cntnmodules,1
  attr :modules
  attr :names
  attr :_return_val,1
  def vrinit
    super
    @app=@screen.application
    @curs=@app::SysCursors
  end

  def construct
    begin SWin::Application.setAccel(self,@parent) ;rescue ;end
    @getTextFace=Win32API.new('GDI32','GetTextFace','LLP','L')
    @getDC = Win32API.new('User32', 'GetDC', 'L', 'L')
    @createRectRgn = Win32API.new('GDI32','CreateRectRgn','LLLL','L')
    @selectClipRgn = Win32API.new('GDI32','SelectClipRgn','LL','L')
    createPen = Win32API.new('GDI32', 'CreatePen', 'LLL', 'L')
    createBrush = Win32API.new('GDI32', 'CreateSolidBrush', 'L', 'L')
    @selectObject = Win32API.new('GDI32', 'SelectObject', 'LL', 'L')
    @deleteObject = Win32API.new('GDI32', 'DeleteObject', 'L', 'L')
    @setROP2 = Win32API.new('GDI32','SetROP2','LL','L')
    @moveTo = Win32API.new('GDI32', 'MoveToEx', 'LLLP', 'V')
    @lineTo = Win32API.new('GDI32', 'LineTo', 'LLL', 'V')
    @rectangle = Win32API.new('GDI32', 'Rectangle', 'LLLLL', 'V')
    lpRect = ' ' * 16
    @span=$ini.read('settings','span',8).to_i
    addHandler WMsg::WM_LBUTTONDOWN,'lbuttondown',MSGTYPE::ARGLINTINT,nil
    addHandler WMsg::WM_MOUSEMOVE,  'mousemove',MSGTYPE::ARGINTINTINT,nil
    addHandler WMsg::WM_LBUTTONUP,  'lbuttonup',  MSGTYPE::ARGLINTINT,nil
    addHandler WMsg::WM_RBUTTONUP,  'rbuttonup',  MSGTYPE::ARGINTSINTSINT,nil
    addHandler WMsg::WM_RBUTTONDOWN,'rbuttondown',MSGTYPE::ARGINTSINTSINT,nil
    acceptEvents [WMsg::WM_LBUTTONUP,WMsg::WM_RBUTTONUP,
                  WMsg::WM_LBUTTONDOWN,WMsg::WM_RBUTTONDOWN,
                  WMsg::WM_MOUSEMOVE]

    @dc=@getDC.Call(self.hWnd)
    x,y,w,h = self.clientrect
    @hrgn=@createRectRgn.Call(x,y,w,h)
    @selectClipRgn.Call(@dc,@hrgn)
    @hBrush=createBrush.call(0)
    @oldBrush=@selectObject.Call(@dc,@hBrush)
    @hPen = createPen.Call(0,2,0x00404040)
    @oldhPen=@selectObject.Call(@dc,@hPen)
    @selected_point=Struct.new(:x,:y)[0,0]
    @paste_to=nil
    @copy_buff=[]
    init_designfrm
  end

  def init_designfrm
    $frm=self
    @names=[]
#    @controls={}
    @focus=[0,0,0,0]
    @moving=false; @resizing=false
    @x1=@x2=@y1=@y2=0
    @enableGrid=true
    @required=["vruby"]
    @included=[]
    @modules=[]
    @afont={}
    @temp_fonts=[]
    @font_array=[]
    @font_hash={}
    @name="form1"
    @buff=""
    @frm_sizebox = 'true'
    @frm_maximizebox = 'true'
    wsdlgcreate
    arrydlgcreate
    moddlgcreate
    createinit
    fd_parent_init
    refreshInspect(nil)
    refreshCntName
  end

  def wsdlgcreate
    tpl = VRDialogTemplate.new
    tpl.style = WS_CAPTION | WS_SYSMENU | DS_MODALFRAME | DS_SETFONT
    tpl.fontname = "MS Gothic"
    tpl.fontsize = 11
    tpl.caption="Window Style"
    btok = tpl.addDlgControl(VRButton,"O   K",5,182,40,12)
    btcan = tpl.addDlgControl(VRButton,"Cancel",50,182,40,12)
    lb1 = tpl.addDlgControl(VRListbox,"",2,16,100,164,0x0060)
    cb1 = tpl.addDlgControl(VRCombobox,"",2,2,100,80)
    @wsdlg=ListBoxDlg.new(@screen,tpl)
    @wsdlg.options ={"target"=>lb1,"target2"=>cb1,"okbutton"=>btok,
                      "cancelbutton"=>btcan,"default" => [["",0]],
                      "default2"=>[["",0]]}
  end

  def arrydlgcreate
    tpl = VRDialogTemplate.new
    tpl.style = WS_CAPTION | WS_SYSMENU | DS_MODALFRAME | DS_SETFONT
    tpl.fontname = "MS Gothic"
    tpl.fontsize = 11
    tpl.caption="Array Editor"
    btok = tpl.addDlgControl(VRButton,"O   K",5,187,40,12,0x00010000)
    btcan = tpl.addDlgControl(VRButton,"Cancel",50,187,40,12,0x00010000)
    ed1 = tpl.addDlgControl(VREdit,"",2,2,200,180,0x00b01064)
    @arrydlg=ArrayEditDialog.new(@screen,tpl)
    @arrydlg.options ={"target"=>ed1,"okbutton"=>btok,
                      "cancelbutton"=>btcan,"default" => [["",""]]}

  end

  def moddlgcreate
    tpl = VRDialogTemplate.new
    tpl.style = WS_CAPTION | WS_SYSMENU | DS_MODALFRAME | DS_SETFONT
    tpl.fontname = "MS Gothic"
    tpl.fontsize = 11
    tpl.caption="Modules"
    btok = tpl.addDlgControl(VRButton,"O   K",5,182,40,12)
    btcan = tpl.addDlgControl(VRButton,"Cancel",50,182,40,12)
    lb1 = tpl.addDlgControl(VRListbox,"",2,2,100,164,0x0060)
    @moddlg=ListBoxDlg.new(@screen,tpl)
    @moddlg.options ={"target"=>lb1,"okbutton"=>btok,
                      "cancelbutton"=>btcan,"default" => [["",0]]}
  end
  
  def setPenMode(mode)
    @setROP2.Call(@dc,mode)
  end

  def rect(x1,y1,x2,y2)
    @moveTo.Call(@dc,x1,y1,0)
    @lineTo.Call(@dc,x2,y1);
    @lineTo.Call(@dc,x2,y2);
    @lineTo.Call(@dc,x1,y2);
    @lineTo.Call(@dc,x1,y1)
  end

  def get_serial_name(s)
    s1 = s.dup
    if @names.index(s1) then
      s1.sub! /(\d+)$/ , ""
      s1 << "#{$1.to_i+1}"
      get_serial_name(s1)
    else
      @names << s1
      s1
    end
  end

  def delete_serial_name(s)
    @names.delete(s)
  end

  def self_paint
    if @enableGrid then
      a=clientrect
      @setROP2.Call(hdc,8)
      nh=(a[2]/@span).to_i;nv=(a[3]/@span).to_i
      setBrush(0)
      dc=self.hdc
      i=0
      #draw grids
      for i in 0.. nh
        grMoveTo(i*@span,0)
        grLineTo(i*@span,nv*@span)
      end
      for i in 0.. nv
        grMoveTo(0,i*@span)
        grLineTo(nh*@span,i*@span)
      end
      @setROP2.Call(hdc,13)
    end

    if @focusExists then
      addTimer(50)
    end
  end

  def self_timer
     paintFocusRect
     deleteTimer
  end

  def paintFocusRect
    dopaint do
      @rectangle.Call(@dc,@x1-5,@y1-5,@x1,@y1)
      @rectangle.Call(@dc,@x2+5,@y2+5,@x2,@y2)
      @rectangle.Call(@dc,@x1-5,@y2+5,@x1,@y2)
      @rectangle.Call(@dc,@x2+5,@y1-5,@x2,@y1)
      @rectangle.Call(@dc,@x1-5,(@y1+@y2)/2-3,@x1,(@y1+@y2)/2+2)
      @rectangle.Call(@dc,@x2+5,(@y1+@y2)/2-3,@x2,(@y1+@y2)/2+2)
      @rectangle.Call(@dc,(@x1+@x2)/2-3,@y1-5,(@x1+@x2)/2+2,@y1)
      @rectangle.Call(@dc,(@x1+@x2)/2-3,@y2+5,(@x1+@x2)/2+2,@y2)
    end
  end

  def setFocusRgn(c)
    refresh
    unless c then
      @x1=@x2=@y1=@y2=nil
      @focusExists = false
    else
      if c.parent.is_a?(VRForm) then
        @x1=c.x;@y1=c.y;@x2=c.x+c.w;@y2=c.y+c.h
      else
        a=getFormPos(c)
        @x1=a[0];@y1=a[1];@x2=a[0]+c.w;@y2=a[1]+c.h
      end
    end
  end

  def getFormPos(c)
      r=[0,0]
    if c then
      if c.parent.is_a?VRForm then
        r[0]=c.x;r[1]=c.y
      else
        a=getFormPos(c.parent)
        r[0]=c.x+a[0];r[1]=c.y+a[1]
      end
    end
      r
  end

  def resizecursor(l,r,t,b) # from visualu.rb
    r =
      if l then
        if t then
          @curs.SizeNWSE
        elsif b then
          @curs.SizeNESW
        else
          @curs.SizeWE
        end
      elsif r then
        if t then
          @curs.SizeNESW
        elsif b then
          @curs.SizeNWSE
        else
          @curs.SizeWE
        end
      elsif t or b then
        @curs.SizeNS
      else
        @curs.Arrow
      end
  end

  def controlstate(l,r,t,b)
    @moving = @resizeALL = @resizeLR = @resizeUD = false
      if l then
          @ox1=@x2
        if t then
          @oy1=@y2;@resizeALL=true
        elsif b then
          @oy1=@y1;@resizeALL=true
        else
          @oy1=@y1;@resizeLR=true
        end
      elsif r then
          @ox1=@x1
        if t then
          @oy1=@y2;@resizeALL=true
        elsif b then
          @oy1=@y1;@resizeALL=true
        else
          @oy1=@y1;@resizeLR=true
        end
      elsif t then
        @ox1=@x1;@oy1=@y2;@resizeUD=true
      elsif b then
        @ox1=@x1;@oy1=@y1;@resizeUD=true
      else
        @ox1=@x1;@oy1=@y1;@ox2=@x2;@oy2=@y2
        @moving=true
      end
  end
  
  def set_selected_point(sx,sy)
    ox=oy=0
    if @paste_to then
      if @pasete_to.respond_to?(:addControl) || @paste_to.parent.class == VRTabbedPanel then
        c=@paste_to
      else
        c=@paste_to.parent
      end
      ox,oy = *getFormPos(c) unless c==self
    end
    @selected_point.x = sx-ox
    @selected_point.y = sy-oy
  end
  
  def self_lbuttonup(x,y)
    num=1 ; @drugging = false
    sx=step(x < 0xefff ? x : x-0x10000)
    sy=step(y < 0xefff ? y : y-0x10000)
    ox=oy=0;a=[0,0]
    set_selected_point(sx,sy)
    if @containerCnt != self || @focused && @focused.parent != self then
      if @containerCnt != self then
        a = getFormPos(@containerCnt)
        ox = a[0]; oy = a[1]
      end
    end
    if @creation then
      nam = get_serial_name(@creation.inst + "1")
      @creating=instance_eval("#{@creation.createMethod}(@containerCnt,@creation,
        nam,nam,@ox1-ox,@oy1-oy,@creation.dflt_w, @creation.dflt_h)")
      return unless @creating
      if @creating && sx - @ox1 >0 && sy - @oy1 >0 then
        @creating.move @ox1-ox,@oy1-oy,sx-@ox1,sy-@oy1
      end
      moveC(@creating)
      @focused=@creating
      @creating.parent.child_created(@creating) if @creating.parent.respond_to? :child_created
      setFocusRgn(@focused)
      @focusExists = true if @focused
      refreshCntName
      $modified += 1
    elsif @resizeALL then
      if @ox1 < sx then
        x1=@ox1 ; w=sx-@ox1
      else
        x1=sx ;  w=@ox1-sx
      end
      if @oy1 < sy then
        y1=@oy1 ; h=sy-@oy1
      else
        y1=sy   ; h=@oy1-sy
      end
      @focused.move x1-ox,y1-oy,w,h
      moveC(@focused)
      setFocusRgn(@focused)
      @focusExists = true
      $modified += 1
    elsif @resizeLR then
      if @ox1 < sx then
        x1=@ox1 ; w=sx-@ox1
      else
        x1=sx ;  w=@ox1-sx
      end
      @focused.move x1-ox,@focused.y,w,@focused.h
      moveC(@focused)
      setFocusRgn(@focused)
      @focusExists = true
      $modified += 1
    elsif @resizeUD then
      if @oy1 < sy then
        y1=@oy1 ; h=sy-@oy1
      else
        y1=sy   ; h=@oy1-sy
      end
      @focused.move @focused.x,y1-oy,@focused.w,h
      moveC(@focused)
      setFocusRgn(@focused)
      @focusExists = true
      $modified += 1
    elsif @moving then
      @focused.move sx-@xl-ox,sy-@yu-oy,@xr+@xl,@yu+@yd
      moveC(@focused)
      if @prevfocuse && @prevfocuse.parent.is_a?(VRRebar) && sx == @px1 && sy == @py1 then
        @focused = @prevfocuse
        @prevfocuse = nil
      end
      setFocusRgn(@focused)
      @focusExists = true
      $modified += 1
    end
    if @focused && (@focused.visible? == false) then
      @focused.visible=true
    end
    setPenMode(R2_COPYPEN)
    self.refresh
    @moving=@resizeALL=@resizeLR=@resizeUD= false
    releaseCapture
    self.parent.tab.noselectAll
    self.focus
    refreshInspect(@focused)
    @creating = nil
    @containerCnt = self
  end

  def self_lbuttondown(x,y)
    sx=step(x);sy=step(y)
    c0 = checkfocus(x,y)
    @paste_to=c0
    if  @focused == nil ||
      !(( @focused.x - 4 < x && x < @focused.x + @focused.w + 4) &&
        ( @focused.y - 4 < y && y < @focused.y + @focused.h + 4))
    then
      if @focused = c0 then
        setFocusRgn(@focused)
      end
    elsif @focused &&
       (( @focused.x  < x && x < @focused.x + @focused.w ) &&
        ( @focused.y  < y && y < @focused.y + @focused.h ))
      if @focused = checkfocus(x,y) then
        setFocusRgn(@focused)
      end
    end
    if @creation then
      if @creation.klass <= SWin::Window && @focused then
        if @focused.respond_to?(:addControl) then
          @containerCnt = @focused
        else
          @containerCnt = @focused.parent
        end
      else
        @containerCnt = self
      end
      @ox1=sx;  @oy1=sy
      @px1 = @ox1 ; @py1 = @oy1
      setPenMode(R2_NOTXORPEN)
      @focusExists = false
      setCapture
    elsif @focused then
      @containerCnt=@focused.parent
      controlstate((x-@x1).abs < 4 && @y2+4 > y && y > @y1-4,
                   (x-@x2).abs < 4 && @y2+4 > y && y > @y1-4,
                   (y-@y1).abs < 4 && @x2+4 > x && x > @x1-4,
                   (y-@y2).abs < 4 && @x2+4 > x && x > @x1-4 )
      @px1 = @ox1 ; @py1 = @oy1
      if @moving  then
        if (@focused.parent.is_a? VRTabbedPanel)||(@focused.parent.is_a? VRRebar) then
          @prevfocuse = @focused
          @focused = @focused.parent
          @containerCnt=@focused.parent
          setFocusRgn(@focused)
          @ox1=@x1;@oy1=@y1;@ox2=@x2;@oy2=@y2
        end
        @px1 = sx ; @py1 = sy
        @xl=@px1-@x1;@yu=@py1-@y1
        @xr=@x2-@px1;@yd=@y2-@py1
        @focusExists = true
      end
      setPenMode(R2_NOTXORPEN)
      setCapture
    else
      @focused = nil
      @focusExists = false
      @containerCnt = self
    end

    refresh
    @drugging = true
  end

  def self_rbuttondown(shift,x,y)
    sx=step(x < 0xefff ? x : x-0x10000)
    sy=step(y < 0xefff ? y : y-0x10000)
    if @focused = checkfocus(x,y) then
      @paste_to=@focused
      @focused = @focused.parent if @focused.parent.class==VRTabbedPanel
      setFocusRgn(@focused)
      @focusExists = true
    else
      @paste_to=nil
      @focusExists = false
    end
    set_selected_point(sx,sy)
    refreshInspect(@focused)
    refresh
    @parent.popupMenu @parent.amenu.menu,self.x+x,self.y+y
  end

  def self_mousemove(shift,x,y)
    SWin::Application.doevents
    sx=step(x < 0xefff ? x : x-0x10000)
    sy=step(y < 0xefff ? y : y-0x10000)
    if  @creation  then
      @cur=@curs.Cross
      @app.setCursor @cur
      if (shift&1) == 1  && @drugging then   #shift1: left button down
        # erase previous lines
        rect(@ox1,@oy1,@px1,@py1)
        # draw new lines
        rect(@ox1,@oy1,sx,sy)
        @px1 = sx ; @py1 = sy
      end
    elsif @moving    then
      if (shift&1) == 1 && @drugging then   #shift1: left button down
        rect(@px1-@xl,@py1-@yu,@px1+@xr,@py1+@yd)
        rect(sx-@xl,sy-@yu,sx+@xr,sy+@yd)
        @px1 = sx ; @py1 = sy
      end
    elsif @resizeALL then
      if (shift&1) == 1 && @drugging then   #shift1: left button down
        rect(@ox1,@oy1,@px1,@py1)
        rect(@ox1,@oy1,sx,sy)
        @px1 = sx ; @py1 = sy
      end
    elsif  @resizeLR  then
      if (shift&1) == 1 && @drugging then   #shift1: left button down
        rect(@ox1,@oy1,@px1,@y2)
        rect(@ox1,@oy1,sx,@y2)
        @px1 = sx ; @py1 = sy
      end
    elsif @resizeUD  then
      if (shift&1) == 1 && @drugging then   #shift1: left button down
        rect(@ox1,@oy1,@x2,@py1)
        rect(@ox1,@oy1,@x2,sy)
        @px1 = sx ; @py1 = sy
      end
    elsif  @focusExists
      if @x1 && @x2 && @y1 && @y2 then
        @app.setCursor( resizecursor(
                              (x-@x1).abs < 4 && @y2+4 > y && y > @y1-4,
                              (x-@x2).abs < 4 && @y2+4 > y && y > @y1-4,
                              (y-@y1).abs < 4 && @x2+4 > x && x > @x1-4,
                              (y-@y2).abs < 4 && @x2+4 > x && x > @x1-4 ))
      end
    else
      @app.setCursor @curs.Arrow
    end
  end

  def getFontName(c)
    f=c.sendMessage(WMsg::WM_GETFONT,0,0)
    f=f+0x100000000 if f < 0
    if f==0 then r="system"
    elsif @afont[f] then
      r=@afont[f].params[0]
    else
      r = "undefined"
    end
    r.to_s
  end

  def refreshInspect(c)
    return if c.class == FDCoverPanel
    c = self unless c
    r = nil
    el = []
    c.modules.each{|i|
      if j = FDModules::StdModules["#{i}".intern]
        el = el +j.events
      elsif j = FDModules::FormModules["#{i}".intern]
        el = el +j.events
      end
    } unless c.modules.empty?
    el << 'ownerdraw(iid,action,state,hwnd,hdc,left,top,right,bottom,data)' if
    c != self && c.owndraw && (c.owndraw > 0)
    if c!=self then
      r = findPalletItem(c)
      attrs = []
      r.attrs.each{|i|
        next if i.is_a?(Array)&&c.parent.is_a?(VRTabbedPanel)&&(i[0]=="style" || i[0]=="font")
        attrs <<
        if i.is_a?(Array) then
          [i[0],i[1].call(c),i[2]]
        else
          begin
            [i,c.instance_eval(i).to_s]
          rescue
            [i,c.substance.instance_eval(i).to_s]
          end
        end
      }
      if r then
        if r.events then
          @parent.inspectfrm.skip_ctrl_name = false
          el = r.events + el
          @parent.inspectfrm.evtList.setListStrings(el)
       else #e.g. menu,toolbar
          @parent.inspectfrm.skip_ctrl_name = true
          @parent.inspectfrm.evtList.setListStrings(c.eventList)
        end
      end
      @parent.inspectfrm.mthdList.setListStrings(r.mthds) if r

    else
      c = self
      a = c.windowrect
      attrs = [["name",c.name],["caption",c.caption],["x",a[0].to_s],
               ["y",a[1].to_s],["w",a[2].to_s],["h",a[3].to_s],
               ['sizebox',@frm_sizebox.to_s,:cbTF],
               ['maximizebox',@frm_maximizebox.to_s,:cbTF],
               ["font",@prFont.call(c),:none],
               ["style",@prStyle.call(c),:none],
               ["modules",@prModule.call(c),:btModule]]
      @parent.inspectfrm.evtList.setListStrings(el)
      @parent.inspectfrm.mthdList.setListStrings([])
    end
    s="#{c.name}:#{c.class}"
    i= @parent.inspectfrm.cbControl.findString(s)
    @parent.inspectfrm.cbControl.select(i)
    @parent.inspectfrm.setItems(attrs)
    @parent.inspectfrm.stb2.caption = ""
  end

  def setControlsList(c)
    c.each do |id,item|
      if item.respond_to?(:controls) then
        setControlsList(item.controls)
      end
      unless item.parent.is_a?(VRTabbedPanel) && item.is_a?(VRPanel)
        s="#{item.name}:#{item.class}"
        @parent.inspectfrm.cbControl.addString(s)
      end
    end
  end

  def refreshCntName
    @parent.inspectfrm.cbControl.clearStrings
    s="#{self.name}:#{self.class}"
    @parent.inspectfrm.cbControl.addString(s)
    setControlsList(@controls)
    @parent.inspectfrm.cbControl.select(
                            @parent.inspectfrm.cbControl.findString(s))
  end

  def moveC(c)
    if c.kind_of?(SWin::Window ) then
      a=c.windowrect
      c.move c.x , c.y , a[2] , a[3]
    end
  end

  def check_container(c,n = 1)
    c.name + "+" + n.to_s
    c.parent.parent.instance_eval("@#{c.name}")
    c.parent.parent.controls if c.parent.parent.kind_of? VRGroupbox
    if  c.parent.parent then
      if c.parent.parent.instance_eval("@#{c.name}") then
        r = true ; return(true)
      else
        r = check_container(c.parent,n+1)
      end
    end
    r
  end

  def updateCont(name,caption,x,y,w,h)
    if @focused then
      unless @focused.name == name then
        oldname=@focused.name.dup
        @focused.name=name
        @focused.parent.instance_eval("@#{name} = @#{oldname}")
        @focused.parent.instance_eval("@#{oldname} = nil")
        @names.delete(oldname)
        @names << name
        @focused.parent.update_items(oldname,name) if
                                     @focused.parent.respond_to? :update_items
        if @focused.respond_to?(:addControl) then
          @buff.gsub!(/\_#{oldname}/,"_#{name}") if @buff
        end
      end
      @focused.caption=caption
      @focused.move(x,y,w,h)
      setFocusRgn(@focused)
    else #if form
      oldname=self.name
      @buff.gsub!(/\_#{oldname}/,"_#{name}") if @buff
      self.name=name
      self.caption=caption
      move(x,y,w,h)
    end
    $modified += 1
    refreshCntName
    refreshInspect(@focused)
  end
  
  def save_window(cnt)
    it = cnt.items.dup if cnt.items
    r = {
    :type => cnt.class,
    :name => cnt.name,
    :caption => cnt.caption,
    :style => cnt.style,
    :x => cnt.x,
    :y => cnt.y,
    :w => cnt.w,
    :h => cnt.h,
    :id => cnt.etc,
    :hfont => cnt.sendMessage(WMsg::WM_GETFONT,0,0),
    :items => it,
    :mods => cnt.modules && cnt.modules.dup,
    :owndraw => cnt.owndraw,  
    :controls => [] }
    if cnt.respond_to?(:addControl) then
      cnt.controls.each{|i,c|
      r[:controls] << save_window(c) unless c.is_a? FDCoverPanel
      } unless cnt.controls == []
    end
    r
  end
  
  def saveandclosewindow(cnt)
    x0,y0,w0,h0 = cnt.windowrect
    it = cnt.items.dup if cnt.items
    r = {
    :type => cnt.class,
    :name => cnt.name,
    :caption => cnt.caption,
    :style => cnt.style,
    :x => cnt.x,
    :y => cnt.y,
    :w => w0,
    :h => h0,
    :id => cnt.etc,
    :hfont => cnt.sendMessage(WMsg::WM_GETFONT,0,0),
    :items => it,
    :mods => cnt.modules && cnt.modules.dup,
    :owndraw => cnt.owndraw,  
    :controls => [] }
    if cnt.respond_to?(:addControl) then
      cnt.controls.each{|i,c|
      r[:controls] << saveandclosewindow(c) unless c.is_a? FDCoverPanel
      } unless cnt.controls == []
    end
    cnt.terminate if cnt.respond_to?(:terminate)
    cnt.parent.deleteControl(cnt)
    cnt.parent.child_deleted(cnt) if cnt.parent.respond_to? :child_deleted
    #    cnt.parent.instance_eval "remove_instance_variable :@#{cnt.name}"
    r
  end

  def recreate1(c_parent,a,offset=[0,0],paste_mode=nil)
    item = findPalletItem(a[:type])
    if paste_mode then
      newname = get_serial_name(a[:name])
    else
      newname=a[:name]
    end
    x0=a[:x]+offset[0]
    y0=a[:y]+offset[1]
    c=c_parent.instance_eval("#{item.createMethod} c_parent,#{a[:type]},'#{newname}','#{a[:caption]}',#{x0},#{y0},#{a[:w]},#{a[:h]},#{a[:style]+a[:owndraw]},a[:items]")
    c_parent.child_created(c) if c_parent.respond_to? :child_created
    c.sendMessage(WMsg::WM_SETFONT,a[:hfont],0)
    c.modules = a[:mods]
    if c.is_a? VRTabbedPanel
      c.panels.each_index{|i|
        c.panels[i].extend(FDCommonMethod)
        c.panels[i].extend(FDParent).fd_parent_init
        c.panels[i].extend CreateCtrl
        a[:controls].find{|j| j[:name] == "panel#{i}"}[:controls].each{|j|
                                               recreate1(c.panels[i],j,[0,0],paste_mode)}
      }
    elsif c.is_a? VRRebar
      c.items.each{|i|
        recreate1(c,a[:controls].select{|j| j[:name]==i[0].sub(/^@/,'')}[0],[0,0],paste_mode)
      }
    elsif c.respond_to?(:addControl) then
      c.extend(FDCommonMethod)
      c.extend(FDParent).fd_parent_init
      c.extend CreateCtrl
      a[:controls].each{|i|
        recreate1(c,i,[0,0],paste_mode)
      } unless (a[:controls]).empty?
    end
    c
  end

  def recreateControl(cnt,parent = nil )
    parent = cnt.parent unless parent
    a = saveandclosewindow(cnt)
    @focused = recreate1(parent,a)
    refreshInspect(@focused)
  end

  def deleteCont
    if @focused then
      if @focused.respond_to? :addControl then
        @focused.delete_child_controls
      end
      par = @focused.parent
      @focused.terminate if @focused.respond_to? :terminate
      @focused.parent.deleteControl(@focused)
      par.child_deleted(@focused) if par.respond_to? :child_deleted
      delete_serial_name(@focused.name)
      @focused = nil
      @focusExists = false
      refresh
      refreshCntName
      refreshInspect(nil)
      $modified += 1
    end
  end
  
  def cutCont
    @copy_buff=[]
    @cut_mode=true
    @copy_buff << saveandclosewindow(@focused)
    @focused = nil
    @focusExists = nil
    refreshInspect(nil)
    refresh
  end
  
  def copyCont
    if @focused then
      @copy_buff=[]
      @copy_buff << save_window(@focused)
    end
  end
  
  def pasteCont
    unless @copy_buff.empty? then
      a=[]
      offset=[@selected_point.x-@copy_buff[0][:x],@selected_point.y-@copy_buff[0][:y]]
      if @paste_to && @paste_to.respond_to?(:addControl) then
        @copy_buff.each{|c| a << recreate1(@paste_to,c,offset,!@cut_mode)}
      elsif @paste_to then
        @copy_buff.each{|c| a << recreate1(@paste_to.parent,c,offset,!@cut_mode)}
      else
        @copy_buff.each_with_index{|c,i| a << recreate1(self,c,offset,!@cut_mode)}
      end
      @cut_mode=nil
      @focused=a[0]
      refreshCntName
      refreshInspect(@focused)
      setFocusRgn(@focused)
      @focusExists=true
      refresh
    end
  end
  
  def setWinStyle
    if @focused then
      @wsdlg.options["default"] = setWSArray(@focused.style)
      @wsdlg.options["default2"] = setWSOption(@focused.style)
      @wsdlg.move 0,0,104,195
      if r = @wsdlg.open(self) then
        ropt = r.shift
        st = ropt >= 0 ? wsArray2int(r) | ropt : wsArray2int(r)
        @focused.style = st
        recreateControl(@focused)
        $modified += 1
      end
    end
  end

  def _add_style(s2,style)
    a=[]
     s2.each{|i| i1 = i.dup
      s = style & $Style[@focused.class][:style][i1]
      a << [i1.to_s , ($Style[@focused.class][:style][i1] != s ? 0 : 1)]
    }
    a
  end

  def setWSOption(style)
    r = [0] ; a = [] ; n = 0
    if $Style[@focused.class] && $Style[@focused.class][:option] != {} then
      a1 = $Style[@focused.class][:option].dup.to_a.sort
      a1.each{|i|
        s = [i[0].dup,i[1]]
        r[0] = n if (style & 0x1f) == s[1]
        a << s
        n += 1
      }
     r += a
    end
    r
  end

  def setWSArray(style)
    a=[]
    s1 = $Style[:win].keys.dup
    s1.each{|i| s = i.dup
      a << [s.to_s,(($Style[:win][i] & style) == 0 ? 0 : 1)]
    }
    if $Style[@focused.class] then
      s2 = $Style[@focused.class][:style].keys.dup
      a = a + _add_style(s2,style)
    end
    a.sort
  end

  def wsArray2int(a)
    r =0
    a.each{|i|
      if w = $Style[:win][i[0]] then
        r = r | w * i[1]
      else
        c = $Style[@focused.class][:style][i[0]]
        r = r | c * i[1]
      end
    }
    r
  end

  def setModules
    if @focused then c=@focused else c=self end
    @moddlg.options["default"] = getModArray(c)
    @moddlg.move 0,0,104,195
    if r = @moddlg.open(self) then
      c.modules.clear
      r.each{|i|
        c.set_modules(eval(i[0])) if i[1] == 1
      }
      $modified += 1
    end
    refreshInspect(c)
  end

  def getModArray(c)
    r = []
    if c == self then
      FDModules::StdModules.each{|key,val|
        n = c.modules.include?(eval(key.to_s)) ? 1 : 0
        r << [key.to_s,n]
      }
      FDModules::FormModules.each{|key,val|
        n = c.modules.include?(eval(key.to_s)) ? 1 : 0
        r << [key.to_s,n]
      }
    else
      a = findPalletItem(c)
      a.mods.each{|key,val|
        n = c.modules.include?(eval(key.to_s)) ? 1 : 0
        r << [key.to_s,n]
        } if a
    end
    r
  end

  def showModDlg(a,w,h)
    @moddlg.options["default"]= a
    @moddlg.move 0,0,w,h
    if r=@moddlg.open(self) then
      $modified += 1
    end
    r
  end

  def changeFocuse(s)
    c = findCtrl(s)
    if c then
      @focused = c
      setFocusRgn(c)
      @focusExists=true
    else
      @focusExists=false
    end
    refreshInspect(c)
    refresh
  end

  def ctrl_setFont
    if @focused then
      c = @focused
      hf=c.sendMessage(WMsg::WM_GETFONT,0,0)
      hf=hf+0x100000000 if hf < 0
      if @afont[hf] then af=[@afont[hf].params,0,0] else af=nil end
      #af[0][1]=(af[0][1]*40/3).abs.to_i + 1 if af
      if f=chooseFontDialog(af) then
        ffont=setFontHash(f)
        c.sendMessage(WMsg::WM_SETFONT,ffont,0x10000)
        c.refresh
        x0,y0,w0,h0=c.windowrect
        c.move(c.x,c.y,w0,h0)
        setFocusRgn(c)
        $modified += 1
      end
    end
    refreshInspect(c)
  end

  def setValue(klass,val)
    klass = val
  end

  def setFontHash(f)
    
    unless  r=@afont.select{|k,v|
      f.fontface==v.params[0] &&
      f.height==v.params[1] &&
      f.style==v.params[2] &&
      f.weight==v.params[3] &&
      f.width==v.params[4] &&
      f.escapement==v.params[5] &&
      f.orientation==v.params[6] &&
      f.pitch_family==v.params[7] &&
      f.charset==v.params[8]
#      f.point==v.point &&
#      f.color==v.color
    }[0] then
      ffont=@screen.factory.newfont(f.fontface,f.height,f.style,
          (f.weight/100).to_i,f.width, f.escapement, f.orientation,
           f.pitch_family,f.charset)
      @afont[ffont.hfont]=ffont
      ffont.handle
    else
      r[0]
    end
  end
  
  def getFontHash(font_handle)
    @afont[font_handle]
  end
  
  def get_font_number(font_handle)
    return nil unless @afont[font_handle]
    unless n=@font_array.index(font_handle) then
      @font_array << font_handle
      @font_array.size-1
    else
      n
    end
  end
  
  def showArrayEditDlg(a,w,h)
    @arrydlg.move 0,0,w,h #204,200
    @arrydlg.options["default"] = a.gsub(/\n/,"\r\n").gsub(/\t/,'\t')
    if r=@arrydlg.open(self) then
      r.gsub(/\\t/,"\t").gsub(/\r\n/,"\n").to_s
    end
  end

  def setTrueFalse(str,svalue)
    if @focused then
      @focused.instance_eval("#{str}(#{svalue})")
    else #this form
      self.instance_eval "@frm_#{str}=svalue"
    end
  end
  
  def make_fonts_str(a)
    return  nil if a.empty?
    r = "[\n"
    a.each{|i|
      f=@afont[i].params.to_a
      f[0]="\'#{f[0]}\'"
      f[3]=f[3]/100
      r+="      @screen.factory.newfont(#{f.join(',')}),\n"}
    r[r.size-2,1]=""
    r+="    ]\n"
    r
  end
  
  def ex_header

    @modules.each{|m|
      if rq = FDModules::FormModules["#{m}".intern ] then
        (@required << rq.requires).uniq!
      elsif rq = FDModules::StdModules["#{m}".intern ] then
        (@required << rq.requires).uniq!
      end
    }
    @required.reject!{|i| !i}
    str="#{FDMsg::Caution}\n"
    @required.each{|s| str += "require 'vr/#{s}'\n"}
    str+="\n"
    str
  end

  def ex_module
    str = "module Frm_#{self.name}\n"
    str +=   "end \n\n"
    str
  end

  def ex_include
    r = ""
    @included.each{|s| r += "  include #{s} if defined? #{s}\n" if s} unless @included.empty?
    @modules.each{|s| r += "  include #{s}\n" if s} unless @modules.empty?
    r
  end

  def examine
    a=[]
    @cntnmodules=[]
    b=@controls.to_a
    b.reject!{|i| if i[1].is_a? FDContainer then a << i;true  else false end }
    a.concat b
    af=self.windowrect
    str = "\n  def _#{self.name}_init\n"
    n = str.size
    str += "    self.sizebox=#{@frm_sizebox}\n" if @frm_sizebox == 'false'
    str += "    self.maximizebox=#{@frm_maximizebox}\n" if @frm_maximizebox == 'false'
    str += "    self.caption = '#{self.caption}'\n"
    str += "    self.move(#{af[0]},#{af[1]},#{af[2]},#{af[3]})\n"
    a.each { |item|
      (@required << 'vrowndraw').uniq! if item[1].respond_to?(:owndraw) &&
                                                          item[1].owndraw > 0 
      target=item[1]
      if target.respond_to? :createSourceStr then
        cnt=item[1].to_s.sub(/\#\<([A-Za-z]+).*/,'\1')
        str += target.createSourceStr.to_s
      end
    }
    str += "  end \n\n"
    if s=make_fonts_str(@font_array) then str[n,0]="    $_#{self.name}_fonts="+s end
    str
  end

  def ex_construct(c)
    str =  "  def construct\n"
    str += "    _#{c.name}_init\n"
    str += "  end \n\n"
    str
  end

  def ex_footer
    "#VRLocalScreen.start Frm_#{self.name}\n"
  end

  def linscan(a,ptn)
    n = 0 ; r = nil
    while a.size-1 >= n do
      if a[n] =~ ptn then
        r = n+1 ; break
      end
      n += 1
    end
    r
  end

  def linscan2(a,ptn1,ptn2 = nil, n = 0)
    r = nil
    while a.size-1 >= n do
      if a[n] =~ ptn2 then
        break
      elsif a[n] =~ ptn1 then
        r = n+1 ; break
      end
      n += 1
    end
    r
  end

  def make_executive
    @buff1 = []
    #    if @buff == "" then
    s1 = examine
    s = ex_header
    s += @cntnmodules.join("") if @cntnmodules
    s += ex_module
    s.scan(/m\odule Frm_#{self.name}.*$/) 
    s = $` + $& + "\n" + ex_include + s1 + ex_construct(self) +
    $'.sub!(/^[\r\n]?/,"") 
    s += ex_footer
    s
  end

  def openfile(f)
    str = ""
    parser = FDParser.new(self)
    if f then
      r = true
#      begin
        open(f){|ff|
          $tstamp=ff.stat.mtime.to_i
          ff.each  do |lin|
            str+=lin
          end
        }
        @buff,@nodes,@variables = parser.parse str
        @modules = @nodes["modules"].collect!{|i| eval(i)}.delete_if{|j|
          j==VRMenuUseable || j==VRToolbarUseable
        }
        set_controls(self,@nodes)
        set_variables(@variables)
        refreshCntName
#      rescue
#        messageBox "\nIf you are not going to open the file of an old version\n" +
#                   "or you edited manually,then please contact me.\n\n#{$!}",
#                    "File Reading Error - #{f}",16
#        r = false
#      end
    end
    refreshInspect(nil)
    r
  end

  def set_controls(c_parent,nodes)
    if c_parent.is_a? VRTabbedPanel
      c_parent.panels.each{|i|
        no=nodes["childs"].select{|j| j["name"] =~ /#{i.name}$/}[0]
        set_controls(i,no)
      }
    end
    r=nil
    nodes["addings"].each{ |i|
      mtd=findPalletItem(i[0]).createMethod
      ctrl=instance_eval("#{mtd}(c_parent,*i)")
      @names << ctrl.name
      unless (f1 = nodes["fonts"]) == {} then
        if f2 = f1["@"+i[1]] then
          if f2.is_a? Integer then
            ctrl.setFont(@afont[@temp_fonts[f2].hfont])
          else #for old form file
            f = f2
#            ffont=@screen.factory.newfont(f.fontface,f.height,f.style,
#                (f.weight / 100),f.width, f.escapement, f.orientation,
#                f.pitch_family,f.charset,f.point,f.color)
            ffont=setFontHash(f)
            ctrl.setFont(@afont[ffont])
          end
        end
      end
      if ctrl.respond_to?(:addControl) && ctrl.class != FDContainer then
        ctrl.extend FDCommonMethod
        ctrl.extend(FDParent).fd_parent_init
        ctrl.extend CreateCtrl
#        r = nodes["childs"].select{|n| n["name"]=="Cntn_#{ctrl.name}"}[0]
        r = nodes["childs"].select{|n| n["name"]=~/Cntn\w*_#{ctrl.name}$/}[0]
        ctrl.modules = r["modules"].collect!{|i| eval(i)}.delete_if{|j|
          j==VRToolbarUseable || j==VRStdControlContainer ||
          j==VRComCtlContainer
        } if r
        set_controls(ctrl,r)
      else
        r = nodes["childs"].select{|n| n["name"]=~/Extn\w*_#{ctrl.name}/}[0]
        ctrl.modules = r["modules"].collect!{|i| eval(i)}.delete_if{|j|
                      j==VRToolbarUseable || j==VRStdControlContainer ||
                      j==VRComCtlContainer
        } if r
      end
      ctrl.parent.child_created(ctrl) if ctrl.parent.respond_to? :child_created
    }
  end

  def set_variables(variables)
    variables.each{|var,val|
      case var
      when 'sizebox','maximizebox'
        instance_eval "@frm_#{var}='#{val}'"
      when /^ctn_(\w+)/
        instance_eval "@#{$1}.move #{val[0]},#{val[1]},24,24"
        instance_eval "@#{$1}.set_attrs val[2,val.size-2]"
      else
      end
    }
  end

  def self_resize(x,y)
    x,y,w,h = self.clientrect
    @deleteObject.Call(@hrgn)
    @hrgn=@createRectRgn.Call(x,y,w,h)
    @selectClipRgn.Call(@dc,@hrgn)
    a=windowrect
    $ini.write "designform","top",a[0]
    $ini.write "designform","left",a[1]
    $ini.write "designform","width",a[2]
    $ini.write "designform","height",a[3]
    refreshInspect(nil)
  end

  def self_destroy
    if $modified > 0 then
      if messageBox("do you save this file?",
                                   "Close #{self.name}",0x04) == 6 then
         @parent.save_clicked
      end
    end
    #SWin::Application.removeAccelList(self)
    $ini.flash
    parent.formShow.checked = false
  end

end
