#!/bin/busybox sh
#
#

showUsage () {
  cat 1>&2 <<- EOUSG
	Usage: $0 [/path/to/imgdir] [ pNN ] [cNNN] [bNN]...
	  /path/to/imgdir : ($imgdir_a)
	  pNN : make password panel with line width NN
	  cNNN : make checker with unit NNN
	  bNN : make bull\'s eyes with unit NN
	EOUSG
  exit
}

imgdir=${FKSH_ONB:-/mnt/onboard/.fakesh}/images
imgdir_a=$imgdir
for i do
  case "$i" in
  /* ) imgdir_a="$i" ;;
  -*) showUsage ;;
  esac
done

wdir=$(mktemp -d /tmp/gspXXXXXX)
export TMPDIR=$wdir
cd $wdir
w=''
eval $(fbset | awk '
  $1=="geometry"{printf "w=%d; h=%d; bpp=%d;", $2, $3, $6;}')
[ -n "$SCREENSHOT_FB_PARAMS" ] && eval "$SCREENSHOT_FB_PARAMS"
[ -z "$bpp" ] && exit 1
opp=$((bpp/8))

# catNmult n1 _file1_ [ _n2_ _file2_ ... ]
catNmult () {
  local n e ee eee
  e=`mktemp`
  ee=`mktemp`
  while [ $# -ge 2 ] ; do
    n=$1
    case "$n" in # for speed up ; ternary is best 
    0) ;;
    1) cat "$2" ;;
    2) cat "$2" "$2" ;;
    3) cat "$2" "$2" "$2" ;;
    *)
      cat "$2" > $e
      while [ $n -gt 0 ] ; do
        case $((n%3)) in
        1) cat $e ;;
        2) cat $e $e ;;
        esac
        n=$(($n/3))
        cat $e $e $e > $ee
        eee=$e; e=$ee; ee=$eee # exchange
      done
    ;;
    esac
    shift 2
  done
  rm -f $e $ee
}

## usage1: onb
#    return true if "/mnt/onboard" is mounted, false otherwise.
## usage2: onb arg1 arg2
#   wait until "/mnt/onboard" is mounted, then mv arg1 arg2
onb () {
  local d
  if [ $# -eq 0 ] ; then
    grep -Eq '^ *[^ ]+ +/mnt/onboard +[^ ]+ +rw,' /proc/mounts
    return
  fi
  [ -f "$1" ] || return
  touch "$1"  #  for good looking on sorting by time
  d="${2%/*}"
  while : ; do
    grep -Eq '^ *[^ ]+ +/mnt/onboard +[^ ]+ +rw,' /proc/mounts && break
    usleep 100000  # 100ms
  done
  [ -d "$d" ] || mkdir -p "$d"
  [ -f "$2" ] && return 
  mv "$1" "$2"
  return 0
}

rv='\0\377 \377\0'

imga=$imgdir/allWhite.raw.gz
imgb=$imgdir/allBlack.raw.gz 
if [ ! -s $imga -o ! -s $imgb ] && onb ; then
  dd if=/dev/zero of=rawb bs=$((w*opp)) count=$h >/dev/null 2>&1
  tr $rv < rawb | gzip -9 > rawa.gz
  gzip -f -9 rawb
  onb rawa.gz $imga
  onb rawb.gz $imgb
fi

dd if=/dev/zero of=pixB bs=$opp count=1 >/dev/null 2>&1
tr $rv < pixB > pixW

## genPwFrame lineWidth bgPix fgPix
# make password panel frame
#+---+---+---+
#| 7 | 8 | 9 |
#+---+---+---+
#| 4 | 5 | 6 |
#+---+---+---+
#| 1 | 2 | 3 |
#+---+-------+
#| 0 |  Ent  |
#+---+-------+
#
#+---+---+---+---+
#|   |   |   |   |
#+---+---+---|   |
#|   |   |   |   |
#+---+---+---+---+
#|   |   |   |   |
#+---+---+---+---+
#
genPwFrame () {
  local lw a b wcb ww wlw hnw hcw
  lw=$1 # line width
  a=$2  # white pix
  b=$3  # black pix
  ww=$(( (w-3*lw)/4 )) # width of white area
  wcb=$(( 3*(ww+lw) )) # width of common black area
  wlw=$((w-wcb)) # width of last white area
  catNmult $ww $a $lw $b\
           $ww $a $lw $b\
           $ww $a $lw $b\
           $wlw $a > WbWbWbW
  catNmult $wcb $b $wlw $a > bbbbbbW
  catNmult $w $b > bbbbbbb
  hnw=$(( (h-2*lw+2)/3 )) # height of non-center white area
  hcw=$(( h-2*(hnw+lw) )) # height of center white area
  catNmult $hcw WbWbWbW\
           $lw  bbbbbbW\
           $hnw WbWbWbW\
           $lw  bbbbbbb\
           $hcw WbWbWbW
  rm -f WbWbWbW bbbbbbW bbbbbbb
}

mkPwFrame () {
  local pwf imga imgb
  pwf="$(printf %s/pwFrames/%02d "$imgdir" $1)"
  imga="${pwf}a.raw.gz"
  imgb="${pwf}b.raw.gz"
  [ -s "$imga" -a -s "$imgb" ] && return
  onb || return 0
  genPwFrame $1 pixW pixB > rawa
  tr $rv < rawa | gzip -9 > rawb.gz
  gzip -f -9 rawa
  onb rawa.gz "$imga"
  onb rawb.gz "$imgb"
}

genCheckerSUB () {
  local n l m r1 r2 tmp a b
  n=$1 # unit size
  l=$2 # length
  m=$((l/n-1))
  r2=$((l%n))
  # $3 # pat center
  # $4 # pat
  if [ $m -lt 0 ] ; then
    catNmult $l $3
    return
  fi
  if [ $((m%2)) -eq 0 ] ; then
    m=$((m/2))
    r1=$((r2/2))
    r2=$((r2-r1))
  else
    m=$((m/2))
    r1=$((r2+n))
    r2=$((r1/2))
    r1=$((r1-r2))
  fi
  if [ $((m%2)) -eq 0 ] ; then
    a=$3; b=$4
  else
    a=$4; b=$3
  fi
  tmp=`mktemp`
  catNmult $n $a $n $b > $tmp
  catNmult $r1 $b \
           $m  $tmp \
           $n  $a \
           $r2 $b
  rm -f $tmp
}

genChecker () {
  local n a b
  n=$1
  a=`mktemp`
  b=`mktemp`
  genCheckerSUB $n $w $2 $3 > $a
  tr $rv < $a > $b
  genCheckerSUB $n $h $a $b
  rm -f $a $b
}

mkCheckers () {
  local ck imga imgb
  ck="$(printf %s/checkers/%03d "$imgdir" $1)"
  imga="${ck}a.raw.gz"
  imgb="${ck}b.raw.gz"
  [ -s "$imga" -a -s "$imgb" ] && return
  onb || return 0
  genChecker $1 pixW pixB > rawa
  tr $rv < rawa | gzip -9 > rawb.gz
  gzip -f -9 rawa
  onb rawa.gz "$imga"
  onb rawb.gz "$imgb"
}

# arg: u unit
b_awkcmd="BEGIN{
  w=$w;
  h=$h;
  opp=$opp;
  x0=w/2;
  y0=h/2;
  for (y=0; y<h; y++) {
    for (x=0; x<w; x++) {
      r=sqrt((x-x0)^2+(y-y0)^2)/u;
      rr=int(r%4);
      for (i=0; i<opp; i++) { printf \"%d\", rr; }
    }
  }
}"

mkBullsEyes () {
  local ble img0 img1 img2 img3
  ble="$(printf %s/bullseyes/%02d "$imgdir" $1)"
  img0="${ble}0.raw.gz"
  img1="${ble}1.raw.gz"
  img2="${ble}2.raw.gz"
  img3="${ble}3.raw.gz"
  [ -s "$img0" -a -s "$img1" -a -s "$img2" -a -s "$img3" ] && return
  onb || return 0
  awk -v u=$1 "$b_awkcmd" </dev/null > raw
  tr 0123 \\377\\000\\000\\377 < raw | gzip -9 > raw0.gz
  tr 0123 \\377\\377\\000\\000 < raw | gzip -9 > raw1.gz
  tr 0123 \\000\\377\\377\\000 < raw | gzip -9 > raw2.gz
  tr 0123 \\000\\000\\377\\377 < raw | gzip -9 > raw3.gz
  rm -f raw
  onb raw0.gz "$img0"
  onb raw1.gz "$img1"
  onb raw2.gz "$img2"
  onb raw3.gz "$img3"
}

################

mkPwFrame 16
mkCheckers 32

################

imgdir="$imgdir_a"
for i do
  case "$i" in
  p00) continue ;;
  p[1-9]| p[0-9][0-9] )
    n=${i#?}; n=${n#0}
    [ $n -ne 0 ] && mkPwFrame $n
  ;;
  c00 | c000 ) continue ;;
  c[1-9] | c[0-9][0-9] | c[0-9][0-9][0-9] )
    n=${i#?}; n=${n#00}; n=${n#0}
    mkCheckers $n
  ;;
  b00) continue ;;
  b[1-9]| b[0-9][0-9] )
    n=${i#?}; n=${n#0}
    [ $n -ne 0 ] && mkBullsEyes $n
  ;;
  esac
done

cd /tmp
rm -rf $wdir

exit
