#!/bin/busybox sh

## parse fakesh.conf
cd /

[ -f "$FKSH_ONB/fakesh.conf" ] || exit 0
# defaults
httpdOpts=''
httpd_home=''
homePage='http%253A%252F%252Flocalhost%252F='
minFreeKB=''   # default=8192 is set in "/etc/init.d/rcS"
swappiness=''  # default=60%
sedCnv='s/#.*//;
  s/  *//g;
  s/\\\\/\\134/g;
  s/\\40/ /g;
  s/\\134/\\/g;'
sedUri='s@:@%3A@g;
  s@/@%2F@g;
  s@=@%3D@g;
  s@\?@%3F@g;
  s@%@%25@g;' ## this format may have a bug.
sedDec='s/ +//g;/[^0-9]/q;s/^0+(.)/\1/;p;' # sed -n -r
while read -r v ; do
  v="$(printf '%s' "$v" | sed "$sedCnv")"
  k="${v%%:*}"; v="${v#*:}"
  case "$k" in
  fakesh_type) fakesh_type="$v" ;;
  logging) logging="$v" ;;
  hostname) [ "$(hostname)" = "$v" ] || hostname "$v" ;;
  httpd_home) httpd_home="$v" ;;
  httpd_home_page) homePage="$(printf '%s' "$v" | sed "$sedUri" )=" ;;
  telnetd) telnetd="$v" ;;
  otherDaemons) otherDaemons="$v" ;;
  minFreeKB) minFreeKB="$(printf '%s' "$v" | sed -n -r "$sedDec" )" ;;
  swap*) swappiness="$(printf '%s' "$v" | sed -n -r "$sedDec" )" ;;
  esac
done < $FKSH_ONB/fakesh.conf

# logging
if [ -f $FKSH_LOG ] ; then
  mv -f $FKSH_LOG $FKSH_LOG.tmp
  cat $FKSH_LOG.tmp >> $FKSH_ONB/log.txt
  rm -f $FKSH_LOG.tmp
fi
case "$logging" in
[Oo][Nn] | 1 | [Tt][Rr][Uu][Ee] ) : > $FKSH_LOG ;;
esac

# minFreeKB
[ -n "$minFreeKB" ] && echo $minFreeKB > /proc/sys/vm/min_free_kbytes

# swappiness
[ -n "$swappiness" ] && [ $swappiness -le 100 ] &&
  echo $swappiness > /proc/sys/vm/swappiness

# kernel panic (secs)
echo '15' > /proc/sys/kernel/panic

## close almost file descripters
for fdp in /proc/$$/fd/* ; do
  [ -e "$fdp" -o -L "$fdp" ] || continue
  fd=${fdp##*/}
  case "$fd" in
  0|1|2 ) ;;
  *) eval "exec $fd<&- $fd>&-" ;;
  esac
done

# httpd
if [ ! -f $FKSH_RAM/httpd ] ; then
  ln -sf /bin/busybox $FKSH_RAM/httpd
fi
killall httpd
if [ -n "$httpd_home" ] ; then
  [ -d "$httpd_home" ] || mkdir -p "$httpd_home"
  $FKSH_RAM/httpd -h "$httpd_home" &
  if [ ! -f "$httpd_home/index.html" ] ; then
    ## that's none of my business?
    cat > "$httpd_home/index.html" <<- 'EOindex_html'
	<html><body>
	<h1 align="center">Kobo httpd works!</h1>
	</body></html>
	EOindex_html
  fi
  eReaderConf='/mnt/onboard/.kobo/Kobo/Kobo eReader.conf'
  if [ -f "$eReaderConf" -a -n "$homePage" ] &&
        ! grep -q -F "$homePage" "$eReaderConf" ; then
    tmpRDC=`mktemp`
    awk -v homePage="$homePage" 'BEGIN{addNext=0;}
      addNext&&/^\[BROWSER_FAVOURITES_GROUP]/{
        print; print homePage; addNext=0; next;
      }
      addNext&&/^\[/{
        printf "[BROWSER_FAVOURITES_GROUP]\n%s\n\n", homePage;
        print; addNext=0; next;
      }
      /^\[ApplicationPreferences]/{addNext=1;}
      {print;}' "$eReaderConf" > $tmpRDC
    cat $tmpRDC > "$eReaderConf"
    rm -f $tmpRDC
  fi
fi &

# telnetd
: ${FKSH_RAM:=$FKSH_HOM/ram}
case "$telnetd" in
[Oo][Nn] | 1 | [Tt][Rr][Uu][Ee] )
  if [ ! -f $FKSH_RAM/telnetd ] ; then
    ln -sf /bin/busybox $FKSH_RAM/telnetd
    $FKSH_RAM/telnetd >/dev/console </dev/console &
  fi
;;
*)
  [ -f $FKSH_RAM/telnetd ] && killall telnetd
  ln -sf telnetd $FKSH_RAM/telnetd
;;
esac &

[ -x "$otherDaemons" ] && "$otherDaemons" &

## TODO
# uninstall, disable
# chage fakesh_type
exit 0
