#!/bin/busybox sh
#
# Usage: autoUpdateSQL.sh | sqlite3 /mnt/onboard/.kobo/KoboReader.sqlite
#

dbDir=$FKSH_ONB/db
[ -d $dbDir ] || exit 0

[ -f $dbDir/before.sql ] && cat $dbDir/before.sql # for pragma etc.

# echo 'DROP TABLE fakesh;'
cat << 'EoSQL1'
CREATE TABLE IF NOT EXISTS fakesh (
  uuid TEXT PRIMARY KEY NOT NULL,
  ContentID TEXT,
  curPage TEXT,
  is_cur INTEGER,
  vol_ID TEXT,
  since_epoch INTEGER,
  ReadStatus INTEGER,
  ___PercentRead INTEGER
);
UPDATE fakesh SET is_cur=0
;
DROP TRIGGER IF EXISTS current_page;
CREATE TRIGGER current_page BEFORE UPDATE ON content
    WHEN new.ContentType='6' BEGIN
UPDATE fakesh SET
  curPage=substr(new.ChapterIDBookmarked,length(new.ContentID)+1),
  since_epoch=strftime('%s','now'),
  ReadStatus=new.ReadStatus,
  ___PercentRead=new.___PercentRead
WHERE fakesh.ContentID==new.ContentID AND fakesh.is_cur
  AND new.ContentID==substr(new.ChapterIDBookmarked,1,length(new.ContentID));
UPDATE OR REPLACE content SET
  DateLastRead=strftime('%Y-%m-%dT%H:%M:%SZ',
      strftime('%s',ifnull(DateLastRead,strftime('%s','now')))%12622780800
      +12622780800*(SELECT Rating FROM ratings
        WHERE ratings.ContentID==content.ContentID),
    'unixepoch')
WHERE -- ContentID==new.ContentID AND
  content.ContentID IN (SELECT ContentID FROM ratings WHERE Rating NOTNULL);
END
;
/*
DROP TRIGGER IF EXISTS current_page_a;
CREATE TRIGGER current_page_a AFTER UPDATE ON content
UPDATE OR REPLACE content SET
  DateLastRead=strftime('%Y-%m-%dT%H:%M:%SZ',
      strftime('%s',ifnull(DateLastRead,strftime('%s','now')))%12622780800
      +12622780800*(SELECT Rating FROM ratings
        WHERE ratings.ContentID==content.ContentID),
    'unixepoch')
WHERE -- ContentID==new.ContentID AND
  content.ContentID IN (SELECT ContentID FROM ratings WHERE Rating NOTNULL);
END
;
*/
DROP TRIGGER IF EXISTS auto_update;
CREATE TRIGGER auto_update AFTER INSERT ON content
    WHEN new.ContentType=='6' BEGIN
UPDATE content SET
  ChapterIDBookmarked=new.ContentID||(SELECT fakesh.curPage FROM fakesh
      WHERE new.ContentID==fakesh.ContentID),
  DateLastRead=strftime('%Y-%m-%dT%H:%M:%SZ',
      (SELECT fakesh.since_epoch FROM fakesh
          WHERE new.ContentID==fakesh.ContentID)
        +12622780800*ifnull((SELECT Rating FROM ratings
            WHERE ratings.ContentID==new.ContentID),0),
      'unixepoch'),
  FirstTimeReading='false',
  ReadStatus=(SELECT fakesh.ReadStatus FROM fakesh
    WHERE new.ContentID==fakesh.ContentID),
  ___PercentRead=(SELECT fakesh.___PercentRead FROM fakesh
    WHERE new.ContentID==fakesh.ContentID)
WHERE ContentID==new.ContentID AND ContentID IN (SELECT
  fakesh.ContentID FROM fakesh WHERE fakesh.is_cur AND fakesh.curPage NOTNULL)
;
UPDATE content SET
  Title='# DELETE ME '||replace(substr(ContentID,-6,2),'e',' '),
  Publisher='fakesh',
  DateLastRead='2000-01-01T01:01:01Z',
  FirstTimeReading='false',
  ReadStatus='2',
  ___SyncTime='2000-01-01T01:01:01Z',
  ___PercentRead='100',
  Language='en',
  IsSocialEnabled='false'
WHERE
  ContentID GLOB 'file:///mnt/onboard/drawings/picture*.png'
;
UPDATE content SET
  Title='',
  Attribution='Edit and Save and UpdateDB',
  DateLastRead='1999-11-11T11:11:11Z',
  ___SyncTime='1999-11-11T11:11:11Z'
WHERE
  ContentID=='file:///mnt/onboard/drawings/picture.png'
;
EoSQL1

uuid_tbl=$(mktemp /tmp/uuidTBL_XXXXXX)

sedESC="s/$(printf \\r)//g;"'s/^ *\([^= ]*\) *= */\1=/;s/%/%%/g'
sqlWhere="\nWHERE (ContentID==new.ContentID
    OR new.ContentID GLOB 'file:///mnt/onboard/drawings/picture*.png')
  AND ContentID=='file://%s'"
addUPD () {
  local kmt tbl tbl_new icode uuid sqlEscPath
  kmt="$(printf "$1")"
  [ -z "$kmt" ] && return 0
  [ -f "$kmt" ] || return 0
  rm -f "${kmt%.*}.kmo"
  [ -f "${kmt%.*}" ] || return 0
  # the next may fails if microSD is read-only mounted.
  grep -q '^ *#uuid ' "$kmt" ||
    printf '\n#uuid %s\n' $(dbus-uuidgen) >> "$kmt"
  tbl=''; uuid=''; icode='EUC-JP'
  sqlEscPath="$(printf %s "$kmt"| sed "s/'/''/g")"
  sqlEscPath="${sqlEscPath%.*}"
  while read -r l ; do
    case "$l" in
    '-- '*)
      icode="$(printf %s "${l#* }"| awk '{printf "%s", $1}')"
      continue
    ;;
    '#uuid '*)
      uuid="${l#* }"; uuid="${uuid#    }"; uuid="${uuid#  }"
      uuid="${uuid# }"; uuid="${uuid%% *}"
      continue
    ;;
    [!A-Za-z_]* ) continue ;;
    s.*=*) tbl_new=content_settings; l="${l#s.}" ;;
    *=*) tbl_new=content ;;
    *) continue ;;
    esac
    l="$(printf '%s' "$l" |
      iconv -f $icode -t UTF-8//TRANSLIT |
      sed "$sedESC")X"
    if [ "$tbl" != "$tbl_new" ] ; then
      [ -n "$tbl" ] && printf "$sqlWhere;\n" "$sqlEscPath"
      tbl=$tbl_new
      printf "UPDATE %s SET\n  ${l%?}" "$tbl" # use "\"-escape of "printf"
    else
      printf ",\n  ${l%?}"
    fi
  done < "$kmt"
  [ -n "$uuid" ] && printf '%s %s\n' "$uuid" "$1" >> $uuid_tbl
  [ -n "$tbl" ] && printf "$sqlWhere\n;\n" "$sqlEscPath"
}

tmpScr=$(mktemp /tmp/updTmp_XXXXXXX)
find /mnt/onboard /mnt/sd -type f -not -path '*/.*/*' \
  -name '*.kmt' -print0 | od -v -A n -t u1 --width=1 |
  awk 'BEGIN{printf "addUPD '\''";}
   $1==0{printf "'\''\naddUPD '\''"; next;}
   $1<=39||$1==92{printf "\\%03o", $1;next;}
   {printf "%c", $1}
   END{printf "'\''\n"}' > $tmpScr

sedMcSD='\@^/dev/mmcblk1p1:@{
s/^.*L="//;
s/"[^"]*"/,/;
s/".*$//;
s/[^-,\.0-9A-Za-z_]//g;
p;q;}'
mcSDid="$(blkid </dev/null| sed -n "$sedMcSD")"
if [ -z "$mcSDid" ] ; then
  mcSDid='_____'
  . $tmpScr 2>/dev/null
else
  /root/bin/StopNickel.sh
  sdMtSt="$(awk '$2=="/mnt/sd"{printf ",%s,", $4}' /proc/mounts)"
  case "$sdMtSt" in *,ro,*) mount -o remount,rw /mnt/sd ;; esac
  . $tmpScr 2>/dev/null
  case "$sdMtSt" in *,ro,*) mount -o remount,ro /mnt/sd ;; esac
  /root/bin/ContNickel.sh
fi

rm -f $tmpScr
cat << 'EoSQL2'
END;
REPLACE INTO content (ContentID,ContentType,MimeType,___UserID)
  VALUES ('///onboard/drawings/picture.png',6,'_','_');
DELETE FROM content WHERE ContentID=='///onboard/drawings/picture.png';
EoSQL2


while read -r uuid p ; do
  case "$p" in
  /mnt/onboard/*) vol_ID='onb' ;;
  /mnt/sd/*)  vol_ID="$mcSDid" ;;
  esac
  p="$(printf "$p"| sed "s/'/''/g")"
  p="file://${p%.*}" # remove .kmt
  cat <<- EoRegUUID
	INSERT OR IGNORE INTO fakesh (uuid) VALUES ('$uuid');
	UPDATE fakesh SET
	  ContentID='$p',
	  is_cur=1, vol_ID='$vol_ID'
	WHERE uuid=='$uuid';
	EoRegUUID
done < $uuid_tbl
rm -f $uuid_tbl

read ut < /sys/class/rtc/rtc0/since_epoch
ut=$((ut-15*24*60*60))  # 15days
cat << EoSQL3
UPDATE fakesh SET
  since_epoch=strftime('%s','now')
WHERE since_epoch ISNULL;
DELETE FROM fakesh WHERE since_epoch<$ut
  AND vol_ID IN ('onb','$mcSDid');
EoSQL3

[ -f $dbDir/after.sql ] && cat $dbDir/after.sql

exit
