/*
 * Created on 2003/08/18
 *
 * To change this generated comment go to
 * Window>Preferences>Java>Code Generation>Code Template
 */
package org.F11.scada.tool.timeset;

import java.util.Calendar;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.F11.scada.EnvironmentManager;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.validator.DynaValidatorForm;

/**
 * @author hori
 */
public class ContinueAction extends Action {

	/*
	 * (non-Javadoc)
	 *
	 * @see org.apache.struts.action.Action#execute(org.apache.struts.action.
	 * ActionMapping, org.apache.struts.action.ActionForm,
	 * javax.servlet.http.HttpServletRequest,
	 * javax.servlet.http.HttpServletResponse)
	 */
	public ActionForward execute(ActionMapping mapping,
			ActionForm form,
			HttpServletRequest request,
			HttpServletResponse response) throws Exception {
		Calendar cal = Calendar.getInstance();
		setForm(cal, form);

		Boolean isTestMode =
			Boolean
				.valueOf(
					EnvironmentManager.get(
						"/server/systemtime/testMode",
						"false")).booleanValue();
		int minuteMin =
			Integer.parseInt(EnvironmentManager.get(
				"/server/systemtime/miunteMin",
				"6"));
		int minuteMax =
			Integer.parseInt(EnvironmentManager.get(
				"/server/systemtime/miunteMax",
				"54"));

		request.setAttribute("minuteMax", minuteMax);
		request.setAttribute("minuteMin", minuteMin);
		return isOpenDialog(cal, isTestMode, minuteMin, minuteMax) ? mapping
			.findForward("continue") : mapping.findForward("error");
	}

	private void setForm(Calendar cal, ActionForm form) {
		DynaValidatorForm actionForm = (DynaValidatorForm) form;
		actionForm.set("year", cal.get(Calendar.YEAR) + "");
		actionForm.set("month", cal.get(Calendar.MONTH) + "");
		actionForm.set("hiddenMonth", cal.get(Calendar.MONTH));
		actionForm.set("day", cal.get(Calendar.DATE) + "");
		actionForm.set("hour", cal.get(Calendar.HOUR_OF_DAY) + "");
		actionForm.set("minute", cal.get(Calendar.MINUTE) + "");
		actionForm.set("second", cal.get(Calendar.SECOND) + "");
	}

	private boolean isOpenDialog(Calendar cal,
			Boolean isTestMode,
			int minuteMin,
			int minuteMax) {
		int minute = cal.get(Calendar.MINUTE);
		return isTestMode || (minuteMin <= minute && minute <= minuteMax);
	}

}
