/*
 * =============================================================================
 * Projrct F-11 - Web SCADA for Java
 * Copyright (C) 2002 Freedom, Inc. All Rights Reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */

package org.F11.scada.tool.sound.individual;

import java.util.List;

public interface IndividualDao {
	public static final Class BEAN = IndividualDto.class;

	/**
	 * s2pagergpitem_tableVXẽACeIndividualDtõXgŕԂ܂B
	 * 
	 * @param dto y[W[dto
	 * @return s2pagergpitem_tableVXẽACeIndividualDtõXgŕԂ܂B
	 */
	List findAllItem(IndividualCondition dto);

	public static final String findAllItem_ARGS = "dto";

	/**
	 * item_tableŎw肵ACeIndividualDtoŕԂ܂B
	 * 
	 * @param provider voC_
	 * @param holder z_
	 * @return Ŏw肵ACeIndividualDtoŕԂ܂B
	 */
	IndividualDto getItem(String provider, String holder);

	public static final String getItem_ARGS = "provider, holder";

	/**
	 * Ŏw肵ACěx^CvXV܂B
	 * 
	 * @param dto xDto
	 * @return XVR[hB
	 */
	int updateIndividual(IndividualDto dto);

	/**
	 * Ŏw肵ACěx^Cv}܂B
	 * 
	 * @param dto xDto
	 * @return }R[hB
	 */
	int insertIndividual(IndividualDto dto);

	public static final String insertIndividual_NO_PERSISTENT_PROPS =
		"alarmIndividualSettingId";

	/**
	 * 
	 * @param provider
	 * @param holder
	 * @return
	 */
	IndividualDto selectIndividual(String provider, String holder);

	public static final String selectIndividual_QUERY =
		"provider = ? AND holder = ?";

	/**
	 * ̃ACeIndividualDtõXgŕԂ܂B
	 * 
	 * @param attibute o鑮
	 * @return ACeIndividualDtõXgŕԂ܂B
	 */
	List<IndividualDto> getItems(int attibute);

	public static final String getItems_ARGS = "attibute";
}
