/*
 * Created on 2003/10/09
 *
 * To change this generated comment go to
 * Window>Preferences>Java>Code Generation>Code Template
 */
package org.F11.scada.tool.alist.history;

import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.SimpleDateFormat;

/**
 * @author hori
 */
public class HistoryRecordBean {
	private static final Timestamp epoch = new Timestamp(0);
	private static final DateFormat df =
		new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");

	private String alarm_color;
	private Timestamp ondate;
	private Timestamp offdate;
	private String unit;
	private String p_name;
	private String att_name;
	private String message;
	private String histry_check;
	private String attribute1;
	private String attribute2;
	private String attribute3;

	/**
	 *
	 */
	public HistoryRecordBean(
			String alarm_color,
			Timestamp ondate,
			Timestamp offdate,
			String unit,
			String p_name,
			String att_name,
			String message,
			String histry_check) {
		this.alarm_color = alarm_color;
		this.ondate = ondate;
		this.offdate = offdate;
		this.unit = unit;
		this.p_name = p_name;
		this.att_name = att_name;
		this.message = message;
		this.histry_check = histry_check;
	}

	public HistoryRecordBean() {
		this.ondate = epoch;
		this.offdate = epoch;
	}

	/**
	 * @return
	 */
	public String getAlarm_color() {
		return alarm_color;
	}

	/**
	 * @return
	 */
	public String getAtt_name() {
		return att_name;
	}

	/**
	 * @return
	 */
	public String getMessage() {
		return message;
	}

	/**
	 * @return
	 */
	public String getP_name() {
		return p_name;
	}

	/**
	 * @return
	 */
	public String getUnit() {
		return unit;
	}

	/**
	 * @param string
	 */
	public void setAlarm_color(String string) {
		alarm_color = string;
	}

	/**
	 * @param string
	 */
	public void setAtt_name(String string) {
		att_name = string;
	}

	/**
	 * @param string
	 */
	public void setMessage(String string) {
		message = string;
	}

	/**
	 * @param string
	 */
	public void setP_name(String string) {
		p_name = string;
	}

	/**
	 * @param string
	 */
	public void setUnit(String string) {
		unit = string;
	}

	/**
	 * @return
	 */
	public String getOffdate() {
		if (epoch.equals(offdate))
			return "";
		return df.format(offdate);
	}

	public Timestamp getOffdateTime() {
		return offdate;
	}

	/**
	 * @return
	 */
	public String getOndate() {
		if (epoch.equals(ondate))
			return "";
		return df.format(ondate);
	}

	public Timestamp getOndateTime() {
		return ondate;
	}

	/**
	 * @param timestamp
	 */
	public void setOffdate(Timestamp timestamp) {
		if (timestamp == null) {
			offdate = epoch;
		} else {
			offdate = timestamp;
		}
	}

	/**
	 * @param timestamp
	 */
	public void setOndate(Timestamp timestamp) {
		if (timestamp == null) {
			ondate = epoch;
		} else {
			ondate = timestamp;
		}
	}

	/**
	 * @return
	 */
	public String getHistry_check() {
		return histry_check;
	}

	/**
	 * @param string
	 */
	public void setHistry_check(String string) {
		histry_check = string;
	}

	public String getAttribute1() {
		return attribute1;
	}

	public void setAttribute1(String attribute1) {
		this.attribute1 = attribute1;
	}

	public String getAttribute2() {
		return attribute2;
	}

	public void setAttribute2(String attribute2) {
		this.attribute2 = attribute2;
	}

	public String getAttribute3() {
		return attribute3;
	}

	public void setAttribute3(String attribute3) {
		this.attribute3 = attribute3;
	}

}
