/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.dbcp.impl;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.sql.ConnectionEventListener;
import javax.sql.XAConnection;
import javax.transaction.xa.XAResource;
import org.seasar.extension.dbcp.impl.DBXAResourceImpl;

public class XAConnectionImpl
implements XAConnection {
    private Connection connection_;
    private XAResource xaResource_;
    private List _listeners = new ArrayList();

    public XAConnectionImpl(Connection connection) {
        this.connection_ = connection;
        this.xaResource_ = new DBXAResourceImpl(connection);
    }

    public XAResource getXAResource() {
        return this.xaResource_;
    }

    public Connection getConnection() throws SQLException {
        return this.connection_;
    }

    public void close() throws SQLException {
        if (this.connection_ == null) {
            return;
        }
        if (!this.connection_.isClosed()) {
            this.connection_.close();
        }
        this.connection_ = null;
    }

    public synchronized void addConnectionEventListener(ConnectionEventListener listener) {
        this._listeners.add(listener);
    }

    public synchronized void removeConnectionEventListener(ConnectionEventListener listener) {
        this._listeners.remove(listener);
    }
}

