/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.backport.java.util.concurrent.helpers;

import edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;
import edu.emory.mathcs.backport.java.util.concurrent.helpers.Utils;
import java.util.Collection;

public abstract class WaitQueue {
    public abstract void insert(WaitNode var1);

    public abstract WaitNode extract();

    public abstract boolean hasNodes();

    public abstract int getLength();

    public abstract Collection getWaitingThreads();

    public abstract boolean isWaiting(Thread var1);

    public static interface QueuedSync {
        public boolean recheck(WaitNode var1);

        public void takeOver(WaitNode var1);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static class WaitNode {
        boolean waiting;
        WaitNode next;
        final Thread owner;

        public Thread getOwner() {
            return this.owner;
        }

        public synchronized boolean signal(QueuedSync sync) {
            boolean signalled = this.waiting;
            if (signalled) {
                this.waiting = false;
                this.notify();
                sync.takeOver(this);
            }
            return signalled;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public synchronized boolean doTimedWait(QueuedSync sync, long nanos) throws InterruptedException {
            if (sync.recheck(this) || !this.waiting) {
                return true;
            }
            if (nanos <= 0L) {
                this.waiting = false;
                return false;
            }
            long deadline = Utils.nanoTime() + nanos;
            try {
                while (true) {
                    TimeUnit.NANOSECONDS.timedWait(this, nanos);
                    if (!this.waiting) {
                        return true;
                    }
                    nanos = deadline - Utils.nanoTime();
                    if (nanos <= 0L) {
                        this.waiting = false;
                        return false;
                    }
                    continue;
                    break;
                }
            }
            catch (InterruptedException ex) {
                if (this.waiting) {
                    this.waiting = false;
                    throw ex;
                }
                Thread.currentThread().interrupt();
                return true;
            }
        }

        public synchronized void doWait(QueuedSync sync) throws InterruptedException {
            if (!sync.recheck(this)) {
                try {
                    while (this.waiting) {
                        this.wait();
                    }
                }
                catch (InterruptedException ex) {
                    if (this.waiting) {
                        this.waiting = false;
                        throw ex;
                    }
                    Thread.currentThread().interrupt();
                    return;
                }
            }
        }

        private final /* synthetic */ void this() {
            this.waiting = true;
            this.next = null;
        }

        public WaitNode() {
            this.this();
            this.owner = Thread.currentThread();
        }
    }
}

