/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.backport.java.util.concurrent.atomic;

import edu.emory.mathcs.backport.java.util.concurrent.atomic.AtomicReference;

public class AtomicStampedReference {
    private final AtomicReference atomicRef;

    public Object getReference() {
        return this.getPair().reference;
    }

    public int getStamp() {
        return this.getPair().integer;
    }

    public Object get(int[] stampHolder) {
        ReferenceIntegerPair p = this.getPair();
        stampHolder[0] = p.integer;
        return p.reference;
    }

    public boolean weakCompareAndSet(Object expectedReference, Object newReference, int expectedStamp, int newStamp) {
        ReferenceIntegerPair current = this.getPair();
        boolean bl = false;
        if (expectedReference == current.reference && expectedStamp == current.integer && (newReference == current.reference && newStamp == current.integer || this.atomicRef.weakCompareAndSet(current, new ReferenceIntegerPair(newReference, newStamp)))) {
            bl = true;
        }
        return bl;
    }

    public boolean compareAndSet(Object expectedReference, Object newReference, int expectedStamp, int newStamp) {
        ReferenceIntegerPair current = this.getPair();
        boolean bl = false;
        if (expectedReference == current.reference && expectedStamp == current.integer && (newReference == current.reference && newStamp == current.integer || this.atomicRef.compareAndSet(current, new ReferenceIntegerPair(newReference, newStamp)))) {
            bl = true;
        }
        return bl;
    }

    public void set(Object newReference, int newStamp) {
        ReferenceIntegerPair current = this.getPair();
        if (newReference != current.reference || newStamp != current.integer) {
            this.atomicRef.set(new ReferenceIntegerPair(newReference, newStamp));
        }
    }

    public boolean attemptStamp(Object expectedReference, int newStamp) {
        ReferenceIntegerPair current = this.getPair();
        boolean bl = false;
        if (expectedReference == current.reference && (newStamp == current.integer || this.atomicRef.compareAndSet(current, new ReferenceIntegerPair(expectedReference, newStamp)))) {
            bl = true;
        }
        return bl;
    }

    private final ReferenceIntegerPair getPair() {
        return (ReferenceIntegerPair)this.atomicRef.get();
    }

    public AtomicStampedReference(Object initialRef, int initialStamp) {
        this.atomicRef = new AtomicReference(new ReferenceIntegerPair(initialRef, initialStamp));
    }

    private static class ReferenceIntegerPair {
        private final Object reference;
        private final int integer;

        ReferenceIntegerPair(Object r, int i) {
            this.reference = r;
            this.integer = i;
        }
    }
}

